import os, sys, glob

def main():
    scratch_dir = "/scratch/ssd004/scratch/calvinyu/"
    git_dir = os.path.join(scratch_dir, "git_merge/")
    assert os.path.exists(git_dir), f"{git_dir} does not exist"
    exit_code = 0
    
    # delete .git and .gitattributes
    cmd = f"cd {git_dir} && rm -rf .git .gitattributes"
    print(f"\n COMMAND: {cmd} \n")
    exit_code =  os.system(cmd)
    if exit_code > 0: return exit_code

    # # delete calvinyu/dot-git and scratch/lfs-objects
    cmd = f"rm -rf ~/dot-git && cd {scratch_dir} && rm -rf lfs-objects"
    print(f"\n COMMAND: {cmd} \n")
    exit_code =  os.system(cmd)
    if exit_code > 0: return exit_code

    # move stats from yashkant to calvinyu/git_merge
    cmd = f"cd {git_dir} && find . -type l -delete "
    if os.path.exists("/scratch/ssd004/scratch/yashkant/stats/")\
         and not os.path.exists(os.path.join(git_dir, "stats")):    
        cmd += "&& mv /scratch/ssd004/scratch/yashkant/stats/ ./"
    print(f"\n COMMAND: {cmd} \n")
    exit_code =  os.system(cmd)

    # git init move dot-git to home and soft link 
    cmd = f"cd {git_dir} && git init && mv .git ~/dot-git && ln -s ~/dot-git .git"
    print(f"\n COMMAND: {cmd} \n")
    exit_code =  os.system(cmd)
    if exit_code > 0: return exit_code

    # run commit_merge_seq.py
    cmd = f"cd ~/evalmerge && sleep 2 && python scripts/commit_merge_seq.py"
    print(f"\n COMMAND: {cmd} \n")
    exit_code =  os.system(cmd)
    if exit_code > 0: return exit_code
    
    # # move stats to yashkant
    # cmd = f"cd {git_dir} && mv stats/ /scratch/ssd004/scratch/yashkant/ && ln -s /scratch/ssd004/scratch/yashkant/stats/ ./ "
    # print(f"\n COMMAND: {cmd} \n")
    # exit_code =  os.system(cmd)
    # # if exit_code > 0: return exit_code

    # # run merge_models.py and await failure
    # cmd = f"cd ~/evalmerge && python scripts/merge_models_seq.py"
    # print(f"\n COMMAND: {cmd} \n")
    # exit_code =  os.system(cmd)
    # if exit_code > 0: return exit_code

    return 0

if __name__ == "__main__":
    exit_code = 1
    while exit_code > 0:
        exit_code = main()
        print(f"failed with code {exit_code}, sleeping 5, then retrying")
        os.system("sleep 5")
