import os, sys, glob

def main():
    scratch_dir = "/scratch/ssd004/scratch/calvinyu/"
    git_dir = os.path.join(scratch_dir, "git_merge/")
    assert os.path.exists(git_dir), f"{git_dir} does not exist"
    exit_code = 0
    
    # delete .git and .gitattributes
    cmd = f"cd {git_dir} && rm -rf .git .gitattributes"
    print(f"\n COMMAND: {cmd} \n")
    exit_code =  os.system(cmd)
    # if exit_code > 0: return exit_code

    # delete symlinks in merged models and move merged models to yashkant
    cmd = f"cd {git_dir}/merged/all && " \
        "find . -type l -delete && " \
        "mv ./* /scratch/ssd004/scratch/yashkant/merged/all/"
    print(f"\n COMMAND: {cmd} \n")
    exit_code =  os.system(cmd)
    # if exit_code > 0: breakpoint()

    # delete calvinyu/dot-git and scratch/lfs-objects
    cmd = f"rm -rf ~/dot-git && cd {scratch_dir} && rm -rf lfs-objects"
    print(f"\n COMMAND: {cmd} \n")
    exit_code =  os.system(cmd)
    # if exit_code > 0: return exit_code

    # move stats from yashkant to calvinyu/git_merge
    cmd = f"cd {git_dir} && find . -type l -delete "
    if os.path.exists("/scratch/ssd004/scratch/yashkant/stats/")\
         and not os.path.exists(os.path.join(git_dir, "stats")):    
        cmd += "&& mv /scratch/ssd004/scratch/yashkant/stats/ ./"
    print(f"\n COMMAND: {cmd} \n")
    exit_code =  os.system(cmd)

    # git init move dot-git to home and soft link 
    cmd = f"cd {git_dir} && git init && mv .git ~/dot-git && ln -s ~/dot-git .git"
    print(f"\n COMMAND: {cmd} \n")
    exit_code =  os.system(cmd)
    # if exit_code > 0: return exit_code
    sys.exit(0)
    breakpoint()
    
    # run commit_models.py 
    cmd = f"cd ~/evalmerge && sleep 2 && python scripts/commit_models.py"
    print(f"\n COMMAND: {cmd} \n")
    exit_code =  os.system(cmd)
    breakpoint()
    if exit_code > 0: return exit_code

    # move stats to yashkant and soft link merged models (helps to detect which models to skip in merge_models.py)
    cmd = f"cd {git_dir} && mv stats/ /scratch/ssd004/scratch/yashkant/ && ln -s /scratch/ssd004/scratch/yashkant/stats/ ./ && " \
        f"ln -s /scratch/ssd004/scratch/yashkant/merged/all/* {git_dir}/merged/all/"
    print(f"\n COMMAND: {cmd} \n")
    exit_code =  os.system(cmd)
    # if exit_code > 0: return exit_code

    # run merge_models.py and await failure
    cmd = f"cd ~/evalmerge && python scripts/merge_models.py"
    print(f"\n COMMAND: {cmd} \n")
    exit_code =  os.system(cmd)
    return exit_code


if __name__ == "__main__":
    exit_code = 1
    # while exit_code is None or exit_code > 0:
    exit_code = main()
    print(f"failed with code {exit_code}, sleeping 5, then retrying")
    os.system("sleep 5")
