/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.regexp.RegexNERSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class RegexNERAnnotator
implements Annotator {
    private final RegexNERSequenceClassifier classifier;
    private final boolean verbose;
    public static PropertiesUtils.Property[] SUPPORTED_PROPERTIES = new PropertiesUtils.Property[]{new PropertiesUtils.Property("mapping", "edu/stanford/nlp/models/regexner/type_map_clean", "Mapping file to use."), new PropertiesUtils.Property("ignorecase", "false", "Whether to ignore case or not when matching patterns."), new PropertiesUtils.Property("validpospattern", "", "Regular expression pattern for matching POS tags."), new PropertiesUtils.Property("verbose", "false", "")};

    public RegexNERAnnotator(String name, Properties properties) {
        String mapping = properties.getProperty(name + ".mapping", "edu/stanford/nlp/models/regexner/type_map_clean");
        boolean ignoreCase = Boolean.parseBoolean(properties.getProperty(name + ".ignorecase", "false"));
        String validPosPattern = properties.getProperty(name + ".validpospattern", "^(NN|JJ)");
        boolean overwriteMyLabels = true;
        boolean verbose = Boolean.parseBoolean(properties.getProperty(name + ".verbose", "false"));
        this.classifier = new RegexNERSequenceClassifier(mapping, ignoreCase, overwriteMyLabels, validPosPattern);
        this.verbose = verbose;
    }

    public RegexNERAnnotator(String mapping) {
        this(mapping, false);
    }

    public RegexNERAnnotator(String mapping, boolean ignoreCase) {
        this(mapping, ignoreCase, "^(NN|JJ)");
    }

    public RegexNERAnnotator(String mapping, boolean ignoreCase, String validPosPattern) {
        this(mapping, ignoreCase, true, validPosPattern, false);
    }

    public RegexNERAnnotator(String mapping, boolean ignoreCase, boolean overwriteMyLabels, String validPosPattern, boolean verbose) {
        this.classifier = new RegexNERSequenceClassifier(mapping, ignoreCase, overwriteMyLabels, validPosPattern);
        this.verbose = verbose;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.verbose) {
            System.err.print("Adding RegexNER annotations ... ");
        }
        if (!annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            throw new RuntimeException("Unable to find sentences in " + annotation);
        }
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sentence : sentences) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            this.classifier.classify(tokens);
            for (CoreLabel token : tokens) {
                if (token.get(CoreAnnotations.NamedEntityTagAnnotation.class) != null) continue;
                token.set(CoreAnnotations.NamedEntityTagAnnotation.class, this.classifier.flags.backgroundSymbol);
            }
            for (int start = 0; start < tokens.size(); ++start) {
                CoreLabel token;
                token = (CoreLabel)tokens.get(start);
                String answerType = (String)token.get(CoreAnnotations.AnswerAnnotation.class);
                if (answerType == null) continue;
                String NERType = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                int answerEnd = RegexNERAnnotator.findEndOfAnswerAnnotation(tokens, start);
                int NERStart = RegexNERAnnotator.findStartOfNERAnnotation(tokens, start);
                int NEREnd = RegexNERAnnotator.findEndOfNERAnnotation(tokens, start);
                if ((NERStart == start || NERType.equals(this.classifier.flags.backgroundSymbol)) && (answerEnd == NEREnd || NERType.equals(this.classifier.flags.backgroundSymbol) && NEREnd >= answerEnd)) {
                    for (int i = start; i < answerEnd; ++i) {
                        ((CoreLabel)tokens.get(i)).set(CoreAnnotations.NamedEntityTagAnnotation.class, answerType);
                    }
                }
                start = answerEnd - 1;
            }
        }
        if (this.verbose) {
            System.err.println("done.");
        }
    }

    private static int findEndOfAnswerAnnotation(List<CoreLabel> tokens, int start) {
        String type = (String)tokens.get(start).get(CoreAnnotations.AnswerAnnotation.class);
        while (start < tokens.size() && type.equals(tokens.get(start).get(CoreAnnotations.AnswerAnnotation.class))) {
            ++start;
        }
        return start;
    }

    private static int findStartOfNERAnnotation(List<CoreLabel> tokens, int start) {
        String type = (String)tokens.get(start).get(CoreAnnotations.NamedEntityTagAnnotation.class);
        while (start >= 0 && type.equals(tokens.get(start).get(CoreAnnotations.NamedEntityTagAnnotation.class))) {
            --start;
        }
        return start + 1;
    }

    private static int findEndOfNERAnnotation(List<CoreLabel> tokens, int start) {
        String type = (String)tokens.get(start).get(CoreAnnotations.NamedEntityTagAnnotation.class);
        while (start < tokens.size() && type.equals(tokens.get(start).get(CoreAnnotations.NamedEntityTagAnnotation.class))) {
            ++start;
        }
        return start;
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return StanfordCoreNLP.TOKENIZE_SSPLIT_POS;
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.emptySet();
    }
}

