/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.trees.GrammaticalRelation;
import java.io.Serializable;
import java.util.Comparator;

public class SemanticGraphEdge
implements Comparable<SemanticGraphEdge>,
Serializable {
    public static boolean printOnlyRelation = false;
    private GrammaticalRelation relation;
    private double weight;
    private boolean isExtra;
    private final IndexedWord source;
    private final IndexedWord target;
    private static Comparator<SemanticGraphEdge> targetComparator = new SemanticGraphEdgeTargetComparator();
    private static final long serialVersionUID = 2L;

    public SemanticGraphEdge(IndexedWord source, IndexedWord target, GrammaticalRelation relation, double weight, boolean isExtra) {
        this.source = source;
        this.target = target;
        this.relation = relation;
        this.weight = weight;
        this.isExtra = isExtra;
    }

    public SemanticGraphEdge(SemanticGraphEdge e) {
        this(e.getSource(), e.getTarget(), e.getRelation(), e.getWeight(), e.isExtra());
    }

    public String toString() {
        if (!printOnlyRelation) {
            return this.getSource() + " -> " + this.getTarget() + " (" + this.getRelation() + ")";
        }
        return this.getRelation().toString();
    }

    public GrammaticalRelation getRelation() {
        return this.relation;
    }

    public void setRelation(GrammaticalRelation relation) {
        this.relation = relation;
    }

    public IndexedWord getSource() {
        return this.source;
    }

    public IndexedWord getGovernor() {
        return this.getSource();
    }

    public IndexedWord getTarget() {
        return this.target;
    }

    public IndexedWord getDependent() {
        return this.getTarget();
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public boolean isExtra() {
        return this.isExtra;
    }

    public void setIsExtra(boolean isExtra) {
        this.isExtra = isExtra;
    }

    public boolean typeEquals(SemanticGraphEdge e) {
        return this.relation.equals(e.relation);
    }

    public static Comparator<SemanticGraphEdge> orderByTargetComparator() {
        return targetComparator;
    }

    @Override
    public int compareTo(SemanticGraphEdge other) {
        int sourceVal = this.getSource().compareTo(other.getSource());
        if (sourceVal != 0) {
            return sourceVal;
        }
        int targetVal = this.getTarget().compareTo(other.getTarget());
        if (targetVal != 0) {
            return targetVal;
        }
        String thisRelation = this.getRelation().toString();
        String thatRelation = other.getRelation().toString();
        return thisRelation.compareTo(thatRelation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SemanticGraphEdge)) {
            return false;
        }
        SemanticGraphEdge semanticGraphEdge = (SemanticGraphEdge)o;
        if (this.relation != null) {
            boolean retFlag = this.relation.equals(semanticGraphEdge.relation);
            boolean govMatch = this.getGovernor().equals(semanticGraphEdge.getGovernor());
            boolean depMatch = this.getDependent().equals(semanticGraphEdge.getDependent());
            boolean matched = retFlag && govMatch && depMatch;
            return matched;
        }
        return super.equals(o);
    }

    public int hashCode() {
        int result = this.relation != null ? this.relation.hashCode() : 0;
        result = 29 * result + (this.getSource() != null ? this.getSource().hashCode() : 0);
        result = 29 * result + (this.getTarget() != null ? this.getTarget().hashCode() : 0);
        return result;
    }

    private static class SemanticGraphEdgeTargetComparator
    implements Comparator<SemanticGraphEdge> {
        private SemanticGraphEdgeTargetComparator() {
        }

        @Override
        public int compare(SemanticGraphEdge o1, SemanticGraphEdge o2) {
            int targetVal = o1.getTarget().compareTo(o2.getTarget());
            if (targetVal != 0) {
                return targetVal;
            }
            int sourceVal = o1.getSource().compareTo(o2.getSource());
            if (sourceVal != 0) {
                return sourceVal;
            }
            return o1.getRelation().toString().compareTo(o2.getRelation().toString());
        }
    }
}

