/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.server;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.common.ParserGrammar;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.TreeBinarizer;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TypedDependency;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.List;

public class LexicalizedParserServer {
    final int port;
    final ServerSocket serverSocket;
    final ParserGrammar parser;
    final TreeBinarizer binarizer;
    boolean stillRunning = true;
    static final int DEFAULT_PORT = 4466;

    public LexicalizedParserServer(int port, String parserModel) throws IOException {
        this(port, LexicalizedParserServer.loadModel(parserModel, null));
    }

    public LexicalizedParserServer(int port, String parserModel, String taggerModel) throws IOException {
        this(port, LexicalizedParserServer.loadModel(parserModel, taggerModel));
    }

    public LexicalizedParserServer(int port, ParserGrammar parser) throws IOException {
        this.port = port;
        this.serverSocket = new ServerSocket(port);
        this.parser = parser;
        this.binarizer = TreeBinarizer.simpleTreeBinarizer(parser.getTLPParams().headFinder(), parser.treebankLanguagePack());
    }

    private static ParserGrammar loadModel(String parserModel, String taggerModel) {
        ParserGrammar model;
        if (taggerModel == null) {
            model = ParserGrammar.loadModel(parserModel, new String[0]);
        } else {
            model = ParserGrammar.loadModel(parserModel, "-preTag", "-taggerSerializedFile", taggerModel);
            model.loadTagger();
        }
        model.setOptionFlags(model.defaultCoreNLPFlags());
        return model;
    }

    public void listen() throws IOException {
        while (this.stillRunning) {
            Socket clientSocket = null;
            try {
                clientSocket = this.serverSocket.accept();
                System.err.println("Got a connection");
                this.processRequest(clientSocket);
                System.err.println("Goodbye!");
                System.err.println();
            }
            catch (IOException e) {
                clientSocket.close();
                System.err.println(e);
            }
        }
        this.serverSocket.close();
    }

    public void processRequest(Socket clientSocket) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), "utf-8"));
        String line = reader.readLine();
        System.err.println(line);
        if (line == null) {
            return;
        }
        line = line.trim();
        String[] pieces = line.split(" ", 2);
        String[] commandPieces = pieces[0].split(":", 2);
        String command = commandPieces[0];
        String commandArgs = "";
        if (commandPieces.length > 1) {
            commandArgs = commandPieces[1];
        }
        String arg = null;
        if (pieces.length > 1) {
            arg = pieces[1];
        }
        System.err.println("Got the command " + command);
        if (arg != null) {
            System.err.println(" ... with argument " + arg);
        }
        switch (command) {
            case "quit": {
                this.handleQuit();
                break;
            }
            case "parse": {
                this.handleParse(arg, clientSocket.getOutputStream(), commandArgs.equals("binarized"));
                break;
            }
            case "dependencies": {
                this.handleDependencies(arg, clientSocket.getOutputStream(), commandArgs);
                break;
            }
            case "tree": {
                this.handleTree(arg, clientSocket.getOutputStream());
                break;
            }
            case "tokenize": {
                this.handleTokenize(arg, clientSocket.getOutputStream());
                break;
            }
            case "lemma": {
                this.handleLemma(arg, clientSocket.getOutputStream());
            }
        }
        System.err.println("Handled request");
        clientSocket.close();
    }

    public void handleQuit() {
        this.stillRunning = false;
    }

    public void handleTokenize(String arg, OutputStream outStream) throws IOException {
        if (arg == null) {
            return;
        }
        List<? extends HasWord> tokens = this.parser.tokenize(arg);
        OutputStreamWriter osw = new OutputStreamWriter(outStream, "utf-8");
        for (int i = 0; i < tokens.size(); ++i) {
            HasWord word = tokens.get(i);
            if (i > 0) {
                osw.write(" ");
            }
            osw.write(word.toString());
        }
        osw.write("\n");
        osw.flush();
    }

    public void handleLemma(String arg, OutputStream outStream) throws IOException {
        if (arg == null) {
            return;
        }
        List<CoreLabel> tokens = this.parser.lemmatize(arg);
        OutputStreamWriter osw = new OutputStreamWriter(outStream, "utf-8");
        for (int i = 0; i < tokens.size(); ++i) {
            CoreLabel word = tokens.get(i);
            if (i > 0) {
                osw.write(" ");
            }
            osw.write(word.lemma());
        }
        osw.write("\n");
        osw.flush();
    }

    public void handleDependencies(String arg, OutputStream outStream, String commandArgs) throws IOException {
        Tree tree = this.parse(arg, false);
        if (tree == null) {
            return;
        }
        GrammaticalStructure gs = this.parser.getTLPParams().getGrammaticalStructure(tree, this.parser.treebankLanguagePack().punctuationWordRejectFilter(), this.parser.getTLPParams().typedDependencyHeadFinder());
        Collection<TypedDependency> deps = null;
        switch (commandArgs.toUpperCase()) {
            case "COLLAPSED_TREE": {
                deps = gs.typedDependenciesCollapsedTree();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Dependencies type not implemented: " + commandArgs);
            }
        }
        OutputStreamWriter osw = new OutputStreamWriter(outStream, "utf-8");
        for (TypedDependency dep : deps) {
            osw.write(dep.toString());
            osw.write("\n");
        }
        osw.flush();
    }

    public void handleTree(String arg, OutputStream outStream) throws IOException {
        Tree tree = this.parse(arg, false);
        if (tree == null) {
            return;
        }
        System.err.println(tree);
        if (tree != null) {
            ObjectOutputStream oos = new ObjectOutputStream(outStream);
            oos.writeObject(tree);
            oos.flush();
        }
    }

    public void handleParse(String arg, OutputStream outStream, boolean binarized) throws IOException {
        Tree tree = this.parse(arg, binarized);
        if (tree == null) {
            return;
        }
        System.err.println(tree);
        if (tree != null) {
            OutputStreamWriter osw = new OutputStreamWriter(outStream, "utf-8");
            osw.write(tree.toString());
            osw.write("\n");
            osw.flush();
        }
    }

    private Tree parse(String arg, boolean binarized) {
        if (arg == null) {
            return null;
        }
        Tree tree = this.parser.parse(arg);
        if (binarized) {
            tree = this.binarizer.transformTree(tree);
        }
        return tree;
    }

    private static void help() {
        System.err.println("-help:   display this message");
        System.err.println("-model:  load this parser (default englishPCFG.ser.gz)");
        System.err.println("-tagger: pretag with this tagger model");
        System.err.println("-port:   run on this port (default 4466)");
    }

    public static void main(String[] args) throws IOException {
        System.setOut(new PrintStream((OutputStream)System.out, true, "utf-8"));
        System.setErr(new PrintStream((OutputStream)System.err, true, "utf-8"));
        int port = 4466;
        String model = LexicalizedParser.DEFAULT_PARSER_LOC;
        String tagger = null;
        for (int i = 0; i < args.length; i += 2) {
            String arg;
            if (i + 1 >= args.length) {
                System.err.println("Unspecified argument " + args[i]);
                System.exit(2);
            }
            if ((arg = args[i]).startsWith("--")) {
                arg = arg.substring(2);
            } else if (arg.startsWith("-")) {
                arg = arg.substring(1);
            }
            if (arg.equalsIgnoreCase("model")) {
                model = args[i + 1];
                continue;
            }
            if (arg.equalsIgnoreCase("port")) {
                port = Integer.valueOf(args[i + 1]);
                continue;
            }
            if (arg.equalsIgnoreCase("tagger")) {
                tagger = args[i + 1];
                continue;
            }
            if (!arg.equalsIgnoreCase("help")) continue;
            LexicalizedParserServer.help();
            System.exit(0);
        }
        LexicalizedParserServer server = new LexicalizedParserServer(port, model, tagger);
        System.err.println("Server ready!");
        server.listen();
    }
}

