/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.common.ParserUtils;
import edu.stanford.nlp.parser.common.ParsingThreadsafeProcessor;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.metrics.AbstractEval;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class ParseFiles {
    private final TreebankLanguagePack tlp;
    private final PrintWriter pwOut;
    private final PrintWriter pwErr;
    private int numWords = 0;
    private int numSents = 0;
    private int numUnparsable = 0;
    private int numNoMemory = 0;
    private int numFallback = 0;
    private int numSkipped = 0;
    private boolean saidMemMessage = false;
    private final boolean runningAverages;
    private final boolean summary;
    private final AbstractEval.ScoreEval pcfgLL;
    private final AbstractEval.ScoreEval depLL;
    private final AbstractEval.ScoreEval factLL;
    private final Options op;
    private final LexicalizedParser pqFactory;
    private final TreePrint treePrint;

    public static void parseFiles(String[] args, int argIndex, boolean tokenized, TokenizerFactory<? extends HasWord> tokenizerFactory, String elementDelimiter, String sentenceDelimiter, Function<List<HasWord>, List<HasWord>> escaper, String tagDelimiter, Options op, TreePrint treePrint, LexicalizedParser pqFactory) {
        ParseFiles pf = new ParseFiles(op, treePrint, pqFactory);
        pf.parseFiles(args, argIndex, tokenized, tokenizerFactory, elementDelimiter, sentenceDelimiter, escaper, tagDelimiter);
    }

    public ParseFiles(Options op, TreePrint treePrint, LexicalizedParser pqFactory) {
        this.op = op;
        this.pqFactory = pqFactory;
        this.treePrint = treePrint;
        this.tlp = op.tlpParams.treebankLanguagePack();
        this.pwOut = op.tlpParams.pw();
        this.pwErr = op.tlpParams.pw(System.err);
        if (op.testOptions.verbose) {
            this.pwErr.println("Sentence final words are: " + Arrays.asList(this.tlp.sentenceFinalPunctuationWords()));
            this.pwErr.println("File encoding is: " + op.tlpParams.getInputEncoding());
        }
        this.runningAverages = Boolean.parseBoolean(op.testOptions.evals.getProperty("runningAverages"));
        this.summary = Boolean.parseBoolean(op.testOptions.evals.getProperty("summary"));
        this.pcfgLL = Boolean.parseBoolean(op.testOptions.evals.getProperty("pcfgLL")) ? new AbstractEval.ScoreEval("pcfgLL", this.runningAverages) : null;
        this.depLL = Boolean.parseBoolean(op.testOptions.evals.getProperty("depLL")) ? new AbstractEval.ScoreEval("depLL", this.runningAverages) : null;
        this.factLL = Boolean.parseBoolean(op.testOptions.evals.getProperty("factLL")) ? new AbstractEval.ScoreEval("factLL", this.runningAverages) : null;
    }

    public void parseFiles(String[] args, int argIndex, boolean tokenized, TokenizerFactory<? extends HasWord> tokenizerFactory, String elementDelimiter, String sentenceDelimiter, Function<List<HasWord>, List<HasWord>> escaper, String tagDelimiter) {
        DocumentPreprocessor.DocType docType;
        DocumentPreprocessor.DocType docType2 = docType = elementDelimiter == null ? DocumentPreprocessor.DocType.Plain : DocumentPreprocessor.DocType.XML;
        if (this.op.testOptions.verbose && tokenizerFactory != null) {
            this.pwErr.println("parseFiles: Tokenizer factory is: " + tokenizerFactory);
        }
        Timing timer = new Timing();
        timer.start();
        for (int i = argIndex; i < args.length; ++i) {
            int len;
            DocumentPreprocessor documentPreprocessor;
            String filename = args[i];
            if (filename.equals("-")) {
                try {
                    documentPreprocessor = new DocumentPreprocessor(IOUtils.readerFromStdin(this.op.tlpParams.getInputEncoding()), docType);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            } else {
                documentPreprocessor = new DocumentPreprocessor(filename, docType, this.op.tlpParams.getInputEncoding());
            }
            documentPreprocessor.setSentenceFinalPuncWords(this.tlp.sentenceFinalPunctuationWords());
            documentPreprocessor.setEscaper(escaper);
            documentPreprocessor.setSentenceDelimiter(sentenceDelimiter);
            documentPreprocessor.setTagDelimiter(tagDelimiter);
            documentPreprocessor.setElementDelimiter(elementDelimiter);
            if (tokenizerFactory == null) {
                documentPreprocessor.setTokenizerFactory(tokenized ? null : this.tlp.getTokenizerFactory());
            } else {
                documentPreprocessor.setTokenizerFactory(tokenizerFactory);
            }
            PrintWriter pwo = this.pwOut;
            if (this.op.testOptions.writeOutputFiles) {
                String normalizedName = filename;
                try {
                    new URL(normalizedName);
                    normalizedName = normalizedName.replaceAll("/", "_");
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                String ext = this.op.testOptions.outputFilesExtension == null ? "stp" : this.op.testOptions.outputFilesExtension;
                String fname = normalizedName + '.' + ext;
                if (this.op.testOptions.outputFilesDirectory != null && !this.op.testOptions.outputFilesDirectory.equals("")) {
                    String fseparator = System.getProperty("file.separator");
                    if (fseparator == null || fseparator.isEmpty()) {
                        fseparator = "/";
                    }
                    File fnameFile = new File(fname);
                    fname = this.op.testOptions.outputFilesDirectory + fseparator + fnameFile.getName();
                }
                try {
                    pwo = this.op.tlpParams.pw(new FileOutputStream(fname));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            this.treePrint.printHeader(pwo, this.op.tlpParams.getOutputEncoding());
            this.pwErr.println("Parsing file: " + filename);
            int num = 0;
            int numProcessed = 0;
            if (this.op.testOptions.testingThreads != 1) {
                MulticoreWrapper<List<? extends HasWord>, ParserQuery> wrapper = new MulticoreWrapper<List<? extends HasWord>, ParserQuery>(this.op.testOptions.testingThreads, new ParsingThreadsafeProcessor(this.pqFactory, this.pwErr));
                for (List<HasWord> sentence : documentPreprocessor) {
                    ++this.numSents;
                    len = sentence.size();
                    this.numWords += len;
                    this.pwErr.println("Parsing [sent. " + ++num + " len. " + len + "]: " + Sentence.listToString(sentence, true));
                    wrapper.put(sentence);
                    while (wrapper.peek()) {
                        ParserQuery pq = wrapper.poll();
                        this.processResults(pq, numProcessed++, pwo);
                    }
                }
                wrapper.join();
                while (wrapper.peek()) {
                    ParserQuery pq = wrapper.poll();
                    this.processResults(pq, numProcessed++, pwo);
                }
            } else {
                ParserQuery pq = this.pqFactory.parserQuery();
                for (List<HasWord> sentence : documentPreprocessor) {
                    ++this.numSents;
                    len = sentence.size();
                    this.numWords += len;
                    this.pwErr.println("Parsing [sent. " + ++num + " len. " + len + "]: " + Sentence.listToString(sentence, true));
                    pq.parseAndReport(sentence, this.pwErr);
                    this.processResults(pq, numProcessed++, pwo);
                }
            }
            this.treePrint.printFooter(pwo);
            if (this.op.testOptions.writeOutputFiles) {
                pwo.close();
            }
            this.pwErr.println("Parsed file: " + filename + " [" + num + " sentences].");
        }
        long millis = timer.stop();
        if (this.summary) {
            if (this.pcfgLL != null) {
                this.pcfgLL.display(false, this.pwErr);
            }
            if (this.depLL != null) {
                this.depLL.display(false, this.pwErr);
            }
            if (this.factLL != null) {
                this.factLL.display(false, this.pwErr);
            }
        }
        if (this.saidMemMessage) {
            ParserUtils.printOutOfMemory(this.pwErr);
        }
        double wordspersec = (double)this.numWords / ((double)millis / 1000.0);
        double sentspersec = (double)this.numSents / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        this.pwErr.println("Parsed " + this.numWords + " words in " + this.numSents + " sentences (" + nf.format(wordspersec) + " wds/sec; " + nf.format(sentspersec) + " sents/sec).");
        if (this.numFallback > 0) {
            this.pwErr.println("  " + this.numFallback + " sentences were parsed by fallback to PCFG.");
        }
        if (this.numUnparsable > 0 || this.numNoMemory > 0 || this.numSkipped > 0) {
            this.pwErr.println("  " + (this.numUnparsable + this.numNoMemory + this.numSkipped) + " sentences were not parsed:");
            if (this.numUnparsable > 0) {
                this.pwErr.println("    " + this.numUnparsable + " were not parsable with non-zero probability.");
            }
            if (this.numNoMemory > 0) {
                this.pwErr.println("    " + this.numNoMemory + " were skipped because of insufficient memory.");
            }
            if (this.numSkipped > 0) {
                this.pwErr.println("    " + this.numSkipped + " were skipped as length 0 or greater than " + this.op.testOptions.maxLength);
            }
        }
    }

    public void processResults(ParserQuery parserQuery, int num, PrintWriter pwo) {
        if (parserQuery.parseSkipped()) {
            List<? extends HasWord> sentence = parserQuery.originalSentence();
            if (sentence != null) {
                this.numWords -= sentence.size();
            }
            ++this.numSkipped;
        }
        if (parserQuery.parseNoMemory()) {
            ++this.numNoMemory;
        }
        if (parserQuery.parseUnparsable()) {
            ++this.numUnparsable;
        }
        if (parserQuery.parseFallback()) {
            ++this.numFallback;
        }
        this.saidMemMessage = this.saidMemMessage || parserQuery.saidMemMessage();
        Tree ansTree = parserQuery.getBestParse();
        if (ansTree == null) {
            pwo.println("(())");
            return;
        }
        if (this.pcfgLL != null && parserQuery.getPCFGParser() != null) {
            this.pcfgLL.recordScore(parserQuery.getPCFGParser(), this.pwErr);
        }
        if (this.depLL != null && parserQuery.getDependencyParser() != null) {
            this.depLL.recordScore(parserQuery.getDependencyParser(), this.pwErr);
        }
        if (this.factLL != null && parserQuery.getFactoredParser() != null) {
            this.factLL.recordScore(parserQuery.getFactoredParser(), this.pwErr);
        }
        try {
            this.treePrint.printTree(ansTree, Integer.toString(num), pwo);
        }
        catch (RuntimeException re) {
            this.pwErr.println("TreePrint.printTree skipped: out of memory (or other error)");
            re.printStackTrace();
            ++this.numNoMemory;
            try {
                this.treePrint.printTree(null, Integer.toString(num), pwo);
            }
            catch (Exception e) {
                this.pwErr.println("Sentence skipped: out of memory or error calling TreePrint.");
                pwo.println("(())");
                e.printStackTrace();
            }
        }
        if (this.op.testOptions.printPCFGkBest > 0 && parserQuery.getPCFGParser() != null && parserQuery.getPCFGParser().hasParse()) {
            List<ScoredObject<Tree>> trees = parserQuery.getKBestPCFGParses(this.op.testOptions.printPCFGkBest);
            this.treePrint.printTrees(trees, Integer.toString(num), pwo);
        } else if (this.op.testOptions.printFactoredKGood > 0 && parserQuery.getFactoredParser() != null && parserQuery.getFactoredParser().hasParse()) {
            List<ScoredObject<Tree>> trees = parserQuery.getKGoodFactoredParses(this.op.testOptions.printFactoredKGood);
            this.treePrint.printTrees(trees, Integer.toString(num), pwo);
        }
    }
}

