/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.gui;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.ui.TreeJPanel;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ScrollableTreeJPanel
extends TreeJPanel {
    private int fontSize = 12;
    private Color defaultColor = Color.BLACK;
    private Color matchedColor = Color.RED;
    private Color tdiffColor = Color.BLUE;
    private String fontName = "";
    private int style = 0;
    private Dimension preferredSize = null;
    private List<Tree> matchedParts = new ArrayList<Tree>();
    private List<Point2D.Double> matchedPartCoordinates = new ArrayList<Point2D.Double>();
    private int leafCtr = 0;
    private double yieldHeight;
    private float[] yieldOffsets;
    private Set<Constituent> diffConstituents = Generics.newHashSet();

    public ScrollableTreeJPanel() {
    }

    public ScrollableTreeJPanel(int i, int j) {
        super(i, j);
    }

    @Override
    public void paintComponent(Graphics g) {
        double height;
        Font font;
        this.superPaint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if ("".equals(this.fontName)) {
            font = g2.getFont();
            this.fontName = font.getName();
            this.style = font.getStyle();
        }
        if (this.tree != null) {
            this.yieldOffsets = new float[this.tree.yield().size()];
        }
        font = new Font(this.fontName, this.style, this.fontSize);
        g2.setFont(font);
        FontMetrics fM = g2.getFontMetrics();
        Dimension space = this.getSize();
        double width = ScrollableTreeJPanel.width(this.tree, fM);
        this.yieldHeight = height = ScrollableTreeJPanel.height(this.tree, fM);
        double startX = 0.0;
        double startY = 0.0;
        if (this.HORIZONTAL_ALIGN == 0) {
            startX = (space.getWidth() - width) / 2.0;
        }
        if (this.HORIZONTAL_ALIGN == 4) {
            startX = space.getWidth() - width;
        }
        if (this.VERTICAL_ALIGN == 0) {
            startY = (space.getHeight() - height) / 2.0;
        }
        if (this.VERTICAL_ALIGN == 3) {
            startY = space.getHeight() - height;
        }
        this.leafCtr = 0;
        if (this.matchedParts != null && this.matchedParts.contains(this.tree)) {
            this.paintTree(this.tree, new Point2D.Double(startX, startY), g2, fM, this.matchedColor);
        } else {
            this.paintTree(this.tree, new Point2D.Double(startX, startY), g2, fM, this.defaultColor);
            this.renderRows(g2, fM, this.defaultColor);
        }
    }

    private void renderRows(Graphics2D g2, FontMetrics fM, Color defaultColor2) {
        double nodeHeight = fM.getHeight();
        double layerMultiplier = 2.5;
        double layerHeight = nodeHeight * layerMultiplier;
        ArrayList sentence = this.tree.yieldHasWord();
        for (int i = 0; i < sentence.size(); ++i) {
            g2.drawString(((HasWord)sentence.get(i)).word(), this.yieldOffsets[i], (float)(this.yieldHeight + layerHeight));
        }
        float rowOrigin = (float)(this.yieldHeight + 2.0 * layerHeight);
        ArrayList rows = new ArrayList();
        block3: for (Constituent c : this.diffConstituents) {
            for (int rowIdx = 0; rowIdx < this.diffConstituents.size(); ++rowIdx) {
                int ext;
                float rowHeight = rowOrigin + (float)((double)rowIdx * layerHeight);
                int n = ext = c.end() == this.yieldOffsets.length - 1 ? 0 : 1;
                if (rowIdx >= rows.size()) {
                    rows.add(new ArrayList());
                    ((List)rows.get(rowIdx)).add(new IntPair(c.start(), c.end()));
                    double nodeWidth = fM.stringWidth(c.value());
                    g2.drawString(c.value(), this.yieldOffsets[c.start()], rowHeight);
                    try {
                        g2.drawLine((int)((double)this.yieldOffsets[c.start()] + nodeWidth) + 10, (int)rowHeight, (int)this.yieldOffsets[c.end() + ext] - 15, (int)rowHeight);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {}
                    continue block3;
                }
                boolean foundOverlap = false;
                for (IntPair span : (List)rows.get(rowIdx)) {
                    if (!ScrollableTreeJPanel.doesOverlap(c, span)) continue;
                    foundOverlap = true;
                    break;
                }
                if (foundOverlap) continue;
                ((List)rows.get(rowIdx)).add(new IntPair(c.start(), c.end()));
                double nodeWidth = fM.stringWidth(c.value());
                g2.drawString(c.value(), this.yieldOffsets[c.start()], rowHeight);
                g2.drawLine((int)((double)this.yieldOffsets[c.start()] + nodeWidth) + 10, (int)rowHeight, (int)this.yieldOffsets[c.end() + ext] - 15, (int)rowHeight);
                continue block3;
            }
        }
    }

    private static boolean doesOverlap(Constituent c, IntPair p) {
        if (p.getSource() <= c.start() && p.getTarget() >= c.start()) {
            return true;
        }
        if (p.getSource() >= c.start() && p.getTarget() <= c.end()) {
            return true;
        }
        return p.getSource() <= c.end() && p.getTarget() >= c.end();
    }

    protected double paintTree(Tree t, Point2D start, Graphics2D g2, FontMetrics fM, Color paintColor) {
        if (t == null) {
            return 0.0;
        }
        String nodeStr = ScrollableTreeJPanel.nodeToString(t);
        double nodeWidth = fM.stringWidth(nodeStr);
        double nodeHeight = fM.getHeight();
        double nodeAscent = fM.getAscent();
        TreeJPanel.WidthResult wr = ScrollableTreeJPanel.widthResult(t, fM);
        double treeWidth = wr.width;
        double nodeTab = wr.nodeTab;
        double childTab = wr.childTab;
        double nodeCenter = wr.nodeCenter;
        Color curColor = g2.getColor();
        g2.setColor(paintColor);
        g2.drawString(nodeStr, (float)(nodeTab + start.getX()), (float)(start.getY() + nodeAscent));
        g2.setColor(curColor);
        double layerMultiplier = 2.5;
        double layerHeight = nodeHeight * layerMultiplier;
        if (t.isLeaf()) {
            this.yieldOffsets[this.leafCtr++] = (float)(nodeTab + start.getX());
            return nodeWidth;
        }
        double childStartX = start.getX() + childTab;
        double childStartY = start.getY() + layerHeight;
        double lineStartX = start.getX() + nodeCenter;
        double lineStartY = start.getY() + nodeHeight * 1.075;
        double lineEndY = lineStartY + nodeHeight * 1.35;
        for (int i = 0; i < t.children().length; ++i) {
            double cWidth;
            Tree child = t.children()[i];
            if (this.matchedParts != null && this.matchedParts.contains(child)) {
                Point2D.Double coord = new Point2D.Double(childStartX, childStartY);
                this.matchedPartCoordinates.add(coord);
                cWidth = this.paintTree(child, coord, g2, fM, this.matchedColor);
            } else {
                Color col = this.defaultColor;
                if (((CoreLabel)child.label()).has(CoreAnnotations.DoAnnotation.class)) {
                    col = (Boolean)((CoreLabel)child.label()).get(CoreAnnotations.DoAnnotation.class) != false ? this.tdiffColor : this.defaultColor;
                }
                cWidth = this.paintTree(child, new Point2D.Double(childStartX, childStartY), g2, fM, col);
            }
            wr = ScrollableTreeJPanel.widthResult(child, fM);
            double lineEndX = childStartX + wr.nodeCenter;
            g2.draw(new Line2D.Double(lineStartX, lineStartY, lineEndX, lineEndY));
            childStartX += cWidth;
            if (i >= t.children().length - 1) continue;
            childStartX += 2.5 * (double)fM.stringWidth(" ");
        }
        return treeWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        if (this.tree == null) {
            return super.getSize();
        }
        FontMetrics fM = this.getFontMetrics(new Font(this.fontName, this.style, this.fontSize));
        double nodeHeight = fM.getHeight();
        double layerMultiplier = 2.5;
        double layerHeight = nodeHeight * layerMultiplier;
        double layerBuffer = (double)(this.diffConstituents.size() + 1) * layerHeight;
        this.preferredSize = new Dimension((int)ScrollableTreeJPanel.width(this.tree, fM), (int)(ScrollableTreeJPanel.height(this.tree, fM) + (layerBuffer += 20.0)));
        return this.preferredSize;
    }

    public List<Tree> getMatchedParts() {
        return this.matchedParts;
    }

    public void setMatchedParts(List<Tree> matchedParts) {
        this.matchedParts = matchedParts;
    }

    public List<Point2D.Double> getMatchedPartCoordinates() {
        return this.matchedPartCoordinates;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.preferredSize = null;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    public Color getMatchedColor() {
        return this.matchedColor;
    }

    public void setMatchedColor(Color matchedColor) {
        this.matchedColor = matchedColor;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setDiffConstituents(Set<Constituent> diffConstituents) {
        this.diffConstituents = diffConstituents;
    }
}

