/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.hcoref.CorefCoreAnnotations;
import edu.stanford.nlp.hcoref.CorefProperties;
import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.hcoref.md.CorefMentionFinder;
import edu.stanford.nlp.hcoref.md.DependencyCorefMentionFinder;
import edu.stanford.nlp.hcoref.md.HybridCorefMentionFinder;
import edu.stanford.nlp.hcoref.md.RuleBasedCorefMentionFinder;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.TextAnnotationCreator;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.ChineseSemanticHeadFinder;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class MentionAnnotator
extends TextAnnotationCreator
implements Annotator {
    HeadFinder headFinder;
    CorefMentionFinder md;
    String mdName;
    Dictionaries dictionaries;
    Properties corefProperties;
    Set<Annotator.Requirement> mentionAnnotatorRequirements;

    public MentionAnnotator(Properties props) {
        try {
            this.corefProperties = props;
            this.dictionaries = new Dictionaries(props);
            this.headFinder = MentionAnnotator.getHeadFinder(props);
            this.md = this.getMentionFinder(props, this.headFinder);
            System.err.println("Using mention detector type: " + this.mdName);
            this.mentionAnnotatorRequirements.addAll((Collection<Annotator.Requirement>)Annotator.REQUIREMENTS.get("mention"));
        }
        catch (Exception e) {
            System.err.println("Error with building coref mention annotator!");
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        String docID = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
        if (docID == null) {
            docID = "";
        }
        if (docID.contains("nw") && this.corefProperties.getProperty("coref.input.type", "raw").equals("conll") && this.corefProperties.getProperty("coref.language", "en").equals("zh") && PropertiesUtils.getBool(this.corefProperties, "coref.specialCaseNewswire")) {
            CorefProperties.setRemoveNested(this.corefProperties, false);
        } else {
            CorefProperties.setRemoveNested(this.corefProperties, true);
        }
        List<List<Mention>> mentions = this.md.findMentions(annotation, this.dictionaries, this.corefProperties);
        int mentionIndex = 0;
        int currIndex = 0;
        for (CoreMap sentence : sentences) {
            List<Mention> mentionsForThisSentence = mentions.get(currIndex);
            sentence.set(CorefCoreAnnotations.CorefMentionsAnnotation.class, mentionsForThisSentence);
            ++currIndex;
            for (Mention m : mentionsForThisSentence) {
                m.mentionID = mentionIndex++;
            }
        }
    }

    private static HeadFinder getHeadFinder(Properties props) {
        Locale lang = CorefProperties.getLanguage(props);
        if (lang == Locale.ENGLISH) {
            return new SemanticHeadFinder();
        }
        if (lang == Locale.CHINESE) {
            return new ChineseSemanticHeadFinder();
        }
        throw new RuntimeException("Invalid language setting: cannot load HeadFinder");
    }

    private CorefMentionFinder getMentionFinder(Properties props, HeadFinder headFinder) throws ClassNotFoundException, IOException {
        switch (CorefProperties.getMDType(props)) {
            case DEPENDENCY: {
                this.mentionAnnotatorRequirements = new ArraySet<Annotator.Requirement>(DEPENDENCY_REQUIREMENT);
                this.mdName = "dependency";
                return new DependencyCorefMentionFinder(props);
            }
            case HYBRID: {
                this.mdName = "hybrid";
                this.mentionAnnotatorRequirements = new ArraySet<Annotator.Requirement>(DEPENDENCY_REQUIREMENT, PARSE_REQUIREMENT);
                return new HybridCorefMentionFinder(headFinder, props);
            }
        }
        this.mdName = "rule";
        this.mentionAnnotatorRequirements = new ArraySet<Annotator.Requirement>(DEPENDENCY_REQUIREMENT, PARSE_REQUIREMENT);
        return new RuleBasedCorefMentionFinder(headFinder, props);
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return this.mentionAnnotatorRequirements;
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(MENTION_REQUIREMENT);
    }
}

