/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.Pattern;
import edu.stanford.nlp.util.Execution;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;

public abstract class SentenceIndex<E extends Pattern> {
    Set<String> stopWords;
    int numAllSentences = 0;
    Function<CoreLabel, Map<String, String>> transformCoreLabeltoString;

    public SentenceIndex(Set<String> stopWords, Function<CoreLabel, Map<String, String>> transformCoreLabeltoString) {
        this.stopWords = stopWords;
        this.transformCoreLabeltoString = transformCoreLabeltoString;
    }

    public int size() {
        return this.numAllSentences;
    }

    public abstract void add(Map<String, DataInstance> var1, boolean var2);

    public static SentenceIndex createIndex(Class<? extends SentenceIndex> indexClass, Map<String, List<CoreLabel>> sents, Properties props, Set<String> stopWords, String indexDirectory, Function<CoreLabel, Map<String, String>> transformCoreLabeltoString) {
        try {
            Execution.fillOptions(SentenceIndex.class, props);
            Method m = indexClass.getMethod("createIndex", Map.class, Properties.class, Set.class, String.class, Function.class);
            SentenceIndex index = (SentenceIndex)m.invoke(null, sents, props, stopWords, indexDirectory, transformCoreLabeltoString);
            return index;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract Map<E, Set<String>> queryIndex(Collection<E> var1);

    public void setUp(Properties props) {
        Execution.fillOptions((Object)this, props);
    }

    protected abstract void add(List<CoreLabel> var1, String var2, boolean var3);

    public abstract void finishUpdating();

    public abstract void update(List<CoreLabel> var1, String var2);

    public abstract void saveIndex(String var1);

    public static SentenceIndex loadIndex(Class<? extends SentenceIndex> indexClass, Properties props, Set<String> stopWords, String indexDirectory, Function<CoreLabel, Map<String, String>> transformCoreLabeltoString) {
        try {
            Execution.fillOptions(SentenceIndex.class, props);
            Method m = indexClass.getMethod("loadIndex", Properties.class, Set.class, String.class, Function.class);
            SentenceIndex index = (SentenceIndex)m.invoke(null, props, stopWords, indexDirectory, transformCoreLabeltoString);
            return index;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

