/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.naturalli.Util;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Quadruple;
import edu.stanford.nlp.util.Triple;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class NaturalLogicWeights {
    private final Map<Pair<String, String>, Double> verbPPAffinity = new HashMap<Pair<String, String>, Double>();
    private final Map<Triple<String, String, String>, Double> verbSubjPPAffinity = new HashMap<Triple<String, String, String>, Double>();
    private final Map<Quadruple<String, String, String, String>, Double> verbSubjObjPPAffinity = new HashMap<Quadruple<String, String, String, String>, Double>();
    private final Map<Quadruple<String, String, String, String>, Double> verbSubjPPPPAffinity = new HashMap<Quadruple<String, String, String, String>, Double>();
    private final Map<Quadruple<String, String, String, String>, Double> verbSubjPPObjAffinity = new HashMap<Quadruple<String, String, String, String>, Double>();
    private final Map<String, Double> verbObjAffinity = new HashMap<String, Double>();
    private final double upperProbabilityCap;

    public NaturalLogicWeights() {
        this.upperProbabilityCap = 1.0;
    }

    public NaturalLogicWeights(double upperProbabilityCap) {
        this.upperProbabilityCap = upperProbabilityCap;
    }

    public NaturalLogicWeights(String affinityModels, double upperProbabilityCap) throws IOException {
        String line;
        this.upperProbabilityCap = upperProbabilityCap;
        BufferedReader ppReader = IOUtils.readerFromString(affinityModels + "/pp.tab.gz", "utf8");
        while ((line = ppReader.readLine()) != null) {
            String[] fields = line.split("\t");
            Pair<String, String> key = Pair.makePair(fields[0].intern(), fields[1].intern());
            this.verbPPAffinity.put(key, Double.parseDouble(fields[2]));
        }
        ppReader.close();
        BufferedReader subjPPReader = IOUtils.readerFromString(affinityModels + "/subj_pp.tab.gz", "utf8");
        while ((line = subjPPReader.readLine()) != null) {
            String[] fields = line.split("\t");
            Triple<String, String, String> key = Triple.makeTriple(fields[0].intern(), fields[1].intern(), fields[2].intern());
            this.verbSubjPPAffinity.put(key, Double.parseDouble(fields[3]));
        }
        subjPPReader.close();
        BufferedReader subjObjPPReader = IOUtils.readerFromString(affinityModels + "/subj_obj_pp.tab.gz", "utf8");
        while ((line = subjObjPPReader.readLine()) != null) {
            String[] fields = line.split("\t");
            Quadruple<String, String, String, String> key = Quadruple.makeQuadruple(fields[0].intern(), fields[1].intern(), fields[2].intern(), fields[3].intern());
            this.verbSubjObjPPAffinity.put(key, Double.parseDouble(fields[4]));
        }
        subjObjPPReader.close();
        BufferedReader subjPPPPReader = IOUtils.readerFromString(affinityModels + "/subj_pp_pp.tab.gz", "utf8");
        while ((line = subjPPPPReader.readLine()) != null) {
            String[] fields = line.split("\t");
            Quadruple<String, String, String, String> key = Quadruple.makeQuadruple(fields[0].intern(), fields[1].intern(), fields[2].intern(), fields[3].intern());
            this.verbSubjPPPPAffinity.put(key, Double.parseDouble(fields[4]));
        }
        subjPPPPReader.close();
        BufferedReader subjPPObjReader = IOUtils.readerFromString(affinityModels + "/subj_pp_obj.tab.gz", "utf8");
        while ((line = subjPPObjReader.readLine()) != null) {
            String[] fields = line.split("\t");
            Quadruple<String, String, String, String> key = Quadruple.makeQuadruple(fields[0].intern(), fields[1].intern(), fields[2].intern(), fields[3].intern());
            this.verbSubjPPObjAffinity.put(key, Double.parseDouble(fields[4]));
        }
        subjPPObjReader.close();
        BufferedReader objReader = IOUtils.readerFromString(affinityModels + "/obj.tab.gz", "utf8");
        while ((line = objReader.readLine()) != null) {
            String[] fields = line.split("\t");
            this.verbObjAffinity.put(fields[0], Double.parseDouble(fields[1]));
        }
        objReader.close();
    }

    public double deletionProbability(String edgeType) {
        if (edgeType.contains("prep")) {
            return 0.9;
        }
        if (edgeType.contains("obj")) {
            return 0.0;
        }
        return 1.0;
    }

    public double objDeletionProbability(SemanticGraphEdge edge, Iterable<SemanticGraphEdge> neighbors) {
        Optional<Object> subj = Optional.empty();
        Optional<Object> pp = Optional.empty();
        for (SemanticGraphEdge neighbor : neighbors) {
            if (neighbor == edge) continue;
            String neighborRel = neighbor.getRelation().toString();
            if (neighborRel.contains("subj")) {
                subj = Optional.of(neighbor.getDependent().originalText().toLowerCase());
            }
            if (!neighborRel.contains("prep")) continue;
            pp = Optional.of(neighborRel);
        }
        String obj = edge.getDependent().originalText().toLowerCase();
        String verb = edge.getGovernor().originalText().toLowerCase();
        Double rawScore = null;
        if (subj.isPresent() && pp.isPresent()) {
            rawScore = this.verbSubjPPObjAffinity.get(Quadruple.makeQuadruple(verb, subj.get(), pp.get(), obj));
        }
        if (rawScore == null) {
            rawScore = this.verbObjAffinity.get(verb);
        }
        if (rawScore == null) {
            return this.deletionProbability(edge.getRelation().toString());
        }
        return 1.0 - Math.min(1.0, rawScore / this.upperProbabilityCap);
    }

    public double ppDeletionProbability(SemanticGraphEdge edge, Iterable<SemanticGraphEdge> neighbors) {
        Optional<Object> subj = Optional.empty();
        Optional<Object> obj = Optional.empty();
        Optional<Object> pp = Optional.empty();
        for (SemanticGraphEdge neighbor : neighbors) {
            if (neighbor == edge) continue;
            String neighborRel = neighbor.getRelation().toString();
            if (neighborRel.contains("subj")) {
                subj = Optional.of(neighbor.getDependent().originalText().toLowerCase());
            }
            if (neighborRel.contains("obj")) {
                obj = Optional.of(neighbor.getDependent().originalText().toLowerCase());
            }
            if (!neighborRel.contains("prep")) continue;
            pp = Optional.of(neighborRel);
        }
        String prep = edge.getRelation().toString();
        String verb = edge.getGovernor().originalText().toLowerCase();
        Double rawScore = null;
        if (subj.isPresent()) {
            if (obj.isPresent()) {
                rawScore = this.verbSubjObjPPAffinity.get(Quadruple.makeQuadruple(verb, subj.get(), obj.get(), prep));
            }
            if (rawScore == null && pp.isPresent()) {
                rawScore = this.verbSubjPPPPAffinity.get(Quadruple.makeQuadruple(verb, subj.get(), pp.get(), prep));
            }
            if (rawScore == null) {
                rawScore = this.verbSubjPPAffinity.get(Triple.makeTriple(verb, subj.get(), prep));
            }
        }
        if (rawScore == null) {
            rawScore = this.verbPPAffinity.get(Pair.makePair(verb, prep));
        }
        if (rawScore == null) {
            return this.deletionProbability(prep);
        }
        return 1.0 - Math.min(1.0, rawScore / this.upperProbabilityCap);
    }

    public double deletionProbability(SemanticGraphEdge edge, Iterable<SemanticGraphEdge> neighbors) {
        String edgeRel = edge.getRelation().toString();
        if (edgeRel.contains("prep")) {
            return this.ppDeletionProbability(edge, neighbors);
        }
        if (edgeRel.contains("obj")) {
            return this.objDeletionProbability(edge, neighbors);
        }
        if (edgeRel.equals("amod")) {
            String word = (edge.getDependent().lemma() != null ? edge.getDependent().lemma() : edge.getDependent().word()).toLowerCase();
            if (Util.PRIVATIVE_ADJECTIVES.contains(word)) {
                return 0.0;
            }
            return 1.0;
        }
        return this.deletionProbability(edgeRel);
    }

    public static NaturalLogicWeights fromString(String str) {
        return new NaturalLogicWeights();
    }
}

