/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.hcoref.data;

import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.math.NumberMatchingRegex;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class SpeakerInfo
implements Serializable {
    private static final long serialVersionUID = 7776098967746458031L;
    private String speakerId;
    private String speakerName;
    private String[] speakerNameStrings;
    private String speakerDesc;
    private Set<Mention> mentions = new LinkedHashSet<Mention>();
    private boolean speakerIdIsNumber;
    private boolean speakerIdIsAutoDetermined;
    private static final Pattern DEFAULT_SPEAKER_PATTERN = Pattern.compile("PER\\d+");
    public static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+|_+");

    public SpeakerInfo(String speakerName) {
        this.speakerId = speakerName;
        int commaPos = speakerName.indexOf(44);
        if (commaPos > 0) {
            this.speakerName = speakerName.substring(0, commaPos);
            if (commaPos < speakerName.length()) {
                this.speakerDesc = speakerName.substring(commaPos + 1);
                this.speakerDesc = this.speakerDesc.trim();
                if (this.speakerDesc.isEmpty()) {
                    this.speakerDesc = null;
                }
            }
        } else {
            this.speakerName = speakerName;
        }
        this.speakerNameStrings = WHITESPACE_PATTERN.split(this.speakerName);
        this.speakerIdIsNumber = NumberMatchingRegex.isDecimalInteger(this.speakerId);
        this.speakerIdIsAutoDetermined = DEFAULT_SPEAKER_PATTERN.matcher(this.speakerId).matches();
    }

    public boolean hasRealSpeakerName() {
        return this.mentions.size() > 0 || !this.speakerIdIsAutoDetermined && !this.speakerIdIsNumber;
    }

    public String getSpeakerName() {
        return this.speakerName;
    }

    public String getSpeakerDesc() {
        return this.speakerDesc;
    }

    public String[] getSpeakerNameStrings() {
        return this.speakerNameStrings;
    }

    public Set<Mention> getMentions() {
        return this.mentions;
    }

    public boolean containsMention(Mention m) {
        return this.mentions.contains(m);
    }

    public void addMention(Mention m) {
        if (this.mentions.isEmpty() && m.mentionType == Dictionaries.MentionType.PROPER) {
            String mentionName = m.spanToString();
            if (this.speakerIdIsNumber || this.speakerIdIsAutoDetermined) {
                String nerName = m.nerName();
                this.speakerName = nerName != null ? nerName : mentionName;
                this.speakerNameStrings = WHITESPACE_PATTERN.split(this.speakerName);
            }
        }
        this.mentions.add(m);
    }

    public int getCorefClusterId() {
        int corefClusterId = -1;
        for (Mention m : this.mentions) {
            if (m.corefClusterID < 0) continue;
            corefClusterId = m.corefClusterID;
            break;
        }
        return corefClusterId;
    }

    public String toString() {
        return this.speakerId;
    }
}

