/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.util.Arrays;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.ASReq;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KDCReqBody;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.PAEncTSEnc;
import sun.security.krb5.internal.crypto.Nonce;

public class KrbAsReq {
    private ASReq asReqMessg;
    private boolean DEBUG = Krb5.DEBUG;

    public KrbAsReq(EncryptionKey encryptionKey, KDCOptions kDCOptions, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, PAData[] pADataArray) throws KrbException, IOException {
        Object object;
        if (kDCOptions == null) {
            kDCOptions = new KDCOptions();
        }
        if (kDCOptions.get(2) || kDCOptions.get(4) || kDCOptions.get(28) || kDCOptions.get(30) || kDCOptions.get(31)) {
            throw new KrbException(101);
        }
        if (!kDCOptions.get(6) && kerberosTime != null) {
            kerberosTime = null;
        }
        if (!kDCOptions.get(8) && kerberosTime3 != null) {
            kerberosTime3 = null;
        }
        PAData[] pADataArray2 = null;
        if (encryptionKey != null) {
            object = new PAEncTSEnc();
            byte[] byArray = ((PAEncTSEnc)object).asn1Encode();
            EncryptedData encryptedData = new EncryptedData(encryptionKey, byArray, 1);
            pADataArray2 = new PAData[]{new PAData(2, encryptedData.asn1Encode())};
        }
        if (pADataArray != null && pADataArray.length > 0) {
            pADataArray2 = pADataArray2 == null ? new PAData[pADataArray.length] : Arrays.copyOf(pADataArray2, pADataArray2.length + pADataArray.length);
            System.arraycopy(pADataArray, 0, pADataArray2, pADataArray2.length - pADataArray.length, pADataArray.length);
        }
        if (principalName.getRealm() == null) {
            throw new RealmException(601, "default realm not specified ");
        }
        if (this.DEBUG) {
            System.out.println(">>> KrbAsReq creating message");
        }
        if (hostAddresses == null && Config.getInstance().useAddresses()) {
            hostAddresses = HostAddresses.getLocalAddresses();
        }
        if (principalName2 == null) {
            object = principalName.getRealmAsString();
            principalName2 = PrincipalName.tgsService((String)object, (String)object);
        }
        if (kerberosTime2 == null) {
            kerberosTime2 = new KerberosTime(0L);
        }
        object = new KDCReqBody(kDCOptions, principalName, principalName2, kerberosTime, kerberosTime2, kerberosTime3, Nonce.value(), nArray, hostAddresses, null, null);
        this.asReqMessg = new ASReq(pADataArray2, (KDCReqBody)object);
    }

    byte[] encoding() throws IOException, Asn1Exception {
        return this.asReqMessg.asn1Encode();
    }

    ASReq getMessage() {
        return this.asReqMessg;
    }
}

