/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.c14n;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizerSpi;
import com.sun.org.apache.xml.internal.security.c14n.ClassLoaderUtils;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.c14n.implementations.Canonicalizer11_OmitComments;
import com.sun.org.apache.xml.internal.security.c14n.implementations.Canonicalizer11_WithComments;
import com.sun.org.apache.xml.internal.security.c14n.implementations.Canonicalizer20010315ExclOmitComments;
import com.sun.org.apache.xml.internal.security.c14n.implementations.Canonicalizer20010315ExclWithComments;
import com.sun.org.apache.xml.internal.security.c14n.implementations.Canonicalizer20010315OmitComments;
import com.sun.org.apache.xml.internal.security.c14n.implementations.Canonicalizer20010315WithComments;
import com.sun.org.apache.xml.internal.security.c14n.implementations.CanonicalizerPhysical;
import com.sun.org.apache.xml.internal.security.exceptions.AlgorithmAlreadyRegisteredException;
import com.sun.org.apache.xml.internal.security.parser.XMLParserException;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Node;

public final class Canonicalizer {
    public static final String ENCODING = StandardCharsets.UTF_8.name();
    public static final String XPATH_C14N_WITH_COMMENTS_SINGLE_NODE = "(.//. | .//@* | .//namespace::*)";
    public static final String ALGO_ID_C14N_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String ALGO_ID_C14N_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String ALGO_ID_C14N_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String ALGO_ID_C14N_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String ALGO_ID_C14N11_OMIT_COMMENTS = "http://www.w3.org/2006/12/xml-c14n11";
    public static final String ALGO_ID_C14N11_WITH_COMMENTS = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
    public static final String ALGO_ID_C14N_PHYSICAL = "http://santuario.apache.org/c14n/physical";
    private static Map<String, Class<? extends CanonicalizerSpi>> canonicalizerHash = new ConcurrentHashMap<String, Class<? extends CanonicalizerSpi>>();
    private final CanonicalizerSpi canonicalizerSpi;

    private Canonicalizer(String string) throws InvalidCanonicalizerException {
        try {
            Class<? extends CanonicalizerSpi> clazz = canonicalizerHash.get(string);
            this.canonicalizerSpi = JavaUtils.newInstanceWithEmptyConstructor(clazz);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidCanonicalizerException(exception, "signature.Canonicalizer.UnknownCanonicalizer", objectArray);
        }
    }

    public static final Canonicalizer getInstance(String string) throws InvalidCanonicalizerException {
        return new Canonicalizer(string);
    }

    public static void register(String string, String string2) throws AlgorithmAlreadyRegisteredException, ClassNotFoundException {
        JavaUtils.checkRegisterPermission();
        Class<? extends CanonicalizerSpi> clazz = canonicalizerHash.get(string);
        if (clazz != null) {
            Object[] objectArray = new Object[]{string, clazz};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        canonicalizerHash.put(string, ClassLoaderUtils.loadClass(string2, Canonicalizer.class));
    }

    public static void register(String string, Class<? extends CanonicalizerSpi> clazz) throws AlgorithmAlreadyRegisteredException, ClassNotFoundException {
        JavaUtils.checkRegisterPermission();
        Class<? extends CanonicalizerSpi> clazz2 = canonicalizerHash.get(string);
        if (clazz2 != null) {
            Object[] objectArray = new Object[]{string, clazz2};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        canonicalizerHash.put(string, clazz);
    }

    public static void registerDefaultAlgorithms() {
        canonicalizerHash.put(ALGO_ID_C14N_OMIT_COMMENTS, Canonicalizer20010315OmitComments.class);
        canonicalizerHash.put(ALGO_ID_C14N_WITH_COMMENTS, Canonicalizer20010315WithComments.class);
        canonicalizerHash.put(ALGO_ID_C14N_EXCL_OMIT_COMMENTS, Canonicalizer20010315ExclOmitComments.class);
        canonicalizerHash.put(ALGO_ID_C14N_EXCL_WITH_COMMENTS, Canonicalizer20010315ExclWithComments.class);
        canonicalizerHash.put(ALGO_ID_C14N11_OMIT_COMMENTS, Canonicalizer11_OmitComments.class);
        canonicalizerHash.put(ALGO_ID_C14N11_WITH_COMMENTS, Canonicalizer11_WithComments.class);
        canonicalizerHash.put(ALGO_ID_C14N_PHYSICAL, CanonicalizerPhysical.class);
    }

    public void canonicalize(byte[] byArray, OutputStream outputStream, boolean bl) throws XMLParserException, IOException, CanonicalizationException {
        this.canonicalizerSpi.engineCanonicalize(byArray, outputStream, bl);
    }

    public void canonicalizeSubtree(Node node, OutputStream outputStream) throws CanonicalizationException {
        this.canonicalizerSpi.engineCanonicalizeSubTree(node, outputStream);
    }

    public void canonicalizeSubtree(Node node, String string, OutputStream outputStream) throws CanonicalizationException {
        this.canonicalizerSpi.engineCanonicalizeSubTree(node, string, outputStream);
    }

    public void canonicalizeSubtree(Node node, String string, boolean bl, OutputStream outputStream) throws CanonicalizationException {
        this.canonicalizerSpi.engineCanonicalizeSubTree(node, string, bl, outputStream);
    }

    public void canonicalizeXPathNodeSet(Set<Node> set, OutputStream outputStream) throws CanonicalizationException {
        this.canonicalizerSpi.engineCanonicalizeXPathNodeSet(set, outputStream);
    }

    public void canonicalizeXPathNodeSet(Set<Node> set, String string, OutputStream outputStream) throws CanonicalizationException {
        this.canonicalizerSpi.engineCanonicalizeXPathNodeSet(set, string, outputStream);
    }
}

