/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.IndexedInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.TypedInstruction;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class LocalVariableInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    private int n = -1;
    private short c_tag = (short)-1;
    private short canon_tag = (short)-1;

    private boolean wide() {
        return this.n > 255;
    }

    LocalVariableInstruction(short canon_tag, short c_tag) {
        this.canon_tag = canon_tag;
        this.c_tag = c_tag;
    }

    LocalVariableInstruction() {
    }

    protected LocalVariableInstruction(short opcode, short c_tag, int n) {
        super(opcode, (short)2);
        this.c_tag = c_tag;
        this.canon_tag = opcode;
        this.setIndex(n);
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        if (this.wide()) {
            out.writeByte(196);
        }
        out.writeByte(super.getOpcode());
        if (super.getLength() > 1) {
            if (this.wide()) {
                out.writeShort(this.n);
            } else {
                out.writeByte(this.n);
            }
        }
    }

    @Override
    public String toString(boolean verbose) {
        short _opcode = super.getOpcode();
        if (_opcode >= 26 && _opcode <= 45 || _opcode >= 59 && _opcode <= 78) {
            return super.toString(verbose);
        }
        return super.toString(verbose) + " " + this.n;
    }

    @Override
    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        if (wide) {
            this.n = bytes.readUnsignedShort();
            super.setLength(4);
        } else {
            short _opcode = super.getOpcode();
            if (_opcode >= 21 && _opcode <= 25 || _opcode >= 54 && _opcode <= 58) {
                this.n = bytes.readUnsignedByte();
                super.setLength(2);
            } else if (_opcode <= 45) {
                this.n = (_opcode - 26) % 4;
                super.setLength(1);
            } else {
                this.n = (_opcode - 59) % 4;
                super.setLength(1);
            }
        }
    }

    @Override
    public final int getIndex() {
        return this.n;
    }

    @Override
    public void setIndex(int n) {
        if (n < 0 || n > 65535) {
            throw new ClassGenException("Illegal value: " + n);
        }
        this.n = n;
        if (n <= 3) {
            super.setOpcode((short)(this.c_tag + n));
            super.setLength(1);
        } else {
            super.setOpcode(this.canon_tag);
            if (this.wide()) {
                super.setLength(4);
            } else {
                super.setLength(2);
            }
        }
    }

    public short getCanonicalTag() {
        return this.canon_tag;
    }

    @Override
    public Type getType(ConstantPoolGen cp) {
        switch (this.canon_tag) {
            case 21: 
            case 54: {
                return Type.INT;
            }
            case 22: 
            case 55: {
                return Type.LONG;
            }
            case 24: 
            case 57: {
                return Type.DOUBLE;
            }
            case 23: 
            case 56: {
                return Type.FLOAT;
            }
            case 25: 
            case 58: {
                return Type.OBJECT;
            }
        }
        throw new ClassGenException("Oops: unknown case in switch" + this.canon_tag);
    }

    final void setIndexOnly(int n) {
        this.n = n;
    }
}

