/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantMethodHandle
extends Constant {
    private int reference_kind;
    private int reference_index;

    public ConstantMethodHandle(ConstantMethodHandle c) {
        this(c.getReferenceKind(), c.getReferenceIndex());
    }

    ConstantMethodHandle(DataInput file) throws IOException {
        this(file.readUnsignedByte(), file.readUnsignedShort());
    }

    public ConstantMethodHandle(int reference_kind, int reference_index) {
        super((byte)15);
        this.reference_kind = reference_kind;
        this.reference_index = reference_index;
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantMethodHandle(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        file.writeByte(super.getTag());
        file.writeByte(this.reference_kind);
        file.writeShort(this.reference_index);
    }

    public int getReferenceKind() {
        return this.reference_kind;
    }

    public void setReferenceKind(int reference_kind) {
        this.reference_kind = reference_kind;
    }

    public int getReferenceIndex() {
        return this.reference_index;
    }

    public void setReferenceIndex(int reference_index) {
        this.reference_index = reference_index;
    }

    @Override
    public String toString() {
        return super.toString() + "(reference_kind = " + this.reference_kind + ", reference_index = " + this.reference_index + ")";
    }
}

