/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.HasCategory;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.EnglishPatterns;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.Generics;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class UniversalSemanticHeadFinder
extends ModCollinsHeadFinder {
    private static final boolean DEBUG = System.getProperty("SemanticHeadFinder", null) != null;
    private static final String[] auxiliaries = new String[]{"will", "wo", "shall", "sha", "may", "might", "should", "would", "can", "could", "ca", "must", "'ll", "ll", "-ll", "cold", "has", "have", "had", "having", "'ve", "ve", "v", "of", "hav", "hvae", "as", "get", "gets", "getting", "got", "gotten", "do", "does", "did", "'d", "d", "du", "to", "2", "na", "a", "ot", "ta", "the", "too"};
    private static final String[] verbTags = new String[]{"TO", "MD", "VB", "VBD", "VBP", "VBZ", "VBG", "VBN", "AUX", "AUXG"};
    private static final String[] unambiguousAuxTags = new String[]{"TO", "MD", "AUX", "AUXG"};
    private final Set<String> verbalAuxiliaries;
    private final Set<String> copulars;
    private final Set<String> passiveAuxiliaries;
    private final Set<String> verbalTags;
    private final Set<String> unambiguousAuxiliaryTags;
    private final boolean makeCopulaHead;
    static final TregexPattern[] headOfCopulaTregex = new TregexPattern[]{TregexPattern.compile("SBARQ < (WHNP $++ (/^VB/ < " + EnglishPatterns.copularWordRegex + " $++ ADJP=head))"), TregexPattern.compile("SBARQ < (WHNP=head $++ (/^VB/ < " + EnglishPatterns.copularWordRegex + " $+ NP !$++ ADJP))"), TregexPattern.compile("SINV < (NP=head $++ (NP $++ (VP < (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + "))))")};
    static final TregexPattern[] headOfConjpTregex = new TregexPattern[]{TregexPattern.compile("CONJP < (CC <: /^(?i:but|and)$/ $+ (RB=head <: /^(?i:not)$/))"), TregexPattern.compile("CONJP < (CC <: /^(?i:but)$/ [ ($+ (RB=head <: /^(?i:also|rather)$/)) | ($+ (ADVP=head <: (RB <: /^(?i:also|rather)$/))) ])"), TregexPattern.compile("CONJP < (CC <: /^(?i:and)$/ [ ($+ (RB=head <: /^(?i:yet)$/)) | ($+ (ADVP=head <: (RB <: /^(?i:yet)$/))) ])")};
    static final TregexPattern noVerbOverTempTregex = TregexPattern.compile("/^VP/ < NP-TMP !< /^V/ !< NNP|NN|NNPS|NNS|NP|JJ|ADJP|S");
    static final Predicate<Tree> REMOVE_TMP_AND_ADV = tree -> {
        if (tree == null) {
            return false;
        }
        Label label = tree.label();
        if (label == null) {
            return false;
        }
        if (label.value().contains("-TMP") || label.value().contains("-ADV")) {
            return false;
        }
        return !label.value().startsWith("VP") || !noVerbOverTempTregex.matcher((Tree)tree).matches();
    };
    private static final long serialVersionUID = 5721799188009249808L;

    public UniversalSemanticHeadFinder() {
        this((TreebankLanguagePack)new PennTreebankLanguagePack(), true);
    }

    public UniversalSemanticHeadFinder(boolean noCopulaHead) {
        this((TreebankLanguagePack)new PennTreebankLanguagePack(), noCopulaHead);
    }

    public UniversalSemanticHeadFinder(TreebankLanguagePack tlp, boolean noCopulaHead) {
        super(tlp);
        this.makeCopulaHead = !noCopulaHead;
        this.ruleChanges();
        this.verbalAuxiliaries = Generics.newHashSet(Arrays.asList(auxiliaries));
        this.passiveAuxiliaries = Generics.newHashSet(Arrays.asList(EnglishPatterns.beGetVerbs));
        this.copulars = Generics.newHashSet();
        if (noCopulaHead) {
            this.copulars.addAll(Arrays.asList(EnglishPatterns.copularVerbs));
        }
        this.verbalTags = Generics.newHashSet(Arrays.asList(verbTags));
        this.unambiguousAuxiliaryTags = Generics.newHashSet(Arrays.asList(unambiguousAuxTags));
    }

    @Override
    public boolean makesCopulaHead() {
        return this.makeCopulaHead;
    }

    private void ruleChanges() {
        this.nonTerminalInfo.put("NP", new String[][]{{"rightdis", "NN", "NNP", "NNPS", "NNS", "NX", "NML", "JJR", "WP"}, {"left", "NP", "PRP"}, {"rightdis", "$", "ADJP", "FW", "CD", "JJ", "QP"}, {"rightdis", "JJS", "DT", "WDT", "NML", "PRN", "RB", "RBR", "ADVP"}, {"left", "POS"}});
        this.nonTerminalInfo.put("NX", this.nonTerminalInfo.get("NP"));
        this.nonTerminalInfo.put("NML", this.nonTerminalInfo.get("NP"));
        this.nonTerminalInfo.put("WHNP", new String[][]{{"rightdis", "NN", "NNP", "NNPS", "NNS", "NX", "NML", "JJR", "WP"}, {"left", "WHNP", "NP"}, {"rightdis", "$", "ADJP", "PRN", "FW"}, {"right", "CD"}, {"rightdis", "JJ", "JJS", "RB", "QP"}, {"left", "WHPP", "WHADJP", "WP$", "WDT"}});
        this.nonTerminalInfo.put("WHADJP", new String[][]{{"left", "ADJP", "JJ", "JJR", "WP"}, {"right", "RB"}, {"right"}});
        this.nonTerminalInfo.put("WHADVP", new String[][]{{"rightdis", "WRB", "WHADVP", "RB", "JJ"}});
        this.nonTerminalInfo.put("QP", new String[][]{{"right", "$", "NNS", "NN", "CD", "JJ", "PDT", "DT", "IN", "RB", "NCD", "QP", "JJR", "JJS"}});
        this.nonTerminalInfo.put("S", new String[][]{{"left", "VP", "S", "FRAG", "SBAR", "ADJP", "UCP", "TO"}, {"right", "NP"}});
        this.nonTerminalInfo.put("SBAR", new String[][]{{"left", "S", "SQ", "SINV", "SBAR", "FRAG", "VP", "WHNP", "WHPP", "WHADVP", "WHADJP", "IN", "DT"}});
        if (this.makeCopulaHead) {
            this.nonTerminalInfo.put("SQ", new String[][]{{"left", "VP", "SQ", "VB", "VBZ", "VBD", "VBP", "MD", "AUX", "AUXG", "ADJP"}});
        } else {
            this.nonTerminalInfo.put("SQ", new String[][]{{"left", "VP", "SQ", "ADJP", "VB", "VBZ", "VBD", "VBP", "MD", "AUX", "AUXG"}});
        }
        this.nonTerminalInfo.put("UCP", new String[][]{{"left"}});
        this.nonTerminalInfo.put("CONJP", new String[][]{{"right", "JJ", "RB"}, {"left", "CC", "IN"}, {"right", "VB"}});
        this.nonTerminalInfo.put("FRAG", new String[][]{{"left", "IN"}, {"right", "RB"}, {"left", "NP"}, {"left", "ADJP", "ADVP", "FRAG", "S", "SBAR", "VP"}});
        this.nonTerminalInfo.put("PRN", new String[][]{{"left", "VP", "SQ", "S", "SINV", "SBAR", "NP", "ADJP", "PP", "ADVP", "INTJ", "WHNP", "NAC", "VBP", "JJ", "NN", "NNP"}});
        this.nonTerminalInfo.put("XS", new String[][]{{"right", "IN"}});
        this.nonTerminalInfo.put("EMBED", new String[][]{{"right", "INTJ"}});
        this.nonTerminalInfo.put("PP", new String[][]{{"left", "NP", "S", "SBAR", "SBARQ", "ADVP", "PP", "VP", "ADJP", "FRAG", "UCP", "PRN"}, {"right"}});
        this.nonTerminalInfo.put("WHPP", this.nonTerminalInfo.get("PP"));
        this.nonTerminalInfo.put("MWE", new String[][]{{"left"}});
        this.nonTerminalInfo.put("PCONJP", new String[][]{{"left"}});
        this.nonTerminalInfo.put("ADJP", new String[][]{{"left", "$"}, {"rightdis", "NNS", "NN", "NNP", "JJ", "QP", "VBN", "VBG"}, {"left", "ADJP"}, {"rightdis", "JJP", "JJR", "JJS", "DT", "RB", "RBR", "CD", "IN", "VBD"}, {"left", "ADVP", "NP"}});
        this.nonTerminalInfo.put("INTJ", new String[][]{{"rightdis", "NNS", "NN", "NNP"}, {"left"}});
        this.nonTerminalInfo.put("ADVP", new String[][]{{"rightdis", "RB", "RBR", "RBS", "JJ", "JJR", "JJS"}, {"rightdis", "RP", "DT", "NN", "CD", "NP", "VBN", "NNP", "CC", "FW", "NNS", "ADJP", "NML"}, {"left"}});
    }

    private boolean shouldSkip(Tree t, boolean origWasInterjection) {
        return t.isPreTerminal() && (this.tlp.isPunctuationTag(t.value()) || !origWasInterjection && "UH".equals(t.value())) || "INTJ".equals(t.value()) && !origWasInterjection;
    }

    private int findPreviousHead(int headIdx, Tree[] daughterTrees, boolean origWasInterjection) {
        boolean seenSeparator = false;
        int newHeadIdx = headIdx;
        while (newHeadIdx >= 0) {
            if (--newHeadIdx < 0) {
                return newHeadIdx;
            }
            String label = this.tlp.basicCategory(daughterTrees[newHeadIdx].value());
            if (",".equals(label) || ":".equals(label)) {
                seenSeparator = true;
                continue;
            }
            if (daughterTrees[newHeadIdx].isPreTerminal() && (this.tlp.isPunctuationTag(label) || !origWasInterjection && "UH".equals(label)) || "INTJ".equals(label) && !origWasInterjection) continue;
            if (seenSeparator) break;
            newHeadIdx = -1;
            break;
        }
        return newHeadIdx;
    }

    @Override
    protected int postOperationFix(int headIdx, Tree[] daughterTrees) {
        String prevLab;
        if (headIdx >= 2 && ((prevLab = this.tlp.basicCategory(daughterTrees[headIdx - 1].value())).equals("CC") || prevLab.equals("CONJP"))) {
            int nextHead;
            int newHeadIdx;
            boolean origWasInterjection = "UH".equals(this.tlp.basicCategory(daughterTrees[headIdx].value()));
            for (newHeadIdx = headIdx - 2; newHeadIdx >= 0 && this.shouldSkip(daughterTrees[newHeadIdx], origWasInterjection); --newHeadIdx) {
            }
            while (newHeadIdx >= 2 && (nextHead = this.findPreviousHead(newHeadIdx, daughterTrees, origWasInterjection)) >= 0) {
                newHeadIdx = nextHead;
            }
            if (newHeadIdx >= 0) {
                headIdx = newHeadIdx;
            }
        }
        return headIdx;
    }

    @Override
    protected Tree determineNonTrivialHead(Tree t, Tree parent) {
        TregexMatcher matcher;
        String motherCat = this.tlp.basicCategory(t.label().value());
        if (DEBUG) {
            System.err.println("At " + motherCat + ", my parent is " + parent);
        }
        if (motherCat.equals("CONJP")) {
            for (TregexPattern pattern : headOfConjpTregex) {
                matcher = pattern.matcher(t);
                if (!matcher.matchesAt(t)) continue;
                return matcher.getNode("head");
            }
        }
        if ((motherCat.equals("SBARQ") || motherCat.equals("SINV")) && !this.makeCopulaHead) {
            for (TregexPattern pattern : headOfCopulaTregex) {
                matcher = pattern.matcher(t);
                if (!matcher.matchesAt(t)) continue;
                return matcher.getNode("head");
            }
        }
        if (motherCat.equals("VP") || motherCat.equals("SQ") || motherCat.equals("SINV")) {
            Tree pti;
            Tree[] kids = t.children();
            if (DEBUG) {
                System.err.println("Semantic head finder: at VP");
                System.err.println("Class is " + t.getClass().getName());
                t.pennPrint(System.err);
            }
            Tree[] tmpFilteredChildren = null;
            if (this.hasVerbalAuxiliary(kids, this.verbalAuxiliaries, true) || this.hasPassiveProgressiveAuxiliary(kids)) {
                String[] how = this.hasVerbalAuxiliary(kids, this.copulars, true) ? new String[]{"left", "VP", "ADJP"} : new String[]{"left", "VP"};
                if (tmpFilteredChildren == null) {
                    tmpFilteredChildren = ArrayUtils.filter(kids, REMOVE_TMP_AND_ADV);
                }
                pti = this.traverseLocate(tmpFilteredChildren, how, false);
                if (DEBUG) {
                    System.err.println("Determined head (case 1) for " + t.value() + " is: " + pti);
                }
                if (pti != null) {
                    return pti;
                }
            }
            if (this.hasVerbalAuxiliary(kids, this.copulars, false) && !this.isExistential(t, parent) && !UniversalSemanticHeadFinder.isWHQ(t, parent)) {
                String[][] how = motherCat.equals("SQ") ? new String[][]{{"right", "VP", "ADJP", "NP", "UCP", "PP", "WHADJP", "WHNP"}} : new String[][]{{"left", "VP", "ADJP", "NP", "UCP", "PP", "WHADJP", "WHNP"}};
                if (tmpFilteredChildren == null) {
                    tmpFilteredChildren = ArrayUtils.filter(kids, REMOVE_TMP_AND_ADV);
                }
                pti = null;
                for (int i = 0; i < how.length && pti == null; ++i) {
                    pti = this.traverseLocate(tmpFilteredChildren, how[i], false);
                }
                if (motherCat.equals("SQ") && pti != null && pti.label() != null && pti.label().value().startsWith("NP")) {
                    boolean foundAnotherNp = false;
                    for (Tree kid : kids) {
                        if (kid == pti) break;
                        if (kid.label() == null || !kid.label().value().startsWith("NP")) continue;
                        foundAnotherNp = true;
                        break;
                    }
                    if (!foundAnotherNp) {
                        pti = null;
                    }
                }
                if (DEBUG) {
                    System.err.println("Determined head (case 2) for " + t.value() + " is: " + pti);
                }
                if (pti != null) {
                    return pti;
                }
                if (DEBUG) {
                    System.err.println("------");
                    System.err.println("SemanticHeadFinder failed to reassign head for");
                    t.pennPrint(System.err);
                    System.err.println("------");
                }
            }
        }
        Tree hd = super.determineNonTrivialHead(t, parent);
        if (DEBUG) {
            System.err.println("Determined head (case 3) for " + t.value() + " is: " + hd);
        }
        return hd;
    }

    private boolean isExistential(Tree t, Tree parent) {
        if (DEBUG) {
            System.err.println("isExistential: " + t + ' ' + parent);
        }
        boolean toReturn = false;
        String motherCat = this.tlp.basicCategory(t.label().value());
        if (motherCat.equals("VP") && parent != null) {
            Tree[] kids;
            for (Tree kid : kids = parent.children()) {
                if (kid.value().equals("VP")) break;
                List<Label> tags = kid.preTerminalYield();
                for (Label tag : tags) {
                    if (!tag.value().equals("EX")) continue;
                    toReturn = true;
                }
            }
        } else if (motherCat.startsWith("SQ") && parent != null) {
            Tree[] kids;
            for (Tree kid : kids = parent.children()) {
                if (kid.value().startsWith("VB")) continue;
                List<Label> tags = kid.preTerminalYield();
                for (Label tag : tags) {
                    if (!tag.value().equals("EX")) continue;
                    toReturn = true;
                }
            }
        }
        if (DEBUG) {
            System.err.println("decision " + toReturn);
        }
        return toReturn;
    }

    private static boolean isWHQ(Tree t, Tree parent) {
        if (t == null) {
            return false;
        }
        boolean toReturn = false;
        if (t.value().startsWith("SQ") && parent != null && parent.value().equals("SBARQ")) {
            Tree[] kids;
            for (Tree kid : kids = parent.children()) {
                if (!kid.value().startsWith("WH")) continue;
                toReturn = true;
            }
        }
        if (DEBUG) {
            System.err.println("in isWH, decision: " + toReturn + " for node " + t);
        }
        return toReturn;
    }

    private boolean isVerbalAuxiliary(Tree preterminal, Set<String> verbalSet, boolean allowJustTagMatch) {
        if (preterminal.isPreTerminal()) {
            Label kidLabel = preterminal.label();
            String tag = null;
            if (kidLabel instanceof HasTag) {
                tag = ((HasTag)((Object)kidLabel)).tag();
            }
            if (tag == null) {
                tag = preterminal.value();
            }
            Label wordLabel = preterminal.firstChild().label();
            String word = null;
            if (wordLabel instanceof HasWord) {
                word = ((HasWord)((Object)wordLabel)).word();
            }
            if (word == null) {
                word = wordLabel.value();
            }
            if (DEBUG) {
                System.err.println("Checking " + preterminal.value() + " head is " + word + '/' + tag);
            }
            String lcWord = word.toLowerCase();
            if (allowJustTagMatch && this.unambiguousAuxiliaryTags.contains(tag) || this.verbalTags.contains(tag) && verbalSet.contains(lcWord)) {
                if (DEBUG) {
                    System.err.println("isAuxiliary found desired type of aux");
                }
                return true;
            }
        }
        return false;
    }

    public boolean isVerbalAuxiliary(Tree t) {
        return this.isVerbalAuxiliary(t, this.verbalAuxiliaries, true);
    }

    private boolean hasPassiveProgressiveAuxiliary(Tree[] kids) {
        if (DEBUG) {
            System.err.println("Checking for passive/progressive auxiliary");
        }
        boolean foundPassiveVP = false;
        boolean foundPassiveAux = false;
        for (Tree kid : kids) {
            if (DEBUG) {
                System.err.println("  checking in " + kid);
            }
            if (this.isVerbalAuxiliary(kid, this.passiveAuxiliaries, false)) {
                foundPassiveAux = true;
            } else if (kid.isPhrasal()) {
                Label kidLabel = kid.label();
                String cat = null;
                if (kidLabel instanceof HasCategory) {
                    cat = ((HasCategory)((Object)kidLabel)).category();
                }
                if (cat == null) {
                    cat = kid.value();
                }
                if (!cat.startsWith("VP")) continue;
                if (DEBUG) {
                    System.err.println("hasPassiveProgressiveAuxiliary found VP");
                }
                Tree[] kidkids = kid.children();
                boolean foundParticipleInVp = false;
                for (Tree kidkid : kidkids) {
                    if (DEBUG) {
                        System.err.println("  hasPassiveProgressiveAuxiliary examining " + kidkid);
                    }
                    if (kidkid.isPreTerminal()) {
                        Label kidkidLabel = kidkid.label();
                        String tag = null;
                        if (kidkidLabel instanceof HasTag) {
                            tag = ((HasTag)((Object)kidkidLabel)).tag();
                        }
                        if (tag == null) {
                            tag = kidkid.value();
                        }
                        if ("VBN".equals(tag) || "VBG".equals(tag) || "VBD".equals(tag)) {
                            foundPassiveVP = true;
                            if (!DEBUG) break;
                            System.err.println("hasPassiveAuxiliary found VBN/VBG/VBD VP");
                            break;
                        }
                        if (!"CC".equals(tag) || !foundParticipleInVp) continue;
                        foundPassiveVP = true;
                        if (!DEBUG) break;
                        System.err.println("hasPassiveAuxiliary [coordination] found (VP (VP[VBN/VBG/VBD] CC");
                        break;
                    }
                    if (!kidkid.isPhrasal()) continue;
                    String catcat = null;
                    if (kidLabel instanceof HasCategory) {
                        catcat = ((HasCategory)((Object)kidLabel)).category();
                    }
                    if (catcat == null) {
                        catcat = kid.value();
                    }
                    if ("VP".equals(catcat)) {
                        if (DEBUG) {
                            System.err.println("hasPassiveAuxiliary found (VP (VP)), recursing");
                        }
                        foundParticipleInVp = UniversalSemanticHeadFinder.vpContainsParticiple(kidkid);
                        continue;
                    }
                    if (!"CONJP".equals(catcat) && !"PRN".equals(catcat) || !foundParticipleInVp) continue;
                    foundPassiveVP = true;
                    if (!DEBUG) break;
                    System.err.println("hasPassiveAuxiliary [coordination] found (VP (VP[VBN/VBG/VBD] CONJP");
                    break;
                }
            }
            if (foundPassiveAux && foundPassiveVP) break;
        }
        if (DEBUG) {
            System.err.println("hasPassiveProgressiveAuxiliary returns " + (foundPassiveAux && foundPassiveVP));
        }
        return foundPassiveAux && foundPassiveVP;
    }

    private static boolean vpContainsParticiple(Tree t) {
        for (Tree kid : t.children()) {
            if (DEBUG) {
                System.err.println("vpContainsParticiple examining " + kid);
            }
            if (!kid.isPreTerminal()) continue;
            Label kidLabel = kid.label();
            String tag = null;
            if (kidLabel instanceof HasTag) {
                tag = ((HasTag)((Object)kidLabel)).tag();
            }
            if (tag == null) {
                tag = kid.value();
            }
            if (!"VBN".equals(tag) && !"VBG".equals(tag) && !"VBD".equals(tag)) continue;
            if (DEBUG) {
                System.err.println("vpContainsParticiple found VBN/VBG/VBD VP");
            }
            return true;
        }
        return false;
    }

    private boolean hasVerbalAuxiliary(Tree[] kids, Set<String> verbalSet, boolean allowTagOnlyMatch) {
        if (DEBUG) {
            System.err.println("Checking for verbal auxiliary");
        }
        for (Tree kid : kids) {
            if (DEBUG) {
                System.err.println("  checking in " + kid);
            }
            if (!this.isVerbalAuxiliary(kid, verbalSet, allowTagOnlyMatch)) continue;
            return true;
        }
        if (DEBUG) {
            System.err.println("hasVerbalAuxiliary returns false");
        }
        return false;
    }
}

