/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scoref;

import edu.stanford.nlp.util.PropertiesUtils;
import java.util.Arrays;
import java.util.Properties;

public class StatisticalCorefProperties {
    private static final String DEFAULT_MODELS_PATH = "edu/stanford/nlp/models/dcoref/";

    public static Properties addHcorefProps(Properties props) {
        Properties newProps = (Properties)props.clone();
        newProps.setProperty("coref.useSemantics", "false");
        newProps.setProperty("coref.big.gender.number", "edu/stanford/nlp/models/dcoref/gender.data.gz");
        newProps.setProperty("coref.input.type", "conll");
        if (props.containsKey("coref.scorer")) {
            newProps.setProperty("coref.path.scorer.conll", props.getProperty("coref.scorer"));
        }
        if (StatisticalCorefProperties.conll(props)) {
            newProps.setProperty("coref.useConstituencyTree", props.getProperty("coref.useConstituencyTree", "true"));
            newProps.setProperty("coref.md.type", props.getProperty("coref.md.type", "rule"));
            newProps.setProperty("coref.useMarkedDiscourse", "true");
        } else {
            String mdPath = PropertiesUtils.getString(newProps, "coref.mentionDetectionModel", "edu/stanford/nlp/models/hcoref/md-model.ser");
            newProps.setProperty("coref.md.type", "dependency");
            newProps.setProperty("coref.useGoldPOS", "false");
            newProps.setProperty("coref.useGoldNE", "false");
            newProps.setProperty("coref.useGoldParse", "false");
        }
        if (props.containsKey("coref.test")) {
            newProps.setProperty("coref.path.input", props.getProperty("coref.test"));
        }
        return newProps;
    }

    public static void setInput(Properties props, Dataset d) {
        props.setProperty("coref.path.input", d == Dataset.TRAIN ? props.getProperty("coref.train") : (d == Dataset.DEV ? props.getProperty("coref.dev") : props.getProperty("coref.test")));
    }

    public static boolean conll(Properties props) {
        return PropertiesUtils.getBool(props, "coref.conll", false);
    }

    public static String trainingPath(Properties props) {
        return props.getProperty("coref.trainingPath");
    }

    public static String conllOutputPath(Properties props) {
        return props.getProperty("coref.conllOutputPath");
    }

    public static String classificationModelPath(Properties props) {
        return PropertiesUtils.getString(props, "coref.classificationModel", "edu/stanford/nlp/models/scoref/classification_model.ser.gz");
    }

    public static String rankingModelPath(Properties props) {
        return PropertiesUtils.getString(props, "coref.rankingModel", "edu/stanford/nlp/models/scoref/ranking_model.ser.gz");
    }

    public static String anaphoricityModelPath(Properties props) {
        return PropertiesUtils.getString(props, "coref.anaphoricityModel", "edu/stanford/nlp/models/scoref/anaphoricity_model.ser.gz");
    }

    public static String clusteringModelPath(Properties props) {
        return PropertiesUtils.getString(props, "coref.clusteringModel", "edu/stanford/nlp/models/scoref/clustering_model.ser");
    }

    public static String wordCountsPath(Properties props) {
        return PropertiesUtils.getString(props, "coref.wordCounts", "edu/stanford/nlp/models/scoref/word_counts.ser.gz");
    }

    private static String defaultModelPath(Properties props, String modelName) {
        return DEFAULT_MODELS_PATH + modelName + (StatisticalCorefProperties.conll(props) ? "_conll" : ".ser");
    }

    public static boolean cluster(Properties props) {
        return PropertiesUtils.getBool(props, "coref.doClustering", true);
    }

    public static int maxMentionDistance(Properties props) {
        return PropertiesUtils.getInt(props, "coref.maxMentionDistance", 50);
    }

    public static int maxMentionDistanceWithStringMatch(Properties props) {
        return PropertiesUtils.getInt(props, "coref.maxMentionDistanceWithStringMatch", 5000);
    }

    public static double[] pairwiseScoreThresholds(Properties props) {
        String[] split;
        String thresholdsProp = (String)props.get("coref.pairwiseScoreThresholds");
        if (thresholdsProp != null && (split = thresholdsProp.split(",")).length == 4) {
            return Arrays.stream(split).mapToDouble(Double::parseDouble).toArray();
        }
        double threshold = PropertiesUtils.getDouble(props, "coref.pairwiseScoreThresholds", 0.35);
        return new double[]{threshold, threshold, threshold, threshold};
    }

    public static boolean useConstituencyParse(Properties props) {
        boolean defaultValue = StatisticalCorefProperties.conll(props);
        return PropertiesUtils.getBool(props, "coref.useConstituencyTree", defaultValue);
    }

    public static double minClassImbalance(Properties props) {
        return PropertiesUtils.getDouble(props, "coref.minClassImbalance", 0.0);
    }

    public static int minTrainExamplesPerDocument(Properties props) {
        return PropertiesUtils.getInt(props, "coref.minTrainExamplesPerDocument", Integer.MAX_VALUE);
    }

    public static enum Dataset {
        TRAIN,
        DEV,
        TEST;

    }
}

