/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.shiftreduce.BinaryTransition;
import edu.stanford.nlp.parser.shiftreduce.ShiftTransition;
import edu.stanford.nlp.parser.shiftreduce.Transition;

class OracleTransition {
    final Transition transition;
    final boolean allowsShift;
    final boolean allowsBinary;
    final boolean allowsEitherSide;

    OracleTransition(Transition transition, boolean allowsShift, boolean allowsBinary, boolean allowsEitherSide) {
        this.transition = transition;
        this.allowsShift = allowsShift;
        this.allowsBinary = allowsBinary;
        this.allowsEitherSide = allowsEitherSide;
    }

    boolean isCorrect(Transition other) {
        if (this.transition != null && this.transition.equals(other)) {
            return true;
        }
        if (this.allowsShift && other instanceof ShiftTransition) {
            return true;
        }
        if (this.allowsBinary && other instanceof BinaryTransition) {
            return true;
        }
        return this.allowsEitherSide && other instanceof BinaryTransition && this.transition instanceof BinaryTransition && ((BinaryTransition)other).label.equals(((BinaryTransition)this.transition).label);
    }
}

