/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.EnvLookup;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.ling.tokensregex.MultiPatternMatcher;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.ling.tokensregex.types.AssignableExpression;
import edu.stanford.nlp.ling.tokensregex.types.Expression;
import edu.stanford.nlp.ling.tokensregex.types.Expressions;
import edu.stanford.nlp.ling.tokensregex.types.Value;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Interval;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SequenceMatchRules {
    public static final String COMPOSITE_RULE_TYPE = "composite";
    public static final String TOKEN_PATTERN_RULE_TYPE = "tokens";
    public static final String TEXT_PATTERN_RULE_TYPE = "text";
    public static final String FILTER_RULE_TYPE = "filter";
    public static final TokenPatternExtractRuleCreator TOKEN_PATTERN_EXTRACT_RULE_CREATOR = new TokenPatternExtractRuleCreator();
    public static final CompositeExtractRuleCreator COMPOSITE_EXTRACT_RULE_CREATOR = new CompositeExtractRuleCreator();
    public static final TextPatternExtractRuleCreator TEXT_PATTERN_EXTRACT_RULE_CREATOR = new TextPatternExtractRuleCreator();
    public static final MultiTokenPatternExtractRuleCreator MULTI_TOKEN_PATTERN_EXTRACT_RULE_CREATOR = new MultiTokenPatternExtractRuleCreator();
    public static final AnnotationExtractRuleCreator DEFAULT_EXTRACT_RULE_CREATOR = TOKEN_PATTERN_EXTRACT_RULE_CREATOR;
    static final Map<String, AnnotationExtractRuleCreator> registeredRuleTypes = new HashMap<String, AnnotationExtractRuleCreator>();

    public static AssignmentRule createAssignmentRule(Env env, AssignableExpression var, Expression result) {
        AssignmentRule ar = new AssignmentRule(var, result);
        ar.evaluate(env);
        return ar;
    }

    public static Rule createRule(Env env, Expressions.CompositeValue cv) {
        cv = cv.simplifyNoTypeConversion(env, new Object[0]);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (String s : cv.getAttributes()) {
            attributes.put(s, cv.getExpression(s));
        }
        return SequenceMatchRules.createExtractionRule(env, attributes);
    }

    protected static AnnotationExtractRule createExtractionRule(Env env, Map<String, Object> attributes) {
        AnnotationExtractRuleCreator ruleCreator;
        String ruleType = (String)Expressions.asObject(env, attributes.get("ruleType"));
        if (ruleType == null && env != null) {
            ruleType = (String)env.getDefaults().get("ruleType");
        }
        if ((ruleCreator = SequenceMatchRules.lookupExtractRuleCreator(env, ruleType)) != null) {
            return ruleCreator.create(env, attributes);
        }
        throw new IllegalArgumentException("Unknown rule type: " + ruleType);
    }

    public static AnnotationExtractRule createExtractionRule(Env env, String ruleType, Object pattern, Expression result) {
        AnnotationExtractRuleCreator ruleCreator;
        if (ruleType == null && env != null) {
            ruleType = (String)env.getDefaults().get("ruleType");
        }
        if ((ruleCreator = SequenceMatchRules.lookupExtractRuleCreator(env, ruleType)) != null) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("ruleType", ruleType);
            attributes.put("pattern", pattern);
            attributes.put("result", result);
            return ruleCreator.create(env, attributes);
        }
        throw new IllegalArgumentException("Unknown rule type: " + ruleType);
    }

    protected static AnnotationExtractRuleCreator lookupExtractRuleCreator(Env env, String ruleType) {
        Object obj;
        if (env != null && (obj = env.get(ruleType)) != null && obj instanceof AnnotationExtractRuleCreator) {
            return (AnnotationExtractRuleCreator)obj;
        }
        if (ruleType == null) {
            return DEFAULT_EXTRACT_RULE_CREATOR;
        }
        return registeredRuleTypes.get(ruleType);
    }

    public static AnnotationExtractRule createTokenPatternRule(Env env, SequencePattern.PatternExpr expr, Expression result) {
        return TOKEN_PATTERN_EXTRACT_RULE_CREATOR.create(env, expr, result);
    }

    public static AnnotationExtractRule createTextPatternRule(Env env, String expr, Expression result) {
        return TEXT_PATTERN_EXTRACT_RULE_CREATOR.create(env, expr, result);
    }

    public static AnnotationExtractRule createMultiTokenPatternRule(Env env, AnnotationExtractRule template, List<TokenSequencePattern> patterns) {
        return MULTI_TOKEN_PATTERN_EXTRACT_RULE_CREATOR.create(env, template, patterns);
    }

    public static MatchedExpression.SingleAnnotationExtractor createAnnotationExtractor(Env env, AnnotationExtractRule r) {
        MatchedExpression.SingleAnnotationExtractor extractor = new MatchedExpression.SingleAnnotationExtractor();
        extractor.name = r.name;
        extractor.tokensAnnotationField = r.tokensAnnotationField;
        extractor.tokensResultAnnotationField = r.tokensResultAnnotationField;
        extractor.resultAnnotationField = r.resultAnnotationField;
        extractor.resultNestedAnnotationField = r.resultNestedAnnotationField;
        extractor.priority = r.priority;
        extractor.weight = r.weight;
        extractor.includeNested = r.includeNested;
        extractor.resultAnnotationExtractor = EnvLookup.getDefaultResultAnnotationExtractor(env);
        extractor.tokensAggregator = EnvLookup.getDefaultTokensAggregator(env);
        return extractor;
    }

    static {
        registeredRuleTypes.put(TOKEN_PATTERN_RULE_TYPE, TOKEN_PATTERN_EXTRACT_RULE_CREATOR);
        registeredRuleTypes.put(COMPOSITE_RULE_TYPE, COMPOSITE_EXTRACT_RULE_CREATOR);
        registeredRuleTypes.put(TEXT_PATTERN_RULE_TYPE, TEXT_PATTERN_EXTRACT_RULE_CREATOR);
        registeredRuleTypes.put(FILTER_RULE_TYPE, TOKEN_PATTERN_EXTRACT_RULE_CREATOR);
    }

    public static class CoreMapToListFunctionApplier<O>
    implements Function<CoreMap, O> {
        Env env;
        Function<List<? extends CoreMap>, O> func;

        public CoreMapToListFunctionApplier(Env env, Function<List<? extends CoreMap>, O> func) {
            this.func = func;
            this.env = env;
        }

        @Override
        public O apply(CoreMap cm) {
            if (this.env != null) {
                this.env.push("_", cm);
            }
            O res = this.func.apply(Arrays.asList(cm));
            if (this.env != null) {
                this.env.pop("_");
            }
            return res;
        }
    }

    public static class CoreMapFunctionApplier<T, O>
    implements Function<CoreMap, O> {
        Env env;
        Class annotationField;
        Function<T, O> func;

        public CoreMapFunctionApplier(Env env, Class annotationField, Function<T, O> func) {
            this.annotationField = annotationField;
            if (annotationField == null) {
                throw new IllegalArgumentException("Annotation field cannot be null");
            }
            this.func = func;
            this.env = env;
        }

        @Override
        public O apply(CoreMap cm) {
            if (this.env != null) {
                this.env.push("_", cm);
            }
            Object field = cm.get(this.annotationField);
            O res = this.func.apply(field);
            if (this.env != null) {
                this.env.pop("_");
            }
            return res;
        }
    }

    public static class SequenceMatchedExpressionExtractor
    implements Function<SequenceMatchResult<CoreMap>, MatchedExpression> {
        MatchedExpression.SingleAnnotationExtractor extractor;
        int group = 0;

        public SequenceMatchedExpressionExtractor(MatchedExpression.SingleAnnotationExtractor extractor, int group) {
            this.extractor = extractor;
            this.group = group;
        }

        @Override
        public MatchedExpression apply(SequenceMatchResult<CoreMap> matched) {
            MatchedExpression te = this.extractor.createMatchedExpression(null, Interval.toInterval(matched.start(this.group), matched.end(this.group), 2));
            if (Double.isNaN(te.priority)) {
                te.priority = matched.priority();
            }
            if (Double.isNaN(te.weight)) {
                te.weight = matched.score();
            }
            if (this.group != 0) {
                te.context = matched.toBasicSequenceMatchResult();
            }
            return te;
        }
    }

    public static class StringMatchedExpressionExtractor
    implements Function<MatchResult, MatchedExpression> {
        MatchedExpression.SingleAnnotationExtractor extractor;
        int group = 0;

        public StringMatchedExpressionExtractor(MatchedExpression.SingleAnnotationExtractor extractor, int group) {
            this.extractor = extractor;
            this.group = group;
        }

        @Override
        public MatchedExpression apply(MatchResult matched) {
            MatchedExpression te = this.extractor.createMatchedExpression(Interval.toInterval(matched.start(this.group), matched.end(this.group), 2), null);
            return te;
        }
    }

    public static class StringPatternExtractRule<O>
    implements ExtractRule<String, O>,
    Function<String, O> {
        Pattern pattern;
        Function<MatchResult, O> extractor;

        public StringPatternExtractRule(Pattern pattern, Function<MatchResult, O> extractor) {
            this.pattern = pattern;
            this.extractor = extractor;
        }

        public StringPatternExtractRule(Env env, String regex, Function<MatchResult, O> extractor) {
            this(env, regex, extractor, false);
        }

        public StringPatternExtractRule(String regex, Function<MatchResult, O> extractor) {
            this(null, regex, extractor, false);
        }

        public StringPatternExtractRule(Env env, String regex, Function<MatchResult, O> extractor, boolean addWordBoundaries) {
            this.extractor = extractor;
            if (addWordBoundaries) {
                regex = "\\b" + regex + "\\b";
            }
            this.pattern = env != null ? env.getStringPattern(regex) : Pattern.compile(regex);
        }

        @Override
        public boolean extract(String str, List<O> out2) {
            if (str == null) {
                return false;
            }
            boolean extracted = false;
            Matcher m = this.pattern.matcher(str);
            while (m.find()) {
                out2.add(this.extractor.apply(m));
                extracted = true;
            }
            return extracted;
        }

        @Override
        public O apply(String str) {
            if (str == null) {
                return null;
            }
            Matcher m = this.pattern.matcher(str);
            if (m.matches()) {
                return this.extractor.apply(m);
            }
            return null;
        }
    }

    public static class MultiSequencePatternExtractRule<T, O>
    implements ExtractRule<List<? extends T>, O>,
    Function<List<? extends T>, O> {
        MultiPatternMatcher<T> matcher;
        Function<SequenceMatchResult<T>, O> extractor;

        public MultiSequencePatternExtractRule(MultiPatternMatcher<T> matcher, Function<SequenceMatchResult<T>, O> extractor) {
            this.extractor = extractor;
            this.matcher = matcher;
        }

        @Override
        public boolean extract(List<? extends T> seq, List<O> out2) {
            if (seq == null) {
                return false;
            }
            boolean extracted = false;
            List<SequenceMatchResult<T>> matched = this.matcher.findNonOverlappingMaxScore(seq);
            for (SequenceMatchResult<? extends T> sequenceMatchResult : matched) {
                out2.add(this.extractor.apply(sequenceMatchResult));
                extracted = true;
            }
            return extracted;
        }

        @Override
        public O apply(List<? extends T> seq) {
            if (seq == null) {
                return null;
            }
            List<SequenceMatchResult<T>> matched = this.matcher.findNonOverlappingMaxScore(seq);
            if (matched.size() > 0) {
                return this.extractor.apply(matched.get(0));
            }
            return null;
        }
    }

    public static class SequencePatternExtractRule<T, O>
    implements ExtractRule<List<? extends T>, O>,
    Function<List<? extends T>, O> {
        SequencePattern<T> pattern;
        Function<SequenceMatchResult<T>, O> extractor;
        SequenceMatcher.FindType findType = null;
        boolean matchWithResult = false;

        public SequencePatternExtractRule(Env env, String regex, Function<SequenceMatchResult<T>, O> extractor) {
            this.extractor = extractor;
            this.pattern = SequencePattern.compile(env, regex);
        }

        public SequencePatternExtractRule(SequencePattern<T> p, Function<SequenceMatchResult<T>, O> extractor) {
            this.extractor = extractor;
            this.pattern = p;
        }

        public SequencePatternExtractRule(SequencePattern<T> p, Function<SequenceMatchResult<T>, O> extractor, SequenceMatcher.FindType findType, boolean matchWithResult) {
            this.extractor = extractor;
            this.pattern = p;
            this.findType = findType;
            this.matchWithResult = matchWithResult;
        }

        @Override
        public boolean extract(List<? extends T> seq, List<O> out2) {
            if (seq == null) {
                return false;
            }
            boolean extracted = false;
            SequenceMatcher<T> m = this.pattern.getMatcher(seq);
            if (this.findType != null) {
                m.setFindType(this.findType);
            }
            m.setMatchWithResult(this.matchWithResult);
            while (m.find()) {
                out2.add(this.extractor.apply(m));
                extracted = true;
            }
            return extracted;
        }

        @Override
        public O apply(List<? extends T> seq) {
            if (seq == null) {
                return null;
            }
            SequenceMatcher<T> m = this.pattern.getMatcher(seq);
            m.setMatchWithResult(this.matchWithResult);
            if (m.matches()) {
                return this.extractor.apply(m);
            }
            return null;
        }
    }

    public static class BasicSequenceExtractRule
    implements ExtractRule<List<? extends CoreMap>, MatchedExpression> {
        MatchedExpression.SingleAnnotationExtractor extractor;

        public BasicSequenceExtractRule(MatchedExpression.SingleAnnotationExtractor extractor) {
            this.extractor = extractor;
        }

        @Override
        public boolean extract(List<? extends CoreMap> seq, List<MatchedExpression> out2) {
            boolean extracted = false;
            for (int i = 0; i < seq.size(); ++i) {
                CoreMap t = seq.get(i);
                Value v = this.extractor.apply(t);
                if (v == null) continue;
                MatchedExpression te = this.extractor.createMatchedExpression(Interval.toInterval(i, i + 1, 2), null);
                out2.add(te);
                extracted = true;
            }
            return extracted;
        }
    }

    public static class CoreMapToListExtractRule<O>
    implements ExtractRule<CoreMap, O> {
        ExtractRule<List<? extends CoreMap>, O> extractRule;

        public CoreMapToListExtractRule(ExtractRule<List<? extends CoreMap>, O> extractRule) {
            this.extractRule = extractRule;
        }

        @Override
        public boolean extract(CoreMap cm, List<O> out2) {
            return this.extractRule.extract(Arrays.asList(cm), out2);
        }
    }

    public static class CoreMapExtractRule<T, O>
    implements ExtractRule<CoreMap, O> {
        Env env;
        Class annotationField;
        ExtractRule<T, O> extractRule;

        public CoreMapExtractRule(Env env, Class annotationField, ExtractRule<T, O> extractRule) {
            this.annotationField = annotationField;
            this.extractRule = extractRule;
            this.env = env;
        }

        @Override
        public boolean extract(CoreMap cm, List<O> out2) {
            this.env.push("_", cm);
            Object field = cm.get(this.annotationField);
            boolean res = this.extractRule.extract(field, out2);
            this.env.pop("_");
            return res;
        }
    }

    public static class ListExtractRule<I, O>
    implements ExtractRule<I, O> {
        List<ExtractRule<I, O>> rules;

        public ListExtractRule(Collection<ExtractRule<I, O>> rules) {
            this.rules = new ArrayList<ExtractRule<I, O>>(rules);
        }

        public ListExtractRule(ExtractRule<I, O> ... rules) {
            this.rules = new ArrayList<ExtractRule<I, O>>(rules.length);
            for (ExtractRule<I, O> rule : rules) {
                this.rules.add(rule);
            }
        }

        @Override
        public boolean extract(I in, List<O> out2) {
            boolean extracted = false;
            for (ExtractRule<I, O> rule : this.rules) {
                if (!rule.extract(in, out2)) continue;
                extracted = true;
            }
            return extracted;
        }

        public void addRules(ExtractRule<I, O> ... rules) {
            for (ExtractRule<I, O> rule : rules) {
                this.rules.add(rule);
            }
        }

        public void addRules(Collection<ExtractRule<I, O>> rules) {
            this.rules.addAll(rules);
        }
    }

    public static class FilterExtractRule<I, O>
    implements ExtractRule<I, O> {
        Predicate<I> filter;
        ExtractRule<I, O> rule;

        public FilterExtractRule(Predicate<I> filter, ExtractRule<I, O> rule) {
            this.filter = filter;
            this.rule = rule;
        }

        public FilterExtractRule(Predicate<I> filter, ExtractRule<I, O> ... rules) {
            this.filter = filter;
            this.rule = new ListExtractRule<I, O>(rules);
        }

        @Override
        public boolean extract(I in, List<O> out2) {
            if (this.filter.test(in)) {
                return this.rule.extract(in, out2);
            }
            return false;
        }
    }

    public static interface ExtractRule<I, O> {
        public boolean extract(I var1, List<O> var2);
    }

    public static class SequenceMatchResultExtractor<T>
    implements Function<SequenceMatchResult<T>, Value> {
        Env env;
        Expression action;
        Expression result;

        public SequenceMatchResultExtractor(Env env, Expression action, Expression result) {
            this.env = env;
            this.action = action;
            this.result = result;
        }

        public SequenceMatchResultExtractor(Env env, Expression result) {
            this.env = env;
            this.result = result;
        }

        @Override
        public Value apply(SequenceMatchResult<T> matchResult) {
            Value v = null;
            if (this.action != null) {
                this.action.evaluate(this.env, matchResult);
            }
            if (this.result != null) {
                v = this.result.evaluate(this.env, matchResult);
            }
            return v;
        }
    }

    public static class StringMatchResultExtractor
    implements Function<MatchResult, Value> {
        Env env;
        Expression action;
        Expression result;

        public StringMatchResultExtractor(Env env, Expression action, Expression result) {
            this.env = env;
            this.action = action;
            this.result = result;
        }

        public StringMatchResultExtractor(Env env, Expression result) {
            this.env = env;
            this.result = result;
        }

        @Override
        public Value apply(MatchResult matchResult) {
            Value v = null;
            if (this.action != null) {
                this.action.evaluate(this.env, matchResult);
            }
            if (this.result != null) {
                v = this.result.evaluate(this.env, matchResult);
            }
            return v;
        }
    }

    public static class AnnotationMatchedFilter
    implements Predicate<MatchedExpression>,
    Serializable {
        MatchedExpression.SingleAnnotationExtractor extractor;

        public AnnotationMatchedFilter(MatchedExpression.SingleAnnotationExtractor extractor) {
            this.extractor = extractor;
        }

        @Override
        public boolean test(MatchedExpression me) {
            CoreMap cm = me.getAnnotation();
            Value v = this.extractor.apply(cm);
            if (v != null) {
                if (v.get() == null) {
                    return true;
                }
                this.extractor.annotate(me);
                return false;
            }
            return false;
        }
    }

    public static class TextPatternExtractRuleCreator
    extends AnnotationExtractRuleCreator {
        protected void updateExtractRule(AnnotationExtractRule r, Env env, String expr, Expression action, Expression result) {
            MatchedExpression.SingleAnnotationExtractor annotationExtractor = SequenceMatchRules.createAnnotationExtractor(env, r);
            Pattern pattern = env.getStringPattern(expr);
            StringMatchResultExtractor valueExtractor = new StringMatchResultExtractor(env, action, result);
            StringPatternExtractRule<Value> valueExtractRule = new StringPatternExtractRule<Value>(pattern, valueExtractor);
            StringMatchedExpressionExtractor exprExtractor = new StringMatchedExpressionExtractor(annotationExtractor, r.matchedExpressionGroup);
            StringPatternExtractRule<MatchedExpression> exprExtractRule = new StringPatternExtractRule<MatchedExpression>(pattern, exprExtractor);
            annotationExtractor.valueExtractor = new CoreMapFunctionApplier(env, r.annotationField, valueExtractRule);
            r.extractRule = new CoreMapExtractRule(env, r.annotationField, exprExtractRule);
            r.filterRule = new AnnotationMatchedFilter(annotationExtractor);
            r.pattern = pattern;
            r.result = result;
        }

        protected AnnotationExtractRule create(Env env, String expr, Expression result) {
            AnnotationExtractRule r = super.create(env, null);
            if (r.annotationField == null) {
                r.annotationField = EnvLookup.getDefaultTextAnnotationKey(env);
            }
            r.ruleType = SequenceMatchRules.TEXT_PATTERN_RULE_TYPE;
            this.updateExtractRule(r, env, expr, null, result);
            return r;
        }

        @Override
        public AnnotationExtractRule create(Env env, Map<String, Object> attributes) {
            AnnotationExtractRule r = super.create(env, attributes);
            if (r.annotationField == null) {
                r.annotationField = EnvLookup.getDefaultTextAnnotationKey(env);
            }
            if (r.ruleType == null) {
                r.ruleType = SequenceMatchRules.TEXT_PATTERN_RULE_TYPE;
            }
            String expr = (String)Expressions.asObject(env, attributes.get("pattern"));
            Expression action = Expressions.asExpression(env, attributes.get("action"));
            Expression result = Expressions.asExpression(env, attributes.get("result"));
            this.updateExtractRule(r, env, expr, action, result);
            return r;
        }
    }

    public static class MultiTokenPatternExtractRuleCreator
    extends AnnotationExtractRuleCreator {
        protected void updateExtractRule(AnnotationExtractRule r, Env env, MultiPatternMatcher<CoreMap> pattern, Expression action, Expression result) {
            MatchedExpression.SingleAnnotationExtractor annotationExtractor = SequenceMatchRules.createAnnotationExtractor(env, r);
            SequenceMatchResultExtractor valueExtractor = new SequenceMatchResultExtractor(env, action, result);
            MultiSequencePatternExtractRule valueExtractRule = new MultiSequencePatternExtractRule(pattern, valueExtractor);
            SequenceMatchedExpressionExtractor exprExtractor = new SequenceMatchedExpressionExtractor(annotationExtractor, r.matchedExpressionGroup);
            MultiSequencePatternExtractRule<CoreMap, MatchedExpression> exprExtractRule = new MultiSequencePatternExtractRule<CoreMap, MatchedExpression>(pattern, exprExtractor);
            annotationExtractor.expressionToValue = matched -> {
                if (matched != null && matched.context != null && matched.context instanceof SequenceMatchResult) {
                    return valueExtractor.apply((SequenceMatchResult)matched.context);
                }
                return null;
            };
            if (r.annotationField != null && r.annotationField != CoreMap.class) {
                annotationExtractor.valueExtractor = new CoreMapFunctionApplier<CoreMap, Value>(env, r.annotationField, valueExtractRule);
                r.extractRule = new CoreMapExtractRule<CoreMap, MatchedExpression>(env, r.annotationField, exprExtractRule);
            } else {
                annotationExtractor.valueExtractor = new CoreMapToListFunctionApplier<Value>(env, valueExtractRule);
                r.extractRule = new CoreMapToListExtractRule<MatchedExpression>(exprExtractRule);
            }
            r.filterRule = new AnnotationMatchedFilter(annotationExtractor);
            r.pattern = pattern;
            r.result = result;
        }

        protected AnnotationExtractRule create(Env env, AnnotationExtractRule aerTemplate, List<TokenSequencePattern> patterns) {
            AnnotationExtractRule r = new AnnotationExtractRule();
            r.stage = aerTemplate.stage;
            r.active = aerTemplate.active;
            r.priority = Double.NaN;
            r.weight = Double.NaN;
            r.annotationField = aerTemplate.annotationField;
            r.tokensAnnotationField = aerTemplate.tokensAnnotationField;
            r.tokensResultAnnotationField = aerTemplate.tokensResultAnnotationField;
            r.resultAnnotationField = aerTemplate.resultAnnotationField;
            r.resultNestedAnnotationField = aerTemplate.resultNestedAnnotationField;
            r.matchFindType = aerTemplate.matchFindType;
            r.matchedExpressionGroup = aerTemplate.matchedExpressionGroup;
            r.matchWithResults = aerTemplate.matchWithResults;
            r.ruleType = aerTemplate.ruleType;
            r.isComposite = aerTemplate.isComposite;
            r.includeNested = aerTemplate.includeNested;
            r.active = aerTemplate.active;
            r.result = aerTemplate.result;
            if (r.annotationField == null) {
                r.annotationField = r.tokensAnnotationField;
            }
            r.ruleType = SequenceMatchRules.TOKEN_PATTERN_RULE_TYPE;
            MultiPatternMatcher<CoreMap> multiPatternMatcher = TokenSequencePattern.getMultiPatternMatcher(patterns);
            multiPatternMatcher.setMatchWithResult(r.matchWithResults);
            this.updateExtractRule(r, env, multiPatternMatcher, null, r.result);
            return r;
        }

        @Override
        public AnnotationExtractRule create(Env env, Map<String, Object> attributes) {
            throw new UnsupportedOperationException();
        }
    }

    public static class TokenPatternExtractRuleCreator
    extends AnnotationExtractRuleCreator {
        protected void updateExtractRule(AnnotationExtractRule r, Env env, SequencePattern.PatternExpr expr, Expression action, Expression result) {
            TokenSequencePattern pattern = TokenSequencePattern.compile(expr);
            this.updateExtractRule(r, env, pattern, action, result);
        }

        protected void updateExtractRule(AnnotationExtractRule r, Env env, TokenSequencePattern pattern, Expression action, Expression result) {
            MatchedExpression.SingleAnnotationExtractor annotationExtractor = SequenceMatchRules.createAnnotationExtractor(env, r);
            SequenceMatchResultExtractor valueExtractor = new SequenceMatchResultExtractor(env, action, result);
            SequencePatternExtractRule valueExtractRule = new SequencePatternExtractRule(pattern, valueExtractor, r.matchFindType, r.matchWithResults);
            SequenceMatchedExpressionExtractor exprExtractor = new SequenceMatchedExpressionExtractor(annotationExtractor, r.matchedExpressionGroup);
            SequencePatternExtractRule<CoreMap, MatchedExpression> exprExtractRule = new SequencePatternExtractRule<CoreMap, MatchedExpression>(pattern, exprExtractor, r.matchFindType, r.matchWithResults);
            annotationExtractor.expressionToValue = matched -> {
                if (matched != null && matched.context != null && matched.context instanceof SequenceMatchResult) {
                    return valueExtractor.apply((SequenceMatchResult)matched.context);
                }
                return null;
            };
            if (r.annotationField != null && r.annotationField != CoreMap.class) {
                annotationExtractor.valueExtractor = new CoreMapFunctionApplier<CoreMap, Value>(env, r.annotationField, valueExtractRule);
                r.extractRule = new CoreMapExtractRule<CoreMap, MatchedExpression>(env, r.annotationField, exprExtractRule);
            } else {
                annotationExtractor.valueExtractor = new CoreMapToListFunctionApplier<Value>(env, valueExtractRule);
                r.extractRule = new CoreMapToListExtractRule<MatchedExpression>(exprExtractRule);
            }
            r.filterRule = new AnnotationMatchedFilter(annotationExtractor);
            r.pattern = pattern;
            r.result = result;
            pattern.weight = r.weight;
            pattern.priority = r.priority;
        }

        protected AnnotationExtractRule create(Env env, SequencePattern.PatternExpr expr, Expression result) {
            AnnotationExtractRule r = super.create(env, null);
            if (r.annotationField == null) {
                r.annotationField = r.tokensAnnotationField;
            }
            r.ruleType = SequenceMatchRules.TOKEN_PATTERN_RULE_TYPE;
            this.updateExtractRule(r, env, expr, null, result);
            return r;
        }

        @Override
        public AnnotationExtractRule create(Env env, Map<String, Object> attributes) {
            AnnotationExtractRule r = super.create(env, attributes);
            if (r.annotationField == null) {
                r.annotationField = r.tokensAnnotationField;
            }
            if (r.ruleType == null) {
                r.ruleType = SequenceMatchRules.TOKEN_PATTERN_RULE_TYPE;
            }
            TokenSequencePattern expr = (TokenSequencePattern)Expressions.asObject(env, attributes.get("pattern"));
            Expression action = Expressions.asExpression(env, attributes.get("action"));
            Expression result = Expressions.asExpression(env, attributes.get("result"));
            this.updateExtractRule(r, env, expr, action, result);
            return r;
        }
    }

    public static class CompositeExtractRuleCreator
    extends AnnotationExtractRuleCreator {
        protected void updateExtractRule(AnnotationExtractRule r, Env env, SequencePattern.PatternExpr expr, Expression action, Expression result) {
            TokenSequencePattern pattern = TokenSequencePattern.compile(expr);
            this.updateExtractRule(r, env, pattern, action, result);
        }

        protected void updateExtractRule(AnnotationExtractRule r, Env env, TokenSequencePattern pattern, Expression action, Expression result) {
            MatchedExpression.SingleAnnotationExtractor annotationExtractor = SequenceMatchRules.createAnnotationExtractor(env, r);
            SequenceMatchResultExtractor valueExtractor = new SequenceMatchResultExtractor(env, action, result);
            SequencePatternExtractRule valueExtractRule = new SequencePatternExtractRule(pattern, valueExtractor, r.matchFindType, r.matchWithResults);
            SequenceMatchedExpressionExtractor exprExtractor = new SequenceMatchedExpressionExtractor(annotationExtractor, r.matchedExpressionGroup);
            SequencePatternExtractRule<CoreMap, MatchedExpression> exprExtractRule = new SequencePatternExtractRule<CoreMap, MatchedExpression>(pattern, exprExtractor, r.matchFindType, r.matchWithResults);
            annotationExtractor.expressionToValue = matched -> {
                if (matched != null && matched.context != null && matched.context instanceof SequenceMatchResult) {
                    return valueExtractor.apply((SequenceMatchResult)matched.context);
                }
                return null;
            };
            annotationExtractor.valueExtractor = new CoreMapFunctionApplier<CoreMap, Value>(env, r.annotationField, valueExtractRule);
            r.extractRule = exprExtractRule;
            r.filterRule = new AnnotationMatchedFilter(annotationExtractor);
            r.pattern = pattern;
            r.result = result;
            pattern.weight = r.weight;
            pattern.priority = r.priority;
        }

        protected AnnotationExtractRule create(Env env, SequencePattern.PatternExpr expr, Expression result) {
            AnnotationExtractRule r = super.create(env, null);
            r.isComposite = true;
            if (r.annotationField == null) {
                r.annotationField = r.resultNestedAnnotationField;
            }
            if (r.annotationField == null) {
                throw new IllegalArgumentException("Error creating composite rule: no annotation field");
            }
            r.ruleType = SequenceMatchRules.TOKEN_PATTERN_RULE_TYPE;
            this.updateExtractRule(r, env, expr, null, result);
            return r;
        }

        @Override
        public AnnotationExtractRule create(Env env, Map<String, Object> attributes) {
            AnnotationExtractRule r = super.create(env, attributes);
            r.isComposite = true;
            if (r.annotationField == null) {
                r.annotationField = r.resultNestedAnnotationField;
            }
            if (r.annotationField == null) {
                throw new IllegalArgumentException("Error creating composite rule: no annotation field");
            }
            if (r.ruleType == null) {
                r.ruleType = SequenceMatchRules.TOKEN_PATTERN_RULE_TYPE;
            }
            TokenSequencePattern expr = (TokenSequencePattern)Expressions.asObject(env, attributes.get("pattern"));
            Expression action = Expressions.asExpression(env, attributes.get("action"));
            Expression result = Expressions.asExpression(env, attributes.get("result"));
            this.updateExtractRule(r, env, expr, action, result);
            return r;
        }
    }

    public static class AnnotationExtractRuleCreator {
        public AnnotationExtractRule create(Env env) {
            AnnotationExtractRule r = new AnnotationExtractRule();
            r.resultAnnotationField = EnvLookup.getDefaultResultAnnotationKey(env);
            r.resultNestedAnnotationField = EnvLookup.getDefaultNestedResultsAnnotationKey(env);
            r.tokensAnnotationField = EnvLookup.getDefaultTokensAnnotationKey(env);
            r.tokensResultAnnotationField = EnvLookup.getDefaultTokensResultAnnotationKey(env);
            if (env != null) {
                r.update(env, env.getDefaults());
            }
            return r;
        }

        public AnnotationExtractRule create(Env env, Map<String, Object> attributes) {
            AnnotationExtractRule r = this.create(env);
            if (attributes != null) {
                r.update(env, attributes);
            }
            return r;
        }
    }

    public static class AnnotationExtractRule<S, T extends MatchedExpression>
    implements Rule,
    ExtractRule<S, T>,
    Predicate<T>,
    Serializable {
        public String name;
        public int stage = 1;
        public double priority;
        public double weight;
        public Class annotationField;
        public Class tokensAnnotationField;
        public List<Class> tokensResultAnnotationField;
        public List<Class> resultAnnotationField;
        public Class resultNestedAnnotationField;
        public SequenceMatcher.FindType matchFindType;
        public int matchedExpressionGroup;
        public boolean matchWithResults;
        public String ruleType;
        public boolean isComposite;
        public boolean includeNested = true;
        public boolean active = true;
        public ExtractRule<S, T> extractRule;
        public Predicate<T> filterRule;
        public Object pattern;
        public Expression result;

        public void update(Env env, Map<String, Object> attributes) {
            for (String key : attributes.keySet()) {
                Object obj = attributes.get(key);
                switch (key) {
                    case "name": {
                        this.name = (String)Expressions.asObject(env, obj);
                        break;
                    }
                    case "priority": {
                        this.priority = ((Number)Expressions.asObject(env, obj)).doubleValue();
                        break;
                    }
                    case "stage": {
                        this.stage = ((Number)Expressions.asObject(env, obj)).intValue();
                        break;
                    }
                    case "weight": {
                        this.weight = ((Number)Expressions.asObject(env, obj)).doubleValue();
                        break;
                    }
                    case "over": {
                        Object annoKey = Expressions.asObject(env, obj);
                        if (annoKey instanceof Class) {
                            this.annotationField = (Class)annoKey;
                            break;
                        }
                        if (annoKey instanceof String) {
                            this.annotationField = EnvLookup.lookupAnnotationKeyWithClassname(env, (String)annoKey);
                            break;
                        }
                        if (this.annotationField == null) {
                            this.annotationField = CoreMap.class;
                            break;
                        }
                        throw new IllegalArgumentException("Invalid annotation key " + annoKey);
                    }
                    case "active": {
                        this.active = (Boolean)Expressions.asObject(env, obj);
                        break;
                    }
                    case "ruleType": {
                        this.ruleType = (String)Expressions.asObject(env, obj);
                        break;
                    }
                    case "matchFindType": {
                        this.matchFindType = SequenceMatcher.FindType.valueOf((String)Expressions.asObject(env, obj));
                        break;
                    }
                    case "matchWithResults": {
                        this.matchWithResults = (Boolean)Expressions.asObject(env, obj);
                        break;
                    }
                    case "matchedExpressionGroup": {
                        this.matchedExpressionGroup = ((Number)Expressions.asObject(env, obj)).intValue();
                    }
                }
            }
        }

        @Override
        public boolean extract(S in, List<T> out2) {
            return this.extractRule.extract(in, out2);
        }

        @Override
        public boolean test(T obj) {
            return this.filterRule.test(obj);
        }

        public boolean isMostlyCompatible(AnnotationExtractRule<S, T> aer) {
            return this.stage == aer.stage && Objects.equals(this.annotationField, aer.annotationField) && Objects.equals(this.tokensAnnotationField, aer.tokensAnnotationField) && this.matchedExpressionGroup == 0 && aer.matchedExpressionGroup == 0 && this.matchWithResults == aer.matchWithResults && Objects.equals(this.ruleType, aer.ruleType) && this.isComposite == aer.isComposite && this.active == aer.active && Objects.equals(this.result, aer.result);
        }

        public boolean hasTokensRegexPattern() {
            return this.pattern != null && this.pattern instanceof TokenSequencePattern;
        }
    }

    public static class AssignmentRule
    implements Rule {
        Expression expr;

        public AssignmentRule(AssignableExpression varExpr, Expression value) {
            this.expr = varExpr.assign(value);
        }

        public void evaluate(Env env) {
            this.expr.evaluate(env, new Object[0]);
        }
    }

    public static interface Rule {
    }
}

