/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.matcher;

import edu.stanford.nlp.ling.tokensregex.matcher.ApproxMatch;
import edu.stanford.nlp.ling.tokensregex.matcher.BoundedCostOrderedMap;
import edu.stanford.nlp.ling.tokensregex.matcher.ExactMatchCost;
import edu.stanford.nlp.ling.tokensregex.matcher.Match;
import edu.stanford.nlp.ling.tokensregex.matcher.MatchCostFunction;
import edu.stanford.nlp.ling.tokensregex.matcher.MultiMatch;
import edu.stanford.nlp.ling.tokensregex.matcher.TrieMap;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.Interval;
import edu.stanford.nlp.util.IntervalTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrieMapMatcher<K, V> {
    TrieMap<K, V> root;
    TrieMap<K, V> rootWithDelimiter;
    List<K> multimatchDelimiter;
    public static final Comparator<Match> MATCH_LENGTH_ENDPOINTS_COMPARATOR = Interval.lengthEndpointsComparator();
    public static final Function<Match, Double> MATCH_LENGTH_SCORER = Interval.lengthScorer();
    private static final MatchCostFunction DEFAULT_COST = new ExactMatchCost();
    private static final Comparator<PartialApproxMatch> PARTIAL_MATCH_COMPARATOR = new Comparator<PartialApproxMatch>(){

        @Override
        public int compare(PartialApproxMatch o1, PartialApproxMatch o2) {
            if (o1.cost == o2.cost) {
                if (o1.matched.size() == o2.matched.size()) {
                    int m2;
                    int m1 = o1.multimatches != null ? o1.multimatches.size() : 0;
                    int n = m2 = o2.multimatches != null ? o2.multimatches.size() : 0;
                    if (m1 == m2) {
                        if (o1.begin == o2.begin) {
                            if (o1.end == o2.end) {
                                int i;
                                for (i = 0; i < o1.matched.size(); ++i) {
                                    int comp;
                                    Object x1 = o1.matched.get(i);
                                    Object x2 = o2.matched.get(i);
                                    if (x1 == null || x2 == null || !(x1 instanceof Comparable) || (comp = ((Comparable)x1).compareTo(x2)) == 0) continue;
                                    return comp;
                                }
                                if (o1.multimatches != null && o2.multimatches != null && (i = 0) < o1.multimatches.size()) {
                                    Match mm1 = (Match)o1.multimatches.get(i);
                                    Match mm2 = (Match)o2.multimatches.get(i);
                                    return mm1.getInterval().compareTo(mm2.getInterval());
                                }
                                return 0;
                            }
                            return o1.end < o2.end ? -1 : 1;
                        }
                        return o1.begin < o2.begin ? -1 : 1;
                    }
                    return m1 < m2 ? -1 : 1;
                }
                return o1.matched.size() < o2.matched.size() ? -1 : 1;
            }
            if (Double.isNaN(o1.cost)) {
                return -1;
            }
            if (Double.isNaN(o2.cost)) {
                return 1;
            }
            return o1.cost < o2.cost ? -1 : 1;
        }
    };

    public TrieMapMatcher(TrieMap<K, V> root) {
        this.root = root;
        this.rootWithDelimiter = root;
    }

    public TrieMapMatcher(TrieMap<K, V> root, List<K> multimatchDelimiter) {
        this.root = root;
        this.multimatchDelimiter = multimatchDelimiter;
        if (multimatchDelimiter != null && !multimatchDelimiter.isEmpty()) {
            this.rootWithDelimiter = new TrieMap();
            this.rootWithDelimiter.putChildTrie(multimatchDelimiter, root);
        } else {
            this.rootWithDelimiter = root;
        }
    }

    public List<ApproxMatch<K, V>> findClosestMatches(K[] target, int n) {
        return this.findClosestMatches(Arrays.asList(target), n);
    }

    public List<ApproxMatch<K, V>> findClosestMatches(K[] target, int n, boolean multimatch, boolean keepAlignments) {
        return this.findClosestMatches(Arrays.asList(target), n, multimatch, keepAlignments);
    }

    public List<ApproxMatch<K, V>> findClosestMatches(K[] target, MatchCostFunction<K, V> costFunction, Double maxCost, int n, boolean multimatch, boolean keepAlignments) {
        return this.findClosestMatches(Arrays.asList(target), costFunction, (double)maxCost, n, multimatch, keepAlignments);
    }

    public List<ApproxMatch<K, V>> findClosestMatches(List<K> target, int n) {
        return this.findClosestMatches(target, TrieMapMatcher.<K, V>defaultCost(), Double.MAX_VALUE, n, false, false);
    }

    public List<ApproxMatch<K, V>> findClosestMatches(List<K> target, int n, boolean multimatch, boolean keepAlignments) {
        return this.findClosestMatches(target, TrieMapMatcher.<K, V>defaultCost(), Double.MAX_VALUE, n, multimatch, keepAlignments);
    }

    public List<ApproxMatch<K, V>> findClosestMatches(List<K> target, MatchCostFunction<K, V> costFunction, double maxCost, int n, boolean multimatch, boolean keepAlignments) {
        if (this.root.isEmpty()) {
            return null;
        }
        int extra = 3;
        MatchQueue best = new MatchQueue(n, maxCost);
        List[] prevMatches = null;
        for (int i = 0; i <= target.size(); ++i) {
            List[] curMatches = new List[target.size() + 1 + extra];
            for (int j = 0; j <= target.size() + extra; ++j) {
                if (j > 0) {
                    MatchQueue queue;
                    boolean complete = i == target.size();
                    K t = i > 0 && i <= target.size() ? (K)target.get(i - 1) : null;
                    MatchQueue matchQueue = queue = multimatch ? new MultiMatchQueue(n, maxCost) : new MatchQueue(n, maxCost);
                    if (i > 0) {
                        for (PartialApproxMatch pam : prevMatches[j - 1]) {
                            if (pam.trie == null || pam.trie.children == null) continue;
                            for (Object k : pam.trie.children.keySet()) {
                                this.addToQueue(queue, best, costFunction, pam, t, k, multimatch, complete);
                            }
                        }
                    }
                    for (PartialApproxMatch pam : curMatches[j - 1]) {
                        if (pam.trie == null || pam.trie.children == null) continue;
                        for (Object k : pam.trie.children.keySet()) {
                            this.addToQueue(queue, best, costFunction, pam, null, k, multimatch, complete);
                        }
                    }
                    if (i > 0) {
                        for (PartialApproxMatch pam : prevMatches[j]) {
                            this.addToQueue(queue, best, costFunction, pam, t, null, multimatch, complete);
                        }
                    }
                    curMatches[j] = queue.toSortedList();
                    continue;
                }
                curMatches[0] = new ArrayList();
                if (i > 0) {
                    Object t = i < target.size() ? (Object)target.get(i - 1) : null;
                    for (PartialApproxMatch pam : prevMatches[0]) {
                        PartialApproxMatch npam = pam.withMatch(costFunction, costFunction.cost(t, null, pam.getMatchedLength()), t, null);
                        if (!(npam.cost <= maxCost)) continue;
                        curMatches[0].add(npam);
                    }
                    continue;
                }
                curMatches[0].add(new PartialApproxMatch(0.0, this.root, keepAlignments ? target.size() : 0));
            }
            prevMatches = curMatches;
        }
        ArrayList<ApproxMatch<K, V>> res = new ArrayList<ApproxMatch<K, V>>();
        for (PartialApproxMatch m : best.toSortedList()) {
            res.add(m.toApproxMatch());
        }
        return res;
    }

    public List<Match<K, V>> findAllMatches(K ... list) {
        return this.findAllMatches(Arrays.asList(list));
    }

    public List<Match<K, V>> findAllMatches(List<K> list) {
        return this.findAllMatches(list, 0, list.size());
    }

    public List<Match<K, V>> findAllMatches(List<K> list, int start, int end) {
        ArrayList<Match<K, V>> allMatches = new ArrayList<Match<K, V>>();
        this.updateAllMatches(this.root, allMatches, new ArrayList(), list, start, end);
        return allMatches;
    }

    public List<Match<K, V>> findNonOverlapping(K ... list) {
        return this.findNonOverlapping(Arrays.asList(list));
    }

    public List<Match<K, V>> findNonOverlapping(List<K> list) {
        return this.findNonOverlapping(list, 0, list.size());
    }

    public List<Match<K, V>> findNonOverlapping(List<K> list, int start, int end) {
        return this.findNonOverlapping(list, start, end, MATCH_LENGTH_ENDPOINTS_COMPARATOR);
    }

    public List<Match<K, V>> findNonOverlapping(List<K> list, int start, int end, Comparator<? super Match<K, V>> compareFunc) {
        List<Match<K, V>> allMatches = this.findAllMatches(list, start, end);
        return this.getNonOverlapping(allMatches, compareFunc);
    }

    public List<Match<K, V>> findNonOverlapping(List<K> list, int start, int end, Function<? super Match<K, V>, Double> scoreFunc) {
        List<Match<K, V>> allMatches = this.findAllMatches(list, start, end);
        return this.getNonOverlapping(allMatches, scoreFunc);
    }

    public List<Match<K, V>> segment(K ... list) {
        return this.segment(Arrays.asList(list));
    }

    public List<Match<K, V>> segment(List<K> list) {
        return this.segment(list, 0, list.size());
    }

    public List<Match<K, V>> segment(List<K> list, int start, int end) {
        return this.segment(list, start, end, MATCH_LENGTH_SCORER);
    }

    public List<Match<K, V>> segment(List<K> list, int start, int end, Comparator<? super Match<K, V>> compareFunc) {
        List<Match<K, V>> nonOverlapping = this.findNonOverlapping(list, start, end, compareFunc);
        ArrayList<Match<K, V>> segments = new ArrayList<Match<K, V>>(nonOverlapping.size());
        int last = 0;
        for (Match<K, V> match : nonOverlapping) {
            if (match.begin > last) {
                Match<K, Object> empty = new Match<K, Object>(list.subList(last, match.begin), null, last, match.begin);
                segments.add(empty);
            }
            segments.add(match);
            last = match.end;
        }
        if (list.size() > last) {
            Match<K, Object> empty = new Match<K, Object>(list.subList(last, list.size()), null, last, list.size());
            segments.add(empty);
        }
        return segments;
    }

    public List<Match<K, V>> segment(List<K> list, int start, int end, Function<? super Match<K, V>, Double> scoreFunc) {
        List<Match<K, V>> nonOverlapping = this.findNonOverlapping(list, start, end, scoreFunc);
        ArrayList<Match<K, V>> segments = new ArrayList<Match<K, V>>(nonOverlapping.size());
        int last = 0;
        for (Match<K, V> match : nonOverlapping) {
            if (match.begin > last) {
                Match<K, Object> empty = new Match<K, Object>(list.subList(last, match.begin), null, last, match.begin);
                segments.add(empty);
            }
            segments.add(match);
            last = match.end;
        }
        if (list.size() > last) {
            Match<K, Object> empty = new Match<K, Object>(list.subList(last, list.size()), null, last, list.size());
            segments.add(empty);
        }
        return segments;
    }

    public List<Match<K, V>> segment(List<K> list, Function<? super Match<K, V>, Double> scoreFunc) {
        return this.segment(list, 0, list.size(), scoreFunc);
    }

    public List<Match<K, V>> getNonOverlapping(List<Match<K, V>> allMatches) {
        return this.getNonOverlapping(allMatches, MATCH_LENGTH_ENDPOINTS_COMPARATOR);
    }

    public List<Match<K, V>> getNonOverlapping(List<Match<K, V>> allMatches, Comparator<? super Match<K, V>> compareFunc) {
        if (allMatches.size() > 1) {
            List<Match<K, V>> nonOverlapping = IntervalTree.getNonOverlapping(allMatches, compareFunc);
            Collections.sort(nonOverlapping, HasInterval.ENDPOINTS_COMPARATOR);
            return nonOverlapping;
        }
        return allMatches;
    }

    public List<Match<K, V>> getNonOverlapping(List<Match<K, V>> allMatches, Function<? super Match<K, V>, Double> scoreFunc) {
        return IntervalTree.getNonOverlappingMaxScore(allMatches, scoreFunc);
    }

    protected void updateAllMatches(TrieMap<K, V> trie, List<Match<K, V>> matches, List<K> matched, List<K> list, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.updateAllMatchesWithStart(trie, matches, matched, list, i, end);
        }
    }

    protected void updateAllMatchesWithStart(TrieMap<K, V> trie, List<Match<K, V>> matches, List<K> matched, List<K> list, int start, int end) {
        K key;
        TrieMap child;
        if (start > end) {
            return;
        }
        if (trie.children != null && start < end && (child = trie.children.get(key = list.get(start))) != null) {
            ArrayList<K> p = new ArrayList<K>(matched.size() + 1);
            p.addAll(matched);
            p.add(key);
            this.updateAllMatchesWithStart(child, matches, p, list, start + 1, end);
        }
        if (trie.isLeaf()) {
            matches.add(new Match(matched, trie.value, start - matched.size(), start));
        }
    }

    private boolean addToQueue(MatchQueue<K, V> queue, MatchQueue<K, V> best, MatchCostFunction<K, V> costFunction, PartialApproxMatch<K, V> pam, K a, K b, boolean multimatch, boolean complete) {
        double deltaCost = costFunction.cost(a, b, pam.getMatchedLength());
        double newCost = pam.cost + deltaCost;
        if (queue.maxCost != Double.MAX_VALUE && newCost > queue.maxCost) {
            return false;
        }
        if (best.size() >= queue.maxSize && newCost > best.topCost()) {
            return false;
        }
        PartialApproxMatch npam = ((PartialApproxMatch)pam).withMatch(costFunction, deltaCost, a, b);
        if (!multimatch || npam.trie != null && npam.trie.children != null) {
            if (!multimatch && complete && npam.value != null) {
                best.add(npam);
            }
            queue.add(npam);
        }
        if (multimatch && npam.value != null) {
            npam = ((PartialApproxMatch)pam).withMatch(costFunction, deltaCost, a, b, multimatch, this.rootWithDelimiter);
            if (complete && npam.value != null) {
                best.add(npam);
            }
            queue.add(npam);
        }
        return true;
    }

    public static <K, V> MatchCostFunction<K, V> defaultCost() {
        return (MatchCostFunction)ErasureUtils.uncheckedCast(DEFAULT_COST);
    }

    public static <K, V> Comparator<PartialApproxMatch<K, V>> partialMatchComparator() {
        return (Comparator)ErasureUtils.uncheckedCast(PARTIAL_MATCH_COMPARATOR);
    }

    private static class MultiMatchQueue<K, V>
    extends MatchQueue<K, V> {
        private final Map<Integer, BoundedCostOrderedMap<Match<K, V>, PartialApproxMatch<K, V>>> multimatchQueues = new HashMap<Integer, BoundedCostOrderedMap<Match<K, V>, PartialApproxMatch<K, V>>>();

        public MultiMatchQueue(int maxSize, double maxCost) {
            super(maxSize, maxCost);
        }

        @Override
        public void add(PartialApproxMatch<K, V> pam) {
            BoundedCostOrderedMap mq;
            MultiMatch m = new MultiMatch(pam.matched, pam.value, pam.begin, pam.end, pam.multimatches);
            Integer key = pam.multimatches != null ? pam.multimatches.size() : 0;
            if (pam.value == null) {
                key = key + 1;
            }
            if ((mq = this.multimatchQueues.get(key)) == null) {
                mq = new BoundedCostOrderedMap(this.MATCH_COST_FUNCTION, this.maxSize, this.maxCost);
                this.multimatchQueues.put(key, mq);
            }
            mq.put(m, pam);
        }

        @Override
        public double topCost() {
            double cost = Double.MIN_VALUE;
            for (BoundedCostOrderedMap<Match<K, V>, PartialApproxMatch<K, V>> q : this.multimatchQueues.values()) {
                if (!(q.topCost() > cost)) continue;
                cost = q.topCost();
            }
            return cost;
        }

        @Override
        public int size() {
            int sz = 0;
            for (BoundedCostOrderedMap<Match<K, V>, PartialApproxMatch<K, V>> q : this.multimatchQueues.values()) {
                sz += q.size();
            }
            return sz;
        }

        @Override
        public List<PartialApproxMatch<K, V>> toSortedList() {
            ArrayList<PartialApproxMatch<K, V>> all = new ArrayList<PartialApproxMatch<K, V>>(this.size());
            for (BoundedCostOrderedMap<Match<K, V>, PartialApproxMatch<K, V>> q : this.multimatchQueues.values()) {
                all.addAll(q.valuesList());
            }
            Collections.sort(all, TrieMapMatcher.partialMatchComparator());
            return all;
        }
    }

    private static class MatchQueue<K, V> {
        private final BoundedCostOrderedMap<Match<K, V>, PartialApproxMatch<K, V>> queue;
        protected final int maxSize;
        protected final double maxCost;
        public final Function<PartialApproxMatch<K, V>, Double> MATCH_COST_FUNCTION = new Function<PartialApproxMatch<K, V>, Double>(){

            @Override
            public Double apply(PartialApproxMatch<K, V> in) {
                return in.cost;
            }
        };

        public MatchQueue(int maxSize, double maxCost) {
            this.maxSize = maxSize;
            this.maxCost = maxCost;
            this.queue = new BoundedCostOrderedMap(this.MATCH_COST_FUNCTION, maxSize, maxCost);
        }

        public void add(PartialApproxMatch<K, V> pam) {
            ArrayList multiMatchesWithoutOffsets = null;
            if (pam.multimatches != null) {
                multiMatchesWithoutOffsets = new ArrayList(pam.multimatches.size());
                for (Match m : pam.multimatches) {
                    multiMatchesWithoutOffsets.add(new Match(m.matched, m.value, 0, 0));
                }
            }
            MultiMatch m = new MultiMatch(pam.matched, pam.value, pam.begin, pam.end, multiMatchesWithoutOffsets);
            this.queue.put(m, pam);
        }

        public double topCost() {
            return this.queue.topCost();
        }

        public int size() {
            return this.queue.size();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public List<PartialApproxMatch<K, V>> toSortedList() {
            List<PartialApproxMatch<K, V>> res = this.queue.valuesList();
            Collections.sort(res, TrieMapMatcher.partialMatchComparator());
            return res;
        }
    }

    private static class PartialApproxMatch<K, V>
    extends ApproxMatch<K, V> {
        TrieMap<K, V> trie;
        int lastMultimatchedMatchedStartIndex = 0;
        int lastMultimatchedOriginalStartIndex = 0;

        private PartialApproxMatch() {
        }

        private PartialApproxMatch(double cost, TrieMap<K, V> trie, int alignmentLength) {
            this.trie = trie;
            this.cost = cost;
            Object object = this.value = trie != null ? (Object)this.trie.value : null;
            if (alignmentLength > 0) {
                this.alignments = new Interval[alignmentLength];
            }
        }

        private PartialApproxMatch<K, V> withMatch(MatchCostFunction<K, V> costFunction, double deltaCost, K t, K k) {
            PartialApproxMatch<K, V> res = new PartialApproxMatch<K, V>();
            res.matched = this.matched;
            if (k != null) {
                if (res.matched == null) {
                    res.matched = new ArrayList(1);
                } else {
                    res.matched = new ArrayList(this.matched.size() + 1);
                    res.matched.addAll(this.matched);
                }
                res.matched.add(k);
            }
            res.begin = this.begin;
            res.end = t != null ? this.end + 1 : this.end;
            res.cost = this.cost + deltaCost;
            res.trie = k != null ? this.trie.getChildTrie(k) : this.trie;
            res.value = res.trie != null ? res.trie.value : null;
            res.multimatches = this.multimatches;
            res.lastMultimatchedMatchedStartIndex = this.lastMultimatchedMatchedStartIndex;
            res.lastMultimatchedOriginalStartIndex = this.lastMultimatchedOriginalStartIndex;
            if (res.lastMultimatchedOriginalStartIndex == this.end && k == null && t != null) {
                ++res.lastMultimatchedOriginalStartIndex;
            }
            if (this.alignments != null) {
                res.alignments = new Interval[this.alignments.length];
                System.arraycopy(this.alignments, 0, res.alignments, 0, this.alignments.length);
                if (k != null && res.end > 0) {
                    int p = res.end - 1;
                    res.alignments[p] = res.alignments[p] == null ? Interval.toInterval(res.matched.size() - 1, res.matched.size()) : Interval.toInterval(res.alignments[p].getBegin(), (Integer)res.alignments[p].getEnd() + 1);
                }
            }
            return res;
        }

        private ApproxMatch<K, V> toApproxMatch() {
            return new ApproxMatch(this.matched, this.value, this.begin, this.end, this.multimatches, this.cost, this.alignments);
        }

        private PartialApproxMatch<K, V> withMatch(MatchCostFunction<K, V> costFunction, double deltaCost, K t, K k, boolean multimatch, TrieMap<K, V> root) {
            PartialApproxMatch<K, V> res = this.withMatch(costFunction, deltaCost, t, k);
            if (multimatch && res.matched != null && res.value != null) {
                if (res.multimatches == null) {
                    res.multimatches = new ArrayList(1);
                } else {
                    res.multimatches = new ArrayList(this.multimatches.size() + 1);
                    res.multimatches.addAll(this.multimatches);
                }
                List newlyMatched = res.matched.subList(this.lastMultimatchedMatchedStartIndex, res.matched.size());
                res.multimatches.add(new Match(newlyMatched, res.value, this.lastMultimatchedOriginalStartIndex, res.end));
                res.cost += costFunction.multiMatchDeltaCost(newlyMatched, res.value, this.multimatches, res.multimatches);
                res.lastMultimatchedMatchedStartIndex = res.matched.size();
                res.lastMultimatchedOriginalStartIndex = res.end;
                res.trie = root;
            }
            return res;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PartialApproxMatch that = (PartialApproxMatch)o;
            if (this.lastMultimatchedMatchedStartIndex != that.lastMultimatchedMatchedStartIndex) {
                return false;
            }
            if (this.lastMultimatchedOriginalStartIndex != that.lastMultimatchedOriginalStartIndex) {
                return false;
            }
            return !(this.trie != null ? !this.trie.equals(that.trie) : that.trie != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.lastMultimatchedMatchedStartIndex;
            result = 31 * result + this.lastMultimatchedOriginalStartIndex;
            return result;
        }
    }
}

