import * as React from 'react';
import { Icon, IconProps } from '../../icon';

const SaveIcon = React.forwardRef<SVGSVGElement, IconProps>((props, ref) => {
  return (
    <Icon {...props}>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        width="19"
        height="18"
        viewBox="0 0 19 18"
        fill="none">
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M11.8978 3.31241C11.8121 3.29183 11.715 3.2885 11.3516 3.2885H6.59236C6.58075 3.2885 6.56921 3.2885 6.55774 3.2885V5.12311C6.55774 5.32554 6.55815 5.44614 6.56545 5.53553C6.56991 5.59009 6.57579 5.61302 6.5777 5.61917C6.59398 5.65007 6.61924 5.67533 6.65014 5.69161C6.65629 5.69352 6.67922 5.6994 6.73378 5.70386C6.82318 5.71116 6.94377 5.71157 7.1462 5.71157H11.8539C12.0563 5.71157 12.1769 5.71116 12.2663 5.70386C12.3209 5.6994 12.3438 5.69352 12.3499 5.69161C12.3808 5.67533 12.4061 5.65007 12.4224 5.61917C12.4243 5.61302 12.4302 5.59009 12.4346 5.53553C12.4419 5.44614 12.4423 5.32554 12.4423 5.12311V3.67708C12.2715 3.5079 12.2112 3.45479 12.1479 3.41602C12.0705 3.36857 11.9861 3.33361 11.8978 3.31241ZM13.4808 4.7151L13.4808 5.14127C13.4808 5.31952 13.4808 5.48324 13.4696 5.62009C13.4576 5.76765 13.43 5.92907 13.3488 6.08852C13.2326 6.31648 13.0473 6.50182 12.8193 6.61798C12.6598 6.69922 12.4984 6.72681 12.3509 6.73887C12.214 6.75005 12.0503 6.75004 11.872 6.75003H7.12806C6.9498 6.75004 6.78608 6.75005 6.64922 6.73887C6.50166 6.72681 6.34024 6.69922 6.18079 6.61798C5.95283 6.50182 5.76749 6.31648 5.65133 6.08852C5.57009 5.92907 5.5425 5.76765 5.53044 5.62009C5.51926 5.48323 5.51927 5.31951 5.51928 5.14125C5.51928 5.13522 5.51928 5.12917 5.51928 5.12311V3.30028C5.43025 3.30395 5.34774 3.30876 5.27053 3.31507C4.9563 3.34074 4.77577 3.3886 4.63903 3.45827C4.34593 3.60762 4.10764 3.84591 3.9583 4.13901C3.88862 4.27575 3.84076 4.45628 3.81509 4.7705C3.78892 5.09078 3.78852 5.50218 3.78852 6.09233V11.9077C3.78852 12.4979 3.78892 12.9093 3.81509 13.2295C3.84076 13.5438 3.88862 13.7243 3.9583 13.861C4.10764 14.1541 4.34593 14.3924 4.63903 14.5418C4.77577 14.6114 4.9563 14.6593 5.27053 14.685C5.34774 14.6913 5.43025 14.6961 5.51928 14.6998L5.51928 10.7819C5.51927 10.6036 5.51926 10.4399 5.53044 10.303C5.5425 10.1555 5.57009 9.99405 5.65133 9.8346C5.76749 9.60664 5.95283 9.4213 6.18079 9.30515C6.34024 9.22391 6.50166 9.19631 6.64922 9.18425C6.78607 9.17307 6.94979 9.17308 7.12804 9.17309H11.872C12.0503 9.17308 12.214 9.17307 12.3509 9.18425C12.4984 9.19631 12.6598 9.22391 12.8193 9.30515C13.0473 9.4213 13.2326 9.60664 13.3488 9.83461C13.43 9.99405 13.4576 10.1555 13.4696 10.303C13.4808 10.4399 13.4808 10.6036 13.4808 10.7819L13.4808 14.6998C13.5698 14.6961 13.6523 14.6913 13.7296 14.685C14.0438 14.6593 14.2243 14.6114 14.3611 14.5418C14.6542 14.3924 14.8924 14.1541 15.0418 13.861C15.1115 13.7243 15.1593 13.5438 15.185 13.2295C15.2112 12.9093 15.2116 12.4979 15.2116 11.9077V7.14844C15.2116 6.78506 15.2082 6.688 15.1877 6.6023C15.1665 6.514 15.1315 6.42959 15.084 6.35216C15.038 6.27702 14.9717 6.20602 14.7148 5.94908L13.4808 4.7151ZM13.0004 15.7486C13.3106 15.7461 13.5799 15.7391 13.8141 15.72C14.1926 15.6891 14.525 15.6237 14.8325 15.467C15.321 15.2181 15.7182 14.821 15.9671 14.3325C16.1238 14.0249 16.1891 13.6925 16.22 13.3141C16.25 12.9466 16.25 12.4927 16.25 11.9299V7.14844C16.25 7.1315 16.25 7.11478 16.25 7.09826C16.2502 6.80845 16.2503 6.58032 16.1974 6.35988C16.1508 6.16562 16.0739 5.97991 15.9695 5.80957C15.851 5.61627 15.6896 5.45505 15.4846 5.25024C15.4729 5.23857 15.461 5.22675 15.4491 5.21478L13.2853 3.05099C13.2733 3.03902 13.2615 3.02719 13.2498 3.0155C13.045 2.81045 12.8838 2.64904 12.6905 2.53059C12.5202 2.4262 12.3344 2.34928 12.1402 2.30264C11.9197 2.24972 11.6916 2.24985 11.4018 2.25002C11.3853 2.25003 11.3686 2.25004 11.3516 2.25004L6.57013 2.25004C6.39283 2.25004 6.22633 2.25003 6.06993 2.25097C6.05954 2.25035 6.04906 2.25004 6.03851 2.25004C6.02546 2.25004 6.01253 2.25052 5.99972 2.25147C5.68951 2.25398 5.42021 2.26092 5.18596 2.28006C4.80752 2.31098 4.47512 2.3763 4.16758 2.533C3.67909 2.7819 3.28193 3.17906 3.03302 3.66756C2.87633 3.97509 2.811 4.3075 2.78008 4.68594C2.75005 5.05349 2.75006 5.50738 2.75006 6.07011V11.9299C2.75006 12.4927 2.75005 12.9465 2.78008 13.3141C2.811 13.6925 2.87633 14.0249 3.03302 14.3325C3.28193 14.821 3.67909 15.2181 4.16758 15.467C4.47512 15.6237 4.80752 15.6891 5.18596 15.72C5.42021 15.7391 5.68951 15.7461 5.99972 15.7486C6.01253 15.7495 6.02546 15.75 6.03851 15.75C6.04906 15.75 6.05954 15.7497 6.06993 15.7491C6.22632 15.75 6.39282 15.75 6.57012 15.75H12.43C12.6073 15.75 12.7738 15.75 12.9302 15.7491C12.9405 15.7497 12.951 15.75 12.9616 15.75C12.9746 15.75 12.9876 15.7495 13.0004 15.7486ZM12.4423 14.7115V10.8C12.4423 10.5976 12.4419 10.477 12.4346 10.3876C12.4302 10.333 12.4243 10.3101 12.4224 10.3039C12.4061 10.273 12.3808 10.2478 12.3499 10.2315C12.3438 10.2296 12.3209 10.2237 12.2663 10.2193C12.1769 10.212 12.0563 10.2116 11.8539 10.2116H7.1462C6.94377 10.2116 6.82318 10.212 6.73378 10.2193C6.67921 10.2237 6.65628 10.2296 6.65014 10.2315C6.61923 10.2478 6.59398 10.273 6.5777 10.304C6.57579 10.3101 6.56991 10.333 6.56545 10.3876C6.55815 10.477 6.55774 10.5976 6.55774 10.8V14.7115C6.56921 14.7115 6.58075 14.7115 6.59236 14.7115H12.4077C12.4193 14.7115 12.4309 14.7115 12.4423 14.7115ZM6.57832 10.3022C6.57833 10.3022 6.57821 10.3025 6.57794 10.3032L6.57832 10.3022ZM6.64835 10.2321C6.64833 10.2321 6.64865 10.232 6.64938 10.2318L6.64835 10.2321ZM12.3517 10.2321C12.3517 10.2321 12.3513 10.232 12.3507 10.2317L12.3517 10.2321ZM12.4218 10.3022C12.4218 10.3022 12.4219 10.3025 12.4222 10.3033L12.4218 10.3022ZM12.4218 5.62096C12.4218 5.62094 12.4219 5.62057 12.4221 5.61992L12.4218 5.62096ZM12.3507 5.69137C12.3514 5.6911 12.3517 5.69098 12.3517 5.69099L12.3507 5.69137ZM6.6494 5.69137C6.64865 5.69113 6.64833 5.69099 6.64835 5.69099L6.6494 5.69137ZM6.57793 5.61991C6.57821 5.62057 6.57833 5.62095 6.57832 5.62096L6.57793 5.61991Z"
          fill="white"
        />
      </svg>
    </Icon>
  );
});

export { SaveIcon };
