import * as React from 'react';
import { Icon, IconProps } from '../../icon';

const Phone = React.forwardRef<SVGSVGElement, IconProps>((props, ref) => {
  return (
    <Icon {...props}>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        width="20"
        height="20"
        viewBox="0 0 20 20"
        fill="none">
        <path
          d="M8.75 15.625C8.40482 15.625 8.125 15.9048 8.125 16.25C8.125 16.5952 8.40482 16.875 8.75 16.875H11.25C11.5952 16.875 11.875 16.5952 11.875 16.25C11.875 15.9048 11.5952 15.625 11.25 15.625H8.75Z"
          fill="#3E5CFA"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M7.1875 0.625C5.6342 0.625 4.375 1.8842 4.375 3.4375V16.5625C4.375 18.1158 5.6342 19.375 7.1875 19.375H12.8125C14.3658 19.375 15.625 18.1158 15.625 16.5625V3.4375C15.625 1.8842 14.3658 0.625 12.8125 0.625H7.1875ZM6.25 3.4375C6.25 2.91973 6.66973 2.5 7.1875 2.5H8.125V2.8125C8.125 3.33027 8.54473 3.75 9.0625 3.75H10.9375C11.4553 3.75 11.875 3.33027 11.875 2.8125V2.5H12.8125C13.3303 2.5 13.75 2.91973 13.75 3.4375V16.5625C13.75 17.0803 13.3303 17.5 12.8125 17.5H7.1875C6.66973 17.5 6.25 17.0803 6.25 16.5625V3.4375Z"
          fill="#3E5CFA"
        />
      </svg>
    </Icon>
  );
});

export { Phone };
