import * as React from 'react';
import { Icon, IconProps } from '../../icon';

const Discord = React.forwardRef<SVGSVGElement, IconProps>((props, ref) => {
  return (
    <Icon {...props}>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none">
        <path
          d="M19.3237 4.95519C19.3179 4.94321 19.3082 4.93382 19.2964 4.9287C17.9313 4.26682 16.4907 3.79485 15.0107 3.5246C14.9973 3.52195 14.9834 3.52386 14.971 3.53004C14.9587 3.53622 14.9485 3.54637 14.9419 3.55903C14.7457 3.93527 14.5677 4.32174 14.4084 4.71695C12.813 4.46103 11.1903 4.46103 9.59492 4.71695C9.43457 4.32073 9.25365 3.93417 9.05298 3.55903C9.0461 3.54664 9.03585 3.53673 9.02356 3.53059C9.01127 3.52445 8.99751 3.52236 8.98409 3.5246C7.50395 3.79428 6.06329 4.26629 4.69838 4.92874C4.6867 4.93398 4.67684 4.94291 4.67017 4.95432C1.94061 9.26201 1.19288 13.4638 1.55969 17.6135C1.56073 17.6237 1.56368 17.6335 1.56839 17.6425C1.57309 17.6514 1.57945 17.6593 1.58709 17.6655C3.17648 18.9092 4.95424 19.8585 6.84449 20.4729C6.85781 20.4771 6.87202 20.4769 6.88523 20.4723C6.89843 20.4678 6.91 20.459 6.91836 20.4473C7.32435 19.8635 7.68408 19.2454 7.99391 18.5991C7.99817 18.5902 8.0006 18.5805 8.00104 18.5706C8.00148 18.5607 7.99993 18.5507 7.99648 18.5415C7.99304 18.5322 7.98777 18.5239 7.98104 18.5169C7.97431 18.51 7.96626 18.5046 7.95742 18.5012C7.39015 18.2718 6.84096 17.9953 6.31501 17.6742C6.30546 17.6683 6.29743 17.66 6.29165 17.65C6.28586 17.64 6.28249 17.6287 6.28184 17.617C6.28118 17.6053 6.28326 17.5936 6.28789 17.583C6.29252 17.5723 6.29956 17.563 6.30839 17.556C6.41906 17.4686 6.52781 17.3786 6.63456 17.2859C6.64392 17.2777 6.65525 17.2725 6.66727 17.2708C6.67929 17.2691 6.69152 17.271 6.70259 17.2762C10.1483 18.938 13.8787 18.938 17.2836 17.2762C17.2947 17.2706 17.3071 17.2685 17.3193 17.2701C17.3315 17.2716 17.343 17.2768 17.3525 17.285C17.4594 17.3782 17.5684 17.4685 17.6795 17.556C17.6884 17.563 17.6955 17.5722 17.7002 17.5828C17.7049 17.5934 17.7071 17.605 17.7065 17.6167C17.7059 17.6284 17.7026 17.6398 17.6969 17.6498C17.6912 17.6599 17.6832 17.6682 17.6737 17.6742C17.149 17.998 16.5993 18.2743 16.0305 18.5003C16.0217 18.5039 16.0137 18.5093 16.007 18.5164C16.0003 18.5234 15.9951 18.5319 15.9917 18.5412C15.9883 18.5506 15.9869 18.5605 15.9874 18.5705C15.9879 18.5805 15.9904 18.5902 15.9947 18.5991C16.3097 19.2418 16.6689 19.8592 17.0694 20.4463C17.0776 20.4583 17.0891 20.4674 17.1023 20.4721C17.1156 20.4769 17.1299 20.4771 17.1433 20.4728C19.037 19.8604 20.8178 18.9111 22.4092 17.6655C22.417 17.6596 22.4234 17.6519 22.4281 17.6431C22.4329 17.6343 22.4357 17.6245 22.4366 17.6144C22.8757 12.8169 21.7014 8.64952 19.3237 4.95519ZM8.50849 15.0868C7.47109 15.0868 6.61629 14.0807 6.61629 12.8451C6.61629 11.6096 7.45451 10.6034 8.50849 10.6034C9.57072 10.6034 10.4172 11.6183 10.4007 12.845C10.4007 14.0807 9.56241 15.0868 8.50849 15.0868ZM15.5045 15.0868C14.4672 15.0868 13.6124 14.0807 13.6124 12.8451C13.6124 11.6096 14.4506 10.6034 15.5045 10.6034C16.5668 10.6034 17.4133 11.6183 17.3967 12.845C17.3967 14.0807 16.5668 15.0868 15.5045 15.0868Z"
          fill="#6D7175"
        />
      </svg>
    </Icon>
  );
});

export { Discord };
