import type { Config } from 'tailwindcss';
import type { PluginAPI } from 'tailwindcss/types/config';
const plugin = require('tailwindcss/plugin');
import token from './token';

// We want each package to be responsible for its own content.
const config: Omit<Config, 'content' | 'plugins'> = {
  future: {
    hoverOnlyWhenSupported: true,
  },
  ...token,
  plugins: [
    require('@tailwindcss/typography'),
    require('tailwindcss-animate'),
    plugin(({ addBase }: PluginAPI) => {
      addBase({
        ':root': {
          /* basic */
          '--black': '#000000',
          '--white': '#ffffff',
          '--none': '#ffffff00',

          /* flow line/point */
          '--flow-color-01': '#A3A3A3',
          '--flow-color-02': '#2E90FA',
          '--flow-color-03': '#86CB3C',
          '--flow-color-04': '#22CCEE',
          '--flow-color-05': '#2ED3B7',
          '--flow-color-06': '#F03838',
          '--flow-color-07': '#6938EF',
          '--flow-color-08': '#EF20EF',
          '--flow-color-09': '#FAC515',
          '--flow-color-10': '#AC40FF',

          /* neutral */
          '--neutral': ' #1a1c1d',
          '--neutral-10': ' #202223',
          '--neutral-20': ' #323436',
          '--neutral-30': ' #414345',
          '--neutral-40': ' #5c5f62',
          '--neutral-50': ' #6d7175',
          '--neutral-60': ' #8c9196',
          '--neutral-70': ' #c9ccd0',
          '--neutral-75': ' #dbdddf',
          '--neutral-80': ' #e4e5e7',
          '--neutral-85': ' #edeeef',
          '--neutral-90': ' #f1f2f3',
          '--neutral-95': ' #f6f6f7',
          '--neutral-99': ' #fafafb',

          '--neutral-variant': ' #17191c',
          '--neutral-variant-5': ' #27292c',
          '--neutral-variant-10': ' #323539',
          '--neutral-variant-15': ' #42454a',
          '--neutral-variant-20': ' #363f4d',
          '--neutral-variant-30': ' #444f61',
          '--neutral-variant-35': ' #4f5c70',
          '--neutral-variant-40': ' #9da1a6',
          '--neutral-variant-50': ' #b6babf',
          '--neutral-variant-60': ' #cdd2d8',
          '--neutral-variant-70': ' #dadfe5',
          '--neutral-variant-80': ' #e4e9f0',
          '--neutral-variant-85': ' #edf0f5',
          '--neutral-variant-88': ' #e5effd',
          '--neutral-variant-90': ' #edf4fe',
          '--neutral-variant-95': ' #f2f7fe',
          '--neutral-variant-99': ' #f5f7fa',

          '--neutral-dark': ' #17181c',
          '--neutral-dark-5': ' #1b1c21',
          '--neutral-dark-10': ' #27282c',
          '--neutral-dark-15': ' #2d2e33',
          '--neutral-dark-20': ' #323339',
          '--neutral-dark-25': ' #42434a',
          '--neutral-dark-30': ' #54565e',
          '--neutral-dark-40': ' #666873',
          '--neutral-dark-50': ' #797b87',
          '--neutral-dark-60': ' #868996',
          '--neutral-dark-70': ' #9699a8',
          '--neutral-dark-80': ' #a6a9ba',
          '--neutral-dark-85': ' #b8bccf',
          '--neutral-dark-90': ' #cacfe3',
          '--neutral-dark-95': ' #d4d8ed',
          '--neutral-dark-99': ' #e1e6fc',

          '--neutral-dark-special': ' #1c1e26',
          '--neutral-dark-special-5': ' #22242e',
          '--neutral-dark-special-10': ' #232533',
          '--neutral-dark-special-20': ' #2b2e3b',
          '--neutral-dark-special-30': ' #383c52',
          '--neutral-dark-special-40': ' #464b66',

          '--blue': ' #0b1964',
          '--blue-5': ' #0e2494',
          '--blue-10': ' #1b35b6',
          '--blue-15': ' #1b39cf',
          '--blue-20': ' #2b48d8',
          '--blue-30': ' #3e5cfa',
          '--blue-40': ' #5974ff',
          '--blue-50': ' #788eff',
          '--blue-60': ' #95a6ff',
          '--blue-70': ' #ccd4ff',
          '--blue-80': ' #e0e5ff',
          '--blue-90': ' #ecefff',
          '--blue-95': ' #f2f4fe',

          '--blue-dark-10': ' #292c38',
          '--blue-dark-20': ' #2c334f',
          '--blue-dark-30': ' #2b3561',
          '--blue-dark-40': ' #2d3770',
          '--blue-dark-50': ' #354285',

          '--red': ' #6c0f00',
          '--red-10': ' #a21b00',
          '--red-20': ' #bc2200',
          '--red-25': ' #cf371c',
          '--red-30': ' #d72c0d',
          '--red-40': ' #ec2f0d',
          '--red-50': ' #fd5749',
          '--red-55': ' #ff5353',
          '--red-60': ' #febcb9',
          '--red-70': ' #fed3d1',
          '--red-80': ' #ffe9e8',
          '--red-90': ' #fff0f0',
          '--red-95': ' #fff4f4',

          '--red-dark-10': ' #382a29',
          '--red-dark-20': ' #4f2e2c',
          '--red-dark-30': ' #612e2b',

          '--yellow': ' #403624',
          '--yellow-5': ' #7e5700',
          '--yellow-10': ' #b98900',
          '--yellow-15': ' #cf9e1b',
          '--yellow-20': ' #e8a900',
          '--yellow-30': ' #fda500',
          '--yellow-35': ' #e1b878',
          '--yellow-40': ' #ffc453',
          '--yellow-50': ' #ffd06a',
          '--yellow-60': ' #ffd79d',
          '--yellow-70': ' #ffe6bb',
          '--yellow-80': ' #ffebd3',
          '--yellow-90': ' #fff2e2',
          '--yellow-95': ' #fff5ea',

          '--yellow-dark-10': ' #383029',
          '--yellow-dark-20': ' #4f3e2c',
          '--yellow-dark-30': ' #61472b',

          '--green': ' #005231',
          '--green-10': ' #006d41',
          '--green-20': ' #0bb26f',
          '--green-25': ' #1bcf75',
          '--green-30': ' #0dcc7f',
          '--green-40': ' #12d687',
          '--green-50': ' #18ce79',
          '--green-60': ' #86f7be',
          '--green-70': ' #baf9d9',
          '--green-80': ' #d9fae9',
          '--green-90': ' #e6faf0',
          '--green-95': ' #f2faf6',

          '--green-dark-10': ' #293830',
          '--green-dark-20': ' #2c4f3e',
          '--green-dark-30': ' #2b6147',

          '--aqua': ' #243640',
          '--aqua-5': ' #093852',
          '--aqua-10': ' #0f5c85',
          '--aqua-20': ' #2980af',
          '--aqua-25': ' #1b93cf',
          '--aqua-30': ' #2096d6',
          '--aqua-40': ' #0da8fc',
          '--aqua-50': ' #5dc4fc',
          '--aqua-55': ' #6acbff',
          '--aqua-60': ' #95d8fc',
          '--aqua-70': ' #b8e4fc',
          '--aqua-75': ' #c7ebff',
          '--aqua-80': ' #d6f0ff',
          '--aqua-90': ' #e0f4ff',
          '--aqua-95': ' #f0faff',

          '--aqua-dark-10': ' #293338',
          '--aqua-dark-20': ' #2c434f',
          '--aqua-dark-30': ' #2b4f61',

          '--lemon': ' #24210b',
          '--lemon-20': ' #454127',
          '--lemon-40': ' #8f7d1a',
          '--lemon-50': ' #a48f07',
          '--lemon-60': ' #cfaf00',
          '--lemon-70': ' #f3d42d',
          '--lemon-80': ' #ffe86b',
          '--lemon-90': ' #fdf5ca',

          /* opaque black */
          '--opaque-black-1': ' #00000003',
          '--opaque-black-3': ' #00000008',
          '--opaque-black-5': ' #0000000d',
          '--opaque-black-8': ' #00000014',
          '--opaque-black-10': ' #0000001a',
          '--opaque-black-20': ' #00000033',
          '--opaque-black-30': ' #0000004d',
          '--opaque-black-40': ' #00000066',
          '--opaque-black-50': ' #00000080',
          '--opaque-black-60': ' #00000099',
          '--opaque-black-70': ' #000000b2',
          '--opaque-black-75': ' #000000bf',
          '--opaque-black-80': ' #000000cc',
          '--opaque-black-90': ' #000000e5',
          '--opaque-black-100': ' #000000',

          /* opaque white */
          '--opaque-white-1': ' #ffffff03',
          '--opaque-white-3': ' #ffffff08',
          '--opaque-white-5': ' #ffffff0d',
          '--opaque-white-8': ' #ffffff14',
          '--opaque-white-10': ' #ffffff1a',
          '--opaque-white-20': ' #ffffff33',
          '--opaque-white-30': ' #ffffff4d',
          '--opaque-white-40': ' #ffffff66',
          '--opaque-white-50': ' #ffffff80',
          '--opaque-white-60': ' #ffffff99',
          '--opaque-white-70': ' #ffffffb2',
          '--opaque-white-75': ' #ffffffbf',
          '--opaque-white-80': ' #ffffffcc',
          '--opaque-white-90': ' #ffffffe5',
          '--opaque-white-100': ' #ffffff',

          //alpha black
          '--alpha-black-1': '#00000003',
          '--alpha-black-3': '#00000008',
          '--alpha-black-5': '#0000000d',
          '--alpha-black-8': '#00000014',
          '--alpha-black-10': '#0000001a',
          '--alpha-black-20': '#00000033',
          '--alpha-black-30': '#0000004d',
          '--alpha-black-40': '#00000066',
          '--alpha-black-50': '#00000080',
          '--alpha-black-60': '#00000099',
          '--alpha-black-70': '#000000b2',
          '--alpha-black-75': '#000000bf',
          '--alpha-black-80': '#000000cc',
          '--alpha-black-90': '#000000e5',
          '--alpha-black-100': '#000000',

          //alpha white
          '--alpha-white-1': '#ffffff03',
          '--alpha-white-3': '#ffffff08',
          '--alpha-white-5': '#ffffff0d',
          '--alpha-white-8': '#ffffff14',
          '--alpha-white-10': '#ffffff1a',
          '--alpha-white-20': '#ffffff33',
          '--alpha-white-30': '#ffffff4d',
          '--alpha-white-40': '#ffffff66',
          '--alpha-white-50': '#ffffff80',
          '--alpha-white-60': '#ffffff99',
          '--alpha-white-70': '#ffffffb2',
          '--alpha-white-75': '#ffffffbf',
          '--alpha-white-80': '#ffffffcc',
          '--alpha-white-90': '#ffffffe5',
          '--alpha-white-100': '#ffffff',

          /* status */
          '--status-01-10': ' #f4f2ff',
          '--status-01-20': ' #ece9ff',
          '--status-01-30': ' #d8d1ff',
          '--status-01-40': ' #c1b5ff',
          '--status-01-50': ' #a895ff',
          '--status-01-60': ' #896bff',
          '--status-01-70': ' #621bff',
          '--status-01-80': ' #5919e9',
          '--status-01-90': ' #5016d0',
          '--status-01-100': ' #4513b4',
          '--status-01-110': ' #391093',
          '--status-01-120': ' #280b68',

          '--status-02-10': ' #f2fff9',
          '--status-02-20': ' #e9fff5',
          '--status-02-30': ' #d1ffea',
          '--status-02-40': ' #b6ffe0',
          '--status-02-50': ' #96ffd4',
          '--status-02-60': ' #6cffc8',
          '--status-02-70': ' #1bf7b4',
          '--status-02-80': ' #1de9ab',
          '--status-02-90': ' #1ad099',
          '--status-02-100': ' #17b484',
          '--status-02-110': ' #12936c',
          '--status-02-120': ' #0d684c',

          '--status-03-10': ' #fdf3ff',
          '--status-03-20': ' #fbeaff',
          '--status-03-30': ' #f7d3ff',
          '--status-03-40': ' #f3baff',
          '--status-03-50': ' #ef9cff',
          '--status-03-60': ' #ea77ff',
          '--status-03-70': ' #e640ff',
          '--status-03-80': ' #d23ae9',
          '--status-03-90': ' #bc34d0',
          '--status-03-100': ' #a32db4',
          '--status-03-110': ' #852593',
          '--status-03-120': ' #5e1a68',

          '--status-04-10': ' #f3f6ff',
          '--status-04-20': ' #ebf0ff',
          '--status-04-30': ' #d4e0ff',
          '--status-04-40': ' #bbcfff',
          '--status-04-50': ' #9ebcff',
          '--status-04-60': ' #7aa7ff',
          '--status-04-70': ' #458fff',
          '--status-04-80': ' #3f83e9',
          '--status-04-90': ' #3875d0',
          '--status-04-100': ' #3165b4',
          '--status-04-110': ' #285393',
          '--status-04-120': ' #1c3a68',

          '--status-05-10': ' #f2fbff',
          '--status-05-20': ' #eaf8ff',
          '--status-05-30': ' #d2f0ff',
          '--status-05-40': ' #b7e8ff',
          '--status-05-50': ' #98e0ff',
          '--status-05-60': ' #70d8ff',
          '--status-05-70': ' #2fcfff',
          '--status-05-80': ' #2bbde9',
          '--status-05-90': ' #26a9d0',
          '--status-05-100': ' #2192b4',
          '--status-05-110': ' #1b7893',
          '--status-05-120': ' #135468',

          /* utility status token */

          '--status01-20': ' var(--status-01-20)',
          '--status01-30': ' var(--status-01-30)',
          '--status01-40': ' var(--status-01-40)',
          '--status01-50': ' var(--status-01-50)',
          '--status01-60': ' var(--status-01-60)',
          '--status01-70': ' var(--status-01-70)',
          '--status01-80': ' var(--status-01-80)',
          '--status01-90': ' var(--status-01-90)',

          '--status02-20': ' var(--status-02-20)',
          '--status02-30': ' var(--status-02-30)',
          '--status02-40': ' var(--status-02-40)',
          '--status02-50': ' var(--status-02-50)',
          '--status02-60': ' var(--status-02-60)',
          '--status02-70': ' var(--status-02-70)',
          '--status02-80': ' var(--status-02-80)',
          '--status02-90': ' var(--status-02-90)',

          '--status03-20': ' var(--status-03-20)',
          '--status03-30': ' var(--status-03-30)',
          '--status03-40': ' var(--status-03-40)',
          '--status03-50': ' var(--status-03-50)',
          '--status03-60': ' var(--status-03-60)',
          '--status03-70': ' var(--status-03-70)',
          '--status03-80': ' var(--status-03-80)',
          '--status03-90': ' var(--status-03-90)',

          '--status04-20': ' var(--status-04-20)',
          '--status04-30': ' var(--status-04-30)',
          '--status04-40': ' var(--status-04-40)',
          '--status04-50': ' var(--status-04-50)',
          '--status04-60': ' var(--status-04-60)',
          '--status04-70': ' var(--status-04-70)',
          '--status04-80': ' var(--status-04-80)',
          '--status04-90': ' var(--status-04-90)',

          '--status05-20': ' var(--status-05-20)',
          '--status05-30': ' var(--status-05-30)',
          '--status05-40': ' var(--status-05-40)',
          '--status05-50': ' var(--status-05-50)',
          '--status05-60': ' var(--status-05-60)',
          '--status05-70': ' var(--status-05-70)',
          '--status05-80': ' var(--status-05-80)',
          '--status05-90': ' var(--status-05-90)',

          /* text */
          '--text': ' var(--neutral-10)',
          '--text-subtle': ' var(--neutral-30)',
          '--text-subtler': ' var(--neutral-50)',
          '--text-subtlest': ' var(--neutral-60)',
          '--text-disabled': ' var(--neutral-70)',
          '--text-inverse': ' var(--white)',
          '--text-static': ' var(--white)',
          '--text-static-black': ' var(--neutral-10)',
          '--text-brand': ' var(--blue-30)',
          '--text-critical': ' var(--red-40)',
          '--text-critical-bolder': ' var(--red)',
          '--text-warning': ' var(--yellow-30)',
          '--text-warning-bolder': ' var(--yellow-5)',
          '--text-success': ' var(--green-30)',
          '--text-success-bolder': ' var(--green)',

          /* icon */
          '--icon': ' var(--neutral-30)',
          '--icon-subtle': ' var(--neutral-50)',
          '--icon-subtlest': ' var(--neutral-60)',
          '--icon-disabled': ' var(--neutral-70)',
          '--icon-inverse': ' var(--white)',
          '--icon-static': ' var(--white)',
          '--icon-static-black': ' var(--neutral-30)',
          '--icon-brand': ' var(--blue-30)',
          '--icon-critical': ' var(--red-40)',
          '--icon-warning': ' var(--yellow-30)',
          '--icon-success': ' var(--green-30)',

          /* surface */
          '--surface-default': ' var(--white)',
          '--surface-subtle': ' var(--neutral-99)',
          '--surface-hovered': ' var(--neutral-95)',
          '--surface-hovered-static': ' var(--neutral-95)',
          '--surface-pressed': ' var(--neutral-90)',
          '--surface-pressed-static': ' var(--neutral-90)',
          '--surface-disabled': ' var(--neutral-99)',
          '--surface-disabled-static': ' var(--neutral-99)',
          '--surface-search-field': ' var(--white)',
          '--surface-inverse': ' var(--neutral)',
          '--surface-static': ' var(--white)',
          '--surface-static-black': ' var(--neutral)',
          '--surface-none': ' var(--none)',
          '--surface-accent-green-subtle': ' var(--green-70)',
          '--surface-accent-green-subtler': ' var(--green-80)',
          '--surface-accent-green-subtlest': ' var(--green-95)',
          '--surface-accent-green-bolder': ' var(--green-20)',
          '--surface-accent-aqua-subtle': ' var(--aqua-70)',
          '--surface-accent-aqua-subtler': ' var(--aqua-80)',
          '--surface-accent-aqua-subtlest': ' var(--aqua-95)',
          '--surface-accent-aqua-bolder': ' var(--aqua-20)',
          '--surface-accent-blue-subtle': ' var(--blue-70)',
          '--surface-accent-blue-subtler': ' var(--blue-80)',
          '--surface-accent-blue-subtlest': ' var(--blue-95)',
          '--surface-accent-blue-bolder': ' var(--blue-20)',
          '--surface-accent-yellow-subtle': ' var(--yellow-70)',
          '--surface-accent-yellow-subtler': ' var(--yellow-80)',
          '--surface-accent-yellow-subtlest': ' var(--yellow-95)',
          '--surface-accent-yellow-bolder': ' var(--yellow-20)',
          '--surface-accent-red-subtle': ' var(--red-70)',
          '--surface-accent-red-subtler': ' var(--red-80)',
          '--surface-accent-red-subtlest': ' var(--red-95)',
          '--surface-accent-red-bolder': ' var(--red-20)',
          '--surface-accent-gray-subtle': ' var(--neutral-75)',
          '--surface-accent-gray-subtler': ' var(--neutral-85)',
          '--surface-accent-gray-subtlest': ' var(--neutral-95)',
          '--surface-accent-gray-bolder': ' var(--neutral-60)',
          '--surface-primary-default': ' var(--blue-30)',
          '--surface-primary-hovered': ' var(--blue-20)',
          '--surface-primary-pressed': ' var(--blue-10)',
          '--surface-primary-subtle-default': ' var(--blue-95)',
          '--surface-primary-subtle-hovered': ' var(--blue-90)',
          '--surface-primary-subtle-pressed': ' var(--blue-80)',
          '--surface-container-default': ' var(--neutral-variant-99)',
          '--surface-container-hovered': ' var(--neutral-variant-85)',
          '--surface-container-pressed': ' var(--neutral-variant-80)',
          '--surface-container-selected-default': ' var(--neutral-variant-95)',
          '--surface-container-selected-hovered': ' var(--neutral-variant-90)',
          '--surface-container-selected-pressed': ' var(--neutral-variant-88)',
          '--surface-warning-default': ' var(--yellow-30)',
          '--surface-warning-hovered': ' var(--yellow-20)',
          '--surface-warning-pressed': ' var(--yellow-10)',
          '--surface-warning-subtle-default': ' var(--yellow-95)',
          '--surface-warning-subtle-hovered': ' var(--yellow-90)',
          '--surface-warning-subtle-pressed': ' var(--yellow-80)',
          '--surface-success-default': ' var(--green-40)',
          '--surface-success-hovered': ' var(--green-30)',
          '--surface-success-pressed': ' var(--green-20)',
          '--surface-success-subtle-default': ' var(--green-95)',
          '--surface-success-subtle-hovered': ' var(--green-90)',
          '--surface-success-subtle-pressed': ' var(--green-80)',
          '--surface-critical-default': ' var(--red-40)',
          '--surface-critical-hovered': ' var(--red-20)',
          '--surface-critical-pressed': ' var(--red-10)',
          '--surface-critical-subtle-default': ' var(--red-95)',
          '--surface-critical-subtle-hovered': ' var(--red-90)',
          '--surface-critical-subtle-pressed': ' var(--red-80)',
          '--surface-info-default': ' var(--aqua-40)',
          '--surface-info-hovered': ' var(--aqua-30)',
          '--surface-info-pressed': ' var(--aqua-20)',
          '--surface-info-subtle-default': ' var(--aqua-95)',
          '--surface-info-subtle-hovered': ' var(--aqua-90)',
          '--surface-info-subtle-pressed': ' var(--aqua-80)',
          '--surface-lemon-bold': ' var(--yellow-5)',
          '--surface-lemon-default': ' var(--lemon-70)',
          '--surface-lemon-subtle': ' var(--lemon-90)',
          '--surface-lemon-subtlest': ' var(--white)',
          '--alpha-mask-desktop': 'var(--alpha-black-75)',
          '--alpha-mask-mobile': 'var(--alpha-black-75)',
          '--opaque-facetime-white': ' var(--opaque-white-20)',
          '--opaque-facetime-black': ' var(--opaque-black-20)',
          '--opaque-facetime-static': ' var(--opaque-black-20)',
          '--opaque-mask-desktop': ' var(--opaque-black-75)',
          '--opaque-mask-mobile': ' var(--opaque-black-75)',
          '--white-1': ' var(--opaque-white-1)',
          '--white-3': ' var(--opaque-white-3)',
          '--white-5': ' var(--opaque-white-5)',
          '--white-8': ' var(--opaque-white-8)',
          '--white-10': ' var(--opaque-white-10)',
          '--white-20': ' var(--opaque-white-20)',
          '--white-30': ' var(--opaque-white-30)',
          '--white-40': ' var(--opaque-white-40)',
          '--white-50': ' var(--opaque-white-50)',
          '--white-60': ' var(--opaque-white-60)',
          '--white-70': ' var(--opaque-white-70)',
          '--white-80': ' var(--opaque-white-80)',
          '--white-90': ' var(--opaque-white-90)',
          '--white-100': ' var(--opaque-white-100)',
          '--black-1': ' var(--opaque-black-1)',
          '--black-3': ' var(--opaque-black-3)',
          '--black-5': ' var(--opaque-black-5)',
          '--black-8': ' var(--opaque-black-8)',
          '--black-10': ' var(--opaque-black-10)',
          '--black-20': ' var(--opaque-black-20)',
          '--black-30': ' var(--opaque-black-30)',
          '--black-40': ' var(--opaque-black-40)',
          '--black-50': ' var(--opaque-black-50)',
          '--black-60': ' var(--opaque-black-60)',
          '--black-70': ' var(--opaque-black-70)',
          '--black-80': ' var(--opaque-black-80)',
          '--black-90': ' var(--opaque-black-90)',
          '--black-100': ' var(--opaque-black-100)',

          /* border */
          '--border': ' var(--neutral-variant-80)',
          '--border-static': ' var(--white)',
          '--border-subtle': ' var(--neutral-variant-85)',
          '--border-hovered': ' var(--neutral-variant-70)',
          '--border-pressed': ' var(--neutral-variant-60)',
          '--border-depressed': ' var(--neutral-variant-50)',
          '--border-critical': ' var(--red-30)',
          '--border-success': ' var(--green-40)',
          '--border-brand': ' var(--blue-30)',
          '--border-opaque': ' var(--opaque-white-5)',
          '--border-warning': ' var(--yellow-10)',
          '--border-warning-subtle': ' var(--yellow-35)',

          /* shadow */
          '--shadow-surface-default': ' var(--opaque-black-10)',
          '--shadow-surface-bolder': ' var(--opaque-black-3)',

          '--shadow-modal-default': ' var(--opaque-black-10)',
          '--shadow-modal-bolder': ' var(--opaque-black-10)',

          '--shadow-button-basic': ' var(--opaque-black-5)',
          '--shadow-button-primary-1': ' var(--opaque-black-8)',
          '--shadow-button-primary-2': ' var(--opaque-black-20)',
          '--shadow-button-pressed': ' var(--opaque-black-5)',

          /* focus-ring */
          '--focus-ring-brand': ' var(--status-04-70)',
          '--focus-ring-error': ' var(--red-55)',

          /* 1 */
          '--on-primary': ' #f6f6f7',
          '--inverse-primary': ' #fff',
          '--secondary': ' #6d7175',
          '--on-secondary': ' #ffffff',

          '--outline': ' #e4e9f0',
          /* 1 #F6F6F6 */
          '--outline-variant': ' #c9cccf',

          '--surface-create-bg': ' #fafafb',
          /* 1 */
          '--surface': ' #ffffff',
          /* 1 */
          '--surface-variant': ' #ecefff',
          '--on-surface': ' #202223',
          /* 148454E */
          '--on-surface-variant': ' #48454e',
          '--on-surface-btn-text': ' #414345',
          /* --secondary-container": " #E6DFF9", */
          '--on-secondary-container': ' #8c9196',
          '--secondary-container': ' #ecefff',
          /* 1 */
          '--surface-container': ' #f2f7fe',
          '--surface-container-high': ' #f5f7fa',
          '--surface-container-low': ' #f6f6f7',
          '--surface-normal': ' #f3d42d',
          '--surface-bold': ' #7e5700',

          '--surface-lemon': ' #fdf5ca',
          '--surface-subtlest': ' #ffffff',
          '--surface-one': ' #ebe1ff',

          /* 1 */
          '--primary': ' var(--surface-primary-default)',
          '--error': ' #d94227',
        },
        '.dark': {
          '.md-viewer code': {
            'background-color': ' #27282c !important',
            'font-size': ' 14px !important',
            color: ' var(--white)',
          },

          /* utility status token */

          '--status01-20': ' var(--status-01-120)',
          '--status01-30': ' var(--status-01-110)',
          '--status01-40': ' var(--status-01-100)',
          '--status01-50': ' var(--status-01-90)',
          '--status01-60': ' var(--status-01-80)',
          '--status01-70': ' var(--status-01-70)',
          '--status01-80': ' var(--status-01-60)',
          '--status01-90': ' var(--status-01-50)',

          '--status02-20': ' var(--status-02-120)',
          '--status02-30': ' var(--status-02-110)',
          '--status02-40': ' var(--status-02-100)',
          '--status02-50': ' var(--status-02-90)',
          '--status02-60': ' var(--status-02-80)',
          '--status02-70': ' var(--status-02-70)',
          '--status02-80': ' var(--status-02-60)',
          '--status02-90': ' var(--status-02-50)',

          '--status03-20': ' var(--status-03-120)',
          '--status03-30': ' var(--status-03-110)',
          '--status03-40': ' var(--status-03-100)',
          '--status03-50': ' var(--status-03-90)',
          '--status03-60': ' var(--status-03-80)',
          '--status03-70': ' var(--status-03-70)',
          '--status03-80': ' var(--status-03-60)',
          '--status03-90': ' var(--status-03-50)',

          '--status04-20': ' var(--status-04-120)',
          '--status04-30': ' var(--status-04-110)',
          '--status04-40': ' var(--status-04-100)',
          '--status04-50': ' var(--status-04-90)',
          '--status04-60': ' var(--status-04-80)',
          '--status04-70': ' var(--status-04-70)',
          '--status04-80': ' var(--status-04-60)',
          '--status04-90': ' var(--status-04-50)',

          '--status05-20': ' var(--status-05-120)',
          '--status05-30': ' var(--status-05-110)',
          '--status05-40': ' var(--status-05-100)',
          '--status05-50': ' var(--status-05-90)',
          '--status05-60': ' var(--status-05-80)',
          '--status05-70': ' var(--status-05-70)',
          '--status05-80': ' var(--status-05-60)',
          '--status05-90': ' var(--status-05-50)',

          /* text */
          '--text': ' var(--white)',
          '--text-subtle': ' var(--neutral-dark-85)',
          '--text-subtler': ' var(--neutral-dark-60)',
          '--text-subtlest': ' var(--neutral-dark-40)',
          '--text-disabled': ' var(--neutral-dark-30)',
          '--text-inverse': ' var(--neutral-10)',
          '--text-static': ' var(--white)',
          '--text-static-black': ' var(--neutral-10)',
          '--text-brand': ' var(--blue-40)',
          '--text-critical': ' var(--red-50)',
          '--text-critical-bolder': ' var(--red-70)',
          '--text-warning': ' var(--yellow-40)',
          '--text-warning-bolder': ' var(--yellow-70)',
          '--text-success': ' var(--green-40)',
          '--text-success-bolder': ' var(--green-70)',

          /* icon */
          '--icon': ' var(--neutral-dark-85)',
          '--icon-subtle': ' var(--neutral-dark-60)',
          '--icon-subtlest': ' var(--neutral-dark-40)',
          '--icon-disabled': ' var(--neutral-dark-30)',
          '--icon-inverse': ' var(--neutral-30)',
          '--icon-static': ' var(--white)',
          '--icon-static-black': ' var(--neutral-30)',
          '--icon-brand': ' var(--blue-40)',
          '--icon-critical': ' var(--red-50)',
          '--icon-warning': ' var(--yellow-40)',
          '--icon-success': ' var(--green-40)',

          /* surface */
          '--surface-default': ' var(--neutral-dark-special)',
          '--surface-subtle': ' var(--neutral-dark-special-5)',
          '--surface-hovered': ' var(--neutral-dark-special-10)',
          '--surface-pressed': ' var(--neutral-dark-special-20)',
          '--surface-disabled': ' var(--neutral-dark-special-5)',
          '--surface-search-field': ' var(--neutral-dark-special-5)',
          '--surface-inverse': ' var(--white)',
          '--surface-static': ' var(--white)',
          '--surface-static-black': ' var(--neutral)',
          '--surface-none': ' var(--none)',
          '--surface-accent-green-subtle': ' var(--green-dark-10)',
          '--surface-accent-green-subtler': ' var(--green-dark-20)',
          '--surface-accent-green-subtlest': ' var(--green-dark-30)',
          '--surface-accent-green-bolder': ' var(--green-25)',
          '--surface-accent-aqua-subtle': ' var(--aqua-dark-10)',
          '--surface-accent-aqua-subtler': ' var(--aqua-dark-20)',
          '--surface-accent-aqua-subtlest': ' var(--aqua-dark-30)',
          '--surface-accent-aqua-bolder': ' var(--aqua-25)',
          '--surface-accent-blue-subtle': ' var(--blue-dark-10)',
          '--surface-accent-blue-subtler': ' var(--blue-dark-20)',
          '--surface-accent-blue-subtlest': ' var(--blue-dark-30)',
          '--surface-accent-blue-bolder': ' var(--blue-15)',
          '--surface-accent-yellow-subtle': ' var(--yellow-dark-10)',
          '--surface-accent-yellow-subtler': ' var(--yellow-dark-20)',
          '--surface-accent-yellow-subtlest': ' var(--yellow-dark-30)',
          '--surface-accent-yellow-bolder': ' var(--yellow-15)',
          '--surface-accent-red-subtle': ' var(--red-dark-10)',
          '--surface-accent-red-subtler': ' var(--red-dark-20)',
          '--surface-accent-red-subtlest': ' var(--red-dark-30)',
          '--surface-accent-red-bolder': ' var(--red-25)',
          '--surface-accent-gray-subtle': ' var(--neutral-dark-30)',
          '--surface-accent-gray-subtler': ' var(--neutral-dark-25)',
          '--surface-accent-gray-subtlest': ' var(--neutral-dark-20)',
          '--surface-accent-gray-bolder': ' var(--neutral-dark-40)',
          '--surface-primary-default': ' var(--blue-40)',
          '--surface-primary-hovered': ' var(--blue-20)',
          '--surface-primary-pressed': ' var(--blue-10)',
          '--surface-primary-subtle-default': ' var(--blue-dark-30)',
          '--surface-primary-subtle-hovered': ' var(--blue-dark-40)',
          '--surface-primary-subtle-pressed': ' var(--blue-dark-50)',
          '--surface-container-default': ' var(--neutral-dark)',
          '--surface-container-hovered': ' var(--neutral-dark-10)',
          '--surface-container-pressed': ' var(--neutral-dark-15)',
          '--surface-container-selected-default':
            ' var(--neutral-dark-special-10)',
          '--surface-container-selected-hovered':
            ' var(--neutral-dark-special-30)',
          '--surface-container-selected-pressed':
            ' var(--neutral-dark-special-40)',
          '--surface-warning-default': ' var(--yellow-30)',
          '--surface-warning-hovered': ' var(--yellow-20)',
          '--surface-warning-pressed': ' var(--yellow-10)',
          '--surface-warning-subtle-default': ' var(--yellow-dark-10)',
          '--surface-warning-subtle-hovered': ' var(--yellow-dark-20)',
          '--surface-warning-subtle-pressed': ' var(--yellow-dark-30)',
          '--surface-success-default': ' var(--green-40)',
          '--surface-success-hovered': ' var(--green-30)',
          '--surface-success-pressed': ' var(--green-20)',
          '--surface-success-subtle-default': ' var(--green-dark-10)',
          '--surface-success-subtle-hovered': ' var(--green-dark-20)',
          '--surface-success-subtle-pressed': ' var(--green-dark-30)',
          '--surface-critical-default': ' var(--red-30)',
          '--surface-critical-hovered': ' var(--red-20)',
          '--surface-critical-pressed': ' var(--red-10)',
          '--surface-critical-subtle-default': ' var(--red-dark-10)',
          '--surface-critical-subtle-hovered': ' var(--red-dark-20)',
          '--surface-critical-subtle-pressed': ' var(--red-dark-30)',
          '--surface-info-default': ' var(--aqua-40)',
          '--surface-info-hovered': ' var(--aqua-30)',
          '--surface-info-pressed': ' var(--aqua-20)',
          '--surface-info-subtle-default': ' var(--aqua-dark-10)',
          '--surface-info-subtle-hovered': ' var(--aqua-dark-20)',
          '--surface-info-subtle-pressed': ' var(--aqua-dark-30)',
          '--surface-lemon-bold': ' var(--lemon-80)',
          '--surface-lemon-default': ' var(--lemon-50)',
          '--surface-lemon-subtle': ' var(--lemon-20)',
          '--surface-lemon-subtlest': ' var(--lemon)',
          '--opaque-facetime-white': ' var(--opaque-black-20)',
          '--opaque-facetime-black': ' var(--opaque-white-20)',
          '--opaque-facetime-static': ' var(--opaque-black-20)',
          '--opaque-mask-desktop': ' var(--opaque-black-75)',
          '--opaque-mask-mobile': ' var(--opaque-black-75)',
          '--white-1': ' var(--opaque-black-1)',
          '--white-3': ' var(--opaque-black-3)',
          '--white-5': ' var(--opaque-black-5)',
          '--white-8': ' var(--opaque-black-8)',
          '--white-10': ' var(--opaque-black-10)',
          '--white-20': ' var(--opaque-black-20)',
          '--white-30': ' var(--opaque-black-30)',
          '--white-40': ' var(--opaque-black-40)',
          '--white-50': ' var(--opaque-black-50)',
          '--white-60': ' var(--opaque-black-60)',
          '--white-70': ' var(--opaque-black-70)',
          '--white-80': ' var(--opaque-black-80)',
          '--white-90': ' var(--opaque-black-90)',
          '--white-100': ' var(--opaque-black-100)',
          '--black-1': ' var(--opaque-white-1)',
          '--black-3': ' var(--opaque-white-3)',
          '--black-5': ' var(--opaque-white-5)',
          '--black-8': ' var(--opaque-white-8)',
          '--black-10': ' var(--opaque-white-10)',
          '--black-20': ' var(--opaque-white-20)',
          '--black-30': ' var(--opaque-white-30)',
          '--black-40': ' var(--opaque-white-40)',
          '--black-50': ' var(--opaque-white-50)',
          '--black-60': ' var(--opaque-white-60)',
          '--black-70': ' var(--opaque-white-70)',
          '--black-80': ' var(--opaque-white-80)',
          '--black-90': ' var(--opaque-white-90)',
          '--black-100': ' var(--opaque-white-100)',

          /* border */
          '--border': ' var(--neutral-dark-25)',
          '--border-subtle': ' var(--neutral-dark-20)',
          '--border-hovered': ' var(--neutral-dark-30)',
          '--border-pressed': ' var(--neutral-dark-40)',
          '--border-depressed': ' var(--neutral-dark-50)',
          '--border-critical': ' var(--red-50)',
          '--border-success': ' var(--green-40)',
          '--border-brand': ' var(--blue-40)',
          '--border-opaque': ' var(--opaque-white-5)',
          '--border-warning': ' var(--yellow-10)',
          '--border-warning-subtle': ' var(--yellow-35)',

          /* shadow */
          '--shadow-surface-default': ' var(--opaque-white-5)',
          '--shadow-surface-bolder': ' var(--opaque-white-3)',
          '--shadow-modal-default': ' var(--opaque-white-1)',
          '--shadow-modal-bolder': ' var(--opaque-white-1)',
          '--shadow-button-basic': ' var(--opaque-white-5)',
          '--shadow-button-primary-1': ' var(--opaque-white-8)',
          '--shadow-button-primary-2': ' var(--opaque-white-20)',
          '--shadow-button-pressed': ' var(--opaque-white-10)',

          /* focus-ring */
          '--focus-ring-brand': ' var(--status-04-70)',
          '--focus-ring-error': ' var(--red-55)',

          /* 1 */
          '--primary': ' #5974ff',
          '--inverse-primary': ' #fff',
          '--secondary': ' #b8bccf',
          '--surface-container': ' #232533',
          '--surface-container-low': ' #27282c',
          '--surface-container-high': ' #1c1e26',
          '--surface-variant': ' #383c52',
          /* #666873 */
          '--on-surface-variant': ' #666873',
          '--on-surface-btn-text': ' #fff',
          '--secondary-container': ' #383c52',
          '--on-secondary-container': ' #666873',
          '--outline': ' #2b2e3b',
          '--outline-variant': ' #323339',
          '--surface': ' #17181c',
          '--surface-create-bg': ' #22242e',
          '--on-surface': ' #fff',
          '--on-primary': ' #232533',
        },
      });
    }),
  ],
};
export default config;
