import * as React from 'react';
import { Icon, IconProps } from '../../icon';

const Config = React.forwardRef<SVGSVGElement, IconProps>((props, ref) => {
  return (
    <Icon {...props}>
      <svg
        width="18"
        height="18"
        viewBox="0 0 18 18"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        className="cursor-pointer">
        <g id="wrapper">
          <g id="Union">
            <path
              fillRule="evenodd"
              clipRule="evenodd"
              d="M4.5 2.25C4.81066 2.25 5.0625 2.50184 5.0625 2.8125L5.0625 9.65852C5.71792 9.89018 6.1875 10.5153 6.1875 11.25C6.1875 11.9847 5.71792 12.6098 5.0625 12.8415V15.1875C5.0625 15.4982 4.81066 15.75 4.5 15.75C4.18934 15.75 3.9375 15.4982 3.9375 15.1875V12.8415C3.28208 12.6098 2.8125 11.9847 2.8125 11.25C2.8125 10.5153 3.28208 9.89018 3.9375 9.65852L3.9375 2.8125C3.9375 2.50184 4.18934 2.25 4.5 2.25ZM4.5 10.6875C4.18934 10.6875 3.9375 10.9393 3.9375 11.25C3.9375 11.5607 4.18934 11.8125 4.5 11.8125C4.81066 11.8125 5.0625 11.5607 5.0625 11.25C5.0625 10.9393 4.81066 10.6875 4.5 10.6875Z"
              fill="#6D7175"
            />
            <path
              fillRule="evenodd"
              clipRule="evenodd"
              d="M9 2.25C9.31066 2.25 9.5625 2.50184 9.5625 2.8125V5.15852C10.2179 5.39018 10.6875 6.01525 10.6875 6.75C10.6875 7.48475 10.2179 8.10982 9.5625 8.34148V15.1875C9.5625 15.4982 9.31066 15.75 9 15.75C8.68934 15.75 8.4375 15.4982 8.4375 15.1875V8.34148C7.78208 8.10982 7.3125 7.48475 7.3125 6.75C7.3125 6.01525 7.78208 5.39018 8.4375 5.15852V2.8125C8.4375 2.50184 8.68934 2.25 9 2.25ZM9 6.1875C8.68934 6.1875 8.4375 6.43934 8.4375 6.75C8.4375 7.06066 8.68934 7.3125 9 7.3125C9.31066 7.3125 9.5625 7.06066 9.5625 6.75C9.5625 6.43934 9.31066 6.1875 9 6.1875Z"
              fill="#6D7175"
            />
            <path
              fillRule="evenodd"
              clipRule="evenodd"
              d="M13.5 2.25C13.8107 2.25 14.0625 2.50184 14.0625 2.8125V9.65852C14.7179 9.89018 15.1875 10.5153 15.1875 11.25C15.1875 11.9847 14.7179 12.6098 14.0625 12.8415L14.0625 15.1875C14.0625 15.4982 13.8107 15.75 13.5 15.75C13.1893 15.75 12.9375 15.4982 12.9375 15.1875L12.9375 12.8415C12.2821 12.6098 11.8125 11.9847 11.8125 11.25C11.8125 10.5153 12.2821 9.89018 12.9375 9.65852V2.8125C12.9375 2.50184 13.1893 2.25 13.5 2.25ZM13.5 10.6875C13.1893 10.6875 12.9375 10.9393 12.9375 11.25C12.9375 11.5607 13.1893 11.8125 13.5 11.8125C13.8107 11.8125 14.0625 11.5607 14.0625 11.25C14.0625 10.9393 13.8107 10.6875 13.5 10.6875Z"
              fill="#6D7175"
            />
          </g>
        </g>
      </svg>
    </Icon>
  );
});

export { Config };
