import * as React from 'react';
import { Icon, IconProps } from '../../icon';

const ShellAgent = React.forwardRef<SVGSVGElement, IconProps>((props, ref) => {
  return (
    <Icon {...props}>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        width="141"
        height="26"
        viewBox="0 0 585 94"
        fill="none">
        <path
          d="M179.727 76.0692C175.037 76.0692 170.788 75.2415 166.981 73.5862C163.229 71.9308 160.194 69.5857 157.877 66.5509C155.559 63.516 154.18 59.9846 153.738 55.9565L163.422 54.1356C163.643 56.7842 164.498 59.1569 165.988 61.2537C167.478 63.3505 169.437 64.9783 171.864 66.137C174.292 67.2958 176.996 67.8751 179.976 67.8751C182.624 67.8751 184.942 67.4613 186.928 66.6336C188.97 65.8059 190.515 64.6748 191.563 63.2401C192.667 61.7503 193.219 60.0949 193.219 58.274C193.219 56.0117 192.336 54.1908 190.57 52.8113C188.804 51.4318 185.99 50.3283 182.128 49.5006L173.271 47.5969C167.478 46.383 163.201 44.5069 160.442 41.9687C157.739 39.3752 156.387 35.9542 156.387 31.7054C156.387 28.0636 157.297 24.8632 159.118 22.1043C160.939 19.2901 163.477 17.1106 166.733 15.5656C169.988 14.0206 173.713 13.248 177.906 13.248C181.714 13.248 185.163 13.9654 188.253 15.4C191.398 16.7795 193.964 18.7383 195.95 21.2766C197.936 23.7596 199.206 26.6841 199.757 30.05L190.239 32.202C190.018 30.05 189.329 28.1739 188.17 26.5737C187.066 24.9736 185.604 23.732 183.783 22.8492C182.017 21.9111 180.058 21.4421 177.906 21.4421C175.644 21.4421 173.658 21.856 171.947 22.6836C170.237 23.4561 168.912 24.5321 167.974 25.9116C167.036 27.2911 166.567 28.8361 166.567 30.5466C166.567 32.6434 167.312 34.354 168.802 35.6783C170.347 36.9474 172.83 37.9406 176.251 38.6579L185.19 40.4788C191.315 41.6376 195.867 43.5964 198.847 46.3554C201.827 49.0591 203.316 52.5906 203.316 56.9497C203.316 60.7571 202.323 64.123 200.337 67.0475C198.405 69.9168 195.646 72.1515 192.06 73.7517C188.528 75.2967 184.418 76.0692 179.727 76.0692ZM208.506 74V12.8342H217.858V38.8235H217.941C219.597 36.1197 221.721 34.0505 224.314 32.6158C226.963 31.1812 230.025 30.4639 233.502 30.4639C236.536 30.4639 239.157 31.0708 241.365 32.2848C243.572 33.4987 245.255 35.292 246.413 37.6647C247.627 39.9822 248.234 42.7412 248.234 45.9415V74H238.882V48.1763C238.882 45.1414 238.054 42.7412 236.398 40.9754C234.798 39.2097 232.591 38.3268 229.777 38.3268C227.515 38.3268 225.473 38.851 223.652 39.8994C221.831 40.8927 220.397 42.3273 219.348 44.2034C218.355 46.0243 217.858 48.1211 217.858 50.4938V74H208.506ZM278.065 75.6554C273.43 75.6554 269.264 74.6621 265.567 72.6757C261.87 70.6893 258.973 67.9579 256.876 64.4816C254.834 61.0054 253.813 57.0601 253.813 52.6458C253.813 48.2866 254.751 44.4241 256.628 41.0582C258.504 37.6371 261.125 34.9885 264.491 33.1124C267.856 31.1812 271.664 30.2156 275.913 30.2156C280.106 30.2156 283.776 31.1536 286.921 33.0297C290.121 34.9058 292.604 37.4992 294.37 40.8099C296.136 44.0655 297.046 47.8452 297.101 52.1492C297.101 52.7561 297.074 53.3631 297.019 53.9701C296.963 54.577 296.881 55.1564 296.77 55.7082H263.497C263.718 58.1912 264.491 60.3984 265.815 62.3297C267.194 64.2057 268.96 65.668 271.112 66.7164C273.264 67.7648 275.664 68.289 278.313 68.289C281.237 68.289 283.914 67.6544 286.341 66.3853C288.824 65.061 290.701 63.3781 291.97 61.3364L298.177 65.1438C297.184 67.1854 295.694 69.0063 293.708 70.6065C291.721 72.2067 289.376 73.4482 286.672 74.3311C283.969 75.2139 281.099 75.6554 278.065 75.6554ZM287.5 49.335C287.279 46.9072 286.672 44.8104 285.679 43.0446C284.686 41.2789 283.334 39.927 281.624 38.989C279.968 38.051 278.065 37.5819 275.913 37.5819C273.705 37.5819 271.719 38.0785 269.953 39.0718C268.188 40.065 266.725 41.4445 265.567 43.2102C264.463 44.9759 263.773 47.0175 263.497 49.335H287.5ZM303.721 74V12.8342H313.074V74H303.721ZM320.534 74V12.8342H329.887V74H320.534ZM334.284 74L356.3 15.3173H368.881L390.732 74H379.889L375.337 61.1709H349.761L345.126 74H334.284ZM351.996 53.1424H373.019L362.673 24.2562H362.508L351.996 53.1424ZM411.007 93.0367C406.372 93.0367 401.986 92.1539 397.847 90.3881C393.764 88.6224 390.619 86.3049 388.412 83.4356L393.047 76.7314C394.812 79.2696 397.268 81.2836 400.413 82.7734C403.558 84.3185 406.896 85.091 410.428 85.091C413.573 85.091 416.332 84.4564 418.705 83.1873C421.077 81.9733 422.926 80.2352 424.25 77.9729C425.575 75.7105 426.237 73.0895 426.237 70.1099V66.0542H426.154C425.161 67.7096 423.836 69.1443 422.181 70.3582C420.581 71.5721 418.788 72.5102 416.801 73.1723C414.87 73.8345 412.911 74.1655 410.925 74.1655C407.007 74.1655 403.558 73.2827 400.579 71.517C397.599 69.696 395.281 67.1578 393.626 63.9023C391.971 60.5915 391.143 56.8118 391.143 52.563C391.143 48.2039 391.971 44.3689 393.626 41.0582C395.281 37.6923 397.571 35.0989 400.496 33.278C403.475 31.4571 406.896 30.5466 410.759 30.5466C413.849 30.5466 416.801 31.3743 419.615 33.0297C422.485 34.6299 424.692 36.7267 426.237 39.3201H426.319L427.561 31.8709H435.59V70.2754C435.59 74.8553 434.569 78.8557 432.527 82.2768C430.541 85.6979 427.671 88.3465 423.919 90.2226C420.222 92.0987 415.918 93.0367 411.007 93.0367ZM413.573 66.3025C416.111 66.3025 418.374 65.7232 420.36 64.5644C422.347 63.3505 423.892 61.6951 424.995 59.5983C426.099 57.5015 426.651 55.1564 426.651 52.563C426.651 49.8592 426.099 47.4314 424.995 45.2794C423.892 43.1274 422.347 41.4445 420.36 40.2305C418.374 39.0166 416.111 38.4096 413.573 38.4096C411.035 38.4096 408.745 39.0166 406.703 40.2305C404.717 41.3893 403.172 43.0446 402.068 45.1966C400.965 47.3486 400.413 49.8041 400.413 52.563C400.413 55.2116 400.965 57.5843 402.068 59.6811C403.172 61.7779 404.717 63.4057 406.703 64.5644C408.745 65.7232 411.035 66.3025 413.573 66.3025ZM465.748 75.6554C461.113 75.6554 456.947 74.6621 453.25 72.6757C449.553 70.6893 446.656 67.9579 444.56 64.4816C442.518 61.0054 441.497 57.0601 441.497 52.6458C441.497 48.2866 442.435 44.4241 444.311 41.0582C446.187 37.6371 448.808 34.9885 452.174 33.1124C455.54 31.1812 459.347 30.2156 463.596 30.2156C467.79 30.2156 471.459 31.1536 474.604 33.0297C477.805 34.9058 480.288 37.4992 482.054 40.8099C483.819 44.0655 484.73 47.8452 484.785 52.1492C484.785 52.7561 484.757 53.3631 484.702 53.9701C484.647 54.577 484.564 55.1564 484.454 55.7082H451.181C451.402 58.1912 452.174 60.3984 453.499 62.3297C454.878 64.2057 456.644 65.668 458.796 66.7164C460.948 67.7648 463.348 68.289 465.997 68.289C468.921 68.289 471.597 67.6544 474.025 66.3853C476.508 65.061 478.384 63.3781 479.653 61.3364L485.861 65.1438C484.868 67.1854 483.378 69.0063 481.391 70.6065C479.405 72.2067 477.06 73.4482 474.356 74.3311C471.652 75.2139 468.783 75.6554 465.748 75.6554ZM475.184 49.335C474.963 46.9072 474.356 44.8104 473.363 43.0446C472.37 41.2789 471.018 39.927 469.307 38.989C467.652 38.051 465.748 37.5819 463.596 37.5819C461.389 37.5819 459.403 38.0785 457.637 39.0718C455.871 40.065 454.409 41.4445 453.25 43.2102C452.147 44.9759 451.457 47.0175 451.181 49.335H475.184ZM516.401 30.4639C519.436 30.4639 522.057 31.0708 524.264 32.2848C526.471 33.4987 528.154 35.292 529.313 37.6647C530.527 39.9822 531.134 42.7412 531.134 45.9415V74H521.781V48.1763C521.781 45.1414 520.953 42.7412 519.298 40.9754C517.698 39.2097 515.491 38.3268 512.677 38.3268C510.414 38.3268 508.373 38.851 506.552 39.8994C504.731 40.8927 503.296 42.3273 502.248 44.2034C501.255 46.0243 500.758 48.1211 500.758 50.4938V74H491.405V31.8709H499.516L500.675 38.8235H500.758C502.468 36.1197 504.62 34.0505 507.214 32.6158C509.862 31.1812 512.925 30.4639 516.401 30.4639ZM556.855 75.6554C553.93 75.6554 551.337 75.076 549.075 73.9172C546.867 72.7033 545.157 71.0479 543.943 68.9511C542.729 66.7992 542.122 64.2885 542.122 61.4192V39.2373H533.597V31.8709H542.122V19.8695L551.475 17.8003V31.8709H569.27V39.2373H551.475V60.1777C551.475 61.6675 551.751 63.0194 552.303 64.2333C552.91 65.4473 553.737 66.3853 554.786 67.0475C555.889 67.6544 557.131 67.9579 558.51 67.9579C560.607 67.9579 562.428 67.3509 563.973 66.137C565.518 64.8679 566.621 63.1298 567.284 60.9226L571.836 65.8059C570.843 68.7856 568.939 71.1859 566.125 73.0068C563.366 74.7725 560.276 75.6554 556.855 75.6554Z"
          fill="#24295A"
        />
        <path
          d="M29.3375 7C8.94234 7 1.88349 52.6344 0.345815 64.9927C0.214415 66.0487 1.56844 66.5981 2.38719 65.8837C42.5567 30.8334 61.1684 83.5 77.1106 83.5C68.1876 83.5 61.6494 59.2801 53.4351 38.096C47.0507 21.631 39.6537 7 29.3375 7Z"
          fill="url(#paint0_linear_5226_78567)"
        />
        <path
          d="M119.377 64.6429C120.148 65.5521 121.671 64.9537 121.483 63.7947C119.649 52.5064 113.598 22.6434 100.898 22.6434C93.0927 22.6434 91.0983 37.762 89.0976 52.9281L89.0913 52.9763C106.158 52.9763 112.64 56.6904 119.377 64.6429Z"
          fill="url(#paint1_linear_5226_78567)"
        />
        <path
          d="M53.4346 38.0932C61.6489 59.2773 68.1871 83.4972 77.1101 83.4972C85.0558 83.4972 87.0796 68.2194 89.0907 52.9735L89.0971 52.9254C91.0978 37.7592 93.0921 22.6406 100.898 22.6406C85.2375 22.6406 77.1101 77.774 53.4346 38.0932Z"
          fill="#DDB1FF"
        />
        <defs>
          <linearGradient
            id="paint0_linear_5226_78567"
            x1="0.336915"
            y1="34.0937"
            x2="122.312"
            y2="34.0938"
            gradientUnits="userSpaceOnUse">
            <stop stopColor="#3239DC" />
            <stop offset="0.0001" stopColor="#0026AB" />
            <stop offset="1" stopColor="#7859F2" />
            <stop offset="1" stopColor="#5A38E2" />
          </linearGradient>
          <linearGradient
            id="paint1_linear_5226_78567"
            x1="0.336915"
            y1="34.0937"
            x2="122.312"
            y2="34.0938"
            gradientUnits="userSpaceOnUse">
            <stop stopColor="#3239DC" />
            <stop offset="0.0001" stopColor="#0026AB" />
            <stop offset="1" stopColor="#7859F2" />
            <stop offset="1" stopColor="#5A38E2" />
          </linearGradient>
        </defs>
      </svg>
    </Icon>
  );
});

export { ShellAgent };
