import * as React from 'react';
import { Icon, IconProps } from '../../icon';

const Report = React.forwardRef<SVGSVGElement, IconProps>((props, ref) => {
  return (
    <Icon {...props}>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none">
        <path
          d="M8.25007 7.54141C8.25007 7.1272 8.58585 6.79141 9.00007 6.79141H15.6316C16.0459 6.79141 16.3816 7.1272 16.3816 7.54141C16.3816 7.95563 16.0459 8.29141 15.6316 8.29141H9.00007C8.58585 8.29141 8.25007 7.95563 8.25007 7.54141Z"
          fill="#6D7175"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M19.5394 9.33814V5C19.5394 4.0335 18.7559 3.25 17.7894 3.25H6.52626C5.55976 3.25 4.77626 4.0335 4.77626 5V9.38841L4.69581 9.35356C3.54026 8.85282 2.25 9.6999 2.25 10.9593V18.5414C2.25 19.5079 3.0335 20.2914 4 20.2914H20C20.9665 20.2914 21.75 19.5079 21.75 18.5414V11.0275C21.75 9.84726 20.6215 9.03803 19.5394 9.33814ZM6.52626 4.75C6.38819 4.75 6.27626 4.86193 6.27626 5V10.0384L12.3524 12.6714C12.419 12.7003 12.4949 12.6988 12.5602 12.6673L18.0394 10.0292V5C18.0394 4.86193 17.9275 4.75 17.7894 4.75H6.52626ZM3.75 10.9593C3.75 10.7794 3.93432 10.6584 4.0994 10.7299L11.756 14.0477C12.2222 14.2498 12.7532 14.2392 13.211 14.0188L19.8915 10.8022C20.0575 10.7223 20.25 10.8432 20.25 11.0275V18.5414C20.25 18.6794 20.1381 18.7914 20 18.7914H4C3.86193 18.7914 3.75 18.6794 3.75 18.5414V10.9593Z"
          fill="#6D7175"
        />
      </svg>
    </Icon>
  );
});

export { Report };
