import * as React from 'react';
import { Icon, IconProps } from '../../icon';

const Setting = React.forwardRef<SVGSVGElement, IconProps>((props, ref) => {
  return (
    <Icon {...props}>
      <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22" fill="none">
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M7.56253 11C7.56253 9.10154 9.10155 7.56252 11 7.56252C12.8985 7.56252 14.4375 9.10154 14.4375 11C14.4375 12.8985 12.8985 14.4375 11 14.4375C9.10155 14.4375 7.56253 12.8985 7.56253 11ZM11 8.93752C9.86094 8.93752 8.93753 9.86093 8.93753 11C8.93753 12.1391 9.86094 13.0625 11 13.0625C12.1391 13.0625 13.0625 12.1391 13.0625 11C13.0625 9.86093 12.1391 8.93752 11 8.93752Z"
          fill="#6D7175"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M8.80263 3.49869C8.94075 2.66993 9.6578 2.0625 10.498 2.0625H11.5008C12.341 2.0625 13.058 2.66993 13.1962 3.49869L13.3327 4.31802C13.3519 4.43337 13.4488 4.57118 13.634 4.64809C13.8147 4.72312 13.9761 4.69559 14.0744 4.62538L14.7505 4.14245C15.4342 3.6541 16.3707 3.73161 16.9648 4.32571L17.6739 5.0348C18.268 5.62891 18.3455 6.56545 17.8572 7.24914L17.3741 7.92549C17.3039 8.02371 17.2764 8.18497 17.3514 8.36555C17.4282 8.5507 17.566 8.64744 17.6812 8.66666L18.5007 8.80324C19.3295 8.94136 19.9369 9.65841 19.9369 10.4986V11.5014C19.9369 12.3416 19.3295 13.0586 18.5007 13.1968L17.6814 13.3333C17.566 13.3525 17.4282 13.4494 17.3513 13.6346C17.2763 13.8153 17.3038 13.9766 17.374 14.0749L17.8569 14.7509C18.3452 15.4346 18.2677 16.3712 17.6736 16.9653L16.9645 17.6743C16.3704 18.2685 15.4339 18.346 14.7502 17.8576L14.074 17.3747C13.9758 17.3045 13.8145 17.277 13.6339 17.352C13.4487 17.4288 13.3519 17.5666 13.3327 17.6819L13.1962 18.5013C13.058 19.3301 12.341 19.9375 11.5008 19.9375H10.498C9.6578 19.9375 8.94075 19.3301 8.80262 18.5013L8.66607 17.682C8.64684 17.5666 8.55003 17.4288 8.36479 17.3519C8.18411 17.2769 8.02274 17.3044 7.92446 17.3746L7.24831 17.8576C6.56461 18.3459 5.62807 18.2684 5.03396 17.6743L4.32488 16.9652C3.73077 16.3711 3.65326 15.4346 4.14161 14.7509L4.62472 14.0745C4.69488 13.9763 4.7224 13.815 4.64742 13.6345C4.57055 13.4493 4.43282 13.3526 4.31755 13.3333L3.49808 13.1968C2.66932 13.0586 2.06189 12.3416 2.06189 11.5014V10.4986C2.06189 9.65841 2.66932 8.94136 3.49808 8.80324L4.3174 8.66668C4.43276 8.64745 4.57057 8.55063 4.64749 8.36538C4.72251 8.18469 4.69499 8.02331 4.62478 7.92501L4.14197 7.24908C3.65362 6.56539 3.73113 5.62885 4.32524 5.03474L5.03432 4.32565C5.62843 3.73155 6.56497 3.65404 7.24867 4.14239L7.9248 4.62534C8.02302 4.6955 8.18431 4.72302 8.36491 4.64804C8.55008 4.57117 8.64684 4.43342 8.66605 4.31814L8.80263 3.49869ZM10.498 3.4375C10.33 3.4375 10.1865 3.55899 10.1589 3.72474L10.0223 4.54419C9.91194 5.20659 9.43512 5.69251 8.89214 5.91794C8.34432 6.14538 7.66917 6.13249 7.12559 5.74422L6.44946 5.26127C6.31272 5.1636 6.12541 5.1791 6.00659 5.29793L5.29751 6.00701C5.17869 6.12583 5.16318 6.31314 5.26085 6.44988L5.74366 7.12581C6.13199 7.66947 6.14487 8.34474 5.91738 8.89264C5.69191 9.43568 5.20593 9.91256 4.54345 10.023L3.72413 10.1595C3.55838 10.1872 3.43689 10.3306 3.43689 10.4986V11.5014C3.43689 11.6694 3.55838 11.8128 3.72413 11.8405L4.5436 11.9771C5.20598 12.0874 5.6919 12.5643 5.91733 13.1072C6.14476 13.655 6.13186 14.3302 5.74361 14.8737L5.26049 15.5501C5.16282 15.6868 5.17833 15.8741 5.29715 15.993L6.00623 16.7021C6.12506 16.8209 6.31236 16.8364 6.4491 16.7387L7.12526 16.2557C7.66891 15.8674 8.34415 15.8545 8.89205 16.082C9.43507 16.3075 9.91195 16.7935 10.0224 17.4559L10.1589 18.2753C10.1865 18.441 10.33 18.5625 10.498 18.5625H11.5008C11.6688 18.5625 11.8122 18.441 11.8399 18.2753L11.9764 17.4558C12.0868 16.7934 12.5637 16.3075 13.1067 16.0821C13.6545 15.8546 14.3296 15.8675 14.8732 16.2558L15.5494 16.7387C15.6861 16.8364 15.8734 16.8209 15.9922 16.7021L16.7013 15.993C16.8201 15.8742 16.8356 15.6869 16.738 15.5501L16.2551 14.8741C15.8668 14.3305 15.8539 13.6552 16.0814 13.1073C16.3069 12.5643 16.7928 12.0874 17.4553 11.977L18.2747 11.8405C18.4404 11.8128 18.5619 11.6694 18.5619 11.5014V10.4986C18.5619 10.3306 18.4404 10.1872 18.2747 10.1595L17.4552 10.0229C16.7928 9.91255 16.3069 9.43574 16.0815 8.89277C15.854 8.34497 15.8669 7.66984 16.2552 7.12629L16.7383 6.44994C16.836 6.3132 16.8205 6.12589 16.7016 6.00707L15.9925 5.29799C15.8737 5.17916 15.6864 5.16366 15.5497 5.26133L14.8736 5.74427C14.3299 6.1326 13.6546 6.14547 13.1067 5.91799C12.5637 5.69252 12.0868 5.20654 11.9764 4.54406L11.8399 3.72474C11.8122 3.55899 11.6688 3.4375 11.5008 3.4375H10.498Z"
          fill="#6D7175"
        />
      </svg>
    </Icon>
  );
});

export { Setting };
