import * as React from 'react';
import { Icon, IconProps } from '../../icon';

const ArrowLineLeft = React.forwardRef<SVGSVGElement, IconProps>(
  (props, ref) => {
    return (
      <Icon {...props}>
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22" fill="none">
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M3.38464 2.69702C3.76434 2.69702 4.07214 3.00483 4.07214 3.38452V18.6153C4.07214 18.995 3.76434 19.3028 3.38464 19.3028C3.00495 19.3028 2.69714 18.995 2.69714 18.6153V3.38452C2.69714 3.00483 3.00495 2.69702 3.38464 2.69702ZM12.6144 4.80223C12.8829 5.07071 12.8829 5.50601 12.6144 5.7745L8.07646 10.3124L19.109 10.3124C19.4887 10.3124 19.7965 10.6202 19.7965 10.9999C19.7965 11.3796 19.4887 11.6874 19.109 11.6874L8.07646 11.6874L12.6144 16.2253C12.8829 16.4938 12.8829 16.9291 12.6144 17.1976C12.3459 17.4661 11.9106 17.4661 11.6421 17.1976L5.93056 11.486C5.66207 11.2176 5.66207 10.7823 5.93056 10.5138L11.6421 4.80223C11.9106 4.53374 12.3459 4.53374 12.6144 4.80223Z"
            fill="#6D7175"
          />
        </svg>
      </Icon>
    );
  },
);

export { ArrowLineLeft };
