import * as React from 'react';
import { Icon, IconProps } from '../../icon';

const TrashIcon = React.forwardRef<SVGSVGElement, IconProps>((props, ref) => {
  return (
    <Icon {...props}>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        width="18"
        height="18"
        viewBox="0 0 18 18"
        fill="none">
        <path
          d="M6.92401 6.21036C7.22202 6.1989 7.4729 6.43119 7.48436 6.72921L7.74398 13.4792C7.75544 13.7772 7.52314 14.0281 7.22513 14.0396C6.92712 14.051 6.67624 13.8187 6.66478 13.5207L6.40516 6.77072C6.3937 6.4727 6.62599 6.22182 6.92401 6.21036Z"
          fill="#6D7175"
        />
        <path
          d="M11.0761 6.21036C11.3741 6.22182 11.6064 6.4727 11.5949 6.77072L11.3353 13.5207C11.3239 13.8187 11.073 14.051 10.775 14.0396C10.477 14.0281 10.2447 13.7772 10.2561 13.4792L10.5157 6.72921C10.5272 6.43119 10.7781 6.1989 11.0761 6.21036Z"
          fill="#6D7175"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M12.3525 3.54923V3.3586C12.3525 2.1968 11.4522 1.20568 10.2628 1.16763C9.84348 1.15422 9.42254 1.14746 9.00005 1.14746C8.57756 1.14746 8.15662 1.15422 7.73735 1.16763C6.54789 1.20568 5.64755 2.1968 5.64755 3.3586V3.54923C4.92501 3.61497 4.20851 3.70174 3.49868 3.80894C3.23834 3.84826 2.9789 3.89032 2.72038 3.9351C2.42652 3.98601 2.22957 4.26549 2.28047 4.55935C2.33138 4.8532 2.61086 5.05016 2.90472 4.99926C2.96504 4.98881 3.02541 4.97851 3.08583 4.96837L3.84179 14.7958C3.93106 15.9563 4.89878 16.8525 6.06273 16.8525H11.9374C13.1013 16.8525 14.069 15.9563 14.1583 14.7958L14.9143 4.96837C14.9747 4.97851 15.0351 4.98881 15.0954 4.99926C15.3892 5.05016 15.6687 4.8532 15.7196 4.55935C15.7705 4.26549 15.5736 3.98601 15.2797 3.9351C15.0212 3.89032 14.7618 3.84826 14.5014 3.80894C13.7916 3.70174 13.0751 3.61497 12.3525 3.54923ZM9.00005 2.22746C8.58907 2.22746 8.17965 2.23403 7.77188 2.24708C7.19319 2.26559 6.72755 2.75136 6.72755 3.3586V3.46699C7.47919 3.42086 8.23692 3.39746 9.00005 3.39746C9.76318 3.39746 10.5209 3.42086 11.2725 3.46699V3.3586C11.2725 2.75136 10.8069 2.26559 10.2282 2.24708C9.82045 2.23403 9.41103 2.22746 9.00005 2.22746ZM13.8436 4.80544C13.1588 4.71192 12.4677 4.63794 11.7709 4.5841C10.8567 4.51345 9.93263 4.47746 9.00005 4.47746C8.06747 4.47746 7.14341 4.51345 6.22915 4.5841C5.53239 4.63794 4.84131 4.71192 4.15649 4.80544L4.91861 14.713C4.9646 15.3108 5.46312 15.7725 6.06273 15.7725H11.9374C12.537 15.7725 13.0355 15.3108 13.0815 14.713L13.8436 4.80544Z"
          fill="#6D7175"
        />
      </svg>
    </Icon>
  );
});
export { TrashIcon };
