import * as React from 'react';
import { Icon, IconProps } from '../../icon';

const LegoSolid = React.forwardRef<SVGSVGElement, IconProps>((props, ref) => {
  return (
    <Icon {...props}>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none">
        <path
          d="M22.8357 6.82875L18.496 4.65938C17.957 3.67875 16.6135 3 15.0001 3C12.8973 3 11.2501 4.15313 11.2501 5.625C11.2503 5.83306 11.2838 6.03974 11.3495 6.23719L9.51947 7.15219C8.88125 6.88041 8.19374 6.74348 7.50009 6.75C5.39728 6.75 3.75009 7.90312 3.75009 9.375C3.7503 9.58306 3.78385 9.78974 3.84947 9.98719L1.16447 11.3287C1.03986 11.3911 0.93509 11.4869 0.861899 11.6055C0.788708 11.7241 0.749992 11.8607 0.750092 12V18C0.749992 18.1393 0.788708 18.2759 0.861899 18.3945C0.93509 18.5131 1.03986 18.6089 1.16447 18.6713L7.16447 21.6712C7.26866 21.7234 7.38358 21.7505 7.50009 21.7505C7.61661 21.7505 7.73152 21.7234 7.83572 21.6712L22.8357 14.1713C22.9603 14.1089 23.0651 14.0131 23.1383 13.8945C23.2115 13.7759 23.2502 13.6393 23.2501 13.5V7.5C23.2502 7.36067 23.2115 7.22406 23.1383 7.10549C23.0651 6.98693 22.9603 6.8911 22.8357 6.82875ZM7.50009 14.1619L3.17728 12L4.78134 11.1984C5.46009 11.6944 6.42009 12 7.50009 12C9.6029 12 11.2501 10.8469 11.2501 9.375C11.2465 8.93929 11.1036 8.51615 10.8423 8.1675L12.2813 7.44844C12.9601 7.94437 13.9201 8.25 15.0001 8.25C16.7232 8.25 18.1398 7.47563 18.5954 6.38625L20.8229 7.5L7.50009 14.1619ZM15.0001 4.5C16.2882 4.5 17.2501 5.09438 17.2501 5.625C17.2501 6.15562 16.2882 6.75 15.0001 6.75C13.712 6.75 12.7501 6.15562 12.7501 5.625C12.7501 5.09438 13.712 4.5 15.0001 4.5ZM7.50009 8.25C8.78822 8.25 9.75009 8.84438 9.75009 9.375C9.75009 9.90562 8.78822 10.5 7.50009 10.5C6.59353 10.5 5.84915 10.2056 5.48728 9.84375C5.46327 9.81274 5.43694 9.7836 5.40853 9.75656C5.31369 9.6512 5.25778 9.51655 5.25009 9.375C5.25009 8.84438 6.21197 8.25 7.50009 8.25ZM2.25009 13.2131L6.75009 15.4631V19.7869L2.25009 17.5369V13.2131ZM8.25009 19.7869V15.4631L21.7501 8.71313V13.0369L8.25009 19.7869Z"
          fill="#6D7175"
        />
      </svg>
    </Icon>
  );
});

export { LegoSolid };
