import * as React from 'react';

import { Icon, IconProps } from '../../icon';

const ExportIcon = React.forwardRef<SVGSVGElement, IconProps>((props, ref) => {
  return (
    <Icon {...props}>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        width="20"
        height="20"
        viewBox="0 0 20 20"
        fill="currentColor">
        <path
          fill-rule="evenodd"
          clip-rule="evenodd"
          d="M14.5581 2.05806C14.8021 1.81398 15.1979 1.81398 15.4419 2.05806L17.9419 4.55806C18.186 4.80214 18.186 5.19786 17.9419 5.44194L15.4419 7.94194C15.1979 8.18602 14.8021 8.18602 14.5581 7.94194C14.314 7.69786 14.314 7.30214 14.5581 7.05806L15.9911 5.625H14.8333C14.123 5.625 13.6278 5.62549 13.2422 5.65698C12.864 5.68789 12.6467 5.7455 12.4821 5.82936C12.1293 6.00913 11.8425 6.29596 11.6627 6.64877C11.5788 6.81337 11.5212 7.03067 11.4903 7.4089C11.4588 7.79443 11.4583 8.28962 11.4583 9V10C11.4583 10.3452 11.1785 10.625 10.8333 10.625C10.4882 10.625 10.2083 10.3452 10.2083 10V8.97323C10.2083 8.29587 10.2083 7.74953 10.2445 7.30711C10.2817 6.85158 10.3603 6.45146 10.5489 6.08128C10.8485 5.49327 11.3266 5.01521 11.9146 4.71561C12.2848 4.52699 12.6849 4.44835 13.1404 4.41114C13.5829 4.37499 14.1292 4.37499 14.8066 4.375H15.9911L14.5581 2.94194C14.314 2.69786 14.314 2.30214 14.5581 2.05806ZM6.47325 1.87507L8.33333 1.87507C8.67851 1.87507 8.95833 2.15489 8.95833 2.50007C8.95833 2.84525 8.67851 3.12507 8.33333 3.12507H6.5C5.78962 3.12507 5.29443 3.12555 4.9089 3.15705C4.53067 3.18796 4.31337 3.24556 4.14877 3.32943C3.79596 3.50919 3.50913 3.79603 3.32936 4.14884C3.2455 4.31343 3.18789 4.53074 3.15699 4.90897C3.12549 5.29449 3.125 5.78969 3.125 6.50007V13.5001C3.125 14.2104 3.12549 14.7056 3.15699 15.0912C3.18789 15.4694 3.2455 15.6867 3.32936 15.8513C3.50913 16.2041 3.79596 16.4909 4.14877 16.6707C4.31337 16.7546 4.53067 16.8122 4.9089 16.8431C5.29443 16.8746 5.78962 16.8751 6.5 16.8751H13.5C14.2104 16.8751 14.7056 16.8746 15.0911 16.8431C15.4693 16.8122 15.6866 16.7546 15.8512 16.6707C16.204 16.4909 16.4909 16.2041 16.6706 15.8513C16.7545 15.6867 16.8121 15.4694 16.843 15.0912C16.8745 14.7056 16.875 14.2104 16.875 13.5001V11.6667C16.875 11.3216 17.1548 11.0417 17.5 11.0417C17.8452 11.0417 18.125 11.3216 18.125 11.6667V13.5268C18.125 14.2042 18.125 14.7505 18.0889 15.193C18.0516 15.6485 17.973 16.0486 17.7844 16.4188C17.4848 17.0068 17.0067 17.4849 16.4187 17.7845C16.0485 17.9731 15.6484 18.0517 15.1929 18.0889C14.7505 18.1251 14.2041 18.1251 13.5268 18.1251H6.47323C5.79587 18.1251 5.24953 18.1251 4.80711 18.0889C4.35158 18.0517 3.95146 17.9731 3.58128 17.7845C2.99327 17.4849 2.51521 17.0068 2.21561 16.4188C2.02699 16.0486 1.94835 15.6485 1.91114 15.193C1.87499 14.7505 1.87499 14.2042 1.875 13.5268V6.47331C1.87499 5.79595 1.87499 5.2496 1.91114 4.80718C1.94835 4.35165 2.02699 3.95153 2.2156 3.58135C2.51521 2.99334 2.99327 2.51528 3.58128 2.21567C3.95146 2.02706 4.35158 1.94842 4.80711 1.9112C5.24953 1.87506 5.79588 1.87506 6.47325 1.87507Z"
        />
      </svg>
    </Icon>
  );
});

export { ExportIcon };
