import unittest

from proces import mask_phone, mask_address


class TestMasking(unittest.TestCase):
    def setUp(self) -> None:
        self.phone_data = {
            "13397238231": "133********",
            "手机13397238231": "手机133********",
            "手机号 13397238231": "手机号 133********",
            "手机号 13397238231,": "手机号 133********,",
            "19997238231": "199********",
            "+8613397238231": "+86133********",
            "手机+8613397238231": "手机+86133********",
            "手机号 +8613397238231": "手机号 +86133********",
            "手机号 +8613397238231,": "手机号 +86133********,",
            "8613397238231": "86133********",
            "（86）13397238231": "（86）133********",
            "(86)13397238231": "(86)133********",
        }

        self.address_data = {
            "浙江省杭州市": "浙江省杭州市",
            "我在浙江省杭州市": "我在浙江省杭州市",
            "我在浙江省杭州市余杭区": "我在浙江省杭州市***",
            "我在浙江省杭州市余杭区西溪湿地": "我在浙江省杭州市***",
            "我在浙江省杭州市余杭区 西溪湿地": "我在浙江省杭州市*** 西溪湿地",
            "浙江杭州市": "浙江杭州市",
            "我在浙江杭州市": "我在浙江杭州市",
            "我在浙江杭州市余杭区": "我在浙江杭州市***",
            "我在浙江杭州市余杭区西溪湿地": "我在浙江杭州市***",
            "我在浙江杭州市余杭区 西溪湿地": "我在浙江杭州市*** 西溪湿地",
            "浙江杭州": "浙江杭州",
            "我在浙江杭州": "我在浙江杭州",
            "我在浙江杭州余杭区": "我在浙江杭州***",
            "我在浙江杭州余杭区西溪湿地": "我在浙江杭州***",
            "我在浙江杭州余杭区 西溪湿地": "我在浙江杭州*** 西溪湿地",
            "我在浙江杭州余杭区，西溪湿地": "我在浙江杭州***，西溪湿地",
            "我在浙江杭州余杭区-西溪湿地": "我在浙江杭州***-西溪湿地",
            "我在浙江杭州余杭区13397238231": "我在浙江杭州***",
            "杭州": "杭州",
            "杭州市": "杭州市",
            "杭州余杭区": "杭州***",
            "我在杭州余杭区": "我在杭州***",
            "我在杭州余杭区西溪湿地": "我在杭州***",
            "我在杭州余杭区 西溪湿地": "我在杭州*** 西溪湿地",
            "我在杭州余杭区，西溪湿地": "我在杭州***，西溪湿地",
            "我在杭州余杭区-西溪湿地": "我在杭州***-西溪湿地",
            "我在杭州余杭区13397238231": "我在杭州***"
        }

    def test_mask_hone(self) -> None:
        for key, value in self.phone_data.items():
            self.assertEqual(mask_phone(key), value)

    def test_mask_address(self) -> None:
        for key, value in self.address_data.items():
            self.assertEqual(mask_address(key), value)


if __name__ == '__main__':
    unittest.main()
