/*
 * Decompiled with CFR 0.152.
 */
package launch;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.websocket.EncodeException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import launch.HandlerSocket;

@ApplicationScoped
@ServerEndpoint(value="/endpoint")
public class MyWebSocket {
    private static List<HandlerSocket> listSocket = Collections.synchronizedList(new ArrayList());

    public void XyluPacket(HandlerSocket handlerSocket, ByteBuffer buffer) throws IOException, Exception {
        OutputStream wr = handlerSocket.sk.getOutputStream();
        byte[] arr = new byte[buffer.remaining()];
        buffer.get(arr);
        wr.write(arr);
        wr.flush();
    }

    public void XyluPacketLanDau(HandlerSocket handlerSocket, String host, int port, byte[] HeaderHttp) throws IOException, Exception {
        handlerSocket.host = host;
        handlerSocket.port = port;
        handlerSocket.HeaderHttp = HeaderHttp;
    }

    @OnMessage
    public void onMessage(ByteBuffer buffer, Session session) throws IOException, EncodeException {
        try {
            for (HandlerSocket handlerSocket : listSocket) {
                if (!session.getId().equals(handlerSocket.idsession)) continue;
                this.XyluPacket(handlerSocket, buffer);
                return;
            }
        }
        catch (Exception e) {
            System.out.println("loi" + e.getMessage());
        }
    }

    @OnOpen
    public void onOpen(Session session) throws IOException {
        HandlerSocket handlerSocket = new HandlerSocket(session.getId(), session);
        listSocket.add(handlerSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClose
    public void onClose(Session session) throws IOException {
        List<HandlerSocket> list = listSocket;
        synchronized (list) {
            Iterator<HandlerSocket> it = listSocket.iterator();
            while (it.hasNext()) {
                HandlerSocket handlerSocket = it.next();
                if (!session.getId().equals(handlerSocket.idsession)) continue;
                if (handlerSocket.sk != null && handlerSocket.sk.isConnected()) {
                    handlerSocket.sk.close();
                }
                it.remove();
            }
        }
    }

    @OnMessage
    public void onMessage(String message, Session session) throws InterruptedException, Exception {
        System.out.println("onMessage::From=" + session.getId() + " Message=" + message);
        try {
            session.getBasicRemote().sendText("Hello Client " + session.getId() + "!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @OnError
    public void onError(Throwable t) {
        System.out.println("onError::" + t.getMessage());
    }
}

