/*
 * Decompiled with CFR 0.152.
 */
package httpproxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;

public class main {
    private static final int PORT = 7860;
    static byte[] httppatern = new byte[]{72, 84, 84, 80};

    public static void main(String[] args) {
        try {
            InetAddress baddress = InetAddress.getByName("0.0.0.0");
            ServerSocket server = new ServerSocket(7860, 50, baddress);
            while (true) {
                System.out.println("MiniServer active 7860");
                Socket clientSocket = server.accept();
                new ThreadSocket(clientSocket).start();
            }
        }
        catch (Exception e) {
            e.getMessage();
            return;
        }
    }

    private static void sendResponse(OutputStream outputStream, String statusLine, String message) throws IOException {
        String response = statusLine + "\r\nContent-Type: text/plain\r\nContent-Length: " + message.length() + "\r\nConnection: close\r\n\r\n" + message;
        outputStream.write(response.getBytes());
    }

    public static int[] computeLPSArray(byte[] pattern) {
        int[] lps = new int[pattern.length];
        int len = 0;
        int i = 1;
        lps[0] = 0;
        while (i < pattern.length) {
            if (pattern[i] == pattern[len]) {
                lps[i] = ++len;
                ++i;
                continue;
            }
            if (len != 0) {
                len = lps[len - 1];
                continue;
            }
            lps[i] = 0;
            ++i;
        }
        return lps;
    }

    public static boolean kmpSearch(byte[] pattern, byte[] text) {
        int[] lps = main.computeLPSArray(pattern);
        int i = 0;
        int j = 0;
        while (i < text.length) {
            if (pattern[j] == text[i]) {
                ++j;
                ++i;
            }
            if (j == pattern.length) {
                return true;
            }
            if (i >= text.length || pattern[j] == text[i]) continue;
            if (j != 0) {
                j = lps[j - 1];
                continue;
            }
            ++i;
        }
        return false;
    }

    private static class ThreadSocket
    extends Thread {
        private Socket insocket;

        ThreadSocket(Socket insocket) {
            this.insocket = insocket;
        }

        @Override
        public void run() {
            try {
                InputStream is = this.insocket.getInputStream();
                OutputStream out = this.insocket.getOutputStream();
                byte[] buffer = new byte[1024];
                byte[] outx = null;
                int bytesRead = 0;
                bytesRead = is.read(buffer);
                if (bytesRead == -1) {
                    main.sendResponse(out, "HTTP/1.1 502 Bad Gateway", "Bad Gateway");
                    out.close();
                    this.insocket.close();
                    return;
                }
                outx = Arrays.copyOfRange(buffer, 0, bytesRead);
                System.out.println(new String(outx));
                main.sendResponse(out, "HTTP/1.1 200 OK", "Success");
                out.close();
                this.insocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

