/*
 * Decompiled with CFR 0.152.
 */
package httpproxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class HttpServer_test {
    public static void main(String[] args) throws IOException {
        int port = 8080;
        try {
            InetAddress baddress = InetAddress.getByName("0.0.0.0");
            ServerSocket serverSocket = new ServerSocket(port, 50, baddress);
            System.out.println("Server Listening on port " + port);
            while (true) {
                Socket clientSocket = serverSocket.accept();
                new requestHandler(clientSocket).start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private static void htmlHandler(OutputStream outputStream) throws IOException {
        HttpServer_test.sendResponse(outputStream, "HTTP/1.1 200 OK", "Success");
    }

    private static void sendResponse(OutputStream outputStream, String statusLine, String message) throws IOException {
        String response = statusLine + "\r\nContent-Type: text/plain\r\nContent-Length: " + message.length() + "\r\nConnection: close\r\n\r\n" + message;
        outputStream.write(response.getBytes());
    }

    private static class requestHandler
    extends Thread {
        private Socket socket;

        public requestHandler(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                OutputStream outputStream = this.socket.getOutputStream();
                try {
                    String inputLine;
                    while ((inputLine = bufferedReader.readLine()) != null) {
                        System.out.println(inputLine);
                        HttpServer_test.sendResponse(outputStream, "HTTP/1.1 200 OK", inputLine);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

