/*
 * Decompiled with CFR 0.152.
 */
package httpproxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class HttpServer {
    public static void main(String[] args) throws IOException {
        int port = 8080;
        try {
            InetAddress baddress = InetAddress.getByName("0.0.0.0");
            ServerSocket serverSocket = new ServerSocket(port, 50, baddress);
            System.out.println("Server Listening on port " + port);
            while (true) {
                System.out.println("connect " + port);
                Socket clientSocket = serverSocket.accept();
                new requestHandler(clientSocket).start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private static void htmlHandler(OutputStream outputStream) throws IOException {
        HttpServer.sendResponse(outputStream, "HTTP/1.1 200 OK", "Success");
    }

    private static void sendResponse(OutputStream outputStream, String statusLine, String message) throws IOException {
        String response = statusLine + "\r\nContent-Type: text/plain\r\nContent-Length: " + message.length() + "\r\nConnection: close\r\n\r\n" + message;
        outputStream.write(response.getBytes());
    }

    private static class requestHandler
    extends Thread {
        private Socket socket;

        public requestHandler(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                OutputStream outputStream = this.socket.getOutputStream();
                String request = bufferedReader.readLine();
                System.out.println(request);
                if (request != null) {
                    String[] requestParts = request.split(" ");
                    String method = requestParts[0];
                    if (method.equals("GET") || method.equals("HEAD")) {
                        HttpServer.sendResponse(outputStream, "HTTP/1.1 200 OK", "Success");
                    } else {
                        HttpServer.sendResponse(outputStream, "HTTP/1.1 405 Method Not Allowed", "Method Not Allowed");
                    }
                }
                bufferedReader.close();
                outputStream.close();
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

