import{s as hi,o as Ui,n as _}from"../chunks/scheduler.8c3d61f6.js";import{S as Ti,i as Ji,g as r,s as n,r as y,A as bi,h as f,f as l,c as a,j as yi,u as h,x as u,k as ys,y as wi,a as t,v as U,d as T,t as J,w as b}from"../chunks/index.da70eac4.js";import{T as at}from"../chunks/Tip.1d9b8c37.js";import{C as j}from"../chunks/CodeBlock.a9c4becf.js";import{D as ji}from"../chunks/DocNotebookDropdown.48852948.js";import{H as $,E as Zi}from"../chunks/getInferenceSnippets.725ed3d4.js";import{H as pt,a as hs}from"../chunks/HfOption.6c3b4e77.js";function gi(w){let i,c='Skip to the <a href="#diffusionpipeline-explained">DiffusionPipeline explained</a> section if you’re interested in an explanation about how the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class works.';return{c(){i=r("p"),i.innerHTML=c},l(p){i=f(p,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1u8oykr"&&(i.innerHTML=c)},m(p,d){t(p,i,d)},p:_,d(p){p&&l(i)}}}function vi(w){let i,c='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class is a simple and generic way to load the latest trending diffusion model from the <a href="https://huggingface.co/models?library=diffusers&amp;sort=trending" rel="nofollow">Hub</a>. It uses the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method to automatically detect the correct pipeline class for a task from the checkpoint, downloads and caches all the required configuration and weight files, and returns a pipeline ready for inference.',p,d,o,m,Z='This same checkpoint can also be used for an image-to-image task. The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class can handle any task as long as you provide the appropriate inputs. For example, for an image-to-image task, you need to pass an initial image to the pipeline.',g,v,C;return d=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),v=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbWcyaW1nLWluaXQucG5nJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>)
prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=r("p"),i.innerHTML=c,p=n(),y(d.$$.fragment),o=n(),m=r("p"),m.innerHTML=Z,g=n(),y(v.$$.fragment)},l(M){i=f(M,"P",{"data-svelte-h":!0}),u(i)!=="svelte-193oq91"&&(i.innerHTML=c),p=a(M),h(d.$$.fragment,M),o=a(M),m=f(M,"P",{"data-svelte-h":!0}),u(m)!=="svelte-1thtl5s"&&(m.innerHTML=Z),g=a(M),h(v.$$.fragment,M)},m(M,I){t(M,i,I),t(M,p,I),U(d,M,I),t(M,o,I),t(M,m,I),t(M,g,I),U(v,M,I),C=!0},p:_,i(M){C||(T(d.$$.fragment,M),T(v.$$.fragment,M),C=!0)},o(M){J(d.$$.fragment,M),J(v.$$.fragment,M),C=!1},d(M){M&&(l(i),l(p),l(o),l(m),l(g)),b(d,M),b(v,M)}}}function Ii(w){let i,c='Checkpoints can be loaded by their specific pipeline class if you already know it. For example, to load a Stable Diffusion model, use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> class.',p,d,o,m,Z='This same checkpoint may also be used for another task like image-to-image. To differentiate what task you want to use the checkpoint for, you have to use the corresponding task-specific pipeline class. For example, to use the same checkpoint for image-to-image, use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a> class.',g,v,C;return d=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),v=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

pipeline = StableDiffusionImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){i=r("p"),i.innerHTML=c,p=n(),y(d.$$.fragment),o=n(),m=r("p"),m.innerHTML=Z,g=n(),y(v.$$.fragment)},l(M){i=f(M,"P",{"data-svelte-h":!0}),u(i)!=="svelte-b1p9rv"&&(i.innerHTML=c),p=a(M),h(d.$$.fragment,M),o=a(M),m=f(M,"P",{"data-svelte-h":!0}),u(m)!=="svelte-14muyt8"&&(m.innerHTML=Z),g=a(M),h(v.$$.fragment,M)},m(M,I){t(M,i,I),t(M,p,I),U(d,M,I),t(M,o,I),t(M,m,I),t(M,g,I),U(v,M,I),C=!0},p:_,i(M){C||(T(d.$$.fragment,M),T(v.$$.fragment,M),C=!0)},o(M){J(d.$$.fragment,M),J(v.$$.fragment,M),C=!1},d(M){M&&(l(i),l(p),l(o),l(m),l(g)),b(d,M),b(v,M)}}}function Ci(w){let i,c,p,d;return i=new hs({props:{id:"pipelines",option:"generic pipeline",$$slots:{default:[vi]},$$scope:{ctx:w}}}),p=new hs({props:{id:"pipelines",option:"specific pipeline",$$slots:{default:[Ii]},$$scope:{ctx:w}}}),{c(){y(i.$$.fragment),c=n(),y(p.$$.fragment)},l(o){h(i.$$.fragment,o),c=a(o),h(p.$$.fragment,o)},m(o,m){U(i,o,m),t(o,c,m),U(p,o,m),d=!0},p(o,m){const Z={};m&2&&(Z.$$scope={dirty:m,ctx:o}),i.$set(Z);const g={};m&2&&(g.$$scope={dirty:m,ctx:o}),p.$set(g)},i(o){d||(T(i.$$.fragment,o),T(p.$$.fragment,o),d=!0)},o(o){J(i.$$.fragment,o),J(p.$$.fragment,o),d=!1},d(o){o&&l(c),b(i,o),b(p,o)}}}function $i(w){let i,c='To switch between tasks (rather than features), use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method with the <a href="../api/pipelines/auto_pipeline">AutoPipeline</a> class, which automatically identifies the pipeline class based on the task (learn more in the <a href="../tutorials/autopipeline">AutoPipeline</a> tutorial).';return{c(){i=r("p"),i.innerHTML=c},l(p){i=f(p,"P",{"data-svelte-h":!0}),u(i)!=="svelte-16alrk5"&&(i.innerHTML=c)},m(p,d){t(p,i,d)},p:_,d(p){p&&l(i)}}}function _i(w){let i,c='Some pipeline methods may not function properly on new pipelines created with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a>. For instance, the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> method installs hooks on the model components based on a unique offloading sequence for each pipeline. If the models are executed in a different order in the new pipeline, the CPU offloading may not work correctly.',p,d,o='To ensure everything works as expected, we recommend re-applying a pipeline method on a new pipeline created with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a>.';return{c(){i=r("p"),i.innerHTML=c,p=n(),d=r("p"),d.innerHTML=o},l(m){i=f(m,"P",{"data-svelte-h":!0}),u(i)!=="svelte-150boki"&&(i.innerHTML=c),p=a(m),d=f(m,"P",{"data-svelte-h":!0}),u(d)!=="svelte-gydtfi"&&(d.innerHTML=o)},m(m,Z){t(m,i,Z),t(m,p,Z),t(m,d,Z)},p:_,d(m){m&&(l(i),l(p),l(d))}}}function Gi(w){let i,c='When the checkpoints have identical model structures, but they were trained on different datasets and with a different training setup, they should be stored in separate repositories. For example, <a href="https://hf.co/stabilityai/stable-diffusion-2" rel="nofollow">stabilityai/stable-diffusion-2</a> and <a href="https://hf.co/stabilityai/stable-diffusion-2-1" rel="nofollow">stabilityai/stable-diffusion-2-1</a> are stored in separate repositories.';return{c(){i=r("p"),i.innerHTML=c},l(p){i=f(p,"P",{"data-svelte-h":!0}),u(i)!=="svelte-11b88rc"&&(i.innerHTML=c)},m(p,d){t(p,i,d)},p:_,d(p){p&&l(i)}}}function Vi(w){let i,c;return i=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),{c(){y(i.$$.fragment)},l(p){h(i.$$.fragment,p)},m(p,d){U(i,p,d),c=!0},p:_,i(p){c||(T(i.$$.fragment,p),c=!0)},o(p){J(i.$$.fragment,p),c=!1},d(p){b(i,p)}}}function ki(w){let i,c;return i=new j({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMm5vbl9lbWElMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),{c(){y(i.$$.fragment)},l(p){h(i.$$.fragment,p)},m(p,d){U(i,p,d),c=!0},p:_,i(p){c||(T(i.$$.fragment,p),c=!0)},o(p){J(i.$$.fragment,p),c=!1},d(p){b(i,p)}}}function Wi(w){let i,c,p,d;return i=new hs({props:{id:"variants",option:"fp16",$$slots:{default:[Vi]},$$scope:{ctx:w}}}),p=new hs({props:{id:"variants",option:"non-EMA",$$slots:{default:[ki]},$$scope:{ctx:w}}}),{c(){y(i.$$.fragment),c=n(),y(p.$$.fragment)},l(o){h(i.$$.fragment,o),c=a(o),h(p.$$.fragment,o)},m(o,m){U(i,o,m),t(o,c,m),U(p,o,m),d=!0},p(o,m){const Z={};m&2&&(Z.$$scope={dirty:m,ctx:o}),i.$set(Z);const g={};m&2&&(g.$$scope={dirty:m,ctx:o}),p.$set(g)},i(o){d||(T(i.$$.fragment,o),T(p.$$.fragment,o),d=!0)},o(o){J(i.$$.fragment,o),J(p.$$.fragment,o),d=!1},d(o){o&&l(c),b(i,o),b(p,o)}}}function Ri(w){let i,c;return i=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline.save_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)`,wrap:!1}}),{c(){y(i.$$.fragment)},l(p){h(i.$$.fragment,p)},m(p,d){U(i,p,d),c=!0},p:_,i(p){c||(T(i.$$.fragment,p),c=!0)},o(p){J(i.$$.fragment,p),c=!1},d(p){b(i,p)}}}function Bi(w){let i,c;return i=new j({props:{code:"cGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJub25fZW1hJTIyKQ==",highlighted:'pipeline.save_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)',wrap:!1}}),{c(){y(i.$$.fragment)},l(p){h(i.$$.fragment,p)},m(p,d){U(i,p,d),c=!0},p:_,i(p){c||(T(i.$$.fragment,p),c=!0)},o(p){J(i.$$.fragment,p),c=!1},d(p){b(i,p)}}}function Ni(w){let i,c,p,d;return i=new hs({props:{id:"save",option:"fp16",$$slots:{default:[Ri]},$$scope:{ctx:w}}}),p=new hs({props:{id:"save",option:"non_ema",$$slots:{default:[Bi]},$$scope:{ctx:w}}}),{c(){y(i.$$.fragment),c=n(),y(p.$$.fragment)},l(o){h(i.$$.fragment,o),c=a(o),h(p.$$.fragment,o)},m(o,m){U(i,o,m),t(o,c,m),U(p,o,m),d=!0},p(o,m){const Z={};m&2&&(Z.$$scope={dirty:m,ctx:o}),i.$set(Z);const g={};m&2&&(g.$$scope={dirty:m,ctx:o}),p.$set(g)},i(o){d||(T(i.$$.fragment,o),T(p.$$.fragment,o),d=!0)},o(o){J(i.$$.fragment,o),J(p.$$.fragment,o),d=!1},d(o){o&&l(c),b(i,o),b(p,o)}}}function Xi(w){let i,c,p,d,o,m,Z,g,v,C='Diffusion systems consist of multiple components like parameterized models and schedulers that interact in complex ways. That is why we designed the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to wrap the complexity of the entire diffusion system into an easy-to-use API. At the same time, the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is entirely customizable so you can modify each component to build a diffusion system for your use case.',M,I,ot="This guide will show you how to load:",Ts,q,rt="<li>pipelines from the Hub and locally</li> <li>different components into a pipeline</li> <li>multiple pipelines without increasing memory usage</li> <li>checkpoint variants such as different floating point types or non-exponential mean averaged (EMA) weights</li>",Js,E,bs,G,ws,z,ft="There are two ways to load a pipeline for a task:",js,F,ut='<li>Load the generic <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class and allow it to automatically detect the correct pipeline class from the checkpoint.</li> <li>Load a specific pipeline class for a specific task.</li>',Zs,V,gs,H,ct="Use the Space below to gauge a pipeline’s memory requirements before you download and load it to see if it runs on your hardware.",vs,k,dt='<iframe src="https://diffusers-compute-pipeline-size.hf.space?__theme=light" width="850" height="1600"></iframe>',Is,W,mt='<iframe src="https://diffusers-compute-pipeline-size.hf.space?__theme=dark" width="850" height="1600"></iframe>',Cs,D,$s,A,Mt="You can customize the data types for individual sub-models by passing a dictionary to the <code>torch_dtype</code> parameter. This allows you to load different components of a pipeline in different floating point precisions. For instance, if you want to load the transformer with <code>torch.bfloat16</code> and all other components with <code>torch.float16</code>, you can pass a dictionary mapping:",_s,L,Gs,P,yt="If a component is not explicitly specified in the dictionary and no <code>default</code> is provided, it will be loaded with <code>torch.float32</code>.",Vs,O,ks,K,ht='Large models are often <a href="../training/distributed_inference#model-sharding">sharded</a> into smaller files so that they are easier to load. Diffusers supports loading shards in parallel to speed up the loading process.',Ws,ee,Ut="Set the environment variables below to enable parallel loading.",Rs,se,Tt="<li>Set <code>HF_ENABLE_PARALLEL_LOADING</code> to <code>&quot;YES&quot;</code> to enable parallel loading of shards.</li> <li>Set <code>HF_PARALLEL_LOADING_WORKERS</code> to configure the number of parallel threads to use when loading shards. More workers loads a model faster but uses more memory.</li>",Bs,le,Jt="The <code>device_map</code> argument should be set to <code>&quot;cuda&quot;</code> to pre-allocate a large chunk of memory based on the model size. This substantially reduces model load time because warming up the memory allocator now avoids many smaller calls to the allocator later.",Ns,te,Xs,ie,Qs,ne,bt='To load a pipeline locally, use <a href="https://git-lfs.github.com/" rel="nofollow">git-lfs</a> to manually download a checkpoint to your local disk.',Ss,ae,Ys,pe,wt='This creates a local folder, ./stable-diffusion-v1-5, on your disk and you should pass its path to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>.',xs,oe,qs,re,jt='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method won’t download files from the Hub when it detects a local path, but this also means it won’t download and cache the latest changes to a checkpoint.',Es,fe,zs,ue,Zt="You can customize a pipeline by loading different components into it. This is important because you can:",Fs,ce,gt="<li>change to a scheduler with faster generation speed or higher generation quality depending on your needs (call the <code>scheduler.compatibles</code> method on your pipeline to see compatible schedulers)</li> <li>change a default pipeline component to a newer and better performing one</li>",Hs,de,vt='For example, let’s customize the default <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> checkpoint with:',Ds,me,It='<li>The <a href="/docs/diffusers/main/en/api/schedulers/heun#diffusers.HeunDiscreteScheduler">HeunDiscreteScheduler</a> to generate higher quality images at the expense of slower generation speed. You must pass the <code>subfolder=&quot;scheduler&quot;</code> parameter in <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">from_pretrained()</a> to load the scheduler configuration into the correct <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0/tree/main/scheduler" rel="nofollow">subfolder</a> of the pipeline repository.</li> <li>A more stable VAE that runs in fp16.</li>',As,Me,Ls,ye,Ct='Now pass the new scheduler and VAE to the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>.',Ps,he,Os,Ue,Ks,Te,$t="When you load multiple pipelines that share the same model components, it makes sense to reuse the shared components instead of reloading everything into memory again, especially if your hardware is memory-constrained. For example:",el,Je,_t='<li>You generated an image with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> but you want to improve its quality with the <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a>. Both of these pipelines share the same pretrained model, so it’d be a waste of memory to load the same model twice.</li> <li>You want to add a model component, like a <a href="../api/pipelines/animatediff#animatediffpipeline"><code>MotionAdapter</code></a>, to <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> which was instantiated from an existing <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>. Again, both pipelines share the same pretrained model, so it’d be a waste of memory to load an entirely new pipeline again.</li>',sl,be,Gt='With the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">DiffusionPipeline.from_pipe()</a> API, you can switch between multiple pipelines to take advantage of their different features without increasing memory-usage. It is similar to turning on and off a feature in your pipeline.',ll,R,tl,we,Vt='Let’s start with a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and then reuse the loaded model components to create a <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a> to increase generation quality. You’ll use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> with an <a href="./ip_adapter">IP-Adapter</a> to generate a bear eating pizza.',il,je,nl,B,kt='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_sd_0.png"/>',al,Ze,Wt="For reference, you can check how much memory this process consumed.",pl,ge,ol,ve,Rt='Now, reuse the same pipeline components from <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> in <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a> with the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method.',rl,N,fl,Ie,ul,X,Bt='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_sag_1.png"/>',cl,Ce,Nt='If you check the memory usage, you’ll see it remains the same as before because <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a> are sharing the same pipeline components. This allows you to use them interchangeably without any additional memory overhead.',dl,$e,ml,_e,Xt='Let’s animate the image with the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> and also add a <code>MotionAdapter</code> module to the pipeline. For the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>, you need to unload the IP-Adapter first and reload it <em>after</em> you’ve created your new pipeline (this only applies to the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>).',Ml,Ge,yl,Q,Qt='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_animate_3.gif"/>',hl,Ve,St='The <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> is more memory-intensive and consumes 15GB of memory (see the <a href="#memory-usage-of-from_pipe">Memory-usage of from_pipe</a> section to learn what this means for your memory-usage).',Ul,ke,Tl,We,Jl,Re,Yt='Pipelines loaded with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> can be customized with different model components or methods. However, whenever you modify the <em>state</em> of the model components, it affects all the other pipelines that share the same components. For example, if you call <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.unload_ip_adapter">unload_ip_adapter()</a> on the <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a>, you won’t be able to use IP-Adapter with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> because it’s been removed from their shared components.',bl,Be,wl,Ne,jl,Xe,xt='The memory requirement of loading multiple pipelines with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> is determined by the pipeline with the highest memory-usage regardless of the number of pipelines you create.',Zl,Qe,qt="<thead><tr><th>Pipeline</th> <th>Memory usage (GB)</th></tr></thead> <tbody><tr><td>StableDiffusionPipeline</td> <td>4.400</td></tr> <tr><td>StableDiffusionSAGPipeline</td> <td>4.400</td></tr> <tr><td>AnimateDiffPipeline</td> <td>15.178</td></tr></tbody>",gl,Se,Et='The <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> has the highest memory requirement, so the <em>total memory-usage</em> is based only on the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>. Your memory-usage will not increase if you create additional pipelines as long as their memory requirements doesn’t exceed that of the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>. Each pipeline can be used interchangeably without any additional memory overhead.',vl,Ye,Il,xe,zt='Diffusers implements a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">safety checker</a> for Stable Diffusion models which can generate harmful content. The safety checker screens the generated output against known hardcoded not-safe-for-work (NSFW) content. If for whatever reason you’d like to disable the safety checker, pass <code>safety_checker=None</code> to the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method.',Cl,qe,$l,Ee,_l,ze,Ft="A checkpoint variant is usually a checkpoint whose weights are:",Gl,Fe,Ht='<li>Stored in a different floating point type, such as <a href="https://pytorch.org/docs/stable/tensors.html#data-types" rel="nofollow">torch.float16</a>, because it only requires half the bandwidth and storage to download. You can’t use this variant if you’re continuing training or using a CPU.</li> <li>Non-exponential mean averaged (EMA) weights which shouldn’t be used for inference. You should use this variant to continue finetuning a model.</li>',Vl,S,kl,He,Dt='Otherwise, a variant is <strong>identical</strong> to the original checkpoint. They have exactly the same serialization format (like <a href="./using_safetensors">safetensors</a>), model structure, and their weights have identical tensor shapes.',Wl,De,At="<thead><tr><th><strong>checkpoint type</strong></th> <th><strong>weight name</strong></th> <th><strong>argument for loading weights</strong></th></tr></thead> <tbody><tr><td>original</td> <td>diffusion_pytorch_model.safetensors</td> <td></td></tr> <tr><td>floating point</td> <td>diffusion_pytorch_model.fp16.safetensors</td> <td><code>variant</code>, <code>torch_dtype</code></td></tr> <tr><td>non-EMA</td> <td>diffusion_pytorch_model.non_ema.safetensors</td> <td><code>variant</code></td></tr></tbody>",Rl,Ae,Lt="There are two important arguments for loading variants:",Bl,Le,Pt='<li><p><code>torch_dtype</code> specifies the floating point precision of the loaded checkpoint. For example, if you want to save bandwidth by loading a fp16 variant, you should set <code>variant=&quot;fp16&quot;</code> and <code>torch_dtype=torch.float16</code> to <em>convert the weights</em> to fp16. Otherwise, the fp16 weights are converted to the default fp32 precision.</p> <p>If you only set <code>torch_dtype=torch.float16</code>, the default fp32 weights are downloaded first and then converted to fp16.</p></li> <li><p><code>variant</code> specifies which files should be loaded from the repository. For example, if you want to load a non-EMA variant of a UNet from <a href="https://hf.co/stable-diffusion-v1-5/stable-diffusion-v1-5/tree/main/unet" rel="nofollow">stable-diffusion-v1-5/stable-diffusion-v1-5</a>, set <code>variant=&quot;non_ema&quot;</code> to download the <code>non_ema</code> file.</p></li>',Nl,Y,Xl,Pe,Ot='Use the <code>variant</code> parameter in the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">DiffusionPipeline.save_pretrained()</a> method to save a checkpoint as a different floating point type or as a non-EMA variant. You should try save a variant to the same folder as the original checkpoint, so you have the option of loading both from the same folder.',Ql,x,Sl,Oe,Kt="If you don’t save the variant to an existing folder, you must specify the <code>variant</code> argument otherwise it’ll throw an <code>Exception</code> because it can’t find the original checkpoint.",Yl,Ke,xl,es,ql,ss,ei='As a class method, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> is responsible for two things:',El,ls,si='<li>Download the latest version of the folder structure required for inference and cache it. If the latest folder structure is available in the local cache, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> reuses the cache and won’t redownload the files.</li> <li>Load the cached weights into the correct pipeline <a href="../api/pipelines/overview#diffusers-summary">class</a> - retrieved from the <code>model_index.json</code> file - and return an instance of it.</li>',zl,ts,li='The pipelines’ underlying folder structure corresponds directly with their class instances. For example, the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> corresponds to the folder structure in <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a>.',Fl,is,Hl,ns,ti='You’ll see pipeline is an instance of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, which consists of seven components:',Dl,as,ii='<li><code>&quot;feature_extractor&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a> from 🤗 Transformers.</li> <li><code>&quot;safety_checker&quot;</code>: a <a href="https://github.com/huggingface/diffusers/blob/e55687e1e15407f60f32242027b7bb8170e58266/src/diffusers/pipelines/stable_diffusion/safety_checker.py#L32" rel="nofollow">component</a> for screening against harmful content.</li> <li><code>&quot;scheduler&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.</li> <li><code>&quot;text_encoder&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> from 🤗 Transformers.</li> <li><code>&quot;tokenizer&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> from 🤗 Transformers.</li> <li><code>&quot;unet&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>.</li> <li><code>&quot;vae&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>.</li>',Al,ps,Ll,os,ni='Compare the components of the pipeline instance to the <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/tree/main" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a> folder structure, and you’ll see there is a separate folder for each of the components in the repository:',Pl,rs,Ol,fs,ai="You can access each of the components of the pipeline as an attribute to view its configuration:",Kl,us,et,cs,pi='Every pipeline expects a <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> file that tells the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',st,ds,oi="<li>which pipeline class to load from <code>_class_name</code></li> <li>which version of 🧨 Diffusers was used to create the model in <code>_diffusers_version</code></li> <li>what components from which library are stored in the subfolders (<code>name</code> corresponds to the component and subfolder name, <code>library</code> corresponds to the name of the library to load the class from, and <code>class</code> corresponds to the class name)</li>",lt,ms,tt,Ms,it,Us,nt;return o=new $({props:{title:"Load pipelines",local:"load-pipelines",headingTag:"h1"}}),Z=new ji({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"}]}}),E=new $({props:{title:"Load a pipeline",local:"load-a-pipeline",headingTag:"h2"}}),G=new at({props:{warning:!1,$$slots:{default:[gi]},$$scope:{ctx:w}}}),V=new pt({props:{id:"pipelines",options:["generic pipeline","specific pipeline"],$$slots:{default:[Ci]},$$scope:{ctx:w}}}),D=new $({props:{title:"Specifying Component-Specific Data Types",local:"specifying-component-specific-data-types",headingTag:"h3"}}),L=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEh1bnl1YW5WaWRlb1BpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwSHVueXVhblZpZGVvUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmh1bnl1YW52aWRlby1jb21tdW5pdHklMkZIdW55dWFuVmlkZW8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRCU3QiUyMnRyYW5zZm9ybWVyJTIyJTNBJTIwdG9yY2guYmZsb2F0MTYlMkMlMjAlMjJkZWZhdWx0JTIyJTNBJTIwdG9yY2guZmxvYXQxNiU3RCUyQyUwQSklMEFwcmludChwaXBlLnRyYW5zZm9ybWVyLmR0eXBlJTJDJTIwcGlwZS52YWUuZHR5cGUpJTIwJTIwJTIzJTIwKHRvcmNoLmJmbG9hdDE2JTJDJTIwdG9yY2guZmxvYXQxNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanVideoPipeline
<span class="hljs-keyword">import</span> torch

pipe = HunyuanVideoPipeline.from_pretrained(
    <span class="hljs-string">&quot;hunyuanvideo-community/HunyuanVideo&quot;</span>,
    torch_dtype={<span class="hljs-string">&quot;transformer&quot;</span>: torch.bfloat16, <span class="hljs-string">&quot;default&quot;</span>: torch.float16},
)
<span class="hljs-built_in">print</span>(pipe.transformer.dtype, pipe.vae.dtype)  <span class="hljs-comment"># (torch.bfloat16, torch.float16)</span>`,wrap:!1}}),O=new $({props:{title:"Parallel loading",local:"parallel-loading",headingTag:"h3"}}),te=new j({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQW9zLmVudmlyb24lNUIlMjJIRl9FTkFCTEVfUEFSQUxMRUxfTE9BRElORyUyMiU1RCUyMCUzRCUyMCUyMllFUyUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMldhbi1BSSUyRldhbjIuMi1JMlYtQTE0Qi1EaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

os.environ[<span class="hljs-string">&quot;HF_ENABLE_PARALLEL_LOADING&quot;</span>] = <span class="hljs-string">&quot;YES&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Wan-AI/Wan2.2-I2V-A14B-Diffusers&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),ie=new $({props:{title:"Local pipeline",local:"local-pipeline",headingTag:"h3"}}),ae=new j({props:{code:"Z2l0LWxmcyUyMGluc3RhbGwlMEFnaXQlMjBjbG9uZSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTU=",highlighted:`git-lfs install
git <span class="hljs-built_in">clone</span> https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5`,wrap:!1}}),oe=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjIuJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

stable_diffusion = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),fe=new $({props:{title:"Customize a pipeline",local:"customize-a-pipeline",headingTag:"h2"}}),Me=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBIZXVuRGlzY3JldGVTY2hlZHVsZXIlMkMlMjBBdXRvZW5jb2RlcktMJTBBaW1wb3J0JTIwdG9yY2glMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBIZXVuRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJtYWRlYnlvbGxpbiUyRnNkeGwtdmFlLWZwMTYtZml4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, HeunDiscreteScheduler, AutoencoderKL
<span class="hljs-keyword">import</span> torch

scheduler = HeunDiscreteScheduler.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),he=new j({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjBzY2hlZHVsZXIlM0RzY2hlZHVsZXIlMkMlMEElMjAlMjB2YWUlM0R2YWUlMkMlMEElMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIp",highlighted:`pipeline = StableDiffusionXLPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  scheduler=scheduler,
  vae=vae,
  torch_dtype=torch.float16,
  variant=<span class="hljs-string">&quot;fp16&quot;</span>,
  use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Ue=new $({props:{title:"Reuse a pipeline",local:"reuse-a-pipeline",headingTag:"h2"}}),R=new at({props:{warning:!1,$$slots:{default:[$i]},$$scope:{ctx:w}}}),je=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMGdjJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMGNvbXB1dGVfbW9kdWxlX3NpemVzJTBBJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmxvYWRfbmVnX2VtYmVkLnBuZyUyMiklMEElMEFwaXBlX3NkJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNi4wX0IxX25vVkFFJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVfc2QubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJtb2RlbHMlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXJfc2QxNS5iaW4lMjIpJTBBcGlwZV9zZC5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYpJTBBcGlwZV9zZC50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDMzKSUwQW91dF9zZCUyMCUzRCUyMHBpcGVfc2QoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVhciUyMGVhdHMlMjBwaXp6YSUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMndyb25nJTIwd2hpdGUlMjBiYWxhbmNlJTJDJTIwZGFyayUyQyUyMHNrZXRjaGVzJTJDd29yc3QlMjBxdWFsaXR5JTJDbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW91dF9zZA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, StableDiffusionSAGPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> gc
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> compute_module_sizes

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/load_neg_embed.png&quot;</span>)

pipe_sd = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, torch_dtype=torch.float16)
pipe_sd.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipe_sd.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)
pipe_sd.to(<span class="hljs-string">&quot;cuda&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sd = pipe_sd(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>,
    ip_adapter_image=image,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
out_sd`,wrap:!1}}),ge=new j({props:{code:"ZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUwQXByaW50KGYlMjJNYXglMjBtZW1vcnklMjBhbGxvY2F0ZWQlM0ElMjAlN0JieXRlc190b19naWdhX2J5dGVzKHRvcmNoLmN1ZGEubWF4X21lbW9yeV9hbGxvY2F0ZWQoKSklN0QlMjBHQiUyMiklMEElMjJNYXglMjBtZW1vcnklMjBhbGxvY2F0ZWQlM0ElMjA0LjQwNjIxMzI4MzUzODgxOCUyMEdCJTIy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">bytes_to_giga_bytes</span>(<span class="hljs-params"><span class="hljs-built_in">bytes</span></span>):
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">bytes</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory allocated: <span class="hljs-subst">{bytes_to_giga_bytes(torch.cuda.max_memory_allocated())}</span> GB&quot;</span>)
<span class="hljs-string">&quot;Max memory allocated: 4.406213283538818 GB&quot;</span>`,wrap:!1}}),N=new at({props:{warning:!0,$$slots:{default:[_i]},$$scope:{ctx:w}}}),Ie=new j({props:{code:"cGlwZV9zYWclMjAlM0QlMjBTdGFibGVEaWZmdXNpb25TQUdQaXBlbGluZS5mcm9tX3BpcGUoJTBBJTIwJTIwJTIwJTIwcGlwZV9zZCUwQSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgzMyklMEFvdXRfc2FnJTIwJTNEJTIwcGlwZV9zYWcoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVhciUyMGVhdHMlMjBwaXp6YSUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMndyb25nJTIwd2hpdGUlMjBiYWxhbmNlJTJDJTIwZGFyayUyQyUyMHNrZXRjaGVzJTJDd29yc3QlMjBxdWFsaXR5JTJDbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMS4wJTJDJTBBJTIwJTIwJTIwJTIwc2FnX3NjYWxlJTNEMC43NSUwQSkuaW1hZ2VzJTVCMCU1RCUwQW91dF9zYWc=",highlighted:`pipe_sag = StableDiffusionSAGPipeline.from_pipe(
    pipe_sd
)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sag = pipe_sag(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>,
    ip_adapter_image=image,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
    guidance_scale=<span class="hljs-number">1.0</span>,
    sag_scale=<span class="hljs-number">0.75</span>
).images[<span class="hljs-number">0</span>]
out_sag`,wrap:!1}}),$e=new j({props:{code:"cHJpbnQoZiUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMCU3QmJ5dGVzX3RvX2dpZ2FfYnl0ZXModG9yY2guY3VkYS5tYXhfbWVtb3J5X2FsbG9jYXRlZCgpKSU3RCUyMEdCJTIyKSUwQSUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMDQuNDA2MjEzMjgzNTM4ODE4JTIwR0IlMjI=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory allocated: <span class="hljs-subst">{bytes_to_giga_bytes(torch.cuda.max_memory_allocated())}</span> GB&quot;</span>)
<span class="hljs-string">&quot;Max memory allocated: 4.406213283538818 GB&quot;</span>`,wrap:!1}}),Ge=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEFuaW1hdGVEaWZmUGlwZWxpbmUlMkMlMjBNb3Rpb25BZGFwdGVyJTJDJTIwRERJTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fZ2lmJTBBJTBBcGlwZV9zYWcudW5sb2FkX2lwX2FkYXB0ZXIoKSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tYWRhcHRlci12MS01LTIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBJTBBcGlwZV9hbmltYXRlJTIwJTNEJTIwQW5pbWF0ZURpZmZQaXBlbGluZS5mcm9tX3BpcGUocGlwZV9zZCUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciklMEFwaXBlX2FuaW1hdGUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlX2FuaW1hdGUuc2NoZWR1bGVyLmNvbmZpZyUyQyUyMGJldGFfc2NoZWR1bGUlM0QlMjJsaW5lYXIlMjIpJTBBJTIzJTIwbG9hZCUyMElQLUFkYXB0ZXIlMjBhbmQlMjBMb1JBJTIwd2VpZ2h0cyUyMGFnYWluJTBBcGlwZV9hbmltYXRlLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVfYW5pbWF0ZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tbG9yYS16b29tLW91dCUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnpvb20tb3V0JTIyKSUwQXBpcGVfYW5pbWF0ZS50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDMzKSUwQXBpcGVfYW5pbWF0ZS5zZXRfYWRhcHRlcnMoJTIyem9vbS1vdXQlMjIlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QwLjc1KSUwQW91dCUyMCUzRCUyMHBpcGVfYW5pbWF0ZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJiZWFyJTIwZWF0cyUyMHBpenphJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihvdXQlMkMlMjAlMjJvdXRfYW5pbWF0ZS5naWYlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, MotionAdapter, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

pipe_sag.unload_ip_adapter()
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)

pipe_animate = AnimateDiffPipeline.from_pipe(pipe_sd, motion_adapter=adapter)
pipe_animate.scheduler = DDIMScheduler.from_config(pipe_animate.scheduler.config, beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>)
<span class="hljs-comment"># load IP-Adapter and LoRA weights again</span>
pipe_animate.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipe_animate.load_lora_weights(<span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>)
pipe_animate.to(<span class="hljs-string">&quot;cuda&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
pipe_animate.set_adapters(<span class="hljs-string">&quot;zoom-out&quot;</span>, adapter_weights=<span class="hljs-number">0.75</span>)
out = pipe_animate(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    ip_adapter_image=image,
    generator=generator,
).frames[<span class="hljs-number">0</span>]
export_to_gif(out, <span class="hljs-string">&quot;out_animate.gif&quot;</span>)`,wrap:!1}}),ke=new j({props:{code:"cHJpbnQoZiUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMCU3QmJ5dGVzX3RvX2dpZ2FfYnl0ZXModG9yY2guY3VkYS5tYXhfbWVtb3J5X2FsbG9jYXRlZCgpKSU3RCUyMEdCJTIyKSUwQSUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMDE1LjE3ODY2NDIwNzQ1ODQ5NiUyMEdCJTIy",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory allocated: <span class="hljs-subst">{bytes_to_giga_bytes(torch.cuda.max_memory_allocated())}</span> GB&quot;</span>)
<span class="hljs-string">&quot;Max memory allocated: 15.178664207458496 GB&quot;</span>`,wrap:!1}}),We=new $({props:{title:"Modify from_pipe components",local:"modify-frompipe-components",headingTag:"h3"}}),Be=new j({props:{code:"cGlwZS5zYWdfdW5sb2FkX2lwX2FkYXB0ZXIoKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDMzKSUwQW91dF9zZCUyMCUzRCUyMHBpcGVfc2QoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVhciUyMGVhdHMlMjBwaXp6YSUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMndyb25nJTIwd2hpdGUlMjBiYWxhbmNlJTJDJTIwZGFyayUyQyUyMHNrZXRjaGVzJTJDd29yc3QlMjBxdWFsaXR5JTJDbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUyMkF0dHJpYnV0ZUVycm9yJTNBJTIwJ05vbmVUeXBlJyUyMG9iamVjdCUyMGhhcyUyMG5vJTIwYXR0cmlidXRlJTIwJ2ltYWdlX3Byb2plY3Rpb25fbGF5ZXJzJyUyMg==",highlighted:`pipe.sag_unload_ip_adapter()

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sd = pipe_sd(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>,
    ip_adapter_image=image,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;AttributeError: &#x27;NoneType&#x27; object has no attribute &#x27;image_projection_layers&#x27;&quot;</span>`,wrap:!1}}),Ne=new $({props:{title:"Memory usage of from_pipe",local:"memory-usage-of-frompipe",headingTag:"h3"}}),Ye=new $({props:{title:"Safety checker",local:"safety-checker",headingTag:"h2"}}),qe=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEElMjIlMjIlMjIlMEFZb3UlMjBoYXZlJTIwZGlzYWJsZWQlMjB0aGUlMjBzYWZldHklMjBjaGVja2VyJTIwZm9yJTIwJTNDY2xhc3MlMjAnZGlmZnVzZXJzLnBpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uLnBpcGVsaW5lX3N0YWJsZV9kaWZmdXNpb24uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUnJTNFJTIwYnklMjBwYXNzaW5nJTIwJTYwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTYwLiUyMEVuc3VyZSUyMHRoYXQlMjB5b3UlMjBhYmlkZSUyMGJ5JTIwdGhlJTIwY29uZGl0aW9ucyUyMG9mJTIwdGhlJTIwU3RhYmxlJTIwRGlmZnVzaW9uJTIwbGljZW5zZSUyMGFuZCUyMGRvJTIwbm90JTIwZXhwb3NlJTIwdW5maWx0ZXJlZCUyMHJlc3VsdHMlMjBpbiUyMHNlcnZpY2VzJTIwb3IlMjBhcHBsaWNhdGlvbnMlMjBvcGVuJTIwdG8lMjB0aGUlMjBwdWJsaWMuJTIwQm90aCUyMHRoZSUyMGRpZmZ1c2VycyUyMHRlYW0lMjBhbmQlMjBIdWdnaW5nJTIwRmFjZSUyMHN0cm9uZ2x5JTIwcmVjb21tZW5kJTIwa2VlcGluZyUyMHRoZSUyMHNhZmV0eSUyMGZpbHRlciUyMGVuYWJsZWQlMjBpbiUyMGFsbCUyMHB1YmxpYy1mYWNpbmclMjBjaXJjdW1zdGFuY2VzJTJDJTIwZGlzYWJsaW5nJTIwaXQlMjBvbmx5JTIwZm9yJTIwdXNlJTIwY2FzZXMlMjB0aGF0JTIwaW52b2x2ZSUyMGFuYWx5emluZyUyMG5ldHdvcmslMjBiZWhhdmlvciUyMG9yJTIwYXVkaXRpbmclMjBpdHMlMjByZXN1bHRzLiUyMEZvciUyMG1vcmUlMjBpbmZvcm1hdGlvbiUyQyUyMHBsZWFzZSUyMGhhdmUlMjBhJTIwbG9vayUyMGF0JTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkaWZmdXNlcnMlMkZwdWxsJTJGMjU0JTIwLiUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, safety_checker=<span class="hljs-literal">None</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;
You have disabled the safety checker for &lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt; by passing \`safety_checker=None\`. Ensure that you abide by the conditions of the Stable Diffusion license and do not expose unfiltered results in services or applications open to the public. Both the diffusers team and Hugging Face strongly recommend keeping the safety filter enabled in all public-facing circumstances, disabling it only for use cases that involve analyzing network behavior or auditing its results. For more information, please have a look at https://github.com/huggingface/diffusers/pull/254 .
&quot;&quot;&quot;</span>`,wrap:!1}}),Ee=new $({props:{title:"Checkpoint variants",local:"checkpoint-variants",headingTag:"h2"}}),S=new at({props:{warning:!1,$$slots:{default:[Gi]},$$scope:{ctx:w}}}),Y=new pt({props:{id:"variants",options:["fp16","non-EMA"],$$slots:{default:[Wi]},$$scope:{ctx:w}}}),x=new pt({props:{id:"save",options:["fp16","non_ema"],$$slots:{default:[Ni]},$$scope:{ctx:w}}}),Ke=new j({props:{code:"JTIzJTIwJUYwJTlGJTkxJThFJTIwdGhpcyUyMHdvbid0JTIwd29yayUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQSUyMyUyMCVGMCU5RiU5MSU4RCUyMHRoaXMlMjB3b3JrcyUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-comment"># 👎 this won&#x27;t work</span>
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># 👍 this works</span>
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),es=new $({props:{title:"DiffusionPipeline explained",local:"diffusionpipeline-explained",headingTag:"h2"}}),is=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXByaW50KHBpcGVsaW5lKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(pipeline)`,wrap:!1}}),ps=new j({props:{code:"U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjAlMjJmZWF0dXJlX2V4dHJhY3RvciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBJbWFnZVByb2Nlc3NvciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnNhZmV0eV9jaGVja2VyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlN0YWJsZURpZmZ1c2lvblNhZmV0eUNoZWNrZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzY2hlZHVsZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJQTkRNU2NoZWR1bGVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQ0xJUFRleHRNb2RlbCUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRva2VuaXplciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUb2tlbml6ZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ1bmV0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVU5ldDJEQ29uZGl0aW9uTW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ2YWUlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBdXRvZW5jb2RlcktMJTIyJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`StableDiffusionPipeline <span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),rs=new j({props:{code:"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",highlighted:`.
├── feature_extractor
│   └── preprocessor_config.json
├── model_index.json
├── safety_checker
│   ├── config.json
|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   ├── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── scheduler
│   └── scheduler_config.json
├── text_encoder
│   ├── config.json
</span>|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   </span>|<span class="hljs-string">── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── tokenizer
│   ├── merges.txt
│   ├── special_tokens_map.json
│   ├── tokenizer_config.json
│   └── vocab.json
├── unet
│   ├── config.json
│   ├── diffusion_pytorch_model.bin
</span>|<span class="hljs-string">   </span>|<span class="hljs-string">── diffusion_pytorch_model.fp16.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.f16.safetensors
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.safetensors
│   └── diffusion_pytorch_model.safetensors
</span>|<span class="hljs-string">── vae
.   ├── config.json
.   ├── diffusion_pytorch_model.bin
    ├── diffusion_pytorch_model.fp16.bin
    ├── diffusion_pytorch_model.fp16.safetensors
    └── diffusion_pytorch_model.safetensors</span>`,wrap:!1}}),us=new j({props:{code:"cGlwZWxpbmUudG9rZW5pemVyJTBBQ0xJUFRva2VuaXplciglMEElMjAlMjAlMjAlMjBuYW1lX29yX3BhdGglM0QlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXJ1bndheW1sLS1zdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzbmFwc2hvdHMlMkYzOTU5M2Q1NjUwMTEyYjRjYzU4MDQzM2Y2YjA0MzUzODU4ODJkODE5JTJGdG9rZW5pemVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDQ5NDA4JTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfbWF4X2xlbmd0aCUzRDc3JTJDJTBBJTIwJTIwJTIwJTIwaXNfZmFzdCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZ19zaWRlJTNEJTIycmlnaHQlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uX3NpZGUlM0QlMjJyaWdodCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwZWNpYWxfdG9rZW5zJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYm9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NzdGFydG9mdGV4dCU3QyUzRSUyMiUyQyUyMHJzdHJpcCUzREZhbHNlJTJDJTIwbHN0cmlwJTNERmFsc2UlMkMlMjBzaW5nbGVfd29yZCUzREZhbHNlJTJDJTIwbm9ybWFsaXplZCUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMjByc3RyaXAlM0RGYWxzZSUyQyUyMGxzdHJpcCUzREZhbHNlJTJDJTIwc2luZ2xlX3dvcmQlM0RGYWxzZSUyQyUyMG5vcm1hbGl6ZWQlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVua190b2tlbiUyMiUzQSUyMEFkZGVkVG9rZW4oJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTIwcnN0cmlwJTNERmFsc2UlMkMlMjBsc3RyaXAlM0RGYWxzZSUyQyUyMHNpbmdsZV93b3JkJTNERmFsc2UlMkMlMjBub3JtYWxpemVkJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYWRfdG9rZW4lMjIlM0ElMjAlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNEVHJ1ZSUwQSk=",highlighted:`pipeline.tokenizer
CLIPTokenizer(
    name_or_path=<span class="hljs-string">&quot;/root/.cache/huggingface/hub/models--runwayml--stable-diffusion-v1-5/snapshots/39593d5650112b4cc580433f6b0435385882d819/tokenizer&quot;</span>,
    vocab_size=<span class="hljs-number">49408</span>,
    model_max_length=<span class="hljs-number">77</span>,
    is_fast=<span class="hljs-literal">False</span>,
    padding_side=<span class="hljs-string">&quot;right&quot;</span>,
    truncation_side=<span class="hljs-string">&quot;right&quot;</span>,
    special_tokens={
        <span class="hljs-string">&quot;bos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|startoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;eos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;unk_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;pad_token&quot;</span>: <span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    },
    clean_up_tokenization_spaces=<span class="hljs-literal">True</span>
)`,wrap:!1}}),ms=new j({props:{code:"JTdCJTBBJTIwJTIwJTIyX2NsYXNzX25hbWUlMjIlM0ElMjAlMjJTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuNi4wJTIyJTJDJTBBJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQSW1hZ2VQcm9jZXNzb3IlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzYWZldHlfY2hlY2tlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZV9kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdGFibGVEaWZmdXNpb25TYWZldHlDaGVja2VyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRleHRfZW5jb2RlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUZXh0TW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ0b2tlbml6ZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQVG9rZW5pemVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydW5ldCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlVOZXQyRENvbmRpdGlvbk1vZGVsJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydmFlJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXV0b2VuY29kZXJLTCUyMiUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_class_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;_diffusers_version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;0.6.0&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ms=new Zi({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/loading.md"}}),{c(){i=r("meta"),c=n(),p=r("p"),d=n(),y(o.$$.fragment),m=n(),y(Z.$$.fragment),g=n(),v=r("p"),v.innerHTML=C,M=n(),I=r("p"),I.textContent=ot,Ts=n(),q=r("ul"),q.innerHTML=rt,Js=n(),y(E.$$.fragment),bs=n(),y(G.$$.fragment),ws=n(),z=r("p"),z.textContent=ft,js=n(),F=r("ol"),F.innerHTML=ut,Zs=n(),y(V.$$.fragment),gs=n(),H=r("p"),H.textContent=ct,vs=n(),k=r("div"),k.innerHTML=dt,Is=n(),W=r("div"),W.innerHTML=mt,Cs=n(),y(D.$$.fragment),$s=n(),A=r("p"),A.innerHTML=Mt,_s=n(),y(L.$$.fragment),Gs=n(),P=r("p"),P.innerHTML=yt,Vs=n(),y(O.$$.fragment),ks=n(),K=r("p"),K.innerHTML=ht,Ws=n(),ee=r("p"),ee.textContent=Ut,Rs=n(),se=r("ul"),se.innerHTML=Tt,Bs=n(),le=r("p"),le.innerHTML=Jt,Ns=n(),y(te.$$.fragment),Xs=n(),y(ie.$$.fragment),Qs=n(),ne=r("p"),ne.innerHTML=bt,Ss=n(),y(ae.$$.fragment),Ys=n(),pe=r("p"),pe.innerHTML=wt,xs=n(),y(oe.$$.fragment),qs=n(),re=r("p"),re.innerHTML=jt,Es=n(),y(fe.$$.fragment),zs=n(),ue=r("p"),ue.textContent=Zt,Fs=n(),ce=r("ul"),ce.innerHTML=gt,Hs=n(),de=r("p"),de.innerHTML=vt,Ds=n(),me=r("ul"),me.innerHTML=It,As=n(),y(Me.$$.fragment),Ls=n(),ye=r("p"),ye.innerHTML=Ct,Ps=n(),y(he.$$.fragment),Os=n(),y(Ue.$$.fragment),Ks=n(),Te=r("p"),Te.textContent=$t,el=n(),Je=r("ol"),Je.innerHTML=_t,sl=n(),be=r("p"),be.innerHTML=Gt,ll=n(),y(R.$$.fragment),tl=n(),we=r("p"),we.innerHTML=Vt,il=n(),y(je.$$.fragment),nl=n(),B=r("div"),B.innerHTML=kt,al=n(),Ze=r("p"),Ze.textContent=Wt,pl=n(),y(ge.$$.fragment),ol=n(),ve=r("p"),ve.innerHTML=Rt,rl=n(),y(N.$$.fragment),fl=n(),y(Ie.$$.fragment),ul=n(),X=r("div"),X.innerHTML=Bt,cl=n(),Ce=r("p"),Ce.innerHTML=Nt,dl=n(),y($e.$$.fragment),ml=n(),_e=r("p"),_e.innerHTML=Xt,Ml=n(),y(Ge.$$.fragment),yl=n(),Q=r("div"),Q.innerHTML=Qt,hl=n(),Ve=r("p"),Ve.innerHTML=St,Ul=n(),y(ke.$$.fragment),Tl=n(),y(We.$$.fragment),Jl=n(),Re=r("p"),Re.innerHTML=Yt,bl=n(),y(Be.$$.fragment),wl=n(),y(Ne.$$.fragment),jl=n(),Xe=r("p"),Xe.innerHTML=xt,Zl=n(),Qe=r("table"),Qe.innerHTML=qt,gl=n(),Se=r("p"),Se.innerHTML=Et,vl=n(),y(Ye.$$.fragment),Il=n(),xe=r("p"),xe.innerHTML=zt,Cl=n(),y(qe.$$.fragment),$l=n(),y(Ee.$$.fragment),_l=n(),ze=r("p"),ze.textContent=Ft,Gl=n(),Fe=r("ul"),Fe.innerHTML=Ht,Vl=n(),y(S.$$.fragment),kl=n(),He=r("p"),He.innerHTML=Dt,Wl=n(),De=r("table"),De.innerHTML=At,Rl=n(),Ae=r("p"),Ae.textContent=Lt,Bl=n(),Le=r("ul"),Le.innerHTML=Pt,Nl=n(),y(Y.$$.fragment),Xl=n(),Pe=r("p"),Pe.innerHTML=Ot,Ql=n(),y(x.$$.fragment),Sl=n(),Oe=r("p"),Oe.innerHTML=Kt,Yl=n(),y(Ke.$$.fragment),xl=n(),y(es.$$.fragment),ql=n(),ss=r("p"),ss.innerHTML=ei,El=n(),ls=r("ul"),ls.innerHTML=si,zl=n(),ts=r("p"),ts.innerHTML=li,Fl=n(),y(is.$$.fragment),Hl=n(),ns=r("p"),ns.innerHTML=ti,Dl=n(),as=r("ul"),as.innerHTML=ii,Al=n(),y(ps.$$.fragment),Ll=n(),os=r("p"),os.innerHTML=ni,Pl=n(),y(rs.$$.fragment),Ol=n(),fs=r("p"),fs.textContent=ai,Kl=n(),y(us.$$.fragment),et=n(),cs=r("p"),cs.innerHTML=pi,st=n(),ds=r("ul"),ds.innerHTML=oi,lt=n(),y(ms.$$.fragment),tt=n(),y(Ms.$$.fragment),it=n(),Us=r("p"),this.h()},l(e){const s=bi("svelte-u9bgzb",document.head);i=f(s,"META",{name:!0,content:!0}),s.forEach(l),c=a(e),p=f(e,"P",{}),yi(p).forEach(l),d=a(e),h(o.$$.fragment,e),m=a(e),h(Z.$$.fragment,e),g=a(e),v=f(e,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1mjzpt7"&&(v.innerHTML=C),M=a(e),I=f(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-b6mpdv"&&(I.textContent=ot),Ts=a(e),q=f(e,"UL",{"data-svelte-h":!0}),u(q)!=="svelte-1eibdva"&&(q.innerHTML=rt),Js=a(e),h(E.$$.fragment,e),bs=a(e),h(G.$$.fragment,e),ws=a(e),z=f(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-1fp1qkh"&&(z.textContent=ft),js=a(e),F=f(e,"OL",{"data-svelte-h":!0}),u(F)!=="svelte-1hgg7us"&&(F.innerHTML=ut),Zs=a(e),h(V.$$.fragment,e),gs=a(e),H=f(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-x1hybx"&&(H.textContent=ct),vs=a(e),k=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(k)!=="svelte-1eacg44"&&(k.innerHTML=dt),Is=a(e),W=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(W)!=="svelte-1scmarz"&&(W.innerHTML=mt),Cs=a(e),h(D.$$.fragment,e),$s=a(e),A=f(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-mf3fth"&&(A.innerHTML=Mt),_s=a(e),h(L.$$.fragment,e),Gs=a(e),P=f(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-8ntfez"&&(P.innerHTML=yt),Vs=a(e),h(O.$$.fragment,e),ks=a(e),K=f(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-14tzv1s"&&(K.innerHTML=ht),Ws=a(e),ee=f(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-1jl98rh"&&(ee.textContent=Ut),Rs=a(e),se=f(e,"UL",{"data-svelte-h":!0}),u(se)!=="svelte-k29lww"&&(se.innerHTML=Tt),Bs=a(e),le=f(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-34lk0z"&&(le.innerHTML=Jt),Ns=a(e),h(te.$$.fragment,e),Xs=a(e),h(ie.$$.fragment,e),Qs=a(e),ne=f(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-19d3ik7"&&(ne.innerHTML=bt),Ss=a(e),h(ae.$$.fragment,e),Ys=a(e),pe=f(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-13irge8"&&(pe.innerHTML=wt),xs=a(e),h(oe.$$.fragment,e),qs=a(e),re=f(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-g0yd3u"&&(re.innerHTML=jt),Es=a(e),h(fe.$$.fragment,e),zs=a(e),ue=f(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-1ifrszd"&&(ue.textContent=Zt),Fs=a(e),ce=f(e,"UL",{"data-svelte-h":!0}),u(ce)!=="svelte-1ln6l0l"&&(ce.innerHTML=gt),Hs=a(e),de=f(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-pkpme0"&&(de.innerHTML=vt),Ds=a(e),me=f(e,"UL",{"data-svelte-h":!0}),u(me)!=="svelte-niwzp6"&&(me.innerHTML=It),As=a(e),h(Me.$$.fragment,e),Ls=a(e),ye=f(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-1tnhj53"&&(ye.innerHTML=Ct),Ps=a(e),h(he.$$.fragment,e),Os=a(e),h(Ue.$$.fragment,e),Ks=a(e),Te=f(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-14g5ay7"&&(Te.textContent=$t),el=a(e),Je=f(e,"OL",{"data-svelte-h":!0}),u(Je)!=="svelte-1vxntr0"&&(Je.innerHTML=_t),sl=a(e),be=f(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-jst5ua"&&(be.innerHTML=Gt),ll=a(e),h(R.$$.fragment,e),tl=a(e),we=f(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-1urnmn2"&&(we.innerHTML=Vt),il=a(e),h(je.$$.fragment,e),nl=a(e),B=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(B)!=="svelte-ye42mk"&&(B.innerHTML=kt),al=a(e),Ze=f(e,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-1u6h93y"&&(Ze.textContent=Wt),pl=a(e),h(ge.$$.fragment,e),ol=a(e),ve=f(e,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-1cvgfbk"&&(ve.innerHTML=Rt),rl=a(e),h(N.$$.fragment,e),fl=a(e),h(Ie.$$.fragment,e),ul=a(e),X=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(X)!=="svelte-5lltp7"&&(X.innerHTML=Bt),cl=a(e),Ce=f(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-1js9yxv"&&(Ce.innerHTML=Nt),dl=a(e),h($e.$$.fragment,e),ml=a(e),_e=f(e,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-1wtawsa"&&(_e.innerHTML=Xt),Ml=a(e),h(Ge.$$.fragment,e),yl=a(e),Q=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(Q)!=="svelte-cbprhg"&&(Q.innerHTML=Qt),hl=a(e),Ve=f(e,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-1hscc5j"&&(Ve.innerHTML=St),Ul=a(e),h(ke.$$.fragment,e),Tl=a(e),h(We.$$.fragment,e),Jl=a(e),Re=f(e,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-1dz1nqo"&&(Re.innerHTML=Yt),bl=a(e),h(Be.$$.fragment,e),wl=a(e),h(Ne.$$.fragment,e),jl=a(e),Xe=f(e,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-3tn4b0"&&(Xe.innerHTML=xt),Zl=a(e),Qe=f(e,"TABLE",{"data-svelte-h":!0}),u(Qe)!=="svelte-170u8iz"&&(Qe.innerHTML=qt),gl=a(e),Se=f(e,"P",{"data-svelte-h":!0}),u(Se)!=="svelte-1w0v69h"&&(Se.innerHTML=Et),vl=a(e),h(Ye.$$.fragment,e),Il=a(e),xe=f(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-1dz5d7t"&&(xe.innerHTML=zt),Cl=a(e),h(qe.$$.fragment,e),$l=a(e),h(Ee.$$.fragment,e),_l=a(e),ze=f(e,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-144ljdh"&&(ze.textContent=Ft),Gl=a(e),Fe=f(e,"UL",{"data-svelte-h":!0}),u(Fe)!=="svelte-86xcrp"&&(Fe.innerHTML=Ht),Vl=a(e),h(S.$$.fragment,e),kl=a(e),He=f(e,"P",{"data-svelte-h":!0}),u(He)!=="svelte-naaguo"&&(He.innerHTML=Dt),Wl=a(e),De=f(e,"TABLE",{"data-svelte-h":!0}),u(De)!=="svelte-1xwvx35"&&(De.innerHTML=At),Rl=a(e),Ae=f(e,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-9nwb1f"&&(Ae.textContent=Lt),Bl=a(e),Le=f(e,"UL",{"data-svelte-h":!0}),u(Le)!=="svelte-kz39jt"&&(Le.innerHTML=Pt),Nl=a(e),h(Y.$$.fragment,e),Xl=a(e),Pe=f(e,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-k0wnr6"&&(Pe.innerHTML=Ot),Ql=a(e),h(x.$$.fragment,e),Sl=a(e),Oe=f(e,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-s6vvaz"&&(Oe.innerHTML=Kt),Yl=a(e),h(Ke.$$.fragment,e),xl=a(e),h(es.$$.fragment,e),ql=a(e),ss=f(e,"P",{"data-svelte-h":!0}),u(ss)!=="svelte-nr77qh"&&(ss.innerHTML=ei),El=a(e),ls=f(e,"UL",{"data-svelte-h":!0}),u(ls)!=="svelte-17dcgvz"&&(ls.innerHTML=si),zl=a(e),ts=f(e,"P",{"data-svelte-h":!0}),u(ts)!=="svelte-kb1186"&&(ts.innerHTML=li),Fl=a(e),h(is.$$.fragment,e),Hl=a(e),ns=f(e,"P",{"data-svelte-h":!0}),u(ns)!=="svelte-102ytrs"&&(ns.innerHTML=ti),Dl=a(e),as=f(e,"UL",{"data-svelte-h":!0}),u(as)!=="svelte-1e5gxzy"&&(as.innerHTML=ii),Al=a(e),h(ps.$$.fragment,e),Ll=a(e),os=f(e,"P",{"data-svelte-h":!0}),u(os)!=="svelte-16nw0pl"&&(os.innerHTML=ni),Pl=a(e),h(rs.$$.fragment,e),Ol=a(e),fs=f(e,"P",{"data-svelte-h":!0}),u(fs)!=="svelte-5jik9b"&&(fs.textContent=ai),Kl=a(e),h(us.$$.fragment,e),et=a(e),cs=f(e,"P",{"data-svelte-h":!0}),u(cs)!=="svelte-1jvh1d2"&&(cs.innerHTML=pi),st=a(e),ds=f(e,"UL",{"data-svelte-h":!0}),u(ds)!=="svelte-hr84vt"&&(ds.innerHTML=oi),lt=a(e),h(ms.$$.fragment,e),tt=a(e),h(Ms.$$.fragment,e),it=a(e),Us=f(e,"P",{}),yi(Us).forEach(l),this.h()},h(){ys(i,"name","hf:doc:metadata"),ys(i,"content",Qi),ys(k,"class","block dark:hidden"),ys(W,"class","hidden dark:block"),ys(B,"class","flex justify-center"),ys(X,"class","flex justify-center"),ys(Q,"class","flex justify-center")},m(e,s){wi(document.head,i),t(e,c,s),t(e,p,s),t(e,d,s),U(o,e,s),t(e,m,s),U(Z,e,s),t(e,g,s),t(e,v,s),t(e,M,s),t(e,I,s),t(e,Ts,s),t(e,q,s),t(e,Js,s),U(E,e,s),t(e,bs,s),U(G,e,s),t(e,ws,s),t(e,z,s),t(e,js,s),t(e,F,s),t(e,Zs,s),U(V,e,s),t(e,gs,s),t(e,H,s),t(e,vs,s),t(e,k,s),t(e,Is,s),t(e,W,s),t(e,Cs,s),U(D,e,s),t(e,$s,s),t(e,A,s),t(e,_s,s),U(L,e,s),t(e,Gs,s),t(e,P,s),t(e,Vs,s),U(O,e,s),t(e,ks,s),t(e,K,s),t(e,Ws,s),t(e,ee,s),t(e,Rs,s),t(e,se,s),t(e,Bs,s),t(e,le,s),t(e,Ns,s),U(te,e,s),t(e,Xs,s),U(ie,e,s),t(e,Qs,s),t(e,ne,s),t(e,Ss,s),U(ae,e,s),t(e,Ys,s),t(e,pe,s),t(e,xs,s),U(oe,e,s),t(e,qs,s),t(e,re,s),t(e,Es,s),U(fe,e,s),t(e,zs,s),t(e,ue,s),t(e,Fs,s),t(e,ce,s),t(e,Hs,s),t(e,de,s),t(e,Ds,s),t(e,me,s),t(e,As,s),U(Me,e,s),t(e,Ls,s),t(e,ye,s),t(e,Ps,s),U(he,e,s),t(e,Os,s),U(Ue,e,s),t(e,Ks,s),t(e,Te,s),t(e,el,s),t(e,Je,s),t(e,sl,s),t(e,be,s),t(e,ll,s),U(R,e,s),t(e,tl,s),t(e,we,s),t(e,il,s),U(je,e,s),t(e,nl,s),t(e,B,s),t(e,al,s),t(e,Ze,s),t(e,pl,s),U(ge,e,s),t(e,ol,s),t(e,ve,s),t(e,rl,s),U(N,e,s),t(e,fl,s),U(Ie,e,s),t(e,ul,s),t(e,X,s),t(e,cl,s),t(e,Ce,s),t(e,dl,s),U($e,e,s),t(e,ml,s),t(e,_e,s),t(e,Ml,s),U(Ge,e,s),t(e,yl,s),t(e,Q,s),t(e,hl,s),t(e,Ve,s),t(e,Ul,s),U(ke,e,s),t(e,Tl,s),U(We,e,s),t(e,Jl,s),t(e,Re,s),t(e,bl,s),U(Be,e,s),t(e,wl,s),U(Ne,e,s),t(e,jl,s),t(e,Xe,s),t(e,Zl,s),t(e,Qe,s),t(e,gl,s),t(e,Se,s),t(e,vl,s),U(Ye,e,s),t(e,Il,s),t(e,xe,s),t(e,Cl,s),U(qe,e,s),t(e,$l,s),U(Ee,e,s),t(e,_l,s),t(e,ze,s),t(e,Gl,s),t(e,Fe,s),t(e,Vl,s),U(S,e,s),t(e,kl,s),t(e,He,s),t(e,Wl,s),t(e,De,s),t(e,Rl,s),t(e,Ae,s),t(e,Bl,s),t(e,Le,s),t(e,Nl,s),U(Y,e,s),t(e,Xl,s),t(e,Pe,s),t(e,Ql,s),U(x,e,s),t(e,Sl,s),t(e,Oe,s),t(e,Yl,s),U(Ke,e,s),t(e,xl,s),U(es,e,s),t(e,ql,s),t(e,ss,s),t(e,El,s),t(e,ls,s),t(e,zl,s),t(e,ts,s),t(e,Fl,s),U(is,e,s),t(e,Hl,s),t(e,ns,s),t(e,Dl,s),t(e,as,s),t(e,Al,s),U(ps,e,s),t(e,Ll,s),t(e,os,s),t(e,Pl,s),U(rs,e,s),t(e,Ol,s),t(e,fs,s),t(e,Kl,s),U(us,e,s),t(e,et,s),t(e,cs,s),t(e,st,s),t(e,ds,s),t(e,lt,s),U(ms,e,s),t(e,tt,s),U(Ms,e,s),t(e,it,s),t(e,Us,s),nt=!0},p(e,[s]){const ri={};s&2&&(ri.$$scope={dirty:s,ctx:e}),G.$set(ri);const fi={};s&2&&(fi.$$scope={dirty:s,ctx:e}),V.$set(fi);const ui={};s&2&&(ui.$$scope={dirty:s,ctx:e}),R.$set(ui);const ci={};s&2&&(ci.$$scope={dirty:s,ctx:e}),N.$set(ci);const di={};s&2&&(di.$$scope={dirty:s,ctx:e}),S.$set(di);const mi={};s&2&&(mi.$$scope={dirty:s,ctx:e}),Y.$set(mi);const Mi={};s&2&&(Mi.$$scope={dirty:s,ctx:e}),x.$set(Mi)},i(e){nt||(T(o.$$.fragment,e),T(Z.$$.fragment,e),T(E.$$.fragment,e),T(G.$$.fragment,e),T(V.$$.fragment,e),T(D.$$.fragment,e),T(L.$$.fragment,e),T(O.$$.fragment,e),T(te.$$.fragment,e),T(ie.$$.fragment,e),T(ae.$$.fragment,e),T(oe.$$.fragment,e),T(fe.$$.fragment,e),T(Me.$$.fragment,e),T(he.$$.fragment,e),T(Ue.$$.fragment,e),T(R.$$.fragment,e),T(je.$$.fragment,e),T(ge.$$.fragment,e),T(N.$$.fragment,e),T(Ie.$$.fragment,e),T($e.$$.fragment,e),T(Ge.$$.fragment,e),T(ke.$$.fragment,e),T(We.$$.fragment,e),T(Be.$$.fragment,e),T(Ne.$$.fragment,e),T(Ye.$$.fragment,e),T(qe.$$.fragment,e),T(Ee.$$.fragment,e),T(S.$$.fragment,e),T(Y.$$.fragment,e),T(x.$$.fragment,e),T(Ke.$$.fragment,e),T(es.$$.fragment,e),T(is.$$.fragment,e),T(ps.$$.fragment,e),T(rs.$$.fragment,e),T(us.$$.fragment,e),T(ms.$$.fragment,e),T(Ms.$$.fragment,e),nt=!0)},o(e){J(o.$$.fragment,e),J(Z.$$.fragment,e),J(E.$$.fragment,e),J(G.$$.fragment,e),J(V.$$.fragment,e),J(D.$$.fragment,e),J(L.$$.fragment,e),J(O.$$.fragment,e),J(te.$$.fragment,e),J(ie.$$.fragment,e),J(ae.$$.fragment,e),J(oe.$$.fragment,e),J(fe.$$.fragment,e),J(Me.$$.fragment,e),J(he.$$.fragment,e),J(Ue.$$.fragment,e),J(R.$$.fragment,e),J(je.$$.fragment,e),J(ge.$$.fragment,e),J(N.$$.fragment,e),J(Ie.$$.fragment,e),J($e.$$.fragment,e),J(Ge.$$.fragment,e),J(ke.$$.fragment,e),J(We.$$.fragment,e),J(Be.$$.fragment,e),J(Ne.$$.fragment,e),J(Ye.$$.fragment,e),J(qe.$$.fragment,e),J(Ee.$$.fragment,e),J(S.$$.fragment,e),J(Y.$$.fragment,e),J(x.$$.fragment,e),J(Ke.$$.fragment,e),J(es.$$.fragment,e),J(is.$$.fragment,e),J(ps.$$.fragment,e),J(rs.$$.fragment,e),J(us.$$.fragment,e),J(ms.$$.fragment,e),J(Ms.$$.fragment,e),nt=!1},d(e){e&&(l(c),l(p),l(d),l(m),l(g),l(v),l(M),l(I),l(Ts),l(q),l(Js),l(bs),l(ws),l(z),l(js),l(F),l(Zs),l(gs),l(H),l(vs),l(k),l(Is),l(W),l(Cs),l($s),l(A),l(_s),l(Gs),l(P),l(Vs),l(ks),l(K),l(Ws),l(ee),l(Rs),l(se),l(Bs),l(le),l(Ns),l(Xs),l(Qs),l(ne),l(Ss),l(Ys),l(pe),l(xs),l(qs),l(re),l(Es),l(zs),l(ue),l(Fs),l(ce),l(Hs),l(de),l(Ds),l(me),l(As),l(Ls),l(ye),l(Ps),l(Os),l(Ks),l(Te),l(el),l(Je),l(sl),l(be),l(ll),l(tl),l(we),l(il),l(nl),l(B),l(al),l(Ze),l(pl),l(ol),l(ve),l(rl),l(fl),l(ul),l(X),l(cl),l(Ce),l(dl),l(ml),l(_e),l(Ml),l(yl),l(Q),l(hl),l(Ve),l(Ul),l(Tl),l(Jl),l(Re),l(bl),l(wl),l(jl),l(Xe),l(Zl),l(Qe),l(gl),l(Se),l(vl),l(Il),l(xe),l(Cl),l($l),l(_l),l(ze),l(Gl),l(Fe),l(Vl),l(kl),l(He),l(Wl),l(De),l(Rl),l(Ae),l(Bl),l(Le),l(Nl),l(Xl),l(Pe),l(Ql),l(Sl),l(Oe),l(Yl),l(xl),l(ql),l(ss),l(El),l(ls),l(zl),l(ts),l(Fl),l(Hl),l(ns),l(Dl),l(as),l(Al),l(Ll),l(os),l(Pl),l(Ol),l(fs),l(Kl),l(et),l(cs),l(st),l(ds),l(lt),l(tt),l(it),l(Us)),l(i),b(o,e),b(Z,e),b(E,e),b(G,e),b(V,e),b(D,e),b(L,e),b(O,e),b(te,e),b(ie,e),b(ae,e),b(oe,e),b(fe,e),b(Me,e),b(he,e),b(Ue,e),b(R,e),b(je,e),b(ge,e),b(N,e),b(Ie,e),b($e,e),b(Ge,e),b(ke,e),b(We,e),b(Be,e),b(Ne,e),b(Ye,e),b(qe,e),b(Ee,e),b(S,e),b(Y,e),b(x,e),b(Ke,e),b(es,e),b(is,e),b(ps,e),b(rs,e),b(us,e),b(ms,e),b(Ms,e)}}}const Qi='{"title":"Load pipelines","local":"load-pipelines","sections":[{"title":"Load a pipeline","local":"load-a-pipeline","sections":[{"title":"Specifying Component-Specific Data Types","local":"specifying-component-specific-data-types","sections":[],"depth":3},{"title":"Parallel loading","local":"parallel-loading","sections":[],"depth":3},{"title":"Local pipeline","local":"local-pipeline","sections":[],"depth":3}],"depth":2},{"title":"Customize a pipeline","local":"customize-a-pipeline","sections":[],"depth":2},{"title":"Reuse a pipeline","local":"reuse-a-pipeline","sections":[{"title":"Modify from_pipe components","local":"modify-frompipe-components","sections":[],"depth":3},{"title":"Memory usage of from_pipe","local":"memory-usage-of-frompipe","sections":[],"depth":3}],"depth":2},{"title":"Safety checker","local":"safety-checker","sections":[],"depth":2},{"title":"Checkpoint variants","local":"checkpoint-variants","sections":[],"depth":2},{"title":"DiffusionPipeline explained","local":"diffusionpipeline-explained","sections":[],"depth":2}],"depth":1}';function Si(w){return Ui(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Di extends Ti{constructor(i){super(),Ji(this,i,Si,Xi,hi,{})}}export{Di as component};
