import{s as Ot,o as Kt,n as Ln}from"../chunks/scheduler.8c3d61f6.js";import{S as ea,i as na,g as o,s as t,r as d,A as ta,h as i,f as s,c as a,j as y,u as c,x as w,k as I,y as n,a as h,v as m,d as g,t as u,w as f}from"../chunks/index.da70eac4.js";import{T as aa}from"../chunks/Tip.1d9b8c37.js";import{D as M}from"../chunks/Docstring.c021b19a.js";import{C as qn}from"../chunks/CodeBlock.a9c4becf.js";import{E as xt}from"../chunks/ExampleCodeBlock.56b4589c.js";import{H as on,E as sa}from"../chunks/getInferenceSnippets.725ed3d4.js";function oa(P){let p,k='<a href="../../optimization/cache">Caching</a> may also speed up inference by storing and reusing intermediate outputs.';return{c(){p=o("p"),p.innerHTML=k},l(b){p=i(b,"P",{"data-svelte-h":!0}),w(p)!=="svelte-yvhnlz"&&(p.innerHTML=k)},m(b,_){h(b,p,_)},p:Ln,d(b){b&&s(p)}}}function ia(P){let p,k="Examples:",b,_,v;return _=new qn({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUwQSUyMyUyMERlcGVuZGluZyUyMG9uJTIwdGhlJTIwdmFyaWFudCUyMGJlaW5nJTIwdXNlZCUyQyUyMHRoZSUyMHBpcGVsaW5lJTIwY2FsbCUyMHdpbGwlMjBzbGlnaHRseSUyMHZhcnkuJTBBJTIzJTIwUmVmZXIlMjB0byUyMHRoZSUyMHBpcGVsaW5lJTIwZG9jdW1lbnRhdGlvbiUyMGZvciUyMG1vcmUlMjBkZXRhaWxzLiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnF3ZW5pbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImagePipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage.png&quot;</span>)`,wrap:!1}}),{c(){p=o("p"),p.textContent=k,b=t(),d(_.$$.fragment)},l(r){p=i(r,"P",{"data-svelte-h":!0}),w(p)!=="svelte-kvfsh7"&&(p.textContent=k),b=a(r),c(_.$$.fragment,r)},m(r,Q){h(r,p,Q),h(r,b,Q),m(_,r,Q),v=!0},p:Ln,i(r){v||(g(_.$$.fragment,r),v=!0)},o(r){u(_.$$.fragment,r),v=!1},d(r){r&&(s(p),s(b)),f(_,r)}}}function ra(P){let p,k="Examples:",b,_,v;return _=new qn({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlSW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCkucmVzaXplKCgxMDI0JTJDJTIwMTAyNCkpJTBBcHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwd2l6YXJkJTJDJTIwZ2FuZGFsZiUyQyUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwZGV0YWlsZWQlMkMlMjBmYW50YXN5JTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwUGl4YXIlMkMlMjBEaXNuZXklMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMCUyMiUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC45NSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlcy5zYXZlKCUyMnF3ZW5pbWFnZV9pbWcyaW1nLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageImg2ImgPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, negative_prompt=<span class="hljs-string">&quot; &quot;</span>, image=init_image, strength=<span class="hljs-number">0.95</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images.save(<span class="hljs-string">&quot;qwenimage_img2img.png&quot;</span>)`,wrap:!1}}),{c(){p=o("p"),p.textContent=k,b=t(),d(_.$$.fragment)},l(r){p=i(r,"P",{"data-svelte-h":!0}),w(p)!=="svelte-kvfsh7"&&(p.textContent=k),b=a(r),c(_.$$.fragment,r)},m(r,Q){h(r,p,Q),h(r,b,Q),m(_,r,Q),v=!0},p:Ln,i(r){v||(g(_.$$.fragment,r),v=!0)},o(r){u(_.$$.fragment,r),v=!1},d(r){r&&(s(p),s(b)),f(_,r)}}}function la(P){let p,k="Examples:",b,_,v;return _=new qn({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlSW5wYWludFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkZhY2UlMjBvZiUyMGElMjB5ZWxsb3clMjBjYXQlMkMlMjBoaWdoJTIwcmVzb2x1dGlvbiUyQyUyMHNpdHRpbmclMjBvbiUyMGElMjBwYXJrJTIwYmVuY2glMjIlMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQXNvdXJjZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCklMEFtYXNrJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIwJTIyJTJDJTIwaW1hZ2UlM0Rzb3VyY2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFzayUyQyUyMHN0cmVuZ3RoJTNEMC44NSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIycXdlbmltYWdlX2lucGFpbnRpbmcucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageInpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source = load_image(img_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(mask_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, negative_prompt=<span class="hljs-string">&quot; &quot;</span>, image=source, mask_image=mask, strength=<span class="hljs-number">0.85</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage_inpainting.png&quot;</span>)`,wrap:!1}}),{c(){p=o("p"),p.textContent=k,b=t(),d(_.$$.fragment)},l(r){p=i(r,"P",{"data-svelte-h":!0}),w(p)!=="svelte-kvfsh7"&&(p.textContent=k),b=a(r),c(_.$$.fragment,r)},m(r,Q){h(r,p,Q),h(r,b,Q),m(_,r,Q),v=!0},p:Ln,i(r){v||(g(_.$$.fragment,r),v=!0)},o(r){u(_.$$.fragment,r),v=!1},d(r){r&&(s(p),s(b)),f(_,r)}}}function pa(P){let p,k,b,_,v,r,Q,$t="Qwen-Image from the Qwen team is an image generation foundation model in the Qwen series that achieves significant advances in complex text rendering and precise image editing. Experiments show strong general capabilities in both image generation and editing, with exceptional performance in text rendering, especially for Chinese.",ln,ne,Qt='Check out the model card <a href="https://huggingface.co/Qwen/Qwen-Image" rel="nofollow">here</a> to learn more.',pn,V,dn,te,cn,ae,Jt=`Use a LoRA from <code>lightx2v/Qwen-Image-Lightning</code> to speed up inference by reducing the
number of steps. Refer to the code snippet below:`,mn,E,Ze,kt="Code",Vn,se,gn,oe,un,T,ie,En,We,Ut="The QwenImage pipeline for text-to-image generation.",Gn,C,re,Nn,Le,jt="Function invoked when calling the pipeline for generation.",Bn,G,Xn,N,le,Rn,qe,Pt=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,zn,B,pe,Dn,Ve,Ct=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,An,X,de,Fn,Ee,Zt=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Hn,R,ce,Yn,Ge,Wt=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Sn,Ne,me,fn,ge,hn,L,ue,On,Be,Lt="Output class for Stable Diffusion pipelines.",_n,fe,wn,x,he,Kn,Xe,qt="The QwenImage pipeline for text-to-image generation.",et,Z,_e,nt,Re,Vt="Function invoked when calling the pipeline for generation.",tt,z,at,D,we,st,ze,Et=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,ot,A,be,it,De,Gt=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,rt,F,ye,lt,Ae,Nt=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,pt,H,Ie,dt,Fe,Bt=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,ct,He,ve,bn,Me,yn,$,Te,mt,Ye,Xt="The QwenImage pipeline for text-to-image generation.",gt,W,xe,ut,Se,Rt="Function invoked when calling the pipeline for generation.",ft,Y,ht,S,$e,_t,Oe,zt=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,wt,O,Qe,bt,Ke,Dt=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,yt,K,Je,It,en,At=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,vt,ee,ke,Mt,nn,Ft=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Tt,tn,Ue,In,je,vn,rn,Mn;return v=new on({props:{title:"QwenImage",local:"qwenimage",headingTag:"h1"}}),V=new aa({props:{$$slots:{default:[oa]},$$scope:{ctx:P}}}),te=new on({props:{title:"LoRA for faster inference",local:"lora-for-faster-inference",headingTag:"h2"}}),se=new qn({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, FlowMatchEulerDiscreteScheduler
<span class="hljs-keyword">import</span> torch 
<span class="hljs-keyword">import</span> math

ckpt_id = <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>

<span class="hljs-comment"># From</span>
<span class="hljs-comment"># https://github.com/ModelTC/Qwen-Image-Lightning/blob/342260e8f5468d2f24d084ce04f55e101007118b/generate_with_diffusers.py#L82C9-L97C10</span>
scheduler_config = {
    <span class="hljs-string">&quot;base_image_seq_len&quot;</span>: <span class="hljs-number">256</span>,
    <span class="hljs-string">&quot;base_shift&quot;</span>: math.log(<span class="hljs-number">3</span>),  <span class="hljs-comment"># We use shift=3 in distillation</span>
    <span class="hljs-string">&quot;invert_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;max_image_seq_len&quot;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&quot;max_shift&quot;</span>: math.log(<span class="hljs-number">3</span>),  <span class="hljs-comment"># We use shift=3 in distillation</span>
    <span class="hljs-string">&quot;num_train_timesteps&quot;</span>: <span class="hljs-number">1000</span>,
    <span class="hljs-string">&quot;shift&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;shift_terminal&quot;</span>: <span class="hljs-literal">None</span>,  <span class="hljs-comment"># set shift_terminal to None</span>
    <span class="hljs-string">&quot;stochastic_sampling&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;time_shift_type&quot;</span>: <span class="hljs-string">&quot;exponential&quot;</span>,
    <span class="hljs-string">&quot;use_beta_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;use_dynamic_shifting&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;use_exponential_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;use_karras_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
}
scheduler = FlowMatchEulerDiscreteScheduler.from_config(scheduler_config)
pipe = DiffusionPipeline.from_pretrained(
    ckpt_id, scheduler=scheduler, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;lightx2v/Qwen-Image-Lightning&quot;</span>, weight_name=<span class="hljs-string">&quot;Qwen-Image-Lightning-8steps-V1.0.safetensors&quot;</span>
)

prompt = <span class="hljs-string">&quot;a tiny astronaut hatching from an egg on the moon, Ultra HD, 4K, cinematic composition.&quot;</span>
negative_prompt = <span class="hljs-string">&quot; &quot;</span>
image = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">8</span>,
    true_cfg_scale=<span class="hljs-number">1.0</span>,
    generator=torch.manual_seed(<span class="hljs-number">0</span>),
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;qwen_fewsteps.png&quot;</span>)`,wrap:!1}}),oe=new on({props:{title:"QwenImagePipeline",local:"diffusers.QwenImagePipeline",headingTag:"h2"}}),ie=new M({props:{name:"class diffusers.QwenImagePipeline",anchor:"diffusers.QwenImagePipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImagePipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImagePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImagePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImagePipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImagePipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L132"}}),re=new M({props:{name:"__call__",anchor:"diffusers.QwenImagePipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 1.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImagePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImagePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImagePipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
When &gt; 1.0 and a provided <code>negative_prompt</code>, enables true classifier-free guidance.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImagePipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImagePipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImagePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImagePipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImagePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.5) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.QwenImagePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImagePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImagePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImagePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImagePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImagePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImagePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImagePipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImagePipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImagePipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImagePipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L427",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),G=new xt({props:{anchor:"diffusers.QwenImagePipeline.__call__.example",$$slots:{default:[ia]},$$scope:{ctx:P}}}),le=new M({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImagePipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L353"}}),pe=new M({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImagePipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L368"}}),de=new M({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImagePipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L346"}}),ce=new M({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImagePipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L360"}}),me=new M({props:{name:"encode_prompt",anchor:"diffusers.QwenImagePipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImagePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImagePipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImagePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImagePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L226"}}),ge=new on({props:{title:"QwenImagePipelineOutput",local:"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput",headingTag:"h2"}}),ue=new M({props:{name:"class diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput",anchor:"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or numpy array of shape <code>(batch_size, height, width, num_channels)</code>. PIL images or numpy array present the denoised images of the diffusion pipeline.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_output.py#L10"}}),fe=new on({props:{title:"QwenImageImg2ImgPipeline",local:"diffusers.QwenImageImg2ImgPipeline",headingTag:"h2"}}),he=new M({props:{name:"class diffusers.QwenImageImg2ImgPipeline",anchor:"diffusers.QwenImageImg2ImgPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageImg2ImgPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L134"}}),_e=new M({props:{name:"__call__",anchor:"diffusers.QwenImageImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 1.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
When &gt; 1.0 and a provided <code>negative_prompt</code>, enables true classifier-free guidance.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.5) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L501",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),z=new xt({props:{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.example",$$slots:{default:[ra]},$$scope:{ctx:P}}}),we=new M({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L402"}}),be=new M({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageImg2ImgPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L417"}}),ye=new M({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L395"}}),Ie=new M({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageImg2ImgPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L409"}}),ve=new M({props:{name:"encode_prompt",anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L269"}}),Me=new on({props:{title:"QwenImageInpaintPipeline",local:"diffusers.QwenImageInpaintPipeline",headingTag:"h2"}}),Te=new M({props:{name:"class diffusers.QwenImageInpaintPipeline",anchor:"diffusers.QwenImageInpaintPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageInpaintPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L137"}}),xe=new M({props:{name:"__call__",anchor:"diffusers.QwenImageInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 1.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
When &gt; 1.0 and a provided <code>negative_prompt</code>, enables true classifier-free guidance.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.mask_image_latent",description:`<strong>mask_image_latent</strong> (<code>torch.Tensor</code>, <code>List[torch.Tensor]</code>) &#x2014;
<code>Tensor</code> representing an image batch to mask <code>image</code> generated by VAE. If not provided, the mask
latents tensor will ge generated by <code>mask_image</code>.`,name:"mask_image_latent"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.5) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L611",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),Y=new xt({props:{anchor:"diffusers.QwenImageInpaintPipeline.__call__.example",$$slots:{default:[la]},$$scope:{ctx:P}}}),$e=new M({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageInpaintPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L429"}}),Qe=new M({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageInpaintPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L444"}}),Je=new M({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageInpaintPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L422"}}),ke=new M({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageInpaintPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L436"}}),Ue=new M({props:{name:"encode_prompt",anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L280"}}),je=new sa({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/qwenimage.md"}}),{c(){p=o("meta"),k=t(),b=o("p"),_=t(),d(v.$$.fragment),r=t(),Q=o("p"),Q.textContent=$t,ln=t(),ne=o("p"),ne.innerHTML=Qt,pn=t(),d(V.$$.fragment),dn=t(),d(te.$$.fragment),cn=t(),ae=o("p"),ae.innerHTML=Jt,mn=t(),E=o("details"),Ze=o("summary"),Ze.textContent=kt,Vn=t(),d(se.$$.fragment),gn=t(),d(oe.$$.fragment),un=t(),T=o("div"),d(ie.$$.fragment),En=t(),We=o("p"),We.textContent=Ut,Gn=t(),C=o("div"),d(re.$$.fragment),Nn=t(),Le=o("p"),Le.textContent=jt,Bn=t(),d(G.$$.fragment),Xn=t(),N=o("div"),d(le.$$.fragment),Rn=t(),qe=o("p"),qe.innerHTML=Pt,zn=t(),B=o("div"),d(pe.$$.fragment),Dn=t(),Ve=o("p"),Ve.innerHTML=Ct,An=t(),X=o("div"),d(de.$$.fragment),Fn=t(),Ee=o("p"),Ee.textContent=Zt,Hn=t(),R=o("div"),d(ce.$$.fragment),Yn=t(),Ge=o("p"),Ge.textContent=Wt,Sn=t(),Ne=o("div"),d(me.$$.fragment),fn=t(),d(ge.$$.fragment),hn=t(),L=o("div"),d(ue.$$.fragment),On=t(),Be=o("p"),Be.textContent=Lt,_n=t(),d(fe.$$.fragment),wn=t(),x=o("div"),d(he.$$.fragment),Kn=t(),Xe=o("p"),Xe.textContent=qt,et=t(),Z=o("div"),d(_e.$$.fragment),nt=t(),Re=o("p"),Re.textContent=Vt,tt=t(),d(z.$$.fragment),at=t(),D=o("div"),d(we.$$.fragment),st=t(),ze=o("p"),ze.innerHTML=Et,ot=t(),A=o("div"),d(be.$$.fragment),it=t(),De=o("p"),De.innerHTML=Gt,rt=t(),F=o("div"),d(ye.$$.fragment),lt=t(),Ae=o("p"),Ae.textContent=Nt,pt=t(),H=o("div"),d(Ie.$$.fragment),dt=t(),Fe=o("p"),Fe.textContent=Bt,ct=t(),He=o("div"),d(ve.$$.fragment),bn=t(),d(Me.$$.fragment),yn=t(),$=o("div"),d(Te.$$.fragment),mt=t(),Ye=o("p"),Ye.textContent=Xt,gt=t(),W=o("div"),d(xe.$$.fragment),ut=t(),Se=o("p"),Se.textContent=Rt,ft=t(),d(Y.$$.fragment),ht=t(),S=o("div"),d($e.$$.fragment),_t=t(),Oe=o("p"),Oe.innerHTML=zt,wt=t(),O=o("div"),d(Qe.$$.fragment),bt=t(),Ke=o("p"),Ke.innerHTML=Dt,yt=t(),K=o("div"),d(Je.$$.fragment),It=t(),en=o("p"),en.textContent=At,vt=t(),ee=o("div"),d(ke.$$.fragment),Mt=t(),nn=o("p"),nn.textContent=Ft,Tt=t(),tn=o("div"),d(Ue.$$.fragment),In=t(),d(je.$$.fragment),vn=t(),rn=o("p"),this.h()},l(e){const l=ta("svelte-u9bgzb",document.head);p=i(l,"META",{name:!0,content:!0}),l.forEach(s),k=a(e),b=i(e,"P",{}),y(b).forEach(s),_=a(e),c(v.$$.fragment,e),r=a(e),Q=i(e,"P",{"data-svelte-h":!0}),w(Q)!=="svelte-f9n2hx"&&(Q.textContent=$t),ln=a(e),ne=i(e,"P",{"data-svelte-h":!0}),w(ne)!=="svelte-mwc7ri"&&(ne.innerHTML=Qt),pn=a(e),c(V.$$.fragment,e),dn=a(e),c(te.$$.fragment,e),cn=a(e),ae=i(e,"P",{"data-svelte-h":!0}),w(ae)!=="svelte-upho6n"&&(ae.innerHTML=Jt),mn=a(e),E=i(e,"DETAILS",{});var Pe=y(E);Ze=i(Pe,"SUMMARY",{"data-svelte-h":!0}),w(Ze)!=="svelte-14caxiv"&&(Ze.textContent=kt),Vn=a(Pe),c(se.$$.fragment,Pe),Pe.forEach(s),gn=a(e),c(oe.$$.fragment,e),un=a(e),T=i(e,"DIV",{class:!0});var J=y(T);c(ie.$$.fragment,J),En=a(J),We=i(J,"P",{"data-svelte-h":!0}),w(We)!=="svelte-1b1rx25"&&(We.textContent=Ut),Gn=a(J),C=i(J,"DIV",{class:!0});var q=y(C);c(re.$$.fragment,q),Nn=a(q),Le=i(q,"P",{"data-svelte-h":!0}),w(Le)!=="svelte-v78lg8"&&(Le.textContent=jt),Bn=a(q),c(G.$$.fragment,q),q.forEach(s),Xn=a(J),N=i(J,"DIV",{class:!0});var Ce=y(N);c(le.$$.fragment,Ce),Rn=a(Ce),qe=i(Ce,"P",{"data-svelte-h":!0}),w(qe)!=="svelte-1s3c06i"&&(qe.innerHTML=Pt),Ce.forEach(s),zn=a(J),B=i(J,"DIV",{class:!0});var Tn=y(B);c(pe.$$.fragment,Tn),Dn=a(Tn),Ve=i(Tn,"P",{"data-svelte-h":!0}),w(Ve)!=="svelte-pkn4ui"&&(Ve.innerHTML=Ct),Tn.forEach(s),An=a(J),X=i(J,"DIV",{class:!0});var xn=y(X);c(de.$$.fragment,xn),Fn=a(xn),Ee=i(xn,"P",{"data-svelte-h":!0}),w(Ee)!=="svelte-14bnrb6"&&(Ee.textContent=Zt),xn.forEach(s),Hn=a(J),R=i(J,"DIV",{class:!0});var $n=y(R);c(ce.$$.fragment,$n),Yn=a($n),Ge=i($n,"P",{"data-svelte-h":!0}),w(Ge)!=="svelte-1xwrf7t"&&(Ge.textContent=Wt),$n.forEach(s),Sn=a(J),Ne=i(J,"DIV",{class:!0});var Ht=y(Ne);c(me.$$.fragment,Ht),Ht.forEach(s),J.forEach(s),fn=a(e),c(ge.$$.fragment,e),hn=a(e),L=i(e,"DIV",{class:!0});var Qn=y(L);c(ue.$$.fragment,Qn),On=a(Qn),Be=i(Qn,"P",{"data-svelte-h":!0}),w(Be)!=="svelte-1qpjiuf"&&(Be.textContent=Lt),Qn.forEach(s),_n=a(e),c(fe.$$.fragment,e),wn=a(e),x=i(e,"DIV",{class:!0});var U=y(x);c(he.$$.fragment,U),Kn=a(U),Xe=i(U,"P",{"data-svelte-h":!0}),w(Xe)!=="svelte-1b1rx25"&&(Xe.textContent=qt),et=a(U),Z=i(U,"DIV",{class:!0});var an=y(Z);c(_e.$$.fragment,an),nt=a(an),Re=i(an,"P",{"data-svelte-h":!0}),w(Re)!=="svelte-v78lg8"&&(Re.textContent=Vt),tt=a(an),c(z.$$.fragment,an),an.forEach(s),at=a(U),D=i(U,"DIV",{class:!0});var Jn=y(D);c(we.$$.fragment,Jn),st=a(Jn),ze=i(Jn,"P",{"data-svelte-h":!0}),w(ze)!=="svelte-1s3c06i"&&(ze.innerHTML=Et),Jn.forEach(s),ot=a(U),A=i(U,"DIV",{class:!0});var kn=y(A);c(be.$$.fragment,kn),it=a(kn),De=i(kn,"P",{"data-svelte-h":!0}),w(De)!=="svelte-pkn4ui"&&(De.innerHTML=Gt),kn.forEach(s),rt=a(U),F=i(U,"DIV",{class:!0});var Un=y(F);c(ye.$$.fragment,Un),lt=a(Un),Ae=i(Un,"P",{"data-svelte-h":!0}),w(Ae)!=="svelte-14bnrb6"&&(Ae.textContent=Nt),Un.forEach(s),pt=a(U),H=i(U,"DIV",{class:!0});var jn=y(H);c(Ie.$$.fragment,jn),dt=a(jn),Fe=i(jn,"P",{"data-svelte-h":!0}),w(Fe)!=="svelte-1xwrf7t"&&(Fe.textContent=Bt),jn.forEach(s),ct=a(U),He=i(U,"DIV",{class:!0});var Yt=y(He);c(ve.$$.fragment,Yt),Yt.forEach(s),U.forEach(s),bn=a(e),c(Me.$$.fragment,e),yn=a(e),$=i(e,"DIV",{class:!0});var j=y($);c(Te.$$.fragment,j),mt=a(j),Ye=i(j,"P",{"data-svelte-h":!0}),w(Ye)!=="svelte-1b1rx25"&&(Ye.textContent=Xt),gt=a(j),W=i(j,"DIV",{class:!0});var sn=y(W);c(xe.$$.fragment,sn),ut=a(sn),Se=i(sn,"P",{"data-svelte-h":!0}),w(Se)!=="svelte-v78lg8"&&(Se.textContent=Rt),ft=a(sn),c(Y.$$.fragment,sn),sn.forEach(s),ht=a(j),S=i(j,"DIV",{class:!0});var Pn=y(S);c($e.$$.fragment,Pn),_t=a(Pn),Oe=i(Pn,"P",{"data-svelte-h":!0}),w(Oe)!=="svelte-1s3c06i"&&(Oe.innerHTML=zt),Pn.forEach(s),wt=a(j),O=i(j,"DIV",{class:!0});var Cn=y(O);c(Qe.$$.fragment,Cn),bt=a(Cn),Ke=i(Cn,"P",{"data-svelte-h":!0}),w(Ke)!=="svelte-pkn4ui"&&(Ke.innerHTML=Dt),Cn.forEach(s),yt=a(j),K=i(j,"DIV",{class:!0});var Zn=y(K);c(Je.$$.fragment,Zn),It=a(Zn),en=i(Zn,"P",{"data-svelte-h":!0}),w(en)!=="svelte-14bnrb6"&&(en.textContent=At),Zn.forEach(s),vt=a(j),ee=i(j,"DIV",{class:!0});var Wn=y(ee);c(ke.$$.fragment,Wn),Mt=a(Wn),nn=i(Wn,"P",{"data-svelte-h":!0}),w(nn)!=="svelte-1xwrf7t"&&(nn.textContent=Ft),Wn.forEach(s),Tt=a(j),tn=i(j,"DIV",{class:!0});var St=y(tn);c(Ue.$$.fragment,St),St.forEach(s),j.forEach(s),In=a(e),c(je.$$.fragment,e),vn=a(e),rn=i(e,"P",{}),y(rn).forEach(s),this.h()},h(){I(p,"name","hf:doc:metadata"),I(p,"content",da),I(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){n(document.head,p),h(e,k,l),h(e,b,l),h(e,_,l),m(v,e,l),h(e,r,l),h(e,Q,l),h(e,ln,l),h(e,ne,l),h(e,pn,l),m(V,e,l),h(e,dn,l),m(te,e,l),h(e,cn,l),h(e,ae,l),h(e,mn,l),h(e,E,l),n(E,Ze),n(E,Vn),m(se,E,null),h(e,gn,l),m(oe,e,l),h(e,un,l),h(e,T,l),m(ie,T,null),n(T,En),n(T,We),n(T,Gn),n(T,C),m(re,C,null),n(C,Nn),n(C,Le),n(C,Bn),m(G,C,null),n(T,Xn),n(T,N),m(le,N,null),n(N,Rn),n(N,qe),n(T,zn),n(T,B),m(pe,B,null),n(B,Dn),n(B,Ve),n(T,An),n(T,X),m(de,X,null),n(X,Fn),n(X,Ee),n(T,Hn),n(T,R),m(ce,R,null),n(R,Yn),n(R,Ge),n(T,Sn),n(T,Ne),m(me,Ne,null),h(e,fn,l),m(ge,e,l),h(e,hn,l),h(e,L,l),m(ue,L,null),n(L,On),n(L,Be),h(e,_n,l),m(fe,e,l),h(e,wn,l),h(e,x,l),m(he,x,null),n(x,Kn),n(x,Xe),n(x,et),n(x,Z),m(_e,Z,null),n(Z,nt),n(Z,Re),n(Z,tt),m(z,Z,null),n(x,at),n(x,D),m(we,D,null),n(D,st),n(D,ze),n(x,ot),n(x,A),m(be,A,null),n(A,it),n(A,De),n(x,rt),n(x,F),m(ye,F,null),n(F,lt),n(F,Ae),n(x,pt),n(x,H),m(Ie,H,null),n(H,dt),n(H,Fe),n(x,ct),n(x,He),m(ve,He,null),h(e,bn,l),m(Me,e,l),h(e,yn,l),h(e,$,l),m(Te,$,null),n($,mt),n($,Ye),n($,gt),n($,W),m(xe,W,null),n(W,ut),n(W,Se),n(W,ft),m(Y,W,null),n($,ht),n($,S),m($e,S,null),n(S,_t),n(S,Oe),n($,wt),n($,O),m(Qe,O,null),n(O,bt),n(O,Ke),n($,yt),n($,K),m(Je,K,null),n(K,It),n(K,en),n($,vt),n($,ee),m(ke,ee,null),n(ee,Mt),n(ee,nn),n($,Tt),n($,tn),m(Ue,tn,null),h(e,In,l),m(je,e,l),h(e,vn,l),h(e,rn,l),Mn=!0},p(e,[l]){const Pe={};l&2&&(Pe.$$scope={dirty:l,ctx:e}),V.$set(Pe);const J={};l&2&&(J.$$scope={dirty:l,ctx:e}),G.$set(J);const q={};l&2&&(q.$$scope={dirty:l,ctx:e}),z.$set(q);const Ce={};l&2&&(Ce.$$scope={dirty:l,ctx:e}),Y.$set(Ce)},i(e){Mn||(g(v.$$.fragment,e),g(V.$$.fragment,e),g(te.$$.fragment,e),g(se.$$.fragment,e),g(oe.$$.fragment,e),g(ie.$$.fragment,e),g(re.$$.fragment,e),g(G.$$.fragment,e),g(le.$$.fragment,e),g(pe.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(ge.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(_e.$$.fragment,e),g(z.$$.fragment,e),g(we.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(Ie.$$.fragment,e),g(ve.$$.fragment,e),g(Me.$$.fragment,e),g(Te.$$.fragment,e),g(xe.$$.fragment,e),g(Y.$$.fragment,e),g($e.$$.fragment,e),g(Qe.$$.fragment,e),g(Je.$$.fragment,e),g(ke.$$.fragment,e),g(Ue.$$.fragment,e),g(je.$$.fragment,e),Mn=!0)},o(e){u(v.$$.fragment,e),u(V.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(oe.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(G.$$.fragment,e),u(le.$$.fragment,e),u(pe.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),u(_e.$$.fragment,e),u(z.$$.fragment,e),u(we.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(Ie.$$.fragment,e),u(ve.$$.fragment,e),u(Me.$$.fragment,e),u(Te.$$.fragment,e),u(xe.$$.fragment,e),u(Y.$$.fragment,e),u($e.$$.fragment,e),u(Qe.$$.fragment,e),u(Je.$$.fragment,e),u(ke.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),Mn=!1},d(e){e&&(s(k),s(b),s(_),s(r),s(Q),s(ln),s(ne),s(pn),s(dn),s(cn),s(ae),s(mn),s(E),s(gn),s(un),s(T),s(fn),s(hn),s(L),s(_n),s(wn),s(x),s(bn),s(yn),s($),s(In),s(vn),s(rn)),s(p),f(v,e),f(V,e),f(te,e),f(se),f(oe,e),f(ie),f(re),f(G),f(le),f(pe),f(de),f(ce),f(me),f(ge,e),f(ue),f(fe,e),f(he),f(_e),f(z),f(we),f(be),f(ye),f(Ie),f(ve),f(Me,e),f(Te),f(xe),f(Y),f($e),f(Qe),f(Je),f(ke),f(Ue),f(je,e)}}}const da='{"title":"QwenImage","local":"qwenimage","sections":[{"title":"LoRA for faster inference","local":"lora-for-faster-inference","sections":[],"depth":2},{"title":"QwenImagePipeline","local":"diffusers.QwenImagePipeline","sections":[],"depth":2},{"title":"QwenImagePipelineOutput","local":"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput","sections":[],"depth":2},{"title":"QwenImageImg2ImgPipeline","local":"diffusers.QwenImageImg2ImgPipeline","sections":[],"depth":2},{"title":"QwenImageInpaintPipeline","local":"diffusers.QwenImageInpaintPipeline","sections":[],"depth":2}],"depth":1}';function ca(P){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ba extends ea{constructor(p){super(),na(this,p,ca,pa,Ot,{})}}export{ba as component};
