import{s as ot,o as st,n as tt}from"../chunks/scheduler.8c3d61f6.js";import{S as at,i as lt,g as r,s,r as g,A as rt,h as i,f as t,c as a,j as v,u as f,x as w,k as I,y as o,a as p,v as h,d as _,t as y,w as b}from"../chunks/index.da70eac4.js";import{T as it}from"../chunks/Tip.1d9b8c37.js";import{D as B}from"../chunks/Docstring.c021b19a.js";import{C as nt}from"../chunks/CodeBlock.a9c4becf.js";import{E as pt}from"../chunks/ExampleCodeBlock.56b4589c.js";import{H as Pe,E as ct}from"../chunks/getInferenceSnippets.725ed3d4.js";function dt(O){let l,J='Flux can be quite expensive to run on consumer hardware devices. However, you can perform a suite of optimizations to run it faster and in a more memory-friendly manner. Check out <a href="https://huggingface.co/blog/sd3#memory-optimizations-for-sd3" rel="nofollow">this section</a> for more details. Additionally, Flux can benefit from quantization for memory efficiency with a trade-off in inference latency. Refer to <a href="https://huggingface.co/blog/quanto-diffusers" rel="nofollow">this blog post</a> to learn more. For an exhaustive list of resources, check out <a href="https://gist.github.com/sayakpaul/b664605caf0aa3bf8585ab109dd5ac9c" rel="nofollow">this gist</a>.';return{c(){l=r("p"),l.innerHTML=J},l(u){l=i(u,"P",{"data-svelte-h":!0}),w(l)!=="svelte-lx7p45"&&(l.innerHTML=J)},m(u,M){p(u,l,M)},p:tt,d(u){u&&t(l)}}}function mt(O){let l,J="Examples:",u,M,T;return M=new nt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.models.transformers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> image_gen_aux <span class="hljs-keyword">import</span> DepthPreprocessor  <span class="hljs-comment"># https://github.com/huggingface/image_gen_aux</span>
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

pipe = FluxControlInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-Depth-dev&quot;</span>,
    torch_dtype=torch.bfloat16,
)
<span class="hljs-comment"># use following lines if you have GPU constraints</span>
<span class="hljs-comment"># ---------------------------------------------------------------</span>
transformer = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;sayakpaul/FLUX.1-Depth-dev-nf4&quot;</span>, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>, torch_dtype=torch.bfloat16
)
text_encoder_2 = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;sayakpaul/FLUX.1-Depth-dev-nf4&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>, torch_dtype=torch.bfloat16
)
pipe.transformer = transformer
pipe.text_encoder_2 = text_encoder_2
pipe.enable_model_cpu_offload()
<span class="hljs-comment"># ---------------------------------------------------------------</span>
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a blue robot singing opera with human-like expressions&quot;</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>)

head_mask = np.zeros_like(image)
head_mask[<span class="hljs-number">65</span>:<span class="hljs-number">580</span>, <span class="hljs-number">300</span>:<span class="hljs-number">642</span>] = <span class="hljs-number">255</span>
mask_image = Image.fromarray(head_mask)

processor = DepthPreprocessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-large-hf&quot;</span>)
control_image = processor(image)[<span class="hljs-number">0</span>].convert(<span class="hljs-string">&quot;RGB&quot;</span>)

output = pipe(
    prompt=prompt,
    image=image,
    control_image=control_image,
    mask_image=mask_image,
    num_inference_steps=<span class="hljs-number">30</span>,
    strength=<span class="hljs-number">0.9</span>,
    guidance_scale=<span class="hljs-number">10.0</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">42</span>),
).images[<span class="hljs-number">0</span>]
make_image_grid([image, control_image, mask_image, output.resize(image.size)], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">4</span>).save(
    <span class="hljs-string">&quot;output.png&quot;</span>
)`,wrap:!1}}),{c(){l=r("p"),l.textContent=J,u=s(),g(M.$$.fragment)},l(m){l=i(m,"P",{"data-svelte-h":!0}),w(l)!=="svelte-kvfsh7"&&(l.textContent=J),u=a(m),f(M.$$.fragment,m)},m(m,x){p(m,l,x),p(m,u,x),h(M,m,x),T=!0},p:tt,i(m){T||(_(M.$$.fragment,m),T=!0)},o(m){y(M.$$.fragment,m),T=!1},d(m){m&&(t(l),t(u)),b(M,m)}}}function ut(O){let l,J,u,M,T,m,x,Ne='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',pe,G,Re="FluxControlInpaintPipeline is an implementation of Inpainting for Flux.1 Depth/Canny models. It is a pipeline that allows you to inpaint images using the Flux.1 Depth/Canny models. The pipeline takes an image and a mask as input and returns the inpainted image.",ce,V,Xe="FLUX.1 Depth and Canny [dev] is a 12 billion parameter rectified flow transformer capable of generating an image based on a text description while following the structure of a given input image. <strong>This is not a ControlNet model</strong>.",de,$,ze='<thead><tr><th>Control type</th> <th>Developer</th> <th>Link</th></tr></thead> <tbody><tr><td>Depth</td> <td><a href="https://huggingface.co/black-forest-labs" rel="nofollow">Black Forest Labs</a></td> <td><a href="https://huggingface.co/black-forest-labs/FLUX.1-Depth-dev" rel="nofollow">Link</a></td></tr> <tr><td>Canny</td> <td><a href="https://huggingface.co/black-forest-labs" rel="nofollow">Black Forest Labs</a></td> <td><a href="https://huggingface.co/black-forest-labs/FLUX.1-Canny-dev" rel="nofollow">Link</a></td></tr></tbody>',me,k,ue,E,ge,P,fe,c,N,Ue,K,He="The Flux pipeline for image inpainting using Flux-dev-Depth/Canny.",ve,ee,Ye='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',Ce,U,R,Le,te,De="Function invoked when calling the pipeline for generation.",ke,Z,Ze,F,X,Fe,ne,Ae=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,je,j,z,We,oe,Qe=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Se,W,H,Be,se,qe=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ge,S,Y,Ve,ae,Oe=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,$e,le,D,he,A,_e,C,Q,Ee,re,Ke="Output class for Flux image generation pipelines.",ye,q,be,ie,Me;return T=new Pe({props:{title:"FluxControlInpaint",local:"fluxcontrolinpaint",headingTag:"h1"}}),k=new it({props:{$$slots:{default:[dt]},$$scope:{ctx:O}}}),E=new nt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.models.transformers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> image_gen_aux <span class="hljs-keyword">import</span> DepthPreprocessor <span class="hljs-comment"># https://github.com/huggingface/image_gen_aux</span>
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

pipe = FluxControlInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-Depth-dev&quot;</span>,
    torch_dtype=torch.bfloat16,
)
<span class="hljs-comment"># use following lines if you have GPU constraints</span>
<span class="hljs-comment"># ---------------------------------------------------------------</span>
transformer = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;sayakpaul/FLUX.1-Depth-dev-nf4&quot;</span>, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>, torch_dtype=torch.bfloat16
)
text_encoder_2 = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;sayakpaul/FLUX.1-Depth-dev-nf4&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>, torch_dtype=torch.bfloat16
)
pipe.transformer = transformer
pipe.text_encoder_2 = text_encoder_2
pipe.enable_model_cpu_offload()
<span class="hljs-comment"># ---------------------------------------------------------------</span>
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a blue robot singing opera with human-like expressions&quot;</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>)

head_mask = np.zeros_like(image)
head_mask[<span class="hljs-number">65</span>:<span class="hljs-number">580</span>,<span class="hljs-number">300</span>:<span class="hljs-number">642</span>] = <span class="hljs-number">255</span>
mask_image = Image.fromarray(head_mask)

processor = DepthPreprocessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-large-hf&quot;</span>)
control_image = processor(image)[<span class="hljs-number">0</span>].convert(<span class="hljs-string">&quot;RGB&quot;</span>)

output = pipe(
    prompt=prompt,
    image=image,
    control_image=control_image,
    mask_image=mask_image,
    num_inference_steps=<span class="hljs-number">30</span>,
    strength=<span class="hljs-number">0.9</span>,
    guidance_scale=<span class="hljs-number">10.0</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">42</span>),
).images[<span class="hljs-number">0</span>]
make_image_grid([image, control_image, mask_image, output.resize(image.size)], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">4</span>).save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),P=new Pe({props:{title:"FluxControlInpaintPipeline",local:"diffusers.FluxControlInpaintPipeline",headingTag:"h2"}}),N=new B({props:{name:"class diffusers.FluxControlInpaintPipeline",anchor:"diffusers.FluxControlInpaintPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.FluxControlInpaintPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxControlInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxControlInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxControlInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxControlInpaintPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxControlInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxControlInpaintPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control_inpaint.py#L204"}}),R=new B({props:{name:"__call__",anchor:"diffusers.FluxControlInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxControlInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"control_image"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.mask_image_latent",description:`<strong>mask_image_latent</strong> (<code>torch.Tensor</code>, <code>List[torch.Tensor]</code>) &#x2014;
<code>Tensor</code> representing an image batch to mask <code>image</code> generated by VAE. If not provided, the mask
latents tensor will ge generated by <code>mask_image</code>.`,name:"mask_image_latent"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxControlInpaintPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control_inpaint.py#L780",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),Z=new pt({props:{anchor:"diffusers.FluxControlInpaintPipeline.__call__.example",$$slots:{default:[mt]},$$scope:{ctx:O}}}),X=new B({props:{name:"disable_vae_slicing",anchor:"diffusers.FluxControlInpaintPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control_inpaint.py#L582"}}),z=new B({props:{name:"disable_vae_tiling",anchor:"diffusers.FluxControlInpaintPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control_inpaint.py#L597"}}),H=new B({props:{name:"enable_vae_slicing",anchor:"diffusers.FluxControlInpaintPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control_inpaint.py#L575"}}),Y=new B({props:{name:"enable_vae_tiling",anchor:"diffusers.FluxControlInpaintPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control_inpaint.py#L589"}}),D=new B({props:{name:"encode_prompt",anchor:"diffusers.FluxControlInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxControlInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxControlInpaintPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxControlInpaintPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxControlInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlInpaintPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control_inpaint.py#L374"}}),A=new Pe({props:{title:"FluxPipelineOutput",local:"diffusers.pipelines.flux.pipeline_output.FluxPipelineOutput",headingTag:"h2"}}),Q=new B({props:{name:"class diffusers.pipelines.flux.pipeline_output.FluxPipelineOutput",anchor:"diffusers.pipelines.flux.pipeline_output.FluxPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.flux.pipeline_output.FluxPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>torch.Tensor</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or numpy array or torch tensor of shape <code>(batch_size, height, width, num_channels)</code>. PIL images or numpy array present the denoised images of the diffusion
pipeline. Torch tensors can represent either the denoised images or the intermediate latents ready to be
passed to the decoder.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_output.py#L11"}}),q=new ct({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/control_flux_inpaint.md"}}),{c(){l=r("meta"),J=s(),u=r("p"),M=s(),g(T.$$.fragment),m=s(),x=r("div"),x.innerHTML=Ne,pe=s(),G=r("p"),G.textContent=Re,ce=s(),V=r("p"),V.innerHTML=Xe,de=s(),$=r("table"),$.innerHTML=ze,me=s(),g(k.$$.fragment),ue=s(),g(E.$$.fragment),ge=s(),g(P.$$.fragment),fe=s(),c=r("div"),g(N.$$.fragment),Ue=s(),K=r("p"),K.textContent=He,ve=s(),ee=r("p"),ee.innerHTML=Ye,Ce=s(),U=r("div"),g(R.$$.fragment),Le=s(),te=r("p"),te.textContent=De,ke=s(),g(Z.$$.fragment),Ze=s(),F=r("div"),g(X.$$.fragment),Fe=s(),ne=r("p"),ne.innerHTML=Ae,je=s(),j=r("div"),g(z.$$.fragment),We=s(),oe=r("p"),oe.innerHTML=Qe,Se=s(),W=r("div"),g(H.$$.fragment),Be=s(),se=r("p"),se.textContent=qe,Ge=s(),S=r("div"),g(Y.$$.fragment),Ve=s(),ae=r("p"),ae.textContent=Oe,$e=s(),le=r("div"),g(D.$$.fragment),he=s(),g(A.$$.fragment),_e=s(),C=r("div"),g(Q.$$.fragment),Ee=s(),re=r("p"),re.textContent=Ke,ye=s(),g(q.$$.fragment),be=s(),ie=r("p"),this.h()},l(e){const n=rt("svelte-u9bgzb",document.head);l=i(n,"META",{name:!0,content:!0}),n.forEach(t),J=a(e),u=i(e,"P",{}),v(u).forEach(t),M=a(e),f(T.$$.fragment,e),m=a(e),x=i(e,"DIV",{class:!0,"data-svelte-h":!0}),w(x)!=="svelte-si9ct8"&&(x.innerHTML=Ne),pe=a(e),G=i(e,"P",{"data-svelte-h":!0}),w(G)!=="svelte-thlb2p"&&(G.textContent=Re),ce=a(e),V=i(e,"P",{"data-svelte-h":!0}),w(V)!=="svelte-1poqhj5"&&(V.innerHTML=Xe),de=a(e),$=i(e,"TABLE",{"data-svelte-h":!0}),w($)!=="svelte-15v4ttf"&&($.innerHTML=ze),me=a(e),f(k.$$.fragment,e),ue=a(e),f(E.$$.fragment,e),ge=a(e),f(P.$$.fragment,e),fe=a(e),c=i(e,"DIV",{class:!0});var d=v(c);f(N.$$.fragment,d),Ue=a(d),K=i(d,"P",{"data-svelte-h":!0}),w(K)!=="svelte-1t0mqls"&&(K.textContent=He),ve=a(d),ee=i(d,"P",{"data-svelte-h":!0}),w(ee)!=="svelte-mxgguy"&&(ee.innerHTML=Ye),Ce=a(d),U=i(d,"DIV",{class:!0});var L=v(U);f(R.$$.fragment,L),Le=a(L),te=i(L,"P",{"data-svelte-h":!0}),w(te)!=="svelte-v78lg8"&&(te.textContent=De),ke=a(L),f(Z.$$.fragment,L),L.forEach(t),Ze=a(d),F=i(d,"DIV",{class:!0});var we=v(F);f(X.$$.fragment,we),Fe=a(we),ne=i(we,"P",{"data-svelte-h":!0}),w(ne)!=="svelte-1s3c06i"&&(ne.innerHTML=Ae),we.forEach(t),je=a(d),j=i(d,"DIV",{class:!0});var Te=v(j);f(z.$$.fragment,Te),We=a(Te),oe=i(Te,"P",{"data-svelte-h":!0}),w(oe)!=="svelte-pkn4ui"&&(oe.innerHTML=Qe),Te.forEach(t),Se=a(d),W=i(d,"DIV",{class:!0});var xe=v(W);f(H.$$.fragment,xe),Be=a(xe),se=i(xe,"P",{"data-svelte-h":!0}),w(se)!=="svelte-14bnrb6"&&(se.textContent=qe),xe.forEach(t),Ge=a(d),S=i(d,"DIV",{class:!0});var Ie=v(S);f(Y.$$.fragment,Ie),Ve=a(Ie),ae=i(Ie,"P",{"data-svelte-h":!0}),w(ae)!=="svelte-1xwrf7t"&&(ae.textContent=Oe),Ie.forEach(t),$e=a(d),le=i(d,"DIV",{class:!0});var et=v(le);f(D.$$.fragment,et),et.forEach(t),d.forEach(t),he=a(e),f(A.$$.fragment,e),_e=a(e),C=i(e,"DIV",{class:!0});var Je=v(C);f(Q.$$.fragment,Je),Ee=a(Je),re=i(Je,"P",{"data-svelte-h":!0}),w(re)!=="svelte-10l6oeh"&&(re.textContent=Ke),Je.forEach(t),ye=a(e),f(q.$$.fragment,e),be=a(e),ie=i(e,"P",{}),v(ie).forEach(t),this.h()},h(){I(l,"name","hf:doc:metadata"),I(l,"content",gt),I(x,"class","flex flex-wrap space-x-1"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){o(document.head,l),p(e,J,n),p(e,u,n),p(e,M,n),h(T,e,n),p(e,m,n),p(e,x,n),p(e,pe,n),p(e,G,n),p(e,ce,n),p(e,V,n),p(e,de,n),p(e,$,n),p(e,me,n),h(k,e,n),p(e,ue,n),h(E,e,n),p(e,ge,n),h(P,e,n),p(e,fe,n),p(e,c,n),h(N,c,null),o(c,Ue),o(c,K),o(c,ve),o(c,ee),o(c,Ce),o(c,U),h(R,U,null),o(U,Le),o(U,te),o(U,ke),h(Z,U,null),o(c,Ze),o(c,F),h(X,F,null),o(F,Fe),o(F,ne),o(c,je),o(c,j),h(z,j,null),o(j,We),o(j,oe),o(c,Se),o(c,W),h(H,W,null),o(W,Be),o(W,se),o(c,Ge),o(c,S),h(Y,S,null),o(S,Ve),o(S,ae),o(c,$e),o(c,le),h(D,le,null),p(e,he,n),h(A,e,n),p(e,_e,n),p(e,C,n),h(Q,C,null),o(C,Ee),o(C,re),p(e,ye,n),h(q,e,n),p(e,be,n),p(e,ie,n),Me=!0},p(e,[n]){const d={};n&2&&(d.$$scope={dirty:n,ctx:e}),k.$set(d);const L={};n&2&&(L.$$scope={dirty:n,ctx:e}),Z.$set(L)},i(e){Me||(_(T.$$.fragment,e),_(k.$$.fragment,e),_(E.$$.fragment,e),_(P.$$.fragment,e),_(N.$$.fragment,e),_(R.$$.fragment,e),_(Z.$$.fragment,e),_(X.$$.fragment,e),_(z.$$.fragment,e),_(H.$$.fragment,e),_(Y.$$.fragment,e),_(D.$$.fragment,e),_(A.$$.fragment,e),_(Q.$$.fragment,e),_(q.$$.fragment,e),Me=!0)},o(e){y(T.$$.fragment,e),y(k.$$.fragment,e),y(E.$$.fragment,e),y(P.$$.fragment,e),y(N.$$.fragment,e),y(R.$$.fragment,e),y(Z.$$.fragment,e),y(X.$$.fragment,e),y(z.$$.fragment,e),y(H.$$.fragment,e),y(Y.$$.fragment,e),y(D.$$.fragment,e),y(A.$$.fragment,e),y(Q.$$.fragment,e),y(q.$$.fragment,e),Me=!1},d(e){e&&(t(J),t(u),t(M),t(m),t(x),t(pe),t(G),t(ce),t(V),t(de),t($),t(me),t(ue),t(ge),t(fe),t(c),t(he),t(_e),t(C),t(ye),t(be),t(ie)),t(l),b(T,e),b(k,e),b(E,e),b(P,e),b(N),b(R),b(Z),b(X),b(z),b(H),b(Y),b(D),b(A,e),b(Q),b(q,e)}}}const gt='{"title":"FluxControlInpaint","local":"fluxcontrolinpaint","sections":[{"title":"FluxControlInpaintPipeline","local":"diffusers.FluxControlInpaintPipeline","sections":[],"depth":2},{"title":"FluxPipelineOutput","local":"diffusers.pipelines.flux.pipeline_output.FluxPipelineOutput","sections":[],"depth":2}],"depth":1}';function ft(O){return st(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends at{constructor(l){super(),lt(this,l,ft,ut,ot,{})}}export{xt as component};
