import{s as Mr,o as xr,n as Z}from"../chunks/scheduler.182ea377.js";import{S as Tr,i as Cr,g as i,s,r as m,A as Ir,h as l,f as d,c as a,j as T,u,x as p,k as C,y as n,a as w,v as g,d as h,t as b,w as _}from"../chunks/index.abf12888.js";import{T as pt}from"../chunks/Tip.230e2334.js";import{D as I}from"../chunks/Docstring.93f6f462.js";import{C as F}from"../chunks/CodeBlock.57fe6e13.js";import{E as W}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Nn}from"../chunks/Heading.16916d63.js";function Jr(x){let o,v='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){o=i("p"),o.innerHTML=v},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1wmc0l4"&&(o.innerHTML=v)},m(c,r){w(c,o,r)},p:Z,d(c){c&&d(o)}}}function $r(x){let o,v="Examples:",c,r,y;return r=new F({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install opencv-python transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> cv2
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = Image.fromarray(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load control net and stable diffusion v1-5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionControlNetPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># speed up diffusion process with faster scheduler and memory optimization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># remove following line if xformers is not installed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention()

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;futuristic-looking woman&quot;</span>, num_inference_steps=<span class="hljs-number">20</span>, generator=generator, image=canny_image
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function jr(x){let o,v=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=i("p"),o.innerHTML=v},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-ackzsn"&&(o.innerHTML=v)},m(c,r){w(c,o,r)},p:Z,d(c){c&&d(o)}}}function Nr(x){let o,v="Examples:",c,r,y;return r=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Ur(x){let o,v=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=i("p"),o.textContent=v},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-17p1lpg"&&(o.textContent=v)},m(c,r){w(c,o,r)},p:Z,d(c){c&&d(o)}}}function kr(x){let o,v="Examples:",c,r,y;return r=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Zr(x){let o,v="To load a textual inversion embedding vector in 🤗 Diffusers format:",c,r,y;return r=new F({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1y13ww6"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Sr(x){let o,v="locally:",c,r,y;return r=new F({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-4c75kq"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Pr(x){let o,v="Examples:",c,r,y;return r=new F({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install opencv-python transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetImg2ImgPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> cv2
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>np_image = np.array(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>np_image = cv2.Canny(np_image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>np_image = np_image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>np_image = np.concatenate([np_image, np_image, np_image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = Image.fromarray(np_image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load control net and stable diffusion v1-5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionControlNetImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># speed up diffusion process with faster scheduler and memory optimization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;futuristic-looking woman&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    control_image=canny_image,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Dr(x){let o,v=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=i("p"),o.innerHTML=v},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-ackzsn"&&(o.innerHTML=v)},m(c,r){w(c,o,r)},p:Z,d(c){c&&d(o)}}}function Wr(x){let o,v="Examples:",c,r,y;return r=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Fr(x){let o,v=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=i("p"),o.textContent=v},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-17p1lpg"&&(o.textContent=v)},m(c,r){w(c,o,r)},p:Z,d(c){c&&d(o)}}}function Gr(x){let o,v="Examples:",c,r,y;return r=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Br(x){let o,v="To load a textual inversion embedding vector in 🤗 Diffusers format:",c,r,y;return r=new F({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1y13ww6"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Lr(x){let o,v="locally:",c,r,y;return r=new F({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-4c75kq"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Xr(x){let o,v=`This pipeline can be used with checkpoints that have been specifically fine-tuned for inpainting
(<a href="https://huggingface.co/runwayml/stable-diffusion-inpainting" rel="nofollow">runwayml/stable-diffusion-inpainting</a>) as well as
default text-to-image Stable Diffusion checkpoints
(<a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a>). Default text-to-image
Stable Diffusion checkpoints might be preferable for ControlNets that have been fine-tuned on those, such as
<a href="https://huggingface.co/lllyasviel/control_v11p_sd15_inpaint" rel="nofollow">lllyasviel/control_v11p_sd15_inpaint</a>.`;return{c(){o=i("p"),o.innerHTML=v},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-mk8vnx"&&(o.innerHTML=v)},m(c,r){w(c,o,r)},p:Z,d(c){c&&d(o)}}}function Er(x){let o,v="Examples:",c,r,y;return r=new F({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetInpaintPipeline, ControlNetModel, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/test-arrays/resolve/main/stable_diffusion_inpaint/boy.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/test-arrays/resolve/main/stable_diffusion_inpaint/boy_mask.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = mask_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">make_canny_condition</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = np.array(image)
<span class="hljs-meta">... </span>    image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">... </span>    image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">... </span>    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    image = Image.fromarray(image)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = make_canny_condition(init_image)

<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;lllyasviel/control_v11p_sd15_inpaint&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionControlNetInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;a handsome man with ray-ban sunglasses&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    eta=<span class="hljs-number">1.0</span>,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    mask_image=mask_image,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Vr(x){let o,v=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=i("p"),o.innerHTML=v},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-ackzsn"&&(o.innerHTML=v)},m(c,r){w(c,o,r)},p:Z,d(c){c&&d(o)}}}function Rr(x){let o,v="Examples:",c,r,y;return r=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Yr(x){let o,v=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=i("p"),o.textContent=v},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-17p1lpg"&&(o.textContent=v)},m(c,r){w(c,o,r)},p:Z,d(c){c&&d(o)}}}function zr(x){let o,v="Examples:",c,r,y;return r=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Hr(x){let o,v="To load a textual inversion embedding vector in 🤗 Diffusers format:",c,r,y;return r=new F({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1y13ww6"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Qr(x){let o,v="locally:",c,r,y;return r=new F({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-4c75kq"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function Ar(x){let o,v="Examples:",c,r,y;return r=new F({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionControlNetPipeline, FlaxControlNetModel


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_key</span>(<span class="hljs-params">seed=<span class="hljs-number">0</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> jax.random.PRNGKey(seed)


<span class="hljs-meta">&gt;&gt;&gt; </span>rng = create_key(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/test-doc-assets/resolve/main/blog_post_cell_10_output_0.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = <span class="hljs-string">&quot;best quality, extremely detailed&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompts = <span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load control net and stable diffusion v1-5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet, controlnet_params = FlaxControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, from_pt=<span class="hljs-literal">True</span>, dtype=jnp.float32
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe, params = FlaxStableDiffusionControlNetPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, revision=<span class="hljs-string">&quot;flax&quot;</span>, dtype=jnp.float32
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>params[<span class="hljs-string">&quot;controlnet&quot;</span>] = controlnet_params

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>rng = jax.random.split(rng, jax.device_count())

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = pipe.prepare_text_inputs([prompts] * num_samples)
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt_ids = pipe.prepare_text_inputs([negative_prompts] * num_samples)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_image = pipe.prepare_image_inputs([canny_image] * num_samples)

<span class="hljs-meta">&gt;&gt;&gt; </span>p_params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt_ids = shard(negative_prompt_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_image = shard(processed_image)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt_ids=prompt_ids,
<span class="hljs-meta">... </span>    image=processed_image,
<span class="hljs-meta">... </span>    params=p_params,
<span class="hljs-meta">... </span>    prng_seed=rng,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    neg_prompt_ids=negative_prompt_ids,
<span class="hljs-meta">... </span>    jit=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>output_images = pipe.numpy_to_pil(np.asarray(output.reshape((num_samples,) + output.shape[-<span class="hljs-number">3</span>:])))
<span class="hljs-meta">&gt;&gt;&gt; </span>output_images = make_image_grid(output_images, num_samples // <span class="hljs-number">4</span>, <span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_images.save(<span class="hljs-string">&quot;generated_image.png&quot;</span>)`,wrap:!1}}),{c(){o=i("p"),o.textContent=v,c=s(),m(r.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=v),c=a(t),u(r.$$.fragment,t)},m(t,M){w(t,o,M),w(t,c,M),g(r,t,M),y=!0},p:Z,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){b(r.$$.fragment,t),y=!1},d(t){t&&(d(o),d(c)),_(r,t)}}}function qr(x){let o,v,c,r,y,t,M,tl='ControlNet was introduced in <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">Adding Conditional Control to Text-to-Image Diffusion Models</a> by Lvmin Zhang and Maneesh Agrawala.',qo,ft,nl="With a ControlNet model, you can provide an additional control image to condition and control Stable Diffusion generation. For example, if you provide a depth map, the ControlNet model generates an image that’ll preserve the spatial information from the depth map. It is a more flexible and accurate way to control the image generation process.",Oo,mt,ol="The abstract from the paper is:",Ko,ut,sl="<em>We present a neural network structure, ControlNet, to control pretrained large diffusion models to support additional input conditions. The ControlNet learns task-specific conditions in an end-to-end way, and the learning is robust even when the training dataset is small (&lt; 50k). Moreover, training a ControlNet is as fast as fine-tuning a diffusion model, and the model can be trained on a personal devices. Alternatively, if powerful computation clusters are available, the model can scale to large amounts (millions to billions) of data. We report that large diffusion models like Stable Diffusion can be augmented with ControlNets to enable conditional inputs like edge maps, segmentation maps, keypoints, etc. This may enrich the methods to control large diffusion models and further facilitate related applications.</em>",es,gt,al='This model was contributed by <a href="https://huggingface.co/takuma104" rel="nofollow">takuma104</a>. ❤️',ts,ht,il='The original codebase can be found at <a href="https://github.com/lllyasviel/ControlNet" rel="nofollow">lllyasviel/ControlNet</a>, and you can find official ControlNet checkpoints on <a href="https://huggingface.co/lllyasviel" rel="nofollow">lllyasviel’s</a> Hub profile.',ns,pe,os,bt,ss,$,_t,Ns,Un,ll="Pipeline for text-to-image generation using Stable Diffusion with ControlNet guidance.",Us,kn,rl=`This model inherits from <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ks,Zn,cl="The pipeline also inherits the following loading methods:",Zs,Sn,dl='<li><a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li>',Ss,se,yt,Ps,Pn,pl="The call function to the pipeline for generation.",Ds,fe,Ws,X,vt,Fs,Dn,fl=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Gs,me,Bs,ue,Ls,ge,wt,Xs,Wn,ml=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Es,he,Mt,Vs,Fn,ul=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Rs,be,xt,Ys,Gn,gl=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,zs,E,Tt,Hs,Bn,hl=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Qs,_e,As,ye,qs,ve,Ct,Os,Ln,bl='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Ks,S,It,ea,Xn,_l=`Load textual inversion embeddings into the text encoder of <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,ta,En,yl="Example:",na,we,oa,Vn,vl=`To load a textual inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,sa,Me,aa,xe,Jt,ia,Rn,wl="Disables the FreeU mechanism if enabled.",la,Te,$t,ra,Yn,Ml=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,ca,V,jt,da,zn,xl='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',pa,Hn,Tl="The suffixes after the scaling factors represent the stages where they are being applied.",fa,Qn,Cl=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,ma,Ce,Nt,ua,An,Il=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,ga,Ie,Ut,ha,qn,Jl="Encodes the prompt into text encoder hidden states.",as,kt,is,j,Zt,ba,On,$l="Pipeline for image-to-image generation using Stable Diffusion with ControlNet guidance.",_a,Kn,jl=`This model inherits from <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ya,eo,Nl="The pipeline also inherits the following loading methods:",va,to,Ul='<li><a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li>',wa,ae,St,Ma,no,kl="The call function to the pipeline for generation.",xa,Je,Ta,R,Pt,Ca,oo,Zl=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Ia,$e,Ja,je,$a,Ne,Dt,ja,so,Sl=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Na,Ue,Wt,Ua,ao,Pl=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,ka,ke,Ft,Za,io,Dl=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Sa,Y,Gt,Pa,lo,Wl=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Da,Ze,Wa,Se,Fa,Pe,Bt,Ga,ro,Fl='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Ba,P,Lt,La,co,Gl=`Load textual inversion embeddings into the text encoder of <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Xa,po,Bl="Example:",Ea,De,Va,fo,Ll=`To load a textual inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Ra,We,Ya,Fe,Xt,za,mo,Xl="Disables the FreeU mechanism if enabled.",Ha,Ge,Et,Qa,uo,El=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Aa,z,Vt,qa,go,Vl='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Oa,ho,Rl="The suffixes after the scaling factors represent the stages where they are being applied.",Ka,bo,Yl=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,ei,Be,Rt,ti,_o,zl=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,ni,Le,Yt,oi,yo,Hl="Encodes the prompt into text encoder hidden states.",ls,zt,rs,J,Ht,si,vo,Ql="Pipeline for image inpainting using Stable Diffusion with ControlNet guidance.",ai,wo,Al=`This model inherits from <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ii,Mo,ql="The pipeline also inherits the following loading methods:",li,xo,Ol='<li><a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li>',ri,Xe,ci,ie,Qt,di,To,Kl="The call function to the pipeline for generation.",pi,Ee,fi,H,At,mi,Co,er=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,ui,Ve,gi,Re,hi,Ye,qt,bi,Io,tr=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,_i,ze,Ot,yi,Jo,nr=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,vi,He,Kt,wi,$o,or=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Mi,Q,en,xi,jo,sr=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Ti,Qe,Ci,Ae,Ii,qe,tn,Ji,No,ar='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',$i,D,nn,ji,Uo,ir=`Load textual inversion embeddings into the text encoder of <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Ni,ko,lr="Example:",Ui,Oe,ki,Zo,rr=`To load a textual inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Zi,Ke,Si,et,on,Pi,So,cr="Disables the FreeU mechanism if enabled.",Di,tt,sn,Wi,Po,dr=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Fi,A,an,Gi,Do,pr='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Bi,Wo,fr="The suffixes after the scaling factors represent the stages where they are being applied.",Li,Fo,mr=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Xi,nt,ln,Ei,Go,ur=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Vi,ot,rn,Ri,Bo,gr="Encodes the prompt into text encoder hidden states.",cs,cn,ds,re,dn,Yi,Lo,hr="Output class for Stable Diffusion pipelines.",ps,pn,fs,L,fn,zi,Xo,br="Flax-based pipeline for text-to-image generation using Stable Diffusion with ControlNet Guidance.",Hi,Eo,_r=`This model inherits from <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Qi,le,mn,Ai,Vo,yr="The call function to the pipeline for generation.",qi,st,ms,un,us,O,gn,Oi,Ro,vr="Output class for Flax-based Stable Diffusion pipelines.",Ki,at,hn,el,Yo,wr="“Returns a new object replacing the specified fields with new values.",gs,Ao,hs;return y=new Nn({props:{title:"ControlNet",local:"controlnet",headingTag:"h1"}}),pe=new pt({props:{$$slots:{default:[Jr]},$$scope:{ctx:x}}}),bt=new Nn({props:{title:"StableDiffusionControlNetPipeline",local:"diffusers.StableDiffusionControlNetPipeline",headingTag:"h2"}}),_t=new I({props:{name:"class diffusers.StableDiffusionControlNetPipeline",anchor:"diffusers.StableDiffusionControlNetPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": typing.Union[diffusers.models.controlnet.ControlNetModel, typing.List[diffusers.models.controlnet.ControlNetModel], typing.Tuple[diffusers.models.controlnet.ControlNetModel], diffusers.pipelines.controlnet.multicontrolnet.MultiControlNetModel]"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.22.1/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionControlNetPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.22.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionControlNetPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/v0.22.1/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionControlNetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.22.1/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.22.1/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.22.1/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.22.1/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionControlNetPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionControlNetPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L94"}}),yt=new I({props:{name:"__call__",anchor:"diffusers.StableDiffusionControlNetPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.FloatTensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be
accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in
<code>init</code>, images must be passed as a list such that each element of the list can be correctly batched for
input to a single ControlNet.`,name:"image"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.22.1/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L729",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),fe=new W({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.example",$$slots:{default:[$r]},$$scope:{ctx:x}}}),vt=new I({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/pipeline_utils.py#L2028"}}),me=new pt({props:{warning:!0,$$slots:{default:[jr]},$$scope:{ctx:x}}}),ue=new W({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_attention_slicing.example",$$slots:{default:[Nr]},$$scope:{ctx:x}}}),wt=new I({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/pipeline_utils.py#L2068"}}),Mt=new I({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L184"}}),xt=new I({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L192"}}),Tt=new I({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/pipeline_utils.py#L1967"}}),_e=new pt({props:{warning:!0,$$slots:{default:[Ur]},$$scope:{ctx:x}}}),ye=new W({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[kr]},$$scope:{ctx:x}}}),Ct=new I({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/pipeline_utils.py#L2002"}}),It=new I({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/loaders.py#L984"}}),we=new W({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.example",$$slots:{default:[Zr]},$$scope:{ctx:x}}}),Me=new W({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.example-2",$$slots:{default:[Sr]},$$scope:{ctx:x}}}),Jt=new I({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionControlNetPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L725"}}),$t=new I({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L209"}}),jt=new I({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionControlNetPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L702"}}),Nt=new I({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L200"}}),Ut=new I({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L250"}}),kt=new Nn({props:{title:"StableDiffusionControlNetImg2ImgPipeline",local:"diffusers.StableDiffusionControlNetImg2ImgPipeline",headingTag:"h2"}}),Zt=new I({props:{name:"class diffusers.StableDiffusionControlNetImg2ImgPipeline",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": typing.Union[diffusers.models.controlnet.ControlNetModel, typing.List[diffusers.models.controlnet.ControlNetModel], typing.Tuple[diffusers.models.controlnet.ControlNetModel], diffusers.pipelines.controlnet.multicontrolnet.MultiControlNetModel]"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.22.1/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.22.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/v0.22.1/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.22.1/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.22.1/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.22.1/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.22.1/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L128"}}),St=new I({props:{name:"__call__",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 0.8"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The initial image to be used as the starting point for the image generation process. Can also accept
image latents as <code>image</code>, and if passing latents directly they are not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.FloatTensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be
accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in
<code>init</code>, images must be passed as a list such that each element of the list can be correctly batched for
input to a single ControlNet.`,name:"control_image"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.22.1/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L810",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),Je=new W({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.example",$$slots:{default:[Pr]},$$scope:{ctx:x}}}),Pt=new I({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/pipeline_utils.py#L2028"}}),$e=new pt({props:{warning:!0,$$slots:{default:[Dr]},$$scope:{ctx:x}}}),je=new W({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[Wr]},$$scope:{ctx:x}}}),Dt=new I({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/pipeline_utils.py#L2068"}}),Wt=new I({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L218"}}),Ft=new I({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L226"}}),Gt=new I({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/pipeline_utils.py#L1967"}}),Ze=new pt({props:{warning:!0,$$slots:{default:[Fr]},$$scope:{ctx:x}}}),Se=new W({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Gr]},$$scope:{ctx:x}}}),Bt=new I({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/pipeline_utils.py#L2002"}}),Lt=new I({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/loaders.py#L984"}}),De=new W({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.example",$$slots:{default:[Br]},$$scope:{ctx:x}}}),We=new W({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.example-2",$$slots:{default:[Lr]},$$scope:{ctx:x}}}),Xt=new I({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L806"}}),Et=new I({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L243"}}),Vt=new I({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L783"}}),Rt=new I({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L234"}}),Yt=new I({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L284"}}),zt=new Nn({props:{title:"StableDiffusionControlNetInpaintPipeline",local:"diffusers.StableDiffusionControlNetInpaintPipeline",headingTag:"h2"}}),Ht=new I({props:{name:"class diffusers.StableDiffusionControlNetInpaintPipeline",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": typing.Union[diffusers.models.controlnet.ControlNetModel, typing.List[diffusers.models.controlnet.ControlNetModel], typing.Tuple[diffusers.models.controlnet.ControlNetModel], diffusers.pipelines.controlnet.multicontrolnet.MultiControlNetModel]"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.22.1/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.22.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/v0.22.1/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.22.1/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.22.1/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.22.1/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.22.1/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L239"}}),Xe=new pt({props:{$$slots:{default:[Xr]},$$scope:{ctx:x}}}),Qt=new I({props:{name:"__call__",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 1.0"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 0.5"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, &#x2014;
<code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>):
<code>Image</code>, NumPy array or tensor representing an image batch to be used as the starting point. For both
NumPy array and PyTorch tensor, the expected value range is between <code>[0, 1]</code>. If it&#x2019;s a tensor or a
list or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a NumPy array or
a list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code>. It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, &#x2014;
<code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>):
<code>Image</code>, NumPy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a NumPy array or PyTorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for PyTorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for NumPy array, it would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.FloatTensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be
accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in
<code>init</code>, images must be passed as a list such that each element of the list can be correctly batched for
input to a single ControlNet.`,name:"control_image"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.22.1/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L1001",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),Ee=new W({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.example",$$slots:{default:[Er]},$$scope:{ctx:x}}}),At=new I({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/pipeline_utils.py#L2028"}}),Ve=new pt({props:{warning:!0,$$slots:{default:[Vr]},$$scope:{ctx:x}}}),Re=new W({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_attention_slicing.example",$$slots:{default:[Rr]},$$scope:{ctx:x}}}),qt=new I({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/pipeline_utils.py#L2068"}}),Ot=new I({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L343"}}),Kt=new I({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L351"}}),en=new I({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/pipeline_utils.py#L1967"}}),Qe=new pt({props:{warning:!0,$$slots:{default:[Yr]},$$scope:{ctx:x}}}),Ae=new W({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[zr]},$$scope:{ctx:x}}}),tn=new I({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/pipeline_utils.py#L2002"}}),nn=new I({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/loaders.py#L984"}}),Oe=new W({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.example",$$slots:{default:[Hr]},$$scope:{ctx:x}}}),Ke=new W({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.example-2",$$slots:{default:[Qr]},$$scope:{ctx:x}}}),on=new I({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L997"}}),sn=new I({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L368"}}),an=new I({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L974"}}),ln=new I({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L359"}}),rn=new I({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L409"}}),cn=new Nn({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),dn=new I({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),pn=new Nn({props:{title:"FlaxStableDiffusionControlNetPipeline",local:"diffusers.FlaxStableDiffusionControlNetPipeline",headingTag:"h2"}}),fn=new I({props:{name:"class diffusers.FlaxStableDiffusionControlNetPipeline",anchor:"diffusers.FlaxStableDiffusionControlNetPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"controlnet",val:": FlaxControlNetModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_flax.FlaxDDIMScheduler, diffusers.schedulers.scheduling_pndm_flax.FlaxPNDMScheduler, diffusers.schedulers.scheduling_lms_discrete_flax.FlaxLMSDiscreteScheduler, diffusers.schedulers.scheduling_dpmsolver_multistep_flax.FlaxDPMSolverMultistepScheduler]"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPFeatureExtractor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.22.1/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.FlaxCLIPTextModel" rel="nofollow">FlaxCLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.22.1/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/v0.22.1/en/api/models/controlnet#diffusers.FlaxControlNetModel">FlaxControlNetModel</a> &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process.`,name:"controlnet"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.22.1/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_flax_controlnet.py#L111"}}),mn=new I({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__",parameters:[{name:"prompt_ids",val:": Array"},{name:"image",val:": Array"},{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"prng_seed",val:": Array"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": typing.Union[float, jax.Array] = 7.5"},{name:"latents",val:": Array = None"},{name:"neg_prompt_ids",val:": Array = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, jax.Array] = 1.0"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.prompt_ids",description:`<strong>prompt_ids</strong> (<code>jnp.ndarray</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt_ids"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>jnp.ndarray</code>) &#x2014;
Array representing the ControlNet input condition to provide guidance to the <code>unet</code> for generation.`,name:"image"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.params",description:`<strong>params</strong> (<code>Dict</code> or <code>FrozenDict</code>) &#x2014;
Dictionary containing the model parameters/weights.`,name:"params"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.prng_seed",description:`<strong>prng_seed</strong> (<code>jax.Array</code>) &#x2014;
Array containing random number generator key.`,name:"prng_seed"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>jnp.ndarray</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
array is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>jnp.ndarray</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/controlnet/pipeline_flax_controlnet.py#L348",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),st=new W({props:{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.example",$$slots:{default:[Ar]},$$scope:{ctx:x}}}),un=new Nn({props:{title:"FlaxStableDiffusionControlNetPipelineOutput",local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",headingTag:"h2"}}),gn=new I({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": typing.List[bool]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L32"}}),hn=new I({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/flax/struct.py#L111"}}),{c(){o=i("meta"),v=s(),c=i("p"),r=s(),m(y.$$.fragment),t=s(),M=i("p"),M.innerHTML=tl,qo=s(),ft=i("p"),ft.textContent=nl,Oo=s(),mt=i("p"),mt.textContent=ol,Ko=s(),ut=i("p"),ut.innerHTML=sl,es=s(),gt=i("p"),gt.innerHTML=al,ts=s(),ht=i("p"),ht.innerHTML=il,ns=s(),m(pe.$$.fragment),os=s(),m(bt.$$.fragment),ss=s(),$=i("div"),m(_t.$$.fragment),Ns=s(),Un=i("p"),Un.textContent=ll,Us=s(),kn=i("p"),kn.innerHTML=rl,ks=s(),Zn=i("p"),Zn.textContent=cl,Zs=s(),Sn=i("ul"),Sn.innerHTML=dl,Ss=s(),se=i("div"),m(yt.$$.fragment),Ps=s(),Pn=i("p"),Pn.textContent=pl,Ds=s(),m(fe.$$.fragment),Ws=s(),X=i("div"),m(vt.$$.fragment),Fs=s(),Dn=i("p"),Dn.textContent=fl,Gs=s(),m(me.$$.fragment),Bs=s(),m(ue.$$.fragment),Ls=s(),ge=i("div"),m(wt.$$.fragment),Xs=s(),Wn=i("p"),Wn.innerHTML=ml,Es=s(),he=i("div"),m(Mt.$$.fragment),Vs=s(),Fn=i("p"),Fn.textContent=ul,Rs=s(),be=i("div"),m(xt.$$.fragment),Ys=s(),Gn=i("p"),Gn.innerHTML=gl,zs=s(),E=i("div"),m(Tt.$$.fragment),Hs=s(),Bn=i("p"),Bn.innerHTML=hl,Qs=s(),m(_e.$$.fragment),As=s(),m(ye.$$.fragment),qs=s(),ve=i("div"),m(Ct.$$.fragment),Os=s(),Ln=i("p"),Ln.innerHTML=bl,Ks=s(),S=i("div"),m(It.$$.fragment),ea=s(),Xn=i("p"),Xn.innerHTML=_l,ta=s(),En=i("p"),En.textContent=yl,na=s(),m(we.$$.fragment),oa=s(),Vn=i("p"),Vn.innerHTML=vl,sa=s(),m(Me.$$.fragment),aa=s(),xe=i("div"),m(Jt.$$.fragment),ia=s(),Rn=i("p"),Rn.textContent=wl,la=s(),Te=i("div"),m($t.$$.fragment),ra=s(),Yn=i("p"),Yn.innerHTML=Ml,ca=s(),V=i("div"),m(jt.$$.fragment),da=s(),zn=i("p"),zn.innerHTML=xl,pa=s(),Hn=i("p"),Hn.textContent=Tl,fa=s(),Qn=i("p"),Qn.innerHTML=Cl,ma=s(),Ce=i("div"),m(Nt.$$.fragment),ua=s(),An=i("p"),An.textContent=Il,ga=s(),Ie=i("div"),m(Ut.$$.fragment),ha=s(),qn=i("p"),qn.textContent=Jl,as=s(),m(kt.$$.fragment),is=s(),j=i("div"),m(Zt.$$.fragment),ba=s(),On=i("p"),On.textContent=$l,_a=s(),Kn=i("p"),Kn.innerHTML=jl,ya=s(),eo=i("p"),eo.textContent=Nl,va=s(),to=i("ul"),to.innerHTML=Ul,wa=s(),ae=i("div"),m(St.$$.fragment),Ma=s(),no=i("p"),no.textContent=kl,xa=s(),m(Je.$$.fragment),Ta=s(),R=i("div"),m(Pt.$$.fragment),Ca=s(),oo=i("p"),oo.textContent=Zl,Ia=s(),m($e.$$.fragment),Ja=s(),m(je.$$.fragment),$a=s(),Ne=i("div"),m(Dt.$$.fragment),ja=s(),so=i("p"),so.innerHTML=Sl,Na=s(),Ue=i("div"),m(Wt.$$.fragment),Ua=s(),ao=i("p"),ao.textContent=Pl,ka=s(),ke=i("div"),m(Ft.$$.fragment),Za=s(),io=i("p"),io.innerHTML=Dl,Sa=s(),Y=i("div"),m(Gt.$$.fragment),Pa=s(),lo=i("p"),lo.innerHTML=Wl,Da=s(),m(Ze.$$.fragment),Wa=s(),m(Se.$$.fragment),Fa=s(),Pe=i("div"),m(Bt.$$.fragment),Ga=s(),ro=i("p"),ro.innerHTML=Fl,Ba=s(),P=i("div"),m(Lt.$$.fragment),La=s(),co=i("p"),co.innerHTML=Gl,Xa=s(),po=i("p"),po.textContent=Bl,Ea=s(),m(De.$$.fragment),Va=s(),fo=i("p"),fo.innerHTML=Ll,Ra=s(),m(We.$$.fragment),Ya=s(),Fe=i("div"),m(Xt.$$.fragment),za=s(),mo=i("p"),mo.textContent=Xl,Ha=s(),Ge=i("div"),m(Et.$$.fragment),Qa=s(),uo=i("p"),uo.innerHTML=El,Aa=s(),z=i("div"),m(Vt.$$.fragment),qa=s(),go=i("p"),go.innerHTML=Vl,Oa=s(),ho=i("p"),ho.textContent=Rl,Ka=s(),bo=i("p"),bo.innerHTML=Yl,ei=s(),Be=i("div"),m(Rt.$$.fragment),ti=s(),_o=i("p"),_o.textContent=zl,ni=s(),Le=i("div"),m(Yt.$$.fragment),oi=s(),yo=i("p"),yo.textContent=Hl,ls=s(),m(zt.$$.fragment),rs=s(),J=i("div"),m(Ht.$$.fragment),si=s(),vo=i("p"),vo.textContent=Ql,ai=s(),wo=i("p"),wo.innerHTML=Al,ii=s(),Mo=i("p"),Mo.textContent=ql,li=s(),xo=i("ul"),xo.innerHTML=Ol,ri=s(),m(Xe.$$.fragment),ci=s(),ie=i("div"),m(Qt.$$.fragment),di=s(),To=i("p"),To.textContent=Kl,pi=s(),m(Ee.$$.fragment),fi=s(),H=i("div"),m(At.$$.fragment),mi=s(),Co=i("p"),Co.textContent=er,ui=s(),m(Ve.$$.fragment),gi=s(),m(Re.$$.fragment),hi=s(),Ye=i("div"),m(qt.$$.fragment),bi=s(),Io=i("p"),Io.innerHTML=tr,_i=s(),ze=i("div"),m(Ot.$$.fragment),yi=s(),Jo=i("p"),Jo.textContent=nr,vi=s(),He=i("div"),m(Kt.$$.fragment),wi=s(),$o=i("p"),$o.innerHTML=or,Mi=s(),Q=i("div"),m(en.$$.fragment),xi=s(),jo=i("p"),jo.innerHTML=sr,Ti=s(),m(Qe.$$.fragment),Ci=s(),m(Ae.$$.fragment),Ii=s(),qe=i("div"),m(tn.$$.fragment),Ji=s(),No=i("p"),No.innerHTML=ar,$i=s(),D=i("div"),m(nn.$$.fragment),ji=s(),Uo=i("p"),Uo.innerHTML=ir,Ni=s(),ko=i("p"),ko.textContent=lr,Ui=s(),m(Oe.$$.fragment),ki=s(),Zo=i("p"),Zo.innerHTML=rr,Zi=s(),m(Ke.$$.fragment),Si=s(),et=i("div"),m(on.$$.fragment),Pi=s(),So=i("p"),So.textContent=cr,Di=s(),tt=i("div"),m(sn.$$.fragment),Wi=s(),Po=i("p"),Po.innerHTML=dr,Fi=s(),A=i("div"),m(an.$$.fragment),Gi=s(),Do=i("p"),Do.innerHTML=pr,Bi=s(),Wo=i("p"),Wo.textContent=fr,Li=s(),Fo=i("p"),Fo.innerHTML=mr,Xi=s(),nt=i("div"),m(ln.$$.fragment),Ei=s(),Go=i("p"),Go.textContent=ur,Vi=s(),ot=i("div"),m(rn.$$.fragment),Ri=s(),Bo=i("p"),Bo.textContent=gr,cs=s(),m(cn.$$.fragment),ds=s(),re=i("div"),m(dn.$$.fragment),Yi=s(),Lo=i("p"),Lo.textContent=hr,ps=s(),m(pn.$$.fragment),fs=s(),L=i("div"),m(fn.$$.fragment),zi=s(),Xo=i("p"),Xo.textContent=br,Hi=s(),Eo=i("p"),Eo.innerHTML=_r,Qi=s(),le=i("div"),m(mn.$$.fragment),Ai=s(),Vo=i("p"),Vo.textContent=yr,qi=s(),m(st.$$.fragment),ms=s(),m(un.$$.fragment),us=s(),O=i("div"),m(gn.$$.fragment),Oi=s(),Ro=i("p"),Ro.textContent=vr,Ki=s(),at=i("div"),m(hn.$$.fragment),el=s(),Yo=i("p"),Yo.textContent=wr,gs=s(),Ao=i("p"),this.h()},l(e){const f=Ir("svelte-u9bgzb",document.head);o=l(f,"META",{name:!0,content:!0}),f.forEach(d),v=a(e),c=l(e,"P",{}),T(c).forEach(d),r=a(e),u(y.$$.fragment,e),t=a(e),M=l(e,"P",{"data-svelte-h":!0}),p(M)!=="svelte-1rrmugw"&&(M.innerHTML=tl),qo=a(e),ft=l(e,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-1dn0wji"&&(ft.textContent=nl),Oo=a(e),mt=l(e,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-1cwsb16"&&(mt.textContent=ol),Ko=a(e),ut=l(e,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-3xtcbl"&&(ut.innerHTML=sl),es=a(e),gt=l(e,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-lv721a"&&(gt.innerHTML=al),ts=a(e),ht=l(e,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-6h8iw0"&&(ht.innerHTML=il),ns=a(e),u(pe.$$.fragment,e),os=a(e),u(bt.$$.fragment,e),ss=a(e),$=l(e,"DIV",{class:!0});var N=T($);u(_t.$$.fragment,N),Ns=a(N),Un=l(N,"P",{"data-svelte-h":!0}),p(Un)!=="svelte-1or48uk"&&(Un.textContent=ll),Us=a(N),kn=l(N,"P",{"data-svelte-h":!0}),p(kn)!=="svelte-cys7ny"&&(kn.innerHTML=rl),ks=a(N),Zn=l(N,"P",{"data-svelte-h":!0}),p(Zn)!=="svelte-14s6m4u"&&(Zn.textContent=cl),Zs=a(N),Sn=l(N,"UL",{"data-svelte-h":!0}),p(Sn)!=="svelte-19ikyuo"&&(Sn.innerHTML=dl),Ss=a(N),se=l(N,"DIV",{class:!0});var ce=T(se);u(yt.$$.fragment,ce),Ps=a(ce),Pn=l(ce,"P",{"data-svelte-h":!0}),p(Pn)!=="svelte-50j04k"&&(Pn.textContent=pl),Ds=a(ce),u(fe.$$.fragment,ce),ce.forEach(d),Ws=a(N),X=l(N,"DIV",{class:!0});var K=T(X);u(vt.$$.fragment,K),Fs=a(K),Dn=l(K,"P",{"data-svelte-h":!0}),p(Dn)!=="svelte-10jaql7"&&(Dn.textContent=fl),Gs=a(K),u(me.$$.fragment,K),Bs=a(K),u(ue.$$.fragment,K),K.forEach(d),Ls=a(N),ge=l(N,"DIV",{class:!0});var bn=T(ge);u(wt.$$.fragment,bn),Xs=a(bn),Wn=l(bn,"P",{"data-svelte-h":!0}),p(Wn)!=="svelte-1lh0nh5"&&(Wn.innerHTML=ml),bn.forEach(d),Es=a(N),he=l(N,"DIV",{class:!0});var _n=T(he);u(Mt.$$.fragment,_n),Vs=a(_n),Fn=l(_n,"P",{"data-svelte-h":!0}),p(Fn)!=="svelte-14bnrb6"&&(Fn.textContent=ul),_n.forEach(d),Rs=a(N),be=l(N,"DIV",{class:!0});var yn=T(be);u(xt.$$.fragment,yn),Ys=a(yn),Gn=l(yn,"P",{"data-svelte-h":!0}),p(Gn)!=="svelte-1s3c06i"&&(Gn.innerHTML=gl),yn.forEach(d),zs=a(N),E=l(N,"DIV",{class:!0});var ee=T(E);u(Tt.$$.fragment,ee),Hs=a(ee),Bn=l(ee,"P",{"data-svelte-h":!0}),p(Bn)!=="svelte-e03q3e"&&(Bn.innerHTML=hl),Qs=a(ee),u(_e.$$.fragment,ee),As=a(ee),u(ye.$$.fragment,ee),ee.forEach(d),qs=a(N),ve=l(N,"DIV",{class:!0});var vn=T(ve);u(Ct.$$.fragment,vn),Os=a(vn),Ln=l(vn,"P",{"data-svelte-h":!0}),p(Ln)!=="svelte-1vfte1e"&&(Ln.innerHTML=bl),vn.forEach(d),Ks=a(N),S=l(N,"DIV",{class:!0});var G=T(S);u(It.$$.fragment,G),ea=a(G),Xn=l(G,"P",{"data-svelte-h":!0}),p(Xn)!=="svelte-1ne21mi"&&(Xn.innerHTML=_l),ta=a(G),En=l(G,"P",{"data-svelte-h":!0}),p(En)!=="svelte-11lpom8"&&(En.textContent=yl),na=a(G),u(we.$$.fragment,G),oa=a(G),Vn=l(G,"P",{"data-svelte-h":!0}),p(Vn)!=="svelte-2gddoh"&&(Vn.innerHTML=vl),sa=a(G),u(Me.$$.fragment,G),G.forEach(d),aa=a(N),xe=l(N,"DIV",{class:!0});var wn=T(xe);u(Jt.$$.fragment,wn),ia=a(wn),Rn=l(wn,"P",{"data-svelte-h":!0}),p(Rn)!=="svelte-psupw6"&&(Rn.textContent=wl),wn.forEach(d),la=a(N),Te=l(N,"DIV",{class:!0});var Mn=T(Te);u($t.$$.fragment,Mn),ra=a(Mn),Yn=l(Mn,"P",{"data-svelte-h":!0}),p(Yn)!=="svelte-pkn4ui"&&(Yn.innerHTML=Ml),Mn.forEach(d),ca=a(N),V=l(N,"DIV",{class:!0});var te=T(V);u(jt.$$.fragment,te),da=a(te),zn=l(te,"P",{"data-svelte-h":!0}),p(zn)!=="svelte-1f3tmq1"&&(zn.innerHTML=xl),pa=a(te),Hn=l(te,"P",{"data-svelte-h":!0}),p(Hn)!=="svelte-xjijlp"&&(Hn.textContent=Tl),fa=a(te),Qn=l(te,"P",{"data-svelte-h":!0}),p(Qn)!=="svelte-hy0nzs"&&(Qn.innerHTML=Cl),te.forEach(d),ma=a(N),Ce=l(N,"DIV",{class:!0});var xn=T(Ce);u(Nt.$$.fragment,xn),ua=a(xn),An=l(xn,"P",{"data-svelte-h":!0}),p(An)!=="svelte-1xwrf7t"&&(An.textContent=Il),xn.forEach(d),ga=a(N),Ie=l(N,"DIV",{class:!0});var Tn=T(Ie);u(Ut.$$.fragment,Tn),ha=a(Tn),qn=l(Tn,"P",{"data-svelte-h":!0}),p(qn)!=="svelte-16q0ax1"&&(qn.textContent=Jl),Tn.forEach(d),N.forEach(d),as=a(e),u(kt.$$.fragment,e),is=a(e),j=l(e,"DIV",{class:!0});var U=T(j);u(Zt.$$.fragment,U),ba=a(U),On=l(U,"P",{"data-svelte-h":!0}),p(On)!=="svelte-pzsf3g"&&(On.textContent=$l),_a=a(U),Kn=l(U,"P",{"data-svelte-h":!0}),p(Kn)!=="svelte-cys7ny"&&(Kn.innerHTML=jl),ya=a(U),eo=l(U,"P",{"data-svelte-h":!0}),p(eo)!=="svelte-14s6m4u"&&(eo.textContent=Nl),va=a(U),to=l(U,"UL",{"data-svelte-h":!0}),p(to)!=="svelte-19ikyuo"&&(to.innerHTML=Ul),wa=a(U),ae=l(U,"DIV",{class:!0});var de=T(ae);u(St.$$.fragment,de),Ma=a(de),no=l(de,"P",{"data-svelte-h":!0}),p(no)!=="svelte-50j04k"&&(no.textContent=kl),xa=a(de),u(Je.$$.fragment,de),de.forEach(d),Ta=a(U),R=l(U,"DIV",{class:!0});var ne=T(R);u(Pt.$$.fragment,ne),Ca=a(ne),oo=l(ne,"P",{"data-svelte-h":!0}),p(oo)!=="svelte-10jaql7"&&(oo.textContent=Zl),Ia=a(ne),u($e.$$.fragment,ne),Ja=a(ne),u(je.$$.fragment,ne),ne.forEach(d),$a=a(U),Ne=l(U,"DIV",{class:!0});var Cn=T(Ne);u(Dt.$$.fragment,Cn),ja=a(Cn),so=l(Cn,"P",{"data-svelte-h":!0}),p(so)!=="svelte-1lh0nh5"&&(so.innerHTML=Sl),Cn.forEach(d),Na=a(U),Ue=l(U,"DIV",{class:!0});var In=T(Ue);u(Wt.$$.fragment,In),Ua=a(In),ao=l(In,"P",{"data-svelte-h":!0}),p(ao)!=="svelte-14bnrb6"&&(ao.textContent=Pl),In.forEach(d),ka=a(U),ke=l(U,"DIV",{class:!0});var Jn=T(ke);u(Ft.$$.fragment,Jn),Za=a(Jn),io=l(Jn,"P",{"data-svelte-h":!0}),p(io)!=="svelte-1s3c06i"&&(io.innerHTML=Dl),Jn.forEach(d),Sa=a(U),Y=l(U,"DIV",{class:!0});var oe=T(Y);u(Gt.$$.fragment,oe),Pa=a(oe),lo=l(oe,"P",{"data-svelte-h":!0}),p(lo)!=="svelte-e03q3e"&&(lo.innerHTML=Wl),Da=a(oe),u(Ze.$$.fragment,oe),Wa=a(oe),u(Se.$$.fragment,oe),oe.forEach(d),Fa=a(U),Pe=l(U,"DIV",{class:!0});var $n=T(Pe);u(Bt.$$.fragment,$n),Ga=a($n),ro=l($n,"P",{"data-svelte-h":!0}),p(ro)!=="svelte-1vfte1e"&&(ro.innerHTML=Fl),$n.forEach(d),Ba=a(U),P=l(U,"DIV",{class:!0});var B=T(P);u(Lt.$$.fragment,B),La=a(B),co=l(B,"P",{"data-svelte-h":!0}),p(co)!=="svelte-1ne21mi"&&(co.innerHTML=Gl),Xa=a(B),po=l(B,"P",{"data-svelte-h":!0}),p(po)!=="svelte-11lpom8"&&(po.textContent=Bl),Ea=a(B),u(De.$$.fragment,B),Va=a(B),fo=l(B,"P",{"data-svelte-h":!0}),p(fo)!=="svelte-2gddoh"&&(fo.innerHTML=Ll),Ra=a(B),u(We.$$.fragment,B),B.forEach(d),Ya=a(U),Fe=l(U,"DIV",{class:!0});var jn=T(Fe);u(Xt.$$.fragment,jn),za=a(jn),mo=l(jn,"P",{"data-svelte-h":!0}),p(mo)!=="svelte-psupw6"&&(mo.textContent=Xl),jn.forEach(d),Ha=a(U),Ge=l(U,"DIV",{class:!0});var bs=T(Ge);u(Et.$$.fragment,bs),Qa=a(bs),uo=l(bs,"P",{"data-svelte-h":!0}),p(uo)!=="svelte-pkn4ui"&&(uo.innerHTML=El),bs.forEach(d),Aa=a(U),z=l(U,"DIV",{class:!0});var it=T(z);u(Vt.$$.fragment,it),qa=a(it),go=l(it,"P",{"data-svelte-h":!0}),p(go)!=="svelte-1f3tmq1"&&(go.innerHTML=Vl),Oa=a(it),ho=l(it,"P",{"data-svelte-h":!0}),p(ho)!=="svelte-xjijlp"&&(ho.textContent=Rl),Ka=a(it),bo=l(it,"P",{"data-svelte-h":!0}),p(bo)!=="svelte-hy0nzs"&&(bo.innerHTML=Yl),it.forEach(d),ei=a(U),Be=l(U,"DIV",{class:!0});var _s=T(Be);u(Rt.$$.fragment,_s),ti=a(_s),_o=l(_s,"P",{"data-svelte-h":!0}),p(_o)!=="svelte-1xwrf7t"&&(_o.textContent=zl),_s.forEach(d),ni=a(U),Le=l(U,"DIV",{class:!0});var ys=T(Le);u(Yt.$$.fragment,ys),oi=a(ys),yo=l(ys,"P",{"data-svelte-h":!0}),p(yo)!=="svelte-16q0ax1"&&(yo.textContent=Hl),ys.forEach(d),U.forEach(d),ls=a(e),u(zt.$$.fragment,e),rs=a(e),J=l(e,"DIV",{class:!0});var k=T(J);u(Ht.$$.fragment,k),si=a(k),vo=l(k,"P",{"data-svelte-h":!0}),p(vo)!=="svelte-l9ypsb"&&(vo.textContent=Ql),ai=a(k),wo=l(k,"P",{"data-svelte-h":!0}),p(wo)!=="svelte-cys7ny"&&(wo.innerHTML=Al),ii=a(k),Mo=l(k,"P",{"data-svelte-h":!0}),p(Mo)!=="svelte-14s6m4u"&&(Mo.textContent=ql),li=a(k),xo=l(k,"UL",{"data-svelte-h":!0}),p(xo)!=="svelte-19ikyuo"&&(xo.innerHTML=Ol),ri=a(k),u(Xe.$$.fragment,k),ci=a(k),ie=l(k,"DIV",{class:!0});var zo=T(ie);u(Qt.$$.fragment,zo),di=a(zo),To=l(zo,"P",{"data-svelte-h":!0}),p(To)!=="svelte-50j04k"&&(To.textContent=Kl),pi=a(zo),u(Ee.$$.fragment,zo),zo.forEach(d),fi=a(k),H=l(k,"DIV",{class:!0});var lt=T(H);u(At.$$.fragment,lt),mi=a(lt),Co=l(lt,"P",{"data-svelte-h":!0}),p(Co)!=="svelte-10jaql7"&&(Co.textContent=er),ui=a(lt),u(Ve.$$.fragment,lt),gi=a(lt),u(Re.$$.fragment,lt),lt.forEach(d),hi=a(k),Ye=l(k,"DIV",{class:!0});var vs=T(Ye);u(qt.$$.fragment,vs),bi=a(vs),Io=l(vs,"P",{"data-svelte-h":!0}),p(Io)!=="svelte-1lh0nh5"&&(Io.innerHTML=tr),vs.forEach(d),_i=a(k),ze=l(k,"DIV",{class:!0});var ws=T(ze);u(Ot.$$.fragment,ws),yi=a(ws),Jo=l(ws,"P",{"data-svelte-h":!0}),p(Jo)!=="svelte-14bnrb6"&&(Jo.textContent=nr),ws.forEach(d),vi=a(k),He=l(k,"DIV",{class:!0});var Ms=T(He);u(Kt.$$.fragment,Ms),wi=a(Ms),$o=l(Ms,"P",{"data-svelte-h":!0}),p($o)!=="svelte-1s3c06i"&&($o.innerHTML=or),Ms.forEach(d),Mi=a(k),Q=l(k,"DIV",{class:!0});var rt=T(Q);u(en.$$.fragment,rt),xi=a(rt),jo=l(rt,"P",{"data-svelte-h":!0}),p(jo)!=="svelte-e03q3e"&&(jo.innerHTML=sr),Ti=a(rt),u(Qe.$$.fragment,rt),Ci=a(rt),u(Ae.$$.fragment,rt),rt.forEach(d),Ii=a(k),qe=l(k,"DIV",{class:!0});var xs=T(qe);u(tn.$$.fragment,xs),Ji=a(xs),No=l(xs,"P",{"data-svelte-h":!0}),p(No)!=="svelte-1vfte1e"&&(No.innerHTML=ar),xs.forEach(d),$i=a(k),D=l(k,"DIV",{class:!0});var q=T(D);u(nn.$$.fragment,q),ji=a(q),Uo=l(q,"P",{"data-svelte-h":!0}),p(Uo)!=="svelte-1ne21mi"&&(Uo.innerHTML=ir),Ni=a(q),ko=l(q,"P",{"data-svelte-h":!0}),p(ko)!=="svelte-11lpom8"&&(ko.textContent=lr),Ui=a(q),u(Oe.$$.fragment,q),ki=a(q),Zo=l(q,"P",{"data-svelte-h":!0}),p(Zo)!=="svelte-2gddoh"&&(Zo.innerHTML=rr),Zi=a(q),u(Ke.$$.fragment,q),q.forEach(d),Si=a(k),et=l(k,"DIV",{class:!0});var Ts=T(et);u(on.$$.fragment,Ts),Pi=a(Ts),So=l(Ts,"P",{"data-svelte-h":!0}),p(So)!=="svelte-psupw6"&&(So.textContent=cr),Ts.forEach(d),Di=a(k),tt=l(k,"DIV",{class:!0});var Cs=T(tt);u(sn.$$.fragment,Cs),Wi=a(Cs),Po=l(Cs,"P",{"data-svelte-h":!0}),p(Po)!=="svelte-pkn4ui"&&(Po.innerHTML=dr),Cs.forEach(d),Fi=a(k),A=l(k,"DIV",{class:!0});var ct=T(A);u(an.$$.fragment,ct),Gi=a(ct),Do=l(ct,"P",{"data-svelte-h":!0}),p(Do)!=="svelte-1f3tmq1"&&(Do.innerHTML=pr),Bi=a(ct),Wo=l(ct,"P",{"data-svelte-h":!0}),p(Wo)!=="svelte-xjijlp"&&(Wo.textContent=fr),Li=a(ct),Fo=l(ct,"P",{"data-svelte-h":!0}),p(Fo)!=="svelte-hy0nzs"&&(Fo.innerHTML=mr),ct.forEach(d),Xi=a(k),nt=l(k,"DIV",{class:!0});var Is=T(nt);u(ln.$$.fragment,Is),Ei=a(Is),Go=l(Is,"P",{"data-svelte-h":!0}),p(Go)!=="svelte-1xwrf7t"&&(Go.textContent=ur),Is.forEach(d),Vi=a(k),ot=l(k,"DIV",{class:!0});var Js=T(ot);u(rn.$$.fragment,Js),Ri=a(Js),Bo=l(Js,"P",{"data-svelte-h":!0}),p(Bo)!=="svelte-16q0ax1"&&(Bo.textContent=gr),Js.forEach(d),k.forEach(d),cs=a(e),u(cn.$$.fragment,e),ds=a(e),re=l(e,"DIV",{class:!0});var $s=T(re);u(dn.$$.fragment,$s),Yi=a($s),Lo=l($s,"P",{"data-svelte-h":!0}),p(Lo)!=="svelte-1qpjiuf"&&(Lo.textContent=hr),$s.forEach(d),ps=a(e),u(pn.$$.fragment,e),fs=a(e),L=l(e,"DIV",{class:!0});var dt=T(L);u(fn.$$.fragment,dt),zi=a(dt),Xo=l(dt,"P",{"data-svelte-h":!0}),p(Xo)!=="svelte-11a4l7z"&&(Xo.textContent=br),Hi=a(dt),Eo=l(dt,"P",{"data-svelte-h":!0}),p(Eo)!=="svelte-1d46v7i"&&(Eo.innerHTML=_r),Qi=a(dt),le=l(dt,"DIV",{class:!0});var Ho=T(le);u(mn.$$.fragment,Ho),Ai=a(Ho),Vo=l(Ho,"P",{"data-svelte-h":!0}),p(Vo)!=="svelte-50j04k"&&(Vo.textContent=yr),qi=a(Ho),u(st.$$.fragment,Ho),Ho.forEach(d),dt.forEach(d),ms=a(e),u(un.$$.fragment,e),us=a(e),O=l(e,"DIV",{class:!0});var Qo=T(O);u(gn.$$.fragment,Qo),Oi=a(Qo),Ro=l(Qo,"P",{"data-svelte-h":!0}),p(Ro)!=="svelte-wzv2jc"&&(Ro.textContent=vr),Ki=a(Qo),at=l(Qo,"DIV",{class:!0});var js=T(at);u(hn.$$.fragment,js),el=a(js),Yo=l(js,"P",{"data-svelte-h":!0}),p(Yo)!=="svelte-5ihtpa"&&(Yo.textContent=wr),js.forEach(d),Qo.forEach(d),gs=a(e),Ao=l(e,"P",{}),T(Ao).forEach(d),this.h()},h(){C(o,"name","hf:doc:metadata"),C(o,"content",Or),C(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){n(document.head,o),w(e,v,f),w(e,c,f),w(e,r,f),g(y,e,f),w(e,t,f),w(e,M,f),w(e,qo,f),w(e,ft,f),w(e,Oo,f),w(e,mt,f),w(e,Ko,f),w(e,ut,f),w(e,es,f),w(e,gt,f),w(e,ts,f),w(e,ht,f),w(e,ns,f),g(pe,e,f),w(e,os,f),g(bt,e,f),w(e,ss,f),w(e,$,f),g(_t,$,null),n($,Ns),n($,Un),n($,Us),n($,kn),n($,ks),n($,Zn),n($,Zs),n($,Sn),n($,Ss),n($,se),g(yt,se,null),n(se,Ps),n(se,Pn),n(se,Ds),g(fe,se,null),n($,Ws),n($,X),g(vt,X,null),n(X,Fs),n(X,Dn),n(X,Gs),g(me,X,null),n(X,Bs),g(ue,X,null),n($,Ls),n($,ge),g(wt,ge,null),n(ge,Xs),n(ge,Wn),n($,Es),n($,he),g(Mt,he,null),n(he,Vs),n(he,Fn),n($,Rs),n($,be),g(xt,be,null),n(be,Ys),n(be,Gn),n($,zs),n($,E),g(Tt,E,null),n(E,Hs),n(E,Bn),n(E,Qs),g(_e,E,null),n(E,As),g(ye,E,null),n($,qs),n($,ve),g(Ct,ve,null),n(ve,Os),n(ve,Ln),n($,Ks),n($,S),g(It,S,null),n(S,ea),n(S,Xn),n(S,ta),n(S,En),n(S,na),g(we,S,null),n(S,oa),n(S,Vn),n(S,sa),g(Me,S,null),n($,aa),n($,xe),g(Jt,xe,null),n(xe,ia),n(xe,Rn),n($,la),n($,Te),g($t,Te,null),n(Te,ra),n(Te,Yn),n($,ca),n($,V),g(jt,V,null),n(V,da),n(V,zn),n(V,pa),n(V,Hn),n(V,fa),n(V,Qn),n($,ma),n($,Ce),g(Nt,Ce,null),n(Ce,ua),n(Ce,An),n($,ga),n($,Ie),g(Ut,Ie,null),n(Ie,ha),n(Ie,qn),w(e,as,f),g(kt,e,f),w(e,is,f),w(e,j,f),g(Zt,j,null),n(j,ba),n(j,On),n(j,_a),n(j,Kn),n(j,ya),n(j,eo),n(j,va),n(j,to),n(j,wa),n(j,ae),g(St,ae,null),n(ae,Ma),n(ae,no),n(ae,xa),g(Je,ae,null),n(j,Ta),n(j,R),g(Pt,R,null),n(R,Ca),n(R,oo),n(R,Ia),g($e,R,null),n(R,Ja),g(je,R,null),n(j,$a),n(j,Ne),g(Dt,Ne,null),n(Ne,ja),n(Ne,so),n(j,Na),n(j,Ue),g(Wt,Ue,null),n(Ue,Ua),n(Ue,ao),n(j,ka),n(j,ke),g(Ft,ke,null),n(ke,Za),n(ke,io),n(j,Sa),n(j,Y),g(Gt,Y,null),n(Y,Pa),n(Y,lo),n(Y,Da),g(Ze,Y,null),n(Y,Wa),g(Se,Y,null),n(j,Fa),n(j,Pe),g(Bt,Pe,null),n(Pe,Ga),n(Pe,ro),n(j,Ba),n(j,P),g(Lt,P,null),n(P,La),n(P,co),n(P,Xa),n(P,po),n(P,Ea),g(De,P,null),n(P,Va),n(P,fo),n(P,Ra),g(We,P,null),n(j,Ya),n(j,Fe),g(Xt,Fe,null),n(Fe,za),n(Fe,mo),n(j,Ha),n(j,Ge),g(Et,Ge,null),n(Ge,Qa),n(Ge,uo),n(j,Aa),n(j,z),g(Vt,z,null),n(z,qa),n(z,go),n(z,Oa),n(z,ho),n(z,Ka),n(z,bo),n(j,ei),n(j,Be),g(Rt,Be,null),n(Be,ti),n(Be,_o),n(j,ni),n(j,Le),g(Yt,Le,null),n(Le,oi),n(Le,yo),w(e,ls,f),g(zt,e,f),w(e,rs,f),w(e,J,f),g(Ht,J,null),n(J,si),n(J,vo),n(J,ai),n(J,wo),n(J,ii),n(J,Mo),n(J,li),n(J,xo),n(J,ri),g(Xe,J,null),n(J,ci),n(J,ie),g(Qt,ie,null),n(ie,di),n(ie,To),n(ie,pi),g(Ee,ie,null),n(J,fi),n(J,H),g(At,H,null),n(H,mi),n(H,Co),n(H,ui),g(Ve,H,null),n(H,gi),g(Re,H,null),n(J,hi),n(J,Ye),g(qt,Ye,null),n(Ye,bi),n(Ye,Io),n(J,_i),n(J,ze),g(Ot,ze,null),n(ze,yi),n(ze,Jo),n(J,vi),n(J,He),g(Kt,He,null),n(He,wi),n(He,$o),n(J,Mi),n(J,Q),g(en,Q,null),n(Q,xi),n(Q,jo),n(Q,Ti),g(Qe,Q,null),n(Q,Ci),g(Ae,Q,null),n(J,Ii),n(J,qe),g(tn,qe,null),n(qe,Ji),n(qe,No),n(J,$i),n(J,D),g(nn,D,null),n(D,ji),n(D,Uo),n(D,Ni),n(D,ko),n(D,Ui),g(Oe,D,null),n(D,ki),n(D,Zo),n(D,Zi),g(Ke,D,null),n(J,Si),n(J,et),g(on,et,null),n(et,Pi),n(et,So),n(J,Di),n(J,tt),g(sn,tt,null),n(tt,Wi),n(tt,Po),n(J,Fi),n(J,A),g(an,A,null),n(A,Gi),n(A,Do),n(A,Bi),n(A,Wo),n(A,Li),n(A,Fo),n(J,Xi),n(J,nt),g(ln,nt,null),n(nt,Ei),n(nt,Go),n(J,Vi),n(J,ot),g(rn,ot,null),n(ot,Ri),n(ot,Bo),w(e,cs,f),g(cn,e,f),w(e,ds,f),w(e,re,f),g(dn,re,null),n(re,Yi),n(re,Lo),w(e,ps,f),g(pn,e,f),w(e,fs,f),w(e,L,f),g(fn,L,null),n(L,zi),n(L,Xo),n(L,Hi),n(L,Eo),n(L,Qi),n(L,le),g(mn,le,null),n(le,Ai),n(le,Vo),n(le,qi),g(st,le,null),w(e,ms,f),g(un,e,f),w(e,us,f),w(e,O,f),g(gn,O,null),n(O,Oi),n(O,Ro),n(O,Ki),n(O,at),g(hn,at,null),n(at,el),n(at,Yo),w(e,gs,f),w(e,Ao,f),hs=!0},p(e,[f]){const N={};f&2&&(N.$$scope={dirty:f,ctx:e}),pe.$set(N);const ce={};f&2&&(ce.$$scope={dirty:f,ctx:e}),fe.$set(ce);const K={};f&2&&(K.$$scope={dirty:f,ctx:e}),me.$set(K);const bn={};f&2&&(bn.$$scope={dirty:f,ctx:e}),ue.$set(bn);const _n={};f&2&&(_n.$$scope={dirty:f,ctx:e}),_e.$set(_n);const yn={};f&2&&(yn.$$scope={dirty:f,ctx:e}),ye.$set(yn);const ee={};f&2&&(ee.$$scope={dirty:f,ctx:e}),we.$set(ee);const vn={};f&2&&(vn.$$scope={dirty:f,ctx:e}),Me.$set(vn);const G={};f&2&&(G.$$scope={dirty:f,ctx:e}),Je.$set(G);const wn={};f&2&&(wn.$$scope={dirty:f,ctx:e}),$e.$set(wn);const Mn={};f&2&&(Mn.$$scope={dirty:f,ctx:e}),je.$set(Mn);const te={};f&2&&(te.$$scope={dirty:f,ctx:e}),Ze.$set(te);const xn={};f&2&&(xn.$$scope={dirty:f,ctx:e}),Se.$set(xn);const Tn={};f&2&&(Tn.$$scope={dirty:f,ctx:e}),De.$set(Tn);const U={};f&2&&(U.$$scope={dirty:f,ctx:e}),We.$set(U);const de={};f&2&&(de.$$scope={dirty:f,ctx:e}),Xe.$set(de);const ne={};f&2&&(ne.$$scope={dirty:f,ctx:e}),Ee.$set(ne);const Cn={};f&2&&(Cn.$$scope={dirty:f,ctx:e}),Ve.$set(Cn);const In={};f&2&&(In.$$scope={dirty:f,ctx:e}),Re.$set(In);const Jn={};f&2&&(Jn.$$scope={dirty:f,ctx:e}),Qe.$set(Jn);const oe={};f&2&&(oe.$$scope={dirty:f,ctx:e}),Ae.$set(oe);const $n={};f&2&&($n.$$scope={dirty:f,ctx:e}),Oe.$set($n);const B={};f&2&&(B.$$scope={dirty:f,ctx:e}),Ke.$set(B);const jn={};f&2&&(jn.$$scope={dirty:f,ctx:e}),st.$set(jn)},i(e){hs||(h(y.$$.fragment,e),h(pe.$$.fragment,e),h(bt.$$.fragment,e),h(_t.$$.fragment,e),h(yt.$$.fragment,e),h(fe.$$.fragment,e),h(vt.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(wt.$$.fragment,e),h(Mt.$$.fragment,e),h(xt.$$.fragment,e),h(Tt.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),h(Ct.$$.fragment,e),h(It.$$.fragment,e),h(we.$$.fragment,e),h(Me.$$.fragment,e),h(Jt.$$.fragment,e),h($t.$$.fragment,e),h(jt.$$.fragment,e),h(Nt.$$.fragment,e),h(Ut.$$.fragment,e),h(kt.$$.fragment,e),h(Zt.$$.fragment,e),h(St.$$.fragment,e),h(Je.$$.fragment,e),h(Pt.$$.fragment,e),h($e.$$.fragment,e),h(je.$$.fragment,e),h(Dt.$$.fragment,e),h(Wt.$$.fragment,e),h(Ft.$$.fragment,e),h(Gt.$$.fragment,e),h(Ze.$$.fragment,e),h(Se.$$.fragment,e),h(Bt.$$.fragment,e),h(Lt.$$.fragment,e),h(De.$$.fragment,e),h(We.$$.fragment,e),h(Xt.$$.fragment,e),h(Et.$$.fragment,e),h(Vt.$$.fragment,e),h(Rt.$$.fragment,e),h(Yt.$$.fragment,e),h(zt.$$.fragment,e),h(Ht.$$.fragment,e),h(Xe.$$.fragment,e),h(Qt.$$.fragment,e),h(Ee.$$.fragment,e),h(At.$$.fragment,e),h(Ve.$$.fragment,e),h(Re.$$.fragment,e),h(qt.$$.fragment,e),h(Ot.$$.fragment,e),h(Kt.$$.fragment,e),h(en.$$.fragment,e),h(Qe.$$.fragment,e),h(Ae.$$.fragment,e),h(tn.$$.fragment,e),h(nn.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(on.$$.fragment,e),h(sn.$$.fragment,e),h(an.$$.fragment,e),h(ln.$$.fragment,e),h(rn.$$.fragment,e),h(cn.$$.fragment,e),h(dn.$$.fragment,e),h(pn.$$.fragment,e),h(fn.$$.fragment,e),h(mn.$$.fragment,e),h(st.$$.fragment,e),h(un.$$.fragment,e),h(gn.$$.fragment,e),h(hn.$$.fragment,e),hs=!0)},o(e){b(y.$$.fragment,e),b(pe.$$.fragment,e),b(bt.$$.fragment,e),b(_t.$$.fragment,e),b(yt.$$.fragment,e),b(fe.$$.fragment,e),b(vt.$$.fragment,e),b(me.$$.fragment,e),b(ue.$$.fragment,e),b(wt.$$.fragment,e),b(Mt.$$.fragment,e),b(xt.$$.fragment,e),b(Tt.$$.fragment,e),b(_e.$$.fragment,e),b(ye.$$.fragment,e),b(Ct.$$.fragment,e),b(It.$$.fragment,e),b(we.$$.fragment,e),b(Me.$$.fragment,e),b(Jt.$$.fragment,e),b($t.$$.fragment,e),b(jt.$$.fragment,e),b(Nt.$$.fragment,e),b(Ut.$$.fragment,e),b(kt.$$.fragment,e),b(Zt.$$.fragment,e),b(St.$$.fragment,e),b(Je.$$.fragment,e),b(Pt.$$.fragment,e),b($e.$$.fragment,e),b(je.$$.fragment,e),b(Dt.$$.fragment,e),b(Wt.$$.fragment,e),b(Ft.$$.fragment,e),b(Gt.$$.fragment,e),b(Ze.$$.fragment,e),b(Se.$$.fragment,e),b(Bt.$$.fragment,e),b(Lt.$$.fragment,e),b(De.$$.fragment,e),b(We.$$.fragment,e),b(Xt.$$.fragment,e),b(Et.$$.fragment,e),b(Vt.$$.fragment,e),b(Rt.$$.fragment,e),b(Yt.$$.fragment,e),b(zt.$$.fragment,e),b(Ht.$$.fragment,e),b(Xe.$$.fragment,e),b(Qt.$$.fragment,e),b(Ee.$$.fragment,e),b(At.$$.fragment,e),b(Ve.$$.fragment,e),b(Re.$$.fragment,e),b(qt.$$.fragment,e),b(Ot.$$.fragment,e),b(Kt.$$.fragment,e),b(en.$$.fragment,e),b(Qe.$$.fragment,e),b(Ae.$$.fragment,e),b(tn.$$.fragment,e),b(nn.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(on.$$.fragment,e),b(sn.$$.fragment,e),b(an.$$.fragment,e),b(ln.$$.fragment,e),b(rn.$$.fragment,e),b(cn.$$.fragment,e),b(dn.$$.fragment,e),b(pn.$$.fragment,e),b(fn.$$.fragment,e),b(mn.$$.fragment,e),b(st.$$.fragment,e),b(un.$$.fragment,e),b(gn.$$.fragment,e),b(hn.$$.fragment,e),hs=!1},d(e){e&&(d(v),d(c),d(r),d(t),d(M),d(qo),d(ft),d(Oo),d(mt),d(Ko),d(ut),d(es),d(gt),d(ts),d(ht),d(ns),d(os),d(ss),d($),d(as),d(is),d(j),d(ls),d(rs),d(J),d(cs),d(ds),d(re),d(ps),d(fs),d(L),d(ms),d(us),d(O),d(gs),d(Ao)),d(o),_(y,e),_(pe,e),_(bt,e),_(_t),_(yt),_(fe),_(vt),_(me),_(ue),_(wt),_(Mt),_(xt),_(Tt),_(_e),_(ye),_(Ct),_(It),_(we),_(Me),_(Jt),_($t),_(jt),_(Nt),_(Ut),_(kt,e),_(Zt),_(St),_(Je),_(Pt),_($e),_(je),_(Dt),_(Wt),_(Ft),_(Gt),_(Ze),_(Se),_(Bt),_(Lt),_(De),_(We),_(Xt),_(Et),_(Vt),_(Rt),_(Yt),_(zt,e),_(Ht),_(Xe),_(Qt),_(Ee),_(At),_(Ve),_(Re),_(qt),_(Ot),_(Kt),_(en),_(Qe),_(Ae),_(tn),_(nn),_(Oe),_(Ke),_(on),_(sn),_(an),_(ln),_(rn),_(cn,e),_(dn),_(pn,e),_(fn),_(mn),_(st),_(un,e),_(gn),_(hn)}}}const Or='{"title":"ControlNet","local":"controlnet","sections":[{"title":"StableDiffusionControlNetPipeline","local":"diffusers.StableDiffusionControlNetPipeline","sections":[],"depth":2},{"title":"StableDiffusionControlNetImg2ImgPipeline","local":"diffusers.StableDiffusionControlNetImg2ImgPipeline","sections":[],"depth":2},{"title":"StableDiffusionControlNetInpaintPipeline","local":"diffusers.StableDiffusionControlNetInpaintPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2},{"title":"FlaxStableDiffusionControlNetPipeline","local":"diffusers.FlaxStableDiffusionControlNetPipeline","sections":[],"depth":2},{"title":"FlaxStableDiffusionControlNetPipelineOutput","local":"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Kr(x){return xr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lc extends Tr{constructor(o){super(),Cr(this,o,Kr,qr,Mr,{})}}export{lc as component};
