import{s as qt,o as Vt,n as Qt}from"../chunks/scheduler.182ea377.js";import{S as zt,i as Dt,g as s,s as o,r,A as Et,h as a,f as l,c as i,j as Ft,u as d,x as p,k as At,y as Ot,a as n,v as f,d as u,t as c,w as m}from"../chunks/index.abf12888.js";import{T as Kt}from"../chunks/Tip.230e2334.js";import{C as b}from"../chunks/CodeBlock.57fe6e13.js";import{H as M}from"../chunks/Heading.16916d63.js";function el(Me){let h,v='You can also run the <code>diffusers</code> Python codebase on Apple Silicon Macs using the <code>mps</code> accelerator built into PyTorch. This approach is explained in depth in <a href="mps">the mps guide</a>, but it is not compatible with native apps.';return{c(){h=s("p"),h.innerHTML=v},l(y){h=a(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1gipn5x"&&(h.innerHTML=v)},m(y,he){n(y,h,he)},p:Qt,d(y){y&&l(h)}}}function tl(Me){let h,v,y,he,g,we,U,mt='<a href="https://developer.apple.com/documentation/coreml" rel="nofollow">Core ML</a> is the model format and machine learning library supported by Apple frameworks. If you are interested in running Stable Diffusion models inside your macOS or iOS/iPadOS apps, this guide will show you how to convert existing PyTorch checkpoints into the Core ML format and use them for inference with Python or Swift.',be,C,ht="Core ML models can leverage all the compute engines available in Apple devices: the CPU, the GPU, and the Apple Neural Engine (or ANE, a tensor-optimized accelerator available in Apple Silicon Macs and modern iPhones/iPads). Depending on the model and the device it’s running on, Core ML can mix and match compute engines too, so some portions of the model may run on the CPU while others run on GPU, for example.",ve,w,ge,T,Ue,$,yt="Stable Diffusion weights (or checkpoints) are stored in the PyTorch format, so you need to convert them to the Core ML format before we can use them inside native apps.",Ce,J,Mt='Thankfully, Apple engineers developed <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow">a conversion tool</a> based on <code>diffusers</code> to convert the PyTorch checkpoints to Core ML.',Te,j,wt="Before you convert a model, though, take a moment to explore the Hugging Face Hub – chances are the model you’re interested in is already available in Core ML format:",$e,k,bt='<li>the <a href="https://huggingface.co/apple" rel="nofollow">Apple</a> organization includes Stable Diffusion versions 1.4, 1.5, 2.0 base, and 2.1 base</li> <li><a href="https://huggingface.co/coreml" rel="nofollow">coreml</a> organization includes custom DreamBoothed and finetuned models</li> <li>use this <a href="https://huggingface.co/models?pipeline_tag=text-to-image&amp;library=coreml&amp;p=2&amp;sort=likes" rel="nofollow">filter</a> to return all available Core ML checkpoints</li>',Je,L,vt='If you can’t find the model you’re interested in, we recommend you follow the instructions for <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow">Converting Models to Core ML</a> by Apple.',je,_,ke,G,gt="Stable Diffusion models can be converted to different Core ML variants intended for different purposes:",Le,x,Ut='<li><p>The type of attention blocks used. The attention operation is used to “pay attention” to the relationship between different areas in the image representations and to understand how the image and text representations are related. Attention is compute- and memory-intensive, so different implementations exist that consider the hardware characteristics of different devices. For Core ML Stable Diffusion models, there are two attention variants:</p> <ul><li><code>split_einsum</code> (<a href="https://machinelearning.apple.com/research/neural-engine-transformers" rel="nofollow">introduced by Apple</a>) is optimized for ANE devices, which is available in modern iPhones, iPads and M-series computers.</li> <li>The “original” attention (the base implementation used in <code>diffusers</code>) is only compatible with CPU/GPU and not ANE. It can be <em>faster</em> to run your model on CPU + GPU using <code>original</code> attention than ANE. See <a href="https://huggingface.co/blog/fast-mac-diffusers#performance-benchmarks" rel="nofollow">this performance benchmark</a> as well as some <a href="https://github.com/huggingface/swift-coreml-diffusers/issues/31" rel="nofollow">additional measures provided by the community</a> for additional details.</li></ul></li> <li><p>The supported inference framework.</p> <ul><li><code>packages</code> are suitable for Python inference. This can be used to test converted Core ML models before attempting to integrate them inside native apps, or if you want to explore Core ML performance but don’t need to support native apps. For example, an application with a web UI could perfectly use a Python Core ML backend.</li> <li><code>compiled</code> models are required for Swift code. The <code>compiled</code> models in the Hub split the large UNet model weights into several files for compatibility with iOS and iPadOS devices. This corresponds to the <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow"><code>--chunk-unet</code> conversion option</a>. If you want to support native apps, then you need to select the <code>compiled</code> variant.</li></ul></li>',_e,Z,Ct='The official Core ML Stable Diffusion <a href="https://huggingface.co/apple/coreml-stable-diffusion-v1-4/tree/main" rel="nofollow">models</a> include these variants, but the community ones may vary:',Ge,B,xe,X,Tt="You can download and use the variant you need as shown below.",Ze,N,Be,W,$t="Install the following libraries to run Core ML inference in Python:",Xe,S,Ne,I,We,P,Jt="To run inference in Python, use one of the versions stored in the <code>packages</code> folders because the <code>compiled</code> ones are only compatible with Swift. You may choose whether you want to use <code>original</code> or <code>split_einsum</code> attention.",Se,Y,jt="This is how you’d download the <code>original</code> attention variant from the Hub to a directory called <code>models</code>:",Ie,H,Pe,R,Ye,F,kt="Once you have downloaded a snapshot of the model, you can test it using Apple’s Python script.",He,A,Re,q,Lt="<code>&lt;output-mlpackages-directory&gt;</code> should point to the checkpoint you downloaded in the step above, and <code>--compute-unit</code> indicates the hardware you want to allow for inference. It must be one of the following options: <code>ALL</code>, <code>CPU_AND_GPU</code>, <code>CPU_ONLY</code>, <code>CPU_AND_NE</code>. You may also provide an optional output path, and a seed for reproducibility.",Fe,V,_t="The inference script assumes you’re using the original version of the Stable Diffusion model, <code>CompVis/stable-diffusion-v1-4</code>. If you use another model, you <em>have</em> to specify its Hub id in the inference command line, using the <code>--model-version</code> option. This works for models already supported and custom models you trained or fine-tuned yourself.",Ae,Q,Gt='For example, if you want to use <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>:',qe,z,Ve,D,Qe,E,xt="Running inference in Swift is slightly faster than in Python because the models are already compiled in the <code>mlmodelc</code> format. This is noticeable on app startup when the model is loaded but shouldn’t be noticeable if you run several generations afterward.",ze,O,De,K,Zt="To run inference in Swift on your Mac, you need one of the <code>compiled</code> checkpoint versions. We recommend you download them locally using Python code similar to the previous example, but with one of the <code>compiled</code> variants:",Ee,ee,Oe,te,Ke,le,Bt="To run inference, please clone Apple’s repo:",et,ne,tt,oe,Xt='And then use Apple’s command line tool, <a href="https://www.swift.org/package-manager/#" rel="nofollow">Swift Package Manager</a>:',lt,ie,nt,se,Nt="You have to specify in <code>--resource-path</code> one of the checkpoints downloaded in the previous step, so please make sure it contains compiled Core ML bundles with the extension <code>.mlmodelc</code>. The <code>--compute-units</code> has to be one of these values: <code>all</code>, <code>cpuOnly</code>, <code>cpuAndGPU</code>, <code>cpuAndNeuralEngine</code>.",ot,ae,Wt='For more details, please refer to the <a href="https://github.com/apple/ml-stable-diffusion" rel="nofollow">instructions in Apple’s repo</a>.',it,pe,st,re,St="The Core ML models and inference code don’t support many of the features, options, and flexibility of 🧨 Diffusers. These are some of the limitations to keep in mind:",at,de,It="<li>Core ML models are only suitable for inference. They can’t be used for training or fine-tuning.</li> <li>Only two schedulers have been ported to Swift, the default one used by Stable Diffusion and <code>DPMSolverMultistepScheduler</code>, which we ported to Swift from our <code>diffusers</code> implementation. We recommend you use <code>DPMSolverMultistepScheduler</code>, since it produces the same quality in about half the steps.</li> <li>Negative prompts, classifier-free guidance scale, and image-to-image tasks are available in the inference code. Advanced features such as depth guidance, ControlNet, and latent upscalers are not available yet.</li>",pt,fe,Pt='Apple’s <a href="https://github.com/apple/ml-stable-diffusion" rel="nofollow">conversion and inference repo</a> and our own <a href="https://github.com/huggingface/swift-coreml-diffusers" rel="nofollow">swift-coreml-diffusers</a> repos are intended as technology demonstrators to enable other developers to build upon.',rt,ue,Yt="If you feel strongly about any missing features, please feel free to open a feature request or, better yet, a contribution PR :)",dt,ce,ft,me,Ht='One easy way to run Stable Diffusion on your own Apple hardware is to use <a href="https://github.com/huggingface/swift-coreml-diffusers" rel="nofollow">our open-source Swift repo</a>, based on <code>diffusers</code> and Apple’s conversion and inference repo. You can study the code, compile it with <a href="https://developer.apple.com/xcode/" rel="nofollow">Xcode</a> and adapt it for your own needs. For your convenience, there’s also a <a href="https://apps.apple.com/app/diffusers/id1666309574" rel="nofollow">standalone Mac app in the App Store</a>, so you can play with it without having to deal with the code or IDE. If you are a developer and have determined that Core ML is the best solution to build your Stable Diffusion app, then you can use the rest of this guide to get started with your project. We can’t wait to see what you’ll build :)',ut,ye,ct;return g=new M({props:{title:"How to run Stable Diffusion with Core ML",local:"how-to-run-stable-diffusion-with-core-ml",headingTag:"h1"}}),w=new Kt({props:{$$slots:{default:[el]},$$scope:{ctx:Me}}}),T=new M({props:{title:"Stable Diffusion Core ML Checkpoints",local:"stable-diffusion-core-ml-checkpoints",headingTag:"h2"}}),_=new M({props:{title:"Selecting the Core ML Variant to Use",local:"selecting-the-core-ml-variant-to-use",headingTag:"h2"}}),B=new b({props:{code:"Y29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMFJFQURNRS5tZCUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMG9yaWdpbmFsJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29tcGlsZWQlMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBwYWNrYWdlcyUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHNwbGl0X2VpbnN1bSUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNvbXBpbGVkJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcGFja2FnZXM=",highlighted:`coreml-stable-<span class="hljs-keyword">diffusion-v1-4
</span>├── README.md
├── <span class="hljs-keyword">original
</span>│   ├── compiled
│   └── packages
└── split_einsum
    ├── compiled
    └── packages`,wrap:!1}}),N=new M({props:{title:"Core ML Inference in Python",local:"core-ml-inference-in-python",headingTag:"h2"}}),S=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1YiUwQXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZhcHBsZSUyRm1sLXN0YWJsZS1kaWZmdXNpb24=",highlighted:`pip install huggingface_hub
pip install git+https://github.com/apple/ml-stable-diffusion`,wrap:!1}}),I=new M({props:{title:"Download the Model Checkpoints",local:"download-the-model-checkpoints",headingTag:"h3"}}),H=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmFwcGxlJTJGY29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXZhcmlhbnQlMjAlM0QlMjAlMjJvcmlnaW5hbCUyRnBhY2thZ2VzJTIyJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMFBhdGgoJTIyLiUyRm1vZGVscyUyMiklMjAlMkYlMjAocmVwb19pZC5zcGxpdCglMjIlMkYlMjIpJTVCLTElNUQlMjAlMkIlMjAlMjJfJTIyJTIwJTJCJTIwdmFyaWFudC5yZXBsYWNlKCUyMiUyRiUyMiUyQyUyMCUyMl8lMjIpKSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlMkMlMjBhbGxvd19wYXR0ZXJucyUzRGYlMjIlN0J2YXJpYW50JTdEJTJGKiUyMiUyQyUyMGxvY2FsX2RpciUzRG1vZGVsX3BhdGglMkMlMjBsb2NhbF9kaXJfdXNlX3N5bWxpbmtzJTNERmFsc2UpJTBBcHJpbnQoZiUyMk1vZGVsJTIwZG93bmxvYWRlZCUyMGF0JTIwJTdCbW9kZWxfcGF0aCU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

repo_id = <span class="hljs-string">&quot;apple/coreml-stable-diffusion-v1-4&quot;</span>
variant = <span class="hljs-string">&quot;original/packages&quot;</span>

model_path = Path(<span class="hljs-string">&quot;./models&quot;</span>) / (repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>] + <span class="hljs-string">&quot;_&quot;</span> + variant.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>))
snapshot_download(repo_id, allow_patterns=<span class="hljs-string">f&quot;<span class="hljs-subst">{variant}</span>/*&quot;</span>, local_dir=model_path, local_dir_use_symlinks=<span class="hljs-literal">False</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model downloaded at <span class="hljs-subst">{model_path}</span>&quot;</span>)`,wrap:!1}}),R=new M({props:{title:"Inference",local:"python-inference",headingTag:"h3"}}),A=new b({props:{code:"cHl0aG9uJTIwLW0lMjBweXRob25fY29yZW1sX3N0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmUlMjAtLXByb21wdCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMjAtaSUyMG1vZGVscyUyRmNvcmVtbC1zdGFibGUtZGlmZnVzaW9uLXYxLTRfb3JpZ2luYWxfcGFja2FnZXMlMjAtbyUyMCUzQyUyRnBhdGglMkZ0byUyRm91dHB1dCUyRmltYWdlJTNFJTIwLS1jb21wdXRlLXVuaXQlMjBDUFVfQU5EX0dQVSUyMC0tc2VlZCUyMDkz",highlighted:"python -m python_coreml_stable_diffusion.pipeline --prompt &quot;a photo of an astronaut riding a horse on mars&quot; -i models/coreml-stable-diffusion-v1-4_original_packages -o &lt;/path/to/output/image&gt; --compute-unit CPU_AND_GPU --seed 93",wrap:!1}}),z=new b({props:{code:"cHl0aG9uJTIwLW0lMjBweXRob25fY29yZW1sX3N0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmUlMjAtLXByb21wdCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMjAtLWNvbXB1dGUtdW5pdCUyMEFMTCUyMC1vJTIwb3V0cHV0JTIwLS1zZWVkJTIwOTMlMjAtaSUyMG1vZGVscyUyRmNvcmVtbC1zdGFibGUtZGlmZnVzaW9uLXYxLTVfb3JpZ2luYWxfcGFja2FnZXMlMjAtLW1vZGVsLXZlcnNpb24lMjBydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNQ==",highlighted:"python -m python_coreml_stable_diffusion.pipeline --prompt &quot;a photo of an astronaut riding a horse on mars&quot; --compute-unit ALL -o output --seed 93 -i models/coreml-stable-diffusion-v1-5_original_packages --model-version runwayml/stable-diffusion-v1-5",wrap:!1}}),D=new M({props:{title:"Core ML inference in Swift",local:"core-ml-inference-in-swift",headingTag:"h2"}}),O=new M({props:{title:"Download",local:"download",headingTag:"h3"}}),ee=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmFwcGxlJTJGY29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXZhcmlhbnQlMjAlM0QlMjAlMjJvcmlnaW5hbCUyRmNvbXBpbGVkJTIyJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMFBhdGgoJTIyLiUyRm1vZGVscyUyMiklMjAlMkYlMjAocmVwb19pZC5zcGxpdCglMjIlMkYlMjIpJTVCLTElNUQlMjAlMkIlMjAlMjJfJTIyJTIwJTJCJTIwdmFyaWFudC5yZXBsYWNlKCUyMiUyRiUyMiUyQyUyMCUyMl8lMjIpKSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlMkMlMjBhbGxvd19wYXR0ZXJucyUzRGYlMjIlN0J2YXJpYW50JTdEJTJGKiUyMiUyQyUyMGxvY2FsX2RpciUzRG1vZGVsX3BhdGglMkMlMjBsb2NhbF9kaXJfdXNlX3N5bWxpbmtzJTNERmFsc2UpJTBBcHJpbnQoZiUyMk1vZGVsJTIwZG93bmxvYWRlZCUyMGF0JTIwJTdCbW9kZWxfcGF0aCU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

repo_id = <span class="hljs-string">&quot;apple/coreml-stable-diffusion-v1-4&quot;</span>
variant = <span class="hljs-string">&quot;original/compiled&quot;</span>

model_path = Path(<span class="hljs-string">&quot;./models&quot;</span>) / (repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>] + <span class="hljs-string">&quot;_&quot;</span> + variant.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>))
snapshot_download(repo_id, allow_patterns=<span class="hljs-string">f&quot;<span class="hljs-subst">{variant}</span>/*&quot;</span>, local_dir=model_path, local_dir_use_symlinks=<span class="hljs-literal">False</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model downloaded at <span class="hljs-subst">{model_path}</span>&quot;</span>)`,wrap:!1}}),te=new M({props:{title:"Inference",local:"swift-inference",headingTag:"h3"}}),ne=new b({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZhcHBsZSUyRm1sLXN0YWJsZS1kaWZmdXNpb24lMEFjZCUyMG1sLXN0YWJsZS1kaWZmdXNpb24=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/apple/ml-stable-diffusion
<span class="hljs-built_in">cd</span> ml-stable-diffusion`,wrap:!1}}),ie=new b({props:{code:"c3dpZnQlMjBydW4lMjBTdGFibGVEaWZmdXNpb25TYW1wbGUlMjAtLXJlc291cmNlLXBhdGglMjBtb2RlbHMlMkZjb3JlbWwtc3RhYmxlLWRpZmZ1c2lvbi12MS00X29yaWdpbmFsX2NvbXBpbGVkJTIwLS1jb21wdXRlLXVuaXRzJTIwYWxsJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMg==",highlighted:'swift run StableDiffusionSample --resource-path models/coreml-stable-diffusion-v1-4_original_compiled --compute-units all <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>',wrap:!1}}),pe=new M({props:{title:"Supported Diffusers Features",local:"supported-diffusers-features",headingTag:"h2"}}),ce=new M({props:{title:"Native Diffusers Swift app",local:"native-diffusers-swift-app",headingTag:"h2"}}),{c(){h=s("meta"),v=o(),y=s("p"),he=o(),r(g.$$.fragment),we=o(),U=s("p"),U.innerHTML=mt,be=o(),C=s("p"),C.textContent=ht,ve=o(),r(w.$$.fragment),ge=o(),r(T.$$.fragment),Ue=o(),$=s("p"),$.textContent=yt,Ce=o(),J=s("p"),J.innerHTML=Mt,Te=o(),j=s("p"),j.textContent=wt,$e=o(),k=s("ul"),k.innerHTML=bt,Je=o(),L=s("p"),L.innerHTML=vt,je=o(),r(_.$$.fragment),ke=o(),G=s("p"),G.textContent=gt,Le=o(),x=s("ul"),x.innerHTML=Ut,_e=o(),Z=s("p"),Z.innerHTML=Ct,Ge=o(),r(B.$$.fragment),xe=o(),X=s("p"),X.textContent=Tt,Ze=o(),r(N.$$.fragment),Be=o(),W=s("p"),W.textContent=$t,Xe=o(),r(S.$$.fragment),Ne=o(),r(I.$$.fragment),We=o(),P=s("p"),P.innerHTML=Jt,Se=o(),Y=s("p"),Y.innerHTML=jt,Ie=o(),r(H.$$.fragment),Pe=o(),r(R.$$.fragment),Ye=o(),F=s("p"),F.textContent=kt,He=o(),r(A.$$.fragment),Re=o(),q=s("p"),q.innerHTML=Lt,Fe=o(),V=s("p"),V.innerHTML=_t,Ae=o(),Q=s("p"),Q.innerHTML=Gt,qe=o(),r(z.$$.fragment),Ve=o(),r(D.$$.fragment),Qe=o(),E=s("p"),E.innerHTML=xt,ze=o(),r(O.$$.fragment),De=o(),K=s("p"),K.innerHTML=Zt,Ee=o(),r(ee.$$.fragment),Oe=o(),r(te.$$.fragment),Ke=o(),le=s("p"),le.textContent=Bt,et=o(),r(ne.$$.fragment),tt=o(),oe=s("p"),oe.innerHTML=Xt,lt=o(),r(ie.$$.fragment),nt=o(),se=s("p"),se.innerHTML=Nt,ot=o(),ae=s("p"),ae.innerHTML=Wt,it=o(),r(pe.$$.fragment),st=o(),re=s("p"),re.textContent=St,at=o(),de=s("ul"),de.innerHTML=It,pt=o(),fe=s("p"),fe.innerHTML=Pt,rt=o(),ue=s("p"),ue.textContent=Yt,dt=o(),r(ce.$$.fragment),ft=o(),me=s("p"),me.innerHTML=Ht,ut=o(),ye=s("p"),this.h()},l(e){const t=Et("svelte-u9bgzb",document.head);h=a(t,"META",{name:!0,content:!0}),t.forEach(l),v=i(e),y=a(e,"P",{}),Ft(y).forEach(l),he=i(e),d(g.$$.fragment,e),we=i(e),U=a(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-qaabbu"&&(U.innerHTML=mt),be=i(e),C=a(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1orjtw1"&&(C.textContent=ht),ve=i(e),d(w.$$.fragment,e),ge=i(e),d(T.$$.fragment,e),Ue=i(e),$=a(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-17hueww"&&($.textContent=yt),Ce=i(e),J=a(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-x5a2v2"&&(J.innerHTML=Mt),Te=i(e),j=a(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-4w8fdi"&&(j.textContent=wt),$e=i(e),k=a(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-12819qm"&&(k.innerHTML=bt),Je=i(e),L=a(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-eg00q0"&&(L.innerHTML=vt),je=i(e),d(_.$$.fragment,e),ke=i(e),G=a(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1tgahft"&&(G.textContent=gt),Le=i(e),x=a(e,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-1mnjc4n"&&(x.innerHTML=Ut),_e=i(e),Z=a(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1uzdjfm"&&(Z.innerHTML=Ct),Ge=i(e),d(B.$$.fragment,e),xe=i(e),X=a(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1xkemdi"&&(X.textContent=Tt),Ze=i(e),d(N.$$.fragment,e),Be=i(e),W=a(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-19xoujm"&&(W.textContent=$t),Xe=i(e),d(S.$$.fragment,e),Ne=i(e),d(I.$$.fragment,e),We=i(e),P=a(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1k484f2"&&(P.innerHTML=Jt),Se=i(e),Y=a(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1vn0h7b"&&(Y.innerHTML=jt),Ie=i(e),d(H.$$.fragment,e),Pe=i(e),d(R.$$.fragment,e),Ye=i(e),F=a(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-83ivzw"&&(F.textContent=kt),He=i(e),d(A.$$.fragment,e),Re=i(e),q=a(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-31mylk"&&(q.innerHTML=Lt),Fe=i(e),V=a(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-hhlwnj"&&(V.innerHTML=_t),Ae=i(e),Q=a(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-ixiq1r"&&(Q.innerHTML=Gt),qe=i(e),d(z.$$.fragment,e),Ve=i(e),d(D.$$.fragment,e),Qe=i(e),E=a(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1j3moem"&&(E.innerHTML=xt),ze=i(e),d(O.$$.fragment,e),De=i(e),K=a(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1u2q3bb"&&(K.innerHTML=Zt),Ee=i(e),d(ee.$$.fragment,e),Oe=i(e),d(te.$$.fragment,e),Ke=i(e),le=a(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1a6a1za"&&(le.textContent=Bt),et=i(e),d(ne.$$.fragment,e),tt=i(e),oe=a(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1sx1rnz"&&(oe.innerHTML=Xt),lt=i(e),d(ie.$$.fragment,e),nt=i(e),se=a(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-12c7wn6"&&(se.innerHTML=Nt),ot=i(e),ae=a(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-14s5isr"&&(ae.innerHTML=Wt),it=i(e),d(pe.$$.fragment,e),st=i(e),re=a(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-q86h2"&&(re.textContent=St),at=i(e),de=a(e,"UL",{"data-svelte-h":!0}),p(de)!=="svelte-1jpknop"&&(de.innerHTML=It),pt=i(e),fe=a(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-l2tdvl"&&(fe.innerHTML=Pt),rt=i(e),ue=a(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1262j72"&&(ue.textContent=Yt),dt=i(e),d(ce.$$.fragment,e),ft=i(e),me=a(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1bcp14t"&&(me.innerHTML=Ht),ut=i(e),ye=a(e,"P",{}),Ft(ye).forEach(l),this.h()},h(){At(h,"name","hf:doc:metadata"),At(h,"content",ll)},m(e,t){Ot(document.head,h),n(e,v,t),n(e,y,t),n(e,he,t),f(g,e,t),n(e,we,t),n(e,U,t),n(e,be,t),n(e,C,t),n(e,ve,t),f(w,e,t),n(e,ge,t),f(T,e,t),n(e,Ue,t),n(e,$,t),n(e,Ce,t),n(e,J,t),n(e,Te,t),n(e,j,t),n(e,$e,t),n(e,k,t),n(e,Je,t),n(e,L,t),n(e,je,t),f(_,e,t),n(e,ke,t),n(e,G,t),n(e,Le,t),n(e,x,t),n(e,_e,t),n(e,Z,t),n(e,Ge,t),f(B,e,t),n(e,xe,t),n(e,X,t),n(e,Ze,t),f(N,e,t),n(e,Be,t),n(e,W,t),n(e,Xe,t),f(S,e,t),n(e,Ne,t),f(I,e,t),n(e,We,t),n(e,P,t),n(e,Se,t),n(e,Y,t),n(e,Ie,t),f(H,e,t),n(e,Pe,t),f(R,e,t),n(e,Ye,t),n(e,F,t),n(e,He,t),f(A,e,t),n(e,Re,t),n(e,q,t),n(e,Fe,t),n(e,V,t),n(e,Ae,t),n(e,Q,t),n(e,qe,t),f(z,e,t),n(e,Ve,t),f(D,e,t),n(e,Qe,t),n(e,E,t),n(e,ze,t),f(O,e,t),n(e,De,t),n(e,K,t),n(e,Ee,t),f(ee,e,t),n(e,Oe,t),f(te,e,t),n(e,Ke,t),n(e,le,t),n(e,et,t),f(ne,e,t),n(e,tt,t),n(e,oe,t),n(e,lt,t),f(ie,e,t),n(e,nt,t),n(e,se,t),n(e,ot,t),n(e,ae,t),n(e,it,t),f(pe,e,t),n(e,st,t),n(e,re,t),n(e,at,t),n(e,de,t),n(e,pt,t),n(e,fe,t),n(e,rt,t),n(e,ue,t),n(e,dt,t),f(ce,e,t),n(e,ft,t),n(e,me,t),n(e,ut,t),n(e,ye,t),ct=!0},p(e,[t]){const Rt={};t&2&&(Rt.$$scope={dirty:t,ctx:e}),w.$set(Rt)},i(e){ct||(u(g.$$.fragment,e),u(w.$$.fragment,e),u(T.$$.fragment,e),u(_.$$.fragment,e),u(B.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(I.$$.fragment,e),u(H.$$.fragment,e),u(R.$$.fragment,e),u(A.$$.fragment,e),u(z.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),ct=!0)},o(e){c(g.$$.fragment,e),c(w.$$.fragment,e),c(T.$$.fragment,e),c(_.$$.fragment,e),c(B.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(I.$$.fragment,e),c(H.$$.fragment,e),c(R.$$.fragment,e),c(A.$$.fragment,e),c(z.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(ce.$$.fragment,e),ct=!1},d(e){e&&(l(v),l(y),l(he),l(we),l(U),l(be),l(C),l(ve),l(ge),l(Ue),l($),l(Ce),l(J),l(Te),l(j),l($e),l(k),l(Je),l(L),l(je),l(ke),l(G),l(Le),l(x),l(_e),l(Z),l(Ge),l(xe),l(X),l(Ze),l(Be),l(W),l(Xe),l(Ne),l(We),l(P),l(Se),l(Y),l(Ie),l(Pe),l(Ye),l(F),l(He),l(Re),l(q),l(Fe),l(V),l(Ae),l(Q),l(qe),l(Ve),l(Qe),l(E),l(ze),l(De),l(K),l(Ee),l(Oe),l(Ke),l(le),l(et),l(tt),l(oe),l(lt),l(nt),l(se),l(ot),l(ae),l(it),l(st),l(re),l(at),l(de),l(pt),l(fe),l(rt),l(ue),l(dt),l(ft),l(me),l(ut),l(ye)),l(h),m(g,e),m(w,e),m(T,e),m(_,e),m(B,e),m(N,e),m(S,e),m(I,e),m(H,e),m(R,e),m(A,e),m(z,e),m(D,e),m(O,e),m(ee,e),m(te,e),m(ne,e),m(ie,e),m(pe,e),m(ce,e)}}}const ll='{"title":"How to run Stable Diffusion with Core ML","local":"how-to-run-stable-diffusion-with-core-ml","sections":[{"title":"Stable Diffusion Core ML Checkpoints","local":"stable-diffusion-core-ml-checkpoints","sections":[],"depth":2},{"title":"Selecting the Core ML Variant to Use","local":"selecting-the-core-ml-variant-to-use","sections":[],"depth":2},{"title":"Core ML Inference in Python","local":"core-ml-inference-in-python","sections":[{"title":"Download the Model Checkpoints","local":"download-the-model-checkpoints","sections":[],"depth":3},{"title":"Inference","local":"python-inference","sections":[],"depth":3}],"depth":2},{"title":"Core ML inference in Swift","local":"core-ml-inference-in-swift","sections":[{"title":"Download","local":"download","sections":[],"depth":3},{"title":"Inference","local":"swift-inference","sections":[],"depth":3}],"depth":2},{"title":"Supported Diffusers Features","local":"supported-diffusers-features","sections":[],"depth":2},{"title":"Native Diffusers Swift app","local":"native-diffusers-swift-app","sections":[],"depth":2}],"depth":1}';function nl(Me){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rl extends zt{constructor(h){super(),Dt(this,h,nl,tl,qt,{})}}export{rl as component};
