import{s as Ui,o as _i,n as ol}from"../chunks/scheduler.182ea377.js";import{S as $i,i as Zi,g as o,s as i,p as f,x as Y,A as ji,h as s,f as n,c as a,j as w,q as u,m as r,y as H,k as y,v as b,a as l,r as d,d as m,t as c,u as h}from"../chunks/index.008d68e4.js";import{T as al}from"../chunks/Tip.4f096367.js";import{I as ue}from"../chunks/IconCopyLink.96bbb92b.js";import{C as g}from"../chunks/CodeBlock.5ed6eb7b.js";function xi(J){let p,T='🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.';return{c(){p=o("p"),p.innerHTML=T},l(M){p=s(M,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1qbiqsn"&&(p.innerHTML=T)},m(M,v){l(M,p,v)},p:ol,d(M){M&&n(p)}}}function Ci(J){let p,T='The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/controlnet/train_controlnet.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.';return{c(){p=o("p"),p.innerHTML=T},l(M){p=s(M,"P",{"data-svelte-h":!0}),r(p)!=="svelte-c8crv2"&&(p.innerHTML=T)},m(M,v){l(M,p,v)},p:ol,d(M){M&&n(p)}}}function Wi(J){let p,T='If you’re streaming a dataset on a TPU, performance may be bottlenecked by the 🤗 Datasets library which is not optimized for images. To ensure maximum throughput, you’re encouraged to explore other dataset formats like <a href="https://webdataset.github.io/webdataset/" rel="nofollow">WebDataset</a>, <a href="https://github.com/pytorch/data" rel="nofollow">TorchData</a>, and <a href="https://www.tensorflow.org/datasets/tfless_tfds" rel="nofollow">TensorFlow Datasets</a>.';return{c(){p=o("p"),p.innerHTML=T},l(M){p=s(M,"P",{"data-svelte-h":!0}),r(p)!=="svelte-onyuom"&&(p.innerHTML=T)},m(M,v){l(M,p,v)},p:ol,d(M){M&&n(p)}}}function Ri(J){let p,T="If you run into version conflicts with the plugin, try uninstalling and reinstalling all versions of TensorFlow and Tensorboard. The debugging functionality of the profile plugin is still experimental, and not all views are fully functional. The <code>trace_viewer</code> cuts off events after 1M, which can result in all your device traces getting lost if for example, you profile the compilation step by accident.";return{c(){p=o("p"),p.innerHTML=T},l(M){p=s(M,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1yoxzv4"&&(p.innerHTML=T)},m(M,v){l(M,p,v)},p:ol,d(M){M&&n(p)}}}function Ni(J){let p,T,M,v,ge,L,sl,de,cl="ControlNet",je,V,hl='<a href="https://hf.co/papers/2302.05543" rel="nofollow">ControlNet</a> models are adapters trained on top of another pretrained model. It allows for a greater degree of control over image generation by conditioning the model with an additional input image. The input image can be a canny edge, depth map, human pose, and many more.',xe,F,Ml='If you’re training on a GPU with limited vRAM, you should try enabling the <code>gradient_checkpointing</code>, <code>gradient_accumulation_steps</code>, and <code>mixed_precision</code> parameters in the training command. You can also reduce your memory footprint by using memory-efficient attention with <a href="../optimization/xformers">xFormers</a>. JAX/Flax training is also supported for efficient training on TPUs and GPUs, but it doesn’t support gradient checkpointing or xFormers. You should have a GPU with &gt;30GB of memory if you want to train faster with Flax.',Ce,S,yl='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/controlnet/train_controlnet.py" rel="nofollow">train_controlnet.py</a> training script to help you become familiar with it, and how you can adapt it for your own use-case.',We,A,bl="Before running the script, make sure you install the library from source:",Re,z,Ne,Q,gl="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",Ie,P,wl='If you have access to a TPU, the Flax training script runs even faster! Let’s run the training script on the <a href="https://cloud.google.com/tpu/docs/run-calculation-jax" rel="nofollow">Google Cloud TPU VM</a>. Create a single TPU v4-8 VM and connect to it:',Ge,q,Xe,D,Tl="Install JAX 0.4.5:",ke,O,Ee,K,vl="Then install the required dependencies for the Flax script:",Be,tt,Ye,C,He,et,Jl="Initialize an 🤗 Accelerate environment:",Le,nt,Ve,lt,Ul="To setup a default 🤗 Accelerate environment without choosing any configurations:",Fe,it,Se,at,_l="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",Ae,ot,ze,st,$l='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Qe,W,Pe,U,R,we,rt,rl,me,Zl="Script parameters",qe,pt,jl='The training script provides many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/controlnet/train_controlnet.py#L231" rel="nofollow"><code>parse_args()</code></a> function. This function provides default values for each parameter, such as the training batch size and learning rate, but you can also set your own values in the training command if you’d like.',De,ft,xl="For example, to speedup training with mixed precision using the fp16 format, add the <code>--mixed_precision</code> parameter to the training command:",Oe,ut,Ke,dt,Cl='Many of the basic and important parameters are described in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so this guide just focuses on the relevant parameters for ControlNet:',tn,mt,Wl="<li><code>--max_train_samples</code>: the number of training samples; this can be lowered for faster training, but if you want to stream really large datasets, you’ll need to include this parameter and the <code>--streaming</code> parameter in your training command</li> <li><code>--gradient_accumulation_steps</code>: number of update steps to accumulate before the backward pass; this allows you to train with a bigger batch size than your GPU memory can typically handle</li>",en,_,N,Te,ct,pl,ce,Rl="Min-SNR weighting",nn,ht,Nl='The <a href="https://huggingface.co/papers/2303.09556" rel="nofollow">Min-SNR</a> weighting strategy can help with training by rebalancing the loss to achieve faster convergence. The training script supports predicting <code>epsilon</code> (noise) or <code>v_prediction</code>, but Min-SNR is compatible with both prediction types. This weighting strategy is only supported by PyTorch and is unavailable in the Flax training script.',ln,Mt,Il="Add the <code>--snr_gamma</code> parameter and set it to the recommended value of 5.0:",an,yt,on,$,I,ve,bt,fl,he,Gl="Training script",sn,gt,Xl='As with the script parameters, a general walkthrough of the training script is provided in the <a href="text2image#training-script">Text-to-image</a> training guide. Instead, this guide takes a look at the relevant parts of the ControlNet script.',rn,wt,kl='The training script has a <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/controlnet/train_controlnet.py#L582" rel="nofollow"><code>make_train_dataset</code></a> function for preprocessing the dataset with image transforms and caption tokenization. You’ll see that in addition to the usual caption tokenization and image transforms, the script also includes transforms for the conditioning image.',pn,G,fn,Tt,un,vt,El='Within the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/controlnet/train_controlnet.py#L713" rel="nofollow"><code>main()</code></a> function, you’ll find the code for loading the tokenizer, text encoder, scheduler and models. This is also where the ControlNet model is loaded either from existing weights or randomly initialized from a UNet:',dn,Jt,mn,Ut,Bl='The <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/controlnet/train_controlnet.py#L871" rel="nofollow">optimizer</a> is set up to update the ControlNet parameters:',cn,_t,hn,$t,Yl='Finally, in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/controlnet/train_controlnet.py#L943" rel="nofollow">training loop</a>, the conditioning text embeddings and image are passed to the down and mid-blocks of the ControlNet model:',Mn,Zt,yn,jt,Hl='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',bn,Z,X,Je,xt,ul,Me,Ll="Launch the script",gn,Ct,Vl="Now you’re ready to launch the training script! 🚀",wn,Wt,Fl='This guide uses the <a href="https://huggingface.co/datasets/fusing/fill50k" rel="nofollow">fusing/fill50k</a> dataset, but remember, you can create and use your own dataset if you want (see the <a href="create_dataset">Create a dataset for training</a> guide).',Tn,Rt,Sl="Set the environment variable <code>MODEL_NAME</code> to a model id on the Hub or a path to a local model and <code>OUTPUT_DIR</code> to where you want to save the model.",vn,Nt,Al="Download the following images to condition your training with:",Jn,It,Un,Gt,zl="One more thing before you launch the script! Depending on the GPU you have, you may need to enable certain optimizations to train a ControlNet. The default configuration in this script requires ~38GB of vRAM. If you’re training on more than one GPU, add the <code>--multi_gpu</code> parameter to the <code>accelerate launch</code> command.",_n,Xt,Ql="On a 16GB GPU, you can use bitsandbytes 8-bit optimizer and gradient checkpointing to optimize your training run. Install bitsandbytes:",$n,kt,Zn,Et,Pl="Then, add the following parameter to your training command:",jn,Bt,xn,Yt,ql="On a 12GB GPU, you’ll need bitsandbytes 8-bit optimizer, gradient checkpointing, xFormers, and set the gradients to <code>None</code> instead of zero to reduce your memory-usage.",Cn,Ht,Wn,Lt,Dl='On a 8GB GPU, you’ll need to use <a href="https://www.deepspeed.ai/" rel="nofollow">DeepSpeed</a> to offload some of the tensors from the vRAM to either the CPU or NVME to allow training with less GPU memory.',Rn,Vt,Ol="Run the following command to configure your 🤗 Accelerate environment:",Nn,Ft,In,St,Kl='During configuration, confirm that you want to use DeepSpeed stage 2. Now it should be possible to train on under 8GB vRAM by combining DeepSpeed stage 2, fp16 mixed precision, and offloading the model parameters and the optimizer state to the CPU. The drawback is that this requires more system RAM (~25 GB). See the <a href="https://huggingface.co/docs/accelerate/usage_guides/deepspeed" rel="nofollow">DeepSpeed documentation</a> for more configuration options. Your configuration file should look something like:',Gn,At,Xn,zt,ti='You should also change the default Adam optimizer to DeepSpeed’s optimized version of Adam <a href="https://deepspeed.readthedocs.io/en/latest/optimizers.html#adam-cpu" rel="nofollow"><code>deepspeed.ops.adam.DeepSpeedCPUAdam</code></a> for a substantial speedup. Enabling <code>DeepSpeedCPUAdam</code> requires your system’s CUDA toolchain version to be the same as the one installed with PyTorch.',kn,Qt,ei="bitsandbytes 8-bit optimizers don’t seem to be compatible with DeepSpeed at the moment.",En,Pt,ni="That’s it! You don’t need to add any additional parameters to your training command.",Bn,qt,Yn,Dt,li='With Flax, you can <a href="https://jax.readthedocs.io/en/latest/profiling.html" rel="nofollow">profile your code</a> by adding the <code>--profile_steps==5</code> parameter to your training command. Install the Tensorboard profile plugin:',Hn,Ot,Ln,Kt,ii='Then you can inspect the profile at <a href="http://localhost:6006/#profile" rel="nofollow">http://localhost:6006/#profile</a>.',Vn,k,Fn,te,Sn,ee,ai="Once training is complete, you can use your newly trained model for inference!",An,ne,zn,j,E,Ue,le,dl,ye,oi="Stable Diffusion XL",Qn,ie,si='Stable Diffusion XL (SDXL) is a powerful text-to-image model that generates high-resolution images, and it adds a second text-encoder to its architecture. Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/controlnet/train_controlnet_sdxl.py" rel="nofollow"><code>train_controlnet_sdxl.py</code></a> script to train a ControlNet adapter for the SDXL model.',Pn,ae,ri='The SDXL training script is discussed in more detail in the <a href="sdxl">SDXL training</a> guide.',qn,x,B,_e,oe,ml,be,pi="Next steps",Dn,se,fi="Congratulations on training your own ControlNet! To learn more about how to use your new model, the following guides may be helpful:",On,re,ui='<li>Learn how to <a href="../using-diffusers/controlnet">use a ControlNet</a> for inference on a variety of tasks.</li>',Kn;return L=new ue({}),z=new g({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`}}),q=new g({props:{code:"Wk9ORSUzRHVzLWNlbnRyYWwyLWIlMEFUUFVfVFlQRSUzRHY0LTglMEFWTV9OQU1FJTNEaGdfZmxheCUwQSUwQWdjbG91ZCUyMGFscGhhJTIwY29tcHV0ZSUyMHRwdXMlMjB0cHUtdm0lMjBjcmVhdGUlMjAlMjRWTV9OQU1FJTIwJTVDJTBBJTIwLS16b25lJTIwJTI0Wk9ORSUyMCU1QyUwQSUyMC0tYWNjZWxlcmF0b3ItdHlwZSUyMCUyNFRQVV9UWVBFJTIwJTVDJTBBJTIwLS12ZXJzaW9uJTIwJTIwdHB1LXZtLXY0LWJhc2UlMEElMEFnY2xvdWQlMjBhbHBoYSUyMGNvbXB1dGUlMjB0cHVzJTIwdHB1LXZtJTIwc3NoJTIwJTI0Vk1fTkFNRSUyMC0tem9uZSUyMCUyNFpPTkUlMjAtLSUyMCU1Qw==",highlighted:`ZONE=us-central2-b
TPU_TYPE=v4-8
VM_NAME=hg_flax

gcloud alpha compute tpus tpu-vm create <span class="hljs-variable">$VM_NAME</span> \\
 --zone <span class="hljs-variable">$ZONE</span> \\
 --accelerator-type <span class="hljs-variable">$TPU_TYPE</span> \\
 --version  tpu-vm-v4-base

gcloud alpha compute tpus tpu-vm ssh <span class="hljs-variable">$VM_NAME</span> --zone <span class="hljs-variable">$ZONE</span> -- \\`}}),O=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMmpheCU1QnRwdSU1RCUzRCUzRDAuNC41JTIyJTIwLWYlMjBodHRwcyUzQSUyRiUyRnN0b3JhZ2UuZ29vZ2xlYXBpcy5jb20lMkZqYXgtcmVsZWFzZXMlMkZsaWJ0cHVfcmVsZWFzZXMuaHRtbA==",highlighted:'pip install <span class="hljs-string">&quot;jax[tpu]==0.4.5&quot;</span> -f https://storage.googleapis.com/jax-releases/libtpu_releases.html'}}),tt=new g({props:{code:"Y2QlMjBleGFtcGxlcyUyRmNvbnRyb2xuZXQlMEFwaXAlMjBpbnN0YWxsJTIwLXIlMjByZXF1aXJlbWVudHNfZmxheC50eHQ=",highlighted:`<span class="hljs-built_in">cd</span> examples/controlnet
pip install -r requirements_flax.txt`}}),C=new al({props:{$$slots:{default:[xi]},$$scope:{ctx:J}}}),nt=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config"}}),it=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default"}}),ot=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`from accelerate.utils import write_basic_config

write_basic_config()`}}),W=new al({props:{$$slots:{default:[Ci]},$$scope:{ctx:J}}}),rt=new ue({}),ut=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2NvbnRyb2xuZXQucHklMjAlNUMlMEElMjAlMjAtLW1peGVkX3ByZWNpc2lvbiUzRCUyMmZwMTYlMjI=",highlighted:`accelerate launch train_controlnet.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>`}}),ct=new ue({}),yt=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2NvbnRyb2xuZXQucHklMjAlNUMlMEElMjAlMjAtLXNucl9nYW1tYSUzRDUuMA==",highlighted:`accelerate launch train_controlnet.py \\
  --snr_gamma=5.0`}}),bt=new ue({}),G=new al({props:{$$slots:{default:[Wi]},$$scope:{ctx:J}}}),Tt=new g({props:{code:"Y29uZGl0aW9uaW5nX2ltYWdlX3RyYW5zZm9ybXMlMjAlM0QlMjB0cmFuc2Zvcm1zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3Jtcy5SZXNpemUoYXJncy5yZXNvbHV0aW9uJTJDJTIwaW50ZXJwb2xhdGlvbiUzRHRyYW5zZm9ybXMuSW50ZXJwb2xhdGlvbk1vZGUuQklMSU5FQVIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3Jtcy5DZW50ZXJDcm9wKGFyZ3MucmVzb2x1dGlvbiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1zLlRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEp",highlighted:`conditioning_image_transforms = transforms.Compose(
    [
        transforms.Resize(args.resolution, interpolation=transforms.InterpolationMode.BILINEAR),
        transforms.CenterCrop(args.resolution),
        transforms.ToTensor(),
    ]
)`}}),Jt=new g({props:{code:"aWYlMjBhcmdzLmNvbnRyb2xuZXRfbW9kZWxfbmFtZV9vcl9wYXRoJTNBJTBBJTIwJTIwJTIwJTIwbG9nZ2VyLmluZm8oJTIyTG9hZGluZyUyMGV4aXN0aW5nJTIwY29udHJvbG5ldCUyMHdlaWdodHMlMjIpJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYXJncy5jb250cm9sbmV0X21vZGVsX25hbWVfb3JfcGF0aCklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwbG9nZ2VyLmluZm8oJTIySW5pdGlhbGl6aW5nJTIwY29udHJvbG5ldCUyMHdlaWdodHMlMjBmcm9tJTIwdW5ldCUyMiklMEElMjAlMjAlMjAlMjBjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fdW5ldCh1bmV0KQ==",highlighted:`<span class="hljs-keyword">if</span> args.controlnet_model_name_or_path:
    logger.info(<span class="hljs-string">&quot;Loading existing controlnet weights&quot;</span>)
    controlnet = ControlNetModel.from_pretrained(args.controlnet_model_name_or_path)
<span class="hljs-keyword">else</span>:
    logger.info(<span class="hljs-string">&quot;Initializing controlnet weights from unet&quot;</span>)
    controlnet = ControlNetModel.from_unet(unet)`}}),_t=new g({props:{code:"cGFyYW1zX3RvX29wdGltaXplJTIwJTNEJTIwY29udHJvbG5ldC5wYXJhbWV0ZXJzKCklMEFvcHRpbWl6ZXIlMjAlM0QlMjBvcHRpbWl6ZXJfY2xhc3MoJTBBJTIwJTIwJTIwJTIwcGFyYW1zX3RvX29wdGltaXplJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0RhcmdzLmxlYXJuaW5nX3JhdGUlMkMlMEElMjAlMjAlMjAlMjBiZXRhcyUzRChhcmdzLmFkYW1fYmV0YTElMkMlMjBhcmdzLmFkYW1fYmV0YTIpJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEYXJncy5hZGFtX3dlaWdodF9kZWNheSUyQyUwQSUyMCUyMCUyMCUyMGVwcyUzRGFyZ3MuYWRhbV9lcHNpbG9uJTJDJTBBKQ==",highlighted:`params_to_optimize = controlnet.parameters()
optimizer = optimizer_class(
    params_to_optimize,
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`}}),Zt=new g({props:{code:"ZW5jb2Rlcl9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwdGV4dF9lbmNvZGVyKGJhdGNoJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSU1QjAlNUQlMEFjb250cm9sbmV0X2ltYWdlJTIwJTNEJTIwYmF0Y2glNUIlMjJjb25kaXRpb25pbmdfcGl4ZWxfdmFsdWVzJTIyJTVELnRvKGR0eXBlJTNEd2VpZ2h0X2R0eXBlKSUwQSUwQWRvd25fYmxvY2tfcmVzX3NhbXBsZXMlMkMlMjBtaWRfYmxvY2tfcmVzX3NhbXBsZSUyMCUzRCUyMGNvbnRyb2xuZXQoJTBBJTIwJTIwJTIwJTIwbm9pc3lfbGF0ZW50cyUyQyUwQSUyMCUyMCUyMCUyMHRpbWVzdGVwcyUyQyUwQSUyMCUyMCUyMCUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUzRGVuY29kZXJfaGlkZGVuX3N0YXRlcyUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xuZXRfY29uZCUzRGNvbnRyb2xuZXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZGljdCUzREZhbHNlJTJDJTBBKQ==",highlighted:`encoder_hidden_states = text_encoder(batch[<span class="hljs-string">&quot;input_ids&quot;</span>])[<span class="hljs-number">0</span>]
controlnet_image = batch[<span class="hljs-string">&quot;conditioning_pixel_values&quot;</span>].to(dtype=weight_dtype)

down_block_res_samples, mid_block_res_sample = controlnet(
    noisy_latents,
    timesteps,
    encoder_hidden_states=encoder_hidden_states,
    controlnet_cond=controlnet_image,
    return_dict=<span class="hljs-literal">False</span>,
)`}}),xt=new ue({}),It=new g({props:{code:"d2dldCUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNvbnRyb2xuZXRfdHJhaW5pbmclMkZjb25kaXRpb25pbmdfaW1hZ2VfMS5wbmclMEF3Z2V0JTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY29udHJvbG5ldF90cmFpbmluZyUyRmNvbmRpdGlvbmluZ19pbWFnZV8yLnBuZw==",highlighted:`wget https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/conditioning_image_1.png
wget https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/conditioning_image_2.png`}}),kt=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcw==",highlighted:"pip install bitsandbytes"}}),Bt=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2NvbnRyb2xuZXQucHklMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAtLXVzZV84Yml0X2FkYW0lMjAlNUM=",highlighted:`accelerate launch train_controlnet.py \\
  --gradient_checkpointing \\
  --use_8bit_adam \\`}}),Ht=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2NvbnRyb2xuZXQucHklMjAlNUMlMEElMjAlMjAtLXVzZV84Yml0X2FkYW0lMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAtLWVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbiUyMCU1QyUwQSUyMCUyMC0tc2V0X2dyYWRzX3RvX25vbmUlMjAlNUM=",highlighted:`accelerate launch train_controlnet.py \\
  --use_8bit_adam \\
  --gradient_checkpointing \\
  --enable_xformers_memory_efficient_attention \\
  --set_grads_to_none \\`}}),Ft=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config"}}),At=new g({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNBJTIwNCUwQSUyMCUyMG9mZmxvYWRfb3B0aW1pemVyX2RldmljZSUzQSUyMGNwdSUwQSUyMCUyMG9mZmxvYWRfcGFyYW1fZGV2aWNlJTNBJTIwY3B1JTBBJTIwJTIwemVybzNfaW5pdF9mbGFnJTNBJTIwZmFsc2UlMEElMjAlMjB6ZXJvX3N0YWdlJTNBJTIwMiUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQ=",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config:
  gradient_accumulation_steps: 4
  offload_optimizer_device: cpu
  offload_param_device: cpu
  zero3_init_flag: <span class="hljs-literal">false</span>
  zero_stage: 2
distributed_type: DEEPSPEED`}}),qt=new g({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aCUyRnRvJTJGc2F2ZSUyRm1vZGVsJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2NvbnRyb2xuZXQucHklMjAlNUMlMEElMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfRElSJTIwJTVDJTBBJTIwLS1vdXRwdXRfZGlyJTNEJTI0T1VUUFVUX0RJUiUyMCU1QyUwQSUyMC0tZGF0YXNldF9uYW1lJTNEZnVzaW5nJTJGZmlsbDUwayUyMCU1QyUwQSUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMCU1QyUwQSUyMC0tbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMjAlNUMlMEElMjAtLXZhbGlkYXRpb25faW1hZ2UlMjAlMjIuJTJGY29uZGl0aW9uaW5nX2ltYWdlXzEucG5nJTIyJTIwJTIyLiUyRmNvbmRpdGlvbmluZ19pbWFnZV8yLnBuZyUyMiUyMCU1QyUwQSUyMC0tdmFsaWRhdGlvbl9wcm9tcHQlMjAlMjJyZWQlMjBjaXJjbGUlMjB3aXRoJTIwYmx1ZSUyMGJhY2tncm91bmQlMjIlMjAlMjJjeWFuJTIwY2lyY2xlJTIwd2l0aCUyMGJyb3duJTIwZmxvcmFsJTIwYmFja2dyb3VuZCUyMiUyMCU1QyUwQSUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path/to/save/model&quot;</span>

accelerate launch train_controlnet.py \\
 --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_DIR</span> \\
 --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
 --dataset_name=fusing/fill50k \\
 --resolution=512 \\
 --learning_rate=1e-5 \\
 --validation_image <span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span> <span class="hljs-string">&quot;./conditioning_image_2.png&quot;</span> \\
 --validation_prompt <span class="hljs-string">&quot;red circle with blue background&quot;</span> <span class="hljs-string">&quot;cyan circle with brown floral background&quot;</span> \\
 --train_batch_size=1 \\
 --gradient_accumulation_steps=4 \\
 --push_to_hub`}}),Ot=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRlbnNvcmZsb3clMjB0ZW5zb3Jib2FyZC1wbHVnaW4tcHJvZmlsZSUwQXRlbnNvcmJvYXJkJTIwLS1sb2dkaXIlMjBydW5zJTJGZmlsbC1jaXJjbGUtMTAwc3RlcHMtMjAyMzA0MTFfMTY1NjEyJTJG",highlighted:`pip install tensorflow tensorboard-plugin-profile
tensorboard --logdir runs/fill-circle-100steps-20230411_165612/`}}),k=new al({props:{warning:!0,$$slots:{default:[Ri]},$$scope:{ctx:J}}}),te=new g({props:{code:"cHl0aG9uMyUyMHRyYWluX2NvbnRyb2xuZXRfZmxheC5weSUyMCU1QyUwQSUyMC0tcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0QlMjRNT0RFTF9ESVIlMjAlNUMlMEElMjAtLW91dHB1dF9kaXIlM0QlMjRPVVRQVVRfRElSJTIwJTVDJTBBJTIwLS1kYXRhc2V0X25hbWUlM0RmdXNpbmclMkZmaWxsNTBrJTIwJTVDJTBBJTIwLS1yZXNvbHV0aW9uJTNENTEyJTIwJTVDJTBBJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtNSUyMCU1QyUwQSUyMC0tdmFsaWRhdGlvbl9pbWFnZSUyMCUyMi4lMkZjb25kaXRpb25pbmdfaW1hZ2VfMS5wbmclMjIlMjAlMjIuJTJGY29uZGl0aW9uaW5nX2ltYWdlXzIucG5nJTIyJTIwJTVDJTBBJTIwLS12YWxpZGF0aW9uX3Byb21wdCUyMCUyMnJlZCUyMGNpcmNsZSUyMHdpdGglMjBibHVlJTIwYmFja2dyb3VuZCUyMiUyMCUyMmN5YW4lMjBjaXJjbGUlMjB3aXRoJTIwYnJvd24lMjBmbG9yYWwlMjBiYWNrZ3JvdW5kJTIyJTIwJTVDJTBBJTIwLS12YWxpZGF0aW9uX3N0ZXBzJTNEMTAwMCUyMCU1QyUwQSUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDIlMjAlNUMlMEElMjAtLXJldmlzaW9uJTNEJTIybm9uLWVtYSUyMiUyMCU1QyUwQSUyMC0tZnJvbV9wdCUyMCU1QyUwQSUyMC0tcmVwb3J0X3RvJTNEJTIyd2FuZGIlMjIlMjAlNUMlMEElMjAtLXRyYWNrZXJfcHJvamVjdF9uYW1lJTNEJTI0SFVCX01PREVMX0lEJTIwJTVDJTBBJTIwLS1udW1fdHJhaW5fZXBvY2hzJTNEMTElMjAlNUMlMEElMjAtLXB1c2hfdG9faHViJTIwJTVDJTBBJTIwLS1odWJfbW9kZWxfaWQlM0QlMjRIVUJfTU9ERUxfSUQ=",highlighted:`python3 train_controlnet_flax.py \\
 --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_DIR</span> \\
 --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
 --dataset_name=fusing/fill50k \\
 --resolution=512 \\
 --learning_rate=1e-5 \\
 --validation_image <span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span> <span class="hljs-string">&quot;./conditioning_image_2.png&quot;</span> \\
 --validation_prompt <span class="hljs-string">&quot;red circle with blue background&quot;</span> <span class="hljs-string">&quot;cyan circle with brown floral background&quot;</span> \\
 --validation_steps=1000 \\
 --train_batch_size=2 \\
 --revision=<span class="hljs-string">&quot;non-ema&quot;</span> \\
 --from_pt \\
 --report_to=<span class="hljs-string">&quot;wandb&quot;</span> \\
 --tracker_project_name=<span class="hljs-variable">$HUB_MODEL_ID</span> \\
 --num_train_epochs=11 \\
 --push_to_hub \\
 --hub_model_id=<span class="hljs-variable">$HUB_MODEL_ID</span>`}}),ne=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZjb250cm9sbmV0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJwYXRoJTJGdG8lMkZiYXNlJTJGbW9kZWwlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjIuJTJGY29uZGl0aW9uaW5nX2ltYWdlXzEucG5nJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMnBhbGUlMjBnb2xkZW4lMjByb2QlMjBjaXJjbGUlMjB3aXRoJTIwb2xkJTIwbGFjZSUyMGJhY2tncm91bmQlMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBpbWFnZSUzRGNvbnRyb2xfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMi4lMkZvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;path/to/controlnet&quot;</span>, torch_dtype=torch.float16)
pipeline = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;path/to/base/model&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

control_image = load_image(<span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span>)
prompt = <span class="hljs-string">&quot;pale golden rod circle with old lace background&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(prompt, num_inference_steps=<span class="hljs-number">20</span>, generator=generator, image=control_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;./output.png&quot;</span>)`}}),le=new ue({}),oe=new ue({}),{c(){p=o("meta"),T=i(),M=o("h1"),v=o("a"),ge=o("span"),f(L.$$.fragment),sl=i(),de=o("span"),de.textContent=cl,je=i(),V=o("p"),V.innerHTML=hl,xe=i(),F=o("p"),F.innerHTML=Ml,Ce=i(),S=o("p"),S.innerHTML=yl,We=i(),A=o("p"),A.textContent=bl,Re=i(),f(z.$$.fragment),Ne=i(),Q=o("p"),Q.textContent=gl,Ie=Y(`
<hfoptions id="installation">
<hfoption id="PyTorch">
\`\`\`bash
cd examples/controlnet
pip install -r requirements.txt
\`\`\`
</hfoption>
<hfoption id="Flax">
`),P=o("p"),P.innerHTML=wl,Ge=i(),f(q.$$.fragment),Xe=i(),D=o("p"),D.textContent=Tl,ke=i(),f(O.$$.fragment),Ee=i(),K=o("p"),K.textContent=vl,Be=i(),f(tt.$$.fragment),Ye=Y(`
</hfoption>
</hfoptions>
`),f(C.$$.fragment),He=i(),et=o("p"),et.textContent=Jl,Le=i(),f(nt.$$.fragment),Ve=i(),lt=o("p"),lt.textContent=Ul,Fe=i(),f(it.$$.fragment),Se=i(),at=o("p"),at.textContent=_l,Ae=i(),f(ot.$$.fragment),ze=i(),st=o("p"),st.innerHTML=$l,Qe=i(),f(W.$$.fragment),Pe=i(),U=o("h2"),R=o("a"),we=o("span"),f(rt.$$.fragment),rl=i(),me=o("span"),me.textContent=Zl,qe=i(),pt=o("p"),pt.innerHTML=jl,De=i(),ft=o("p"),ft.innerHTML=xl,Oe=i(),f(ut.$$.fragment),Ke=i(),dt=o("p"),dt.innerHTML=Cl,tn=i(),mt=o("ul"),mt.innerHTML=Wl,en=i(),_=o("h3"),N=o("a"),Te=o("span"),f(ct.$$.fragment),pl=i(),ce=o("span"),ce.textContent=Rl,nn=i(),ht=o("p"),ht.innerHTML=Nl,ln=i(),Mt=o("p"),Mt.innerHTML=Il,an=i(),f(yt.$$.fragment),on=i(),$=o("h2"),I=o("a"),ve=o("span"),f(bt.$$.fragment),fl=i(),he=o("span"),he.textContent=Gl,sn=i(),gt=o("p"),gt.innerHTML=Xl,rn=i(),wt=o("p"),wt.innerHTML=kl,pn=i(),f(G.$$.fragment),fn=i(),f(Tt.$$.fragment),un=i(),vt=o("p"),vt.innerHTML=El,dn=i(),f(Jt.$$.fragment),mn=i(),Ut=o("p"),Ut.innerHTML=Bl,cn=i(),f(_t.$$.fragment),hn=i(),$t=o("p"),$t.innerHTML=Yl,Mn=i(),f(Zt.$$.fragment),yn=i(),jt=o("p"),jt.innerHTML=Hl,bn=i(),Z=o("h2"),X=o("a"),Je=o("span"),f(xt.$$.fragment),ul=i(),Me=o("span"),Me.textContent=Ll,gn=i(),Ct=o("p"),Ct.textContent=Vl,wn=i(),Wt=o("p"),Wt.innerHTML=Fl,Tn=i(),Rt=o("p"),Rt.innerHTML=Sl,vn=i(),Nt=o("p"),Nt.textContent=Al,Jn=i(),f(It.$$.fragment),Un=i(),Gt=o("p"),Gt.innerHTML=zl,_n=Y(`
<hfoptions id="gpu-select">
<hfoption id="16GB">
`),Xt=o("p"),Xt.textContent=Ql,$n=i(),f(kt.$$.fragment),Zn=i(),Et=o("p"),Et.textContent=Pl,jn=i(),f(Bt.$$.fragment),xn=Y(`
</hfoption>
<hfoption id="12GB">
`),Yt=o("p"),Yt.innerHTML=ql,Cn=i(),f(Ht.$$.fragment),Wn=Y(`
</hfoption>
<hfoption id="8GB">
`),Lt=o("p"),Lt.innerHTML=Dl,Rn=i(),Vt=o("p"),Vt.textContent=Ol,Nn=i(),f(Ft.$$.fragment),In=i(),St=o("p"),St.innerHTML=Kl,Gn=i(),f(At.$$.fragment),Xn=i(),zt=o("p"),zt.innerHTML=ti,kn=i(),Qt=o("p"),Qt.textContent=ei,En=i(),Pt=o("p"),Pt.textContent=ni,Bn=Y(`
</hfoption>
</hfoptions>
<hfoptions id="training-inference">
<hfoption id="PyTorch">

	`),f(qt.$$.fragment),Yn=Y(`
</hfoption>
<hfoption id="Flax">
`),Dt=o("p"),Dt.innerHTML=li,Hn=i(),f(Ot.$$.fragment),Ln=i(),Kt=o("p"),Kt.innerHTML=ii,Vn=i(),f(k.$$.fragment),Fn=i(),f(te.$$.fragment),Sn=Y(`
</hfoption>
</hfoptions>
`),ee=o("p"),ee.textContent=ai,An=i(),f(ne.$$.fragment),zn=i(),j=o("h2"),E=o("a"),Ue=o("span"),f(le.$$.fragment),dl=i(),ye=o("span"),ye.textContent=oi,Qn=i(),ie=o("p"),ie.innerHTML=si,Pn=i(),ae=o("p"),ae.innerHTML=ri,qn=i(),x=o("h2"),B=o("a"),_e=o("span"),f(oe.$$.fragment),ml=i(),be=o("span"),be.textContent=pi,Dn=i(),se=o("p"),se.textContent=fi,On=i(),re=o("ul"),re.innerHTML=ui,this.h()},l(t){const e=ji("svelte-1phssyn",document.head);p=s(e,"META",{name:!0,content:!0}),e.forEach(n),T=a(t),M=s(t,"H1",{class:!0});var pe=w(M);v=s(pe,"A",{id:!0,class:!0,href:!0});var $e=w(v);ge=s($e,"SPAN",{});var Ze=w(ge);u(L.$$.fragment,Ze),Ze.forEach(n),$e.forEach(n),sl=a(pe),de=s(pe,"SPAN",{"data-svelte-h":!0}),r(de)!=="svelte-1147sj1"&&(de.textContent=cl),pe.forEach(n),je=a(t),V=s(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-q2o66i"&&(V.innerHTML=hl),xe=a(t),F=s(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-l104r8"&&(F.innerHTML=Ml),Ce=a(t),S=s(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-sp8ken"&&(S.innerHTML=yl),We=a(t),A=s(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-l7dm2q"&&(A.textContent=bl),Re=a(t),u(z.$$.fragment,t),Ne=a(t),Q=s(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-z4z0b9"&&(Q.textContent=gl),Ie=H(t,`
<hfoptions id="installation">
<hfoption id="PyTorch">
\`\`\`bash
cd examples/controlnet
pip install -r requirements.txt
\`\`\`
</hfoption>
<hfoption id="Flax">
`),P=s(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-pcu1fk"&&(P.innerHTML=wl),Ge=a(t),u(q.$$.fragment,t),Xe=a(t),D=s(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1a9obhp"&&(D.textContent=Tl),ke=a(t),u(O.$$.fragment,t),Ee=a(t),K=s(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-2qk98r"&&(K.textContent=vl),Be=a(t),u(tt.$$.fragment,t),Ye=H(t,`
</hfoption>
</hfoptions>
`),u(C.$$.fragment,t),He=a(t),et=s(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-60q53m"&&(et.textContent=Jl),Le=a(t),u(nt.$$.fragment,t),Ve=a(t),lt=s(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-di6juu"&&(lt.textContent=Ul),Fe=a(t),u(it.$$.fragment,t),Se=a(t),at=s(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-tsz4qp"&&(at.textContent=_l),Ae=a(t),u(ot.$$.fragment,t),ze=a(t),st=s(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1fkfdql"&&(st.innerHTML=$l),Qe=a(t),u(W.$$.fragment,t),Pe=a(t),U=s(t,"H2",{class:!0});var fe=w(U);R=s(fe,"A",{id:!0,class:!0,href:!0});var di=w(R);we=s(di,"SPAN",{});var mi=w(we);u(rt.$$.fragment,mi),mi.forEach(n),di.forEach(n),rl=a(fe),me=s(fe,"SPAN",{"data-svelte-h":!0}),r(me)!=="svelte-r00uw2"&&(me.textContent=Zl),fe.forEach(n),qe=a(t),pt=s(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-bw2u91"&&(pt.innerHTML=jl),De=a(t),ft=s(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1r0bv1x"&&(ft.innerHTML=xl),Oe=a(t),u(ut.$$.fragment,t),Ke=a(t),dt=s(t,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1s0tjh8"&&(dt.innerHTML=Cl),tn=a(t),mt=s(t,"UL",{"data-svelte-h":!0}),r(mt)!=="svelte-9wifrj"&&(mt.innerHTML=Wl),en=a(t),_=s(t,"H3",{class:!0});var tl=w(_);N=s(tl,"A",{id:!0,class:!0,href:!0});var ci=w(N);Te=s(ci,"SPAN",{});var hi=w(Te);u(ct.$$.fragment,hi),hi.forEach(n),ci.forEach(n),pl=a(tl),ce=s(tl,"SPAN",{"data-svelte-h":!0}),r(ce)!=="svelte-ulysw7"&&(ce.textContent=Rl),tl.forEach(n),nn=a(t),ht=s(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-isitbv"&&(ht.innerHTML=Nl),ln=a(t),Mt=s(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-tp3kp"&&(Mt.innerHTML=Il),an=a(t),u(yt.$$.fragment,t),on=a(t),$=s(t,"H2",{class:!0});var el=w($);I=s(el,"A",{id:!0,class:!0,href:!0});var Mi=w(I);ve=s(Mi,"SPAN",{});var yi=w(ve);u(bt.$$.fragment,yi),yi.forEach(n),Mi.forEach(n),fl=a(el),he=s(el,"SPAN",{"data-svelte-h":!0}),r(he)!=="svelte-339bde"&&(he.textContent=Gl),el.forEach(n),sn=a(t),gt=s(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1ca6n8s"&&(gt.innerHTML=Xl),rn=a(t),wt=s(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-yhtkem"&&(wt.innerHTML=kl),pn=a(t),u(G.$$.fragment,t),fn=a(t),u(Tt.$$.fragment,t),un=a(t),vt=s(t,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1t15wny"&&(vt.innerHTML=El),dn=a(t),u(Jt.$$.fragment,t),mn=a(t),Ut=s(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-1rtudr1"&&(Ut.innerHTML=Bl),cn=a(t),u(_t.$$.fragment,t),hn=a(t),$t=s(t,"P",{"data-svelte-h":!0}),r($t)!=="svelte-ane16q"&&($t.innerHTML=Yl),Mn=a(t),u(Zt.$$.fragment,t),yn=a(t),jt=s(t,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-6gmbd2"&&(jt.innerHTML=Hl),bn=a(t),Z=s(t,"H2",{class:!0});var nl=w(Z);X=s(nl,"A",{id:!0,class:!0,href:!0});var bi=w(X);Je=s(bi,"SPAN",{});var gi=w(Je);u(xt.$$.fragment,gi),gi.forEach(n),bi.forEach(n),ul=a(nl),Me=s(nl,"SPAN",{"data-svelte-h":!0}),r(Me)!=="svelte-zp6p5k"&&(Me.textContent=Ll),nl.forEach(n),gn=a(t),Ct=s(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-rsq2yy"&&(Ct.textContent=Vl),wn=a(t),Wt=s(t,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-87boqf"&&(Wt.innerHTML=Fl),Tn=a(t),Rt=s(t,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-11t01x0"&&(Rt.innerHTML=Sl),vn=a(t),Nt=s(t,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-1uo0m2d"&&(Nt.textContent=Al),Jn=a(t),u(It.$$.fragment,t),Un=a(t),Gt=s(t,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-1wlzzvk"&&(Gt.innerHTML=zl),_n=H(t,`
<hfoptions id="gpu-select">
<hfoption id="16GB">
`),Xt=s(t,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-izoj73"&&(Xt.textContent=Ql),$n=a(t),u(kt.$$.fragment,t),Zn=a(t),Et=s(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-1rkm1uq"&&(Et.textContent=Pl),jn=a(t),u(Bt.$$.fragment,t),xn=H(t,`
</hfoption>
<hfoption id="12GB">
`),Yt=s(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-13zq302"&&(Yt.innerHTML=ql),Cn=a(t),u(Ht.$$.fragment,t),Wn=H(t,`
</hfoption>
<hfoption id="8GB">
`),Lt=s(t,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-1tq9cba"&&(Lt.innerHTML=Dl),Rn=a(t),Vt=s(t,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-1fx999v"&&(Vt.textContent=Ol),Nn=a(t),u(Ft.$$.fragment,t),In=a(t),St=s(t,"P",{"data-svelte-h":!0}),r(St)!=="svelte-184kffk"&&(St.innerHTML=Kl),Gn=a(t),u(At.$$.fragment,t),Xn=a(t),zt=s(t,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-14m6rf5"&&(zt.innerHTML=ti),kn=a(t),Qt=s(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-z8cdsf"&&(Qt.textContent=ei),En=a(t),Pt=s(t,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-lwtx0u"&&(Pt.textContent=ni),Bn=H(t,`
</hfoption>
</hfoptions>
<hfoptions id="training-inference">
<hfoption id="PyTorch">

	`),u(qt.$$.fragment,t),Yn=H(t,`
</hfoption>
<hfoption id="Flax">
`),Dt=s(t,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-10g27jr"&&(Dt.innerHTML=li),Hn=a(t),u(Ot.$$.fragment,t),Ln=a(t),Kt=s(t,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-q8hcb8"&&(Kt.innerHTML=ii),Vn=a(t),u(k.$$.fragment,t),Fn=a(t),u(te.$$.fragment,t),Sn=H(t,`
</hfoption>
</hfoptions>
`),ee=s(t,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1x6in5t"&&(ee.textContent=ai),An=a(t),u(ne.$$.fragment,t),zn=a(t),j=s(t,"H2",{class:!0});var ll=w(j);E=s(ll,"A",{id:!0,class:!0,href:!0});var wi=w(E);Ue=s(wi,"SPAN",{});var Ti=w(Ue);u(le.$$.fragment,Ti),Ti.forEach(n),wi.forEach(n),dl=a(ll),ye=s(ll,"SPAN",{"data-svelte-h":!0}),r(ye)!=="svelte-1g3g87b"&&(ye.textContent=oi),ll.forEach(n),Qn=a(t),ie=s(t,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-t1l7wa"&&(ie.innerHTML=si),Pn=a(t),ae=s(t,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-6dxtva"&&(ae.innerHTML=ri),qn=a(t),x=s(t,"H2",{class:!0});var il=w(x);B=s(il,"A",{id:!0,class:!0,href:!0});var vi=w(B);_e=s(vi,"SPAN",{});var Ji=w(_e);u(oe.$$.fragment,Ji),Ji.forEach(n),vi.forEach(n),ml=a(il),be=s(il,"SPAN",{"data-svelte-h":!0}),r(be)!=="svelte-pr7lub"&&(be.textContent=pi),il.forEach(n),Dn=a(t),se=s(t,"P",{"data-svelte-h":!0}),r(se)!=="svelte-s6fbj8"&&(se.textContent=fi),On=a(t),re=s(t,"UL",{"data-svelte-h":!0}),r(re)!=="svelte-jinr48"&&(re.innerHTML=ui),this.h()},h(){y(p,"name","hf:doc:metadata"),y(p,"content",JSON.stringify(Ii)),y(v,"id","controlnet"),y(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(v,"href","#controlnet"),y(M,"class","relative group"),y(R,"id","script-parameters"),y(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(R,"href","#script-parameters"),y(U,"class","relative group"),y(N,"id","minsnr-weighting"),y(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(N,"href","#minsnr-weighting"),y(_,"class","relative group"),y(I,"id","training-script"),y(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(I,"href","#training-script"),y($,"class","relative group"),y(X,"id","launch-the-script"),y(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(X,"href","#launch-the-script"),y(Z,"class","relative group"),y(E,"id","stable-diffusion-xl"),y(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(E,"href","#stable-diffusion-xl"),y(j,"class","relative group"),y(B,"id","next-steps"),y(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(B,"href","#next-steps"),y(x,"class","relative group")},m(t,e){b(document.head,p),l(t,T,e),l(t,M,e),b(M,v),b(v,ge),d(L,ge,null),b(M,sl),b(M,de),l(t,je,e),l(t,V,e),l(t,xe,e),l(t,F,e),l(t,Ce,e),l(t,S,e),l(t,We,e),l(t,A,e),l(t,Re,e),d(z,t,e),l(t,Ne,e),l(t,Q,e),l(t,Ie,e),l(t,P,e),l(t,Ge,e),d(q,t,e),l(t,Xe,e),l(t,D,e),l(t,ke,e),d(O,t,e),l(t,Ee,e),l(t,K,e),l(t,Be,e),d(tt,t,e),l(t,Ye,e),d(C,t,e),l(t,He,e),l(t,et,e),l(t,Le,e),d(nt,t,e),l(t,Ve,e),l(t,lt,e),l(t,Fe,e),d(it,t,e),l(t,Se,e),l(t,at,e),l(t,Ae,e),d(ot,t,e),l(t,ze,e),l(t,st,e),l(t,Qe,e),d(W,t,e),l(t,Pe,e),l(t,U,e),b(U,R),b(R,we),d(rt,we,null),b(U,rl),b(U,me),l(t,qe,e),l(t,pt,e),l(t,De,e),l(t,ft,e),l(t,Oe,e),d(ut,t,e),l(t,Ke,e),l(t,dt,e),l(t,tn,e),l(t,mt,e),l(t,en,e),l(t,_,e),b(_,N),b(N,Te),d(ct,Te,null),b(_,pl),b(_,ce),l(t,nn,e),l(t,ht,e),l(t,ln,e),l(t,Mt,e),l(t,an,e),d(yt,t,e),l(t,on,e),l(t,$,e),b($,I),b(I,ve),d(bt,ve,null),b($,fl),b($,he),l(t,sn,e),l(t,gt,e),l(t,rn,e),l(t,wt,e),l(t,pn,e),d(G,t,e),l(t,fn,e),d(Tt,t,e),l(t,un,e),l(t,vt,e),l(t,dn,e),d(Jt,t,e),l(t,mn,e),l(t,Ut,e),l(t,cn,e),d(_t,t,e),l(t,hn,e),l(t,$t,e),l(t,Mn,e),d(Zt,t,e),l(t,yn,e),l(t,jt,e),l(t,bn,e),l(t,Z,e),b(Z,X),b(X,Je),d(xt,Je,null),b(Z,ul),b(Z,Me),l(t,gn,e),l(t,Ct,e),l(t,wn,e),l(t,Wt,e),l(t,Tn,e),l(t,Rt,e),l(t,vn,e),l(t,Nt,e),l(t,Jn,e),d(It,t,e),l(t,Un,e),l(t,Gt,e),l(t,_n,e),l(t,Xt,e),l(t,$n,e),d(kt,t,e),l(t,Zn,e),l(t,Et,e),l(t,jn,e),d(Bt,t,e),l(t,xn,e),l(t,Yt,e),l(t,Cn,e),d(Ht,t,e),l(t,Wn,e),l(t,Lt,e),l(t,Rn,e),l(t,Vt,e),l(t,Nn,e),d(Ft,t,e),l(t,In,e),l(t,St,e),l(t,Gn,e),d(At,t,e),l(t,Xn,e),l(t,zt,e),l(t,kn,e),l(t,Qt,e),l(t,En,e),l(t,Pt,e),l(t,Bn,e),d(qt,t,e),l(t,Yn,e),l(t,Dt,e),l(t,Hn,e),d(Ot,t,e),l(t,Ln,e),l(t,Kt,e),l(t,Vn,e),d(k,t,e),l(t,Fn,e),d(te,t,e),l(t,Sn,e),l(t,ee,e),l(t,An,e),d(ne,t,e),l(t,zn,e),l(t,j,e),b(j,E),b(E,Ue),d(le,Ue,null),b(j,dl),b(j,ye),l(t,Qn,e),l(t,ie,e),l(t,Pn,e),l(t,ae,e),l(t,qn,e),l(t,x,e),b(x,B),b(B,_e),d(oe,_e,null),b(x,ml),b(x,be),l(t,Dn,e),l(t,se,e),l(t,On,e),l(t,re,e),Kn=!0},p(t,[e]){const pe={};e&2&&(pe.$$scope={dirty:e,ctx:t}),C.$set(pe);const $e={};e&2&&($e.$$scope={dirty:e,ctx:t}),W.$set($e);const Ze={};e&2&&(Ze.$$scope={dirty:e,ctx:t}),G.$set(Ze);const fe={};e&2&&(fe.$$scope={dirty:e,ctx:t}),k.$set(fe)},i(t){Kn||(m(L.$$.fragment,t),m(z.$$.fragment,t),m(q.$$.fragment,t),m(O.$$.fragment,t),m(tt.$$.fragment,t),m(C.$$.fragment,t),m(nt.$$.fragment,t),m(it.$$.fragment,t),m(ot.$$.fragment,t),m(W.$$.fragment,t),m(rt.$$.fragment,t),m(ut.$$.fragment,t),m(ct.$$.fragment,t),m(yt.$$.fragment,t),m(bt.$$.fragment,t),m(G.$$.fragment,t),m(Tt.$$.fragment,t),m(Jt.$$.fragment,t),m(_t.$$.fragment,t),m(Zt.$$.fragment,t),m(xt.$$.fragment,t),m(It.$$.fragment,t),m(kt.$$.fragment,t),m(Bt.$$.fragment,t),m(Ht.$$.fragment,t),m(Ft.$$.fragment,t),m(At.$$.fragment,t),m(qt.$$.fragment,t),m(Ot.$$.fragment,t),m(k.$$.fragment,t),m(te.$$.fragment,t),m(ne.$$.fragment,t),m(le.$$.fragment,t),m(oe.$$.fragment,t),Kn=!0)},o(t){c(L.$$.fragment,t),c(z.$$.fragment,t),c(q.$$.fragment,t),c(O.$$.fragment,t),c(tt.$$.fragment,t),c(C.$$.fragment,t),c(nt.$$.fragment,t),c(it.$$.fragment,t),c(ot.$$.fragment,t),c(W.$$.fragment,t),c(rt.$$.fragment,t),c(ut.$$.fragment,t),c(ct.$$.fragment,t),c(yt.$$.fragment,t),c(bt.$$.fragment,t),c(G.$$.fragment,t),c(Tt.$$.fragment,t),c(Jt.$$.fragment,t),c(_t.$$.fragment,t),c(Zt.$$.fragment,t),c(xt.$$.fragment,t),c(It.$$.fragment,t),c(kt.$$.fragment,t),c(Bt.$$.fragment,t),c(Ht.$$.fragment,t),c(Ft.$$.fragment,t),c(At.$$.fragment,t),c(qt.$$.fragment,t),c(Ot.$$.fragment,t),c(k.$$.fragment,t),c(te.$$.fragment,t),c(ne.$$.fragment,t),c(le.$$.fragment,t),c(oe.$$.fragment,t),Kn=!1},d(t){t&&(n(T),n(M),n(je),n(V),n(xe),n(F),n(Ce),n(S),n(We),n(A),n(Re),n(Ne),n(Q),n(Ie),n(P),n(Ge),n(Xe),n(D),n(ke),n(Ee),n(K),n(Be),n(Ye),n(He),n(et),n(Le),n(Ve),n(lt),n(Fe),n(Se),n(at),n(Ae),n(ze),n(st),n(Qe),n(Pe),n(U),n(qe),n(pt),n(De),n(ft),n(Oe),n(Ke),n(dt),n(tn),n(mt),n(en),n(_),n(nn),n(ht),n(ln),n(Mt),n(an),n(on),n($),n(sn),n(gt),n(rn),n(wt),n(pn),n(fn),n(un),n(vt),n(dn),n(mn),n(Ut),n(cn),n(hn),n($t),n(Mn),n(yn),n(jt),n(bn),n(Z),n(gn),n(Ct),n(wn),n(Wt),n(Tn),n(Rt),n(vn),n(Nt),n(Jn),n(Un),n(Gt),n(_n),n(Xt),n($n),n(Zn),n(Et),n(jn),n(xn),n(Yt),n(Cn),n(Wn),n(Lt),n(Rn),n(Vt),n(Nn),n(In),n(St),n(Gn),n(Xn),n(zt),n(kn),n(Qt),n(En),n(Pt),n(Bn),n(Yn),n(Dt),n(Hn),n(Ln),n(Kt),n(Vn),n(Fn),n(Sn),n(ee),n(An),n(zn),n(j),n(Qn),n(ie),n(Pn),n(ae),n(qn),n(x),n(Dn),n(se),n(On),n(re)),n(p),h(L),h(z,t),h(q,t),h(O,t),h(tt,t),h(C,t),h(nt,t),h(it,t),h(ot,t),h(W,t),h(rt),h(ut,t),h(ct),h(yt,t),h(bt),h(G,t),h(Tt,t),h(Jt,t),h(_t,t),h(Zt,t),h(xt),h(It,t),h(kt,t),h(Bt,t),h(Ht,t),h(Ft,t),h(At,t),h(qt,t),h(Ot,t),h(k,t),h(te,t),h(ne,t),h(le),h(oe)}}}const Ii={local:"controlnet",sections:[{local:"script-parameters",sections:[{local:"minsnr-weighting",title:"Min-SNR weighting"}],title:"Script parameters"},{local:"training-script",title:"Training script"},{local:"launch-the-script",title:"Launch the script"},{local:"stable-diffusion-xl",title:"Stable Diffusion XL"},{local:"next-steps",title:"Next steps"}],title:"ControlNet"};function Gi(J){return _i(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hi extends $i{constructor(p){super(),Zi(this,p,Gi,Ni,Ui,{})}}export{Hi as component};
