import{s as kt,n as Vt,o as Et}from"../chunks/scheduler.182ea377.js";import{S as Ht,i as Ft,g as s,s as i,r as o,A as Qt,h as p,f as l,c as a,j as Lt,u as c,x as r,k as ot,y as At,a as n,v as m,d as u,t as d,w as f}from"../chunks/index.abf12888.js";import{C as y}from"../chunks/CodeBlock.57fe6e13.js";import{H as ce}from"../chunks/Heading.16916d63.js";function zt(ct){let M,de,me,fe,T,ye,J,mt='<a href="https://arxiv.org/abs/2211.09800" rel="nofollow">InstructPix2Pix</a> is a method to fine-tune text-conditioned diffusion models such that they can follow an edit instruction for an input image. Models fine-tuned using this method take the following as inputs:',Me,h,ut='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/edit-instruction.png" alt="instructpix2pix-inputs" width="600/"/>',he,U,dt="The output is an “edited” image that reflects the edit instruction applied on the input image:",we,w,ft='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/output-gs%407-igs%401-steps%4050.png" alt="instructpix2pix-output" width="600/"/>',Te,g,yt='The <code>train_instruct_pix2pix.py</code> script (you can find the it <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/train_instruct_pix2pix.py" rel="nofollow">here</a>) shows how to implement the training procedure and adapt it for Stable Diffusion.',Je,b,Mt=`<strong><em>Disclaimer: Even though <code>train_instruct_pix2pix.py</code> implements the InstructPix2Pix
training procedure while being faithful to the <a href="https://github.com/timothybrooks/instruct-pix2pix" rel="nofollow">original implementation</a> we have only tested it on a <a href="https://huggingface.co/datasets/fusing/instructpix2pix-1000-samples" rel="nofollow">small-scale dataset</a>. This can impact the end results. For better results, we recommend longer training runs with a larger dataset. <a href="https://huggingface.co/datasets/timbrooks/instructpix2pix-clip-filtered" rel="nofollow">Here</a> you can find a large dataset for InstructPix2Pix training.</em></strong>`,Ue,_,ge,x,be,W,ht="Before running the scripts, make sure to install the library’s training dependencies:",_e,C,wt="<strong>Important</strong>",xe,Z,Tt="To make sure you can successfully run the latest versions of the example scripts, we highly recommend <strong>installing from source</strong> and keeping the install up to date as we update the example scripts frequently and install some example-specific requirements. To do this, execute the following steps in a new virtual environment:",We,j,Ce,$,Jt="Then cd in the example folder",Ze,I,je,v,Ut="Now run",$e,X,Ie,N,gt='And initialize an <a href="https://github.com/huggingface/accelerate/" rel="nofollow">🤗Accelerate</a> environment with:',ve,R,Xe,B,bt="Or for a default accelerate configuration without answering questions about your environment",Ne,Y,Re,S,_t="Or if your environment doesn’t support an interactive shell e.g. a notebook",Be,G,Ye,L,Se,k,xt=`As mentioned before, we’ll use a <a href="https://huggingface.co/datasets/fusing/instructpix2pix-1000-samples" rel="nofollow">small toy dataset</a> for training. The dataset
is a smaller version of the <a href="https://huggingface.co/datasets/timbrooks/instructpix2pix-clip-filtered" rel="nofollow">original dataset</a> used in the InstructPix2Pix paper. To use your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide.`,Ge,V,Wt='Specify the <code>MODEL_NAME</code> environment variable (either a Hub model repository id or a path to the directory containing the model weights) and pass it to the <a href="https://huggingface.co/docs/diffusers/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path" rel="nofollow"><code>pretrained_model_name_or_path</code></a> argument. You’ll also need to specify the dataset name in <code>DATASET_ID</code>:',Le,E,ke,H,Ct="Now, we can launch training. The script saves all the components (<code>feature_extractor</code>, <code>scheduler</code>, <code>text_encoder</code>, <code>unet</code>, etc) in a subfolder in your repository.",Ve,F,Ee,Q,Zt=`Additionally, we support performing validation inference to monitor training progress
with Weights and Biases. You can enable this feature with <code>report_to=&quot;wandb&quot;</code>:`,He,A,Fe,z,jt="We recommend this type of validation as it can be useful for model debugging. Note that you need <code>wandb</code> installed to use this. You can install <code>wandb</code> by running <code>pip install wandb</code>.",Qe,D,$t='<a href="https://wandb.ai/sayakpaul/instruct-pix2pix/runs/ctr3kovq" rel="nofollow">Here</a>, you can find an example training run that includes some validation samples and the training hyperparameters.',Ae,P,It="<strong><em>Note: In the original paper, the authors observed that even when the model is trained with an image resolution of 256x256, it generalizes well to bigger resolutions such as 512x512. This is likely because of the larger dataset they used during training.</em></strong>",ze,q,De,K,vt=`<code>accelerate</code> allows for seamless multi-GPU training. Follow the instructions <a href="https://huggingface.co/docs/accelerate/basic_tutorials/launch" rel="nofollow">here</a>
for running distributed training with <code>accelerate</code>. Here is an example command:`,Pe,O,qe,ee,Ke,te,Xt="Once training is complete, we can perform inference:",Oe,le,et,ne,Nt=`An example model repo obtained using this training script can be found
here - <a href="https://huggingface.co/sayakpaul/instruct-pix2pix" rel="nofollow">sayakpaul/instruct-pix2pix</a>.`,tt,ie,Rt=`We encourage you to play with the following three parameters to control
speed and quality during performance:`,lt,ae,Bt="<li><code>num_inference_steps</code></li> <li><code>image_guidance_scale</code></li> <li><code>guidance_scale</code></li>",nt,se,Yt=`Particularly, <code>image_guidance_scale</code> and <code>guidance_scale</code> can have a profound impact
on the generated (“edited”) image (see <a href="https://twitter.com/RisingSayak/status/1628392199196151808?s=20" rel="nofollow">here</a> for an example).`,it,pe,St='If you’re looking for some interesting ways to use the InstructPix2Pix training methodology, we welcome you to check out this blog post: <a href="https://huggingface.co/blog/instruction-tuning-sd" rel="nofollow">Instruction-tuning Stable Diffusion with InstructPix2Pix</a>.',at,re,st,oe,Gt='Training with <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">Stable Diffusion XL</a> is also supported via the <code>train_instruct_pix2pix_sdxl.py</code> script. Please refer to the docs <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/README_sdxl.md" rel="nofollow">here</a>.',pt,ue,rt;return T=new ce({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h1"}}),_=new ce({props:{title:"Running locally with PyTorch",local:"running-locally-with-pytorch",headingTag:"h2"}}),x=new ce({props:{title:"Installing the dependencies",local:"installing-the-dependencies",headingTag:"h3"}}),j=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC1lJTIwLg==",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install -e .`,wrap:!1}}),I=new y({props:{code:"Y2QlMjBleGFtcGxlcyUyRmluc3RydWN0X3BpeDJwaXg=",highlighted:'<span class="hljs-built_in">cd</span> examples/instruct_pix2pix',wrap:!1}}),X=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:"pip install -r requirements.txt",wrap:!1}}),R=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Y=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),G=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),L=new ce({props:{title:"Toy example",local:"toy-example",headingTag:"h3"}}),E=new y({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBZXhwb3J0JTIwREFUQVNFVF9JRCUzRCUyMmZ1c2luZyUyRmluc3RydWN0cGl4MnBpeC0xMDAwLXNhbXBsZXMlMjI=",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> DATASET_ID=<span class="hljs-string">&quot;fusing/instructpix2pix-1000-samples&quot;</span>`,wrap:!1}}),F=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMHRyYWluX2luc3RydWN0X3BpeDJwaXgucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTNEJTI0REFUQVNFVF9JRCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXNvbHV0aW9uJTNEMjU2JTIwLS1yYW5kb21fZmxpcCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDE1MDAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jaGVja3BvaW50aW5nX3N0ZXBzJTNENTAwMCUyMC0tY2hlY2twb2ludHNfdG90YWxfbGltaXQlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTNENWUtMDUlMjAtLW1heF9ncmFkX25vcm0lM0QxJTIwLS1scl93YXJtdXBfc3RlcHMlM0QwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iJTNEMC4wNSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEZnAxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VlZCUzRDQyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> train_instruct_pix2pix.py \\
    --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
    --dataset_name=<span class="hljs-variable">$DATASET_ID</span> \\
    --enable_xformers_memory_efficient_attention \\
    --resolution=256 --random_flip \\
    --train_batch_size=4 --gradient_accumulation_steps=4 --gradient_checkpointing \\
    --max_train_steps=15000 \\
    --checkpointing_steps=5000 --checkpoints_total_limit=1 \\
    --learning_rate=5e-05 --max_grad_norm=1 --lr_warmup_steps=0 \\
    --conditioning_dropout_prob=0.05 \\
    --mixed_precision=fp16 \\
    --seed=42 \\
    --push_to_hub`,wrap:!1}}),A=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMHRyYWluX2luc3RydWN0X3BpeDJwaXgucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTNEJTI0REFUQVNFVF9JRCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXNvbHV0aW9uJTNEMjU2JTIwLS1yYW5kb21fZmxpcCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDE1MDAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jaGVja3BvaW50aW5nX3N0ZXBzJTNENTAwMCUyMC0tY2hlY2twb2ludHNfdG90YWxfbGltaXQlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTNENWUtMDUlMjAtLW1heF9ncmFkX25vcm0lM0QxJTIwLS1scl93YXJtdXBfc3RlcHMlM0QwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iJTNEMC4wNSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEZnAxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdmFsX2ltYWdlX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGaGYuY28lMkZkYXRhc2V0cyUyRmRpZmZ1c2VycyUyRmRpZmZ1c2Vycy1pbWFnZXMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGbW91bnRhaW4ucG5nJTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS12YWxpZGF0aW9uX3Byb21wdCUzRCUyMm1ha2UlMjB0aGUlMjBtb3VudGFpbnMlMjBzbm93eSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VlZCUzRDQyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXBvcnRfdG8lM0R3YW5kYiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcHVzaF90b19odWI=",highlighted:`accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> train_instruct_pix2pix.py \\
    --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
    --dataset_name=<span class="hljs-variable">$DATASET_ID</span> \\
    --enable_xformers_memory_efficient_attention \\
    --resolution=256 --random_flip \\
    --train_batch_size=4 --gradient_accumulation_steps=4 --gradient_checkpointing \\
    --max_train_steps=15000 \\
    --checkpointing_steps=5000 --checkpoints_total_limit=1 \\
    --learning_rate=5e-05 --max_grad_norm=1 --lr_warmup_steps=0 \\
    --conditioning_dropout_prob=0.05 \\
    --mixed_precision=fp16 \\
    --val_image_url=<span class="hljs-string">&quot;https://hf.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span> \\
    --validation_prompt=<span class="hljs-string">&quot;make the mountains snowy&quot;</span> \\
    --seed=42 \\
    --report_to=wandb \\
    --push_to_hub`,wrap:!1}}),q=new ce({props:{title:"Training with multiple GPUs",local:"training-with-multiple-gpus",headingTag:"h2"}}),O=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMC0tbXVsdGlfZ3B1JTIwdHJhaW5faW5zdHJ1Y3RfcGl4MnBpeC5weSUyMCU1QyUwQSUyMC0tcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0RydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMCU1QyUwQSUyMC0tZGF0YXNldF9uYW1lJTNEc2F5YWtwYXVsJTJGaW5zdHJ1Y3RwaXgycGl4LTEwMDAtc2FtcGxlcyUyMCU1QyUwQSUyMC0tdXNlX2VtYSUyMCU1QyUwQSUyMC0tZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uJTIwJTVDJTBBJTIwLS1yZXNvbHV0aW9uJTNENTEyJTIwLS1yYW5kb21fZmxpcCUyMCU1QyUwQSUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAtLW1heF90cmFpbl9zdGVwcyUzRDE1MDAwJTIwJTVDJTBBJTIwLS1jaGVja3BvaW50aW5nX3N0ZXBzJTNENTAwMCUyMC0tY2hlY2twb2ludHNfdG90YWxfbGltaXQlM0QxJTIwJTVDJTBBJTIwLS1sZWFybmluZ19yYXRlJTNENWUtMDUlMjAtLWxyX3dhcm11cF9zdGVwcyUzRDAlMjAlNUMlMEElMjAtLWNvbmRpdGlvbmluZ19kcm9wb3V0X3Byb2IlM0QwLjA1JTIwJTVDJTBBJTIwLS1taXhlZF9wcmVjaXNpb24lM0RmcDE2JTIwJTVDJTBBJTIwLS1zZWVkJTNENDIlMjAlNUMlMEElMjAtLXB1c2hfdG9faHVi",highlighted:`accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> --multi_gpu train_instruct_pix2pix.py \\
 --pretrained_model_name_or_path=runwayml/stable-diffusion-v1-5 \\
 --dataset_name=sayakpaul/instructpix2pix-1000-samples \\
 --use_ema \\
 --enable_xformers_memory_efficient_attention \\
 --resolution=512 --random_flip \\
 --train_batch_size=4 --gradient_accumulation_steps=4 --gradient_checkpointing \\
 --max_train_steps=15000 \\
 --checkpointing_steps=5000 --checkpoints_total_limit=1 \\
 --learning_rate=5e-05 --lr_warmup_steps=0 \\
 --conditioning_dropout_prob=0.05 \\
 --mixed_precision=fp16 \\
 --seed=42 \\
 --push_to_hub`,wrap:!1}}),ee=new ce({props:{title:"Inference",local:"inference",headingTag:"h2"}}),le=new y({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyeW91cl9tb2RlbF9pZCUyMiUyMCUyMCUyMyUyMCUzQy0lMjByZXBsYWNlJTIwdGhpcyUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnNheWFrcGF1bCUyRnNhbXBsZS1kYXRhc2V0cyUyRnJlc29sdmUlMkZtYWluJTJGdGVzdF9waXgycGl4XzQucG5nJTIyJTBBJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMGltYWdlJTIwJTNEJTIwUElMLkltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFBJTC5JbWFnZU9wcy5leGlmX3RyYW5zcG9zZShpbWFnZSklMEElMjAlMjAlMjBpbWFnZSUyMCUzRCUyMGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUyMCUyMCUyMHJldHVybiUyMGltYWdlJTBBJTBBJTBBaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTBBcHJvbXB0JTIwJTNEJTIwJTIyd2lwZSUyMG91dCUyMHRoZSUyMGxha2UlMjIlMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwMjAlMEFpbWFnZV9ndWlkYW5jZV9zY2FsZSUyMCUzRCUyMDEuNSUwQWd1aWRhbmNlX3NjYWxlJTIwJTNEJTIwMTAlMEElMEFlZGl0ZWRfaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEbnVtX2luZmVyZW5jZV9zdGVwcyUyQyUwQSUyMCUyMCUyMGltYWdlX2d1aWRhbmNlX3NjYWxlJTNEaW1hZ2VfZ3VpZGFuY2Vfc2NhbGUlMkMlMEElMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRGd1aWRhbmNlX3NjYWxlJTJDJTBBJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBZWRpdGVkX2ltYWdlLnNhdmUoJTIyZWRpdGVkX2ltYWdlLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline

model_id = <span class="hljs-string">&quot;your_model_id&quot;</span>  <span class="hljs-comment"># &lt;- replace this</span>
pipe = StableDiffusionInstructPix2PixPipeline.from_pretrained(
   model_id, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/test_pix2pix_4.png&quot;</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
   image = PIL.Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
   image = PIL.ImageOps.exif_transpose(image)
   image = image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)
   <span class="hljs-keyword">return</span> image


image = download_image(url)
prompt = <span class="hljs-string">&quot;wipe out the lake&quot;</span>
num_inference_steps = <span class="hljs-number">20</span>
image_guidance_scale = <span class="hljs-number">1.5</span>
guidance_scale = <span class="hljs-number">10</span>

edited_image = pipe(
   prompt,
   image=image,
   num_inference_steps=num_inference_steps,
   image_guidance_scale=image_guidance_scale,
   guidance_scale=guidance_scale,
   generator=generator,
).images[<span class="hljs-number">0</span>]
edited_image.save(<span class="hljs-string">&quot;edited_image.png&quot;</span>)`,wrap:!1}}),re=new ce({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),{c(){M=s("meta"),de=i(),me=s("p"),fe=i(),o(T.$$.fragment),ye=i(),J=s("p"),J.innerHTML=mt,Me=i(),h=s("p"),h.innerHTML=ut,he=i(),U=s("p"),U.textContent=dt,we=i(),w=s("p"),w.innerHTML=ft,Te=i(),g=s("p"),g.innerHTML=yt,Je=i(),b=s("p"),b.innerHTML=Mt,Ue=i(),o(_.$$.fragment),ge=i(),o(x.$$.fragment),be=i(),W=s("p"),W.textContent=ht,_e=i(),C=s("p"),C.innerHTML=wt,xe=i(),Z=s("p"),Z.innerHTML=Tt,We=i(),o(j.$$.fragment),Ce=i(),$=s("p"),$.textContent=Jt,Ze=i(),o(I.$$.fragment),je=i(),v=s("p"),v.textContent=Ut,$e=i(),o(X.$$.fragment),Ie=i(),N=s("p"),N.innerHTML=gt,ve=i(),o(R.$$.fragment),Xe=i(),B=s("p"),B.textContent=bt,Ne=i(),o(Y.$$.fragment),Re=i(),S=s("p"),S.textContent=_t,Be=i(),o(G.$$.fragment),Ye=i(),o(L.$$.fragment),Se=i(),k=s("p"),k.innerHTML=xt,Ge=i(),V=s("p"),V.innerHTML=Wt,Le=i(),o(E.$$.fragment),ke=i(),H=s("p"),H.innerHTML=Ct,Ve=i(),o(F.$$.fragment),Ee=i(),Q=s("p"),Q.innerHTML=Zt,He=i(),o(A.$$.fragment),Fe=i(),z=s("p"),z.innerHTML=jt,Qe=i(),D=s("p"),D.innerHTML=$t,Ae=i(),P=s("p"),P.innerHTML=It,ze=i(),o(q.$$.fragment),De=i(),K=s("p"),K.innerHTML=vt,Pe=i(),o(O.$$.fragment),qe=i(),o(ee.$$.fragment),Ke=i(),te=s("p"),te.textContent=Xt,Oe=i(),o(le.$$.fragment),et=i(),ne=s("p"),ne.innerHTML=Nt,tt=i(),ie=s("p"),ie.textContent=Rt,lt=i(),ae=s("ul"),ae.innerHTML=Bt,nt=i(),se=s("p"),se.innerHTML=Yt,it=i(),pe=s("p"),pe.innerHTML=St,at=i(),o(re.$$.fragment),st=i(),oe=s("p"),oe.innerHTML=Gt,pt=i(),ue=s("p"),this.h()},l(e){const t=Qt("svelte-u9bgzb",document.head);M=p(t,"META",{name:!0,content:!0}),t.forEach(l),de=a(e),me=p(e,"P",{}),Lt(me).forEach(l),fe=a(e),c(T.$$.fragment,e),ye=a(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-rvcs8b"&&(J.innerHTML=mt),Me=a(e),h=p(e,"P",{align:!0,"data-svelte-h":!0}),r(h)!=="svelte-boa587"&&(h.innerHTML=ut),he=a(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1ue6mnk"&&(U.textContent=dt),we=a(e),w=p(e,"P",{align:!0,"data-svelte-h":!0}),r(w)!=="svelte-5k7lrs"&&(w.innerHTML=ft),Te=a(e),g=p(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-ofa1ib"&&(g.innerHTML=yt),Je=a(e),b=p(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1yi2f71"&&(b.innerHTML=Mt),Ue=a(e),c(_.$$.fragment,e),ge=a(e),c(x.$$.fragment,e),be=a(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-19lpyev"&&(W.textContent=ht),_e=a(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-hai21j"&&(C.innerHTML=wt),xe=a(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-yv8b1i"&&(Z.innerHTML=Tt),We=a(e),c(j.$$.fragment,e),Ce=a(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-blzon4"&&($.textContent=Jt),Ze=a(e),c(I.$$.fragment,e),je=a(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1gehqux"&&(v.textContent=Ut),$e=a(e),c(X.$$.fragment,e),Ie=a(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1apictl"&&(N.innerHTML=gt),ve=a(e),c(R.$$.fragment,e),Xe=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1gl04sb"&&(B.textContent=bt),Ne=a(e),c(Y.$$.fragment,e),Re=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-wgvbkc"&&(S.textContent=_t),Be=a(e),c(G.$$.fragment,e),Ye=a(e),c(L.$$.fragment,e),Se=a(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1450gzw"&&(k.innerHTML=xt),Ge=a(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-pub3aq"&&(V.innerHTML=Wt),Le=a(e),c(E.$$.fragment,e),ke=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-lpm3b6"&&(H.innerHTML=Ct),Ve=a(e),c(F.$$.fragment,e),Ee=a(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-lh171p"&&(Q.innerHTML=Zt),He=a(e),c(A.$$.fragment,e),Fe=a(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1ngvvxh"&&(z.innerHTML=jt),Qe=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-ep8cx1"&&(D.innerHTML=$t),Ae=a(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-fvnmbv"&&(P.innerHTML=It),ze=a(e),c(q.$$.fragment,e),De=a(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1tkye3l"&&(K.innerHTML=vt),Pe=a(e),c(O.$$.fragment,e),qe=a(e),c(ee.$$.fragment,e),Ke=a(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-109q2no"&&(te.textContent=Xt),Oe=a(e),c(le.$$.fragment,e),et=a(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-11ipsjg"&&(ne.innerHTML=Nt),tt=a(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1jap03f"&&(ie.textContent=Rt),lt=a(e),ae=p(e,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-1k7xfoe"&&(ae.innerHTML=Bt),nt=a(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-9uns02"&&(se.innerHTML=Yt),it=a(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-xahvpu"&&(pe.innerHTML=St),at=a(e),c(re.$$.fragment,e),st=a(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1g4l1qf"&&(oe.innerHTML=Gt),pt=a(e),ue=p(e,"P",{}),Lt(ue).forEach(l),this.h()},h(){ot(M,"name","hf:doc:metadata"),ot(M,"content",Dt),ot(h,"align","center"),ot(w,"align","center")},m(e,t){At(document.head,M),n(e,de,t),n(e,me,t),n(e,fe,t),m(T,e,t),n(e,ye,t),n(e,J,t),n(e,Me,t),n(e,h,t),n(e,he,t),n(e,U,t),n(e,we,t),n(e,w,t),n(e,Te,t),n(e,g,t),n(e,Je,t),n(e,b,t),n(e,Ue,t),m(_,e,t),n(e,ge,t),m(x,e,t),n(e,be,t),n(e,W,t),n(e,_e,t),n(e,C,t),n(e,xe,t),n(e,Z,t),n(e,We,t),m(j,e,t),n(e,Ce,t),n(e,$,t),n(e,Ze,t),m(I,e,t),n(e,je,t),n(e,v,t),n(e,$e,t),m(X,e,t),n(e,Ie,t),n(e,N,t),n(e,ve,t),m(R,e,t),n(e,Xe,t),n(e,B,t),n(e,Ne,t),m(Y,e,t),n(e,Re,t),n(e,S,t),n(e,Be,t),m(G,e,t),n(e,Ye,t),m(L,e,t),n(e,Se,t),n(e,k,t),n(e,Ge,t),n(e,V,t),n(e,Le,t),m(E,e,t),n(e,ke,t),n(e,H,t),n(e,Ve,t),m(F,e,t),n(e,Ee,t),n(e,Q,t),n(e,He,t),m(A,e,t),n(e,Fe,t),n(e,z,t),n(e,Qe,t),n(e,D,t),n(e,Ae,t),n(e,P,t),n(e,ze,t),m(q,e,t),n(e,De,t),n(e,K,t),n(e,Pe,t),m(O,e,t),n(e,qe,t),m(ee,e,t),n(e,Ke,t),n(e,te,t),n(e,Oe,t),m(le,e,t),n(e,et,t),n(e,ne,t),n(e,tt,t),n(e,ie,t),n(e,lt,t),n(e,ae,t),n(e,nt,t),n(e,se,t),n(e,it,t),n(e,pe,t),n(e,at,t),m(re,e,t),n(e,st,t),n(e,oe,t),n(e,pt,t),n(e,ue,t),rt=!0},p:Vt,i(e){rt||(u(T.$$.fragment,e),u(_.$$.fragment,e),u(x.$$.fragment,e),u(j.$$.fragment,e),u(I.$$.fragment,e),u(X.$$.fragment,e),u(R.$$.fragment,e),u(Y.$$.fragment,e),u(G.$$.fragment,e),u(L.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(A.$$.fragment,e),u(q.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),rt=!0)},o(e){d(T.$$.fragment,e),d(_.$$.fragment,e),d(x.$$.fragment,e),d(j.$$.fragment,e),d(I.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(Y.$$.fragment,e),d(G.$$.fragment,e),d(L.$$.fragment,e),d(E.$$.fragment,e),d(F.$$.fragment,e),d(A.$$.fragment,e),d(q.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(re.$$.fragment,e),rt=!1},d(e){e&&(l(de),l(me),l(fe),l(ye),l(J),l(Me),l(h),l(he),l(U),l(we),l(w),l(Te),l(g),l(Je),l(b),l(Ue),l(ge),l(be),l(W),l(_e),l(C),l(xe),l(Z),l(We),l(Ce),l($),l(Ze),l(je),l(v),l($e),l(Ie),l(N),l(ve),l(Xe),l(B),l(Ne),l(Re),l(S),l(Be),l(Ye),l(Se),l(k),l(Ge),l(V),l(Le),l(ke),l(H),l(Ve),l(Ee),l(Q),l(He),l(Fe),l(z),l(Qe),l(D),l(Ae),l(P),l(ze),l(De),l(K),l(Pe),l(qe),l(Ke),l(te),l(Oe),l(et),l(ne),l(tt),l(ie),l(lt),l(ae),l(nt),l(se),l(it),l(pe),l(at),l(st),l(oe),l(pt),l(ue)),l(M),f(T,e),f(_,e),f(x,e),f(j,e),f(I,e),f(X,e),f(R,e),f(Y,e),f(G,e),f(L,e),f(E,e),f(F,e),f(A,e),f(q,e),f(O,e),f(ee,e),f(le,e),f(re,e)}}}const Dt='{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[{"title":"Running locally with PyTorch","local":"running-locally-with-pytorch","sections":[{"title":"Installing the dependencies","local":"installing-the-dependencies","sections":[],"depth":3},{"title":"Toy example","local":"toy-example","sections":[],"depth":3}],"depth":2},{"title":"Training with multiple GPUs","local":"training-with-multiple-gpus","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2}],"depth":1}';function Pt(ct){return Et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tl extends Ht{constructor(M){super(),Ft(this,M,Pt,zt,kt,{})}}export{tl as component};
