import{S as bU,i as VU,s as QU,e as n,k as y,w as o,t,M as dU,c as p,d as s,m as j,x as i,a as J,h as M,b as c,N as cM,G as a,g as U,y as T,q as m,o as r,B as w,v as gU}from"../../chunks/vendor-hf-doc-builder.js";import{T as AU}from"../../chunks/Tip-hf-doc-builder.js";import{I as uU}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{C as h}from"../../chunks/CodeBlock-hf-doc-builder.js";import{D as EU}from"../../chunks/DocNotebookDropdown-hf-doc-builder.js";function RU(vs){let C,N,I,F,b;return{c(){C=n("p"),N=t("\u{1F4A1} \uC774 \uD559\uC2B5 \uD29C\uD1A0\uB9AC\uC5BC\uC740 "),I=n("a"),F=t("Training with \u{1F9E8} Diffusers"),b=t(" \uB178\uD2B8\uBD81 \uAE30\uBC18\uC73C\uB85C \uD569\uB2C8\uB2E4. Diffusion \uBAA8\uB378\uC758 \uC791\uB3D9 \uBC29\uC2DD \uBC0F \uC790\uC138\uD55C \uB0B4\uC6A9\uC740 \uB178\uD2B8\uBD81\uC744 \uD655\uC778\uD558\uC138\uC694!"),this.h()},l(f){C=p(f,"P",{});var V=J(C);N=M(V,"\u{1F4A1} \uC774 \uD559\uC2B5 \uD29C\uD1A0\uB9AC\uC5BC\uC740 "),I=p(V,"A",{href:!0,rel:!0});var g=J(I);F=M(g,"Training with \u{1F9E8} Diffusers"),g.forEach(s),b=M(V," \uB178\uD2B8\uBD81 \uAE30\uBC18\uC73C\uB85C \uD569\uB2C8\uB2E4. Diffusion \uBAA8\uB378\uC758 \uC791\uB3D9 \uBC29\uC2DD \uBC0F \uC790\uC138\uD55C \uB0B4\uC6A9\uC740 \uB178\uD2B8\uBD81\uC744 \uD655\uC778\uD558\uC138\uC694!"),V.forEach(s),this.h()},h(){c(I,"href","https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/training_example.ipynb"),c(I,"rel","nofollow")},m(f,V){U(f,C,V),a(C,N),a(C,I),a(I,F),a(C,b)},d(f){f&&s(C)}}}function BU(vs){let C,N,I,F,b,f,V,g,te,os,Me,Ss,D,Ue,P,ne,pe,Ws,A,Je,ll,ye,je,is,ce,oe,zs,X,Ys,E,ie,sl,Te,me,al,re,we,Os,el,$s,v,he,tl,Ce,Ie,Hs,Ml,xs,Nl,fe,qs,Ul,Ks,S,ue,nl,be,Ve,Ls,pl,Ps,Jl,Qe,la,W,de,Ts,ge,Ae,sa,yl,aa,jl,Ee,ea,z,Re,cl,Be,_e,ta,ol,Ma,u,ke,il,Ze,Ge,Tl,ms,Ne,Fe,rs,De,Xe,ws,ve,Se,Ua,R,We,hs,ze,Ye,ml,Cs,Oe,$e,na,rl,pa,Fl,Is,oM,Ja,Dl,He,ya,B,Y,fs,xe,qe,us,Ke,Le,Pe,Xl,bs,lt,st,at,vl,Vs,et,tt,ja,wl,ca,_,Mt,Qs,Ut,nt,ds,pt,Jt,oa,hl,ia,O,yt,Cl,jt,ct,Ta,Il,ma,G,$,gs,fl,ot,As,it,ra,H,Tt,Es,mt,rt,wa,ul,ha,Sl,wt,Ca,bl,Ia,Wl,ht,fa,Vl,Ct,ua,k,It,Rs,ft,ut,Bs,bt,Vt,ba,d,_s,Qt,dt,ks,gt,At,Zs,Et,Rt,Va,Ql,Qa,zl,Gs,iM,da,Yl,Bt,ga,dl,Aa,gl,_t,Ea,Ol,kt,Ra,$l,Zt,Ba,Al,_a,x,Gt,Ns,Nt,Ft,ka,El,Za,Hl,Dt,Ga,xl,Xt,Na,Rl,Fa,q,vt,Fs,St,Wt,Da,Bl,Xa,ql,zt,va,_l,Sa,Kl,Ds,TM,Wa,kl,Yt,za,K,Ot,Ll,$t,Ht,Ya,Q,Pl,ls,xt,qt,Kt,ss,as,Lt,Pt,lM,es,ts,sM,aM,eM,Ms,Us,tM,MM,Oa;return I=new EU({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/basic_training.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/basic_training.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/basic_training.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/basic_training.ipynb"}]}}),g=new uU({}),X=new AU({props:{$$slots:{default:[RU]},$$scope:{ctx:vs}}}),el=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkaWZmdXNlcnMlNUJ0cmFpbmluZyU1RA==",highlighted:"!pip install diffusers[training]"}}),Ml=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`}}),Ul=new h({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login"}}),pl=new h({props:{code:"IXN1ZG8lMjBhcHQlMjAtcXElMjBpbnN0YWxsJTIwZ2l0LWxmcyUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`!sudo apt -qq install git-lfs
!git config --global credential.helper store`}}),yl=new h({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TrainingConfig</span>:
<span class="hljs-meta">... </span>    image_size = <span class="hljs-number">128</span>  <span class="hljs-comment"># \uC0DD\uC131\uB418\uB294 \uC774\uBBF8\uC9C0 \uD574\uC0C1\uB3C4</span>
<span class="hljs-meta">... </span>    train_batch_size = <span class="hljs-number">16</span>
<span class="hljs-meta">... </span>    eval_batch_size = <span class="hljs-number">16</span>  <span class="hljs-comment"># \uD3C9\uAC00 \uB3D9\uC548\uC5D0 \uC0D8\uD50C\uB9C1\uD560 \uC774\uBBF8\uC9C0 \uC218</span>
<span class="hljs-meta">... </span>    num_epochs = <span class="hljs-number">50</span>
<span class="hljs-meta">... </span>    gradient_accumulation_steps = <span class="hljs-number">1</span>
<span class="hljs-meta">... </span>    learning_rate = <span class="hljs-number">1e-4</span>
<span class="hljs-meta">... </span>    lr_warmup_steps = <span class="hljs-number">500</span>
<span class="hljs-meta">... </span>    save_image_epochs = <span class="hljs-number">10</span>
<span class="hljs-meta">... </span>    save_model_epochs = <span class="hljs-number">30</span>
<span class="hljs-meta">... </span>    mixed_precision = <span class="hljs-string">&quot;fp16&quot;</span>  <span class="hljs-comment"># \`no\`\uB294 float32, \uC790\uB3D9 \uD63C\uD569 \uC815\uBC00\uB3C4\uB97C \uC704\uD55C \`fp16\`</span>
<span class="hljs-meta">... </span>    output_dir = <span class="hljs-string">&quot;ddpm-butterflies-128&quot;</span>  <span class="hljs-comment"># \uB85C\uCEEC \uBC0F HF Hub\uC5D0 \uC800\uC7A5\uB418\uB294 \uBAA8\uB378\uBA85</span>

<span class="hljs-meta">... </span>    push_to_hub = <span class="hljs-literal">True</span>  <span class="hljs-comment"># \uC800\uC7A5\uB41C \uBAA8\uB378\uC744 HF Hub\uC5D0 \uC5C5\uB85C\uB4DC\uD560\uC9C0 \uC5EC\uBD80</span>
<span class="hljs-meta">... </span>    hub_private_repo = <span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>    overwrite_output_dir = <span class="hljs-literal">True</span>  <span class="hljs-comment"># \uB178\uD2B8\uBD81\uC744 \uB2E4\uC2DC \uC2E4\uD589\uD560 \uB54C \uC774\uC804 \uBAA8\uB378\uC5D0 \uB36E\uC5B4\uC50C\uC6B8\uC9C0</span>
<span class="hljs-meta">... </span>    seed = <span class="hljs-number">0</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>config = TrainingConfig()`}}),ol=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBY29uZmlnLmRhdGFzZXRfbmFtZSUyMCUzRCUyMCUyMmh1Z2dhbiUyRnNtaXRoc29uaWFuX2J1dHRlcmZsaWVzX3N1YnNldCUyMiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoY29uZmlnLmRhdGFzZXRfbmFtZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>config.dataset_name = <span class="hljs-string">&quot;huggan/smithsonian_butterflies_subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(config.dataset_name, split=<span class="hljs-string">&quot;train&quot;</span>)`}}),rl=new h({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4cyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwNCUyQyUyMGZpZ3NpemUlM0QoMTYlMkMlMjA0KSklMEFmb3IlMjBpJTJDJTIwaW1hZ2UlMjBpbiUyMGVudW1lcmF0ZShkYXRhc2V0JTVCJTNBNCU1RCU1QiUyMmltYWdlJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuaW1zaG93KGltYWdlKSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuc2V0X2F4aXNfb2ZmKCklMEFmaWcuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataset[:<span class="hljs-number">4</span>][<span class="hljs-string">&quot;image&quot;</span>]):
<span class="hljs-meta">... </span>    axs[i].imshow(image)
<span class="hljs-meta">... </span>    axs[i].set_axis_off()
<span class="hljs-meta">&gt;&gt;&gt; </span>fig.show()`}}),wl=new h({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uJTIwaW1wb3J0JTIwdHJhbnNmb3JtcyUwQSUwQXByZXByb2Nlc3MlMjAlM0QlMjB0cmFuc2Zvcm1zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3Jtcy5SZXNpemUoKGNvbmZpZy5pbWFnZV9zaXplJTJDJTIwY29uZmlnLmltYWdlX3NpemUpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuTm9ybWFsaXplKCU1QjAuNSU1RCUyQyUyMCU1QjAuNSU1RCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocess = transforms.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        transforms.Resize((config.image_size, config.image_size)),
<span class="hljs-meta">... </span>        transforms.RandomHorizontalFlip(),
<span class="hljs-meta">... </span>        transforms.ToTensor(),
<span class="hljs-meta">... </span>        transforms.Normalize([<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>]),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`}}),hl=new h({props:{code:"ZGVmJTIwdHJhbnNmb3JtKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QnByZXByb2Nlc3MoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyaW1hZ2VzJTIyJTNBJTIwaW1hZ2VzJTdEJTBBJTBBJTBBZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    images = [preprocess(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;images&quot;</span>: images}


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(transform)`}}),Il=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwdG9yY2gudXRpbHMuZGF0YS5EYXRhTG9hZGVyKGRhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEY29uZmlnLnRyYWluX2JhdGNoX3NpemUlMkMlMjBzaHVmZmxlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = torch.utils.data.DataLoader(dataset, batch_size=config.train_batch_size, shuffle=<span class="hljs-literal">True</span>)`}}),fl=new uU({}),ul=new h({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel(
<span class="hljs-meta">... </span>    sample_size=config.image_size,  <span class="hljs-comment"># \uD0C0\uAC9F \uC774\uBBF8\uC9C0 \uD574\uC0C1\uB3C4</span>
<span class="hljs-meta">... </span>    in_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># \uC785\uB825 \uCC44\uB110 \uC218, RGB \uC774\uBBF8\uC9C0\uC5D0\uC11C 3</span>
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># \uCD9C\uB825 \uCC44\uB110 \uC218</span>
<span class="hljs-meta">... </span>    layers_per_block=<span class="hljs-number">2</span>,  <span class="hljs-comment"># UNet \uBE14\uB7ED\uB2F9 \uBA87 \uAC1C\uC758 ResNet \uB808\uC774\uC5B4\uAC00 \uC0AC\uC6A9\uB418\uB294\uC9C0</span>
<span class="hljs-meta">... </span>    block_out_channels=(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>),  <span class="hljs-comment"># \uAC01 UNet \uBE14\uB7ED\uC744 \uC704\uD55C \uCD9C\uB825 \uCC44\uB110 \uC218</span>
<span class="hljs-meta">... </span>    down_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,  <span class="hljs-comment"># \uC77C\uBC18\uC801\uC778 ResNet \uB2E4\uC6B4\uC0D8\uD50C\uB9C1 \uBE14\uB7ED</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,  <span class="hljs-comment"># spatial self-attention\uC774 \uD3EC\uD568\uB41C \uC77C\uBC18\uC801\uC778 ResNet \uB2E4\uC6B4\uC0D8\uD50C\uB9C1 \uBE14\uB7ED</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    up_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,  <span class="hljs-comment"># \uC77C\uBC18\uC801\uC778 ResNet \uC5C5\uC0D8\uD50C\uB9C1 \uBE14\uB7ED</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,  <span class="hljs-comment"># spatial self-attention\uC774 \uD3EC\uD568\uB41C \uC77C\uBC18\uC801\uC778 ResNet \uC5C5\uC0D8\uD50C\uB9C1 \uBE14\uB7ED</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)`}}),bl=new h({props:{code:"c2FtcGxlX2ltYWdlJTIwJTNEJTIwZGF0YXNldCU1QjAlNUQlNUIlMjJpbWFnZXMlMjIlNUQudW5zcXVlZXplKDApJTBBcHJpbnQoJTIySW5wdXQlMjBzaGFwZSUzQSUyMiUyQyUyMHNhbXBsZV9pbWFnZS5zaGFwZSklMEElMEFwcmludCglMjJPdXRwdXQlMjBzaGFwZSUzQSUyMiUyQyUyMG1vZGVsKHNhbXBsZV9pbWFnZSUyQyUyMHRpbWVzdGVwJTNEMCkuc2FtcGxlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>sample_image = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;images&quot;</span>].unsqueeze(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input shape:&quot;</span>, sample_image.shape)
Input shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Output shape:&quot;</span>, model(sample_image, timestep=<span class="hljs-number">0</span>).sample.shape)
Output shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])`}}),Ql=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERQTVNjaGVkdWxlciUwQSUwQW5vaXNlX3NjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIobnVtX3RyYWluX3RpbWVzdGVwcyUzRDEwMDApJTBBbm9pc2UlMjAlM0QlMjB0b3JjaC5yYW5kbihzYW1wbGVfaW1hZ2Uuc2hhcGUpJTBBdGltZXN0ZXBzJTIwJTNEJTIwdG9yY2guTG9uZ1RlbnNvciglNUI1MCU1RCklMEFub2lzeV9pbWFnZSUyMCUzRCUyMG5vaXNlX3NjaGVkdWxlci5hZGRfbm9pc2Uoc2FtcGxlX2ltYWdlJTJDJTIwbm9pc2UlMkMlMjB0aW1lc3RlcHMpJTBBJTBBSW1hZ2UuZnJvbWFycmF5KCgobm9pc3lfaW1hZ2UucGVybXV0ZSgwJTJDJTIwMiUyQyUyMDMlMkMlMjAxKSUyMCUyQiUyMDEuMCklMjAqJTIwMTI3LjUpLnR5cGUodG9yY2gudWludDgpLm51bXB5KCklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_scheduler = DDPMScheduler(num_train_timesteps=<span class="hljs-number">1000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn(sample_image.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span>timesteps = torch.LongTensor([<span class="hljs-number">50</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_image = noise_scheduler.add_noise(sample_image, noise, timesteps)

<span class="hljs-meta">&gt;&gt;&gt; </span>Image.fromarray(((noisy_image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>) + <span class="hljs-number">1.0</span>) * <span class="hljs-number">127.5</span>).<span class="hljs-built_in">type</span>(torch.uint8).numpy()[<span class="hljs-number">0</span>])`}}),dl=new h({props:{code:"aW1wb3J0JTIwdG9yY2gubm4uZnVuY3Rpb25hbCUyMGFzJTIwRiUwQSUwQW5vaXNlX3ByZWQlMjAlM0QlMjBtb2RlbChub2lzeV9pbWFnZSUyQyUyMHRpbWVzdGVwcykuc2FtcGxlJTBBbG9zcyUyMCUzRCUyMEYubXNlX2xvc3Mobm9pc2VfcHJlZCUyQyUyMG5vaXNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_pred = model(noisy_image, timesteps).sample
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = F.mse_loss(noise_pred, noise)`}}),Al=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5vcHRpbWl6YXRpb24lMjBpbXBvcnQlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0Rjb25maWcubGVhcm5pbmdfcmF0ZSklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0Rjb25maWcubHJfd2FybXVwX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEKGxlbih0cmFpbl9kYXRhbG9hZGVyKSUyMColMjBjb25maWcubnVtX2Vwb2NocyklMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.optimization <span class="hljs-keyword">import</span> get_cosine_schedule_with_warmup

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.AdamW(model.parameters(), lr=config.learning_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span>lr_scheduler = get_cosine_schedule_with_warmup(
<span class="hljs-meta">... </span>    optimizer=optimizer,
<span class="hljs-meta">... </span>    num_warmup_steps=config.lr_warmup_steps,
<span class="hljs-meta">... </span>    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * config.num_epochs),
<span class="hljs-meta">... </span>)`}}),El=new h({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> math
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">make_grid</span>(<span class="hljs-params">images, rows, cols</span>):
<span class="hljs-meta">... </span>    w, h = images[<span class="hljs-number">0</span>].size
<span class="hljs-meta">... </span>    grid = Image.new(<span class="hljs-string">&quot;RGB&quot;</span>, size=(cols * w, rows * h))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images):
<span class="hljs-meta">... </span>        grid.paste(image, box=(i % cols * w, i // cols * h))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> grid


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate</span>(<span class="hljs-params">config, epoch, pipeline</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># \uB79C\uB364\uD55C \uB178\uC774\uC988\uB85C \uBD80\uD130 \uC774\uBBF8\uC9C0\uB97C \uCD94\uCD9C\uD569\uB2C8\uB2E4.(\uC774\uB294 \uC5ED\uC804\uD30C diffusion \uACFC\uC815\uC785\uB2C8\uB2E4.)</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># \uAE30\uBCF8 \uD30C\uC774\uD504\uB77C\uC778 \uCD9C\uB825 \uD615\uD0DC\uB294 \`List[PIL.Image]\` \uC785\uB2C8\uB2E4.</span>
<span class="hljs-meta">... </span>    images = pipeline(
<span class="hljs-meta">... </span>        batch_size=config.eval_batch_size,
<span class="hljs-meta">... </span>        generator=torch.manual_seed(config.seed),
<span class="hljs-meta">... </span>    ).images

<span class="hljs-meta">... </span>    <span class="hljs-comment"># \uC774\uBBF8\uC9C0\uB4E4\uC744 \uADF8\uB9AC\uB4DC\uB85C \uB9CC\uB4E4\uC5B4\uC90D\uB2C8\uB2E4.</span>
<span class="hljs-meta">... </span>    image_grid = make_grid(images, rows=<span class="hljs-number">4</span>, cols=<span class="hljs-number">4</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># \uC774\uBBF8\uC9C0\uB4E4\uC744 \uC800\uC7A5\uD569\uB2C8\uB2E4.</span>
<span class="hljs-meta">... </span>    test_dir = os.path.join(config.output_dir, <span class="hljs-string">&quot;samples&quot;</span>)
<span class="hljs-meta">... </span>    os.makedirs(test_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    image_grid.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{test_dir}</span>/<span class="hljs-subst">{epoch:04d}</span>.png&quot;</span>)`}}),Rl=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBIZkZvbGRlciUyQyUyMFJlcG9zaXRvcnklMkMlMjB3aG9hbWklMEFmcm9tJTIwdHFkbS5hdXRvJTIwaW1wb3J0JTIwdHFkbSUwQWZyb20lMjBwYXRobGliJTIwaW1wb3J0JTIwUGF0aCUwQWltcG9ydCUyMG9zJTBBJTBBJTBBZGVmJTIwZ2V0X2Z1bGxfcmVwb19uYW1lKG1vZGVsX2lkJTNBJTIwc3RyJTJDJTIwb3JnYW5pemF0aW9uJTNBJTIwc3RyJTIwJTNEJTIwTm9uZSUyQyUyMHRva2VuJTNBJTIwc3RyJTIwJTNEJTIwTm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMHRva2VuJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW4lMjAlM0QlMjBIZkZvbGRlci5nZXRfdG9rZW4oKSUwQSUyMCUyMCUyMCUyMGlmJTIwb3JnYW5pemF0aW9uJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdXNlcm5hbWUlMjAlM0QlMjB3aG9hbWkodG9rZW4pJTVCJTIybmFtZSUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjIlN0J1c2VybmFtZSU3RCUyRiU3Qm1vZGVsX2lkJTdEJTIyJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjIlN0Jvcmdhbml6YXRpb24lN0QlMkYlN0Jtb2RlbF9pZCU3RCUyMiUwQSUwQSUwQWRlZiUyMHRyYWluX2xvb3AoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBub2lzZV9zY2hlZHVsZXIlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGFjY2VsZXJhdG9yJUVDJTk5JTgwJTIwdGVuc29yYm9hcmQlMjAlRUIlQTElOUMlRUElQjklODUlMjAlRUMlQjQlODglRUElQjglQjAlRUQlOTklOTQlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1peGVkX3ByZWNpc2lvbiUzRGNvbmZpZy5taXhlZF9wcmVjaXNpb24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Rjb25maWcuZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9nX3dpdGglM0QlMjJ0ZW5zb3Jib2FyZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvZ2dpbmdfZGlyJTNEb3MucGF0aC5qb2luKGNvbmZpZy5vdXRwdXRfZGlyJTJDJTIwJTIybG9ncyUyMiklMkMlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwaWYlMjBhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGNvbmZpZy5wdXNoX3RvX2h1YiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9fbmFtZSUyMCUzRCUyMGdldF9mdWxsX3JlcG9fbmFtZShQYXRoKGNvbmZpZy5vdXRwdXRfZGlyKS5uYW1lKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG8lMjAlM0QlMjBSZXBvc2l0b3J5KGNvbmZpZy5vdXRwdXRfZGlyJTJDJTIwY2xvbmVfZnJvbSUzRHJlcG9fbmFtZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbGlmJTIwY29uZmlnLm91dHB1dF9kaXIlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcy5tYWtlZGlycyhjb25maWcub3V0cHV0X2RpciUyQyUyMGV4aXN0X29rJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5pbml0X3RyYWNrZXJzKCUyMnRyYWluX2V4YW1wbGUlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwJUVCJUFBJUE4JUVCJTkzJUEwJTIwJUVBJUIyJTgzJUVDJTlEJUI0JTIwJUVDJUE0JTgwJUVCJUI5JTg0JUVCJTkwJTk4JUVDJTk3JTg4JUVDJThBJUI1JUVCJThCJTg4JUVCJThCJUE0LiUwQSUyMCUyMCUyMCUyMCUyMyUyMCVFQSVCOCVCMCVFQyU5NiVCNSVFRCU5NSVCNCVFQyU5NSVCQyUyMCVFRCU5NSVBMCUyMCVFRCU4QSVCOSVFQyVBMCU5NSVFRCU5NSU5QyUyMCVFQyU4OCU5QyVFQyU4NCU5QyVFQiU4QSU5NCUyMCVFQyU5NyU4NiVFQyU5QyVCQyVFQiVBOSVCMCUyMCVFQyVBNCU4MCVFQiVCOSU4NCVFRCU5NSU5QyUyMCVFQiVCMCVBOSVFQiVCMiU5NSVFQyU5NyU5MCUyMCVFQyVBMCU5QyVFQSVCMyVCNSVFRCU5NSU5QyUyMCVFQSVCMiU4MyVFQSVCMyVCQyUyMCVFQiU4RiU5OSVFQyU5RCVCQyVFRCU5NSU5QyUyMCVFQyU4OCU5QyVFQyU4NCU5QyVFQiVBMSU5QyUyMCVFQSVCMCU5RCVFQyVCMiVCNCVFQyU5RCU5OCUyMCVFQyU5NSU5NSVFQyVCNiU5NSVFQyU5RCU4NCUyMCVFRCU5MiU4MCVFQiVBOSVCNCUyMCVFQiU5MCVBOSVFQiU4QiU4OCVFQiU4QiVBNC4lMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGxyX3NjaGVkdWxlciUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjBnbG9iYWxfc3RlcCUyMCUzRCUyMDAlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAlRUMlOUQlQjQlRUMlQTAlOUMlMjAlRUIlQUElQTglRUIlOEQlQjglRUMlOUQlODQlMjAlRUQlOTUlOTklRUMlOEElQjUlRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBJTIwJTIwJTIwJTIwZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKGNvbmZpZy5udW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0odG90YWwlM0RsZW4odHJhaW5fZGF0YWxvYWRlciklMkMlMjBkaXNhYmxlJTNEbm90JTIwYWNjZWxlcmF0b3IuaXNfbG9jYWxfbWFpbl9wcm9jZXNzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci5zZXRfZGVzY3JpcHRpb24oZiUyMkVwb2NoJTIwJTdCZXBvY2glN0QlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwc3RlcCUyQyUyMGJhdGNoJTIwaW4lMjBlbnVtZXJhdGUodHJhaW5fZGF0YWxvYWRlciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjbGVhbl9pbWFnZXMlMjAlM0QlMjBiYXRjaCU1QiUyMmltYWdlcyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMCVFQyU5RCVCNCVFQiVBRiVCOCVFQyVBNyU4MCVFQyU5NyU5MCUyMCVFQiU4RCU5NCVFRCU5NSVBMCUyMCVFQiU4NSVCOCVFQyU5RCVCNCVFQyVBNiU4OCVFQiVBNSVCQyUyMCVFQyU4MyU5OCVFRCU5NCU4QyVFQiVBNyU4MSVFRCU5NSVBOSVFQiU4QiU4OCVFQiU4QiVBNC4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub2lzZSUyMCUzRCUyMHRvcmNoLnJhbmRuKGNsZWFuX2ltYWdlcy5zaGFwZSkudG8oY2xlYW5faW1hZ2VzLmRldmljZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicyUyMCUzRCUyMGNsZWFuX2ltYWdlcy5zaGFwZSU1QjAlNUQlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlRUElQjAlODElMjAlRUMlOUQlQjQlRUIlQUYlQjglRUMlQTclODAlRUIlQTUlQkMlMjAlRUMlOUMlODQlRUQlOTUlOUMlMjAlRUIlOUUlOUMlRUIlOEQlQTQlRUQlOTUlOUMlMjAlRUQlODMlODAlRUMlOUUlODQlRUMlOEElQTQlRUQlODUlOUQodGltZXN0ZXApJUVDJTlEJTg0JTIwJUVDJTgzJTk4JUVEJTk0JThDJUVCJUE3JTgxJUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRpbWVzdGVwcyUyMCUzRCUyMHRvcmNoLnJhbmRpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyQyUyMG5vaXNlX3NjaGVkdWxlci5jb25maWcubnVtX3RyYWluX3RpbWVzdGVwcyUyQyUyMChicyUyQyklMkMlMjBkZXZpY2UlM0RjbGVhbl9pbWFnZXMuZGV2aWNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKS5sb25nKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlRUElQjAlODElMjAlRUQlODMlODAlRUMlOUUlODQlRUMlOEElQTQlRUQlODUlOUQlRUMlOUQlOTglMjAlRUIlODUlQjglRUMlOUQlQjQlRUMlQTYlODglMjAlRUQlODElQUMlRUElQjglQjAlRUMlOTclOTAlMjAlRUIlOTQlQjAlRUIlOUQlQkMlMjAlRUElQjklQTglRUIlODElOTclRUQlOTUlOUMlMjAlRUMlOUQlQjQlRUIlQUYlQjglRUMlQTclODAlRUMlOTclOTAlMjAlRUIlODUlQjglRUMlOUQlQjQlRUMlQTYlODglRUIlQTUlQkMlMjAlRUMlQjYlOTQlRUElQjAlODAlRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwKCVFQyU5RCVCNCVFQiU4QSU5NCUyMGZvd2FyZCUyMGRpZmZ1c2lvbiUyMCVFQSVCMyVCQyVFQyVBMCU5NSVFQyU5RSU4NSVFQiU4QiU4OCVFQiU4QiVBNC4pJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9pc3lfaW1hZ2VzJTIwJTNEJTIwbm9pc2Vfc2NoZWR1bGVyLmFkZF9ub2lzZShjbGVhbl9pbWFnZXMlMkMlMjBub2lzZSUyQyUyMHRpbWVzdGVwcyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aXRoJTIwYWNjZWxlcmF0b3IuYWNjdW11bGF0ZShtb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlRUIlODUlQjglRUMlOUQlQjQlRUMlQTYlODglRUIlQTUlQkMlMjAlRUIlQjAlOTglRUIlQjMlQjUlRUMlQTAlODElRUMlOUMlQkMlRUIlQTElOUMlMjAlRUMlOTglODglRUMlQjglQTElRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9pc2VfcHJlZCUyMCUzRCUyMG1vZGVsKG5vaXN5X2ltYWdlcyUyQyUyMHRpbWVzdGVwcyUyQyUyMHJldHVybl9kaWN0JTNERmFsc2UpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBGLm1zZV9sb3NzKG5vaXNlX3ByZWQlMkMlMjBub2lzZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmNsaXBfZ3JhZF9ub3JtXyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjAxLjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9ncyUyMCUzRCUyMCU3QiUyMmxvc3MlMjIlM0ElMjBsb3NzLmRldGFjaCgpLml0ZW0oKSUyQyUyMCUyMmxyJTIyJTNBJTIwbHJfc2NoZWR1bGVyLmdldF9sYXN0X2xyKCklNUIwJTVEJTJDJTIwJTIyc3RlcCUyMiUzQSUyMGdsb2JhbF9zdGVwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvZ3Jlc3NfYmFyLnNldF9wb3N0Zml4KCoqbG9ncyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5sb2cobG9ncyUyQyUyMHN0ZXAlM0RnbG9iYWxfc3RlcCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnbG9iYWxfc3RlcCUyMCUyQiUzRCUyMDElMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlRUElQjAlODElMjAlRUMlOTclOTAlRUQlOEYlQUMlRUQlODElQUMlRUElQjAlODAlMjAlRUIlODElOUQlRUIlODIlOUMlMjAlRUQlOUIlODQlMjBldmFsdWF0ZSgpJUVDJTk5JTgwJTIwJUVCJUFBJTg3JTIwJUVBJUIwJTgwJUVDJUE3JTgwJTIwJUVCJThEJUIwJUVCJUFBJUE4JTIwJUVDJTlEJUI0JUVCJUFGJUI4JUVDJUE3JTgwJUVCJUE1JUJDJTIwJUVDJTg0JUEwJUVEJTgzJTlEJUVDJUEwJTgxJUVDJTlDJUJDJUVCJUExJTlDJTIwJUVDJTgzJTk4JUVEJTk0JThDJUVCJUE3JTgxJUVEJTk1JTk4JUVBJUIzJUEwJTIwJUVCJUFBJUE4JUVCJThEJUI4JUVDJTlEJTg0JTIwJUVDJUEwJTgwJUVDJTlFJUE1JUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwYWNjZWxlcmF0b3IuaXNfbWFpbl9wcm9jZXNzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZWxpbmUlMjAlM0QlMjBERFBNUGlwZWxpbmUodW5ldCUzRGFjY2VsZXJhdG9yLnVud3JhcF9tb2RlbChtb2RlbCklMkMlMjBzY2hlZHVsZXIlM0Rub2lzZV9zY2hlZHVsZXIpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjAoZXBvY2glMjAlMkIlMjAxKSUyMCUyNSUyMGNvbmZpZy5zYXZlX2ltYWdlX2Vwb2NocyUyMCUzRCUzRCUyMDAlMjBvciUyMGVwb2NoJTIwJTNEJTNEJTIwY29uZmlnLm51bV9lcG9jaHMlMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV2YWx1YXRlKGNvbmZpZyUyQyUyMGVwb2NoJTJDJTIwcGlwZWxpbmUpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjAoZXBvY2glMjAlMkIlMjAxKSUyMCUyNSUyMGNvbmZpZy5zYXZlX21vZGVsX2Vwb2NocyUyMCUzRCUzRCUyMDAlMjBvciUyMGVwb2NoJTIwJTNEJTNEJTIwY29uZmlnLm51bV9lcG9jaHMlMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwY29uZmlnLnB1c2hfdG9faHViJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwby5wdXNoX3RvX2h1Yihjb21taXRfbWVzc2FnZSUzRGYlMjJFcG9jaCUyMCU3QmVwb2NoJTdEJTIyJTJDJTIwYmxvY2tpbmclM0RUcnVlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoY29uZmlnLm91dHB1dF9kaXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFolder, Repository, whoami
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_full_repo_name</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span>, organization: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, token: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> token <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>        token = HfFolder.get_token()
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> organization <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>        username = whoami(token)[<span class="hljs-string">&quot;name&quot;</span>]
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{username}</span>/<span class="hljs-subst">{model_id}</span>&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{organization}</span>/<span class="hljs-subst">{model_id}</span>&quot;</span>


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_loop</span>(<span class="hljs-params">config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># accelerator\uC640 tensorboard \uB85C\uAE45 \uCD08\uAE30\uD654</span>
<span class="hljs-meta">... </span>    accelerator = Accelerator(
<span class="hljs-meta">... </span>        mixed_precision=config.mixed_precision,
<span class="hljs-meta">... </span>        gradient_accumulation_steps=config.gradient_accumulation_steps,
<span class="hljs-meta">... </span>        log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>,
<span class="hljs-meta">... </span>        logging_dir=os.path.join(config.output_dir, <span class="hljs-string">&quot;logs&quot;</span>),
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>            repo_name = get_full_repo_name(Path(config.output_dir).name)
<span class="hljs-meta">... </span>            repo = Repository(config.output_dir, clone_from=repo_name)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">elif</span> config.output_dir <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>            os.makedirs(config.output_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>        accelerator.init_trackers(<span class="hljs-string">&quot;train_example&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># \uBAA8\uB4E0 \uAC83\uC774 \uC900\uBE44\uB418\uC5C8\uC2B5\uB2C8\uB2E4.</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># \uAE30\uC5B5\uD574\uC57C \uD560 \uD2B9\uC815\uD55C \uC21C\uC11C\uB294 \uC5C6\uC73C\uBA70 \uC900\uBE44\uD55C \uBC29\uBC95\uC5D0 \uC81C\uACF5\uD55C \uAC83\uACFC \uB3D9\uC77C\uD55C \uC21C\uC11C\uB85C \uAC1D\uCCB4\uC758 \uC555\uCD95\uC744 \uD480\uBA74 \uB429\uB2C8\uB2E4.</span>
<span class="hljs-meta">... </span>    model, optimizer, train_dataloader, lr_scheduler = accelerator.prepare(
<span class="hljs-meta">... </span>        model, optimizer, train_dataloader, lr_scheduler
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    global_step = <span class="hljs-number">0</span>

<span class="hljs-meta">... </span>    <span class="hljs-comment"># \uC774\uC81C \uBAA8\uB378\uC744 \uD559\uC2B5\uD569\uB2C8\uB2E4.</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config.num_epochs):
<span class="hljs-meta">... </span>        progress_bar = tqdm(total=<span class="hljs-built_in">len</span>(train_dataloader), disable=<span class="hljs-keyword">not</span> accelerator.is_local_main_process)
<span class="hljs-meta">... </span>        progress_bar.set_description(<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_dataloader):
<span class="hljs-meta">... </span>            clean_images = batch[<span class="hljs-string">&quot;images&quot;</span>]
<span class="hljs-meta">... </span>            <span class="hljs-comment"># \uC774\uBBF8\uC9C0\uC5D0 \uB354\uD560 \uB178\uC774\uC988\uB97C \uC0D8\uD50C\uB9C1\uD569\uB2C8\uB2E4.</span>
<span class="hljs-meta">... </span>            noise = torch.randn(clean_images.shape).to(clean_images.device)
<span class="hljs-meta">... </span>            bs = clean_images.shape[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>            <span class="hljs-comment"># \uAC01 \uC774\uBBF8\uC9C0\uB97C \uC704\uD55C \uB79C\uB364\uD55C \uD0C0\uC784\uC2A4\uD15D(timestep)\uC744 \uC0D8\uD50C\uB9C1\uD569\uB2C8\uB2E4.</span>
<span class="hljs-meta">... </span>            timesteps = torch.randint(
<span class="hljs-meta">... </span>                <span class="hljs-number">0</span>, noise_scheduler.config.num_train_timesteps, (bs,), device=clean_images.device
<span class="hljs-meta">... </span>            ).long()

<span class="hljs-meta">... </span>            <span class="hljs-comment"># \uAC01 \uD0C0\uC784\uC2A4\uD15D\uC758 \uB178\uC774\uC988 \uD06C\uAE30\uC5D0 \uB530\uB77C \uAE68\uB057\uD55C \uC774\uBBF8\uC9C0\uC5D0 \uB178\uC774\uC988\uB97C \uCD94\uAC00\uD569\uB2C8\uB2E4.</span>
<span class="hljs-meta">... </span>            <span class="hljs-comment"># (\uC774\uB294 foward diffusion \uACFC\uC815\uC785\uB2C8\uB2E4.)</span>
<span class="hljs-meta">... </span>            noisy_images = noise_scheduler.add_noise(clean_images, noise, timesteps)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">with</span> accelerator.accumulate(model):
<span class="hljs-meta">... </span>                <span class="hljs-comment"># \uB178\uC774\uC988\uB97C \uBC18\uBCF5\uC801\uC73C\uB85C \uC608\uCE21\uD569\uB2C8\uB2E4.</span>
<span class="hljs-meta">... </span>                noise_pred = model(noisy_images, timesteps, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>                loss = F.mse_loss(noise_pred, noise)
<span class="hljs-meta">... </span>                accelerator.backward(loss)

<span class="hljs-meta">... </span>                accelerator.clip_grad_norm_(model.parameters(), <span class="hljs-number">1.0</span>)
<span class="hljs-meta">... </span>                optimizer.step()
<span class="hljs-meta">... </span>                lr_scheduler.step()
<span class="hljs-meta">... </span>                optimizer.zero_grad()

<span class="hljs-meta">... </span>            progress_bar.update(<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>            logs = {<span class="hljs-string">&quot;loss&quot;</span>: loss.detach().item(), <span class="hljs-string">&quot;lr&quot;</span>: lr_scheduler.get_last_lr()[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;step&quot;</span>: global_step}
<span class="hljs-meta">... </span>            progress_bar.set_postfix(**logs)
<span class="hljs-meta">... </span>            accelerator.log(logs, step=global_step)
<span class="hljs-meta">... </span>            global_step += <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># \uAC01 \uC5D0\uD3EC\uD06C\uAC00 \uB05D\uB09C \uD6C4 evaluate()\uC640 \uBA87 \uAC00\uC9C0 \uB370\uBAA8 \uC774\uBBF8\uC9C0\uB97C \uC120\uD0DD\uC801\uC73C\uB85C \uC0D8\uD50C\uB9C1\uD558\uACE0 \uBAA8\uB378\uC744 \uC800\uC7A5\uD569\uB2C8\uB2E4.</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>            pipeline = DDPMPipeline(unet=accelerator.unwrap_model(model), scheduler=noise_scheduler)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_image_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                evaluate(config, epoch, pipeline)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_model_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>                    repo.push_to_hub(commit_message=<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>, blocking=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>                <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>                    pipeline.save_pretrained(config.output_dir)`}}),Bl=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQWFyZ3MlMjAlM0QlMjAoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBub2lzZV9zY2hlZHVsZXIlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyKSUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluX2xvb3AlMkMlMjBhcmdzJTJDJTIwbnVtX3Byb2Nlc3NlcyUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>args = (config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler)

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(train_loop, args, num_processes=<span class="hljs-number">1</span>)`}}),_l=new h({props:{code:"aW1wb3J0JTIwZ2xvYiUwQSUwQXNhbXBsZV9pbWFnZXMlMjAlM0QlMjBzb3J0ZWQoZ2xvYi5nbG9iKGYlMjIlN0Jjb25maWcub3V0cHV0X2RpciU3RCUyRnNhbXBsZXMlMkYqLnBuZyUyMikpJTBBSW1hZ2Uub3BlbihzYW1wbGVfaW1hZ2VzJTVCLTElNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> glob

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_images = <span class="hljs-built_in">sorted</span>(glob.glob(<span class="hljs-string">f&quot;<span class="hljs-subst">{config.output_dir}</span>/samples/*.png&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>Image.<span class="hljs-built_in">open</span>(sample_images[-<span class="hljs-number">1</span>])`}}),{c(){C=n("meta"),N=y(),o(I.$$.fragment),F=y(),b=n("h1"),f=n("a"),V=n("span"),o(g.$$.fragment),te=y(),os=n("span"),Me=t("Diffusion \uBAA8\uB378\uC744 \uD559\uC2B5\uD558\uAE30"),Ss=y(),D=n("p"),Ue=t("Unconditional \uC774\uBBF8\uC9C0 \uC0DD\uC131\uC740 \uD559\uC2B5\uC5D0 \uC0AC\uC6A9\uB41C \uB370\uC774\uD130\uC14B\uACFC \uC720\uC0AC\uD55C \uC774\uBBF8\uC9C0\uB97C \uC0DD\uC131\uD558\uB294 diffusion \uBAA8\uB378\uC5D0\uC11C \uC778\uAE30 \uC788\uB294 \uC5B4\uD50C\uB9AC\uCF00\uC774\uC158\uC785\uB2C8\uB2E4. \uC77C\uBC18\uC801\uC73C\uB85C, \uAC00\uC7A5 \uC88B\uC740 \uACB0\uACFC\uB294 \uD2B9\uC815 \uB370\uC774\uD130\uC14B\uC5D0 \uC0AC\uC804 \uD6C8\uB828\uB41C \uBAA8\uB378\uC744 \uD30C\uC778\uD29C\uB2DD\uD558\uB294 \uAC83\uC73C\uB85C \uC5BB\uC744 \uC218 \uC788\uC2B5\uB2C8\uB2E4. \uC774 "),P=n("a"),ne=t("\uD5C8\uBE0C"),pe=t("\uC5D0\uC11C \uC774\uB7EC\uD55C \uB9CE\uC740 \uCCB4\uD06C\uD3EC\uC778\uD2B8\uB97C \uCC3E\uC744 \uC218 \uC788\uC9C0\uB9CC, \uB9CC\uC57D \uB9C8\uC74C\uC5D0 \uB4DC\uB294 \uCCB4\uD06C\uD3EC\uC778\uD2B8\uB97C \uCC3E\uC9C0 \uBABB\uD588\uB2E4\uBA74, \uC5B8\uC81C\uB4E0\uC9C0 \uC2A4\uC2A4\uB85C \uD559\uC2B5\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4!"),Ws=y(),A=n("p"),Je=t("\uC774 \uD29C\uD1A0\uB9AC\uC5BC\uC740 \uB098\uB9CC\uC758 \u{1F98B} \uB098\uBE44 \u{1F98B}\uB97C \uC0DD\uC131\uD558\uAE30 \uC704\uD574 "),ll=n("a"),ye=t("Smithsonian Butterflies"),je=t(" \uB370\uC774\uD130\uC14B\uC758 \uD558\uC704 \uC9D1\uD569\uC5D0\uC11C "),is=n("code"),ce=t("UNet2DModel"),oe=t(" \uBAA8\uB378\uC744 \uD559\uC2B5\uD558\uB294 \uBC29\uBC95\uC744 \uAC00\uB974\uCCD0\uC904 \uAC83\uC785\uB2C8\uB2E4."),zs=y(),o(X.$$.fragment),Ys=y(),E=n("p"),ie=t("\uC2DC\uC791 \uC804\uC5D0, \u{1F917} Datasets\uC744 \uBD88\uB7EC\uC624\uACE0 \uC804\uCC98\uB9AC\uD558\uAE30 \uC704\uD574 \uB370\uC774\uD130\uC14B\uC774 \uC124\uCE58\uB418\uC5B4 \uC788\uB294\uC9C0 \uB2E4\uC218 GPU\uC5D0\uC11C \uD559\uC2B5\uC744 \uAC04\uC18C\uD654\uD558\uAE30 \uC704\uD574 \u{1F917} Accelerate \uAC00 \uC124\uCE58\uB418\uC5B4 \uC788\uB294\uC9C0 \uD655\uC778\uD558\uC138\uC694. \uADF8 \uD6C4 \uD559\uC2B5 \uBA54\uD2B8\uB9AD\uC744 \uC2DC\uAC01\uD654\uD558\uAE30 \uC704\uD574 "),sl=n("a"),Te=t("TensorBoard"),me=t("\uB97C \uB610\uD55C \uC124\uCE58\uD558\uC138\uC694. (\uB610\uD55C \uD559\uC2B5 \uCD94\uC801\uC744 \uC704\uD574 "),al=n("a"),re=t("Weights & Biases"),we=t("\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.)"),Os=y(),o(el.$$.fragment),$s=y(),v=n("p"),he=t("\uCEE4\uBBA4\uB2C8\uD2F0\uC5D0 \uBAA8\uB378\uC744 \uACF5\uC720\uD560 \uAC83\uC744 \uAD8C\uC7A5\uD558\uBA70, \uC774\uB97C \uC704\uD574\uC11C Hugging Face \uACC4\uC815\uC5D0 \uB85C\uADF8\uC778\uC744 \uD574\uC57C \uD569\uB2C8\uB2E4. (\uACC4\uC815\uC774 \uC5C6\uB2E4\uBA74 "),tl=n("a"),Ce=t("\uC5EC\uAE30"),Ie=t("\uC5D0\uC11C \uB9CC\uB4E4 \uC218 \uC788\uC2B5\uB2C8\uB2E4.) \uB178\uD2B8\uBD81\uC5D0\uC11C \uB85C\uADF8\uC778\uD560 \uC218 \uC788\uC73C\uBA70 \uBA54\uC2DC\uC9C0\uAC00 \uD45C\uC2DC\uB418\uBA74 \uD1A0\uD070\uC744 \uC785\uB825\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4."),Hs=y(),o(Ml.$$.fragment),xs=y(),Nl=n("p"),fe=t("\uB610\uB294 \uD130\uBBF8\uB110\uB85C \uB85C\uADF8\uC778\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4:"),qs=y(),o(Ul.$$.fragment),Ks=y(),S=n("p"),ue=t("\uBAA8\uB378 \uCCB4\uD06C\uD3EC\uC778\uD2B8\uAC00 \uC0C1\uB2F9\uD788 \uD06C\uAE30 \uB54C\uBB38\uC5D0 "),nl=n("a"),be=t("Git-LFS"),Ve=t("\uC5D0\uC11C \uB300\uC6A9\uB7C9 \uD30C\uC77C\uC758 \uBC84\uC804 \uAD00\uB9AC\uB97C \uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4."),Ls=y(),o(pl.$$.fragment),Ps=y(),Jl=n("h2"),Qe=t("\uD559\uC2B5 \uAD6C\uC131"),la=y(),W=n("p"),de=t("\uD3B8\uC758\uB97C \uC704\uD574 \uD559\uC2B5 \uD30C\uB77C\uBBF8\uD130\uB4E4\uC744 \uD3EC\uD568\uD55C "),Ts=n("code"),ge=t("TrainingConfig"),Ae=t(" \uD074\uB798\uC2A4\uB97C \uC0DD\uC131\uD569\uB2C8\uB2E4 (\uC790\uC720\uB86D\uAC8C \uC870\uC815 \uAC00\uB2A5):"),sa=y(),o(yl.$$.fragment),aa=y(),jl=n("h2"),Ee=t("\uB370\uC774\uD130\uC14B \uBD88\uB7EC\uC624\uAE30"),ea=y(),z=n("p"),Re=t("\u{1F917} Datasets \uB77C\uC774\uBE0C\uB7EC\uB9AC\uC640 "),cl=n("a"),Be=t("Smithsonian Butterflies"),_e=t(" \uB370\uC774\uD130\uC14B\uC744 \uC27D\uAC8C \uBD88\uB7EC\uC62C \uC218 \uC788\uC2B5\uB2C8\uB2E4."),ta=y(),o(ol.$$.fragment),Ma=y(),u=n("p"),ke=t("\u{1F4A1}"),il=n("a"),Ze=t("HugGan Community Event"),Ge=t(" \uC5D0\uC11C \uCD94\uAC00\uC758 \uB370\uC774\uD130\uC14B\uC744 \uCC3E\uAC70\uB098 \uB85C\uCEEC\uC758 "),Tl=n("a"),ms=n("code"),Ne=t("ImageFolder"),Fe=t("\uB97C \uB9CC\uB4E6\uC73C\uB85C\uC368 \uB098\uB9CC\uC758 \uB370\uC774\uD130\uC14B\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4. HugGan Community Event \uC5D0 \uAC00\uC838\uC628 \uB370\uC774\uD130\uC14B\uC758 \uACBD\uC6B0 \uB9AC\uD3EC\uC9C0\uD1A0\uB9AC\uC758 id\uB85C "),rs=n("code"),De=t("config.dataset_name"),Xe=t(" \uC744 \uC124\uC815\uD558\uACE0, \uB098\uB9CC\uC758 \uC774\uBBF8\uC9C0\uB97C \uC0AC\uC6A9\uD558\uB294 \uACBD\uC6B0 "),ws=n("code"),ve=t("imagefolder"),Se=t(" \uB97C \uC124\uC815\uD569\uB2C8\uB2E4."),Ua=y(),R=n("p"),We=t("\u{1F917} Datasets\uC740 "),hs=n("code"),ze=t("Image"),Ye=t(" \uAE30\uB2A5\uC744 \uC0AC\uC6A9\uD574 \uC790\uB3D9\uC73C\uB85C \uC774\uBBF8\uC9C0 \uB370\uC774\uD130\uB97C \uB514\uCF54\uB529\uD558\uACE0 "),ml=n("a"),Cs=n("code"),Oe=t("PIL.Image"),$e=t("\uB85C \uBD88\uB7EC\uC635\uB2C8\uB2E4. \uC774\uB97C \uC2DC\uAC01\uD654 \uD574\uBCF4\uBA74:"),na=y(),o(rl.$$.fragment),pa=y(),Fl=n("p"),Is=n("img"),Ja=y(),Dl=n("p"),He=t("\uC774\uBBF8\uC9C0\uB294 \uBAA8\uB450 \uB2E4\uB978 \uC0AC\uC774\uC988\uC774\uAE30 \uB54C\uBB38\uC5D0, \uC6B0\uC120 \uC804\uCC98\uB9AC\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4:"),ya=y(),B=n("ul"),Y=n("li"),fs=n("code"),xe=t("Resize"),qe=t(" \uB294 "),us=n("code"),Ke=t("config.image_size"),Le=t(" \uC5D0 \uC815\uC758\uB41C \uC774\uBBF8\uC9C0 \uC0AC\uC774\uC988\uB85C \uBCC0\uACBD\uD569\uB2C8\uB2E4."),Pe=y(),Xl=n("li"),bs=n("code"),lt=t("RandomHorizontalFlip"),st=t(" \uC740 \uB79C\uB364\uC801\uC73C\uB85C \uC774\uBBF8\uC9C0\uB97C \uBBF8\uB7EC\uB9C1\uD558\uC5EC \uB370\uC774\uD130\uC14B\uC744 \uBCF4\uAC15\uD569\uB2C8\uB2E4."),at=y(),vl=n("li"),Vs=n("code"),et=t("Normalize"),tt=t(" \uB294 \uBAA8\uB378\uC774 \uC608\uC0C1\uD558\uB294 [-1, 1] \uBC94\uC704\uB85C \uD53D\uC140 \uAC12\uC744 \uC7AC\uC870\uC815 \uD558\uB294\uB370 \uC911\uC694\uD569\uB2C8\uB2E4."),ja=y(),o(wl.$$.fragment),ca=y(),_=n("p"),Mt=t("\uD559\uC2B5 \uB3C4\uC911\uC5D0 "),Qs=n("code"),Ut=t("preprocess"),nt=t(" \uD568\uC218\uB97C \uC801\uC6A9\uD558\uB824\uBA74 \u{1F917} Datasets\uC758 "),ds=n("code"),pt=t("set_transform"),Jt=t(" \uBC29\uBC95\uC774 \uC0AC\uC6A9\uB429\uB2C8\uB2E4."),oa=y(),o(hl.$$.fragment),ia=y(),O=n("p"),yt=t("\uC774\uBBF8\uC9C0\uC758 \uD06C\uAE30\uAC00 \uC870\uC815\uB418\uC5C8\uB294\uC9C0 \uD655\uC778\uD558\uAE30 \uC704\uD574 \uC774\uBBF8\uC9C0\uB97C \uB2E4\uC2DC \uC2DC\uAC01\uD654\uD574\uBCF4\uC138\uC694. \uC774\uC81C "),Cl=n("a"),jt=t("DataLoader"),ct=t("\uC5D0 \uB370\uC774\uD130\uC14B\uC744 \uD3EC\uD568\uD574 \uD559\uC2B5\uD560 \uC900\uBE44\uAC00 \uB418\uC5C8\uC2B5\uB2C8\uB2E4!"),Ta=y(),o(Il.$$.fragment),ma=y(),G=n("h2"),$=n("a"),gs=n("span"),o(fl.$$.fragment),ot=y(),As=n("span"),it=t("UNet2DModel \uC0DD\uC131\uD558\uAE30"),ra=y(),H=n("p"),Tt=t("\u{1F9E8} Diffusers\uC5D0 \uC0AC\uC804\uD559\uC2B5\uB41C \uBAA8\uB378\uB4E4\uC740 \uBAA8\uB378 \uD074\uB798\uC2A4\uC5D0\uC11C \uC6D0\uD558\uB294 \uD30C\uB77C\uBBF8\uD130\uB85C \uC27D\uAC8C \uC0DD\uC131\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4. \uC608\uB97C \uB4E4\uC5B4, "),Es=n("code"),mt=t("UNet2DModel"),rt=t("\uB97C \uC0DD\uC131\uD558\uB824\uBA74:"),wa=y(),o(ul.$$.fragment),ha=y(),Sl=n("p"),wt=t("\uC0D8\uD50C\uC758 \uC774\uBBF8\uC9C0 \uD06C\uAE30\uC640 \uBAA8\uB378 \uCD9C\uB825 \uD06C\uAE30\uAC00 \uB9DE\uB294\uC9C0 \uBE60\uB974\uAC8C \uD655\uC778\uD558\uAE30 \uC704\uD55C \uC88B\uC740 \uC544\uC774\uB514\uC5B4\uAC00 \uC788\uC2B5\uB2C8\uB2E4:"),Ca=y(),o(bl.$$.fragment),Ia=y(),Wl=n("p"),ht=t("\uD6CC\uB96D\uD574\uC694! \uB2E4\uC74C, \uC774\uBBF8\uC9C0\uC5D0 \uC57D\uAC04\uC758 \uB178\uC774\uC988\uB97C \uB354\uD558\uAE30 \uC704\uD574 \uC2A4\uCF00\uC904\uB7EC\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4."),fa=y(),Vl=n("h2"),Ct=t("\uC2A4\uCF00\uC904\uB7EC \uC0DD\uC131\uD558\uAE30"),ua=y(),k=n("p"),It=t("\uC2A4\uCF00\uC904\uB7EC\uB294 \uBAA8\uB378\uC744 \uD559\uC2B5 \uB610\uB294 \uCD94\uB860\uC5D0 \uC0AC\uC6A9\uD558\uB294\uC9C0\uC5D0 \uB530\uB77C \uB2E4\uB974\uAC8C \uC791\uB3D9\uD569\uB2C8\uB2E4. \uCD94\uB860\uC2DC\uC5D0, \uC2A4\uCF00\uC904\uB7EC\uB294 \uB178\uC774\uC988\uB85C\uBD80\uD130 \uC774\uBBF8\uC9C0\uB97C \uC0DD\uC131\uD569\uB2C8\uB2E4. \uD559\uC2B5\uC2DC \uC2A4\uCF00\uC904\uB7EC\uB294 diffusion \uACFC\uC815\uC5D0\uC11C\uC758 \uD2B9\uC815 \uD3EC\uC778\uD2B8\uB85C\uBD80\uD130 \uBAA8\uB378\uC758 \uCD9C\uB825 \uB610\uB294 \uC0D8\uD50C\uC744 \uAC00\uC838\uC640 "),Rs=n("em"),ft=t("\uB178\uC774\uC988 \uC2A4\uCF00\uC904"),ut=t(" \uACFC "),Bs=n("em"),bt=t("\uC5C5\uB370\uC774\uD2B8 \uADDC\uCE59"),Vt=t("\uC5D0 \uB530\uB77C \uC774\uBBF8\uC9C0\uC5D0 \uB178\uC774\uC988\uB97C \uC801\uC6A9\uD569\uB2C8\uB2E4."),ba=y(),d=n("p"),_s=n("code"),Qt=t("DDPMScheduler"),dt=t("\uB97C \uBCF4\uBA74 \uC774\uC804\uC73C\uB85C\uBD80\uD130 "),ks=n("code"),gt=t("sample_image"),At=t("\uC5D0 \uB79C\uB364\uD55C \uB178\uC774\uC988\uB97C \uB354\uD558\uB294 "),Zs=n("code"),Et=t("add_noise"),Rt=t(" \uBA54\uC11C\uB4DC\uB97C \uC0AC\uC6A9\uD569\uB2C8\uB2E4:"),Va=y(),o(Ql.$$.fragment),Qa=y(),zl=n("p"),Gs=n("img"),da=y(),Yl=n("p"),Bt=t("\uBAA8\uB378\uC758 \uD559\uC2B5 \uBAA9\uC801\uC740 \uC774\uBBF8\uC9C0\uC5D0 \uB354\uD574\uC9C4 \uB178\uC774\uC988\uB97C \uC608\uCE21\uD558\uB294 \uAC83\uC785\uB2C8\uB2E4. \uC774 \uB2E8\uACC4\uC5D0\uC11C \uC190\uC2E4\uC740 \uB2E4\uC74C\uACFC \uAC19\uC774 \uACC4\uC0B0\uB420 \uC218 \uC788\uC2B5\uB2C8\uB2E4:"),ga=y(),o(dl.$$.fragment),Aa=y(),gl=n("h2"),_t=t("\uBAA8\uB378 \uD559\uC2B5\uD558\uAE30"),Ea=y(),Ol=n("p"),kt=t("\uC9C0\uAE08\uAE4C\uC9C0, \uBAA8\uB378 \uD559\uC2B5\uC744 \uC2DC\uC791\uD558\uAE30 \uC704\uD574 \uB9CE\uC740 \uBD80\uBD84\uC744 \uAC16\uCD94\uC5C8\uC73C\uBA70 \uC774\uC81C \uB0A8\uC740 \uAC83\uC740 \uBAA8\uB4E0 \uAC83\uC744 \uC870\uD569\uD558\uB294 \uAC83\uC785\uB2C8\uB2E4."),Ra=y(),$l=n("p"),Zt=t("\uC6B0\uC120 \uC635\uD2F0\uB9C8\uC774\uC800(optimizer)\uC640 \uD559\uC2B5\uB960 \uC2A4\uCF00\uC904\uB7EC(learning rate scheduler)\uAC00 \uD544\uC694\uD560 \uAC83\uC785\uB2C8\uB2E4:"),Ba=y(),o(Al.$$.fragment),_a=y(),x=n("p"),Gt=t("\uADF8 \uD6C4, \uBAA8\uB378\uC744 \uD3C9\uAC00\uD558\uB294 \uBC29\uBC95\uC774 \uD544\uC694\uD569\uB2C8\uB2E4. \uD3C9\uAC00\uB97C \uC704\uD574, "),Ns=n("code"),Nt=t("DDPMPipeline"),Ft=t("\uC744 \uC0AC\uC6A9\uD574 \uBC30\uCE58\uC758 \uC774\uBBF8\uC9C0 \uC0D8\uD50C\uB4E4\uC744 \uC0DD\uC131\uD558\uACE0 \uADF8\uB9AC\uB4DC \uD615\uD0DC\uB85C \uC800\uC7A5\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4:"),ka=y(),o(El.$$.fragment),Za=y(),Hl=n("p"),Dt=t("TensorBoard\uC5D0 \uB85C\uAE45, \uADF8\uB798\uB514\uC5B8\uD2B8 \uB204\uC801 \uBC0F \uD63C\uD569 \uC815\uBC00\uB3C4 \uD559\uC2B5\uC744 \uC27D\uAC8C \uC218\uD589\uD558\uAE30 \uC704\uD574 \u{1F917} Accelerate\uB97C \uD559\uC2B5 \uB8E8\uD504\uC5D0 \uD568\uAED8 \uC55E\uC11C \uB9D0\uD55C \uBAA8\uB4E0 \uAD6C\uC131 \uC815\uBCF4\uB4E4\uC744 \uBB36\uC5B4 \uC9C4\uD589\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4. \uD5C8\uBE0C\uC5D0 \uBAA8\uB378\uC744 \uC5C5\uB85C\uB4DC \uD558\uAE30 \uC704\uD574 \uB9AC\uD3EC\uC9C0\uD1A0\uB9AC \uC774\uB984 \uBC0F \uC815\uBCF4\uB97C \uAC00\uC838\uC624\uAE30 \uC704\uD55C \uD568\uC218\uB97C \uC791\uC131\uD558\uACE0 \uD5C8\uBE0C\uC5D0 \uC5C5\uB85C\uB4DC\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4."),Ga=y(),xl=n("p"),Xt=t("\u{1F4A1}\uC544\uB798\uC758 \uD559\uC2B5 \uB8E8\uD504\uB294 \uC5B4\uB835\uACE0 \uAE38\uC5B4 \uBCF4\uC77C \uC218 \uC788\uC9C0\uB9CC, \uB098\uC911\uC5D0 \uD55C \uC904\uC758 \uCF54\uB4DC\uB85C \uD559\uC2B5\uC744 \uD55C\uB2E4\uBA74 \uADF8\uB9CC\uD55C \uAC00\uCE58\uAC00 \uC788\uC744 \uAC83\uC785\uB2C8\uB2E4! \uB9CC\uC57D \uAE30\uB2E4\uB9AC\uC9C0 \uBABB\uD558\uACE0 \uC774\uBBF8\uC9C0\uB97C \uC0DD\uC131\uD558\uACE0 \uC2F6\uB2E4\uBA74, \uC544\uB798 \uCF54\uB4DC\uB97C \uC790\uC720\uB86D\uAC8C \uBD99\uC5EC\uB123\uACE0 \uC791\uB3D9\uC2DC\uD0A4\uBA74 \uB429\uB2C8\uB2E4. \u{1F917}"),Na=y(),o(Rl.$$.fragment),Fa=y(),q=n("p"),vt=t("\uD734, \uCF54\uB4DC\uAC00 \uAF64 \uB9CE\uC558\uB124\uC694! \uD558\uC9C0\uB9CC \u{1F917} Accelerate\uC758 "),Fs=n("code"),St=t("notebook_launcher"),Wt=t(" \uD568\uC218\uC640 \uD559\uC2B5\uC744 \uC2DC\uC791\uD560 \uC900\uBE44\uAC00 \uB418\uC5C8\uC2B5\uB2C8\uB2E4. \uD568\uC218\uC5D0 \uD559\uC2B5 \uB8E8\uD504, \uBAA8\uB4E0 \uD559\uC2B5 \uC778\uC218, \uD559\uC2B5\uC5D0 \uC0AC\uC6A9\uD560 \uD504\uB85C\uC138\uC2A4 \uC218(\uC0AC\uC6A9 \uAC00\uB2A5\uD55C GPU\uC758 \uC218\uB97C \uBCC0\uACBD\uD560 \uC218 \uC788\uC74C)\uB97C \uC804\uB2EC\uD569\uB2C8\uB2E4:"),Da=y(),o(Bl.$$.fragment),Xa=y(),ql=n("p"),zt=t("\uD55C\uBC88 \uD559\uC2B5\uC774 \uC644\uB8CC\uB418\uBA74, diffusion \uBAA8\uB378\uB85C \uC0DD\uC131\uB41C \uCD5C\uC885 \u{1F98B}\uC774\uBBF8\uC9C0\u{1F98B}\uB97C \uD655\uC778\uD574\uBCF4\uAE38 \uBC14\uB78D\uB2C8\uB2E4!"),va=y(),o(_l.$$.fragment),Sa=y(),Kl=n("p"),Ds=n("img"),Wa=y(),kl=n("h2"),Yt=t("\uB2E4\uC74C \uB2E8\uACC4"),za=y(),K=n("p"),Ot=t("Unconditional \uC774\uBBF8\uC9C0 \uC0DD\uC131\uC740 \uD559\uC2B5\uB420 \uC218 \uC788\uB294 \uC791\uC5C5 \uC911 \uD558\uB098\uC758 \uC608\uC2DC\uC785\uB2C8\uB2E4. \uB2E4\uB978 \uC791\uC5C5\uACFC \uD559\uC2B5 \uBC29\uBC95\uC740 "),Ll=n("a"),$t=t("\u{1F9E8} Diffusers \uD559\uC2B5 \uC608\uC2DC"),Ht=t(" \uD398\uC774\uC9C0\uC5D0\uC11C \uD655\uC778\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4. \uB2E4\uC74C\uC740 \uD559\uC2B5\uD560 \uC218 \uC788\uB294 \uBA87 \uAC00\uC9C0 \uC608\uC2DC\uC785\uB2C8\uB2E4:"),Ya=y(),Q=n("ul"),Pl=n("li"),ls=n("a"),xt=t("Textual Inversion"),qt=t(", \uD2B9\uC815 \uC2DC\uAC01\uC801 \uAC1C\uB150\uC744 \uD559\uC2B5\uC2DC\uCF1C \uC0DD\uC131\uB41C \uC774\uBBF8\uC9C0\uC5D0 \uD1B5\uD569\uC2DC\uD0A4\uB294 \uC54C\uACE0\uB9AC\uC998\uC785\uB2C8\uB2E4."),Kt=y(),ss=n("li"),as=n("a"),Lt=t("DreamBooth"),Pt=t(", \uC8FC\uC81C\uC5D0 \uB300\uD55C \uBA87 \uAC00\uC9C0 \uC785\uB825 \uC774\uBBF8\uC9C0\uB4E4\uC774 \uC8FC\uC5B4\uC9C0\uBA74 \uC8FC\uC81C\uC5D0 \uB300\uD55C \uAC1C\uC778\uD654\uB41C \uC774\uBBF8\uC9C0\uB97C \uC0DD\uC131\uD558\uAE30 \uC704\uD55C \uAE30\uC220\uC785\uB2C8\uB2E4."),lM=y(),es=n("li"),ts=n("a"),sM=t("Guide"),aM=t(" \uB370\uC774\uD130\uC14B\uC5D0 Stable Diffusion \uBAA8\uB378\uC744 \uD30C\uC778\uD29C\uB2DD\uD558\uB294 \uBC29\uBC95\uC785\uB2C8\uB2E4."),eM=y(),Ms=n("li"),Us=n("a"),tM=t("Guide"),MM=t("  LoRA\uB97C \uC0AC\uC6A9\uD574 \uB9E4\uC6B0 \uD070 \uBAA8\uB378\uC744 \uBE60\uB974\uAC8C \uD30C\uC778\uD29C\uB2DD\uD558\uAE30 \uC704\uD55C \uBA54\uBAA8\uB9AC \uD6A8\uC728\uC801\uC778 \uAE30\uC220\uC785\uB2C8\uB2E4."),this.h()},l(l){const e=dU('[data-svelte="svelte-1phssyn"]',document.head);C=p(e,"META",{name:!0,content:!0}),e.forEach(s),N=j(l),i(I.$$.fragment,l),F=j(l),b=p(l,"H1",{class:!0});var Zl=J(b);f=p(Zl,"A",{id:!0,class:!0,href:!0});var mM=J(f);V=p(mM,"SPAN",{});var rM=J(V);i(g.$$.fragment,rM),rM.forEach(s),mM.forEach(s),te=j(Zl),os=p(Zl,"SPAN",{});var wM=J(os);Me=M(wM,"Diffusion \uBAA8\uB378\uC744 \uD559\uC2B5\uD558\uAE30"),wM.forEach(s),Zl.forEach(s),Ss=j(l),D=p(l,"P",{});var $a=J(D);Ue=M($a,"Unconditional \uC774\uBBF8\uC9C0 \uC0DD\uC131\uC740 \uD559\uC2B5\uC5D0 \uC0AC\uC6A9\uB41C \uB370\uC774\uD130\uC14B\uACFC \uC720\uC0AC\uD55C \uC774\uBBF8\uC9C0\uB97C \uC0DD\uC131\uD558\uB294 diffusion \uBAA8\uB378\uC5D0\uC11C \uC778\uAE30 \uC788\uB294 \uC5B4\uD50C\uB9AC\uCF00\uC774\uC158\uC785\uB2C8\uB2E4. \uC77C\uBC18\uC801\uC73C\uB85C, \uAC00\uC7A5 \uC88B\uC740 \uACB0\uACFC\uB294 \uD2B9\uC815 \uB370\uC774\uD130\uC14B\uC5D0 \uC0AC\uC804 \uD6C8\uB828\uB41C \uBAA8\uB378\uC744 \uD30C\uC778\uD29C\uB2DD\uD558\uB294 \uAC83\uC73C\uB85C \uC5BB\uC744 \uC218 \uC788\uC2B5\uB2C8\uB2E4. \uC774 "),P=p($a,"A",{href:!0,rel:!0});var hM=J(P);ne=M(hM,"\uD5C8\uBE0C"),hM.forEach(s),pe=M($a,"\uC5D0\uC11C \uC774\uB7EC\uD55C \uB9CE\uC740 \uCCB4\uD06C\uD3EC\uC778\uD2B8\uB97C \uCC3E\uC744 \uC218 \uC788\uC9C0\uB9CC, \uB9CC\uC57D \uB9C8\uC74C\uC5D0 \uB4DC\uB294 \uCCB4\uD06C\uD3EC\uC778\uD2B8\uB97C \uCC3E\uC9C0 \uBABB\uD588\uB2E4\uBA74, \uC5B8\uC81C\uB4E0\uC9C0 \uC2A4\uC2A4\uB85C \uD559\uC2B5\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4!"),$a.forEach(s),Ws=j(l),A=p(l,"P",{});var ns=J(A);Je=M(ns,"\uC774 \uD29C\uD1A0\uB9AC\uC5BC\uC740 \uB098\uB9CC\uC758 \u{1F98B} \uB098\uBE44 \u{1F98B}\uB97C \uC0DD\uC131\uD558\uAE30 \uC704\uD574 "),ll=p(ns,"A",{href:!0,rel:!0});var CM=J(ll);ye=M(CM,"Smithsonian Butterflies"),CM.forEach(s),je=M(ns," \uB370\uC774\uD130\uC14B\uC758 \uD558\uC704 \uC9D1\uD569\uC5D0\uC11C "),is=p(ns,"CODE",{});var IM=J(is);ce=M(IM,"UNet2DModel"),IM.forEach(s),oe=M(ns," \uBAA8\uB378\uC744 \uD559\uC2B5\uD558\uB294 \uBC29\uBC95\uC744 \uAC00\uB974\uCCD0\uC904 \uAC83\uC785\uB2C8\uB2E4."),ns.forEach(s),zs=j(l),i(X.$$.fragment,l),Ys=j(l),E=p(l,"P",{});var ps=J(E);ie=M(ps,"\uC2DC\uC791 \uC804\uC5D0, \u{1F917} Datasets\uC744 \uBD88\uB7EC\uC624\uACE0 \uC804\uCC98\uB9AC\uD558\uAE30 \uC704\uD574 \uB370\uC774\uD130\uC14B\uC774 \uC124\uCE58\uB418\uC5B4 \uC788\uB294\uC9C0 \uB2E4\uC218 GPU\uC5D0\uC11C \uD559\uC2B5\uC744 \uAC04\uC18C\uD654\uD558\uAE30 \uC704\uD574 \u{1F917} Accelerate \uAC00 \uC124\uCE58\uB418\uC5B4 \uC788\uB294\uC9C0 \uD655\uC778\uD558\uC138\uC694. \uADF8 \uD6C4 \uD559\uC2B5 \uBA54\uD2B8\uB9AD\uC744 \uC2DC\uAC01\uD654\uD558\uAE30 \uC704\uD574 "),sl=p(ps,"A",{href:!0,rel:!0});var fM=J(sl);Te=M(fM,"TensorBoard"),fM.forEach(s),me=M(ps,"\uB97C \uB610\uD55C \uC124\uCE58\uD558\uC138\uC694. (\uB610\uD55C \uD559\uC2B5 \uCD94\uC801\uC744 \uC704\uD574 "),al=p(ps,"A",{href:!0,rel:!0});var uM=J(al);re=M(uM,"Weights & Biases"),uM.forEach(s),we=M(ps,"\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.)"),ps.forEach(s),Os=j(l),i(el.$$.fragment,l),$s=j(l),v=p(l,"P",{});var Ha=J(v);he=M(Ha,"\uCEE4\uBBA4\uB2C8\uD2F0\uC5D0 \uBAA8\uB378\uC744 \uACF5\uC720\uD560 \uAC83\uC744 \uAD8C\uC7A5\uD558\uBA70, \uC774\uB97C \uC704\uD574\uC11C Hugging Face \uACC4\uC815\uC5D0 \uB85C\uADF8\uC778\uC744 \uD574\uC57C \uD569\uB2C8\uB2E4. (\uACC4\uC815\uC774 \uC5C6\uB2E4\uBA74 "),tl=p(Ha,"A",{href:!0,rel:!0});var bM=J(tl);Ce=M(bM,"\uC5EC\uAE30"),bM.forEach(s),Ie=M(Ha,"\uC5D0\uC11C \uB9CC\uB4E4 \uC218 \uC788\uC2B5\uB2C8\uB2E4.) \uB178\uD2B8\uBD81\uC5D0\uC11C \uB85C\uADF8\uC778\uD560 \uC218 \uC788\uC73C\uBA70 \uBA54\uC2DC\uC9C0\uAC00 \uD45C\uC2DC\uB418\uBA74 \uD1A0\uD070\uC744 \uC785\uB825\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4."),Ha.forEach(s),Hs=j(l),i(Ml.$$.fragment,l),xs=j(l),Nl=p(l,"P",{});var VM=J(Nl);fe=M(VM,"\uB610\uB294 \uD130\uBBF8\uB110\uB85C \uB85C\uADF8\uC778\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4:"),VM.forEach(s),qs=j(l),i(Ul.$$.fragment,l),Ks=j(l),S=p(l,"P",{});var xa=J(S);ue=M(xa,"\uBAA8\uB378 \uCCB4\uD06C\uD3EC\uC778\uD2B8\uAC00 \uC0C1\uB2F9\uD788 \uD06C\uAE30 \uB54C\uBB38\uC5D0 "),nl=p(xa,"A",{href:!0,rel:!0});var QM=J(nl);be=M(QM,"Git-LFS"),QM.forEach(s),Ve=M(xa,"\uC5D0\uC11C \uB300\uC6A9\uB7C9 \uD30C\uC77C\uC758 \uBC84\uC804 \uAD00\uB9AC\uB97C \uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4."),xa.forEach(s),Ls=j(l),i(pl.$$.fragment,l),Ps=j(l),Jl=p(l,"H2",{id:!0});var dM=J(Jl);Qe=M(dM,"\uD559\uC2B5 \uAD6C\uC131"),dM.forEach(s),la=j(l),W=p(l,"P",{});var qa=J(W);de=M(qa,"\uD3B8\uC758\uB97C \uC704\uD574 \uD559\uC2B5 \uD30C\uB77C\uBBF8\uD130\uB4E4\uC744 \uD3EC\uD568\uD55C "),Ts=p(qa,"CODE",{});var gM=J(Ts);ge=M(gM,"TrainingConfig"),gM.forEach(s),Ae=M(qa," \uD074\uB798\uC2A4\uB97C \uC0DD\uC131\uD569\uB2C8\uB2E4 (\uC790\uC720\uB86D\uAC8C \uC870\uC815 \uAC00\uB2A5):"),qa.forEach(s),sa=j(l),i(yl.$$.fragment,l),aa=j(l),jl=p(l,"H2",{id:!0});var AM=J(jl);Ee=M(AM,"\uB370\uC774\uD130\uC14B \uBD88\uB7EC\uC624\uAE30"),AM.forEach(s),ea=j(l),z=p(l,"P",{});var Ka=J(z);Re=M(Ka,"\u{1F917} Datasets \uB77C\uC774\uBE0C\uB7EC\uB9AC\uC640 "),cl=p(Ka,"A",{href:!0,rel:!0});var EM=J(cl);Be=M(EM,"Smithsonian Butterflies"),EM.forEach(s),_e=M(Ka," \uB370\uC774\uD130\uC14B\uC744 \uC27D\uAC8C \uBD88\uB7EC\uC62C \uC218 \uC788\uC2B5\uB2C8\uB2E4."),Ka.forEach(s),ta=j(l),i(ol.$$.fragment,l),Ma=j(l),u=p(l,"P",{});var Z=J(u);ke=M(Z,"\u{1F4A1}"),il=p(Z,"A",{href:!0,rel:!0});var RM=J(il);Ze=M(RM,"HugGan Community Event"),RM.forEach(s),Ge=M(Z," \uC5D0\uC11C \uCD94\uAC00\uC758 \uB370\uC774\uD130\uC14B\uC744 \uCC3E\uAC70\uB098 \uB85C\uCEEC\uC758 "),Tl=p(Z,"A",{href:!0,rel:!0});var BM=J(Tl);ms=p(BM,"CODE",{});var _M=J(ms);Ne=M(_M,"ImageFolder"),_M.forEach(s),BM.forEach(s),Fe=M(Z,"\uB97C \uB9CC\uB4E6\uC73C\uB85C\uC368 \uB098\uB9CC\uC758 \uB370\uC774\uD130\uC14B\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4. HugGan Community Event \uC5D0 \uAC00\uC838\uC628 \uB370\uC774\uD130\uC14B\uC758 \uACBD\uC6B0 \uB9AC\uD3EC\uC9C0\uD1A0\uB9AC\uC758 id\uB85C "),rs=p(Z,"CODE",{});var kM=J(rs);De=M(kM,"config.dataset_name"),kM.forEach(s),Xe=M(Z," \uC744 \uC124\uC815\uD558\uACE0, \uB098\uB9CC\uC758 \uC774\uBBF8\uC9C0\uB97C \uC0AC\uC6A9\uD558\uB294 \uACBD\uC6B0 "),ws=p(Z,"CODE",{});var ZM=J(ws);ve=M(ZM,"imagefolder"),ZM.forEach(s),Se=M(Z," \uB97C \uC124\uC815\uD569\uB2C8\uB2E4."),Z.forEach(s),Ua=j(l),R=p(l,"P",{});var Js=J(R);We=M(Js,"\u{1F917} Datasets\uC740 "),hs=p(Js,"CODE",{});var GM=J(hs);ze=M(GM,"Image"),GM.forEach(s),Ye=M(Js," \uAE30\uB2A5\uC744 \uC0AC\uC6A9\uD574 \uC790\uB3D9\uC73C\uB85C \uC774\uBBF8\uC9C0 \uB370\uC774\uD130\uB97C \uB514\uCF54\uB529\uD558\uACE0 "),ml=p(Js,"A",{href:!0,rel:!0});var NM=J(ml);Cs=p(NM,"CODE",{});var FM=J(Cs);Oe=M(FM,"PIL.Image"),FM.forEach(s),NM.forEach(s),$e=M(Js,"\uB85C \uBD88\uB7EC\uC635\uB2C8\uB2E4. \uC774\uB97C \uC2DC\uAC01\uD654 \uD574\uBCF4\uBA74:"),Js.forEach(s),na=j(l),i(rl.$$.fragment,l),pa=j(l),Fl=p(l,"P",{});var DM=J(Fl);Is=p(DM,"IMG",{src:!0}),DM.forEach(s),Ja=j(l),Dl=p(l,"P",{});var XM=J(Dl);He=M(XM,"\uC774\uBBF8\uC9C0\uB294 \uBAA8\uB450 \uB2E4\uB978 \uC0AC\uC774\uC988\uC774\uAE30 \uB54C\uBB38\uC5D0, \uC6B0\uC120 \uC804\uCC98\uB9AC\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4:"),XM.forEach(s),ya=j(l),B=p(l,"UL",{});var ys=J(B);Y=p(ys,"LI",{});var Xs=J(Y);fs=p(Xs,"CODE",{});var vM=J(fs);xe=M(vM,"Resize"),vM.forEach(s),qe=M(Xs," \uB294 "),us=p(Xs,"CODE",{});var SM=J(us);Ke=M(SM,"config.image_size"),SM.forEach(s),Le=M(Xs," \uC5D0 \uC815\uC758\uB41C \uC774\uBBF8\uC9C0 \uC0AC\uC774\uC988\uB85C \uBCC0\uACBD\uD569\uB2C8\uB2E4."),Xs.forEach(s),Pe=j(ys),Xl=p(ys,"LI",{});var UM=J(Xl);bs=p(UM,"CODE",{});var WM=J(bs);lt=M(WM,"RandomHorizontalFlip"),WM.forEach(s),st=M(UM," \uC740 \uB79C\uB364\uC801\uC73C\uB85C \uC774\uBBF8\uC9C0\uB97C \uBBF8\uB7EC\uB9C1\uD558\uC5EC \uB370\uC774\uD130\uC14B\uC744 \uBCF4\uAC15\uD569\uB2C8\uB2E4."),UM.forEach(s),at=j(ys),vl=p(ys,"LI",{});var nM=J(vl);Vs=p(nM,"CODE",{});var zM=J(Vs);et=M(zM,"Normalize"),zM.forEach(s),tt=M(nM," \uB294 \uBAA8\uB378\uC774 \uC608\uC0C1\uD558\uB294 [-1, 1] \uBC94\uC704\uB85C \uD53D\uC140 \uAC12\uC744 \uC7AC\uC870\uC815 \uD558\uB294\uB370 \uC911\uC694\uD569\uB2C8\uB2E4."),nM.forEach(s),ys.forEach(s),ja=j(l),i(wl.$$.fragment,l),ca=j(l),_=p(l,"P",{});var js=J(_);Mt=M(js,"\uD559\uC2B5 \uB3C4\uC911\uC5D0 "),Qs=p(js,"CODE",{});var YM=J(Qs);Ut=M(YM,"preprocess"),YM.forEach(s),nt=M(js," \uD568\uC218\uB97C \uC801\uC6A9\uD558\uB824\uBA74 \u{1F917} Datasets\uC758 "),ds=p(js,"CODE",{});var OM=J(ds);pt=M(OM,"set_transform"),OM.forEach(s),Jt=M(js," \uBC29\uBC95\uC774 \uC0AC\uC6A9\uB429\uB2C8\uB2E4."),js.forEach(s),oa=j(l),i(hl.$$.fragment,l),ia=j(l),O=p(l,"P",{});var La=J(O);yt=M(La,"\uC774\uBBF8\uC9C0\uC758 \uD06C\uAE30\uAC00 \uC870\uC815\uB418\uC5C8\uB294\uC9C0 \uD655\uC778\uD558\uAE30 \uC704\uD574 \uC774\uBBF8\uC9C0\uB97C \uB2E4\uC2DC \uC2DC\uAC01\uD654\uD574\uBCF4\uC138\uC694. \uC774\uC81C "),Cl=p(La,"A",{href:!0,rel:!0});var $M=J(Cl);jt=M($M,"DataLoader"),$M.forEach(s),ct=M(La,"\uC5D0 \uB370\uC774\uD130\uC14B\uC744 \uD3EC\uD568\uD574 \uD559\uC2B5\uD560 \uC900\uBE44\uAC00 \uB418\uC5C8\uC2B5\uB2C8\uB2E4!"),La.forEach(s),Ta=j(l),i(Il.$$.fragment,l),ma=j(l),G=p(l,"H2",{class:!0});var Pa=J(G);$=p(Pa,"A",{id:!0,class:!0,href:!0});var HM=J($);gs=p(HM,"SPAN",{});var xM=J(gs);i(fl.$$.fragment,xM),xM.forEach(s),HM.forEach(s),ot=j(Pa),As=p(Pa,"SPAN",{});var qM=J(As);it=M(qM,"UNet2DModel \uC0DD\uC131\uD558\uAE30"),qM.forEach(s),Pa.forEach(s),ra=j(l),H=p(l,"P",{});var le=J(H);Tt=M(le,"\u{1F9E8} Diffusers\uC5D0 \uC0AC\uC804\uD559\uC2B5\uB41C \uBAA8\uB378\uB4E4\uC740 \uBAA8\uB378 \uD074\uB798\uC2A4\uC5D0\uC11C \uC6D0\uD558\uB294 \uD30C\uB77C\uBBF8\uD130\uB85C \uC27D\uAC8C \uC0DD\uC131\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4. \uC608\uB97C \uB4E4\uC5B4, "),Es=p(le,"CODE",{});var KM=J(Es);mt=M(KM,"UNet2DModel"),KM.forEach(s),rt=M(le,"\uB97C \uC0DD\uC131\uD558\uB824\uBA74:"),le.forEach(s),wa=j(l),i(ul.$$.fragment,l),ha=j(l),Sl=p(l,"P",{});var LM=J(Sl);wt=M(LM,"\uC0D8\uD50C\uC758 \uC774\uBBF8\uC9C0 \uD06C\uAE30\uC640 \uBAA8\uB378 \uCD9C\uB825 \uD06C\uAE30\uAC00 \uB9DE\uB294\uC9C0 \uBE60\uB974\uAC8C \uD655\uC778\uD558\uAE30 \uC704\uD55C \uC88B\uC740 \uC544\uC774\uB514\uC5B4\uAC00 \uC788\uC2B5\uB2C8\uB2E4:"),LM.forEach(s),Ca=j(l),i(bl.$$.fragment,l),Ia=j(l),Wl=p(l,"P",{});var PM=J(Wl);ht=M(PM,"\uD6CC\uB96D\uD574\uC694! \uB2E4\uC74C, \uC774\uBBF8\uC9C0\uC5D0 \uC57D\uAC04\uC758 \uB178\uC774\uC988\uB97C \uB354\uD558\uAE30 \uC704\uD574 \uC2A4\uCF00\uC904\uB7EC\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4."),PM.forEach(s),fa=j(l),Vl=p(l,"H2",{id:!0});var lU=J(Vl);Ct=M(lU,"\uC2A4\uCF00\uC904\uB7EC \uC0DD\uC131\uD558\uAE30"),lU.forEach(s),ua=j(l),k=p(l,"P",{});var cs=J(k);It=M(cs,"\uC2A4\uCF00\uC904\uB7EC\uB294 \uBAA8\uB378\uC744 \uD559\uC2B5 \uB610\uB294 \uCD94\uB860\uC5D0 \uC0AC\uC6A9\uD558\uB294\uC9C0\uC5D0 \uB530\uB77C \uB2E4\uB974\uAC8C \uC791\uB3D9\uD569\uB2C8\uB2E4. \uCD94\uB860\uC2DC\uC5D0, \uC2A4\uCF00\uC904\uB7EC\uB294 \uB178\uC774\uC988\uB85C\uBD80\uD130 \uC774\uBBF8\uC9C0\uB97C \uC0DD\uC131\uD569\uB2C8\uB2E4. \uD559\uC2B5\uC2DC \uC2A4\uCF00\uC904\uB7EC\uB294 diffusion \uACFC\uC815\uC5D0\uC11C\uC758 \uD2B9\uC815 \uD3EC\uC778\uD2B8\uB85C\uBD80\uD130 \uBAA8\uB378\uC758 \uCD9C\uB825 \uB610\uB294 \uC0D8\uD50C\uC744 \uAC00\uC838\uC640 "),Rs=p(cs,"EM",{});var sU=J(Rs);ft=M(sU,"\uB178\uC774\uC988 \uC2A4\uCF00\uC904"),sU.forEach(s),ut=M(cs," \uACFC "),Bs=p(cs,"EM",{});var aU=J(Bs);bt=M(aU,"\uC5C5\uB370\uC774\uD2B8 \uADDC\uCE59"),aU.forEach(s),Vt=M(cs,"\uC5D0 \uB530\uB77C \uC774\uBBF8\uC9C0\uC5D0 \uB178\uC774\uC988\uB97C \uC801\uC6A9\uD569\uB2C8\uB2E4."),cs.forEach(s),ba=j(l),d=p(l,"P",{});var Gl=J(d);_s=p(Gl,"CODE",{});var eU=J(_s);Qt=M(eU,"DDPMScheduler"),eU.forEach(s),dt=M(Gl,"\uB97C \uBCF4\uBA74 \uC774\uC804\uC73C\uB85C\uBD80\uD130 "),ks=p(Gl,"CODE",{});var tU=J(ks);gt=M(tU,"sample_image"),tU.forEach(s),At=M(Gl,"\uC5D0 \uB79C\uB364\uD55C \uB178\uC774\uC988\uB97C \uB354\uD558\uB294 "),Zs=p(Gl,"CODE",{});var MU=J(Zs);Et=M(MU,"add_noise"),MU.forEach(s),Rt=M(Gl," \uBA54\uC11C\uB4DC\uB97C \uC0AC\uC6A9\uD569\uB2C8\uB2E4:"),Gl.forEach(s),Va=j(l),i(Ql.$$.fragment,l),Qa=j(l),zl=p(l,"P",{});var UU=J(zl);Gs=p(UU,"IMG",{src:!0}),UU.forEach(s),da=j(l),Yl=p(l,"P",{});var nU=J(Yl);Bt=M(nU,"\uBAA8\uB378\uC758 \uD559\uC2B5 \uBAA9\uC801\uC740 \uC774\uBBF8\uC9C0\uC5D0 \uB354\uD574\uC9C4 \uB178\uC774\uC988\uB97C \uC608\uCE21\uD558\uB294 \uAC83\uC785\uB2C8\uB2E4. \uC774 \uB2E8\uACC4\uC5D0\uC11C \uC190\uC2E4\uC740 \uB2E4\uC74C\uACFC \uAC19\uC774 \uACC4\uC0B0\uB420 \uC218 \uC788\uC2B5\uB2C8\uB2E4:"),nU.forEach(s),ga=j(l),i(dl.$$.fragment,l),Aa=j(l),gl=p(l,"H2",{id:!0});var pU=J(gl);_t=M(pU,"\uBAA8\uB378 \uD559\uC2B5\uD558\uAE30"),pU.forEach(s),Ea=j(l),Ol=p(l,"P",{});var JU=J(Ol);kt=M(JU,"\uC9C0\uAE08\uAE4C\uC9C0, \uBAA8\uB378 \uD559\uC2B5\uC744 \uC2DC\uC791\uD558\uAE30 \uC704\uD574 \uB9CE\uC740 \uBD80\uBD84\uC744 \uAC16\uCD94\uC5C8\uC73C\uBA70 \uC774\uC81C \uB0A8\uC740 \uAC83\uC740 \uBAA8\uB4E0 \uAC83\uC744 \uC870\uD569\uD558\uB294 \uAC83\uC785\uB2C8\uB2E4."),JU.forEach(s),Ra=j(l),$l=p(l,"P",{});var yU=J($l);Zt=M(yU,"\uC6B0\uC120 \uC635\uD2F0\uB9C8\uC774\uC800(optimizer)\uC640 \uD559\uC2B5\uB960 \uC2A4\uCF00\uC904\uB7EC(learning rate scheduler)\uAC00 \uD544\uC694\uD560 \uAC83\uC785\uB2C8\uB2E4:"),yU.forEach(s),Ba=j(l),i(Al.$$.fragment,l),_a=j(l),x=p(l,"P",{});var se=J(x);Gt=M(se,"\uADF8 \uD6C4, \uBAA8\uB378\uC744 \uD3C9\uAC00\uD558\uB294 \uBC29\uBC95\uC774 \uD544\uC694\uD569\uB2C8\uB2E4. \uD3C9\uAC00\uB97C \uC704\uD574, "),Ns=p(se,"CODE",{});var jU=J(Ns);Nt=M(jU,"DDPMPipeline"),jU.forEach(s),Ft=M(se,"\uC744 \uC0AC\uC6A9\uD574 \uBC30\uCE58\uC758 \uC774\uBBF8\uC9C0 \uC0D8\uD50C\uB4E4\uC744 \uC0DD\uC131\uD558\uACE0 \uADF8\uB9AC\uB4DC \uD615\uD0DC\uB85C \uC800\uC7A5\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4:"),se.forEach(s),ka=j(l),i(El.$$.fragment,l),Za=j(l),Hl=p(l,"P",{});var cU=J(Hl);Dt=M(cU,"TensorBoard\uC5D0 \uB85C\uAE45, \uADF8\uB798\uB514\uC5B8\uD2B8 \uB204\uC801 \uBC0F \uD63C\uD569 \uC815\uBC00\uB3C4 \uD559\uC2B5\uC744 \uC27D\uAC8C \uC218\uD589\uD558\uAE30 \uC704\uD574 \u{1F917} Accelerate\uB97C \uD559\uC2B5 \uB8E8\uD504\uC5D0 \uD568\uAED8 \uC55E\uC11C \uB9D0\uD55C \uBAA8\uB4E0 \uAD6C\uC131 \uC815\uBCF4\uB4E4\uC744 \uBB36\uC5B4 \uC9C4\uD589\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4. \uD5C8\uBE0C\uC5D0 \uBAA8\uB378\uC744 \uC5C5\uB85C\uB4DC \uD558\uAE30 \uC704\uD574 \uB9AC\uD3EC\uC9C0\uD1A0\uB9AC \uC774\uB984 \uBC0F \uC815\uBCF4\uB97C \uAC00\uC838\uC624\uAE30 \uC704\uD55C \uD568\uC218\uB97C \uC791\uC131\uD558\uACE0 \uD5C8\uBE0C\uC5D0 \uC5C5\uB85C\uB4DC\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4."),cU.forEach(s),Ga=j(l),xl=p(l,"P",{});var oU=J(xl);Xt=M(oU,"\u{1F4A1}\uC544\uB798\uC758 \uD559\uC2B5 \uB8E8\uD504\uB294 \uC5B4\uB835\uACE0 \uAE38\uC5B4 \uBCF4\uC77C \uC218 \uC788\uC9C0\uB9CC, \uB098\uC911\uC5D0 \uD55C \uC904\uC758 \uCF54\uB4DC\uB85C \uD559\uC2B5\uC744 \uD55C\uB2E4\uBA74 \uADF8\uB9CC\uD55C \uAC00\uCE58\uAC00 \uC788\uC744 \uAC83\uC785\uB2C8\uB2E4! \uB9CC\uC57D \uAE30\uB2E4\uB9AC\uC9C0 \uBABB\uD558\uACE0 \uC774\uBBF8\uC9C0\uB97C \uC0DD\uC131\uD558\uACE0 \uC2F6\uB2E4\uBA74, \uC544\uB798 \uCF54\uB4DC\uB97C \uC790\uC720\uB86D\uAC8C \uBD99\uC5EC\uB123\uACE0 \uC791\uB3D9\uC2DC\uD0A4\uBA74 \uB429\uB2C8\uB2E4. \u{1F917}"),oU.forEach(s),Na=j(l),i(Rl.$$.fragment,l),Fa=j(l),q=p(l,"P",{});var ae=J(q);vt=M(ae,"\uD734, \uCF54\uB4DC\uAC00 \uAF64 \uB9CE\uC558\uB124\uC694! \uD558\uC9C0\uB9CC \u{1F917} Accelerate\uC758 "),Fs=p(ae,"CODE",{});var iU=J(Fs);St=M(iU,"notebook_launcher"),iU.forEach(s),Wt=M(ae," \uD568\uC218\uC640 \uD559\uC2B5\uC744 \uC2DC\uC791\uD560 \uC900\uBE44\uAC00 \uB418\uC5C8\uC2B5\uB2C8\uB2E4. \uD568\uC218\uC5D0 \uD559\uC2B5 \uB8E8\uD504, \uBAA8\uB4E0 \uD559\uC2B5 \uC778\uC218, \uD559\uC2B5\uC5D0 \uC0AC\uC6A9\uD560 \uD504\uB85C\uC138\uC2A4 \uC218(\uC0AC\uC6A9 \uAC00\uB2A5\uD55C GPU\uC758 \uC218\uB97C \uBCC0\uACBD\uD560 \uC218 \uC788\uC74C)\uB97C \uC804\uB2EC\uD569\uB2C8\uB2E4:"),ae.forEach(s),Da=j(l),i(Bl.$$.fragment,l),Xa=j(l),ql=p(l,"P",{});var TU=J(ql);zt=M(TU,"\uD55C\uBC88 \uD559\uC2B5\uC774 \uC644\uB8CC\uB418\uBA74, diffusion \uBAA8\uB378\uB85C \uC0DD\uC131\uB41C \uCD5C\uC885 \u{1F98B}\uC774\uBBF8\uC9C0\u{1F98B}\uB97C \uD655\uC778\uD574\uBCF4\uAE38 \uBC14\uB78D\uB2C8\uB2E4!"),TU.forEach(s),va=j(l),i(_l.$$.fragment,l),Sa=j(l),Kl=p(l,"P",{});var mU=J(Kl);Ds=p(mU,"IMG",{src:!0}),mU.forEach(s),Wa=j(l),kl=p(l,"H2",{id:!0});var rU=J(kl);Yt=M(rU,"\uB2E4\uC74C \uB2E8\uACC4"),rU.forEach(s),za=j(l),K=p(l,"P",{});var ee=J(K);Ot=M(ee,"Unconditional \uC774\uBBF8\uC9C0 \uC0DD\uC131\uC740 \uD559\uC2B5\uB420 \uC218 \uC788\uB294 \uC791\uC5C5 \uC911 \uD558\uB098\uC758 \uC608\uC2DC\uC785\uB2C8\uB2E4. \uB2E4\uB978 \uC791\uC5C5\uACFC \uD559\uC2B5 \uBC29\uBC95\uC740 "),Ll=p(ee,"A",{href:!0});var wU=J(Ll);$t=M(wU,"\u{1F9E8} Diffusers \uD559\uC2B5 \uC608\uC2DC"),wU.forEach(s),Ht=M(ee," \uD398\uC774\uC9C0\uC5D0\uC11C \uD655\uC778\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4. \uB2E4\uC74C\uC740 \uD559\uC2B5\uD560 \uC218 \uC788\uB294 \uBA87 \uAC00\uC9C0 \uC608\uC2DC\uC785\uB2C8\uB2E4:"),ee.forEach(s),Ya=j(l),Q=p(l,"UL",{});var L=J(Q);Pl=p(L,"LI",{});var pM=J(Pl);ls=p(pM,"A",{href:!0});var hU=J(ls);xt=M(hU,"Textual Inversion"),hU.forEach(s),qt=M(pM,", \uD2B9\uC815 \uC2DC\uAC01\uC801 \uAC1C\uB150\uC744 \uD559\uC2B5\uC2DC\uCF1C \uC0DD\uC131\uB41C \uC774\uBBF8\uC9C0\uC5D0 \uD1B5\uD569\uC2DC\uD0A4\uB294 \uC54C\uACE0\uB9AC\uC998\uC785\uB2C8\uB2E4."),pM.forEach(s),Kt=j(L),ss=p(L,"LI",{});var JM=J(ss);as=p(JM,"A",{href:!0});var CU=J(as);Lt=M(CU,"DreamBooth"),CU.forEach(s),Pt=M(JM,", \uC8FC\uC81C\uC5D0 \uB300\uD55C \uBA87 \uAC00\uC9C0 \uC785\uB825 \uC774\uBBF8\uC9C0\uB4E4\uC774 \uC8FC\uC5B4\uC9C0\uBA74 \uC8FC\uC81C\uC5D0 \uB300\uD55C \uAC1C\uC778\uD654\uB41C \uC774\uBBF8\uC9C0\uB97C \uC0DD\uC131\uD558\uAE30 \uC704\uD55C \uAE30\uC220\uC785\uB2C8\uB2E4."),JM.forEach(s),lM=j(L),es=p(L,"LI",{});var yM=J(es);ts=p(yM,"A",{href:!0});var IU=J(ts);sM=M(IU,"Guide"),IU.forEach(s),aM=M(yM," \uB370\uC774\uD130\uC14B\uC5D0 Stable Diffusion \uBAA8\uB378\uC744 \uD30C\uC778\uD29C\uB2DD\uD558\uB294 \uBC29\uBC95\uC785\uB2C8\uB2E4."),yM.forEach(s),eM=j(L),Ms=p(L,"LI",{});var jM=J(Ms);Us=p(jM,"A",{href:!0});var fU=J(Us);tM=M(fU,"Guide"),fU.forEach(s),MM=M(jM,"  LoRA\uB97C \uC0AC\uC6A9\uD574 \uB9E4\uC6B0 \uD070 \uBAA8\uB378\uC744 \uBE60\uB974\uAC8C \uD30C\uC778\uD29C\uB2DD\uD558\uAE30 \uC704\uD55C \uBA54\uBAA8\uB9AC \uD6A8\uC728\uC801\uC778 \uAE30\uC220\uC785\uB2C8\uB2E4."),jM.forEach(s),L.forEach(s),this.h()},h(){c(C,"name","hf:doc:metadata"),c(C,"content",JSON.stringify(_U)),c(f,"id","diffusion"),c(f,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(f,"href","#diffusion"),c(b,"class","relative group"),c(P,"href","https://huggingface.co/search/full-text?q=unconditional-image-generation&type=model"),c(P,"rel","nofollow"),c(ll,"href","https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset"),c(ll,"rel","nofollow"),c(sl,"href","https://www.tensorflow.org/tensorboard"),c(sl,"rel","nofollow"),c(al,"href","https://docs.wandb.ai/"),c(al,"rel","nofollow"),c(tl,"href","https://hf.co/join"),c(tl,"rel","nofollow"),c(nl,"href","https://git-lfs.com/"),c(nl,"rel","nofollow"),c(Jl,"id",""),c(jl,"id",""),c(cl,"href","https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset"),c(cl,"rel","nofollow"),c(il,"href","https://huggingface.co/huggan"),c(il,"rel","nofollow"),c(Tl,"href","https://huggingface.co/docs/datasets/image_dataset#imagefolder"),c(Tl,"rel","nofollow"),c(ml,"href","https://pillow.readthedocs.io/en/stable/reference/Image.html"),c(ml,"rel","nofollow"),cM(Is.src,oM="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_ds.png")||c(Is,"src",oM),c(Cl,"href","https://pytorch.org/docs/stable/data#torch.utils.data.DataLoader"),c(Cl,"rel","nofollow"),c($,"id","unet2dmodel"),c($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c($,"href","#unet2dmodel"),c(G,"class","relative group"),c(Vl,"id",""),cM(Gs.src,iM="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/noisy_butterfly.png")||c(Gs,"src",iM),c(gl,"id",""),cM(Ds.src,TM="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_final.png")||c(Ds,"src",TM),c(kl,"id",""),c(Ll,"href","../training/overview"),c(ls,"href","../training/text_inversion"),c(as,"href","../training/dreambooth"),c(ts,"href","../training/text2image"),c(Us,"href","../training/lora")},m(l,e){a(document.head,C),U(l,N,e),T(I,l,e),U(l,F,e),U(l,b,e),a(b,f),a(f,V),T(g,V,null),a(b,te),a(b,os),a(os,Me),U(l,Ss,e),U(l,D,e),a(D,Ue),a(D,P),a(P,ne),a(D,pe),U(l,Ws,e),U(l,A,e),a(A,Je),a(A,ll),a(ll,ye),a(A,je),a(A,is),a(is,ce),a(A,oe),U(l,zs,e),T(X,l,e),U(l,Ys,e),U(l,E,e),a(E,ie),a(E,sl),a(sl,Te),a(E,me),a(E,al),a(al,re),a(E,we),U(l,Os,e),T(el,l,e),U(l,$s,e),U(l,v,e),a(v,he),a(v,tl),a(tl,Ce),a(v,Ie),U(l,Hs,e),T(Ml,l,e),U(l,xs,e),U(l,Nl,e),a(Nl,fe),U(l,qs,e),T(Ul,l,e),U(l,Ks,e),U(l,S,e),a(S,ue),a(S,nl),a(nl,be),a(S,Ve),U(l,Ls,e),T(pl,l,e),U(l,Ps,e),U(l,Jl,e),a(Jl,Qe),U(l,la,e),U(l,W,e),a(W,de),a(W,Ts),a(Ts,ge),a(W,Ae),U(l,sa,e),T(yl,l,e),U(l,aa,e),U(l,jl,e),a(jl,Ee),U(l,ea,e),U(l,z,e),a(z,Re),a(z,cl),a(cl,Be),a(z,_e),U(l,ta,e),T(ol,l,e),U(l,Ma,e),U(l,u,e),a(u,ke),a(u,il),a(il,Ze),a(u,Ge),a(u,Tl),a(Tl,ms),a(ms,Ne),a(u,Fe),a(u,rs),a(rs,De),a(u,Xe),a(u,ws),a(ws,ve),a(u,Se),U(l,Ua,e),U(l,R,e),a(R,We),a(R,hs),a(hs,ze),a(R,Ye),a(R,ml),a(ml,Cs),a(Cs,Oe),a(R,$e),U(l,na,e),T(rl,l,e),U(l,pa,e),U(l,Fl,e),a(Fl,Is),U(l,Ja,e),U(l,Dl,e),a(Dl,He),U(l,ya,e),U(l,B,e),a(B,Y),a(Y,fs),a(fs,xe),a(Y,qe),a(Y,us),a(us,Ke),a(Y,Le),a(B,Pe),a(B,Xl),a(Xl,bs),a(bs,lt),a(Xl,st),a(B,at),a(B,vl),a(vl,Vs),a(Vs,et),a(vl,tt),U(l,ja,e),T(wl,l,e),U(l,ca,e),U(l,_,e),a(_,Mt),a(_,Qs),a(Qs,Ut),a(_,nt),a(_,ds),a(ds,pt),a(_,Jt),U(l,oa,e),T(hl,l,e),U(l,ia,e),U(l,O,e),a(O,yt),a(O,Cl),a(Cl,jt),a(O,ct),U(l,Ta,e),T(Il,l,e),U(l,ma,e),U(l,G,e),a(G,$),a($,gs),T(fl,gs,null),a(G,ot),a(G,As),a(As,it),U(l,ra,e),U(l,H,e),a(H,Tt),a(H,Es),a(Es,mt),a(H,rt),U(l,wa,e),T(ul,l,e),U(l,ha,e),U(l,Sl,e),a(Sl,wt),U(l,Ca,e),T(bl,l,e),U(l,Ia,e),U(l,Wl,e),a(Wl,ht),U(l,fa,e),U(l,Vl,e),a(Vl,Ct),U(l,ua,e),U(l,k,e),a(k,It),a(k,Rs),a(Rs,ft),a(k,ut),a(k,Bs),a(Bs,bt),a(k,Vt),U(l,ba,e),U(l,d,e),a(d,_s),a(_s,Qt),a(d,dt),a(d,ks),a(ks,gt),a(d,At),a(d,Zs),a(Zs,Et),a(d,Rt),U(l,Va,e),T(Ql,l,e),U(l,Qa,e),U(l,zl,e),a(zl,Gs),U(l,da,e),U(l,Yl,e),a(Yl,Bt),U(l,ga,e),T(dl,l,e),U(l,Aa,e),U(l,gl,e),a(gl,_t),U(l,Ea,e),U(l,Ol,e),a(Ol,kt),U(l,Ra,e),U(l,$l,e),a($l,Zt),U(l,Ba,e),T(Al,l,e),U(l,_a,e),U(l,x,e),a(x,Gt),a(x,Ns),a(Ns,Nt),a(x,Ft),U(l,ka,e),T(El,l,e),U(l,Za,e),U(l,Hl,e),a(Hl,Dt),U(l,Ga,e),U(l,xl,e),a(xl,Xt),U(l,Na,e),T(Rl,l,e),U(l,Fa,e),U(l,q,e),a(q,vt),a(q,Fs),a(Fs,St),a(q,Wt),U(l,Da,e),T(Bl,l,e),U(l,Xa,e),U(l,ql,e),a(ql,zt),U(l,va,e),T(_l,l,e),U(l,Sa,e),U(l,Kl,e),a(Kl,Ds),U(l,Wa,e),U(l,kl,e),a(kl,Yt),U(l,za,e),U(l,K,e),a(K,Ot),a(K,Ll),a(Ll,$t),a(K,Ht),U(l,Ya,e),U(l,Q,e),a(Q,Pl),a(Pl,ls),a(ls,xt),a(Pl,qt),a(Q,Kt),a(Q,ss),a(ss,as),a(as,Lt),a(ss,Pt),a(Q,lM),a(Q,es),a(es,ts),a(ts,sM),a(es,aM),a(Q,eM),a(Q,Ms),a(Ms,Us),a(Us,tM),a(Ms,MM),Oa=!0},p(l,[e]){const Zl={};e&2&&(Zl.$$scope={dirty:e,ctx:l}),X.$set(Zl)},i(l){Oa||(m(I.$$.fragment,l),m(g.$$.fragment,l),m(X.$$.fragment,l),m(el.$$.fragment,l),m(Ml.$$.fragment,l),m(Ul.$$.fragment,l),m(pl.$$.fragment,l),m(yl.$$.fragment,l),m(ol.$$.fragment,l),m(rl.$$.fragment,l),m(wl.$$.fragment,l),m(hl.$$.fragment,l),m(Il.$$.fragment,l),m(fl.$$.fragment,l),m(ul.$$.fragment,l),m(bl.$$.fragment,l),m(Ql.$$.fragment,l),m(dl.$$.fragment,l),m(Al.$$.fragment,l),m(El.$$.fragment,l),m(Rl.$$.fragment,l),m(Bl.$$.fragment,l),m(_l.$$.fragment,l),Oa=!0)},o(l){r(I.$$.fragment,l),r(g.$$.fragment,l),r(X.$$.fragment,l),r(el.$$.fragment,l),r(Ml.$$.fragment,l),r(Ul.$$.fragment,l),r(pl.$$.fragment,l),r(yl.$$.fragment,l),r(ol.$$.fragment,l),r(rl.$$.fragment,l),r(wl.$$.fragment,l),r(hl.$$.fragment,l),r(Il.$$.fragment,l),r(fl.$$.fragment,l),r(ul.$$.fragment,l),r(bl.$$.fragment,l),r(Ql.$$.fragment,l),r(dl.$$.fragment,l),r(Al.$$.fragment,l),r(El.$$.fragment,l),r(Rl.$$.fragment,l),r(Bl.$$.fragment,l),r(_l.$$.fragment,l),Oa=!1},d(l){s(C),l&&s(N),w(I,l),l&&s(F),l&&s(b),w(g),l&&s(Ss),l&&s(D),l&&s(Ws),l&&s(A),l&&s(zs),w(X,l),l&&s(Ys),l&&s(E),l&&s(Os),w(el,l),l&&s($s),l&&s(v),l&&s(Hs),w(Ml,l),l&&s(xs),l&&s(Nl),l&&s(qs),w(Ul,l),l&&s(Ks),l&&s(S),l&&s(Ls),w(pl,l),l&&s(Ps),l&&s(Jl),l&&s(la),l&&s(W),l&&s(sa),w(yl,l),l&&s(aa),l&&s(jl),l&&s(ea),l&&s(z),l&&s(ta),w(ol,l),l&&s(Ma),l&&s(u),l&&s(Ua),l&&s(R),l&&s(na),w(rl,l),l&&s(pa),l&&s(Fl),l&&s(Ja),l&&s(Dl),l&&s(ya),l&&s(B),l&&s(ja),w(wl,l),l&&s(ca),l&&s(_),l&&s(oa),w(hl,l),l&&s(ia),l&&s(O),l&&s(Ta),w(Il,l),l&&s(ma),l&&s(G),w(fl),l&&s(ra),l&&s(H),l&&s(wa),w(ul,l),l&&s(ha),l&&s(Sl),l&&s(Ca),w(bl,l),l&&s(Ia),l&&s(Wl),l&&s(fa),l&&s(Vl),l&&s(ua),l&&s(k),l&&s(ba),l&&s(d),l&&s(Va),w(Ql,l),l&&s(Qa),l&&s(zl),l&&s(da),l&&s(Yl),l&&s(ga),w(dl,l),l&&s(Aa),l&&s(gl),l&&s(Ea),l&&s(Ol),l&&s(Ra),l&&s($l),l&&s(Ba),w(Al,l),l&&s(_a),l&&s(x),l&&s(ka),w(El,l),l&&s(Za),l&&s(Hl),l&&s(Ga),l&&s(xl),l&&s(Na),w(Rl,l),l&&s(Fa),l&&s(q),l&&s(Da),w(Bl,l),l&&s(Xa),l&&s(ql),l&&s(va),w(_l,l),l&&s(Sa),l&&s(Kl),l&&s(Wa),l&&s(kl),l&&s(za),l&&s(K),l&&s(Ya),l&&s(Q)}}}const _U={local:"diffusion",sections:[{local:"",title:"\uD559\uC2B5 \uAD6C\uC131"},{local:"",title:"\uB370\uC774\uD130\uC14B \uBD88\uB7EC\uC624\uAE30"},{local:"unet2dmodel",title:"UNet2DModel \uC0DD\uC131\uD558\uAE30"},{local:"",title:"\uC2A4\uCF00\uC904\uB7EC \uC0DD\uC131\uD558\uAE30"},{local:"",title:"\uBAA8\uB378 \uD559\uC2B5\uD558\uAE30"},{local:"",title:"\uB2E4\uC74C \uB2E8\uACC4"}],title:"Diffusion \uBAA8\uB378\uC744 \uD559\uC2B5\uD558\uAE30"};function kU(vs){return gU(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class XU extends bU{constructor(C){super();VU(this,C,kU,BU,QU,{})}}export{XU as default,_U as metadata};
