import{s as xe,n as Ce,o as Ie}from"../chunks/scheduler.8c3d61f6.js";import{S as Be,i as Ye,g as i,s as n,r as p,A as Se,h as o,f as l,c as a,j as Ge,u as r,x as m,k as Ze,y as Ee,a as s,v as d,d as c,t as u,w as f}from"../chunks/index.da70eac4.js";import{C as z}from"../chunks/CodeBlock.a9c4becf.js";import{D as ze}from"../chunks/DocNotebookDropdown.48852948.js";import{H as Me,E as Fe}from"../chunks/getInferenceSnippets.39110341.js";function Ne(Te){let h,F,S,N,b,D,M,L,Z,Je='<a href="https://huggingface.co/papers/2311.15127" rel="nofollow">Stable Video Diffusion (SVD)</a> is a powerful image-to-video generation model that can generate 2-4 second high resolution (576x1024) videos conditioned on an input image.',H,T,we="This guide will show you how to use SVD to generate short videos from images.",O,J,Ue="Before you begin, make sure you have the following libraries installed:",q,w,P,U,ye='The are two variants of this model, <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid" rel="nofollow">SVD</a> and <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid-xt" rel="nofollow">SVD-XT</a>. The SVD checkpoint is trained to generate 14 frames and the SVD-XT checkpoint is further finetuned to generate 25 frames.',A,y,ve="You’ll use the SVD-XT checkpoint for this guide.",K,v,ee,g,je='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;source image of a rocket&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/output_rocket.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;generated video from source image&quot;</figcaption></div>',te,j,le,k,ke='You can gain a 20-25% speedup at the expense of slightly increased memory by <a href="../optimization/fp16#torchcompile">compiling</a> the UNet.',se,W,ne,_,ae,$,We="Video generation is very memory intensive because you’re essentially generating <code>num_frames</code> all at once, similar to text-to-image generation with a high batch size. To reduce the memory requirement, there are multiple options that trade-off inference speed for lower memory requirement:",ie,Q,_e="<li>enable model offloading: each component of the pipeline is offloaded to the CPU once it’s not needed anymore.</li> <li>enable feed-forward chunking: the feed-forward layer runs in a loop instead of running a single feed-forward with a huge batch size.</li> <li>reduce <code>decode_chunk_size</code>: the VAE decodes frames in chunks instead of decoding them all together. Setting <code>decode_chunk_size=1</code> decodes one frame at a time and uses the least amount of memory (we recommend adjusting this value based on your GPU memory) but the video might have some flickering.</li>",oe,V,me,R,$e="Using all these tricks together should lower the memory requirement to less than 8GB VRAM.",pe,X,re,G,Qe="Stable Diffusion Video also accepts micro-conditioning, in addition to the conditioning image, which allows more control over the generated video:",de,x,Ve="<li><code>fps</code>: the frames per second of the generated video.</li> <li><code>motion_bucket_id</code>: the motion bucket id to use for the generated video. This can be used to control the motion of the generated video. Increasing the motion bucket id increases the motion of the generated video.</li> <li><code>noise_aug_strength</code>: the amount of noise added to the conditioning image. The higher the values the less the video resembles the conditioning image. Increasing this value also increases the motion of the generated video.</li>",ce,C,Re="For example, to generate a video with more motion, use the <code>motion_bucket_id</code> and <code>noise_aug_strength</code> micro-conditioning parameters:",ue,I,fe,B,Xe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/output_rocket_with_conditions.gif"/>',he,Y,ge,E,be;return b=new Me({props:{title:"Stable Video Diffusion",local:"stable-video-diffusion",headingTag:"h1"}}),M=new ze({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/svd.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/svd.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/svd.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/svd.ipynb"}]}}),w=new z({props:{code:"JTIzJTIwQ29sYWIlRUMlOTclOTAlRUMlODQlOUMlMjAlRUQlOTUlODQlRUMlOUElOTQlRUQlOTUlOUMlMjAlRUIlOUQlQkMlRUMlOUQlQjQlRUIlQjglOEMlRUIlOUYlQUMlRUIlQTYlQUMlRUIlQTUlQkMlMjAlRUMlODQlQTQlRUMlQjklOTglRUQlOTUlOTglRUElQjglQjAlMjAlRUMlOUMlODQlRUQlOTUlQjQlMjAlRUMlQTMlQkMlRUMlODQlOUQlRUMlOUQlODQlMjAlRUMlQTAlOUMlRUMlOTklQjglRUQlOTUlOTglRUMlODQlQjglRUMlOUElOTQlMEEhcGlwJTIwaW5zdGFsbCUyMC1xJTIwLVUlMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRl",highlighted:`<span class="hljs-comment"># Colab에서 필요한 라이브러리를 설치하기 위해 주석을 제외하세요</span>
!pip install -q -U diffusers transformers accelerate`,wrap:!1}}),v=new z({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBjb25kaXRpb25pbmclMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5mcmFtZXMlNUIwJTVEJTBBJTBBZXhwb3J0X3RvX3ZpZGVvKGZyYW1lcyUyQyUyMCUyMmdlbmVyYXRlZC5tcDQlMjIlMkMlMjBmcHMlM0Q3KQ==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Load the conditioning image</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),j=new Me({props:{title:"torch.compile",local:"torchcompile",headingTag:"h2"}}),W=new z({props:{code:"LSUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTJCJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:`<span class="hljs-deletion">- pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipe.to(&quot;cuda&quot;)</span>
<span class="hljs-addition">+ pipe.unet = torch.compile(pipe.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>`,wrap:!1}}),_=new Me({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h2"}}),V=new z({props:{code:"LSUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEEtJTIwZnJhbWVzJTIwJTNEJTIwcGlwZShpbWFnZSUyQyUyMGRlY29kZV9jaHVua19zaXplJTNEOCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuZnJhbWVzJTVCMCU1RCUwQSUyQiUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlLnVuZXQuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoKSUwQSUyQiUyMGZyYW1lcyUyMCUzRCUyMHBpcGUoaW1hZ2UlMkMlMjBkZWNvZGVfY2h1bmtfc2l6ZSUzRDIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1fZnJhbWVzJTNEMjUpLmZyYW1lcyU1QjAlNUQ=",highlighted:`<span class="hljs-deletion">- pipe.enable_model_cpu_offload()</span>
<span class="hljs-deletion">- frames = pipe(image, decode_chunk_size=8, generator=generator).frames[0]</span>
<span class="hljs-addition">+ pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipe.unet.enable_forward_chunking()</span>
<span class="hljs-addition">+ frames = pipe(image, decode_chunk_size=2, generator=generator, num_frames=25).frames[0]</span>`,wrap:!1}}),X=new Me({props:{title:"Micro-conditioning",local:"micro-conditioning",headingTag:"h2"}}),I=new z({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBjb25kaXRpb25pbmclMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbW90aW9uX2J1Y2tldF9pZCUzRDE4MCUyQyUyMG5vaXNlX2F1Z19zdHJlbmd0aCUzRDAuMSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyhmcmFtZXMlMkMlMjAlMjJnZW5lcmF0ZWQubXA0JTIyJTJDJTIwZnBzJTNENyk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Load the conditioning image</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator, motion_bucket_id=<span class="hljs-number">180</span>, noise_aug_strength=<span class="hljs-number">0.1</span>).frames[<span class="hljs-number">0</span>]
export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),Y=new Fe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/svd.md"}}),{c(){h=i("meta"),F=n(),S=i("p"),N=n(),p(b.$$.fragment),D=n(),p(M.$$.fragment),L=n(),Z=i("p"),Z.innerHTML=Je,H=n(),T=i("p"),T.textContent=we,O=n(),J=i("p"),J.textContent=Ue,q=n(),p(w.$$.fragment),P=n(),U=i("p"),U.innerHTML=ye,A=n(),y=i("p"),y.textContent=ve,K=n(),p(v.$$.fragment),ee=n(),g=i("div"),g.innerHTML=je,te=n(),p(j.$$.fragment),le=n(),k=i("p"),k.innerHTML=ke,se=n(),p(W.$$.fragment),ne=n(),p(_.$$.fragment),ae=n(),$=i("p"),$.innerHTML=We,ie=n(),Q=i("ul"),Q.innerHTML=_e,oe=n(),p(V.$$.fragment),me=n(),R=i("p"),R.textContent=$e,pe=n(),p(X.$$.fragment),re=n(),G=i("p"),G.textContent=Qe,de=n(),x=i("ul"),x.innerHTML=Ve,ce=n(),C=i("p"),C.innerHTML=Re,ue=n(),p(I.$$.fragment),fe=n(),B=i("p"),B.innerHTML=Xe,he=n(),p(Y.$$.fragment),ge=n(),E=i("p"),this.h()},l(e){const t=Se("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),F=a(e),S=o(e,"P",{}),Ge(S).forEach(l),N=a(e),r(b.$$.fragment,e),D=a(e),r(M.$$.fragment,e),L=a(e),Z=o(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-6831zo"&&(Z.innerHTML=Je),H=a(e),T=o(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-9hcj9z"&&(T.textContent=we),O=a(e),J=o(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-cwruts"&&(J.textContent=Ue),q=a(e),r(w.$$.fragment,e),P=a(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-iibvlr"&&(U.innerHTML=ye),A=a(e),y=o(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-u5kxxd"&&(y.textContent=ve),K=a(e),r(v.$$.fragment,e),ee=a(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),m(g)!=="svelte-25rdw"&&(g.innerHTML=je),te=a(e),r(j.$$.fragment,e),le=a(e),k=o(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1g0qdyz"&&(k.innerHTML=ke),se=a(e),r(W.$$.fragment,e),ne=a(e),r(_.$$.fragment,e),ae=a(e),$=o(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1aihuum"&&($.innerHTML=We),ie=a(e),Q=o(e,"UL",{"data-svelte-h":!0}),m(Q)!=="svelte-carvgs"&&(Q.innerHTML=_e),oe=a(e),r(V.$$.fragment,e),me=a(e),R=o(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1dz5kg5"&&(R.textContent=$e),pe=a(e),r(X.$$.fragment,e),re=a(e),G=o(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-crombe"&&(G.textContent=Qe),de=a(e),x=o(e,"UL",{"data-svelte-h":!0}),m(x)!=="svelte-hs8jkz"&&(x.innerHTML=Ve),ce=a(e),C=o(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-3jffic"&&(C.innerHTML=Re),ue=a(e),r(I.$$.fragment,e),fe=a(e),B=o(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-19qaph4"&&(B.innerHTML=Xe),he=a(e),r(Y.$$.fragment,e),ge=a(e),E=o(e,"P",{}),Ge(E).forEach(l),this.h()},h(){Ze(h,"name","hf:doc:metadata"),Ze(h,"content",De),Ze(g,"class","flex gap-4")},m(e,t){Ee(document.head,h),s(e,F,t),s(e,S,t),s(e,N,t),d(b,e,t),s(e,D,t),d(M,e,t),s(e,L,t),s(e,Z,t),s(e,H,t),s(e,T,t),s(e,O,t),s(e,J,t),s(e,q,t),d(w,e,t),s(e,P,t),s(e,U,t),s(e,A,t),s(e,y,t),s(e,K,t),d(v,e,t),s(e,ee,t),s(e,g,t),s(e,te,t),d(j,e,t),s(e,le,t),s(e,k,t),s(e,se,t),d(W,e,t),s(e,ne,t),d(_,e,t),s(e,ae,t),s(e,$,t),s(e,ie,t),s(e,Q,t),s(e,oe,t),d(V,e,t),s(e,me,t),s(e,R,t),s(e,pe,t),d(X,e,t),s(e,re,t),s(e,G,t),s(e,de,t),s(e,x,t),s(e,ce,t),s(e,C,t),s(e,ue,t),d(I,e,t),s(e,fe,t),s(e,B,t),s(e,he,t),d(Y,e,t),s(e,ge,t),s(e,E,t),be=!0},p:Ce,i(e){be||(c(b.$$.fragment,e),c(M.$$.fragment,e),c(w.$$.fragment,e),c(v.$$.fragment,e),c(j.$$.fragment,e),c(W.$$.fragment,e),c(_.$$.fragment,e),c(V.$$.fragment,e),c(X.$$.fragment,e),c(I.$$.fragment,e),c(Y.$$.fragment,e),be=!0)},o(e){u(b.$$.fragment,e),u(M.$$.fragment,e),u(w.$$.fragment,e),u(v.$$.fragment,e),u(j.$$.fragment,e),u(W.$$.fragment,e),u(_.$$.fragment,e),u(V.$$.fragment,e),u(X.$$.fragment,e),u(I.$$.fragment,e),u(Y.$$.fragment,e),be=!1},d(e){e&&(l(F),l(S),l(N),l(D),l(L),l(Z),l(H),l(T),l(O),l(J),l(q),l(P),l(U),l(A),l(y),l(K),l(ee),l(g),l(te),l(le),l(k),l(se),l(ne),l(ae),l($),l(ie),l(Q),l(oe),l(me),l(R),l(pe),l(re),l(G),l(de),l(x),l(ce),l(C),l(ue),l(fe),l(B),l(he),l(ge),l(E)),l(h),f(b,e),f(M,e),f(w,e),f(v,e),f(j,e),f(W,e),f(_,e),f(V,e),f(X,e),f(I,e),f(Y,e)}}}const De='{"title":"Stable Video Diffusion","local":"stable-video-diffusion","sections":[{"title":"torch.compile","local":"torchcompile","sections":[],"depth":2},{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[],"depth":2},{"title":"Micro-conditioning","local":"micro-conditioning","sections":[],"depth":2}],"depth":1}';function Le(Te){return Ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ke extends Be{constructor(h){super(),Ye(this,h,Le,Ne,xe,{})}}export{Ke as component};
