import{s as ae,o as oe,n as se}from"../chunks/scheduler.8c3d61f6.js";import{S as ne,i as ie,g as n,s as o,r as m,A as re,h as i,f as l,c as s,j as ee,u as p,x as r,k as le,y as de,a,v as c,d as u,t as h,w as f}from"../chunks/index.da70eac4.js";import{T as me}from"../chunks/Tip.1d9b8c37.js";import{C as D}from"../chunks/CodeBlock.a9c4becf.js";import{H as It,E as pe}from"../chunks/getInferenceSnippets.39110341.js";function ce(O){let d,w='The <a href="/docs/diffusers/main/en/api/models/auto_model#diffusers.AutoModel">AutoModel</a> API is supported for PyTorch &gt;= 2.6 as shown in the examples below.';return{c(){d=n("p"),d.innerHTML=w},l(y){d=i(y,"P",{"data-svelte-h":!0}),r(d)!=="svelte-hh3qdm"&&(d.innerHTML=w)},m(y,P){a(y,d,P)},p:se,d(y){y&&l(d)}}}function ue(O){let d,w,y,P,b,tt,T,Wt='<a href="https://github.com/pytorch/ao" rel="nofollow">TorchAO</a> is an architecture optimization library for PyTorch. It provides high-performance dtypes, optimization techniques, and kernels for inference and training, featuring composability with native PyTorch features like <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a>, FullyShardedDataParallel (FSDP), and more.',et,J,$t="Before you begin, make sure you have Pytorch 2.5+ and TorchAO installed.",lt,U,at,g,Gt='Quantize a model by passing <a href="/docs/diffusers/main/en/api/quantization#diffusers.TorchAoConfig">TorchAoConfig</a> to <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> (you can also load pre-quantized models). This works for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',ot,j,Xt="The example below only quantizes the weights to int8.",st,_,nt,Z,kt='TorchAO is fully compatible with <a href="../optimization/fp16#torchcompile">torch.compile</a>, setting it apart from other quantization methods. This makes it easy to speed up inference with just one line of code.',it,v,rt,q,Rt='For speed and memory benchmarks on Flux and CogVideoX, please refer to the table <a href="https://github.com/huggingface/diffusers/pull/10009#issue-2688781450" rel="nofollow">here</a>. You can also find some torchao <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#benchmarks" rel="nofollow">benchmarks</a> numbers for various hardware.',dt,x,Ht='torchao also supports an automatic quantization API through <a href="https://github.com/pytorch/ao/blob/main/torchao/quantization/README.md#autoquantization" rel="nofollow">autoquant</a>. Autoquantization determines the best quantization strategy applicable to a model by comparing the performance of each technique on chosen input types and shapes. Currently, this can be used directly on the underlying modeling components. Diffusers will also expose an autoquant configuration option in the future.',mt,B,Ft="The <code>TorchAoConfig</code> class accepts three parameters:",pt,C,Qt='<li><code>quant_type</code>: A string value mentioning one of the quantization types below.</li> <li><code>modules_to_not_convert</code>: A list of module full/partial module names for which quantization should not be performed. For example, to not perform any quantization of the <a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>’s first block, one would specify: <code>modules_to_not_convert=[&quot;single_transformer_blocks.0&quot;]</code>.</li> <li><code>kwargs</code>: A dict of keyword arguments to pass to the underlying quantization method which will be invoked based on <code>quant_type</code>.</li>',ct,z,ut,I,Vt="torchao supports weight-only quantization and weight and dynamic-activation quantization for int8, float3-float8, and uint1-uint7.",ht,W,Et="Weight-only quantization stores the model weights in a specific low-bit data type but performs computation with a higher-precision data type, like <code>bfloat16</code>. This lowers the memory requirements from model weights but retains the memory peaks for activation computation.",ft,$,Nt="Dynamic activation quantization stores the model weights in a low-bit dtype, while also quantizing the activations on-the-fly to save additional memory. This lowers the memory requirements from model weights, while also lowering the memory overhead from activation computations. However, this may come at a quality tradeoff at times, so it is recommended to test different models thoroughly.",yt,G,Yt="The quantization methods supported are as follows:",Mt,X,At="<thead><tr><th><strong>Category</strong></th> <th><strong>Full Function Names</strong></th> <th><strong>Shorthands</strong></th></tr></thead> <tbody><tr><td><strong>Integer quantization</strong></td> <td><code>int4_weight_only</code>, <code>int8_dynamic_activation_int4_weight</code>, <code>int8_weight_only</code>, <code>int8_dynamic_activation_int8_weight</code></td> <td><code>int4wo</code>, <code>int4dq</code>, <code>int8wo</code>, <code>int8dq</code></td></tr> <tr><td><strong>Floating point 8-bit quantization</strong></td> <td><code>float8_weight_only</code>, <code>float8_dynamic_activation_float8_weight</code>, <code>float8_static_activation_float8_weight</code></td> <td><code>float8wo</code>, <code>float8wo_e5m2</code>, <code>float8wo_e4m3</code>, <code>float8dq</code>, <code>float8dq_e4m3</code>, <code>float8dq_e4m3_tensor</code>, <code>float8dq_e4m3_row</code></td></tr> <tr><td><strong>Floating point X-bit quantization</strong></td> <td><code>fpx_weight_only</code></td> <td><code>fpX_eAwB</code> where <code>X</code> is the number of bits (1-7), <code>A</code> is exponent bits, and <code>B</code> is mantissa bits. Constraint: <code>X == A + B + 1</code></td></tr> <tr><td><strong>Unsigned Integer quantization</strong></td> <td><code>uintx_weight_only</code></td> <td><code>uint1wo</code>, <code>uint2wo</code>, <code>uint3wo</code>, <code>uint4wo</code>, <code>uint5wo</code>, <code>uint6wo</code>, <code>uint7wo</code></td></tr></tbody>",wt,k,Lt="Some quantization methods are aliases (for example, <code>int8wo</code> is the commonly used shorthand for <code>int8_weight_only</code>). This allows using the quantization methods described in the torchao docs as-is, while also making it convenient to remember their shorthand notations.",bt,R,St='Refer to the <a href="https://docs.pytorch.org/ao/stable/index.html" rel="nofollow">official torchao documentation</a> for a better understanding of the available quantization methods and the exhaustive list of configuration options available.',Tt,H,Jt,F,Pt='To serialize a quantized model in a given dtype, first load the model with the desired quantization dtype and then save it using the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a> method.',Ut,Q,gt,V,Dt='To load a serialized quantized model, use the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method.',jt,E,_t,N,Kt="If you are using <code>torch&lt;=2.6.0</code>, some quantization methods, such as <code>uint4wo</code>, cannot be loaded directly and may result in an <code>UnpicklingError</code> when trying to load the models, but work as expected when saving them. In order to work around this, one can load the state dict manually into the model. Note, however, that this requires using <code>weights_only=False</code> in <code>torch.load</code>, so it should be run only if the weights were obtained from a trustable source.",Zt,Y,vt,M,qt,A,xt,L,Ot='<li><a href="https://docs.pytorch.org/ao/stable/index.html" rel="nofollow">TorchAO Quantization API</a></li> <li><a href="https://github.com/sayakpaul/diffusers-torchao" rel="nofollow">Diffusers-TorchAO examples</a></li>',Bt,S,Ct,K,zt;return b=new It({props:{title:"torchao",local:"torchao",headingTag:"h1"}}),U=new D({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwdG9yY2glMjB0b3JjaGFv",highlighted:"pip install -U torch torchao",wrap:!1}}),_=new D({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTJDJTIwQXV0b01vZGVsJTJDJTIwVG9yY2hBb0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTBBZHR5cGUlMjAlM0QlMjB0b3JjaC5iZmxvYXQxNiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBUb3JjaEFvQ29uZmlnKCUyMmludDh3byUyMiklMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0RkdHlwZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwRmx1eFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRGR0eXBlJTJDJTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBXaXRob3V0JTIwcXVhbnRpemF0aW9uJTNBJTIwfjMxLjQ0NyUyMEdCJTBBJTIzJTIwV2l0aCUyMHF1YW50aXphdGlvbiUzQSUyMH4yMC40MCUyMEdCJTBBcHJpbnQoZiUyMlBpcGVsaW5lJTIwbWVtb3J5JTIwdXNhZ2UlM0ElMjAlN0J0b3JjaC5jdWRhLm1heF9tZW1vcnlfcmVzZXJ2ZWQoKSUyMCUyRiUyMDEwMjQqKjMlM0EuM2YlN0QlMjBHQiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENC41JTJDJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyb3V0cHV0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, AutoModel, TorchAoConfig

model_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
dtype = torch.bfloat16

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int8wo&quot;</span>)
transformer = AutoModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=dtype,
)
pipe = FluxPipeline.from_pretrained(
    model_id,
    transformer=transformer,
    torch_dtype=dtype,
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Without quantization: ~31.447 GB</span>
<span class="hljs-comment"># With quantization: ~20.40 GB</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Pipeline memory usage: <span class="hljs-subst">{torch.cuda.max_memory_reserved() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.3</span>f}</span> GB&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">4.5</span>, max_sequence_length=<span class="hljs-number">512</span>
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),v=new D({props:{code:"JTIzJTIwSW4lMjB0aGUlMjBhYm92ZSUyMGNvZGUlMkMlMjBhZGQlMjB0aGUlMjBmb2xsb3dpbmclMjBhZnRlciUyMGluaXRpYWxpemluZyUyMHRoZSUyMHRyYW5zZm9ybWVyJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjB0b3JjaC5jb21waWxlKHRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUp",highlighted:`<span class="hljs-comment"># In the above code, add the following after initializing the transformer</span>
transformer = torch.<span class="hljs-built_in">compile</span>(transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),z=new It({props:{title:"Supported quantization types",local:"supported-quantization-types",headingTag:"h2"}}),H=new It({props:{title:"Serializing and Deserializing quantized models",local:"serializing-and-deserializing-quantized-models",headingTag:"h2"}}),Q=new D({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwVG9yY2hBb0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBUb3JjaEFvQ29uZmlnKCUyMmludDh3byUyMiklMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGbHV4LjEtRGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBdHJhbnNmb3JtZXIuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfaW50OHdvJTIyJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNERmFsc2Up",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, TorchAoConfig

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int8wo&quot;</span>)
transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=torch.bfloat16,
)
transformer.save_pretrained(<span class="hljs-string">&quot;/path/to/flux_int8wo&quot;</span>, safe_serialization=<span class="hljs-literal">False</span>)`,wrap:!1}}),E=new D({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTJDJTIwQXV0b01vZGVsJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfaW50OHdvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzREZhbHNlKSUwQXBpcGUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRmx1eC4xLURldiUyMiUyQyUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy4wKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, AutoModel

transformer = AutoModel.from_pretrained(<span class="hljs-string">&quot;/path/to/flux_int8wo&quot;</span>, torch_dtype=torch.bfloat16, use_safetensors=<span class="hljs-literal">False</span>)
pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>, transformer=transformer, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>, guidance_scale=<span class="hljs-number">7.0</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),Y=new D({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMGluaXRfZW1wdHlfd2VpZ2h0cyUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBGbHV4UGlwZWxpbmUlMkMlMjBBdXRvTW9kZWwlMkMlMjBUb3JjaEFvQ29uZmlnJTBBJTBBJTIzJTIwU2VyaWFsaXplJTIwdGhlJTIwbW9kZWwlMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGbHV4LjEtRGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEVG9yY2hBb0NvbmZpZyglMjJ1aW50NHdvJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBdHJhbnNmb3JtZXIuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfdWludDR3byUyMiUyQyUyMHNhZmVfc2VyaWFsaXphdGlvbiUzREZhbHNlJTJDJTIwbWF4X3NoYXJkX3NpemUlM0QlMjI1MEdCJTIyKSUwQSUyMyUyMC4uLiUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBtb2RlbCUwQXN0YXRlX2RpY3QlMjAlM0QlMjB0b3JjaC5sb2FkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfdWludDR3byUyRmRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMHdlaWdodHNfb25seSUzREZhbHNlJTJDJTIwbWFwX2xvY2F0aW9uJTNEJTIyY3B1JTIyKSUwQXdpdGglMjBpbml0X2VtcHR5X3dlaWdodHMoKSUzQSUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fY29uZmlnKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfdWludDR3byUyRmNvbmZpZy5qc29uJTIyKSUwQXRyYW5zZm9ybWVyLmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0JTJDJTIwc3RyaWN0JTNEVHJ1ZSUyQyUyMGFzc2lnbiUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, AutoModel, TorchAoConfig

<span class="hljs-comment"># Serialize the model</span>
transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=TorchAoConfig(<span class="hljs-string">&quot;uint4wo&quot;</span>),
    torch_dtype=torch.bfloat16,
)
transformer.save_pretrained(<span class="hljs-string">&quot;/path/to/flux_uint4wo&quot;</span>, safe_serialization=<span class="hljs-literal">False</span>, max_shard_size=<span class="hljs-string">&quot;50GB&quot;</span>)
<span class="hljs-comment"># ...</span>

<span class="hljs-comment"># Load the model</span>
state_dict = torch.load(<span class="hljs-string">&quot;/path/to/flux_uint4wo/diffusion_pytorch_model.bin&quot;</span>, weights_only=<span class="hljs-literal">False</span>, map_location=<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-keyword">with</span> init_empty_weights():
    transformer = AutoModel.from_config(<span class="hljs-string">&quot;/path/to/flux_uint4wo/config.json&quot;</span>)
transformer.load_state_dict(state_dict, strict=<span class="hljs-literal">True</span>, assign=<span class="hljs-literal">True</span>)`,wrap:!1}}),M=new me({props:{warning:!1,$$slots:{default:[ce]},$$scope:{ctx:O}}}),A=new It({props:{title:"Resources",local:"resources",headingTag:"h2"}}),S=new pe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/torchao.md"}}),{c(){d=n("meta"),w=o(),y=n("p"),P=o(),m(b.$$.fragment),tt=o(),T=n("p"),T.innerHTML=Wt,et=o(),J=n("p"),J.textContent=$t,lt=o(),m(U.$$.fragment),at=o(),g=n("p"),g.innerHTML=Gt,ot=o(),j=n("p"),j.textContent=Xt,st=o(),m(_.$$.fragment),nt=o(),Z=n("p"),Z.innerHTML=kt,it=o(),m(v.$$.fragment),rt=o(),q=n("p"),q.innerHTML=Rt,dt=o(),x=n("p"),x.innerHTML=Ht,mt=o(),B=n("p"),B.innerHTML=Ft,pt=o(),C=n("ul"),C.innerHTML=Qt,ct=o(),m(z.$$.fragment),ut=o(),I=n("p"),I.textContent=Vt,ht=o(),W=n("p"),W.innerHTML=Et,ft=o(),$=n("p"),$.textContent=Nt,yt=o(),G=n("p"),G.textContent=Yt,Mt=o(),X=n("table"),X.innerHTML=At,wt=o(),k=n("p"),k.innerHTML=Lt,bt=o(),R=n("p"),R.innerHTML=St,Tt=o(),m(H.$$.fragment),Jt=o(),F=n("p"),F.innerHTML=Pt,Ut=o(),m(Q.$$.fragment),gt=o(),V=n("p"),V.innerHTML=Dt,jt=o(),m(E.$$.fragment),_t=o(),N=n("p"),N.innerHTML=Kt,Zt=o(),m(Y.$$.fragment),vt=o(),m(M.$$.fragment),qt=o(),m(A.$$.fragment),xt=o(),L=n("ul"),L.innerHTML=Ot,Bt=o(),m(S.$$.fragment),Ct=o(),K=n("p"),this.h()},l(t){const e=re("svelte-u9bgzb",document.head);d=i(e,"META",{name:!0,content:!0}),e.forEach(l),w=s(t),y=i(t,"P",{}),ee(y).forEach(l),P=s(t),p(b.$$.fragment,t),tt=s(t),T=i(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-3zt1h"&&(T.innerHTML=Wt),et=s(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-xmmcvn"&&(J.textContent=$t),lt=s(t),p(U.$$.fragment,t),at=s(t),g=i(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-17lo0nz"&&(g.innerHTML=Gt),ot=s(t),j=i(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1d14wga"&&(j.textContent=Xt),st=s(t),p(_.$$.fragment,t),nt=s(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1gq6iie"&&(Z.innerHTML=kt),it=s(t),p(v.$$.fragment,t),rt=s(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-exfnd4"&&(q.innerHTML=Rt),dt=s(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1fx3nq1"&&(x.innerHTML=Ht),mt=s(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1eoai4f"&&(B.innerHTML=Ft),pt=s(t),C=i(t,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-1m2mgoz"&&(C.innerHTML=Qt),ct=s(t),p(z.$$.fragment,t),ut=s(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1dy3rwb"&&(I.textContent=Vt),ht=s(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-17x1tdo"&&(W.innerHTML=Et),ft=s(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1nbmql6"&&($.textContent=Nt),yt=s(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-4xexxq"&&(G.textContent=Yt),Mt=s(t),X=i(t,"TABLE",{"data-svelte-h":!0}),r(X)!=="svelte-1y0n94l"&&(X.innerHTML=At),wt=s(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1r64eqr"&&(k.innerHTML=Lt),bt=s(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-6zfuzk"&&(R.innerHTML=St),Tt=s(t),p(H.$$.fragment,t),Jt=s(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-x34suv"&&(F.innerHTML=Pt),Ut=s(t),p(Q.$$.fragment,t),gt=s(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1km1qu3"&&(V.innerHTML=Dt),jt=s(t),p(E.$$.fragment,t),_t=s(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1m61wn7"&&(N.innerHTML=Kt),Zt=s(t),p(Y.$$.fragment,t),vt=s(t),p(M.$$.fragment,t),qt=s(t),p(A.$$.fragment,t),xt=s(t),L=i(t,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-ok3vq4"&&(L.innerHTML=Ot),Bt=s(t),p(S.$$.fragment,t),Ct=s(t),K=i(t,"P",{}),ee(K).forEach(l),this.h()},h(){le(d,"name","hf:doc:metadata"),le(d,"content",he)},m(t,e){de(document.head,d),a(t,w,e),a(t,y,e),a(t,P,e),c(b,t,e),a(t,tt,e),a(t,T,e),a(t,et,e),a(t,J,e),a(t,lt,e),c(U,t,e),a(t,at,e),a(t,g,e),a(t,ot,e),a(t,j,e),a(t,st,e),c(_,t,e),a(t,nt,e),a(t,Z,e),a(t,it,e),c(v,t,e),a(t,rt,e),a(t,q,e),a(t,dt,e),a(t,x,e),a(t,mt,e),a(t,B,e),a(t,pt,e),a(t,C,e),a(t,ct,e),c(z,t,e),a(t,ut,e),a(t,I,e),a(t,ht,e),a(t,W,e),a(t,ft,e),a(t,$,e),a(t,yt,e),a(t,G,e),a(t,Mt,e),a(t,X,e),a(t,wt,e),a(t,k,e),a(t,bt,e),a(t,R,e),a(t,Tt,e),c(H,t,e),a(t,Jt,e),a(t,F,e),a(t,Ut,e),c(Q,t,e),a(t,gt,e),a(t,V,e),a(t,jt,e),c(E,t,e),a(t,_t,e),a(t,N,e),a(t,Zt,e),c(Y,t,e),a(t,vt,e),c(M,t,e),a(t,qt,e),c(A,t,e),a(t,xt,e),a(t,L,e),a(t,Bt,e),c(S,t,e),a(t,Ct,e),a(t,K,e),zt=!0},p(t,[e]){const te={};e&2&&(te.$$scope={dirty:e,ctx:t}),M.$set(te)},i(t){zt||(u(b.$$.fragment,t),u(U.$$.fragment,t),u(_.$$.fragment,t),u(v.$$.fragment,t),u(z.$$.fragment,t),u(H.$$.fragment,t),u(Q.$$.fragment,t),u(E.$$.fragment,t),u(Y.$$.fragment,t),u(M.$$.fragment,t),u(A.$$.fragment,t),u(S.$$.fragment,t),zt=!0)},o(t){h(b.$$.fragment,t),h(U.$$.fragment,t),h(_.$$.fragment,t),h(v.$$.fragment,t),h(z.$$.fragment,t),h(H.$$.fragment,t),h(Q.$$.fragment,t),h(E.$$.fragment,t),h(Y.$$.fragment,t),h(M.$$.fragment,t),h(A.$$.fragment,t),h(S.$$.fragment,t),zt=!1},d(t){t&&(l(w),l(y),l(P),l(tt),l(T),l(et),l(J),l(lt),l(at),l(g),l(ot),l(j),l(st),l(nt),l(Z),l(it),l(rt),l(q),l(dt),l(x),l(mt),l(B),l(pt),l(C),l(ct),l(ut),l(I),l(ht),l(W),l(ft),l($),l(yt),l(G),l(Mt),l(X),l(wt),l(k),l(bt),l(R),l(Tt),l(Jt),l(F),l(Ut),l(gt),l(V),l(jt),l(_t),l(N),l(Zt),l(vt),l(qt),l(xt),l(L),l(Bt),l(Ct),l(K)),l(d),f(b,t),f(U,t),f(_,t),f(v,t),f(z,t),f(H,t),f(Q,t),f(E,t),f(Y,t),f(M,t),f(A,t),f(S,t)}}}const he='{"title":"torchao","local":"torchao","sections":[{"title":"Supported quantization types","local":"supported-quantization-types","sections":[],"depth":2},{"title":"Serializing and Deserializing quantized models","local":"serializing-and-deserializing-quantized-models","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function fe(O){return oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Je extends ne{constructor(d){super(),ie(this,d,fe,ue,ae,{})}}export{Je as component};
