import{s as Jt,n as dt,o as ut}from"../chunks/scheduler.6e0d5ff7.js";import{S as bt,i as ft,g as i,s as a,r as o,E as Ut,h as p,f as s,c as n,j as ct,u as y,x as M,k as rt,y as ht,a as e,v as m,d as c,t as r,w as J}from"../chunks/index.d7c1b260.js";import{C as b}from"../chunks/CodeBlock.09a08494.js";import{H as d}from"../chunks/Heading.30a009b0.js";function wt(Fl){let u,al,sl,nl,f,il,U,Hl='<p>**커뮤니티 파이프라인에 대한 자세한 내용은 <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">이 이슈</a>를 참조하세요.</p>',pl,h,ql=`<strong>커뮤니티</strong> 예제는 커뮤니티에서 추가한 추론 및 훈련 예제로 구성되어 있습니다.
다음 표를 참조하여 모든 커뮤니티 예제에 대한 개요를 확인하시기 바랍니다. <strong>코드 예제</strong>를 클릭하면 복사하여 붙여넣기할 수 있는 코드 예제를 확인할 수 있습니다.
커뮤니티가 예상대로 작동하지 않는 경우 이슈를 개설하고 작성자에게 핑을 보내주세요.`,Ml,w,Dl='<thead><tr><th align="left">예</th> <th align="left">설명</th> <th align="left">코드 예제</th> <th align="left">콜랩</th> <th align="right">저자</th></tr></thead> <tbody><tr><td align="left">CLIP Guided Stable Diffusion</td> <td align="left">CLIP 가이드 기반의 Stable Diffusion으로 텍스트에서 이미지로 생성하기</td> <td align="left"><a href="#clip-guided-stable-diffusion">CLIP Guided Stable Diffusion</a></td> <td align="left"><a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/CLIP_Guided_Stable_diffusion_with_diffusers.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="콜랩에서 열기"/></a></td> <td align="right"><a href="https://github.com/patil-suraj/" rel="nofollow">Suraj Patil</a></td></tr> <tr><td align="left">One Step U-Net (Dummy)</td> <td align="left">커뮤니티 파이프라인을 어떻게 사용해야 하는지에 대한 예시(참고 <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">https://github.com/huggingface/diffusers/issues/841</a>)</td> <td align="left"><a href="#one-step-unet">One Step U-Net</a></td> <td align="left">-</td> <td align="right"><a href="https://github.com/patrickvonplaten/" rel="nofollow">Patrick von Platen</a></td></tr> <tr><td align="left">Stable Diffusion Interpolation</td> <td align="left">서로 다른 프롬프트/시드 간 Stable Diffusion의 latent space 보간</td> <td align="left"><a href="#stable-diffusion-interpolation">Stable Diffusion Interpolation</a></td> <td align="left">-</td> <td align="right"><a href="https://github.com/nateraw/" rel="nofollow">Nate Raw</a></td></tr> <tr><td align="left">Stable Diffusion Mega</td> <td align="left">모든 기능을 갖춘 <strong>하나의</strong> Stable Diffusion 파이프라인 <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py" rel="nofollow">Text2Image</a>, <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py" rel="nofollow">Image2Image</a> and <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py" rel="nofollow">Inpainting</a></td> <td align="left"><a href="#stable-diffusion-mega">Stable Diffusion Mega</a></td> <td align="left">-</td> <td align="right"><a href="https://github.com/patrickvonplaten/" rel="nofollow">Patrick von Platen</a></td></tr> <tr><td align="left">Long Prompt Weighting Stable Diffusion</td> <td align="left">토큰 길이 제한이 없고 프롬프트에서 파싱 가중치 지원을 하는 <strong>하나의</strong> Stable Diffusion 파이프라인,</td> <td align="left"><a href="#long-prompt-weighting-stable-diffusion">Long Prompt Weighting Stable Diffusion</a></td> <td align="left">-</td> <td align="right"><a href="https://github.com/SkyTNT" rel="nofollow">SkyTNT</a></td></tr> <tr><td align="left">Speech to Image</td> <td align="left">자동 음성 인식을 사용하여 텍스트를 작성하고 Stable Diffusion을 사용하여 이미지를 생성합니다.</td> <td align="left"><a href="#speech-to-image">Speech to Image</a></td> <td align="left">-</td> <td align="right"><a href="https://github.com/MikailINTech" rel="nofollow">Mikail Duzenli</a></td></tr></tbody>',ol,T,Ll="커스텀 파이프라인을 불러오려면 <code>diffusers/examples/community</code>에 있는 파일 중 하나로서 <code>custom_pipeline</code> 인수를 <code>DiffusionPipeline</code>에 전달하기만 하면 됩니다. 자신만의 파이프라인이 있는 PR을 보내주시면 빠르게 병합해드리겠습니다.",yl,j,ml,g,cl,Z,rl,B,Al="모든 노이즈 제거 단계에서 추가 CLIP 모델을 통해 Stable Diffusion을 가이드함으로써 CLIP 모델 기반의 Stable Diffusion은 보다 더 사실적인 이미지를 생성을 할 수 있습니다.",Jl,G,Pl="다음 코드는 약 12GB의 GPU RAM이 필요합니다.",dl,I,ul,W,Kl="이미지` 목록에는 로컬에 저장하거나 구글 콜랩에 직접 표시할 수 있는 PIL 이미지 목록이 포함되어 있습니다. 생성된 이미지는 기본적으로 안정적인 확산을 사용하는 것보다 품질이 높은 경향이 있습니다. 예를 들어 위의 스크립트는 다음과 같은 이미지를 생성합니다:",bl,C,Ol='<img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/clip_guidance/merged_clip_guidance.jpg" alt="clip_guidance"/>.',fl,V,Ul,k,lt="예시 “one-step-unet”는 다음과 같이 실행할 수 있습니다.",hl,X,wl,R,tt='<strong>참고</strong>: 이 커뮤니티 파이프라인은 기능으로 유용하지 않으며 커뮤니티 파이프라인을 추가할 수 있는 방법의 예시일 뿐입니다(<a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">https://github.com/huggingface/diffusers/issues/841</a> 참조).',Tl,_,jl,v,st="다음 코드는 최소 8GB VRAM의 GPU에서 실행할 수 있으며 약 5분 정도 소요됩니다.",gl,Q,Zl,E,et="walk(…)<code>함수의 출력은</code>output_dir`에 정의된 대로 폴더에 저장된 이미지 목록을 반환합니다. 이 이미지를 사용하여 안정적으로 확산되는 동영상을 만들 수 있습니다.",Bl,S,at='<p>안정된 확산을 이용한 동영상 제작 방법과 더 많은 기능에 대한 자세한 내용은 <a href="https://github.com/nateraw/stable-diffusion-videos" rel="nofollow">https://github.com/nateraw/stable-diffusion-videos</a> 에서 확인하시기 바랍니다.</p>',Gl,Y,Il,x,nt="The Stable Diffusion Mega 파이프라인을 사용하면 Stable Diffusion 파이프라인의 주요 사용 사례를 단일 클래스에서 사용할 수 있습니다.",Wl,N,Cl,$,it="위에 표시된 것처럼 하나의 파이프라인에서 ‘텍스트-이미지 변환’, ‘이미지-이미지 변환’, ‘인페인팅’을 모두 실행할 수 있습니다.",Vl,z,kl,F,pt=`파이프라인을 사용하면 77개의 토큰 길이 제한 없이 프롬프트를 입력할 수 있습니다. 또한 ”()“를 사용하여 단어 가중치를 높이거나 ”[]“를 사용하여 단어 가중치를 낮출 수 있습니다.
또한 파이프라인을 사용하면 단일 클래스에서 Stable Diffusion 파이프라인의 주요 사용 사례를 사용할 수 있습니다.`,Xl,H,Rl,q,_l,D,vl,L,Ql,A,Mt="토큰 인덱스 시퀀스 길이가 이 모델에 지정된 최대 시퀀스 길이보다 길면(*** > 77). 이 시퀀스를 모델에서 실행하면 인덱싱 오류가 발생합니다`. 정상적인 현상이니 걱정하지 마세요.",El,P,Sl,K,ot="다음 코드는 사전학습된 OpenAI whisper-small과 Stable Diffusion을 사용하여 오디오 샘플에서 이미지를 생성할 수 있습니다.",Yl,O,xl,ll,yt="위 예시는 다음의 결과 이미지를 보입니다.",Nl,tl,mt='<img src="https://user-images.githubusercontent.com/45072645/196901736-77d9c6fc-63ee-4072-90b0-dc8b903d63e3.png" alt="image"/>',$l,el,zl;return f=new d({props:{title:"커뮤니티 파이프라인",local:"커뮤니티-파이프라인",headingTag:"h1"}}),j=new b({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyZmlsZW5hbWVfaW5fdGhlX2NvbW11bml0eV9mb2xkZXIlMjIlMEEp",highlighted:`pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;filename_in_the_community_folder&quot;</span>
)`,wrap:!1}}),g=new d({props:{title:"사용 예시",local:"사용-예시",headingTag:"h2"}}),Z=new d({props:{title:"CLIP 가이드 기반의 Stable Diffusion",local:"clip-가이드-기반의-stable-diffusion",headingTag:"h3"}}),I=new b({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel
<span class="hljs-keyword">import</span> torch


feature_extractor = CLIPImageProcessor.from_pretrained(<span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>)
clip_model = CLIPModel.from_pretrained(<span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>, torch_dtype=torch.float16)


guided_pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    torch_dtype=torch.float16,
)
guided_pipeline.enable_attention_slicing()
guided_pipeline = guided_pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;fantasy book cover, full moon, fantasy forest landscape, golden vector elements, fantasy magic, dark light night, intricate, elegant, sharp focus, illustration, highly detailed, digital painting, concept art, matte, art by WLOP and Artgerm and Albert Bierstadt, masterpiece&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = []
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
    image = guided_pipeline(
        prompt,
        num_inference_steps=<span class="hljs-number">50</span>,
        guidance_scale=<span class="hljs-number">7.5</span>,
        clip_guidance_scale=<span class="hljs-number">100</span>,
        num_cutouts=<span class="hljs-number">4</span>,
        use_cutouts=<span class="hljs-literal">False</span>,
        generator=generator,
    ).images[<span class="hljs-number">0</span>]
    images.append(image)

<span class="hljs-comment"># 이미지 로컬에 저장하기</span>
<span class="hljs-keyword">for</span> i, img <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images):
    img.save(<span class="hljs-string">f&quot;./clip_guided_sd/image_<span class="hljs-subst">{i}</span>.png&quot;</span>)`,wrap:!1}}),V=new d({props:{title:"One Step Unet",local:"one-step-unet",headingTag:"h3"}}),X=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMkMlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJvbmVfc3RlcF91bmV0JTIyKSUwQXBpcGUoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;one_step_unet&quot;</span>)
pipe()`,wrap:!1}}),_=new d({props:{title:"Stable Diffusion Interpolation",local:"stable-diffusion-interpolation",headingTag:"h3"}}),Q=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBzYWZldHlfY2hlY2tlciUzRE5vbmUlMkMlMjAlMjAlMjMlMjBWZXJ5JTIwaW1wb3J0YW50JTIwZm9yJTIwdmlkZW9zLi4ubG90cyUyMG9mJTIwZmFsc2UlMjBwb3NpdGl2ZXMlMjB3aGlsZSUyMGludGVycG9sYXRpbmclMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJpbnRlcnBvbGF0ZV9zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCklMEElMEFmcmFtZV9maWxlcGF0aHMlMjAlM0QlMjBwaXBlLndhbGsoJTBBJTIwJTIwJTIwJTIwcHJvbXB0cyUzRCU1QiUyMmElMjBkb2clMjIlMkMlMjAlMjJhJTIwY2F0JTIyJTJDJTIwJTIyYSUyMGhvcnNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2VlZHMlM0QlNUI0MiUyQyUyMDEzMzclMkMlMjAxMjM0JTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ludGVycG9sYXRpb25fc3RlcHMlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGZHJlYW1zJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOC41JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    torch_dtype=torch.float16,
    safety_checker=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># Very important for videos...lots of false positives while interpolating</span>
    custom_pipeline=<span class="hljs-string">&quot;interpolate_stable_diffusion&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.enable_attention_slicing()

frame_filepaths = pipe.walk(
    prompts=[<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>, <span class="hljs-string">&quot;a horse&quot;</span>],
    seeds=[<span class="hljs-number">42</span>, <span class="hljs-number">1337</span>, <span class="hljs-number">1234</span>],
    num_interpolation_steps=<span class="hljs-number">16</span>,
    output_dir=<span class="hljs-string">&quot;./dreams&quot;</span>,
    batch_size=<span class="hljs-number">4</span>,
    height=<span class="hljs-number">512</span>,
    width=<span class="hljs-number">512</span>,
    guidance_scale=<span class="hljs-number">8.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
)`,wrap:!1}}),Y=new d({props:{title:"Stable Diffusion Mega",local:"stable-diffusion-mega",headingTag:"h3"}}),N=new b({props:{code:"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",highlighted:`<span class="hljs-comment">#!/usr/bin/env python3</span>
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;stable_diffusion_mega&quot;</span>,
    torch_dtype=torch.float16,
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.enable_attention_slicing()


<span class="hljs-comment">### Text-to-Image</span>

images = pipe.text2img(<span class="hljs-string">&quot;An astronaut riding a horse&quot;</span>).images

<span class="hljs-comment">### Image-to-Image</span>

init_image = download_image(
    <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
)

prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

images = pipe.img2img(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images

<span class="hljs-comment">### Inpainting</span>

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;a cat sitting on a bench&quot;</span>
images = pipe.inpaint(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.75</span>).images`,wrap:!1}}),z=new d({props:{title:"Long Prompt Weighting Stable Diffusion",local:"long-prompt-weighting-stable-diffusion",headingTag:"h3"}}),H=new d({props:{title:"pytorch",local:"pytorch",headingTag:"h4"}}),q=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmhha3VyZWklMkZ3YWlmdS1kaWZmdXNpb24lMjIlMkMlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJscHdfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmJlc3RfcXVhbGl0eSUyMCgxZ2lybCUzQTEuMyklMjBib3clMjBicmlkZSUyMGJyb3duX2hhaXIlMjBjbG9zZWRfbW91dGglMjBmcmlsbGVkX2JvdyUyMGZyaWxsZWRfaGFpcl90dWJlcyUyMGZyaWxscyUyMChmdWxsX2JvZHklM0ExLjMpJTIwZm94X2VhciUyMGhhaXJfYm93JTIwaGFpcl90dWJlcyUyMGhhcHB5JTIwaG9vZCUyMGphcGFuZXNlX2Nsb3RoZXMlMjBraW1vbm8lMjBsb25nX3NsZWV2ZXMlMjByZWRfYm93JTIwc21pbGUlMjBzb2xvJTIwdGFiaSUyMHVjaGlrYWtlJTIwd2hpdGVfa2ltb25vJTIwd2lkZV9zbGVldmVzJTIwY2hlcnJ5X2Jsb3Nzb21zJTIyJTBBbmVnX3Byb21wdCUyMCUzRCUyMCUyMmxvd3JlcyUyQyUyMGJhZF9hbmF0b215JTJDJTIwZXJyb3JfYm9keSUyQyUyMGVycm9yX2hhaXIlMkMlMjBlcnJvcl9hcm0lMkMlMjBlcnJvcl9oYW5kcyUyQyUyMGJhZF9oYW5kcyUyQyUyMGVycm9yX2ZpbmdlcnMlMkMlMjBiYWRfZmluZ2VycyUyQyUyMG1pc3NpbmdfZmluZ2VycyUyQyUyMGVycm9yX2xlZ3MlMkMlMjBiYWRfbGVncyUyQyUyMG11bHRpcGxlX2xlZ3MlMkMlMjBtaXNzaW5nX2xlZ3MlMkMlMjBlcnJvcl9saWdodGluZyUyQyUyMGVycm9yX3NoYWRvdyUyQyUyMGVycm9yX3JlZmxlY3Rpb24lMkMlMjB0ZXh0JTJDJTIwZXJyb3IlMkMlMjBleHRyYV9kaWdpdCUyQyUyMGZld2VyX2RpZ2l0cyUyQyUyMGNyb3BwZWQlMkMlMjB3b3JzdF9xdWFsaXR5JTJDJTIwbG93X3F1YWxpdHklMkMlMjBub3JtYWxfcXVhbGl0eSUyQyUyMGpwZWdfYXJ0aWZhY3RzJTJDJTIwc2lnbmF0dXJlJTJDJTIwd2F0ZXJtYXJrJTJDJTIwdXNlcm5hbWUlMkMlMjBibHVycnklMjIlMEElMEFwaXBlLnRleHQyaW1nKHByb21wdCUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ19wcm9tcHQlMkMlMjB3aWR0aCUzRDUxMiUyQyUyMGhlaWdodCUzRDUxMiUyQyUyMG1heF9lbWJlZGRpbmdzX211bHRpcGxlcyUzRDMpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;hakurei/waifu-diffusion&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;lpw_stable_diffusion&quot;</span>, torch_dtype=torch.float16
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;best_quality (1girl:1.3) bow bride brown_hair closed_mouth frilled_bow frilled_hair_tubes frills (full_body:1.3) fox_ear hair_bow hair_tubes happy hood japanese_clothes kimono long_sleeves red_bow smile solo tabi uchikake white_kimono wide_sleeves cherry_blossoms&quot;</span>
neg_prompt = <span class="hljs-string">&quot;lowres, bad_anatomy, error_body, error_hair, error_arm, error_hands, bad_hands, error_fingers, bad_fingers, missing_fingers, error_legs, bad_legs, multiple_legs, missing_legs, error_lighting, error_shadow, error_reflection, text, error, extra_digit, fewer_digits, cropped, worst_quality, low_quality, normal_quality, jpeg_artifacts, signature, watermark, username, blurry&quot;</span>

pipe.text2img(prompt, negative_prompt=neg_prompt, width=<span class="hljs-number">512</span>, height=<span class="hljs-number">512</span>, max_embeddings_multiples=<span class="hljs-number">3</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),D=new d({props:{title:"onnxruntime",local:"onnxruntime",headingTag:"h4"}}),L=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJscHdfc3RhYmxlX2RpZmZ1c2lvbl9vbm54JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmV2aXNpb24lM0QlMjJvbm54JTIyJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXIlM0QlMjJDVURBRXhlY3V0aW9uUHJvdmlkZXIlMjIlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyQyUyMGJlc3QlMjBxdWFsaXR5JTIyJTBBbmVnX3Byb21wdCUyMCUzRCUyMCUyMmxvd3JlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjBlcnJvciUyMGJvZHklMkMlMjBlcnJvciUyMGhhaXIlMkMlMjBlcnJvciUyMGFybSUyQyUyMGVycm9yJTIwaGFuZHMlMkMlMjBiYWQlMjBoYW5kcyUyQyUyMGVycm9yJTIwZmluZ2VycyUyQyUyMGJhZCUyMGZpbmdlcnMlMkMlMjBtaXNzaW5nJTIwZmluZ2VycyUyQyUyMGVycm9yJTIwbGVncyUyQyUyMGJhZCUyMGxlZ3MlMkMlMjBtdWx0aXBsZSUyMGxlZ3MlMkMlMjBtaXNzaW5nJTIwbGVncyUyQyUyMGVycm9yJTIwbGlnaHRpbmclMkMlMjBlcnJvciUyMHNoYWRvdyUyQyUyMGVycm9yJTIwcmVmbGVjdGlvbiUyQyUyMHRleHQlMkMlMjBlcnJvciUyQyUyMGV4dHJhJTIwZGlnaXQlMkMlMjBmZXdlciUyMGRpZ2l0cyUyQyUyMGNyb3BwZWQlMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTJDJTIwbm9ybWFsJTIwcXVhbGl0eSUyQyUyMGpwZWclMjBhcnRpZmFjdHMlMkMlMjBzaWduYXR1cmUlMkMlMjB3YXRlcm1hcmslMkMlMjB1c2VybmFtZSUyQyUyMGJsdXJyeSUyMiUwQSUwQXBpcGUudGV4dDJpbWcocHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnX3Byb21wdCUyQyUyMHdpZHRoJTNENTEyJTJDJTIwaGVpZ2h0JTNENTEyJTJDJTIwbWF4X2VtYmVkZGluZ3NfbXVsdGlwbGVzJTNEMykuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;lpw_stable_diffusion_onnx&quot;</span>,
    revision=<span class="hljs-string">&quot;onnx&quot;</span>,
    provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars, best quality&quot;</span>
neg_prompt = <span class="hljs-string">&quot;lowres, bad anatomy, error body, error hair, error arm, error hands, bad hands, error fingers, bad fingers, missing fingers, error legs, bad legs, multiple legs, missing legs, error lighting, error shadow, error reflection, text, error, extra digit, fewer digits, cropped, worst quality, low quality, normal quality, jpeg artifacts, signature, watermark, username, blurry&quot;</span>

pipe.text2img(prompt, negative_prompt=neg_prompt, width=<span class="hljs-number">512</span>, height=<span class="hljs-number">512</span>, max_embeddings_multiples=<span class="hljs-number">3</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),P=new d({props:{title:"Speech to Image",local:"speech-to-image",headingTag:"h3"}}),O=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFpbXBvcnQlMjBtYXRwbG90bGliLnB5cGxvdCUyMGFzJTIwcGx0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwV2hpc3BlclByb2Nlc3NvciUyQyUwQSklMEElMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEElMEFhdWRpb19zYW1wbGUlMjAlM0QlMjBkcyU1QjMlNUQlMEElMEF0ZXh0JTIwJTNEJTIwYXVkaW9fc2FtcGxlJTVCJTIydGV4dCUyMiU1RC5sb3dlcigpJTBBc3BlZWNoX2RhdGElMjAlM0QlMjBhdWRpb19zYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBJTBBbW9kZWwlMjAlM0QlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwV2hpc3BlclByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMiklMEElMEFkaWZmdXNlcl9waXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyc3BlZWNoX3RvX2ltYWdlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwZWVjaF9tb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwc3BlZWNoX3Byb2Nlc3NvciUzRHByb2Nlc3NvciUyQyUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFkaWZmdXNlcl9waXBlbGluZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWRpZmZ1c2VyX3BpcGVsaW5lJTIwJTNEJTIwZGlmZnVzZXJfcGlwZWxpbmUudG8oZGV2aWNlKSUwQSUwQW91dHB1dCUyMCUzRCUyMGRpZmZ1c2VyX3BpcGVsaW5lKHNwZWVjaF9kYXRhKSUwQXBsdC5pbXNob3cob3V0cHV0LmltYWdlcyU1QjAlNUQp",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    WhisperForConditionalGeneration,
    WhisperProcessor,
)


device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)

audio_sample = ds[<span class="hljs-number">3</span>]

text = audio_sample[<span class="hljs-string">&quot;text&quot;</span>].lower()
speech_data = audio_sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]

model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>).to(device)
processor = WhisperProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)

diffuser_pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;speech_to_image_diffusion&quot;</span>,
    speech_model=model,
    speech_processor=processor,
    
    torch_dtype=torch.float16,
)

diffuser_pipeline.enable_attention_slicing()
diffuser_pipeline = diffuser_pipeline.to(device)

output = diffuser_pipeline(speech_data)
plt.imshow(output.images[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){u=i("meta"),al=a(),sl=i("p"),nl=a(),o(f.$$.fragment),il=a(),U=i("blockquote"),U.innerHTML=Hl,pl=a(),h=i("p"),h.innerHTML=ql,Ml=a(),w=i("table"),w.innerHTML=Dl,ol=a(),T=i("p"),T.innerHTML=Ll,yl=a(),o(j.$$.fragment),ml=a(),o(g.$$.fragment),cl=a(),o(Z.$$.fragment),rl=a(),B=i("p"),B.textContent=Al,Jl=a(),G=i("p"),G.textContent=Pl,dl=a(),o(I.$$.fragment),ul=a(),W=i("p"),W.textContent=Kl,bl=a(),C=i("p"),C.innerHTML=Ol,fl=a(),o(V.$$.fragment),Ul=a(),k=i("p"),k.textContent=lt,hl=a(),o(X.$$.fragment),wl=a(),R=i("p"),R.innerHTML=tt,Tl=a(),o(_.$$.fragment),jl=a(),v=i("p"),v.textContent=st,gl=a(),o(Q.$$.fragment),Zl=a(),E=i("p"),E.innerHTML=et,Bl=a(),S=i("blockquote"),S.innerHTML=at,Gl=a(),o(Y.$$.fragment),Il=a(),x=i("p"),x.textContent=nt,Wl=a(),o(N.$$.fragment),Cl=a(),$=i("p"),$.textContent=it,Vl=a(),o(z.$$.fragment),kl=a(),F=i("p"),F.textContent=pt,Xl=a(),o(H.$$.fragment),Rl=a(),o(q.$$.fragment),_l=a(),o(D.$$.fragment),vl=a(),o(L.$$.fragment),Ql=a(),A=i("p"),A.textContent=Mt,El=a(),o(P.$$.fragment),Sl=a(),K=i("p"),K.textContent=ot,Yl=a(),o(O.$$.fragment),xl=a(),ll=i("p"),ll.textContent=yt,Nl=a(),tl=i("p"),tl.innerHTML=mt,$l=a(),el=i("p"),this.h()},l(l){const t=Ut("svelte-u9bgzb",document.head);u=p(t,"META",{name:!0,content:!0}),t.forEach(s),al=n(l),sl=p(l,"P",{}),ct(sl).forEach(s),nl=n(l),y(f.$$.fragment,l),il=n(l),U=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),M(U)!=="svelte-19ufsz0"&&(U.innerHTML=Hl),pl=n(l),h=p(l,"P",{"data-svelte-h":!0}),M(h)!=="svelte-bnjena"&&(h.innerHTML=ql),Ml=n(l),w=p(l,"TABLE",{"data-svelte-h":!0}),M(w)!=="svelte-1vl6gny"&&(w.innerHTML=Dl),ol=n(l),T=p(l,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1gzwrqq"&&(T.innerHTML=Ll),yl=n(l),y(j.$$.fragment,l),ml=n(l),y(g.$$.fragment,l),cl=n(l),y(Z.$$.fragment,l),rl=n(l),B=p(l,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1cjq4kr"&&(B.textContent=Al),Jl=n(l),G=p(l,"P",{"data-svelte-h":!0}),M(G)!=="svelte-h9eqwo"&&(G.textContent=Pl),dl=n(l),y(I.$$.fragment,l),ul=n(l),W=p(l,"P",{"data-svelte-h":!0}),M(W)!=="svelte-rejxd2"&&(W.textContent=Kl),bl=n(l),C=p(l,"P",{"data-svelte-h":!0}),M(C)!=="svelte-rgrio8"&&(C.innerHTML=Ol),fl=n(l),y(V.$$.fragment,l),Ul=n(l),k=p(l,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1ebeix6"&&(k.textContent=lt),hl=n(l),y(X.$$.fragment,l),wl=n(l),R=p(l,"P",{"data-svelte-h":!0}),M(R)!=="svelte-5x0zwg"&&(R.innerHTML=tt),Tl=n(l),y(_.$$.fragment,l),jl=n(l),v=p(l,"P",{"data-svelte-h":!0}),M(v)!=="svelte-wn9810"&&(v.textContent=st),gl=n(l),y(Q.$$.fragment,l),Zl=n(l),E=p(l,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1r04986"&&(E.innerHTML=et),Bl=n(l),S=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),M(S)!=="svelte-bcf8d3"&&(S.innerHTML=at),Gl=n(l),y(Y.$$.fragment,l),Il=n(l),x=p(l,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1d6jh9z"&&(x.textContent=nt),Wl=n(l),y(N.$$.fragment,l),Cl=n(l),$=p(l,"P",{"data-svelte-h":!0}),M($)!=="svelte-1eglsg8"&&($.textContent=it),Vl=n(l),y(z.$$.fragment,l),kl=n(l),F=p(l,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1tc5cfu"&&(F.textContent=pt),Xl=n(l),y(H.$$.fragment,l),Rl=n(l),y(q.$$.fragment,l),_l=n(l),y(D.$$.fragment,l),vl=n(l),y(L.$$.fragment,l),Ql=n(l),A=p(l,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1u20860"&&(A.textContent=Mt),El=n(l),y(P.$$.fragment,l),Sl=n(l),K=p(l,"P",{"data-svelte-h":!0}),M(K)!=="svelte-mnvjvu"&&(K.textContent=ot),Yl=n(l),y(O.$$.fragment,l),xl=n(l),ll=p(l,"P",{"data-svelte-h":!0}),M(ll)!=="svelte-yk4vkv"&&(ll.textContent=yt),Nl=n(l),tl=p(l,"P",{"data-svelte-h":!0}),M(tl)!=="svelte-pca3uz"&&(tl.innerHTML=mt),$l=n(l),el=p(l,"P",{}),ct(el).forEach(s),this.h()},h(){rt(u,"name","hf:doc:metadata"),rt(u,"content",Tt)},m(l,t){ht(document.head,u),e(l,al,t),e(l,sl,t),e(l,nl,t),m(f,l,t),e(l,il,t),e(l,U,t),e(l,pl,t),e(l,h,t),e(l,Ml,t),e(l,w,t),e(l,ol,t),e(l,T,t),e(l,yl,t),m(j,l,t),e(l,ml,t),m(g,l,t),e(l,cl,t),m(Z,l,t),e(l,rl,t),e(l,B,t),e(l,Jl,t),e(l,G,t),e(l,dl,t),m(I,l,t),e(l,ul,t),e(l,W,t),e(l,bl,t),e(l,C,t),e(l,fl,t),m(V,l,t),e(l,Ul,t),e(l,k,t),e(l,hl,t),m(X,l,t),e(l,wl,t),e(l,R,t),e(l,Tl,t),m(_,l,t),e(l,jl,t),e(l,v,t),e(l,gl,t),m(Q,l,t),e(l,Zl,t),e(l,E,t),e(l,Bl,t),e(l,S,t),e(l,Gl,t),m(Y,l,t),e(l,Il,t),e(l,x,t),e(l,Wl,t),m(N,l,t),e(l,Cl,t),e(l,$,t),e(l,Vl,t),m(z,l,t),e(l,kl,t),e(l,F,t),e(l,Xl,t),m(H,l,t),e(l,Rl,t),m(q,l,t),e(l,_l,t),m(D,l,t),e(l,vl,t),m(L,l,t),e(l,Ql,t),e(l,A,t),e(l,El,t),m(P,l,t),e(l,Sl,t),e(l,K,t),e(l,Yl,t),m(O,l,t),e(l,xl,t),e(l,ll,t),e(l,Nl,t),e(l,tl,t),e(l,$l,t),e(l,el,t),zl=!0},p:dt,i(l){zl||(c(f.$$.fragment,l),c(j.$$.fragment,l),c(g.$$.fragment,l),c(Z.$$.fragment,l),c(I.$$.fragment,l),c(V.$$.fragment,l),c(X.$$.fragment,l),c(_.$$.fragment,l),c(Q.$$.fragment,l),c(Y.$$.fragment,l),c(N.$$.fragment,l),c(z.$$.fragment,l),c(H.$$.fragment,l),c(q.$$.fragment,l),c(D.$$.fragment,l),c(L.$$.fragment,l),c(P.$$.fragment,l),c(O.$$.fragment,l),zl=!0)},o(l){r(f.$$.fragment,l),r(j.$$.fragment,l),r(g.$$.fragment,l),r(Z.$$.fragment,l),r(I.$$.fragment,l),r(V.$$.fragment,l),r(X.$$.fragment,l),r(_.$$.fragment,l),r(Q.$$.fragment,l),r(Y.$$.fragment,l),r(N.$$.fragment,l),r(z.$$.fragment,l),r(H.$$.fragment,l),r(q.$$.fragment,l),r(D.$$.fragment,l),r(L.$$.fragment,l),r(P.$$.fragment,l),r(O.$$.fragment,l),zl=!1},d(l){l&&(s(al),s(sl),s(nl),s(il),s(U),s(pl),s(h),s(Ml),s(w),s(ol),s(T),s(yl),s(ml),s(cl),s(rl),s(B),s(Jl),s(G),s(dl),s(ul),s(W),s(bl),s(C),s(fl),s(Ul),s(k),s(hl),s(wl),s(R),s(Tl),s(jl),s(v),s(gl),s(Zl),s(E),s(Bl),s(S),s(Gl),s(Il),s(x),s(Wl),s(Cl),s($),s(Vl),s(kl),s(F),s(Xl),s(Rl),s(_l),s(vl),s(Ql),s(A),s(El),s(Sl),s(K),s(Yl),s(xl),s(ll),s(Nl),s(tl),s($l),s(el)),s(u),J(f,l),J(j,l),J(g,l),J(Z,l),J(I,l),J(V,l),J(X,l),J(_,l),J(Q,l),J(Y,l),J(N,l),J(z,l),J(H,l),J(q,l),J(D,l),J(L,l),J(P,l),J(O,l)}}}const Tt='{"title":"커뮤니티 파이프라인","local":"커뮤니티-파이프라인","sections":[{"title":"사용 예시","local":"사용-예시","sections":[{"title":"CLIP 가이드 기반의 Stable Diffusion","local":"clip-가이드-기반의-stable-diffusion","sections":[],"depth":3},{"title":"One Step Unet","local":"one-step-unet","sections":[],"depth":3},{"title":"Stable Diffusion Interpolation","local":"stable-diffusion-interpolation","sections":[],"depth":3},{"title":"Stable Diffusion Mega","local":"stable-diffusion-mega","sections":[],"depth":3},{"title":"Long Prompt Weighting Stable Diffusion","local":"long-prompt-weighting-stable-diffusion","sections":[{"title":"pytorch","local":"pytorch","sections":[],"depth":4},{"title":"onnxruntime","local":"onnxruntime","sections":[],"depth":4}],"depth":3},{"title":"Speech to Image","local":"speech-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function jt(Fl){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends bt{constructor(u){super(),ft(this,u,jt,wt,Jt,{})}}export{It as component};
