import{s as Ot,o as Kt,n as Ie}from"../chunks/scheduler.182ea377.js";import{S as en,i as tn,g as a,s as r,p as v,A as nn,h as o,f as i,c as p,j as J,q as y,m,k as h,v as t,a as g,r as w,d as $,t as x,u as T}from"../chunks/index.008d68e4.js";import{T as Mt}from"../chunks/Tip.4f096367.js";import{D as j}from"../chunks/Docstring.7aec8b85.js";import{C as St}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as Dt}from"../chunks/IconCopyLink.96bbb92b.js";import{E as Ct}from"../chunks/ExampleCodeBlock.23e54afe.js";function sn(M){let s,_='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',c,l,b='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){s=a("p"),s.innerHTML=_,c=r(),l=a("p"),l.innerHTML=b},l(n){s=o(n,"P",{"data-svelte-h":!0}),m(s)!=="svelte-1j961ct"&&(s.innerHTML=_),c=p(n),l=o(n,"P",{"data-svelte-h":!0}),m(l)!=="svelte-z4pn9c"&&(l.innerHTML=b)},m(n,U){g(n,s,U),g(n,c,U),g(n,l,U)},p:Ie,d(n){n&&(i(s),i(c),i(l))}}}function an(M){let s,_="Examples:",c,l,b;return l=new St({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkxhdGVudFVwc2NhbGVQaXBlbGluZSUyQyUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnNkLXgyLWxhdGVudC11cHNjYWxlciUyMiUwQXVwc2NhbGVyJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uTGF0ZW50VXBzY2FsZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEF1cHNjYWxlci50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjBoaWdoJTIwcmVzb2x1dGlvbiUyQyUyMHVucmVhbCUyMGVuZ2luZSUyQyUyMHVsdHJhJTIwcmVhbGlzdGljJTIyJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMzMpJTBBJTBBbG93X3Jlc19sYXRlbnRzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIpLmltYWdlcyUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGVsaW5lLmRlY29kZV9sYXRlbnRzKGxvd19yZXNfbGF0ZW50cyklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lLm51bXB5X3RvX3BpbChpbWFnZSklNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjIuLiUyRmltYWdlcyUyRmExLnBuZyUyMiklMEElMEF1cHNjYWxlZF9pbWFnZSUyMCUzRCUyMHVwc2NhbGVyKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEbG93X3Jlc19sYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBdXBzY2FsZWRfaW1hZ2Uuc2F2ZSglMjIuLiUyRmltYWdlcyUyRmEyLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionLatentUpscalePipeline, StableDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch


<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/sd-x2-latent-upscaler&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaler = StableDiffusionLatentUpscalePipeline.from_pretrained(model_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaler.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut high resolution, unreal engine, ultra realistic&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">33</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_latents = pipeline(prompt, generator=generator, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    image = pipeline.decode_latents(low_res_latents)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipeline.numpy_to_pil(image)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;../images/a1.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image = upscaler(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    image=low_res_latents,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image.save(<span class="hljs-string">&quot;../images/a2.png&quot;</span>)`}}),{c(){s=a("p"),s.textContent=_,c=r(),v(l.$$.fragment)},l(n){s=o(n,"P",{"data-svelte-h":!0}),m(s)!=="svelte-kvfsh7"&&(s.textContent=_),c=p(n),y(l.$$.fragment,n)},m(n,U){g(n,s,U),g(n,c,U),w(l,n,U),b=!0},p:Ie,i(n){b||($(l.$$.fragment,n),b=!0)},o(n){x(l.$$.fragment,n),b=!1},d(n){n&&(i(s),i(c)),T(l,n)}}}function on(M){let s,_=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){s=a("p"),s.innerHTML=_},l(c){s=o(c,"P",{"data-svelte-h":!0}),m(s)!=="svelte-ackzsn"&&(s.innerHTML=_)},m(c,l){g(c,s,l)},p:Ie,d(c){c&&i(s)}}}function ln(M){let s,_="Examples:",c,l,b;return l=new St({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),{c(){s=a("p"),s.textContent=_,c=r(),v(l.$$.fragment)},l(n){s=o(n,"P",{"data-svelte-h":!0}),m(s)!=="svelte-kvfsh7"&&(s.textContent=_),c=p(n),y(l.$$.fragment,n)},m(n,U){g(n,s,U),g(n,c,U),w(l,n,U),b=!0},p:Ie,i(n){b||($(l.$$.fragment,n),b=!0)},o(n){x(l.$$.fragment,n),b=!1},d(n){n&&(i(s),i(c)),T(l,n)}}}function rn(M){let s,_=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){s=a("p"),s.textContent=_},l(c){s=o(c,"P",{"data-svelte-h":!0}),m(s)!=="svelte-17p1lpg"&&(s.textContent=_)},m(c,l){g(c,s,l)},p:Ie,d(c){c&&i(s)}}}function pn(M){let s,_="Examples:",c,l,b;return l=new St({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`}}),{c(){s=a("p"),s.textContent=_,c=r(),v(l.$$.fragment)},l(n){s=o(n,"P",{"data-svelte-h":!0}),m(s)!=="svelte-kvfsh7"&&(s.textContent=_),c=p(n),y(l.$$.fragment,n)},m(n,U){g(n,s,U),g(n,c,U),w(l,n,U),b=!0},p:Ie,i(n){b||($(l.$$.fragment,n),b=!0)},o(n){x(l.$$.fragment,n),b=!1},d(n){n&&(i(s),i(c)),T(l,n)}}}function cn(M){let s,_,c,l,b,n,U,de,It="Latent upscaler",We,Q,jt='The Stable Diffusion latent upscaler model was created by <a href="https://github.com/crowsonkb/k-diffusion" rel="nofollow">Katherine Crowson</a> in collaboration with <a href="https://stability.ai/" rel="nofollow">Stability AI</a>. It is used to enhance the output image resolution by a factor of 2 (see this demo <a href="https://colab.research.google.com/drive/1o1qYJcFeywzCIdkfKJy7cTpgZTCM2EI4" rel="nofollow">notebook</a> for a demonstration of the original implementation).',Ee,k,Ve,L,G,je,O,Qe,ue,Lt="StableDiffusionLatentUpscalePipeline",Be,f,K,Oe,me,Pt="Pipeline for upscaling Stable Diffusion output image resolution by a factor of 2.",Ke,he,Zt=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,et,ge,kt="The pipeline also inherits the following loading methods:",tt,be,Gt='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',nt,I,ee,st,_e,Wt="The call function to the pipeline for generation.",at,W,ot,E,te,it,ve,Et=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to GPU only when their specific submodule has its <code>forward</code>
method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,lt,D,ne,rt,ye,Vt=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,pt,V,ct,B,ft,R,se,dt,we,Bt=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,ut,C,ae,mt,$e,Rt=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,ht,N,gt,X,bt,F,oe,_t,xe,Nt='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',vt,z,ie,yt,Te,Xt="Disables the FreeU mechanism if enabled.",wt,S,le,$t,Ue,Ft='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',xt,Je,zt="The suffixes after the scaling factors represent the stages where they are being applied.",Tt,Me,Ht=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Re,P,H,Le,re,Ut,De,Yt="StableDiffusionPipelineOutput",Ne,Z,pe,Jt,Ce,qt="Output class for Stable Diffusion pipelines.",Xe;return n=new Dt({}),k=new Mt({props:{$$slots:{default:[sn]},$$scope:{ctx:M}}}),O=new Dt({}),K=new j({props:{name:"class diffusers.StableDiffusionLatentUpscalePipeline",anchor:"diffusers.StableDiffusionLatentUpscalePipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": EulerDiscreteScheduler"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A <a href="/docs/diffusers/v0.25.0/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L63"}}),ee=new j({props:{name:"__call__",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union = None"},{name:"num_inference_steps",val:": int = 75"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": Union = None"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide image upscaling.`,name:"prompt"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be upscaled. If it&#x2019;s a tensor, it can be either a
latent output from a Stable Diffusion model or an image tensor in the range <code>[-1, 1]</code>. It is considered
a <code>latent</code> if <code>image.shape[1]</code> is <code>4</code>; otherwise, it is considered to be an image representation and
encoded using this pipeline&#x2019;s <code>vae</code> encoder.`,name:"image"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L289",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),W=new Ct({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.example",$$slots:{default:[an]},$$scope:{ctx:M}}}),te=new j({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L1484"}}),ne=new j({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2048"}}),V=new Mt({props:{warning:!0,$$slots:{default:[on]},$$scope:{ctx:M}}}),B=new Ct({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing.example",$$slots:{default:[ln]},$$scope:{ctx:M}}}),se=new j({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2088"}}),ae=new j({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L1987"}}),N=new Mt({props:{warning:!0,$$slots:{default:[rn]},$$scope:{ctx:M}}}),X=new Ct({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[pn]},$$scope:{ctx:M}}}),oe=new j({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2022"}}),ie=new j({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L285"}}),le=new j({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L262"}}),re=new Dt({}),pe=new j({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),{c(){s=a("meta"),_=r(),c=a("h1"),l=a("a"),b=a("span"),v(n.$$.fragment),U=r(),de=a("span"),de.textContent=It,We=r(),Q=a("p"),Q.innerHTML=jt,Ee=r(),v(k.$$.fragment),Ve=r(),L=a("h2"),G=a("a"),je=a("span"),v(O.$$.fragment),Qe=r(),ue=a("span"),ue.textContent=Lt,Be=r(),f=a("div"),v(K.$$.fragment),Oe=r(),me=a("p"),me.textContent=Pt,Ke=r(),he=a("p"),he.innerHTML=Zt,et=r(),ge=a("p"),ge.textContent=kt,tt=r(),be=a("ul"),be.innerHTML=Gt,nt=r(),I=a("div"),v(ee.$$.fragment),st=r(),_e=a("p"),_e.textContent=Wt,at=r(),v(W.$$.fragment),ot=r(),E=a("div"),v(te.$$.fragment),it=r(),ve=a("p"),ve.innerHTML=Et,lt=r(),D=a("div"),v(ne.$$.fragment),rt=r(),ye=a("p"),ye.textContent=Vt,pt=r(),v(V.$$.fragment),ct=r(),v(B.$$.fragment),ft=r(),R=a("div"),v(se.$$.fragment),dt=r(),we=a("p"),we.innerHTML=Bt,ut=r(),C=a("div"),v(ae.$$.fragment),mt=r(),$e=a("p"),$e.innerHTML=Rt,ht=r(),v(N.$$.fragment),gt=r(),v(X.$$.fragment),bt=r(),F=a("div"),v(oe.$$.fragment),_t=r(),xe=a("p"),xe.innerHTML=Nt,vt=r(),z=a("div"),v(ie.$$.fragment),yt=r(),Te=a("p"),Te.textContent=Xt,wt=r(),S=a("div"),v(le.$$.fragment),$t=r(),Ue=a("p"),Ue.innerHTML=Ft,xt=r(),Je=a("p"),Je.textContent=zt,Tt=r(),Me=a("p"),Me.innerHTML=Ht,Re=r(),P=a("h2"),H=a("a"),Le=a("span"),v(re.$$.fragment),Ut=r(),De=a("span"),De.textContent=Yt,Ne=r(),Z=a("div"),v(pe.$$.fragment),Jt=r(),Ce=a("p"),Ce.textContent=qt,this.h()},l(e){const d=nn("svelte-1phssyn",document.head);s=o(d,"META",{name:!0,content:!0}),d.forEach(i),_=p(e),c=o(e,"H1",{class:!0});var ce=J(c);l=o(ce,"A",{id:!0,class:!0,href:!0});var Pe=J(l);b=o(Pe,"SPAN",{});var Ze=J(b);y(n.$$.fragment,Ze),Ze.forEach(i),Pe.forEach(i),U=p(ce),de=o(ce,"SPAN",{"data-svelte-h":!0}),m(de)!=="svelte-817joc"&&(de.textContent=It),ce.forEach(i),We=p(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1gpdp46"&&(Q.innerHTML=jt),Ee=p(e),y(k.$$.fragment,e),Ve=p(e),L=o(e,"H2",{class:!0});var fe=J(L);G=o(fe,"A",{id:!0,class:!0,href:!0});var ke=J(G);je=o(ke,"SPAN",{});var Ge=J(je);y(O.$$.fragment,Ge),Ge.forEach(i),ke.forEach(i),Qe=p(fe),ue=o(fe,"SPAN",{"data-svelte-h":!0}),m(ue)!=="svelte-1dlkwz0"&&(ue.textContent=Lt),fe.forEach(i),Be=p(e),f=o(e,"DIV",{class:!0});var u=J(f);y(K.$$.fragment,u),Oe=p(u),me=o(u,"P",{"data-svelte-h":!0}),m(me)!=="svelte-s74qtl"&&(me.textContent=Pt),Ke=p(u),he=o(u,"P",{"data-svelte-h":!0}),m(he)!=="svelte-s6xyvg"&&(he.innerHTML=Zt),et=p(u),ge=o(u,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-14s6m4u"&&(ge.textContent=kt),tt=p(u),be=o(u,"UL",{"data-svelte-h":!0}),m(be)!=="svelte-sx1gxv"&&(be.innerHTML=Gt),nt=p(u),I=o(u,"DIV",{class:!0});var Se=J(I);y(ee.$$.fragment,Se),st=p(Se),_e=o(Se,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-50j04k"&&(_e.textContent=Wt),at=p(Se),y(W.$$.fragment,Se),Se.forEach(i),ot=p(u),E=o(u,"DIV",{class:!0});var Fe=J(E);y(te.$$.fragment,Fe),it=p(Fe),ve=o(Fe,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-n1oyuv"&&(ve.innerHTML=Et),Fe.forEach(i),lt=p(u),D=o(u,"DIV",{class:!0});var Y=J(D);y(ne.$$.fragment,Y),rt=p(Y),ye=o(Y,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-10jaql7"&&(ye.textContent=Vt),pt=p(Y),y(V.$$.fragment,Y),ct=p(Y),y(B.$$.fragment,Y),Y.forEach(i),ft=p(u),R=o(u,"DIV",{class:!0});var ze=J(R);y(se.$$.fragment,ze),dt=p(ze),we=o(ze,"P",{"data-svelte-h":!0}),m(we)!=="svelte-1lh0nh5"&&(we.innerHTML=Bt),ze.forEach(i),ut=p(u),C=o(u,"DIV",{class:!0});var q=J(C);y(ae.$$.fragment,q),mt=p(q),$e=o(q,"P",{"data-svelte-h":!0}),m($e)!=="svelte-e03q3e"&&($e.innerHTML=Rt),ht=p(q),y(N.$$.fragment,q),gt=p(q),y(X.$$.fragment,q),q.forEach(i),bt=p(u),F=o(u,"DIV",{class:!0});var He=J(F);y(oe.$$.fragment,He),_t=p(He),xe=o(He,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-1vfte1e"&&(xe.innerHTML=Nt),He.forEach(i),vt=p(u),z=o(u,"DIV",{class:!0});var Ye=J(z);y(ie.$$.fragment,Ye),yt=p(Ye),Te=o(Ye,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-psupw6"&&(Te.textContent=Xt),Ye.forEach(i),wt=p(u),S=o(u,"DIV",{class:!0});var A=J(S);y(le.$$.fragment,A),$t=p(A),Ue=o(A,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-1f3tmq1"&&(Ue.innerHTML=Ft),xt=p(A),Je=o(A,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-xjijlp"&&(Je.textContent=zt),Tt=p(A),Me=o(A,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-hy0nzs"&&(Me.innerHTML=Ht),A.forEach(i),u.forEach(i),Re=p(e),P=o(e,"H2",{class:!0});var qe=J(P);H=o(qe,"A",{id:!0,class:!0,href:!0});var At=J(H);Le=o(At,"SPAN",{});var Qt=J(Le);y(re.$$.fragment,Qt),Qt.forEach(i),At.forEach(i),Ut=p(qe),De=o(qe,"SPAN",{"data-svelte-h":!0}),m(De)!=="svelte-1ocdz42"&&(De.textContent=Yt),qe.forEach(i),Ne=p(e),Z=o(e,"DIV",{class:!0});var Ae=J(Z);y(pe.$$.fragment,Ae),Jt=p(Ae),Ce=o(Ae,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1qpjiuf"&&(Ce.textContent=qt),Ae.forEach(i),this.h()},h(){h(s,"name","hf:doc:metadata"),h(s,"content",JSON.stringify(fn)),h(l,"id","latent-upscaler"),h(l,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(l,"href","#latent-upscaler"),h(c,"class","relative group"),h(G,"id","diffusers.StableDiffusionLatentUpscalePipeline"),h(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(G,"href","#diffusers.StableDiffusionLatentUpscalePipeline"),h(L,"class","relative group"),h(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(H,"id","diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),h(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(H,"href","#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),h(P,"class","relative group"),h(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,d){t(document.head,s),g(e,_,d),g(e,c,d),t(c,l),t(l,b),w(n,b,null),t(c,U),t(c,de),g(e,We,d),g(e,Q,d),g(e,Ee,d),w(k,e,d),g(e,Ve,d),g(e,L,d),t(L,G),t(G,je),w(O,je,null),t(L,Qe),t(L,ue),g(e,Be,d),g(e,f,d),w(K,f,null),t(f,Oe),t(f,me),t(f,Ke),t(f,he),t(f,et),t(f,ge),t(f,tt),t(f,be),t(f,nt),t(f,I),w(ee,I,null),t(I,st),t(I,_e),t(I,at),w(W,I,null),t(f,ot),t(f,E),w(te,E,null),t(E,it),t(E,ve),t(f,lt),t(f,D),w(ne,D,null),t(D,rt),t(D,ye),t(D,pt),w(V,D,null),t(D,ct),w(B,D,null),t(f,ft),t(f,R),w(se,R,null),t(R,dt),t(R,we),t(f,ut),t(f,C),w(ae,C,null),t(C,mt),t(C,$e),t(C,ht),w(N,C,null),t(C,gt),w(X,C,null),t(f,bt),t(f,F),w(oe,F,null),t(F,_t),t(F,xe),t(f,vt),t(f,z),w(ie,z,null),t(z,yt),t(z,Te),t(f,wt),t(f,S),w(le,S,null),t(S,$t),t(S,Ue),t(S,xt),t(S,Je),t(S,Tt),t(S,Me),g(e,Re,d),g(e,P,d),t(P,H),t(H,Le),w(re,Le,null),t(P,Ut),t(P,De),g(e,Ne,d),g(e,Z,d),w(pe,Z,null),t(Z,Jt),t(Z,Ce),Xe=!0},p(e,[d]){const ce={};d&2&&(ce.$$scope={dirty:d,ctx:e}),k.$set(ce);const Pe={};d&2&&(Pe.$$scope={dirty:d,ctx:e}),W.$set(Pe);const Ze={};d&2&&(Ze.$$scope={dirty:d,ctx:e}),V.$set(Ze);const fe={};d&2&&(fe.$$scope={dirty:d,ctx:e}),B.$set(fe);const ke={};d&2&&(ke.$$scope={dirty:d,ctx:e}),N.$set(ke);const Ge={};d&2&&(Ge.$$scope={dirty:d,ctx:e}),X.$set(Ge)},i(e){Xe||($(n.$$.fragment,e),$(k.$$.fragment,e),$(O.$$.fragment,e),$(K.$$.fragment,e),$(ee.$$.fragment,e),$(W.$$.fragment,e),$(te.$$.fragment,e),$(ne.$$.fragment,e),$(V.$$.fragment,e),$(B.$$.fragment,e),$(se.$$.fragment,e),$(ae.$$.fragment,e),$(N.$$.fragment,e),$(X.$$.fragment,e),$(oe.$$.fragment,e),$(ie.$$.fragment,e),$(le.$$.fragment,e),$(re.$$.fragment,e),$(pe.$$.fragment,e),Xe=!0)},o(e){x(n.$$.fragment,e),x(k.$$.fragment,e),x(O.$$.fragment,e),x(K.$$.fragment,e),x(ee.$$.fragment,e),x(W.$$.fragment,e),x(te.$$.fragment,e),x(ne.$$.fragment,e),x(V.$$.fragment,e),x(B.$$.fragment,e),x(se.$$.fragment,e),x(ae.$$.fragment,e),x(N.$$.fragment,e),x(X.$$.fragment,e),x(oe.$$.fragment,e),x(ie.$$.fragment,e),x(le.$$.fragment,e),x(re.$$.fragment,e),x(pe.$$.fragment,e),Xe=!1},d(e){e&&(i(_),i(c),i(We),i(Q),i(Ee),i(Ve),i(L),i(Be),i(f),i(Re),i(P),i(Ne),i(Z)),i(s),T(n),T(k,e),T(O),T(K),T(ee),T(W),T(te),T(ne),T(V),T(B),T(se),T(ae),T(N),T(X),T(oe),T(ie),T(le),T(re),T(pe)}}}const fn={local:"latent-upscaler",sections:[{local:"diffusers.StableDiffusionLatentUpscalePipeline",title:"StableDiffusionLatentUpscalePipeline"},{local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",title:"StableDiffusionPipelineOutput"}],title:"Latent upscaler"};function dn(M){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yn extends en{constructor(s){super(),tn(this,s,dn,cn,Ot,{})}}export{yn as component};
