import{s as Sd,o as Pd,n as Z}from"../chunks/scheduler.182ea377.js";import{S as Dd,i as Wd,g as i,s,p as f,A as Gd,h as l,f as d,c as a,j as M,q as m,m as p,k as w,v as e,a as y,r as u,d as g,t as h,u as _}from"../chunks/index.008d68e4.js";import{T as Mt}from"../chunks/Tip.4f096367.js";import{D as T}from"../chunks/Docstring.7aec8b85.js";import{C as G}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as Vn}from"../chunks/IconCopyLink.96bbb92b.js";import{E as W}from"../chunks/ExampleCodeBlock.23e54afe.js";function Bd(I){let o,x='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){o=i("p"),o.innerHTML=x},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1wmc0l4"&&(o.innerHTML=x)},m(c,r){y(c,o,r)},p:Z,d(c){c&&d(o)}}}function Fd(I){let o,x="Examples:",c,r,v;return r=new G({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install opencv-python transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> cv2
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = Image.fromarray(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load control net and stable diffusion v1-5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionControlNetPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># speed up diffusion process with faster scheduler and memory optimization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># remove following line if xformers is not installed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention()

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;futuristic-looking woman&quot;</span>, num_inference_steps=<span class="hljs-number">20</span>, generator=generator, image=canny_image
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function Ld(I){let o,x=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=i("p"),o.innerHTML=x},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-ackzsn"&&(o.innerHTML=x)},m(c,r){y(c,o,r)},p:Z,d(c){c&&d(o)}}}function Ed(I){let o,x="Examples:",c,r,v;return r=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function Vd(I){let o,x=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=i("p"),o.textContent=x},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-17p1lpg"&&(o.textContent=x)},m(c,r){y(c,o,r)},p:Z,d(c){c&&d(o)}}}function Xd(I){let o,x="Examples:",c,r,v;return r=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function Rd(I){let o,x="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",c,r,v;return r=new G({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1gc783q"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function Yd(I){let o,x="locally:",c,r,v;return r=new G({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-4c75kq"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function zd(I){let o,x="Examples:",c,r,v;return r=new G({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install opencv-python transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetImg2ImgPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> cv2
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>np_image = np.array(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>np_image = cv2.Canny(np_image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>np_image = np_image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>np_image = np.concatenate([np_image, np_image, np_image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = Image.fromarray(np_image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load control net and stable diffusion v1-5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionControlNetImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># speed up diffusion process with faster scheduler and memory optimization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;futuristic-looking woman&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    control_image=canny_image,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function Hd(I){let o,x=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=i("p"),o.innerHTML=x},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-ackzsn"&&(o.innerHTML=x)},m(c,r){y(c,o,r)},p:Z,d(c){c&&d(o)}}}function Ad(I){let o,x="Examples:",c,r,v;return r=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function Qd(I){let o,x=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=i("p"),o.textContent=x},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-17p1lpg"&&(o.textContent=x)},m(c,r){y(c,o,r)},p:Z,d(c){c&&d(o)}}}function qd(I){let o,x="Examples:",c,r,v;return r=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function Od(I){let o,x="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",c,r,v;return r=new G({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1gc783q"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function Kd(I){let o,x="locally:",c,r,v;return r=new G({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-4c75kq"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function ec(I){let o,x=`This pipeline can be used with checkpoints that have been specifically fine-tuned for inpainting
(<a href="https://huggingface.co/runwayml/stable-diffusion-inpainting" rel="nofollow">runwayml/stable-diffusion-inpainting</a>) as well as
default text-to-image Stable Diffusion checkpoints
(<a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a>). Default text-to-image
Stable Diffusion checkpoints might be preferable for ControlNets that have been fine-tuned on those, such as
<a href="https://huggingface.co/lllyasviel/control_v11p_sd15_inpaint" rel="nofollow">lllyasviel/control_v11p_sd15_inpaint</a>.`;return{c(){o=i("p"),o.innerHTML=x},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-mk8vnx"&&(o.innerHTML=x)},m(c,r){y(c,o,r)},p:Z,d(c){c&&d(o)}}}function tc(I){let o,x="Examples:",c,r,v;return r=new G({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetInpaintPipeline, ControlNetModel, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/test-arrays/resolve/main/stable_diffusion_inpaint/boy.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/test-arrays/resolve/main/stable_diffusion_inpaint/boy_mask.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = mask_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">make_canny_condition</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = np.array(image)
<span class="hljs-meta">... </span>    image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">... </span>    image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">... </span>    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    image = Image.fromarray(image)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = make_canny_condition(init_image)

<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;lllyasviel/control_v11p_sd15_inpaint&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionControlNetInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;a handsome man with ray-ban sunglasses&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    eta=<span class="hljs-number">1.0</span>,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    mask_image=mask_image,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function nc(I){let o,x=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=i("p"),o.innerHTML=x},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-ackzsn"&&(o.innerHTML=x)},m(c,r){y(c,o,r)},p:Z,d(c){c&&d(o)}}}function oc(I){let o,x="Examples:",c,r,v;return r=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function sc(I){let o,x=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=i("p"),o.textContent=x},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-17p1lpg"&&(o.textContent=x)},m(c,r){y(c,o,r)},p:Z,d(c){c&&d(o)}}}function ac(I){let o,x="Examples:",c,r,v;return r=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function ic(I){let o,x="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",c,r,v;return r=new G({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1gc783q"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function lc(I){let o,x="locally:",c,r,v;return r=new G({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-4c75kq"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function rc(I){let o,x="Examples:",c,r,v;return r=new G({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionControlNetPipeline, FlaxControlNetModel


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_key</span>(<span class="hljs-params">seed=<span class="hljs-number">0</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> jax.random.PRNGKey(seed)


<span class="hljs-meta">&gt;&gt;&gt; </span>rng = create_key(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/test-doc-assets/resolve/main/blog_post_cell_10_output_0.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = <span class="hljs-string">&quot;best quality, extremely detailed&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompts = <span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load control net and stable diffusion v1-5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet, controlnet_params = FlaxControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, from_pt=<span class="hljs-literal">True</span>, dtype=jnp.float32
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe, params = FlaxStableDiffusionControlNetPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, revision=<span class="hljs-string">&quot;flax&quot;</span>, dtype=jnp.float32
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>params[<span class="hljs-string">&quot;controlnet&quot;</span>] = controlnet_params

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>rng = jax.random.split(rng, jax.device_count())

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = pipe.prepare_text_inputs([prompts] * num_samples)
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt_ids = pipe.prepare_text_inputs([negative_prompts] * num_samples)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_image = pipe.prepare_image_inputs([canny_image] * num_samples)

<span class="hljs-meta">&gt;&gt;&gt; </span>p_params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt_ids = shard(negative_prompt_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_image = shard(processed_image)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt_ids=prompt_ids,
<span class="hljs-meta">... </span>    image=processed_image,
<span class="hljs-meta">... </span>    params=p_params,
<span class="hljs-meta">... </span>    prng_seed=rng,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    neg_prompt_ids=negative_prompt_ids,
<span class="hljs-meta">... </span>    jit=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>output_images = pipe.numpy_to_pil(np.asarray(output.reshape((num_samples,) + output.shape[-<span class="hljs-number">3</span>:])))
<span class="hljs-meta">&gt;&gt;&gt; </span>output_images = make_image_grid(output_images, num_samples // <span class="hljs-number">4</span>, <span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_images.save(<span class="hljs-string">&quot;generated_image.png&quot;</span>)`}}),{c(){o=i("p"),o.textContent=x,c=s(),f(r.$$.fragment)},l(n){o=l(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=x),c=a(n),m(r.$$.fragment,n)},m(n,C){y(n,o,C),y(n,c,C),u(r,n,C),v=!0},p:Z,i(n){v||(g(r.$$.fragment,n),v=!0)},o(n){h(r.$$.fragment,n),v=!1},d(n){n&&(d(o),d(c)),_(r,n)}}}function dc(I){let o,x,c,r,v,n,C,Xn,ql="ControlNet",Ns,Ct,Ol='ControlNet was introduced in <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">Adding Conditional Control to Text-to-Image Diffusion Models</a> by Lvmin Zhang, Anyi Rao, and Maneesh Agrawala.',Us,It,Kl="With a ControlNet model, you can provide an additional control image to condition and control Stable Diffusion generation. For example, if you provide a depth map, the ControlNet model generates an image that’ll preserve the spatial information from the depth map. It is a more flexible and accurate way to control the image generation process.",ks,Tt,er="The abstract from the paper is:",Zs,$t,tr="<em>We present ControlNet, a neural network architecture to add spatial conditioning controls to large, pretrained text-to-image diffusion models. ControlNet locks the production-ready large diffusion models, and reuses their deep and robust encoding layers pretrained with billions of images as a strong backbone to learn a diverse set of conditional controls. The neural architecture is connected with “zero convolutions” (zero-initialized convolution layers) that progressively grow the parameters from zero and ensure that no harmful noise could affect the finetuning. We test various conditioning controls, eg, edges, depth, segmentation, human pose, etc, with Stable Diffusion, using single or multiple conditions, with or without prompts. We show that the training of ControlNets is robust with small (&lt;50k) and large (&gt;1m) datasets. Extensive results show that ControlNet may facilitate wider applications to control image diffusion models.</em>",Ss,Jt,nr='This model was contributed by <a href="https://huggingface.co/takuma104" rel="nofollow">takuma104</a>. ❤️',Ps,jt,or='The original codebase can be found at <a href="https://github.com/lllyasviel/ControlNet" rel="nofollow">lllyasviel/ControlNet</a>, and you can find official ControlNet checkpoints on <a href="https://huggingface.co/lllyasviel" rel="nofollow">lllyasviel’s</a> Hub profile.',Ds,ue,Ws,ie,ge,bs,Nt,ba,Rn,sr="StableDiffusionControlNetPipeline",Gs,$,Ut,va,Yn,ar="Pipeline for text-to-image generation using Stable Diffusion with ControlNet guidance.",ya,zn,ir=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,wa,Hn,lr="The pipeline also inherits the following loading methods:",xa,An,rr='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Ma,ne,kt,Ca,Qn,dr="The call function to the pipeline for generation.",Ia,he,Ta,L,Zt,$a,qn,cr=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Ja,_e,ja,be,Na,ve,St,Ua,On,pr=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,ka,ye,Pt,Za,Kn,fr=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Sa,we,Dt,Pa,eo,mr=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Da,E,Wt,Wa,to,ur=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Ga,xe,Ba,Me,Fa,Ce,Gt,La,no,gr='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Ea,S,Bt,Va,oo,hr=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Xa,so,_r="Example:",Ra,Ie,Ya,ao,br=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,za,Te,Ha,$e,Ft,Aa,io,vr="Disables the FreeU mechanism if enabled.",Qa,Je,Lt,qa,lo,yr=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Oa,V,Et,Ka,ro,wr='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',ei,co,xr="The suffixes after the scaling factors represent the stages where they are being applied.",ti,po,Mr=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,ni,je,Vt,oi,fo,Cr=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,si,Ne,Xt,ai,mo,Ir="Encodes the prompt into text encoder hidden states.",ii,Ue,Rt,li,uo,Tr='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Bs,le,ke,vs,Yt,ri,go,$r="StableDiffusionControlNetImg2ImgPipeline",Fs,j,zt,di,ho,Jr="Pipeline for image-to-image generation using Stable Diffusion with ControlNet guidance.",ci,_o,jr=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,pi,bo,Nr="The pipeline also inherits the following loading methods:",fi,vo,Ur='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',mi,oe,Ht,ui,yo,kr="The call function to the pipeline for generation.",gi,Ze,hi,X,At,_i,wo,Zr=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,bi,Se,vi,Pe,yi,De,Qt,wi,xo,Sr=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,xi,We,qt,Mi,Mo,Pr=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ci,Ge,Ot,Ii,Co,Dr=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ti,R,Kt,$i,Io,Wr=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Ji,Be,ji,Fe,Ni,Le,en,Ui,To,Gr='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',ki,P,tn,Zi,$o,Br=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Si,Jo,Fr="Example:",Pi,Ee,Di,jo,Lr=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Wi,Ve,Gi,Xe,nn,Bi,No,Er="Disables the FreeU mechanism if enabled.",Fi,Re,on,Li,Uo,Vr=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ei,Y,sn,Vi,ko,Xr='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Xi,Zo,Rr="The suffixes after the scaling factors represent the stages where they are being applied.",Ri,So,Yr=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Yi,Ye,an,zi,Po,zr=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Hi,ze,ln,Ai,Do,Hr="Encodes the prompt into text encoder hidden states.",Ls,re,He,ys,rn,Qi,Wo,Ar="StableDiffusionControlNetInpaintPipeline",Es,J,dn,qi,Go,Qr="Pipeline for image inpainting using Stable Diffusion with ControlNet guidance.",Oi,Bo,qr=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ki,Fo,Or="The pipeline also inherits the following loading methods:",el,Lo,Kr='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',tl,Ae,nl,se,cn,ol,Eo,ed="The call function to the pipeline for generation.",sl,Qe,al,z,pn,il,Vo,td=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,ll,qe,rl,Oe,dl,Ke,fn,cl,Xo,nd=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,pl,et,mn,fl,Ro,od=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,ml,tt,un,ul,Yo,sd=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,gl,H,gn,hl,zo,ad=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,_l,nt,bl,ot,vl,st,hn,yl,Ho,id='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',wl,D,_n,xl,Ao,ld=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Ml,Qo,rd="Example:",Cl,at,Il,qo,dd=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Tl,it,$l,lt,bn,Jl,Oo,cd="Disables the FreeU mechanism if enabled.",jl,rt,vn,Nl,Ko,pd=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ul,A,yn,kl,es,fd='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Zl,ts,md="The suffixes after the scaling factors represent the stages where they are being applied.",Sl,ns,ud=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Pl,dt,wn,Dl,os,gd=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Wl,ct,xn,Gl,ss,hd="Encodes the prompt into text encoder hidden states.",Vs,de,pt,ws,Mn,Bl,as,_d="StableDiffusionPipelineOutput",Xs,ce,Cn,Fl,is,bd="Output class for Stable Diffusion pipelines.",Rs,pe,ft,xs,In,Ll,ls,vd="FlaxStableDiffusionControlNetPipeline",Ys,F,Tn,El,rs,yd="Flax-based pipeline for text-to-image generation using Stable Diffusion with ControlNet Guidance.",Vl,ds,wd=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Xl,ae,$n,Rl,cs,xd="The call function to the pipeline for generation.",Yl,mt,zs,fe,ut,Ms,Jn,zl,ps,Md="FlaxStableDiffusionControlNetPipelineOutput",Hs,O,jn,Hl,fs,Cd="Output class for Flax-based Stable Diffusion pipelines.",Al,gt,Nn,Ql,ms,Id="“Returns a new object replacing the specified fields with new values.",As;return n=new Vn({}),ue=new Mt({props:{$$slots:{default:[Bd]},$$scope:{ctx:I}}}),Nt=new Vn({}),Ut=new T({props:{name:"class diffusers.StableDiffusionControlNetPipeline",anchor:"diffusers.StableDiffusionControlNetPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionControlNetPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionControlNetPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionControlNetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionControlNetPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionControlNetPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L139"}}),kt=new T({props:{name:"__call__",anchor:"diffusers.StableDiffusionControlNetPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.FloatTensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be
accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in
<code>init</code>, images must be passed as a list such that each element of the list can be correctly batched for
input to a single ControlNet.`,name:"image"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L865",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),he=new W({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.example",$$slots:{default:[Fd]},$$scope:{ctx:I}}}),Zt=new T({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2048"}}),_e=new Mt({props:{warning:!0,$$slots:{default:[Ld]},$$scope:{ctx:I}}}),be=new W({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_attention_slicing.example",$$slots:{default:[Ed]},$$scope:{ctx:I}}}),St=new T({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2088"}}),Pt=new T({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L237"}}),Dt=new T({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L245"}}),Wt=new T({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L1987"}}),xe=new Mt({props:{warning:!0,$$slots:{default:[Vd]},$$scope:{ctx:I}}}),Me=new W({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Xd]},$$scope:{ctx:I}}}),Gt=new T({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2022"}}),Bt=new T({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/loaders/textual_inversion.py#L265"}}),Ie=new W({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.example",$$slots:{default:[Rd]},$$scope:{ctx:I}}}),Te=new W({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.example-2",$$slots:{default:[Yd]},$$scope:{ctx:I}}}),Ft=new T({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionControlNetPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L809"}}),Lt=new T({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L262"}}),Et=new T({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionControlNetPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L786"}}),Vt=new T({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L253"}}),Xt=new T({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L303"}}),Rt=new T({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionControlNetPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:""},{name:"embedding_dim",val:" = 512"},{name:"dtype",val:" = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.get_guidance_scale_embedding.timesteps",description:`<strong>timesteps</strong> (<code>torch.Tensor</code>) &#x2014;
generate embedding vectors at these timesteps`,name:"timesteps"},{anchor:"diffusers.StableDiffusionControlNetPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
dimension of the embeddings to generate
dtype &#x2014;
data type of the generated embeddings`,name:"embedding_dim"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L814",returnDescription:`
<p>Embedding vectors with shape <code>(len(timesteps), embedding_dim)</code></p>
`,returnType:`
<p><code>torch.FloatTensor</code></p>
`}}),Yt=new Vn({}),zt=new T({props:{name:"class diffusers.StableDiffusionControlNetImg2ImgPipeline",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L132"}}),Ht=new T({props:{name:"__call__",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"control_image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 0.8"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The initial image to be used as the starting point for the image generation process. Can also accept
image latents as <code>image</code>, and if passing latents directly they are not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.FloatTensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be
accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in
<code>init</code>, images must be passed as a list such that each element of the list can be correctly batched for
input to a single ControlNet.`,name:"control_image"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L876",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),Ze=new W({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.example",$$slots:{default:[zd]},$$scope:{ctx:I}}}),At=new T({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2048"}}),Se=new Mt({props:{warning:!0,$$slots:{default:[Hd]},$$scope:{ctx:I}}}),Pe=new W({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[Ad]},$$scope:{ctx:I}}}),Qt=new T({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2088"}}),qt=new T({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L230"}}),Ot=new T({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L238"}}),Kt=new T({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L1987"}}),Be=new Mt({props:{warning:!0,$$slots:{default:[Qd]},$$scope:{ctx:I}}}),Fe=new W({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[qd]},$$scope:{ctx:I}}}),en=new T({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2022"}}),tn=new T({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/loaders/textual_inversion.py#L265"}}),Ee=new W({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.example",$$slots:{default:[Od]},$$scope:{ctx:I}}}),Ve=new W({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.example-2",$$slots:{default:[Kd]},$$scope:{ctx:I}}}),nn=new T({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L849"}}),on=new T({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L255"}}),sn=new T({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L826"}}),an=new T({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L246"}}),ln=new T({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L296"}}),rn=new Vn({}),dn=new T({props:{name:"class diffusers.StableDiffusionControlNetInpaintPipeline",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L243"}}),Ae=new Mt({props:{$$slots:{default:[ec]},$$scope:{ctx:I}}}),cn=new T({props:{name:"__call__",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"mask_image",val:": Union = None"},{name:"control_image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"strength",val:": float = 1.0"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 0.5"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, &#x2014;
<code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>):
<code>Image</code>, NumPy array or tensor representing an image batch to be used as the starting point. For both
NumPy array and PyTorch tensor, the expected value range is between <code>[0, 1]</code>. If it&#x2019;s a tensor or a
list or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a NumPy array or
a list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code>. It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, &#x2014;
<code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>):
<code>Image</code>, NumPy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a NumPy array or PyTorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for PyTorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for NumPy array, it would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.FloatTensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be
accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in
<code>init</code>, images must be passed as a list such that each element of the list can be correctly batched for
input to a single ControlNet.`,name:"control_image"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L1067",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),Qe=new W({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.example",$$slots:{default:[tc]},$$scope:{ctx:I}}}),pn=new T({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2048"}}),qe=new Mt({props:{warning:!0,$$slots:{default:[nc]},$$scope:{ctx:I}}}),Oe=new W({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_attention_slicing.example",$$slots:{default:[oc]},$$scope:{ctx:I}}}),fn=new T({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2088"}}),mn=new T({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L355"}}),un=new T({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L363"}}),gn=new T({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L1987"}}),nt=new Mt({props:{warning:!0,$$slots:{default:[sc]},$$scope:{ctx:I}}}),ot=new W({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ac]},$$scope:{ctx:I}}}),hn=new T({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2022"}}),_n=new T({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/loaders/textual_inversion.py#L265"}}),at=new W({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.example",$$slots:{default:[ic]},$$scope:{ctx:I}}}),it=new W({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.example-2",$$slots:{default:[lc]},$$scope:{ctx:I}}}),bn=new T({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L1040"}}),vn=new T({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L380"}}),yn=new T({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L1017"}}),wn=new T({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L371"}}),xn=new T({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L421"}}),Mn=new Vn({}),Cn=new T({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),In=new Vn({}),Tn=new T({props:{name:"class diffusers.FlaxStableDiffusionControlNetPipeline",anchor:"diffusers.FlaxStableDiffusionControlNetPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"controlnet",val:": FlaxControlNetModel"},{name:"scheduler",val:": Union"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPFeatureExtractor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.FlaxCLIPTextModel" rel="nofollow">FlaxCLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/controlnet#diffusers.FlaxControlNetModel">FlaxControlNetModel</a> &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process.`,name:"controlnet"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_flax_controlnet.py#L111"}}),$n=new T({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__",parameters:[{name:"prompt_ids",val:": Array"},{name:"image",val:": Array"},{name:"params",val:": Union"},{name:"prng_seed",val:": Array"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": Union = 7.5"},{name:"latents",val:": Array = None"},{name:"neg_prompt_ids",val:": Array = None"},{name:"controlnet_conditioning_scale",val:": Union = 1.0"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.prompt_ids",description:`<strong>prompt_ids</strong> (<code>jnp.ndarray</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt_ids"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>jnp.ndarray</code>) &#x2014;
Array representing the ControlNet input condition to provide guidance to the <code>unet</code> for generation.`,name:"image"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.params",description:`<strong>params</strong> (<code>Dict</code> or <code>FrozenDict</code>) &#x2014;
Dictionary containing the model parameters/weights.`,name:"params"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.prng_seed",description:`<strong>prng_seed</strong> (<code>jax.Array</code>) &#x2014;
Array containing random number generator key.`,name:"prng_seed"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>jnp.ndarray</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
array is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>jnp.ndarray</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_flax_controlnet.py#L348",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),mt=new W({props:{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.example",$$slots:{default:[rc]},$$scope:{ctx:I}}}),Jn=new Vn({}),jn=new T({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": List"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L31"}}),Nn=new T({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/flax/struct.py#L110"}}),{c(){o=i("meta"),x=s(),c=i("h1"),r=i("a"),v=i("span"),f(n.$$.fragment),C=s(),Xn=i("span"),Xn.textContent=ql,Ns=s(),Ct=i("p"),Ct.innerHTML=Ol,Us=s(),It=i("p"),It.textContent=Kl,ks=s(),Tt=i("p"),Tt.textContent=er,Zs=s(),$t=i("p"),$t.innerHTML=tr,Ss=s(),Jt=i("p"),Jt.innerHTML=nr,Ps=s(),jt=i("p"),jt.innerHTML=or,Ds=s(),f(ue.$$.fragment),Ws=s(),ie=i("h2"),ge=i("a"),bs=i("span"),f(Nt.$$.fragment),ba=s(),Rn=i("span"),Rn.textContent=sr,Gs=s(),$=i("div"),f(Ut.$$.fragment),va=s(),Yn=i("p"),Yn.textContent=ar,ya=s(),zn=i("p"),zn.innerHTML=ir,wa=s(),Hn=i("p"),Hn.textContent=lr,xa=s(),An=i("ul"),An.innerHTML=rr,Ma=s(),ne=i("div"),f(kt.$$.fragment),Ca=s(),Qn=i("p"),Qn.textContent=dr,Ia=s(),f(he.$$.fragment),Ta=s(),L=i("div"),f(Zt.$$.fragment),$a=s(),qn=i("p"),qn.textContent=cr,Ja=s(),f(_e.$$.fragment),ja=s(),f(be.$$.fragment),Na=s(),ve=i("div"),f(St.$$.fragment),Ua=s(),On=i("p"),On.innerHTML=pr,ka=s(),ye=i("div"),f(Pt.$$.fragment),Za=s(),Kn=i("p"),Kn.textContent=fr,Sa=s(),we=i("div"),f(Dt.$$.fragment),Pa=s(),eo=i("p"),eo.innerHTML=mr,Da=s(),E=i("div"),f(Wt.$$.fragment),Wa=s(),to=i("p"),to.innerHTML=ur,Ga=s(),f(xe.$$.fragment),Ba=s(),f(Me.$$.fragment),Fa=s(),Ce=i("div"),f(Gt.$$.fragment),La=s(),no=i("p"),no.innerHTML=gr,Ea=s(),S=i("div"),f(Bt.$$.fragment),Va=s(),oo=i("p"),oo.innerHTML=hr,Xa=s(),so=i("p"),so.textContent=_r,Ra=s(),f(Ie.$$.fragment),Ya=s(),ao=i("p"),ao.innerHTML=br,za=s(),f(Te.$$.fragment),Ha=s(),$e=i("div"),f(Ft.$$.fragment),Aa=s(),io=i("p"),io.textContent=vr,Qa=s(),Je=i("div"),f(Lt.$$.fragment),qa=s(),lo=i("p"),lo.innerHTML=yr,Oa=s(),V=i("div"),f(Et.$$.fragment),Ka=s(),ro=i("p"),ro.innerHTML=wr,ei=s(),co=i("p"),co.textContent=xr,ti=s(),po=i("p"),po.innerHTML=Mr,ni=s(),je=i("div"),f(Vt.$$.fragment),oi=s(),fo=i("p"),fo.textContent=Cr,si=s(),Ne=i("div"),f(Xt.$$.fragment),ai=s(),mo=i("p"),mo.textContent=Ir,ii=s(),Ue=i("div"),f(Rt.$$.fragment),li=s(),uo=i("p"),uo.innerHTML=Tr,Bs=s(),le=i("h2"),ke=i("a"),vs=i("span"),f(Yt.$$.fragment),ri=s(),go=i("span"),go.textContent=$r,Fs=s(),j=i("div"),f(zt.$$.fragment),di=s(),ho=i("p"),ho.textContent=Jr,ci=s(),_o=i("p"),_o.innerHTML=jr,pi=s(),bo=i("p"),bo.textContent=Nr,fi=s(),vo=i("ul"),vo.innerHTML=Ur,mi=s(),oe=i("div"),f(Ht.$$.fragment),ui=s(),yo=i("p"),yo.textContent=kr,gi=s(),f(Ze.$$.fragment),hi=s(),X=i("div"),f(At.$$.fragment),_i=s(),wo=i("p"),wo.textContent=Zr,bi=s(),f(Se.$$.fragment),vi=s(),f(Pe.$$.fragment),yi=s(),De=i("div"),f(Qt.$$.fragment),wi=s(),xo=i("p"),xo.innerHTML=Sr,xi=s(),We=i("div"),f(qt.$$.fragment),Mi=s(),Mo=i("p"),Mo.textContent=Pr,Ci=s(),Ge=i("div"),f(Ot.$$.fragment),Ii=s(),Co=i("p"),Co.innerHTML=Dr,Ti=s(),R=i("div"),f(Kt.$$.fragment),$i=s(),Io=i("p"),Io.innerHTML=Wr,Ji=s(),f(Be.$$.fragment),ji=s(),f(Fe.$$.fragment),Ni=s(),Le=i("div"),f(en.$$.fragment),Ui=s(),To=i("p"),To.innerHTML=Gr,ki=s(),P=i("div"),f(tn.$$.fragment),Zi=s(),$o=i("p"),$o.innerHTML=Br,Si=s(),Jo=i("p"),Jo.textContent=Fr,Pi=s(),f(Ee.$$.fragment),Di=s(),jo=i("p"),jo.innerHTML=Lr,Wi=s(),f(Ve.$$.fragment),Gi=s(),Xe=i("div"),f(nn.$$.fragment),Bi=s(),No=i("p"),No.textContent=Er,Fi=s(),Re=i("div"),f(on.$$.fragment),Li=s(),Uo=i("p"),Uo.innerHTML=Vr,Ei=s(),Y=i("div"),f(sn.$$.fragment),Vi=s(),ko=i("p"),ko.innerHTML=Xr,Xi=s(),Zo=i("p"),Zo.textContent=Rr,Ri=s(),So=i("p"),So.innerHTML=Yr,Yi=s(),Ye=i("div"),f(an.$$.fragment),zi=s(),Po=i("p"),Po.textContent=zr,Hi=s(),ze=i("div"),f(ln.$$.fragment),Ai=s(),Do=i("p"),Do.textContent=Hr,Ls=s(),re=i("h2"),He=i("a"),ys=i("span"),f(rn.$$.fragment),Qi=s(),Wo=i("span"),Wo.textContent=Ar,Es=s(),J=i("div"),f(dn.$$.fragment),qi=s(),Go=i("p"),Go.textContent=Qr,Oi=s(),Bo=i("p"),Bo.innerHTML=qr,Ki=s(),Fo=i("p"),Fo.textContent=Or,el=s(),Lo=i("ul"),Lo.innerHTML=Kr,tl=s(),f(Ae.$$.fragment),nl=s(),se=i("div"),f(cn.$$.fragment),ol=s(),Eo=i("p"),Eo.textContent=ed,sl=s(),f(Qe.$$.fragment),al=s(),z=i("div"),f(pn.$$.fragment),il=s(),Vo=i("p"),Vo.textContent=td,ll=s(),f(qe.$$.fragment),rl=s(),f(Oe.$$.fragment),dl=s(),Ke=i("div"),f(fn.$$.fragment),cl=s(),Xo=i("p"),Xo.innerHTML=nd,pl=s(),et=i("div"),f(mn.$$.fragment),fl=s(),Ro=i("p"),Ro.textContent=od,ml=s(),tt=i("div"),f(un.$$.fragment),ul=s(),Yo=i("p"),Yo.innerHTML=sd,gl=s(),H=i("div"),f(gn.$$.fragment),hl=s(),zo=i("p"),zo.innerHTML=ad,_l=s(),f(nt.$$.fragment),bl=s(),f(ot.$$.fragment),vl=s(),st=i("div"),f(hn.$$.fragment),yl=s(),Ho=i("p"),Ho.innerHTML=id,wl=s(),D=i("div"),f(_n.$$.fragment),xl=s(),Ao=i("p"),Ao.innerHTML=ld,Ml=s(),Qo=i("p"),Qo.textContent=rd,Cl=s(),f(at.$$.fragment),Il=s(),qo=i("p"),qo.innerHTML=dd,Tl=s(),f(it.$$.fragment),$l=s(),lt=i("div"),f(bn.$$.fragment),Jl=s(),Oo=i("p"),Oo.textContent=cd,jl=s(),rt=i("div"),f(vn.$$.fragment),Nl=s(),Ko=i("p"),Ko.innerHTML=pd,Ul=s(),A=i("div"),f(yn.$$.fragment),kl=s(),es=i("p"),es.innerHTML=fd,Zl=s(),ts=i("p"),ts.textContent=md,Sl=s(),ns=i("p"),ns.innerHTML=ud,Pl=s(),dt=i("div"),f(wn.$$.fragment),Dl=s(),os=i("p"),os.textContent=gd,Wl=s(),ct=i("div"),f(xn.$$.fragment),Gl=s(),ss=i("p"),ss.textContent=hd,Vs=s(),de=i("h2"),pt=i("a"),ws=i("span"),f(Mn.$$.fragment),Bl=s(),as=i("span"),as.textContent=_d,Xs=s(),ce=i("div"),f(Cn.$$.fragment),Fl=s(),is=i("p"),is.textContent=bd,Rs=s(),pe=i("h2"),ft=i("a"),xs=i("span"),f(In.$$.fragment),Ll=s(),ls=i("span"),ls.textContent=vd,Ys=s(),F=i("div"),f(Tn.$$.fragment),El=s(),rs=i("p"),rs.textContent=yd,Vl=s(),ds=i("p"),ds.innerHTML=wd,Xl=s(),ae=i("div"),f($n.$$.fragment),Rl=s(),cs=i("p"),cs.textContent=xd,Yl=s(),f(mt.$$.fragment),zs=s(),fe=i("h2"),ut=i("a"),Ms=i("span"),f(Jn.$$.fragment),zl=s(),ps=i("span"),ps.textContent=Md,Hs=s(),O=i("div"),f(jn.$$.fragment),Hl=s(),fs=i("p"),fs.textContent=Cd,Al=s(),gt=i("div"),f(Nn.$$.fragment),Ql=s(),ms=i("p"),ms.textContent=Id,this.h()},l(t){const b=Gd("svelte-1phssyn",document.head);o=l(b,"META",{name:!0,content:!0}),b.forEach(d),x=a(t),c=l(t,"H1",{class:!0});var Un=M(c);r=l(Un,"A",{id:!0,class:!0,href:!0});var Cs=M(r);v=l(Cs,"SPAN",{});var Is=M(v);m(n.$$.fragment,Is),Is.forEach(d),Cs.forEach(d),C=a(Un),Xn=l(Un,"SPAN",{"data-svelte-h":!0}),p(Xn)!=="svelte-1147sj1"&&(Xn.textContent=ql),Un.forEach(d),Ns=a(t),Ct=l(t,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-1v2xz23"&&(Ct.innerHTML=Ol),Us=a(t),It=l(t,"P",{"data-svelte-h":!0}),p(It)!=="svelte-1dn0wji"&&(It.textContent=Kl),ks=a(t),Tt=l(t,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-1cwsb16"&&(Tt.textContent=er),Zs=a(t),$t=l(t,"P",{"data-svelte-h":!0}),p($t)!=="svelte-fbiw6t"&&($t.innerHTML=tr),Ss=a(t),Jt=l(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-lv721a"&&(Jt.innerHTML=nr),Ps=a(t),jt=l(t,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-6h8iw0"&&(jt.innerHTML=or),Ds=a(t),m(ue.$$.fragment,t),Ws=a(t),ie=l(t,"H2",{class:!0});var kn=M(ie);ge=l(kn,"A",{id:!0,class:!0,href:!0});var Ts=M(ge);bs=l(Ts,"SPAN",{});var $s=M(bs);m(Nt.$$.fragment,$s),$s.forEach(d),Ts.forEach(d),ba=a(kn),Rn=l(kn,"SPAN",{"data-svelte-h":!0}),p(Rn)!=="svelte-17ukoxb"&&(Rn.textContent=sr),kn.forEach(d),Gs=a(t),$=l(t,"DIV",{class:!0});var N=M($);m(Ut.$$.fragment,N),va=a(N),Yn=l(N,"P",{"data-svelte-h":!0}),p(Yn)!=="svelte-1or48uk"&&(Yn.textContent=ar),ya=a(N),zn=l(N,"P",{"data-svelte-h":!0}),p(zn)!=="svelte-s6xyvg"&&(zn.innerHTML=ir),wa=a(N),Hn=l(N,"P",{"data-svelte-h":!0}),p(Hn)!=="svelte-14s6m4u"&&(Hn.textContent=lr),xa=a(N),An=l(N,"UL",{"data-svelte-h":!0}),p(An)!=="svelte-1kastu5"&&(An.innerHTML=rr),Ma=a(N),ne=l(N,"DIV",{class:!0});var me=M(ne);m(kt.$$.fragment,me),Ca=a(me),Qn=l(me,"P",{"data-svelte-h":!0}),p(Qn)!=="svelte-50j04k"&&(Qn.textContent=dr),Ia=a(me),m(he.$$.fragment,me),me.forEach(d),Ta=a(N),L=l(N,"DIV",{class:!0});var K=M(L);m(Zt.$$.fragment,K),$a=a(K),qn=l(K,"P",{"data-svelte-h":!0}),p(qn)!=="svelte-10jaql7"&&(qn.textContent=cr),Ja=a(K),m(_e.$$.fragment,K),ja=a(K),m(be.$$.fragment,K),K.forEach(d),Na=a(N),ve=l(N,"DIV",{class:!0});var Zn=M(ve);m(St.$$.fragment,Zn),Ua=a(Zn),On=l(Zn,"P",{"data-svelte-h":!0}),p(On)!=="svelte-1lh0nh5"&&(On.innerHTML=pr),Zn.forEach(d),ka=a(N),ye=l(N,"DIV",{class:!0});var Sn=M(ye);m(Pt.$$.fragment,Sn),Za=a(Sn),Kn=l(Sn,"P",{"data-svelte-h":!0}),p(Kn)!=="svelte-14bnrb6"&&(Kn.textContent=fr),Sn.forEach(d),Sa=a(N),we=l(N,"DIV",{class:!0});var Pn=M(we);m(Dt.$$.fragment,Pn),Pa=a(Pn),eo=l(Pn,"P",{"data-svelte-h":!0}),p(eo)!=="svelte-1s3c06i"&&(eo.innerHTML=mr),Pn.forEach(d),Da=a(N),E=l(N,"DIV",{class:!0});var ee=M(E);m(Wt.$$.fragment,ee),Wa=a(ee),to=l(ee,"P",{"data-svelte-h":!0}),p(to)!=="svelte-e03q3e"&&(to.innerHTML=ur),Ga=a(ee),m(xe.$$.fragment,ee),Ba=a(ee),m(Me.$$.fragment,ee),ee.forEach(d),Fa=a(N),Ce=l(N,"DIV",{class:!0});var Dn=M(Ce);m(Gt.$$.fragment,Dn),La=a(Dn),no=l(Dn,"P",{"data-svelte-h":!0}),p(no)!=="svelte-1vfte1e"&&(no.innerHTML=gr),Dn.forEach(d),Ea=a(N),S=l(N,"DIV",{class:!0});var B=M(S);m(Bt.$$.fragment,B),Va=a(B),oo=l(B,"P",{"data-svelte-h":!0}),p(oo)!=="svelte-1a425ok"&&(oo.innerHTML=hr),Xa=a(B),so=l(B,"P",{"data-svelte-h":!0}),p(so)!=="svelte-11lpom8"&&(so.textContent=_r),Ra=a(B),m(Ie.$$.fragment,B),Ya=a(B),ao=l(B,"P",{"data-svelte-h":!0}),p(ao)!=="svelte-15d7mv5"&&(ao.innerHTML=br),za=a(B),m(Te.$$.fragment,B),B.forEach(d),Ha=a(N),$e=l(N,"DIV",{class:!0});var Wn=M($e);m(Ft.$$.fragment,Wn),Aa=a(Wn),io=l(Wn,"P",{"data-svelte-h":!0}),p(io)!=="svelte-psupw6"&&(io.textContent=vr),Wn.forEach(d),Qa=a(N),Je=l(N,"DIV",{class:!0});var Gn=M(Je);m(Lt.$$.fragment,Gn),qa=a(Gn),lo=l(Gn,"P",{"data-svelte-h":!0}),p(lo)!=="svelte-pkn4ui"&&(lo.innerHTML=yr),Gn.forEach(d),Oa=a(N),V=l(N,"DIV",{class:!0});var te=M(V);m(Et.$$.fragment,te),Ka=a(te),ro=l(te,"P",{"data-svelte-h":!0}),p(ro)!=="svelte-1f3tmq1"&&(ro.innerHTML=wr),ei=a(te),co=l(te,"P",{"data-svelte-h":!0}),p(co)!=="svelte-xjijlp"&&(co.textContent=xr),ti=a(te),po=l(te,"P",{"data-svelte-h":!0}),p(po)!=="svelte-hy0nzs"&&(po.innerHTML=Mr),te.forEach(d),ni=a(N),je=l(N,"DIV",{class:!0});var Bn=M(je);m(Vt.$$.fragment,Bn),oi=a(Bn),fo=l(Bn,"P",{"data-svelte-h":!0}),p(fo)!=="svelte-1xwrf7t"&&(fo.textContent=Cr),Bn.forEach(d),si=a(N),Ne=l(N,"DIV",{class:!0});var Fn=M(Ne);m(Xt.$$.fragment,Fn),ai=a(Fn),mo=l(Fn,"P",{"data-svelte-h":!0}),p(mo)!=="svelte-16q0ax1"&&(mo.textContent=Ir),Fn.forEach(d),ii=a(N),Ue=l(N,"DIV",{class:!0});var Ln=M(Ue);m(Rt.$$.fragment,Ln),li=a(Ln),uo=l(Ln,"P",{"data-svelte-h":!0}),p(uo)!=="svelte-vo59ec"&&(uo.innerHTML=Tr),Ln.forEach(d),N.forEach(d),Bs=a(t),le=l(t,"H2",{class:!0});var En=M(le);ke=l(En,"A",{id:!0,class:!0,href:!0});var Js=M(ke);vs=l(Js,"SPAN",{});var js=M(vs);m(Yt.$$.fragment,js),js.forEach(d),Js.forEach(d),ri=a(En),go=l(En,"SPAN",{"data-svelte-h":!0}),p(go)!=="svelte-fetb27"&&(go.textContent=$r),En.forEach(d),Fs=a(t),j=l(t,"DIV",{class:!0});var k=M(j);m(zt.$$.fragment,k),di=a(k),ho=l(k,"P",{"data-svelte-h":!0}),p(ho)!=="svelte-pzsf3g"&&(ho.textContent=Jr),ci=a(k),_o=l(k,"P",{"data-svelte-h":!0}),p(_o)!=="svelte-s6xyvg"&&(_o.innerHTML=jr),pi=a(k),bo=l(k,"P",{"data-svelte-h":!0}),p(bo)!=="svelte-14s6m4u"&&(bo.textContent=Nr),fi=a(k),vo=l(k,"UL",{"data-svelte-h":!0}),p(vo)!=="svelte-1kastu5"&&(vo.innerHTML=Ur),mi=a(k),oe=l(k,"DIV",{class:!0});var us=M(oe);m(Ht.$$.fragment,us),ui=a(us),yo=l(us,"P",{"data-svelte-h":!0}),p(yo)!=="svelte-50j04k"&&(yo.textContent=kr),gi=a(us),m(Ze.$$.fragment,us),us.forEach(d),hi=a(k),X=l(k,"DIV",{class:!0});var ht=M(X);m(At.$$.fragment,ht),_i=a(ht),wo=l(ht,"P",{"data-svelte-h":!0}),p(wo)!=="svelte-10jaql7"&&(wo.textContent=Zr),bi=a(ht),m(Se.$$.fragment,ht),vi=a(ht),m(Pe.$$.fragment,ht),ht.forEach(d),yi=a(k),De=l(k,"DIV",{class:!0});var Qs=M(De);m(Qt.$$.fragment,Qs),wi=a(Qs),xo=l(Qs,"P",{"data-svelte-h":!0}),p(xo)!=="svelte-1lh0nh5"&&(xo.innerHTML=Sr),Qs.forEach(d),xi=a(k),We=l(k,"DIV",{class:!0});var qs=M(We);m(qt.$$.fragment,qs),Mi=a(qs),Mo=l(qs,"P",{"data-svelte-h":!0}),p(Mo)!=="svelte-14bnrb6"&&(Mo.textContent=Pr),qs.forEach(d),Ci=a(k),Ge=l(k,"DIV",{class:!0});var Os=M(Ge);m(Ot.$$.fragment,Os),Ii=a(Os),Co=l(Os,"P",{"data-svelte-h":!0}),p(Co)!=="svelte-1s3c06i"&&(Co.innerHTML=Dr),Os.forEach(d),Ti=a(k),R=l(k,"DIV",{class:!0});var _t=M(R);m(Kt.$$.fragment,_t),$i=a(_t),Io=l(_t,"P",{"data-svelte-h":!0}),p(Io)!=="svelte-e03q3e"&&(Io.innerHTML=Wr),Ji=a(_t),m(Be.$$.fragment,_t),ji=a(_t),m(Fe.$$.fragment,_t),_t.forEach(d),Ni=a(k),Le=l(k,"DIV",{class:!0});var Ks=M(Le);m(en.$$.fragment,Ks),Ui=a(Ks),To=l(Ks,"P",{"data-svelte-h":!0}),p(To)!=="svelte-1vfte1e"&&(To.innerHTML=Gr),Ks.forEach(d),ki=a(k),P=l(k,"DIV",{class:!0});var Q=M(P);m(tn.$$.fragment,Q),Zi=a(Q),$o=l(Q,"P",{"data-svelte-h":!0}),p($o)!=="svelte-1a425ok"&&($o.innerHTML=Br),Si=a(Q),Jo=l(Q,"P",{"data-svelte-h":!0}),p(Jo)!=="svelte-11lpom8"&&(Jo.textContent=Fr),Pi=a(Q),m(Ee.$$.fragment,Q),Di=a(Q),jo=l(Q,"P",{"data-svelte-h":!0}),p(jo)!=="svelte-15d7mv5"&&(jo.innerHTML=Lr),Wi=a(Q),m(Ve.$$.fragment,Q),Q.forEach(d),Gi=a(k),Xe=l(k,"DIV",{class:!0});var ea=M(Xe);m(nn.$$.fragment,ea),Bi=a(ea),No=l(ea,"P",{"data-svelte-h":!0}),p(No)!=="svelte-psupw6"&&(No.textContent=Er),ea.forEach(d),Fi=a(k),Re=l(k,"DIV",{class:!0});var ta=M(Re);m(on.$$.fragment,ta),Li=a(ta),Uo=l(ta,"P",{"data-svelte-h":!0}),p(Uo)!=="svelte-pkn4ui"&&(Uo.innerHTML=Vr),ta.forEach(d),Ei=a(k),Y=l(k,"DIV",{class:!0});var bt=M(Y);m(sn.$$.fragment,bt),Vi=a(bt),ko=l(bt,"P",{"data-svelte-h":!0}),p(ko)!=="svelte-1f3tmq1"&&(ko.innerHTML=Xr),Xi=a(bt),Zo=l(bt,"P",{"data-svelte-h":!0}),p(Zo)!=="svelte-xjijlp"&&(Zo.textContent=Rr),Ri=a(bt),So=l(bt,"P",{"data-svelte-h":!0}),p(So)!=="svelte-hy0nzs"&&(So.innerHTML=Yr),bt.forEach(d),Yi=a(k),Ye=l(k,"DIV",{class:!0});var na=M(Ye);m(an.$$.fragment,na),zi=a(na),Po=l(na,"P",{"data-svelte-h":!0}),p(Po)!=="svelte-1xwrf7t"&&(Po.textContent=zr),na.forEach(d),Hi=a(k),ze=l(k,"DIV",{class:!0});var oa=M(ze);m(ln.$$.fragment,oa),Ai=a(oa),Do=l(oa,"P",{"data-svelte-h":!0}),p(Do)!=="svelte-16q0ax1"&&(Do.textContent=Hr),oa.forEach(d),k.forEach(d),Ls=a(t),re=l(t,"H2",{class:!0});var sa=M(re);He=l(sa,"A",{id:!0,class:!0,href:!0});var Td=M(He);ys=l(Td,"SPAN",{});var $d=M(ys);m(rn.$$.fragment,$d),$d.forEach(d),Td.forEach(d),Qi=a(sa),Wo=l(sa,"SPAN",{"data-svelte-h":!0}),p(Wo)!=="svelte-irjf56"&&(Wo.textContent=Ar),sa.forEach(d),Es=a(t),J=l(t,"DIV",{class:!0});var U=M(J);m(dn.$$.fragment,U),qi=a(U),Go=l(U,"P",{"data-svelte-h":!0}),p(Go)!=="svelte-l9ypsb"&&(Go.textContent=Qr),Oi=a(U),Bo=l(U,"P",{"data-svelte-h":!0}),p(Bo)!=="svelte-s6xyvg"&&(Bo.innerHTML=qr),Ki=a(U),Fo=l(U,"P",{"data-svelte-h":!0}),p(Fo)!=="svelte-14s6m4u"&&(Fo.textContent=Or),el=a(U),Lo=l(U,"UL",{"data-svelte-h":!0}),p(Lo)!=="svelte-1kastu5"&&(Lo.innerHTML=Kr),tl=a(U),m(Ae.$$.fragment,U),nl=a(U),se=l(U,"DIV",{class:!0});var gs=M(se);m(cn.$$.fragment,gs),ol=a(gs),Eo=l(gs,"P",{"data-svelte-h":!0}),p(Eo)!=="svelte-50j04k"&&(Eo.textContent=ed),sl=a(gs),m(Qe.$$.fragment,gs),gs.forEach(d),al=a(U),z=l(U,"DIV",{class:!0});var vt=M(z);m(pn.$$.fragment,vt),il=a(vt),Vo=l(vt,"P",{"data-svelte-h":!0}),p(Vo)!=="svelte-10jaql7"&&(Vo.textContent=td),ll=a(vt),m(qe.$$.fragment,vt),rl=a(vt),m(Oe.$$.fragment,vt),vt.forEach(d),dl=a(U),Ke=l(U,"DIV",{class:!0});var aa=M(Ke);m(fn.$$.fragment,aa),cl=a(aa),Xo=l(aa,"P",{"data-svelte-h":!0}),p(Xo)!=="svelte-1lh0nh5"&&(Xo.innerHTML=nd),aa.forEach(d),pl=a(U),et=l(U,"DIV",{class:!0});var ia=M(et);m(mn.$$.fragment,ia),fl=a(ia),Ro=l(ia,"P",{"data-svelte-h":!0}),p(Ro)!=="svelte-14bnrb6"&&(Ro.textContent=od),ia.forEach(d),ml=a(U),tt=l(U,"DIV",{class:!0});var la=M(tt);m(un.$$.fragment,la),ul=a(la),Yo=l(la,"P",{"data-svelte-h":!0}),p(Yo)!=="svelte-1s3c06i"&&(Yo.innerHTML=sd),la.forEach(d),gl=a(U),H=l(U,"DIV",{class:!0});var yt=M(H);m(gn.$$.fragment,yt),hl=a(yt),zo=l(yt,"P",{"data-svelte-h":!0}),p(zo)!=="svelte-e03q3e"&&(zo.innerHTML=ad),_l=a(yt),m(nt.$$.fragment,yt),bl=a(yt),m(ot.$$.fragment,yt),yt.forEach(d),vl=a(U),st=l(U,"DIV",{class:!0});var ra=M(st);m(hn.$$.fragment,ra),yl=a(ra),Ho=l(ra,"P",{"data-svelte-h":!0}),p(Ho)!=="svelte-1vfte1e"&&(Ho.innerHTML=id),ra.forEach(d),wl=a(U),D=l(U,"DIV",{class:!0});var q=M(D);m(_n.$$.fragment,q),xl=a(q),Ao=l(q,"P",{"data-svelte-h":!0}),p(Ao)!=="svelte-1a425ok"&&(Ao.innerHTML=ld),Ml=a(q),Qo=l(q,"P",{"data-svelte-h":!0}),p(Qo)!=="svelte-11lpom8"&&(Qo.textContent=rd),Cl=a(q),m(at.$$.fragment,q),Il=a(q),qo=l(q,"P",{"data-svelte-h":!0}),p(qo)!=="svelte-15d7mv5"&&(qo.innerHTML=dd),Tl=a(q),m(it.$$.fragment,q),q.forEach(d),$l=a(U),lt=l(U,"DIV",{class:!0});var da=M(lt);m(bn.$$.fragment,da),Jl=a(da),Oo=l(da,"P",{"data-svelte-h":!0}),p(Oo)!=="svelte-psupw6"&&(Oo.textContent=cd),da.forEach(d),jl=a(U),rt=l(U,"DIV",{class:!0});var ca=M(rt);m(vn.$$.fragment,ca),Nl=a(ca),Ko=l(ca,"P",{"data-svelte-h":!0}),p(Ko)!=="svelte-pkn4ui"&&(Ko.innerHTML=pd),ca.forEach(d),Ul=a(U),A=l(U,"DIV",{class:!0});var wt=M(A);m(yn.$$.fragment,wt),kl=a(wt),es=l(wt,"P",{"data-svelte-h":!0}),p(es)!=="svelte-1f3tmq1"&&(es.innerHTML=fd),Zl=a(wt),ts=l(wt,"P",{"data-svelte-h":!0}),p(ts)!=="svelte-xjijlp"&&(ts.textContent=md),Sl=a(wt),ns=l(wt,"P",{"data-svelte-h":!0}),p(ns)!=="svelte-hy0nzs"&&(ns.innerHTML=ud),wt.forEach(d),Pl=a(U),dt=l(U,"DIV",{class:!0});var pa=M(dt);m(wn.$$.fragment,pa),Dl=a(pa),os=l(pa,"P",{"data-svelte-h":!0}),p(os)!=="svelte-1xwrf7t"&&(os.textContent=gd),pa.forEach(d),Wl=a(U),ct=l(U,"DIV",{class:!0});var fa=M(ct);m(xn.$$.fragment,fa),Gl=a(fa),ss=l(fa,"P",{"data-svelte-h":!0}),p(ss)!=="svelte-16q0ax1"&&(ss.textContent=hd),fa.forEach(d),U.forEach(d),Vs=a(t),de=l(t,"H2",{class:!0});var ma=M(de);pt=l(ma,"A",{id:!0,class:!0,href:!0});var Jd=M(pt);ws=l(Jd,"SPAN",{});var jd=M(ws);m(Mn.$$.fragment,jd),jd.forEach(d),Jd.forEach(d),Bl=a(ma),as=l(ma,"SPAN",{"data-svelte-h":!0}),p(as)!=="svelte-1ocdz42"&&(as.textContent=_d),ma.forEach(d),Xs=a(t),ce=l(t,"DIV",{class:!0});var ua=M(ce);m(Cn.$$.fragment,ua),Fl=a(ua),is=l(ua,"P",{"data-svelte-h":!0}),p(is)!=="svelte-1qpjiuf"&&(is.textContent=bd),ua.forEach(d),Rs=a(t),pe=l(t,"H2",{class:!0});var ga=M(pe);ft=l(ga,"A",{id:!0,class:!0,href:!0});var Nd=M(ft);xs=l(Nd,"SPAN",{});var Ud=M(xs);m(In.$$.fragment,Ud),Ud.forEach(d),Nd.forEach(d),Ll=a(ga),ls=l(ga,"SPAN",{"data-svelte-h":!0}),p(ls)!=="svelte-9uxary"&&(ls.textContent=vd),ga.forEach(d),Ys=a(t),F=l(t,"DIV",{class:!0});var xt=M(F);m(Tn.$$.fragment,xt),El=a(xt),rs=l(xt,"P",{"data-svelte-h":!0}),p(rs)!=="svelte-11a4l7z"&&(rs.textContent=yd),Vl=a(xt),ds=l(xt,"P",{"data-svelte-h":!0}),p(ds)!=="svelte-egv27w"&&(ds.innerHTML=wd),Xl=a(xt),ae=l(xt,"DIV",{class:!0});var hs=M(ae);m($n.$$.fragment,hs),Rl=a(hs),cs=l(hs,"P",{"data-svelte-h":!0}),p(cs)!=="svelte-50j04k"&&(cs.textContent=xd),Yl=a(hs),m(mt.$$.fragment,hs),hs.forEach(d),xt.forEach(d),zs=a(t),fe=l(t,"H2",{class:!0});var ha=M(fe);ut=l(ha,"A",{id:!0,class:!0,href:!0});var kd=M(ut);Ms=l(kd,"SPAN",{});var Zd=M(Ms);m(Jn.$$.fragment,Zd),Zd.forEach(d),kd.forEach(d),zl=a(ha),ps=l(ha,"SPAN",{"data-svelte-h":!0}),p(ps)!=="svelte-e1rlff"&&(ps.textContent=Md),ha.forEach(d),Hs=a(t),O=l(t,"DIV",{class:!0});var _s=M(O);m(jn.$$.fragment,_s),Hl=a(_s),fs=l(_s,"P",{"data-svelte-h":!0}),p(fs)!=="svelte-wzv2jc"&&(fs.textContent=Cd),Al=a(_s),gt=l(_s,"DIV",{class:!0});var _a=M(gt);m(Nn.$$.fragment,_a),Ql=a(_a),ms=l(_a,"P",{"data-svelte-h":!0}),p(ms)!=="svelte-5ihtpa"&&(ms.textContent=Id),_a.forEach(d),_s.forEach(d),this.h()},h(){w(o,"name","hf:doc:metadata"),w(o,"content",JSON.stringify(cc)),w(r,"id","controlnet"),w(r,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(r,"href","#controlnet"),w(c,"class","relative group"),w(ge,"id","diffusers.StableDiffusionControlNetPipeline"),w(ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(ge,"href","#diffusers.StableDiffusionControlNetPipeline"),w(ie,"class","relative group"),w(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ke,"id","diffusers.StableDiffusionControlNetImg2ImgPipeline"),w(ke,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(ke,"href","#diffusers.StableDiffusionControlNetImg2ImgPipeline"),w(le,"class","relative group"),w(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(He,"id","diffusers.StableDiffusionControlNetInpaintPipeline"),w(He,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(He,"href","#diffusers.StableDiffusionControlNetInpaintPipeline"),w(re,"class","relative group"),w(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(pt,"id","diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),w(pt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(pt,"href","#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),w(de,"class","relative group"),w(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ft,"id","diffusers.FlaxStableDiffusionControlNetPipeline"),w(ft,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(ft,"href","#diffusers.FlaxStableDiffusionControlNetPipeline"),w(pe,"class","relative group"),w(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ut,"id","diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"),w(ut,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(ut,"href","#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"),w(fe,"class","relative group"),w(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,b){e(document.head,o),y(t,x,b),y(t,c,b),e(c,r),e(r,v),u(n,v,null),e(c,C),e(c,Xn),y(t,Ns,b),y(t,Ct,b),y(t,Us,b),y(t,It,b),y(t,ks,b),y(t,Tt,b),y(t,Zs,b),y(t,$t,b),y(t,Ss,b),y(t,Jt,b),y(t,Ps,b),y(t,jt,b),y(t,Ds,b),u(ue,t,b),y(t,Ws,b),y(t,ie,b),e(ie,ge),e(ge,bs),u(Nt,bs,null),e(ie,ba),e(ie,Rn),y(t,Gs,b),y(t,$,b),u(Ut,$,null),e($,va),e($,Yn),e($,ya),e($,zn),e($,wa),e($,Hn),e($,xa),e($,An),e($,Ma),e($,ne),u(kt,ne,null),e(ne,Ca),e(ne,Qn),e(ne,Ia),u(he,ne,null),e($,Ta),e($,L),u(Zt,L,null),e(L,$a),e(L,qn),e(L,Ja),u(_e,L,null),e(L,ja),u(be,L,null),e($,Na),e($,ve),u(St,ve,null),e(ve,Ua),e(ve,On),e($,ka),e($,ye),u(Pt,ye,null),e(ye,Za),e(ye,Kn),e($,Sa),e($,we),u(Dt,we,null),e(we,Pa),e(we,eo),e($,Da),e($,E),u(Wt,E,null),e(E,Wa),e(E,to),e(E,Ga),u(xe,E,null),e(E,Ba),u(Me,E,null),e($,Fa),e($,Ce),u(Gt,Ce,null),e(Ce,La),e(Ce,no),e($,Ea),e($,S),u(Bt,S,null),e(S,Va),e(S,oo),e(S,Xa),e(S,so),e(S,Ra),u(Ie,S,null),e(S,Ya),e(S,ao),e(S,za),u(Te,S,null),e($,Ha),e($,$e),u(Ft,$e,null),e($e,Aa),e($e,io),e($,Qa),e($,Je),u(Lt,Je,null),e(Je,qa),e(Je,lo),e($,Oa),e($,V),u(Et,V,null),e(V,Ka),e(V,ro),e(V,ei),e(V,co),e(V,ti),e(V,po),e($,ni),e($,je),u(Vt,je,null),e(je,oi),e(je,fo),e($,si),e($,Ne),u(Xt,Ne,null),e(Ne,ai),e(Ne,mo),e($,ii),e($,Ue),u(Rt,Ue,null),e(Ue,li),e(Ue,uo),y(t,Bs,b),y(t,le,b),e(le,ke),e(ke,vs),u(Yt,vs,null),e(le,ri),e(le,go),y(t,Fs,b),y(t,j,b),u(zt,j,null),e(j,di),e(j,ho),e(j,ci),e(j,_o),e(j,pi),e(j,bo),e(j,fi),e(j,vo),e(j,mi),e(j,oe),u(Ht,oe,null),e(oe,ui),e(oe,yo),e(oe,gi),u(Ze,oe,null),e(j,hi),e(j,X),u(At,X,null),e(X,_i),e(X,wo),e(X,bi),u(Se,X,null),e(X,vi),u(Pe,X,null),e(j,yi),e(j,De),u(Qt,De,null),e(De,wi),e(De,xo),e(j,xi),e(j,We),u(qt,We,null),e(We,Mi),e(We,Mo),e(j,Ci),e(j,Ge),u(Ot,Ge,null),e(Ge,Ii),e(Ge,Co),e(j,Ti),e(j,R),u(Kt,R,null),e(R,$i),e(R,Io),e(R,Ji),u(Be,R,null),e(R,ji),u(Fe,R,null),e(j,Ni),e(j,Le),u(en,Le,null),e(Le,Ui),e(Le,To),e(j,ki),e(j,P),u(tn,P,null),e(P,Zi),e(P,$o),e(P,Si),e(P,Jo),e(P,Pi),u(Ee,P,null),e(P,Di),e(P,jo),e(P,Wi),u(Ve,P,null),e(j,Gi),e(j,Xe),u(nn,Xe,null),e(Xe,Bi),e(Xe,No),e(j,Fi),e(j,Re),u(on,Re,null),e(Re,Li),e(Re,Uo),e(j,Ei),e(j,Y),u(sn,Y,null),e(Y,Vi),e(Y,ko),e(Y,Xi),e(Y,Zo),e(Y,Ri),e(Y,So),e(j,Yi),e(j,Ye),u(an,Ye,null),e(Ye,zi),e(Ye,Po),e(j,Hi),e(j,ze),u(ln,ze,null),e(ze,Ai),e(ze,Do),y(t,Ls,b),y(t,re,b),e(re,He),e(He,ys),u(rn,ys,null),e(re,Qi),e(re,Wo),y(t,Es,b),y(t,J,b),u(dn,J,null),e(J,qi),e(J,Go),e(J,Oi),e(J,Bo),e(J,Ki),e(J,Fo),e(J,el),e(J,Lo),e(J,tl),u(Ae,J,null),e(J,nl),e(J,se),u(cn,se,null),e(se,ol),e(se,Eo),e(se,sl),u(Qe,se,null),e(J,al),e(J,z),u(pn,z,null),e(z,il),e(z,Vo),e(z,ll),u(qe,z,null),e(z,rl),u(Oe,z,null),e(J,dl),e(J,Ke),u(fn,Ke,null),e(Ke,cl),e(Ke,Xo),e(J,pl),e(J,et),u(mn,et,null),e(et,fl),e(et,Ro),e(J,ml),e(J,tt),u(un,tt,null),e(tt,ul),e(tt,Yo),e(J,gl),e(J,H),u(gn,H,null),e(H,hl),e(H,zo),e(H,_l),u(nt,H,null),e(H,bl),u(ot,H,null),e(J,vl),e(J,st),u(hn,st,null),e(st,yl),e(st,Ho),e(J,wl),e(J,D),u(_n,D,null),e(D,xl),e(D,Ao),e(D,Ml),e(D,Qo),e(D,Cl),u(at,D,null),e(D,Il),e(D,qo),e(D,Tl),u(it,D,null),e(J,$l),e(J,lt),u(bn,lt,null),e(lt,Jl),e(lt,Oo),e(J,jl),e(J,rt),u(vn,rt,null),e(rt,Nl),e(rt,Ko),e(J,Ul),e(J,A),u(yn,A,null),e(A,kl),e(A,es),e(A,Zl),e(A,ts),e(A,Sl),e(A,ns),e(J,Pl),e(J,dt),u(wn,dt,null),e(dt,Dl),e(dt,os),e(J,Wl),e(J,ct),u(xn,ct,null),e(ct,Gl),e(ct,ss),y(t,Vs,b),y(t,de,b),e(de,pt),e(pt,ws),u(Mn,ws,null),e(de,Bl),e(de,as),y(t,Xs,b),y(t,ce,b),u(Cn,ce,null),e(ce,Fl),e(ce,is),y(t,Rs,b),y(t,pe,b),e(pe,ft),e(ft,xs),u(In,xs,null),e(pe,Ll),e(pe,ls),y(t,Ys,b),y(t,F,b),u(Tn,F,null),e(F,El),e(F,rs),e(F,Vl),e(F,ds),e(F,Xl),e(F,ae),u($n,ae,null),e(ae,Rl),e(ae,cs),e(ae,Yl),u(mt,ae,null),y(t,zs,b),y(t,fe,b),e(fe,ut),e(ut,Ms),u(Jn,Ms,null),e(fe,zl),e(fe,ps),y(t,Hs,b),y(t,O,b),u(jn,O,null),e(O,Hl),e(O,fs),e(O,Al),e(O,gt),u(Nn,gt,null),e(gt,Ql),e(gt,ms),As=!0},p(t,[b]){const Un={};b&2&&(Un.$$scope={dirty:b,ctx:t}),ue.$set(Un);const Cs={};b&2&&(Cs.$$scope={dirty:b,ctx:t}),he.$set(Cs);const Is={};b&2&&(Is.$$scope={dirty:b,ctx:t}),_e.$set(Is);const kn={};b&2&&(kn.$$scope={dirty:b,ctx:t}),be.$set(kn);const Ts={};b&2&&(Ts.$$scope={dirty:b,ctx:t}),xe.$set(Ts);const $s={};b&2&&($s.$$scope={dirty:b,ctx:t}),Me.$set($s);const N={};b&2&&(N.$$scope={dirty:b,ctx:t}),Ie.$set(N);const me={};b&2&&(me.$$scope={dirty:b,ctx:t}),Te.$set(me);const K={};b&2&&(K.$$scope={dirty:b,ctx:t}),Ze.$set(K);const Zn={};b&2&&(Zn.$$scope={dirty:b,ctx:t}),Se.$set(Zn);const Sn={};b&2&&(Sn.$$scope={dirty:b,ctx:t}),Pe.$set(Sn);const Pn={};b&2&&(Pn.$$scope={dirty:b,ctx:t}),Be.$set(Pn);const ee={};b&2&&(ee.$$scope={dirty:b,ctx:t}),Fe.$set(ee);const Dn={};b&2&&(Dn.$$scope={dirty:b,ctx:t}),Ee.$set(Dn);const B={};b&2&&(B.$$scope={dirty:b,ctx:t}),Ve.$set(B);const Wn={};b&2&&(Wn.$$scope={dirty:b,ctx:t}),Ae.$set(Wn);const Gn={};b&2&&(Gn.$$scope={dirty:b,ctx:t}),Qe.$set(Gn);const te={};b&2&&(te.$$scope={dirty:b,ctx:t}),qe.$set(te);const Bn={};b&2&&(Bn.$$scope={dirty:b,ctx:t}),Oe.$set(Bn);const Fn={};b&2&&(Fn.$$scope={dirty:b,ctx:t}),nt.$set(Fn);const Ln={};b&2&&(Ln.$$scope={dirty:b,ctx:t}),ot.$set(Ln);const En={};b&2&&(En.$$scope={dirty:b,ctx:t}),at.$set(En);const Js={};b&2&&(Js.$$scope={dirty:b,ctx:t}),it.$set(Js);const js={};b&2&&(js.$$scope={dirty:b,ctx:t}),mt.$set(js)},i(t){As||(g(n.$$.fragment,t),g(ue.$$.fragment,t),g(Nt.$$.fragment,t),g(Ut.$$.fragment,t),g(kt.$$.fragment,t),g(he.$$.fragment,t),g(Zt.$$.fragment,t),g(_e.$$.fragment,t),g(be.$$.fragment,t),g(St.$$.fragment,t),g(Pt.$$.fragment,t),g(Dt.$$.fragment,t),g(Wt.$$.fragment,t),g(xe.$$.fragment,t),g(Me.$$.fragment,t),g(Gt.$$.fragment,t),g(Bt.$$.fragment,t),g(Ie.$$.fragment,t),g(Te.$$.fragment,t),g(Ft.$$.fragment,t),g(Lt.$$.fragment,t),g(Et.$$.fragment,t),g(Vt.$$.fragment,t),g(Xt.$$.fragment,t),g(Rt.$$.fragment,t),g(Yt.$$.fragment,t),g(zt.$$.fragment,t),g(Ht.$$.fragment,t),g(Ze.$$.fragment,t),g(At.$$.fragment,t),g(Se.$$.fragment,t),g(Pe.$$.fragment,t),g(Qt.$$.fragment,t),g(qt.$$.fragment,t),g(Ot.$$.fragment,t),g(Kt.$$.fragment,t),g(Be.$$.fragment,t),g(Fe.$$.fragment,t),g(en.$$.fragment,t),g(tn.$$.fragment,t),g(Ee.$$.fragment,t),g(Ve.$$.fragment,t),g(nn.$$.fragment,t),g(on.$$.fragment,t),g(sn.$$.fragment,t),g(an.$$.fragment,t),g(ln.$$.fragment,t),g(rn.$$.fragment,t),g(dn.$$.fragment,t),g(Ae.$$.fragment,t),g(cn.$$.fragment,t),g(Qe.$$.fragment,t),g(pn.$$.fragment,t),g(qe.$$.fragment,t),g(Oe.$$.fragment,t),g(fn.$$.fragment,t),g(mn.$$.fragment,t),g(un.$$.fragment,t),g(gn.$$.fragment,t),g(nt.$$.fragment,t),g(ot.$$.fragment,t),g(hn.$$.fragment,t),g(_n.$$.fragment,t),g(at.$$.fragment,t),g(it.$$.fragment,t),g(bn.$$.fragment,t),g(vn.$$.fragment,t),g(yn.$$.fragment,t),g(wn.$$.fragment,t),g(xn.$$.fragment,t),g(Mn.$$.fragment,t),g(Cn.$$.fragment,t),g(In.$$.fragment,t),g(Tn.$$.fragment,t),g($n.$$.fragment,t),g(mt.$$.fragment,t),g(Jn.$$.fragment,t),g(jn.$$.fragment,t),g(Nn.$$.fragment,t),As=!0)},o(t){h(n.$$.fragment,t),h(ue.$$.fragment,t),h(Nt.$$.fragment,t),h(Ut.$$.fragment,t),h(kt.$$.fragment,t),h(he.$$.fragment,t),h(Zt.$$.fragment,t),h(_e.$$.fragment,t),h(be.$$.fragment,t),h(St.$$.fragment,t),h(Pt.$$.fragment,t),h(Dt.$$.fragment,t),h(Wt.$$.fragment,t),h(xe.$$.fragment,t),h(Me.$$.fragment,t),h(Gt.$$.fragment,t),h(Bt.$$.fragment,t),h(Ie.$$.fragment,t),h(Te.$$.fragment,t),h(Ft.$$.fragment,t),h(Lt.$$.fragment,t),h(Et.$$.fragment,t),h(Vt.$$.fragment,t),h(Xt.$$.fragment,t),h(Rt.$$.fragment,t),h(Yt.$$.fragment,t),h(zt.$$.fragment,t),h(Ht.$$.fragment,t),h(Ze.$$.fragment,t),h(At.$$.fragment,t),h(Se.$$.fragment,t),h(Pe.$$.fragment,t),h(Qt.$$.fragment,t),h(qt.$$.fragment,t),h(Ot.$$.fragment,t),h(Kt.$$.fragment,t),h(Be.$$.fragment,t),h(Fe.$$.fragment,t),h(en.$$.fragment,t),h(tn.$$.fragment,t),h(Ee.$$.fragment,t),h(Ve.$$.fragment,t),h(nn.$$.fragment,t),h(on.$$.fragment,t),h(sn.$$.fragment,t),h(an.$$.fragment,t),h(ln.$$.fragment,t),h(rn.$$.fragment,t),h(dn.$$.fragment,t),h(Ae.$$.fragment,t),h(cn.$$.fragment,t),h(Qe.$$.fragment,t),h(pn.$$.fragment,t),h(qe.$$.fragment,t),h(Oe.$$.fragment,t),h(fn.$$.fragment,t),h(mn.$$.fragment,t),h(un.$$.fragment,t),h(gn.$$.fragment,t),h(nt.$$.fragment,t),h(ot.$$.fragment,t),h(hn.$$.fragment,t),h(_n.$$.fragment,t),h(at.$$.fragment,t),h(it.$$.fragment,t),h(bn.$$.fragment,t),h(vn.$$.fragment,t),h(yn.$$.fragment,t),h(wn.$$.fragment,t),h(xn.$$.fragment,t),h(Mn.$$.fragment,t),h(Cn.$$.fragment,t),h(In.$$.fragment,t),h(Tn.$$.fragment,t),h($n.$$.fragment,t),h(mt.$$.fragment,t),h(Jn.$$.fragment,t),h(jn.$$.fragment,t),h(Nn.$$.fragment,t),As=!1},d(t){t&&(d(x),d(c),d(Ns),d(Ct),d(Us),d(It),d(ks),d(Tt),d(Zs),d($t),d(Ss),d(Jt),d(Ps),d(jt),d(Ds),d(Ws),d(ie),d(Gs),d($),d(Bs),d(le),d(Fs),d(j),d(Ls),d(re),d(Es),d(J),d(Vs),d(de),d(Xs),d(ce),d(Rs),d(pe),d(Ys),d(F),d(zs),d(fe),d(Hs),d(O)),d(o),_(n),_(ue,t),_(Nt),_(Ut),_(kt),_(he),_(Zt),_(_e),_(be),_(St),_(Pt),_(Dt),_(Wt),_(xe),_(Me),_(Gt),_(Bt),_(Ie),_(Te),_(Ft),_(Lt),_(Et),_(Vt),_(Xt),_(Rt),_(Yt),_(zt),_(Ht),_(Ze),_(At),_(Se),_(Pe),_(Qt),_(qt),_(Ot),_(Kt),_(Be),_(Fe),_(en),_(tn),_(Ee),_(Ve),_(nn),_(on),_(sn),_(an),_(ln),_(rn),_(dn),_(Ae),_(cn),_(Qe),_(pn),_(qe),_(Oe),_(fn),_(mn),_(un),_(gn),_(nt),_(ot),_(hn),_(_n),_(at),_(it),_(bn),_(vn),_(yn),_(wn),_(xn),_(Mn),_(Cn),_(In),_(Tn),_($n),_(mt),_(Jn),_(jn),_(Nn)}}}const cc={local:"controlnet",sections:[{local:"diffusers.StableDiffusionControlNetPipeline",title:"StableDiffusionControlNetPipeline"},{local:"diffusers.StableDiffusionControlNetImg2ImgPipeline",title:"StableDiffusionControlNetImg2ImgPipeline"},{local:"diffusers.StableDiffusionControlNetInpaintPipeline",title:"StableDiffusionControlNetInpaintPipeline"},{local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",title:"StableDiffusionPipelineOutput"},{local:"diffusers.FlaxStableDiffusionControlNetPipeline",title:"FlaxStableDiffusionControlNetPipeline"},{local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",title:"FlaxStableDiffusionControlNetPipelineOutput"}],title:"ControlNet"};function pc(I){return Pd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vc extends Dd{constructor(o){super(),Wd(this,o,pc,dc,Sd,{})}}export{vc as component};
